/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.cfg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.analysis.cfg.CFGEdge;

public abstract class CFGNode {
    private static int fgNextID = 0;
    public final int fID = fgNextID++;
    public final List<CFGEdge> fOutgoingEdges = new ArrayList<CFGEdge>();
    public final List<CFGEdge> fIncomingEdges = new ArrayList<CFGEdge>();

    public void addIncomingEdge(CFGEdge e) {
        this.fIncomingEdges.add(e);
    }

    public CFGEdge getIncomingEdge(int idx) {
        return this.fIncomingEdges.get(idx);
    }

    public void addOutgoingEdge(CFGEdge e) {
        this.fOutgoingEdges.add(e);
    }

    public CFGEdge getOutgoingEdge(int idx) {
        return this.fOutgoingEdges.get(idx);
    }

    public abstract boolean isStartNode();

    public abstract boolean isEndNode();

    public String getShortName() {
        return "n" + Integer.toString(this.fID);
    }

    public abstract String getPrettyName();

    public String toString() {
        return this.getPrettyName();
    }

    public static void resetID() {
        fgNextID = 0;
    }
}

