/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.parser;

import lpg.runtime.IAst;
import lpg.runtime.IToken;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.box.parser.Ast.ASTNode;
import org.eclipse.imp.box.parser.Ast.AbstractVisitor;
import org.eclipse.imp.parser.ISourcePositionLocator;

public class BoxASTNodeLocator
implements ISourcePositionLocator {
    private final ASTNode[] fNode = new ASTNode[1];
    private int fStartOffset;
    private int fEndOffset;
    private NodeVisitor fVisitor = new NodeVisitor();

    public Object findNode(Object ast, int offset) {
        return this.findNode(ast, offset, offset);
    }

    public Object findNode(Object ast, int startOffset, int endOffset) {
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
        ((ASTNode)ast).accept(this.fVisitor);
        if (this.fNode[0] == null) {
            // empty if block
        }
        return this.fNode[0];
    }

    public int getStartOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getLeftIToken().getStartOffset();
        }
        if (entity instanceof IToken) {
            IToken t = (IToken)entity;
            return t.getStartOffset();
        }
        return 0;
    }

    public int getEndOffset(Object entity) {
        if (entity instanceof IAst) {
            IAst n = (IAst)entity;
            return n.getLeftIToken().getEndOffset();
        }
        if (entity instanceof IToken) {
            IToken t = (IToken)entity;
            return t.getEndOffset();
        }
        return 0;
    }

    public int getLength(Object entity) {
        return this.getEndOffset(entity) - this.getStartOffset(entity);
    }

    public IPath getPath(Object node) {
        return new Path("");
    }

    private final class NodeVisitor
    extends AbstractVisitor {
        private NodeVisitor() {
        }

        public void unimplementedVisitor(String s) {
        }

        public boolean preVisit(ASTNode element) {
            int nodeStartOffset = element.getLeftIToken().getStartOffset();
            int nodeEndOffset = element.getRightIToken().getEndOffset();
            if (nodeStartOffset <= BoxASTNodeLocator.this.fStartOffset && nodeEndOffset >= BoxASTNodeLocator.this.fEndOffset) {
                ((BoxASTNodeLocator)BoxASTNodeLocator.this).fNode[0] = element;
                return true;
            }
            return false;
        }
    }
}

