/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.builders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.box.builders.BoxException;
import org.eclipse.imp.box.parser.Ast.AbstractVisitor;
import org.eclipse.imp.box.parser.Ast.Box0;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.osgi.framework.Bundle;
import org.syntax_definition.sdf.Tools;

public class BoxFactory {
    private static String BoxParsetablePath;
    private static String BoxParsetablePathReflexive;

    public static String extractText(IBox boxAst) {
        if (boxAst != null) {
            AbstractVisitor v = new AbstractVisitor(){
                private StringBuffer buffer = new StringBuffer();

                public void unimplementedVisitor(String s) {
                }

                public boolean visit(Box0 n) {
                    String lit = n.toString();
                    this.buffer.append(this.unquote(lit));
                    this.buffer.append(' ');
                    return true;
                }

                private String unquote(String lit) {
                    if (lit.length() > 2) {
                        return lit.substring(1, lit.length() - 1).replaceAll("\\n", "\n").replaceAll("\\t", "\t");
                    }
                    return "";
                }

                public String toString() {
                    return this.buffer.toString();
                }
            };
            boxAst.accept(v);
            return v.toString();
        }
        return null;
    }

    public static String box2text(String boxString) throws BoxException {
        String sglr = "sglr -p " + BoxParsetablePath;
        String pandora = "pandora";
        try {
            InputStream input = Tools.cat((String)boxString);
            InputStream output = Tools.pipeline((String[])new String[]{sglr, pandora}, (InputStream)input);
            return Tools.uncat((InputStream)output);
        }
        catch (IOException e) {
            throw new BoxException("IOException while formatting", boxString, e);
        }
        catch (InterruptedException e) {
            throw new BoxException("Formatting was interrupted", boxString, e);
        }
    }

    public static String formatBox(String boxString) throws IOException, InterruptedException {
        String sglr = "sglr -p " + BoxParsetablePathReflexive;
        String boxFormat = "BoxFormatter";
        String pandora = "pandora";
        InputStream input = Tools.cat((String)boxString);
        InputStream output = Tools.pipeline((String[])new String[]{sglr, boxFormat, pandora}, (InputStream)input);
        return Tools.uncat((InputStream)output);
    }

    static {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.imp.box");
        URL url = bundle.getResource("resources/Box.tbl");
        URL urlReflexive = bundle.getResource("resources/Box.trm.tbl");
        try {
            BoxParsetablePath = new File(FileLocator.toFileURL((URL)url).getPath()).toString();
            BoxParsetablePathReflexive = new File(FileLocator.toFileURL((URL)urlReflexive).getPath()).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

