/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.builders.BoxException;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.formatting.spec.BoxStringBuilder;
import org.eclipse.imp.formatting.spec.Item;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.Separator;
import org.eclipse.imp.formatting.spec.SpaceOptionBinder;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class RuleTable
implements IEditorPart {
    private Table ruleTable;
    private TableEditor tableEditor;
    private final int STATUS_COLUMN = 0;
    private final int EDIT_COLUMN = 1;
    private final int PREVIEW_COLUMN = 2;
    private final int MARGIN = 2;
    private Item activeItem;
    private List<IPropertyListener> listeners = new LinkedList<IPropertyListener>();
    private Specification model;
    private boolean dirty = false;
    private IEditorSite site;
    private IEditorInput input;

    public void setModel(Specification model) {
        this.model = model;
        this.refresh();
    }

    public void addPropertyListener(IPropertyListener l) {
        this.listeners.add(l);
    }

    private void firePropertyChange(int change) {
        for (IPropertyListener l : this.listeners) {
            l.propertyChanged((Object)this, change);
        }
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public IEditorSite getEditorSite() {
        return this.site;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.site = site;
        this.input = input;
    }

    public void dispose() {
        this.ruleTable.dispose();
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public String getTitle() {
        return "Rules";
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocus() {
        this.ruleTable.setFocus();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        this.ruleTable = new Table(parent, 65536);
        this.ruleTable.setLinesVisible(true);
        this.ruleTable.setHeaderVisible(true);
        TableColumn status = new TableColumn(this.ruleTable, 2048);
        status.setText("Status");
        status.setResizable(true);
        TableColumn box = new TableColumn(this.ruleTable, 2048);
        box.setText("Box");
        box.setResizable(true);
        TableColumn preview = new TableColumn(this.ruleTable, 2048);
        preview.setText("Preview");
        preview.setResizable(true);
        status.pack();
        box.pack();
        preview.pack();
        this.createCellEditor();
        this.createCellPainter();
        this.createCellTooltip();
    }

    private void createCellEditor() {
        this.tableEditor = new TableEditor(this.ruleTable);
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.verticalAlignment = 128;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.grabVertical = true;
        this.tableEditor.minimumWidth = 50;
        this.ruleTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = RuleTable.this.tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                RuleTable.this.activeItem = (Item)item.getData();
                final Text newEditor = new Text((Composite)RuleTable.this.ruleTable, 2114);
                newEditor.setFont(item.getFont());
                newEditor.setText(item.getText(1));
                if (RuleTable.this.activeItem instanceof Rule) {
                    newEditor.addModifyListener((ModifyListener)new RuleModifier());
                } else if (RuleTable.this.activeItem instanceof Separator) {
                    newEditor.addModifyListener((ModifyListener)new SeparatorModifier());
                }
                newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        newEditor.dispose();
                    }
                });
                newEditor.setFocus();
                RuleTable.this.tableEditor.setEditor((Control)newEditor, item, 1);
            }
        });
    }

    private void disposeTableEditor() {
        Control e = this.tableEditor.getEditor();
        if (e != null) {
            e.dispose();
        }
    }

    private void createCellTooltip() {
        this.ruleTable.setToolTipText("");
        Listener tooltipListener = new Listener(){
            Shell tip = null;
            Label label = null;
            Display display = RuleTable.access$200(RuleTable.this).getDisplay();
            Shell shell = RuleTable.access$200(RuleTable.this).getShell();

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = RuleTable.this.ruleTable.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(this.shell, 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(this.display.getSystemColor(28));
                        this.label.setBackground(RuleTable.this.ruleTable.getDisplay().getSystemColor(29));
                        String text = (String)item.getData("tooltip");
                        if (text == null) break;
                        this.label.setText(text);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = RuleTable.this.ruleTable.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x + size.y, pt.y - size.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.ruleTable.addListener(1, tooltipListener);
        this.ruleTable.addListener(12, tooltipListener);
        this.ruleTable.addListener(32, tooltipListener);
        this.ruleTable.addListener(5, tooltipListener);
    }

    private void createCellPainter() {
        this.ruleTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                event.gc.setFont(item.getFont());
                Point size = event.gc.textExtent(text, 2);
                event.width = size.x + 4;
                event.height = size.y + 2;
            }
        });
        this.ruleTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.ruleTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                event.gc.setFont(item.getFont());
                event.gc.drawText(text, event.x + 2, event.y + 2, true);
            }
        });
    }

    public void addSeparator() {
        Separator s = new Separator();
        if (this.activeItem != null) {
            this.disposeTableEditor();
            int i = this.model.getRules().indexOf(this.activeItem);
            this.model.addSeparator(i, s);
            TableItem item = new TableItem(this.ruleTable, 0, i);
            this.initSeparatorTableItem(s, item);
            this.ruleTable.select(i);
            this.activeItem = s;
        } else {
            this.model.addRule(s);
            TableItem item = new TableItem(this.ruleTable, 0);
            this.initSeparatorTableItem(s, item);
            this.ruleTable.select(this.ruleTable.getChildren().length);
        }
    }

    private void initSeparatorTableItem(Separator s, TableItem item) {
        item.setData((Object)s);
        this.updateSeparatorTableItem(item, s.getLabel());
    }

    private void updateSeparatorTableItem(TableItem item, String label) {
        item.setText(1, label);
        item.setText(2, "");
        item.setText(0, "---");
        Font font = new Font((Device)this.ruleTable.getDisplay(), "Monospace", 14, 1);
        item.setFont(font);
    }

    public void refresh() {
        this.ruleTable.removeAll();
        Iterator<Item> iter = this.model.ruleIterator();
        while (iter.hasNext()) {
            Item i = iter.next();
            TableItem item = new TableItem(this.ruleTable, 0);
            if (i instanceof Rule) {
                this.initRuleTableItem((Rule)i, item, false);
                continue;
            }
            if (!(i instanceof Separator)) continue;
            this.initSeparatorTableItem((Separator)i, item);
        }
        for (TableColumn c : this.ruleTable.getColumns()) {
            c.pack();
        }
    }

    public void setDirty(boolean b) {
        if (this.dirty != b) {
            this.dirty = b;
            this.firePropertyChange(257);
        }
    }

    private void initRuleTableItem(Rule rule, TableItem item, boolean recompute) {
        item.setData((Object)rule);
        this.updateRuleTableItem(item, rule, recompute);
    }

    private void updateRuleTableItem(TableItem item, Rule rule, boolean recompute) {
        String boxString = rule.getBoxString();
        item.setText(1, boxString == null ? "\n" : boxString);
        if (boxString != null) {
            Parser parser = this.model.getParser();
            if (parser.parseBox(boxString) != null) {
                String formatted;
                if (recompute) {
                    try {
                        formatted = this.getFormattedBox(boxString);
                    }
                    catch (BoxException e) {
                        this.setItemAttribs(item, e.getMessage(), e.getBoxString());
                        return;
                    }
                    if (formatted != null && formatted.length() > 0) {
                        rule.setPatternString(formatted);
                    }
                } else {
                    formatted = rule.getPatternString();
                    if (formatted == null) {
                        formatted = "";
                    }
                }
                item.setText(2, formatted);
                Object ast = parser.parseObject(formatted);
                if (ast == null) {
                    this.setItemAttribs(item, "Syntax error in formatted output", "");
                } else {
                    rule.setPatternAst(ast);
                    this.setItemAttribs(item, "Ok", ast.getClass().getName());
                }
            } else {
                this.setItemAttribs(item, "Syntax error in box rule", "");
            }
        } else {
            this.setItemAttribs(item, "Empty box rule", "");
        }
    }

    private void setItemAttribs(TableItem item, String text, String tooltip) {
        item.setText(0, text);
        item.setData("tooltip", (Object)tooltip);
    }

    private String getFormattedBox(String boxString) throws BoxException {
        if (boxString != null && boxString.length() > 0) {
            SpaceOptionBinder binder = new SpaceOptionBinder(this.model);
            boxString = binder.bind(boxString);
            return BoxFactory.box2text((String)boxString);
        }
        return "";
    }

    public void move(int diff) {
        if (this.activeItem != null && this.activeItem instanceof Rule) {
            Rule r = (Rule)this.activeItem;
            List rules = this.model.getRules();
            int cur = rules.indexOf(this.activeItem);
            if (cur + diff >= 0) {
                this.disposeTableEditor();
                this.ruleTable.remove(cur);
                this.model.removeRule(this.activeItem);
                this.model.addRule(cur + diff, r);
                TableItem item = new TableItem(this.ruleTable, 0, cur + diff);
                this.initRuleTableItem(r, item, false);
                this.ruleTable.select(cur + diff);
                this.setDirty(true);
            }
        }
    }

    public void deleteRule() {
        if (this.activeItem != null) {
            this.disposeTableEditor();
            int i = this.model.getRules().indexOf(this.activeItem);
            this.ruleTable.deselectAll();
            this.ruleTable.remove(i);
            this.model.removeRule(i);
            this.setDirty(true);
        }
    }

    public void newRule() {
        Rule r = new Rule();
        if (this.activeItem != null) {
            this.disposeTableEditor();
            int i = this.model.getRules().indexOf(this.activeItem);
            this.model.addRule(i, r);
            TableItem item = new TableItem(this.ruleTable, 0, i);
            this.initRuleTableItem(r, item, false);
            this.ruleTable.select(i);
            this.activeItem = r;
            this.setDirty(true);
        } else {
            this.model.addRule(r);
            TableItem item = new TableItem(this.ruleTable, 0);
            this.initRuleTableItem(r, item, false);
            this.ruleTable.select(this.ruleTable.getChildren().length);
            this.setDirty(true);
        }
    }

    public void formatRule() {
        if (this.activeItem != null && this.activeItem instanceof Rule) {
            Rule rule = (Rule)this.activeItem;
            this.disposeTableEditor();
            String box = rule.getBoxString();
            try {
                String formatted = BoxFactory.formatBox((String)box);
                if (formatted != null) {
                    rule.setBoxString(formatted);
                    int i = this.model.getRules().indexOf(rule);
                    this.ruleTable.getItem(i).setText(1, formatted);
                    this.setDirty(true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void addRuleFromExample() {
        String result;
        this.disposeTableEditor();
        IInputValidator v = new IInputValidator(){

            public String isValid(String newText) {
                Parser parser = RuleTable.this.model.getParser();
                if (parser.parseObject(newText) != null) {
                    return null;
                }
                return "Not a valid string";
            }
        };
        InputDialog dialog = new InputDialog(this.ruleTable.getShell(), "provide your example", "", null, v);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (result = dialog.getValue()) != null) {
            this.newRule();
            Rule rule = (Rule)this.activeItem;
            String box = BoxStringBuilder.exampleToBox(result);
            rule.setBoxString(box);
            int i = this.model.getRules().indexOf(this.activeItem);
            TableItem item = this.ruleTable.getItem(i);
            this.updateRuleTableItem(item, rule, true);
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private final class SeparatorModifier
    implements ModifyListener {
        private SeparatorModifier() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)RuleTable.this.tableEditor.getEditor();
            String l = text.getText();
            TableItem i = RuleTable.this.tableEditor.getItem();
            i.setText(1, l);
            Separator sep = (Separator)RuleTable.this.tableEditor.getItem().getData();
            sep.setLabel(l);
            RuleTable.this.updateSeparatorTableItem(i, l);
            RuleTable.this.setDirty(true);
        }
    }

    private final class RuleModifier
    implements ModifyListener {
        private RuleModifier() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)RuleTable.this.tableEditor.getEditor();
            String b = text.getText();
            TableItem i = RuleTable.this.tableEditor.getItem();
            i.setText(1, b);
            Rule rule = (Rule)RuleTable.this.tableEditor.getItem().getData();
            rule.setBoxString(b);
            RuleTable.this.updateRuleTableItem(i, rule, true);
            RuleTable.this.setDirty(true);
        }
    }
}

