/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import org.eclipse.imp.formatting.spec.VariableEnvironment;
import org.eclipse.imp.services.IASTAdapter;

public class Matcher {
    private IASTAdapter adapter;

    public Matcher(IASTAdapter adapter) {
        this.adapter = adapter;
    }

    private boolean nodeIdentityMatch(Object pattern, Object object) {
        String type1 = this.adapter.getTypeOf(pattern);
        String type2 = this.adapter.getTypeOf(object);
        return this.typeMatch(type1, type2);
    }

    private boolean typeMatch(String type1, String type2) {
        return type1 == null && type2 == null || type1.equals(type2);
    }

    public boolean match(Object pattern, Object object, VariableEnvironment environment) {
        if (this.adapter.isMetaVariable(pattern)) {
            environment.put(pattern.toString(), object);
            return true;
        }
        if (this.nodeIdentityMatch(pattern, object)) {
            Object[] kids2;
            Object[] kids1 = this.adapter.getChildren(pattern);
            if (kids1.length != (kids2 = this.adapter.getChildren(object)).length) {
                return false;
            }
            if (kids1.length == 0) {
                return pattern.equals(object);
            }
            for (int i = 0; i < kids1.length; ++i) {
                if (this.match(kids1[i], kids2[i], environment)) continue;
                return false;
            }
            environment.putAll(environment);
            return true;
        }
        return false;
    }
}

