/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.builders;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.formatting.Activator;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.runtime.PluginBase;

public class FormattingSpecificationBuilder
extends BuilderBase {
    public static final String BUILDER_ID = "org.eclipse.imp.formatting.org.eclipse.imp.formatting.builder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.formatting.org.eclipse.imp.formatting.builder.problem";
    public static final String LANGUAGE_NAME = "FormattingSpecification";
    public static final Language LANGUAGE = LanguageRegistry.findLanguage((String)"FormattingSpecification");

    protected PluginBase getPlugin() {
        return Activator.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        IPath path = file.getRawLocation();
        if (path == null) {
            return false;
        }
        String pathString = path.toString();
        if (pathString.indexOf("/bin/") != -1) {
            return false;
        }
        return LANGUAGE.hasExtension(path.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile resource) {
        System.err.println("FormattingSpecificationBuilder.isNonRootSourceFile(..) returning FALSE by default");
        return false;
    }

    protected void collectDependencies(IFile file) {
        System.err.println("FormattingSpecificationBuilder.collectDependencies(..) doing nothing by default");
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        try {
            System.out.println("Builder.compile with file = " + file.getName());
            this.runParserForCompiler(file, monitor);
            this.doRefresh((IResource)file.getParent());
        }
        catch (Exception e) {
            this.getPlugin().writeErrorMsg(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void runParserForCompiler(IFile file, IProgressMonitor monitor) {
        try {
            IPath path = file.getProjectRelativePath();
            Parser p = new Parser(path, (ISourceProject)file.getProject(), new IMessageHandler(){

                public void clearMessages() {
                }

                public void startMessageGroup(String groupName) {
                }

                public void endMessageGroup() {
                }

                public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
                }
            });
            try {
                p.parse(path);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.doRefresh((IResource)file.getParent());
        }
        catch (Exception e) {
            this.getPlugin().writeErrorMsg(e.getMessage());
            e.printStackTrace();
        }
    }
}

