/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.box.builders.BoxException;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.formatting.Activator;
import org.eclipse.imp.formatting.spec.ExtensionPointBinder;
import org.eclipse.imp.formatting.spec.ParseException;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.formatting.spec.Transformer;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IASTAdapter;
import org.eclipse.imp.services.ISourceFormatter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SourceFormatter
implements ISourceFormatter,
ILanguageService {
    private IASTAdapter adapter;
    private AbstractTextEditor fActiveEditor;
    private Language fLanguage;
    private Transformer transformer;
    private IMessageHandler handler = new IMessageHandler(){

        public void clearMessages() {
        }

        public void startMessageGroup(String groupName) {
        }

        public void endMessageGroup() {
        }

        public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
            Activator.getInstance().writeErrorMsg(msg + "@" + startOffset + "-" + endOffset);
        }
    };
    private Parser parser;

    public void formatterStarts(String initialIndentation) {
        this.initialize();
    }

    private void initialize() {
        try {
            UniversalEditor ue = (UniversalEditor)this.getActiveEditor();
            this.fLanguage = LanguageRegistry.findLanguage((IEditorInput)ue.getEditorInput(), (IDocumentProvider)ue.getDocumentProvider());
            ExtensionPointBinder b = new ExtensionPointBinder(this.fLanguage);
            this.adapter = b.getASTAdapter();
            IPath fsp = b.getSpecificationPath();
            this.parser = new Parser(fsp, this.getActiveProject(), this.handler);
            Specification spec = this.parser.parse(fsp);
            this.transformer = new Transformer(spec, this.adapter);
        }
        catch (ModelFactory.ModelException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AbstractTextEditor getActiveEditor() {
        this.fActiveEditor = (AbstractTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return this.fActiveEditor;
    }

    private ISourceProject getActiveProject() throws ModelFactory.ModelException {
        return ModelFactory.open((IProject)this.extractResource((IEditorPart)this.getActiveEditor()).getProject());
    }

    private IResource extractResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    public String format(IParseController ignored, String content, boolean isLineStart, String indentation, int[] positions) {
        Object ast = this.parser.parseObject(content);
        if (ast != null) {
            String box = this.transformer.transformToBox(content, ast);
            try {
                return BoxFactory.box2text((String)box);
            }
            catch (BoxException e) {
                this.postError("Internal error: " + e.getMessage());
                return content;
            }
        }
        this.postError("Code could not be formatted due to parse error(s)");
        return content;
    }

    private void postError(String cause) {
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to format", (String)cause);
    }

    public void formatterStops() {
    }
}

