/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import org.eclipse.imp.formatting.editor.Editor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class Contributor
extends EditorActionBarContributor {
    private IEditorPart activeEditorPart;

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("Editor &Menu");
        manager.prependToGroup("additions", (IContributionItem)menu);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new Action("Add rule"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.newRule();
                }
            }
        });
        manager.add((IAction)new Action("Add rule..."){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.addRuleFromExample();
                }
            }
        });
        manager.add((IAction)new Action("Delete rule"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.deleteRule();
                }
            }
        });
        manager.add((IAction)new Action("Add separator"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.addSeparator();
                }
            }
        });
        manager.add((IAction)new Action("Up"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.moveUp();
                }
            }
        });
        manager.add((IAction)new Action("Down"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.moveDown();
                }
            }
        });
        manager.add((IAction)new Action("New option"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.addOption();
                }
            }
        });
        manager.add((IAction)new Action("Delete option"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.deleteOption();
                }
            }
        });
        manager.add((IAction)new Action("Format"){

            public void run() {
                IEditorPart editor = Contributor.this.getPage().getActiveEditor();
                if (editor instanceof Editor) {
                    Editor e = (Editor)editor;
                    e.updateExample();
                }
            }
        });
    }
}

