/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.formatting.editor.RuleTable;
import org.eclipse.imp.formatting.editor.SpaceOptionTable;
import org.eclipse.imp.formatting.spec.ExtensionPointBinder;
import org.eclipse.imp.formatting.spec.ParseException;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.formatting.spec.Transformer;
import org.eclipse.imp.formatting.spec.Unparser;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.utils.StreamUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class Editor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final int RuleEditorIndex = 0;
    private static final int ExampleEditorIndex = 1;
    private static final int OptionEditorIndex = 2;
    protected TextEditor editor;
    protected Text example;
    private Specification model;
    private boolean exampleModified = false;
    private Parser parser;
    private RuleTable ruleTable;
    private SpaceOptionTable spaceTable;
    private ModifyListener exampleModifier;

    public Editor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        LanguageRegistry.getLanguages();
    }

    public Specification getModel() {
        return this.model;
    }

    public void createExampleViewer() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        this.example = new Text(parent, 2816);
        this.example.setFont(new Font((Device)this.example.getDisplay(), "Monospace", 10, 0));
        this.exampleModifier = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Editor.this.model.setExample(Editor.this.example.getText());
                Editor.this.exampleModified = true;
                Editor.this.firePropertyChange(257);
                Object ast = Editor.this.parser.parseObject(Editor.this.example.getText());
                if (ast != null) {
                    Editor.this.model.setExampleAst(ast);
                }
            }
        };
        this.example.addModifyListener(this.exampleModifier);
        this.addPage(1, (Control)parent);
        this.setPageText(1, "Example");
    }

    protected void updateExample() {
        if (this.model != null) {
            String current = this.example.getText();
            if (current == null || current.length() == 0) {
                this.example.setText(this.model.getExample());
            }
            this.reformatExample();
        }
    }

    protected void createPages() {
        this.createRuleEditor();
        IEditorInput input = this.ruleTable.getEditorInput();
        this.setPartName(input.getName());
        this.model = this.updateModelFromFile(input);
        this.createExampleViewer();
        this.createOptionEditor();
        this.ruleTable.setModel(this.model);
        this.spaceTable.setModel(this.model);
        this.updateExample();
        this.exampleModified = false;
    }

    private void createOptionEditor() {
        this.spaceTable = new SpaceOptionTable(this.model);
        this.spaceTable.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                Editor.this.firePropertyChange(257);
            }
        });
        try {
            this.addPage(2, this.spaceTable, this.getEditorInput());
            this.setPageText(2, this.spaceTable.getTitle());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private void createRuleEditor() {
        this.ruleTable = new RuleTable();
        this.ruleTable.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                Editor.this.firePropertyChange(257);
            }
        });
        try {
            this.addPage(0, this.ruleTable, this.getEditorInput());
            this.setPageText(0, this.ruleTable.getTitle());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private Specification updateModelFromFile(IEditorInput input) {
        try {
            IPath path = ((IFileEditorInput)this.getEditorInput()).getFile().getProjectRelativePath();
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            IPath fullFilePath = project.getLocation().append(path);
            ISourceProject sp = ModelFactory.open((IProject)project);
            this.parser = new Parser(fullFilePath, sp, new IMessageHandler(){

                public void clearMessages() {
                }

                public void startMessageGroup(String groupName) {
                }

                public void endMessageGroup() {
                }

                public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
                    System.err.println("parse error:");
                    System.err.println("\tline: " + startLine);
                    System.err.println("\tcolumn: " + startCol);
                }
            });
            IFile file = ((IFileEditorInput)input).getFile();
            String editorText = StreamUtils.readStreamContents((InputStream)file.getContents());
            if (editorText == null || editorText.length() == 0) {
                String langName = this.askUserForLanguage();
                this.parser.setLanguage(langName);
                Specification skelSpec = new Specification(langName, this.parser);
                this.exampleModified = true;
                return skelSpec;
            }
            this.model = this.parser.load(editorText);
            return this.model;
        }
        catch (ParseException e) {
            System.err.println("error:" + e);
        }
        catch (ModelFactory.ModelException e) {
            System.err.println("model error:" + (Object)((Object)e));
        }
        catch (CoreException e) {
            System.err.println("file reading error:" + (Object)((Object)e));
        }
        return new Specification(this.parser);
    }

    private String askUserForLanguage() {
        InputDialog d = new InputDialog(this.ruleTable.getSite().getShell(), "Missing language ID", "Please provide the language ID", "", new IInputValidator(){

            public String isValid(String newText) {
                return newText != null && newText.length() > 0 ? null : "Language ID must be non-empty";
            }
        });
        if (d.open() == 0) {
            return d.getValue();
        }
        return "";
    }

    private void reformatExample() {
        Object ast = this.parser.parseObject(this.model.getExample());
        if (ast != null) {
            this.model.setExampleAst(ast);
            try {
                Language objectLanguage = LanguageRegistry.findLanguage((String)this.model.getLanguage());
                ExtensionPointBinder b = new ExtensionPointBinder(objectLanguage);
                Transformer t = new Transformer(this.model, b.getASTAdapter());
                String box = t.transformToBox(this.model.getExample(), this.model.getExampleAst());
                String newExample = BoxFactory.box2text((String)box);
                this.example.removeModifyListener(this.exampleModifier);
                this.example.setText(newExample);
                this.example.addModifyListener(this.exampleModifier);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Unparser u = new Unparser();
            String contents = u.unparse(this.model);
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            ByteArrayInputStream s = new ByteArrayInputStream(contents.getBytes());
            file.setContents((InputStream)s, 0, monitor);
            this.ruleTable.setDirty(false);
            this.spaceTable.setDirty(false);
            this.exampleModified = false;
            this.firePropertyChange(257);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = Editor.this.getSite().getWorkbenchWindow().getPages();
                    for (int i = 0; i < pages.length; ++i) {
                        if (!((FileEditorInput)Editor.this.editor.getEditorInput()).getFile().getProject().equals(event.getResource())) continue;
                        IEditorPart editorPart = pages[i].findEditor(Editor.this.editor.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                }
            });
        }
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 2: {
                this.spaceTable.refresh();
                break;
            }
            case 1: {
                this.updateExample();
                break;
            }
        }
        super.pageChange(newPageIndex);
    }

    public boolean isDirty() {
        return this.ruleTable.isDirty() || this.spaceTable.isDirty() || this.exampleModified;
    }

    public void newRule() {
        this.ruleTable.newRule();
    }

    public void addSeparator() {
        this.ruleTable.addSeparator();
    }

    public void deleteRule() {
        this.ruleTable.deleteRule();
    }

    public void formatRule() {
        this.ruleTable.formatRule();
    }

    public void addRuleFromExample() {
        this.ruleTable.addRuleFromExample();
    }

    public void moveUp() {
        this.ruleTable.move(-1);
    }

    public void moveDown() {
        this.ruleTable.move(1);
    }

    public void addOption() {
        this.spaceTable.newOption();
    }

    public void deleteOption() {
        this.spaceTable.deleteOption();
    }
}

