/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.java.hosted;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.model.IPathEntry;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectUtils {
    public void addExtenderForJavaHostedProjects(Language lang) {
        ModelFactory.getInstance().installExtender(new ModelFactory.IFactoryExtender(){

            public void extend(ISourceProject project) {
                this.initializeBuildPathFromJavaProject(project);
            }

            public void extend(ICompilationUnit unit) {
            }

            public void initializeBuildPathFromJavaProject(ISourceProject project) {
                IJavaProject javaProject = JavaCore.create((IProject)project.getRawProject());
                if (javaProject.exists()) {
                    try {
                        IClasspathEntry[] cpEntries = javaProject.getResolvedClasspath(true);
                        ArrayList<IPathEntry> buildPath = new ArrayList<IPathEntry>(cpEntries.length);
                        for (int i = 0; i < cpEntries.length; ++i) {
                            IPathEntry.PathEntryType type;
                            IClasspathEntry entry = cpEntries[i];
                            IPath path = entry.getPath();
                            switch (entry.getEntryKind()) {
                                case 5: {
                                    type = IPathEntry.PathEntryType.CONTAINER;
                                    break;
                                }
                                case 1: {
                                    type = IPathEntry.PathEntryType.ARCHIVE;
                                    break;
                                }
                                case 2: {
                                    type = IPathEntry.PathEntryType.PROJECT;
                                    break;
                                }
                                case 3: {
                                    type = IPathEntry.PathEntryType.SOURCE_FOLDER;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Encountered variable class-path entry: " + entry.getPath().toPortableString());
                                }
                            }
                            IPathEntry pathEntry = ModelFactory.createPathEntry((IPathEntry.PathEntryType)type, (IPath)path);
                            buildPath.add(pathEntry);
                        }
                        project.setBuildPath(buildPath);
                    }
                    catch (JavaModelException e) {
                        ErrorHandler.reportError((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }, lang);
    }
}

