/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.analysis;

import lpg.runtime.IAstVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.analysis.LPGAnalysisTypes;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.IFactGenerator;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.FactKey;
import org.eclipse.imp.pdb.facts.db.IFactContext;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.db.context.CompilationUnitContext;
import org.eclipse.imp.pdb.facts.impl.reference.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;

public class LPGCallGraphGenerator
implements IFactGenerator {
    public void generate(FactBase factBase, Type type, IFactContext context) throws AnalysisException {
        CompilationUnitContext cuc = (CompilationUnitContext)context;
        Language lpgLang = LanguageRegistry.findLanguage((String)LPGRuntimePlugin.getInstance().getLanguageID());
        IParseController pc = ServiceFactory.getInstance().getParseController(lpgLang);
        final boolean[] hasError = new boolean[]{false};
        IMessageHandler mh = new IMessageHandler(){

            public void clearMessages() {
            }

            public void startMessageGroup(String groupName) {
            }

            public void endMessageGroup() {
            }

            public void handleSimpleMessage(String msg, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
                hasError[0] = true;
            }
        };
        ICompilationUnit cu = cuc.getCompilationUnit();
        pc.initialize(cu.getPath(), cu.getProject(), mh);
        LPGParser.ASTNode root = (LPGParser.ASTNode)pc.parse(cu.getSource(), (IProgressMonitor)new NullProgressMonitor());
        ISetWriter cgw = (ISetWriter)LPGAnalysisTypes.LPGCallGraphType.writer((IValueFactory)ValueFactory.getInstance());
        root.accept((IAstVisitor)new CGVisitor(cgw));
        factBase.defineFact((IFactKey)new FactKey(type, context), (IValue)cgw.done());
    }

    private final class CGVisitor
    extends LPGParser.AbstractVisitor {
        private String lhsStr;
        private final ISetWriter fWriter;
        private final ValueFactory fValueFactory = ValueFactory.getInstance();

        public CGVisitor(ISetWriter rw) {
            this.fWriter = rw;
        }

        public void unimplementedVisitor(String s) {
        }

        public boolean visit(LPGParser.nonTerm n) {
            this.lhsStr = n.getruleNameWithAttributes().getSYMBOL().toString();
            return super.visit(n);
        }

        public boolean visit(LPGParser.rule n) {
            LPGParser.symWithAttrsList rhsList = n.getsymWithAttrsList();
            for (int i = 0; i < rhsList.size(); ++i) {
                LPGParser.IsymWithAttrs sym = rhsList.getsymWithAttrsAt(i);
                if (!(sym instanceof LPGParser.symWithAttrs1)) continue;
                LPGParser.symWithAttrs1 sym1 = (LPGParser.symWithAttrs1)sym;
                String rhsStr = sym1.getSYMBOL().toString();
                IValue lhs = LPGAnalysisTypes.LPGNonTerminalType.make((IValueFactory)this.fValueFactory, this.lhsStr);
                IValue rhs = LPGAnalysisTypes.LPGNonTerminalType.make((IValueFactory)this.fValueFactory, rhsStr);
                ITuple tuple = this.fValueFactory.tuple(new IValue[]{lhs, rhs});
                this.fWriter.insert(new IValue[]{tuple});
            }
            return true;
        }
    }
}

