//
// This is the grammar specification from the Final Draft of the generic spec.
//
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2007 IBM Corporation.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
//Contributors:
//    Philippe Charles (pcharles@us.ibm.com) - initial API and implementation

////////////////////////////////////////////////////////////////////////////////

package org.eclipse.imp.lpg.parser;

public class JavaParserprs implements lpg.runtime.ParseTable, JavaParsersym {
    public final static int ERROR_SYMBOL = 119;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 83;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 84;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 36;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 479;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 119;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 8412;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 1;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 539;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 249;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 368;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 7209;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 2;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 85;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 85;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 7416;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 7873;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return JavaParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,1,0,0,1,1,0,0,0,0,
            0,1,0,0,0,0,0,0,0,0,
            0,0,0,0,1,0,1,0,0,0,
            0,0,0,0,0,0,0,0,0,1,
            0,0,0,0,0,0,0,0,1,0,
            0,0,1,0,1,0,0,1,0,1,
            0,0,0,1,1,0,0,1,0,0,
            0,1,0,1,1,0,0,0,0,0,
            0,0,0,0,0,1,0,0,0,1,
            0,0,0,0,0,0,0,0,0,1,
            1,0,0,1,0,0,1,1,1,1,
            0,1,0,0,1,0,0,0,1,1,
            1,0,0,0,1,0,0,0,0,0,
            0,0,0,1,0,0,1,1,0,1,
            0,0,1,0,0,1,0,0,1,0,
            1,0,1,0,1,0,1,0,0,1,
            1,0,0,0,1,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            7,19,18,16,15,10,12,13,14,9,
            11,17,22,36,37,38,117,199,200,222,
            223,224,225,226,227,197,198,233,195,196,
            235,236,234,194,248,237,238,239,240,241,
            64,153,154,155,242,243,244,245,160,246,
            247,83,101,107,193,169,171,172,173,174,
            175,176,177,178,179,180,181,182,183,184,
            185,186,187,209,210,63,53,55,56,57,
            62,100,98,99,29,20,116,133,228,54,
            127,128,129,132,170,81,167,168,97,166,
            188,189,190,191,192,8,21,58,65,80,
            84,86,103,113,142,145,152,161,207,231,
            48,61,71,72,73,74,75,76,77,78,
            79,85,87,89,102,108,112,138,140,141,
            143,144,215,232,2,5,70,82,92,95,
            104,122,124,206,212,230,23,28,31,32,
            44,46,49,50,51,52,60,68,90,91,
            93,94,96,106,137,139,149,158,159,205,
            211,213,214,216,217,221,229,3,4,6,
            24,25,26,27,30,33,34,35,39,40,
            41,42,43,45,47,59,66,67,69,88,
            105,109,110,111,114,115,118,119,120,121,
            123,125,126,130,131,134,135,136,146,147,
            148,150,151,156,157,162,163,164,165,201,
            202,203,204,208,218,219,220,249,1
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            1,1,0,0,1,0,0,0,1,1,
            1,0,0,0,0,0,0,1,1,1,
            1,0,0,0,0,0,0,0,0,0,
            0,1,0,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            0,1,1,1,0,0,0,0,0,0,
            0,0,0,1,0,0,1,1,1,1,
            1,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            2,2,1,1,3,3,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,2,1,3,
            1,1,3,2,3,1,2,2,3,1,
            3,1,1,2,2,2,1,3,1,3,
            1,3,1,3,1,3,3,1,2,1,
            2,4,1,1,1,1,3,5,6,6,
            1,1,1,1,1,7,1,2,1,1,
            1,1,1,1,1,1,3,1,3,2,
            2,1,3,3,1,2,1,1,1,1,
            1,1,1,1,1,4,1,3,1,3,
            1,3,1,1,1,2,1,1,1,1,
            1,1,1,1,2,5,1,1,4,3,
            1,3,1,3,3,1,2,1,1,4,
            1,2,1,1,1,1,1,1,1,1,
            1,1,2,1,3,1,1,1,1,1,
            2,4,5,1,1,2,1,1,1,1,
            4,6,6,8,5,5,1,3,4,3,
            2,1,1,6,1,2,1,1,1,1,
            1,1,1,2,3,3,1,2,1,1,
            1,1,1,3,1,2,1,1,1,1,
            6,1,2,1,1,1,5,3,1,2,
            7,1,1,1,1,1,1,2,1,2,
            1,1,1,5,1,3,3,1,1,1,
            1,4,1,3,2,5,4,1,3,3,
            1,2,1,1,1,2,3,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            5,7,7,1,3,3,2,1,1,1,
            1,1,1,1,3,5,5,4,1,2,
            2,1,2,3,3,2,1,5,5,7,
            1,1,9,9,1,1,1,1,3,7,
            3,3,3,3,5,3,4,1,2,5,
            2,1,1,1,3,3,1,3,3,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,8,10,1,3,4,4,4,
            4,1,2,3,2,3,3,3,5,4,
            7,7,9,7,4,4,1,1,1,1,
            2,2,1,1,2,2,1,2,2,1,
            2,2,1,5,4,1,3,3,3,1,
            3,3,1,3,4,5,1,3,3,3,
            4,3,1,3,3,1,3,1,3,1,
            3,1,3,1,3,1,5,1,1,3,
            1,1,1,1,1,1,1,1,1,1,
            3,4,1,1,1,1,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,0,
            1,0,1,0,1,0,1,0,1,-4,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            -2,-153,1,34,35,4,-314,1,2,3,
            41,42,43,44,-136,1,2,3,-58,5,
            -70,-290,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,-37,1,2,3,-306,5,
            6,7,8,9,95,-6,97,98,-220,100,
            -127,1,54,-149,54,106,-347,1,2,3,
            4,-7,1,2,-98,1,-280,1,2,3,
            4,5,6,7,8,9,10,11,12,-3,
            -10,1,2,-14,-246,1,2,-12,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,-18,85,
            86,34,35,-224,1,2,3,4,41,42,
            43,44,-245,-66,-19,85,86,-8,157,190,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,-305,1,41,42,43,44,41,42,
            43,44,95,145,97,98,53,100,207,-247,
            -15,107,-21,106,-13,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,159,160,-11,34,35,
            174,41,42,43,44,41,42,43,44,186,
            161,240,163,164,165,166,113,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,199,
            201,-427,203,-299,1,2,3,-166,5,95,
            -414,97,98,209,100,247,-65,174,245,246,
            106,-25,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,-67,-22,211,34,35,41,42,43,
            44,-23,41,42,43,44,-99,1,-61,217,
            178,179,-152,1,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,-125,1,161,-24,
            163,164,165,166,-292,206,95,208,97,98,
            119,100,-26,-150,-357,1,2,106,-343,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,-27,
            108,109,34,35,41,42,43,44,54,41,
            42,43,44,-63,167,168,108,109,-76,-29,
            -151,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,-30,41,42,43,44,-222,41,
            42,43,44,95,-31,97,98,-32,100,219,
            -155,107,-33,223,106,-384,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,88,-140,1,34,
            35,41,42,43,44,-34,41,42,43,44,
            212,-60,-415,-298,1,112,214,4,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            -276,1,41,42,43,44,-89,1,2,149,
            95,151,97,98,53,100,-156,1,2,3,
            4,5,6,7,8,9,10,11,12,-204,
            -409,-227,85,86,119,-59,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,-363,1,2,34,
            35,41,42,43,44,114,41,42,43,44,
            -390,1,-131,1,186,85,86,248,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            157,-395,1,2,-79,1,-158,1,-388,1,
            95,-36,97,98,-431,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,85,86,85,34,35,
            -436,1,-38,107,-167,41,42,43,44,-413,
            1,2,-300,221,222,169,-39,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,-229,
            1,-232,191,192,96,196,197,-334,107,95,
            -293,97,98,-253,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,-313,-223,96,34,35,-459,
            1,2,3,4,5,6,7,8,9,10,
            11,12,108,109,54,-35,107,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,-17,
            1,2,3,4,5,6,7,8,9,10,
            11,12,198,-161,1,-440,-468,1,-207,108,
            109,149,-40,151,101,102,103,104,105,-371,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            85,86,145,34,35,-62,1,2,3,4,
            5,6,7,8,9,10,11,12,-473,170,
            -43,-95,-44,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,-171,1,2,3,4,
            5,6,7,8,9,10,11,12,-163,1,
            -210,167,168,108,109,-198,1,-45,169,111,
            101,102,103,104,105,-449,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,85,86,213,34,
            35,-182,1,2,3,4,5,6,7,8,
            9,10,11,12,-201,1,170,-211,-46,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,-281,1,2,3,4,5,6,7,8,
            9,10,11,12,-214,1,-47,149,-48,151,
            -49,111,-231,1,-233,1,101,102,103,104,
            105,-450,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,85,86,-51,34,35,-282,1,2,
            3,4,5,6,7,8,9,10,11,12,
            -240,1,-56,-215,-68,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,-342,1,2,
            3,4,5,6,7,8,9,10,11,12,
            -288,1,-329,1,-361,1,-433,1,-437,1,
            -69,-360,101,102,103,104,105,-470,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,85,86,
            -396,34,35,-349,1,2,3,4,5,6,
            7,8,9,10,11,12,-302,-71,-72,-312,
            -73,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,-399,1,2,3,4,5,6,
            7,8,9,10,11,12,-74,-242,1,-53,
            1,-54,1,-303,-338,-472,-355,-75,101,102,
            103,104,105,-479,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,85,86,145,34,35,-405,
            1,2,3,4,5,6,7,8,9,10,
            11,12,-404,-176,-77,-80,-81,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,85,
            86,-82,-83,96,-84,-85,-364,-86,158,-87,
            -90,-91,-92,41,42,43,44,110,-93,-94,
            -351,-381,-96,-103,101,102,103,104,105,-383,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,-105,-393,1,-106,115,-387,-109,
            -111,-114,-16,120,185,229,185,-52,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,122,156,
            -115,34,35,41,42,43,44,224,-116,226,
            119,225,54,-117,-118,53,-119,232,233,-120,
            121,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,-64,82,154,-121,-122,158,-123,
            96,152,-133,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,193,194,-124,34,35,-410,-126,
            -129,-130,-138,-141,-143,-144,-145,54,-146,-148,
            -157,-159,-162,-164,-165,-168,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,-169,41,
            42,43,44,242,-170,-172,-173,-174,-175,-186,
            -196,53,188,244,-160,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,-197,-199,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,-200,-202,-203,-205,-212,
            -213,-217,-218,-219,116,-221,-225,-226,-424,-252,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            -228,-230,-234,34,35,-235,-236,-237,-239,-241,
            -243,-254,-256,210,-257,-258,-259,-260,-261,-262,
            -264,117,118,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,-365,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,-265,-267,-268,34,
            35,-269,178,179,-270,-271,-272,-273,-274,-275,
            122,-277,-279,-283,-285,-286,-287,-289,-296,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,153,-301,-307,-308,-309,-311,-315,-316,-317,
            -318,-319,-320,-321,-322,-323,-325,-327,234,235,
            -367,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,-332,-333,-335,34,35,-340,-341,-344,-345,
            -346,-348,-350,-352,-356,-358,-362,-372,-373,-374,
            -375,-376,-378,-379,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,-447,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,-380,-382,-386,
            34,35,-389,-391,-392,-397,-398,-400,-401,-402,
            -403,-406,-407,-408,-418,-419,-420,-421,-422,-426,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,-238,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,-428,-429,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,-284,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,-97,1,-154,1,45,46,
            47,48,49,50,51,52,-251,1,-430,-438,
            1,-432,-439,-442,-446,-451,-452,-453,-454,117,
            118,-128,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,-455,-456,111,-457,45,46,47,48,
            49,50,51,52,-458,-460,-461,-462,-465,-466,
            -467,-471,-474,-475,-476,-478,0,0,0,0,
            96,0,96,0,0,0,0,0,0,0,
            0,148,96,0,110,96,110,0,87,0,
            89,0,0,0,0,0,110,0,0,110,
            0,0,0,0,0,131,0,131,0,0,
            0,0,0,0,0,0,0,131,236,237,
            131,0,0,0,0,0,0,0,-244,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,0,
            0,238,239,45,46,47,48,49,50,51,
            52,-304,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,0,0,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,-444,-463,0,0,0,0,0,111,
            0,-359,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,0,148,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,0,0,0,0,0,117,118,
            -330,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,0,122,122,0,0,117,118,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,153,153,87,0,89,
            -331,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-41,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,87,0,89,
            -336,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-42,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,87,0,89,
            -337,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-107,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,87,0,89,
            -377,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-423,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,0,0,0,0,45,46,
            47,48,49,50,51,52,0,0,0,0,
            0,111,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            87,0,89,0,0,0,0,0,148,-425,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-108,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,87,0,89,-434,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-112,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,87,0,89,-435,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-113,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,87,0,89,-445,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-179,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,87,0,89,-464,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-180,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,87,0,89,-477,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,0,0,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            -55,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,0,0,0,0,0,0,0,
            0,0,0,0,0,0,117,118,-249,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,0,
            0,0,0,45,46,47,48,49,50,51,
            52,-181,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,155,-448,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,0,0,0,
            0,45,46,47,48,49,50,51,52,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,155,-28,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,0,0,0,0,45,
            46,47,48,49,50,51,52,-324,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,155,-50,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,0,0,0,0,45,46,47,
            48,49,50,51,52,-57,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,0,0,0,0,
            45,46,47,48,49,50,51,52,-101,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,0,
            0,0,0,45,46,47,48,49,50,51,
            52,-102,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,0,0,0,0,45,46,47,48,
            49,50,51,52,-110,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,0,0,0,0,45,
            46,47,48,49,50,51,52,-137,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,0,0,
            0,0,45,46,47,48,49,50,51,52,
            -139,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-142,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,0,0,0,0,45,46,
            47,48,49,50,51,52,-147,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,0,0,0,
            0,45,46,47,48,49,50,51,52,-193,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            0,0,0,0,45,46,47,48,49,50,
            51,52,-208,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,0,0,0,0,45,46,47,
            48,49,50,51,52,-216,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,0,0,0,0,
            45,46,47,48,49,50,51,52,-248,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,0,
            0,0,0,45,46,47,48,49,50,51,
            52,-278,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,0,0,0,0,45,46,47,48,
            49,50,51,52,-291,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,0,0,0,0,45,
            46,47,48,49,50,51,52,-369,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,0,0,
            0,0,45,46,47,48,49,50,51,52,
            -370,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,0,0,0,0,45,46,47,48,49,
            50,51,52,-104,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,0,0,0,0,45,46,
            47,48,49,50,51,-100,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,0,-206,-209,34,
            35,0,0,0,0,0,41,42,43,44,
            -310,1,0,0,-416,1,-134,0,53,0,
            55,-295,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,82,83,84,
            0,41,42,43,44,41,42,43,44,0,
            95,0,0,53,99,0,0,53,-368,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,-135,
            0,0,34,35,0,0,85,86,143,41,
            42,43,44,0,0,0,0,120,120,0,
            0,53,0,55,0,0,0,0,0,0,
            0,121,0,0,0,121,120,0,0,0,
            0,144,144,0,0,0,181,0,183,0,
            82,83,84,156,156,0,0,0,0,0,
            144,0,152,95,0,0,152,99,-328,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,0,187,36,37,38,39,40,0,
            0,143,0,45,46,47,48,49,50,120,
            0,0,0,0,0,0,0,0,218,0,
            220,0,0,0,0,0,215,216,0,0,
            0,0,0,144,0,0,0,0,0,181,
            0,183,-194,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,187,0,36,37,
            38,39,40,0,0,0,0,45,46,47,
            48,-195,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,0,0,36,37,38,
            39,40,0,0,0,0,45,46,47,-191,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,0,0,36,37,38,39,40,
            0,0,0,0,45,46,-192,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            0,0,36,37,38,39,40,0,0,0,
            -385,45,-188,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,-5,0,36,37,
            38,39,40,-255,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,0,0,31,32,0,41,42,43,
            44,0,0,0,0,0,0,0,0,53,
            54,0,0,0,0,0,0,0,0,0,
            0,0,0,-20,0,0,0,0,0,0,
            0,0,76,77,78,79,80,81,0,119,
            0,0,0,0,88,0,90,91,92,93,
            94,-132,1,2,3,4,5,6,7,8,
            9,10,11,12,41,42,43,44,112,113,
            114,0,0,0,154,0,0,0,0,123,
            124,125,126,127,128,129,130,0,132,133,
            134,135,136,137,-339,0,0,0,0,76,
            180,0,146,147,-189,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,0,0,
            36,37,38,39,-190,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,-417,0,
            36,37,38,39,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            159,160,0,119,0,0,0,0,0,41,
            42,43,44,0,0,0,0,0,0,0,
            0,53,54,0,0,0,0,0,0,0,
            -443,0,0,0,0,0,195,0,154,0,
            0,0,0,0,76,77,78,79,80,81,
            0,0,0,0,0,0,88,0,90,91,
            92,93,94,0,180,0,0,0,0,0,
            0,41,42,43,44,0,0,0,0,0,
            112,113,114,53,54,0,0,0,0,0,
            0,123,124,125,126,127,128,129,130,0,
            132,133,134,135,136,137,76,77,78,79,
            80,81,0,0,146,147,0,0,88,0,
            90,91,92,93,94,241,0,243,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,112,113,114,0,0,0,0,0,
            0,0,0,123,124,125,126,127,128,129,
            130,0,132,133,134,135,136,137,0,0,
            0,0,0,0,0,0,146,147,-183,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,0,0,36,37,38,-184,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,0,0,36,37,38,-185,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            0,0,36,37,38,-263,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,0,
            0,36,37,38,-366,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,0,0,0,34,35,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,55,
            -469,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,0,0,0,34,35,0,0,0,-78,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,55,-294,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            41,42,43,44,0,0,0,143,0,0,
            0,0,53,54,0,0,0,41,42,43,
            44,0,0,0,0,0,0,0,0,53,
            0,0,0,0,0,76,77,78,79,80,
            81,0,0,0,0,0,182,88,184,90,
            91,92,93,94,0,0,0,0,82,83,
            84,0,0,143,0,0,0,0,0,0,
            0,112,113,114,0,99,0,0,0,0,
            0,0,123,124,125,126,127,128,129,130,
            0,132,133,134,135,136,137,0,0,0,
            0,0,182,0,184,-187,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,0,
            0,36,37,-266,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,0,0,36,
            37,-326,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,0,0,36,37,-177,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,0,0,36,-178,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            -412,0,36,-250,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,0,0,0,34,35,0,
            0,41,42,43,44,0,0,0,0,0,
            0,0,0,53,0,-354,0,0,55,0,
            0,0,0,0,0,0,0,0,0,0,
            -297,0,0,0,0,0,76,77,78,79,
            80,81,0,0,0,0,0,0,88,0,
            90,91,92,93,94,0,41,42,43,44,
            0,0,0,0,0,0,0,0,53,0,
            0,41,42,43,44,115,116,0,0,0,
            0,0,0,53,-441,0,0,0,0,0,
            0,76,77,78,79,80,81,0,138,139,
            140,141,142,88,0,90,91,92,93,94,
            0,0,82,83,84,0,0,0,0,0,
            0,0,0,0,0,41,42,43,44,99,
            115,116,0,0,0,175,176,53,0,0,
            -411,0,0,0,0,0,0,0,0,0,
            0,0,0,138,139,140,141,142,0,0,
            76,77,78,79,80,81,0,0,0,0,
            0,0,88,0,90,91,92,93,94,0,
            150,41,42,43,44,0,0,227,228,0,
            0,0,177,53,0,-9,0,0,0,115,
            116,171,172,173,0,0,0,0,0,0,
            0,0,0,0,0,0,76,77,78,79,
            80,81,138,139,140,141,142,0,88,0,
            90,91,92,93,94,0,41,42,43,44,
            0,0,0,0,0,230,231,0,0,-88,
            0,0,0,0,0,115,116,0,-1,175,
            176,0,-353,0,0,0,-394,0,0,0,
            0,76,77,78,79,80,81,0,138,139,
            140,141,142,88,0,90,91,92,93,94,
            41,42,43,44,0,0,0,0,0,41,
            42,43,44,41,42,43,44,41,42,43,
            44,53,0,0,0,53,0,177,0,53,
            0,0,0,0,0,76,77,78,79,80,
            81,0,0,0,0,0,0,88,0,90,
            91,92,93,94,82,83,84,0,82,83,
            84,0,0,0,0,0,0,162,0,0,
            0,99,0,0,0,99,0,0,0,0,
            0,0,0,0,0,0,0,0,0,121,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,202,0,204,
            0,0,0,0,0,0,0,0,0,0,
            0,162,150,0,0,0,150,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,171,172,173,0,0,0,0,
            0,0,0,0,0,0,0,189,0,0,
            0,0,0,0,0,0,0,0,200,0,
            0,0,0,205,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            189,189,189,1,190,190,190,190,190,190,
            10,10,6,6,7,7,8,8,8,8,
            8,9,9,11,11,11,5,3,107,2,
            2,13,4,12,157,192,194,194,158,85,
            195,195,159,159,160,197,197,198,198,14,
            14,16,16,199,199,15,15,189,203,203,
            204,204,205,161,161,161,161,163,164,165,
            166,162,162,162,77,77,78,81,81,76,
            76,76,76,76,76,76,76,109,207,207,
            208,168,209,209,122,147,147,123,123,123,
            123,124,124,124,124,124,128,131,131,110,
            110,96,96,148,148,132,132,112,112,112,
            112,112,112,112,112,129,133,169,169,170,
            170,172,172,173,173,99,84,84,82,82,
            150,135,135,113,113,113,113,113,113,113,
            113,113,113,151,211,211,174,174,210,210,
            125,126,127,212,214,137,137,114,114,114,
            114,213,216,216,216,79,217,220,220,152,
            222,223,90,90,91,94,94,88,88,88,
            88,88,88,88,226,226,225,228,228,175,
            175,175,175,175,138,140,140,115,115,115,
            115,176,142,142,116,116,116,92,229,231,
            231,177,177,177,177,177,177,177,233,53,
            53,41,41,41,42,235,235,178,179,117,
            117,117,118,237,237,43,44,111,239,239,
            54,100,100,97,97,97,98,95,56,56,
            56,56,56,56,57,57,57,57,57,57,
            57,57,57,57,57,57,101,101,101,101,
            101,59,60,103,63,58,102,64,55,55,
            55,55,55,55,55,65,65,66,240,243,
            243,180,154,154,119,119,119,152,61,104,
            67,62,62,74,105,183,183,184,143,143,
            75,68,69,70,72,71,73,73,245,245,
            186,247,17,17,20,20,20,20,20,20,
            20,20,20,20,22,22,22,22,22,22,
            22,22,25,25,19,19,89,89,21,21,
            21,21,187,187,144,120,120,23,23,23,
            18,18,18,18,18,24,24,28,28,28,
            28,26,27,33,33,33,33,33,29,30,
            31,31,31,31,32,32,36,36,36,36,
            37,37,37,38,38,38,38,39,39,39,
            39,39,39,40,40,40,45,45,46,46,
            47,47,48,48,50,50,49,49,51,51,
            34,35,35,35,248,248,248,248,248,248,
            248,248,248,248,248,248,52,244,156,156,
            246,246,185,185,182,182,155,155,181,181,
            242,242,241,241,83,83,238,238,236,236,
            234,234,232,232,230,230,141,141,139,139,
            227,227,224,224,93,93,153,153,221,221,
            219,219,145,145,218,218,87,87,106,106,
            215,215,136,136,188,188,171,171,149,149,
            134,134,130,130,146,146,167,167,206,206,
            108,108,80,80,121,121,202,202,201,201,
            200,200,196,196,193,193,191,191,86,86,
            1,1322,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,1727,1689,
            1363,333,334,1523,1377,348,1731,1729,1581,289,
            290,229,287,32,288,1030,1222,287,29,1582,
            90,725,231,232,233,287,29,1582,26,820,
            1688,1599,1481,781,264,993,255,258,259,260,
            261,262,263,265,266,267,268,269,270,271,
            272,273,274,275,311,312,77,254,74,75,
            783,5964,136,1500,2123,449,29,1582,26,1444,
            5437,5520,12,14,15,674,365,251,253,1199,
            1226,364,368,644,972,161,4,287,2053,1582,
            156,157,287,29,2006,287,878,68,2053,1582,
            26,24,23,10,12,14,15,2358,2359,25,
            362,421,2043,2041,162,287,29,1900,112,1322,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,1583,1084,1103,1628,1727,1689,1363,333,
            334,1523,1377,348,1731,1729,1581,289,290,2266,
            539,585,288,1030,287,2053,1582,156,157,725,
            231,232,233,1307,1837,2286,539,1626,469,88,
            2,781,264,993,255,258,259,260,261,262,
            263,265,266,267,268,269,270,271,272,273,
            274,275,311,312,77,254,74,75,783,5964,
            136,1500,2123,287,238,229,231,232,233,230,
            231,232,233,674,2586,251,253,1101,1226,2368,
            1299,505,92,561,2049,112,1322,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,1583,
            1084,1103,1628,1727,1689,1363,333,334,1523,1377,
            348,1731,1729,1581,289,290,41,43,436,288,
            1030,155,230,231,232,233,725,231,232,233,
            328,58,297,63,64,65,66,142,781,264,
            993,255,258,259,260,261,262,263,265,266,
            267,268,269,270,271,272,273,274,275,311,
            312,77,254,74,75,783,5964,136,1500,2123,
            2042,7146,1063,818,287,29,1582,26,1049,2051,
            674,1778,251,253,2527,1226,327,2007,154,1089,
            639,2050,112,1322,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,1583,1084,1103,1628,
            1727,1689,1363,333,334,1523,1377,348,1731,1729,
            1581,289,290,573,42,2499,288,1030,230,231,
            232,233,424,725,231,232,233,287,1365,573,
            175,236,2407,287,164,781,264,993,255,258,
            259,260,261,262,263,265,266,267,268,269,
            270,271,272,273,274,275,311,312,77,254,
            74,75,783,5964,136,1500,2123,287,2301,59,
            564,63,64,65,66,820,1455,674,519,251,
            253,303,1226,369,1059,287,29,1900,2054,112,
            1322,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,1727,1689,1363,
            333,334,1523,1377,348,1731,1729,1581,289,290,
            367,1207,521,288,1030,230,231,232,233,325,
            725,231,232,233,1827,723,517,943,521,1784,
            591,730,781,264,993,255,258,259,260,261,
            262,263,265,266,267,268,269,270,271,272,
            273,274,275,311,312,77,254,74,75,783,
            5964,136,1500,2123,598,117,231,232,233,502,
            187,231,232,233,674,728,251,253,740,1226,
            2804,1110,194,758,491,2653,246,1322,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,1727,1689,1363,333,334,1523,
            1377,348,1731,1729,1581,289,290,186,22,367,
            288,1030,230,231,232,233,425,725,231,232,
            233,1051,419,1823,287,32,116,2367,1222,781,
            264,993,255,258,259,260,261,262,263,265,
            266,267,268,269,270,271,272,273,274,275,
            311,312,77,254,74,75,783,5964,136,1500,
            2123,364,369,229,231,232,233,287,29,2263,
            1456,674,509,251,253,994,1325,1677,2053,1582,
            26,24,23,10,12,14,15,2402,11,25,
            685,1738,1243,539,1725,303,179,1322,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,1727,1689,1363,333,334,1523,
            1377,348,1731,1729,1581,289,290,287,29,1900,
            288,1030,230,231,232,233,166,725,231,232,
            233,566,367,499,30,329,539,1833,5334,781,
            264,993,255,258,259,260,261,262,263,265,
            266,267,268,269,270,271,272,273,274,275,
            311,312,77,254,74,75,783,5964,136,1500,
            2123,89,287,29,1900,287,47,287,1412,570,
            111,674,636,252,253,318,1322,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,1583,
            1084,1103,1628,1727,1689,1363,333,334,1523,1377,
            348,1731,1729,1581,289,290,539,1837,1685,288,
            1030,287,111,697,93,573,725,231,232,233,
            287,29,1900,634,3043,489,1410,2108,781,264,
            993,255,258,259,260,261,262,263,265,266,
            267,268,269,270,271,272,273,274,275,311,
            312,77,254,74,75,783,5964,136,1500,2123,
            287,2523,573,34,537,2802,44,533,1444,38,
            674,820,252,253,549,2536,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,1727,1689,1363,333,334,1523,1377,348,
            1731,1729,1581,289,290,1049,1162,2854,288,1030,
            1677,2053,1582,26,24,23,10,12,14,15,
            2402,11,25,780,521,331,843,195,264,993,
            281,2532,259,260,261,262,263,265,266,267,
            268,269,270,271,272,273,274,275,311,312,
            1636,2053,1582,26,24,23,10,12,14,15,
            2785,11,25,2262,287,30,573,287,2523,757,
            1944,521,126,2125,509,2531,277,278,279,280,
            549,2536,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,1727,1689,
            1363,333,334,1523,1377,348,1731,1729,1581,289,
            290,539,27,2592,288,1030,1636,2053,1582,26,
            24,23,10,12,14,15,2787,11,25,634,
            1373,132,945,452,264,993,285,2532,259,260,
            261,262,263,265,266,267,268,269,270,271,
            272,273,274,275,311,312,1636,2053,1582,26,
            24,23,10,12,14,15,2797,11,25,165,
            54,757,2037,517,1460,521,287,2492,830,1517,
            361,286,277,278,279,280,549,2536,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,1727,1689,1363,333,334,1523,
            1377,348,1731,1729,1581,289,290,539,27,162,
            288,1030,1636,2053,1582,26,24,23,10,12,
            14,15,2358,2419,25,287,2493,1579,837,295,
            264,993,308,2532,259,260,261,262,263,265,
            266,267,268,269,270,271,272,273,274,275,
            311,312,1636,2053,1582,26,24,23,10,12,
            14,15,2358,2572,25,287,2497,296,2876,135,
            509,199,360,287,1897,287,48,309,277,278,
            279,280,549,2536,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,1583,1084,1103,1628,
            1727,1689,1363,333,334,1523,1377,348,1731,1729,
            1581,289,290,539,2496,932,288,1030,1636,2053,
            1582,26,24,23,10,12,14,15,2358,2573,
            25,222,2526,1033,837,2027,264,993,281,2532,
            259,260,261,262,263,265,266,267,268,269,
            270,271,272,273,274,275,311,312,1636,2053,
            1582,26,24,23,10,12,14,15,1319,11,
            25,287,1945,287,2589,287,1153,783,2497,570,
            2856,2194,1444,2868,277,278,279,280,549,2536,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,1583,1084,1103,1628,1727,1689,1363,333,
            334,1523,1377,348,1731,1729,1581,289,290,539,
            1831,1779,288,1030,1636,2053,1582,26,24,23,
            10,12,14,15,2115,11,25,1484,2222,1650,
            1038,1701,264,993,282,2532,259,260,261,262,
            263,265,266,267,268,269,270,271,272,273,
            274,275,311,312,1636,2053,1582,26,24,23,
            10,12,14,15,1839,11,25,1752,287,111,
            292,453,292,453,1488,837,1898,1670,1803,283,
            277,278,279,280,549,2536,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,1727,1689,1363,333,334,1523,1377,348,
            1731,1729,1581,289,290,539,28,881,288,1030,
            1636,2053,1582,26,24,23,10,12,14,15,
            2800,11,25,2386,661,48,494,1774,264,993,
            313,2532,259,260,261,262,263,265,266,267,
            268,269,270,271,272,273,274,275,311,312,
            539,2648,2156,2322,2265,2330,2349,1694,2357,37,
            2376,43,880,949,207,231,232,233,108,604,
            50,1621,942,385,687,314,277,278,279,280,
            1018,2799,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,229,231,232,233,2175,2207,2180,2210,428,
            2208,446,447,728,1039,635,111,513,206,820,
            1490,537,417,413,2415,2256,217,2257,482,1322,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,1583,1084,1103,1628,1727,1689,1363,333,
            334,1523,1377,348,1731,1729,1581,289,290,76,
            2413,133,288,1030,229,231,232,233,1947,1494,
            2585,302,184,330,550,892,781,596,2875,473,
            483,1835,264,993,2255,258,259,260,261,262,
            263,265,266,267,268,269,270,271,272,273,
            274,275,311,312,266,137,872,999,277,36,
            797,2802,2727,482,1322,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,1583,1084,1103,
            1628,1727,1689,1363,333,334,1523,1377,348,1731,
            1729,1581,289,290,35,1881,1010,288,1030,1254,
            203,1061,860,1022,52,80,1082,1084,158,1085,
            1095,866,628,1119,1137,580,630,264,993,285,
            258,259,260,261,262,263,265,266,267,268,
            269,270,271,272,273,274,275,311,312,1132,
            229,231,232,233,2670,1139,1122,1149,371,1163,
            1141,790,1221,1361,2728,616,2409,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,2253,
            1084,1103,1628,342,340,1363,333,334,341,343,
            348,379,380,2121,383,384,387,393,396,1145,
            1172,2161,2122,2174,2169,2177,240,231,232,233,
            2175,2207,2180,2210,239,2208,1195,690,1112,1186,
            1138,1159,1221,1210,1248,213,1253,1300,839,1835,
            482,1322,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,1727,1689,
            1363,333,334,1523,1377,348,1731,1729,1581,289,
            290,937,1304,1257,288,1030,1332,1133,1251,736,
            1306,1368,1323,1378,125,1415,1370,200,410,1418,
            737,840,2403,241,264,993,308,258,259,260,
            261,262,263,265,266,267,268,269,270,271,
            272,273,274,275,311,312,482,1322,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,1727,1689,1363,333,334,1523,
            1377,348,1731,1729,1581,289,290,889,811,899,
            288,1030,2355,235,2407,2356,1335,1309,1037,1353,
            1252,487,1366,1372,1371,1430,1443,1468,1453,1342,
            264,993,320,258,259,260,261,262,263,265,
            266,267,268,269,270,271,272,273,274,275,
            311,312,354,1482,1486,1491,1531,1498,1425,1533,
            21,1509,1534,1559,1573,1578,786,919,936,2406,
            2408,482,1322,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,1727,
            1689,1363,333,334,1523,1377,348,1731,1729,1581,
            289,290,1521,1579,1584,288,1030,1619,1672,1625,
            1589,909,1673,1586,1622,1633,1540,1635,988,1634,
            1680,1731,1695,1777,1825,264,993,282,258,259,
            260,261,262,263,265,266,267,268,269,270,
            271,272,273,274,275,311,312,482,1322,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,1583,1084,1103,1628,1727,1689,1363,333,334,
            1523,1377,348,1731,1729,1581,289,290,1723,1574,
            1724,288,1030,1727,1733,1734,1830,1735,1859,1901,
            2294,2230,82,2258,2105,1879,1840,1829,1963,2005,
            1749,264,993,313,258,259,260,261,262,263,
            265,266,267,268,269,270,271,272,273,274,
            275,311,312,666,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,396,1781,1836,2161,
            2122,2174,2169,2177,240,231,232,233,2175,2207,
            2180,2210,239,2208,968,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,342,340,1363,333,334,1523,1377,348,
            379,380,2121,383,384,387,393,396,429,1030,
            2161,2122,2174,2169,2177,570,111,570,111,2175,
            2207,2180,2210,428,2208,446,113,570,111,888,
            570,111,2024,1787,1848,1884,2050,2051,1885,2053,
            243,241,1168,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,1583,1084,1103,1628,
            342,340,1363,333,334,1523,1377,348,379,380,
            2121,383,384,387,393,396,429,1030,2161,2122,
            2174,2169,2177,2054,2055,114,1891,2175,2207,2180,
            2210,428,2208,446,356,1887,2056,1892,1923,1924,
            1927,2057,2059,2158,1933,1934,1935,7873,7873,7873,
            7873,2265,7873,2265,7873,7873,7873,7873,7873,7873,
            7873,7873,248,2530,7873,107,2265,107,7873,2340,
            7873,2356,7873,7873,7873,7873,7873,107,7873,7873,
            107,7873,7873,7873,7873,7873,2264,7873,2401,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,2264,629,
            2524,2865,7873,7873,7873,7873,7873,7873,7873,868,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,342,340,1363,
            333,334,1523,1377,348,379,380,2121,383,384,
            387,393,396,429,1030,2161,2122,2174,2169,2177,
            7873,7873,1418,2574,2175,2207,2180,2210,428,2208,
            446,113,716,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2253,1084,1103,1628,
            342,340,1363,333,334,341,343,348,379,380,
            2121,383,384,387,393,396,7873,7873,2161,2122,
            2174,2169,2177,240,231,232,233,2175,2207,2180,
            2210,239,2208,1835,1835,7873,7873,7873,7873,7873,
            114,7873,716,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2253,1084,1103,1628,
            342,340,1363,333,334,341,343,348,379,380,
            2121,383,384,387,393,396,7873,110,2161,2122,
            2174,2169,2177,240,231,232,233,2175,2207,2180,
            2210,239,2208,7873,7873,7873,7873,7873,7873,237,
            241,1168,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,356,7873,487,487,7873,7873,244,
            241,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,179,355,2590,7873,
            2356,1168,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,356,1068,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,2253,1084,
            1103,1628,342,340,1363,333,334,341,343,348,
            379,380,2121,383,384,387,393,388,2591,7873,
            2356,1168,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,356,1068,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,2253,1084,
            1103,1628,342,340,1363,333,334,341,343,348,
            379,380,2121,383,384,387,393,389,2593,7873,
            2356,1168,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,356,1068,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,2253,1084,
            1103,1628,342,340,1363,333,334,341,343,348,
            379,380,2121,383,384,387,393,392,2594,7873,
            2356,868,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,113,1168,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,342,340,1363,333,334,1523,1377,348,
            379,380,2121,383,384,387,393,396,429,1030,
            2161,2122,2174,2169,2177,7873,7873,7873,7873,2175,
            2207,2180,2210,428,2208,446,356,7873,7873,7873,
            7873,7873,114,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,2806,7873,2356,7873,7873,7873,7873,7873,249,
            1168,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,356,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,391,2807,7873,2356,
            1168,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,356,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,386,2809,7873,2356,
            1168,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,356,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,385,2853,7873,2356,
            1168,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,356,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,399,2866,7873,2356,
            1168,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,356,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,398,2872,7873,2356,
            716,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,2253,1084,1103,1628,342,340,
            1363,333,334,341,343,348,379,380,2121,383,
            384,387,393,396,7873,7873,2161,2122,2174,2169,
            2177,240,231,232,233,2175,2207,2180,2210,239,
            2208,1118,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,457,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,228,241,1118,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,342,340,1363,
            333,334,1523,1377,348,379,380,2121,383,384,
            387,393,396,429,1030,2161,2122,2174,2169,2177,
            7873,7873,7873,7873,2175,2207,2180,2210,428,2208,
            446,457,1068,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2253,1084,1103,1628,
            342,340,1363,333,334,341,343,348,379,380,
            2121,383,384,387,393,397,2259,1118,2120,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,1583,1084,1103,1628,342,340,1363,333,334,
            1523,1377,348,379,380,2121,383,384,387,393,
            396,429,1030,2161,2122,2174,2169,2177,7873,7873,
            7873,7873,2175,2207,2180,2210,428,2208,446,457,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,2529,1068,2120,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,1583,
            1084,1103,1628,342,340,1363,333,334,1523,1377,
            348,379,380,2121,383,384,387,393,396,429,
            1030,2161,2122,2174,2169,2177,7873,7873,7873,7873,
            2175,2207,2180,2210,428,2208,446,2117,1068,2120,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,2253,1084,1103,1628,342,340,1363,333,
            334,341,343,348,379,380,2121,383,384,387,
            393,394,2867,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,1583,1084,1103,
            1628,342,340,1363,333,334,1523,1377,348,379,
            380,2121,383,384,387,393,396,429,1030,2161,
            2122,2174,2169,2177,7873,7873,7873,7873,2175,2207,
            2180,2210,428,2208,446,2254,1068,2120,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,342,340,1363,333,334,1523,
            1377,348,379,380,2121,383,384,387,393,396,
            429,1030,2161,2122,2174,2169,2177,7873,7873,7873,
            7873,2175,2207,2180,2210,428,2208,446,2260,1068,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,342,340,1363,
            333,334,1523,1377,348,379,380,2121,383,384,
            387,393,396,429,1030,2161,2122,2174,2169,2177,
            7873,7873,7873,7873,2175,2207,2180,2210,428,2208,
            446,2296,1068,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,1583,1084,1103,1628,
            342,340,1363,333,334,1523,1377,348,379,380,
            2121,383,384,387,393,396,429,1030,2161,2122,
            2174,2169,2177,7873,7873,7873,7873,2175,2207,2180,
            2210,428,2208,446,2297,1068,2120,1476,26,24,
            23,2004,12,14,15,1146,2299,25,1095,1583,
            1084,1103,1628,342,340,1363,333,334,1523,1377,
            348,379,380,2121,383,384,387,393,396,429,
            1030,2161,2122,2174,2169,2177,7873,7873,7873,7873,
            2175,2207,2180,2210,428,2208,446,2117,1068,2120,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,1583,1084,1103,1628,342,340,1363,333,
            334,1523,1377,348,379,380,2121,383,384,387,
            393,396,429,1030,2161,2122,2174,2169,2177,7873,
            7873,7873,7873,2175,2207,2180,2210,428,2208,446,
            2360,1068,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,2361,1068,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,342,340,1363,333,334,1523,1377,348,
            379,380,2121,383,384,387,393,396,429,1030,
            2161,2122,2174,2169,2177,7873,7873,7873,7873,2175,
            2207,2180,2210,428,2208,446,2362,1068,2120,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,1583,1084,1103,1628,342,340,1363,333,334,
            1523,1377,348,379,380,2121,383,384,387,393,
            396,429,1030,2161,2122,2174,2169,2177,7873,7873,
            7873,7873,2175,2207,2180,2210,428,2208,446,2364,
            1068,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,1583,1084,1103,1628,342,340,
            1363,333,334,1523,1377,348,379,380,2121,383,
            384,387,393,396,429,1030,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2207,2180,2210,428,
            2208,446,2488,816,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,1583,1084,1103,
            1628,342,340,1363,333,334,1523,1377,348,379,
            380,2121,383,384,387,393,396,429,1030,2161,
            2122,2174,2169,2177,7873,7873,7873,7873,2175,2207,
            2180,2210,428,2208,446,2495,1068,2120,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,342,340,1363,333,334,1523,
            1377,348,379,380,2121,383,384,387,393,396,
            429,1030,2161,2122,2174,2169,2177,7873,7873,7873,
            7873,2175,2207,2180,2210,428,2208,446,2498,1068,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,342,340,1363,
            333,334,1523,1377,348,379,380,2121,383,384,
            387,393,396,429,1030,2161,2122,2174,2169,2177,
            7873,7873,7873,7873,2175,2207,2180,2210,428,2208,
            446,2528,1068,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,1583,1084,1103,1628,
            342,340,1363,333,334,1523,1377,348,379,380,
            2121,383,384,387,393,396,429,1030,2161,2122,
            2174,2169,2177,7873,7873,7873,7873,2175,2207,2180,
            2210,428,2208,446,357,1068,2120,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,1583,
            1084,1103,1628,342,340,1363,333,334,1523,1377,
            348,379,380,2121,383,384,387,393,396,429,
            1030,2161,2122,2174,2169,2177,7873,7873,7873,7873,
            2175,2207,2180,2210,428,2208,446,2577,1068,2120,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,1583,1084,1103,1628,342,340,1363,333,
            334,1523,1377,348,379,380,2121,383,384,387,
            393,396,429,1030,2161,2122,2174,2169,2177,7873,
            7873,7873,7873,2175,2207,2180,2210,428,2208,446,
            2668,1068,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,342,
            340,1363,333,334,1523,1377,348,379,380,2121,
            383,384,387,393,396,429,1030,2161,2122,2174,
            2169,2177,7873,7873,7873,7873,2175,2207,2180,2210,
            428,2208,446,2669,1068,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,342,340,1363,333,334,1523,1377,348,
            379,380,2121,383,384,387,393,396,429,1030,
            2161,2122,2174,2169,2177,7873,7873,7873,7873,2175,
            2207,2180,2210,428,2208,430,1311,2120,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            1583,1084,1103,1628,1727,1689,1363,333,334,1523,
            1377,348,1731,1729,1581,289,290,7873,1188,1188,
            288,1030,7873,7873,7873,7873,7873,229,231,232,
            233,707,307,7873,7873,833,307,961,7873,781,
            7873,318,1558,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2579,1084,1103,2580,
            342,340,1363,333,334,341,343,348,136,1606,
            2123,7873,229,231,232,233,229,231,232,233,
            7873,316,7873,7873,728,2266,7873,7873,728,1354,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,1583,1084,1103,1628,1727,1689,1363,
            333,334,1523,1377,348,1731,1729,1581,289,290,
            961,7873,7873,288,1030,7873,7873,539,2581,2295,
            229,231,232,233,7873,7873,7873,7873,2415,2415,
            7873,7873,781,7873,318,7873,7873,7873,7873,7873,
            7873,7873,1835,7873,7873,7873,1835,1519,7873,7873,
            7873,7873,363,363,7873,7873,7873,2289,7873,459,
            7873,136,1606,2123,359,358,7873,7873,7873,7873,
            7873,362,7873,177,316,7873,7873,178,2266,1068,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,2253,1084,1103,1628,342,340,1363,
            333,334,341,343,348,379,380,2121,383,384,
            387,393,396,7873,5418,2161,2122,2174,2169,2177,
            7873,7873,2295,7873,2175,2207,2180,2210,427,2208,
            1621,7873,7873,7873,7873,7873,7873,7873,7873,1842,
            7873,2587,7873,7873,7873,7873,7873,999,501,7873,
            7873,7873,7873,7873,362,7873,7873,7873,7873,7873,
            2667,7873,459,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,396,5419,7873,2161,
            2122,2174,2169,2177,7873,7873,7873,7873,2175,2207,
            2180,2489,1068,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2253,1084,1103,1628,
            342,340,1363,333,334,341,343,348,379,380,
            2121,383,384,387,393,396,7873,7873,2161,2122,
            2174,2169,2177,7873,7873,7873,7873,2175,2207,2490,
            1068,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,2253,1084,1103,1628,342,340,
            1363,333,334,341,343,348,379,380,2121,383,
            384,387,393,396,7873,7873,2161,2122,2174,2169,
            2177,7873,7873,7873,7873,2175,2486,1068,2120,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,2253,1084,1103,1628,342,340,1363,333,334,
            341,343,348,379,380,2121,383,384,387,393,
            396,7873,7873,2161,2122,2174,2169,2177,7873,7873,
            7873,1042,2487,1068,2120,1476,26,24,23,10,
            12,14,15,1146,11,25,1095,2253,1084,1103,
            1628,342,340,1363,333,334,341,343,348,379,
            380,2121,383,384,387,393,396,1218,7873,2161,
            2122,2174,2169,2479,1467,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,2253,1084,
            1103,1628,342,340,1363,333,334,341,343,348,
            379,380,2121,7873,7873,395,393,7873,1948,231,
            232,233,7873,7873,7873,7873,7873,7873,7873,7873,
            887,160,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,1729,7873,7873,7873,7873,7873,
            7873,7873,7873,77,103,74,75,783,5964,7873,
            302,7873,7873,7873,7873,185,7873,104,182,183,
            2005,1049,68,2053,1582,26,24,23,10,12,
            14,15,2358,2359,25,79,231,232,233,115,
            141,165,7873,7873,7873,1106,7873,7873,7873,7873,
            95,97,98,99,100,101,102,1566,7873,1044,
            2204,923,724,939,1152,230,7873,7873,7873,7873,
            78,300,7873,1,6580,1068,2120,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,2253,
            1084,1103,1628,342,340,1363,333,334,341,343,
            348,379,380,2121,383,384,387,393,396,7873,
            7873,2161,2122,2174,2482,1068,2120,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,2253,
            1084,1103,1628,342,340,1363,333,334,341,343,
            348,379,380,2121,383,384,387,393,396,1218,
            7873,2161,2122,2174,2485,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,40,43,7873,302,7873,7873,7873,7873,7873,
            1948,231,232,233,7873,7873,7873,7873,7873,7873,
            7873,7873,887,160,7873,7873,7873,7873,7873,7873,
            7873,1395,7873,7873,7873,7873,7873,2357,7873,1106,
            7873,7873,7873,7873,7873,77,103,74,75,783,
            5964,7873,7873,7873,7873,7873,7873,185,7873,104,
            182,183,2005,1049,7873,299,7873,7873,7873,7873,
            7873,7873,1948,231,232,233,7873,7873,7873,7873,
            7873,115,141,165,887,160,7873,7873,7873,7873,
            7873,7873,95,97,98,99,100,101,102,1566,
            7873,1044,2204,923,724,939,1152,77,103,74,
            75,783,5964,7873,7873,2805,6580,7873,7873,185,
            7873,104,182,183,2005,1049,2052,7873,5861,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,115,141,165,7873,7873,7873,7873,
            7873,7873,7873,7873,95,97,98,99,100,101,
            102,1566,7873,1044,2204,923,724,939,1152,7873,
            7873,7873,7873,7873,7873,7873,7873,181,6580,1068,
            2120,1476,26,24,23,10,12,14,15,1146,
            11,25,1095,2253,1084,1103,1628,342,340,1363,
            333,334,341,343,348,379,380,2121,383,384,
            387,393,396,7873,7873,2161,2122,2420,766,2120,
            1476,26,24,23,10,12,14,15,1146,11,
            25,1095,2253,1084,1103,1628,342,340,1363,333,
            334,341,343,348,379,380,2121,383,384,387,
            393,396,7873,7873,2161,2122,2421,1068,2120,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,2253,1084,1103,1628,342,340,1363,333,334,
            341,343,348,379,380,2121,383,384,387,393,
            396,7873,7873,2161,2122,2477,1068,2120,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            2253,1084,1103,1628,342,340,1363,333,334,341,
            343,348,379,380,2121,383,384,387,393,396,
            7873,7873,2161,2122,2537,1517,2120,1476,26,24,
            23,10,12,14,15,1146,11,25,1095,1583,
            1084,1103,1628,1727,1689,1363,333,334,1523,1377,
            348,1731,1729,1581,289,290,7873,7873,7873,288,
            1030,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            318,1517,2120,1476,26,24,23,10,12,14,
            15,1146,11,25,1095,1583,1084,1103,1628,1727,
            1689,1363,333,334,1523,1377,348,1731,1729,1581,
            289,290,7873,7873,7873,288,1030,7873,7873,7873,
            1274,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,318,1011,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,1948,231,232,233,7873,7873,7873,2666,7873,
            7873,7873,7873,887,160,7873,7873,7873,229,231,
            232,233,7873,7873,7873,7873,7873,7873,7873,7873,
            781,7873,7873,7873,7873,7873,77,103,74,75,
            783,5964,7873,7873,7873,7873,7873,2665,185,455,
            104,182,183,2005,1049,7873,7873,7873,7873,136,
            1818,2123,7873,7873,2666,7873,7873,7873,7873,7873,
            7873,7873,115,141,165,7873,2578,7873,7873,7873,
            7873,7873,7873,96,97,98,99,100,101,102,
            1566,7873,1044,2204,923,724,939,1152,7873,7873,
            7873,7873,7873,2873,7873,455,1068,2120,1476,26,
            24,23,10,12,14,15,1146,11,25,1095,
            2253,1084,1103,1628,342,340,1363,333,334,341,
            343,348,379,380,2121,383,384,387,393,396,
            7873,7873,2161,2478,918,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,2253,1084,
            1103,1628,342,340,1363,333,334,341,343,348,
            379,380,2121,383,384,387,393,396,7873,7873,
            2161,2538,1068,2120,1476,26,24,23,10,12,
            14,15,1146,11,25,1095,2253,1084,1103,1628,
            342,340,1363,333,334,341,343,348,379,380,
            2121,383,384,387,393,396,7873,7873,2161,2588,
            1068,2120,1476,26,24,23,10,12,14,15,
            1146,11,25,1095,2253,1084,1103,1628,342,340,
            1363,333,334,341,343,348,379,380,2121,383,
            384,387,393,396,7873,7873,2417,1068,2120,1476,
            26,24,23,10,12,14,15,1146,11,25,
            1095,2253,1084,1103,1628,342,340,1363,333,334,
            341,343,348,379,380,2121,383,384,387,393,
            396,1943,7873,2418,1426,2120,1476,26,24,23,
            10,12,14,15,1146,11,25,1095,1583,1084,
            1103,1628,1727,1689,1363,333,334,1523,1377,348,
            1731,1729,1581,289,290,7873,7873,7873,288,1030,
            7873,7873,2662,231,232,233,7873,7873,7873,7873,
            7873,7873,7873,7873,1221,7873,2083,7873,7873,319,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,341,7873,7873,7873,7873,7873,77,201,74,
            75,783,5964,7873,7873,7873,7873,7873,7873,185,
            7873,202,182,183,2005,1049,7873,2662,231,232,
            233,7873,7873,7873,7873,7873,7873,7873,7873,1221,
            7873,7873,229,231,232,233,205,212,7873,7873,
            7873,7873,7873,7873,781,1985,7873,7873,7873,7873,
            7873,7873,77,223,74,2659,783,5964,7873,199,
            1990,2003,1516,2249,185,7873,224,182,2658,2005,
            1049,7873,7873,136,1884,2123,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,2662,231,232,233,
            133,205,212,7873,7873,7873,197,200,1221,7873,
            7873,2130,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,222,1990,2003,1924,2249,7873,
            7873,77,201,74,75,783,5964,7873,7873,7873,
            7873,7873,7873,185,7873,202,182,183,2005,1049,
            7873,131,2662,231,232,233,7873,7873,2803,7035,
            7873,7873,7873,219,1221,7873,1246,7873,7873,7873,
            205,212,2582,507,2583,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,77,223,74,
            2659,783,5964,199,1990,2003,1516,2249,7873,185,
            7873,224,182,2658,2005,1049,7873,2040,231,232,
            233,7873,7873,7873,7873,7873,2657,7091,7873,7873,
            2048,7873,7873,7873,7873,7873,205,212,7873,54,
            198,200,7873,341,7873,7873,7873,1011,7873,7873,
            7873,7873,77,71,74,75,783,5964,7873,222,
            1990,2003,1924,2249,185,7873,72,182,183,2005,
            1049,2040,231,232,233,7873,7873,7873,7873,7873,
            229,231,232,233,229,231,232,233,229,231,
            232,233,728,7873,7873,7873,781,7873,220,7873,
            781,7873,7873,7873,7873,7873,77,71,74,75,
            783,5964,7873,7873,7873,7873,7873,7873,185,7873,
            72,182,183,2005,1049,136,1884,2123,7873,136,
            1884,2123,7873,7873,7873,7873,7873,7873,60,7873,
            7873,7873,133,7873,7873,7873,134,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            636,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,57,7873,
            7200,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,61,131,7873,7873,7873,132,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,2656,507,2583,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,571,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,670,
            7873,7873,7873,7873,531,7873,0,652,530,0,
            7876,464,0,7886,464,0,7893,464,0,7892,
            464,0,7891,464,0,7890,464,0,7889,464,
            0,7895,464,0,7894,464,0,652,484,0,
            512,510,0,512,510,502,0,510,502,0,
            652,139,0,85,138,0,229,79,0,1273,
            31,538,0,29,32,49,0,29,32,55,
            0,7876,538,0,343,433,0,341,432,0,
            431,378,0,652,143,167,0,143,167,0,
            122,149,0,85,149,0,85,122,149,0,
            86,152,0,86,193,152,0,121,148,0,
            84,121,148,0,84,192,148,0,84,192,
            121,148,0,83,147,0,83,191,147,0,
            120,146,0,82,120,146,0,120,146,170,
            0,146,170,0,82,190,146,0,82,190,
            120,146,0,82,190,120,146,170,0,119,
            145,0,81,119,145,0,119,145,169,0,
            145,169,0,81,189,145,0,81,189,119,
            145,0,81,189,119,145,169,0,118,144,
            0,80,118,144,0,118,144,168,0,144,
            168,0,80,188,144,0,80,188,118,144,
            0,80,188,118,144,168,0,229,117,0,
            229,79,187,0,229,79,187,117,0,229,
            79,117,0,652,485,0,86,193,0,84,
            192,0,83,191,0,82,190,0,81,189,
            0,80,188,0,79,187,0,29,53,0,
            5992,538,0,29,32,0,29,49,0,6407,
            413,0,2300,407,0,652,167,0,652,143,
            0,10,2416,0,2300,410,0,2300,409,0,
            2300,408,0,6407,415,0,6407,414,0,8224,
            500,0,8223,500,0,8222,500,0,8220,500,
            0,8219,500,0,8218,500,0,8217,500,0,
            8226,500,0,8225,500,0,7876,500,0,7895,
            500,0,7894,500,0,7893,500,0,7892,500,
            0,7891,500,0,7890,500,0,7889,500,0,
            7886,500,0,625,500,0,1098,538,500,0,
            4345,500,0,8210,538,500,0,1050,500,0,
            3052,469,0,524,7876,0,2300,411,0,3471,
            467,0,2649,462,0,2060,462,0,478,476,
            0,5435,495,0,2649,463,0,2060,463,0,
            504,7876,0,183,226,0,75,225,0,85,
            210,0,84,192,209,0,84,209,0,79,
            187,207,0,79,207,0,229,207,0,229,
            79,187,207,0,83,191,216,0,80,188,
            208,0,80,208,0,208,215,0,80,188,
            208,215,0,80,188,215,0,652,214,0,
            49,307,0
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            0,0,22,2,0,25,26,27,28,29,
            30,0,32,33,34,35,36,37,38,39,
            40,0,0,23,3,24,4,0,1,0,
            29,0,52,0,1,4,56,57,58,59,
            60,61,62,63,64,65,66,0,21,2,
            50,51,5,6,7,8,9,10,11,0,
            13,0,1,2,42,85,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,50,21,22,104,24,106,0,108,109,
            110,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,0,0,22,0,56,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,100,105,102,103,26,91,28,
            26,0,28,52,0,4,2,56,57,58,
            59,60,61,62,63,64,65,66,0,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,0,0,
            22,69,0,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            88,0,90,2,26,0,28,25,0,0,
            52,0,30,69,56,57,58,59,60,61,
            62,63,64,65,66,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,0,0,22,69,4,
            25,26,27,28,29,30,0,32,33,34,
            35,36,37,38,39,40,0,88,2,90,
            69,0,27,2,0,0,67,52,4,4,
            71,56,57,58,59,60,61,62,63,64,
            65,66,67,85,20,20,71,0,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,43,43,22,
            0,1,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,19,
            20,0,0,0,0,2,0,91,0,52,
            0,95,4,56,57,58,59,60,61,62,
            63,64,65,66,0,1,2,24,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,0,
            44,27,0,1,44,31,0,51,0,1,
            0,51,2,0,0,41,3,43,44,45,
            12,19,14,15,50,0,16,53,72,73,
            74,75,76,77,78,79,80,23,0,0,
            2,0,68,5,6,7,8,9,10,11,
            99,13,46,47,100,81,42,83,0,1,
            86,87,24,89,23,91,92,93,69,95,
            96,0,0,2,3,4,5,6,7,8,
            9,10,11,0,13,44,3,88,0,90,
            2,0,51,22,0,1,25,26,27,28,
            29,30,0,32,33,34,35,36,37,38,
            39,40,24,72,73,74,75,76,77,78,
            79,80,20,52,99,42,0,56,57,58,
            59,60,61,62,63,64,65,66,0,0,
            2,3,4,5,6,7,8,9,10,11,
            0,13,26,0,28,0,3,2,86,0,
            22,2,0,25,26,27,28,29,30,0,
            32,33,34,35,36,37,38,39,40,24,
            0,31,23,44,29,0,24,0,97,98,
            52,41,23,0,56,57,58,59,60,61,
            62,63,64,65,66,0,1,2,3,70,
            5,6,7,8,9,10,11,0,13,0,
            51,4,42,0,0,0,2,22,3,42,
            25,26,27,28,29,30,0,32,33,34,
            35,36,37,38,39,40,23,23,23,24,
            0,46,47,48,49,0,1,2,3,42,
            5,6,7,8,9,10,11,42,13,50,
            20,0,87,23,0,50,0,22,93,0,
            25,26,27,28,29,30,0,32,33,34,
            35,36,37,38,39,40,0,1,2,25,
            107,46,47,48,49,0,1,2,3,23,
            5,6,7,8,9,10,11,0,13,0,
            96,45,43,44,101,0,0,22,3,0,
            25,26,27,28,29,30,0,32,33,34,
            35,36,37,38,39,40,0,0,23,24,
            3,46,47,48,49,0,82,2,3,42,
            5,6,7,8,9,10,11,42,13,23,
            44,42,0,27,2,0,51,22,3,0,
            25,26,3,28,29,30,0,32,33,34,
            35,36,37,38,39,40,70,25,23,24,
            0,46,47,48,49,0,51,2,3,0,
            5,6,7,8,9,10,11,42,13,0,
            101,42,0,1,2,50,0,22,0,0,
            25,26,0,28,29,30,27,32,33,34,
            35,36,37,38,39,40,46,47,0,0,
            24,46,47,48,49,0,24,0,53,2,
            3,42,5,6,7,8,9,10,11,0,
            13,43,44,44,42,89,21,0,0,22,
            3,0,25,26,27,28,29,30,0,32,
            33,34,35,36,37,38,39,40,0,70,
            23,24,53,46,47,48,49,0,0,2,
            3,42,5,6,7,8,9,10,11,42,
            13,0,44,25,3,0,0,50,30,22,
            4,0,25,26,0,28,29,30,0,32,
            33,34,35,36,37,38,39,40,70,68,
            0,44,44,46,47,48,49,0,24,2,
            3,0,5,6,7,8,9,10,11,43,
            13,46,47,23,0,87,42,0,70,22,
            42,93,25,26,27,28,29,30,0,32,
            33,34,35,36,37,38,39,40,67,0,
            0,1,71,46,47,48,49,0,1,2,
            3,0,5,6,7,8,9,10,11,19,
            13,0,0,46,47,3,0,0,0,22,
            31,0,25,26,23,28,29,30,0,32,
            33,34,35,36,37,38,39,40,0,1,
            0,24,0,46,47,48,49,0,97,2,
            3,0,5,6,7,8,9,10,11,42,
            13,0,44,0,0,4,50,4,4,22,
            92,31,25,26,0,28,29,30,4,32,
            33,34,35,36,37,38,39,40,67,0,
            1,0,71,46,47,48,49,0,0,2,
            3,0,5,6,7,8,9,10,11,67,
            13,0,0,71,23,4,0,0,0,22,
            0,20,25,26,0,28,29,30,0,32,
            33,34,35,36,37,38,39,40,0,111,
            42,0,0,46,47,48,49,0,20,2,
            3,0,5,6,7,8,9,10,11,43,
            13,43,20,51,44,0,42,0,27,22,
            53,20,25,26,0,28,29,30,0,32,
            33,34,35,36,37,38,39,40,23,0,
            23,53,3,46,47,48,49,0,1,2,
            0,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,43,21,22,
            20,24,0,0,27,0,1,0,31,4,
            0,0,0,0,1,3,0,12,41,14,
            15,16,17,18,19,12,21,20,0,52,
            17,54,55,0,1,2,20,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,43,21,22,98,24,0,0,
            27,84,3,0,31,0,0,0,0,4,
            0,1,2,3,41,5,6,7,8,9,
            10,11,0,13,82,52,23,54,55,19,
            85,0,22,27,0,25,26,86,28,29,
            30,0,32,33,34,35,36,37,38,39,
            40,20,0,0,1,2,3,84,5,6,
            7,8,9,10,11,0,13,0,3,0,
            0,0,19,51,3,22,68,0,25,26,
            82,28,29,30,43,32,33,34,35,36,
            37,38,39,40,0,1,2,20,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,0,21,22,0,24,0,
            53,27,53,53,0,0,92,2,3,0,
            5,6,7,8,9,10,11,23,13,45,
            23,89,0,0,20,3,52,22,54,55,
            25,26,0,28,29,30,4,32,33,34,
            35,36,37,38,39,40,0,0,2,3,
            3,5,6,7,8,9,10,11,84,13,
            0,0,53,0,3,0,43,0,22,0,
            0,25,3,0,4,29,30,0,32,33,
            34,35,36,37,38,39,40,27,0,20,
            27,0,23,24,48,49,0,24,2,3,
            0,5,6,7,8,9,10,11,43,13,
            0,42,0,0,4,0,4,44,22,0,
            43,25,26,23,28,29,30,0,32,33,
            34,35,36,37,38,39,40,0,0,2,
            3,3,5,6,7,8,9,10,11,82,
            13,0,0,0,81,3,83,0,0,22,
            3,24,25,0,45,0,29,30,0,32,
            33,34,35,36,37,38,39,40,0,1,
            2,23,94,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,0,21,
            0,0,0,50,0,27,43,94,43,31,
            42,0,0,0,0,0,3,2,20,41,
            5,6,7,8,9,10,11,23,13,0,
            1,2,54,55,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,0,
            21,0,0,24,53,43,0,43,2,0,
            31,5,6,7,8,9,10,11,68,13,
            41,20,20,0,0,0,27,0,22,20,
            0,1,2,54,55,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            27,21,0,0,24,3,0,4,0,1,
            0,31,0,0,0,3,3,0,1,45,
            12,41,14,15,16,17,18,19,0,0,
            20,0,1,2,54,55,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,45,21,0,1,24,0,0,0,45,
            0,4,31,0,1,12,0,14,15,16,
            17,18,41,45,21,12,20,14,15,16,
            17,18,0,1,2,54,55,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,0,21,0,3,0,1,0,0,
            50,45,4,31,0,0,0,1,12,0,
            14,15,16,41,20,19,68,0,12,20,
            14,15,16,17,18,19,54,55,0,1,
            2,27,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,0,21,
            54,55,43,0,0,50,0,3,52,31,
            0,0,45,3,0,4,0,0,20,41,
            0,1,2,45,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            84,21,0,0,0,0,0,4,45,43,
            4,31,0,0,0,0,4,4,4,0,
            0,41,0,1,2,45,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,0,21,67,0,0,0,0,0,
            0,0,0,31,0,0,0,0,0,0,
            0,0,20,41,0,1,2,45,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,0,21,0,1,2,0,
            0,0,0,0,0,31,94,0,12,0,
            14,15,0,0,20,41,0,1,2,45,
            24,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,23,0,1,0,
            0,4,0,0,0,0,0,31,0,12,
            0,14,15,16,17,18,19,41,21,20,
            20,0,20,20,0,20,20,23,20,0,
            54,55,0,1,2,0,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,0,21,0,1,2,0,0,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,0,21,22,45,24,0,
            1,2,85,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,0,
            21,44,0,0,0,0,1,0,51,0,
            0,0,0,0,0,0,0,12,44,14,
            15,16,17,18,45,51,21,20,0,72,
            73,74,75,76,77,78,79,80,0,0,
            0,0,0,0,1,0,72,73,74,75,
            76,77,78,79,80,12,0,14,15,16,
            17,18,19,0,21,0,0,0,0,0,
            0,0,1,0,31,0,0,0,0,0,
            1,0,0,12,41,14,15,16,17,18,
            19,12,21,14,15,16,17,18,19,0,
            21,0,31,0,0,0,0,0,1,0,
            31,0,41,0,0,0,1,0,0,12,
            41,14,15,16,17,18,19,12,21,14,
            15,16,17,18,19,0,1,0,31,0,
            0,0,0,0,1,0,31,12,41,14,
            15,16,17,18,19,12,41,14,15,16,
            17,18,19,0,0,0,31,0,0,0,
            0,0,1,0,31,0,41,0,0,0,
            1,0,0,12,41,14,15,16,17,18,
            0,12,21,14,15,16,17,18,0,1,
            21,0,0,0,0,0,0,1,0,0,
            12,0,14,15,16,17,18,0,12,21,
            14,15,16,17,18,0,1,21,24,24,
            0,0,0,0,0,0,1,12,0,14,
            15,16,17,18,0,0,21,12,44,44,
            0,16,0,0,19,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,81,81,83,83,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            522,652,7420,4345,8157,7423,7438,7426,7441,7444,
            7432,7429,7953,7435,7955,7954,7957,7956,7959,709,
            109,7873,1050,7481,7873,1098,3344,892,3254,625,
            8210,7873,8217,8218,8219,8220,8222,8223,8226,8224,
            8225,7873,7873,2411,5386,5992,7940,7873,2261,7873,
            1794,7873,1793,530,7417,8168,932,4433,1940,1942,
            2128,924,980,4121,1775,4486,589,7873,1317,7876,
            135,2939,7886,7889,7893,7895,7894,7891,7892,7873,
            7890,79,7839,7836,1514,498,7836,7836,7836,7836,
            7836,7836,7836,7839,7836,7664,7664,7829,7630,7664,
            7833,5016,187,229,785,229,678,7873,7880,7881,
            7882,498,652,7420,4345,8157,7423,7438,7426,7441,
            7444,7432,7429,7953,7435,7955,7954,7957,7956,7959,
            709,7873,400,1050,292,2363,1098,3344,892,3254,
            625,8210,522,8217,8218,8219,8220,8222,8223,8226,
            8224,8225,522,524,7878,5897,540,8255,1220,8254,
            380,7873,380,1793,7873,8129,7876,932,4433,1940,
            1942,2128,924,980,4121,1775,4486,589,499,652,
            7420,4345,8157,7423,7438,7426,7441,7444,7432,7429,
            7953,7435,7955,7954,7957,7956,7959,709,291,402,
            1050,4242,7873,1098,3344,892,3254,625,8210,522,
            8217,8218,8219,8220,8222,8223,8226,8224,8225,522,
            3943,7873,4033,7876,379,7873,379,2339,7873,462,
            1793,7873,8211,2410,932,4433,1940,1942,2128,924,
            980,4121,1775,4486,589,522,652,7420,4345,8157,
            7423,7438,7426,7441,7444,7432,7429,7953,7435,7955,
            7954,7957,7956,7959,709,7873,7873,1050,4242,8032,
            1098,3344,892,3254,625,8210,426,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,7873,3943,7876,4033,
            2525,452,892,7876,340,342,7792,1793,294,293,
            7795,932,4433,1940,1942,2128,924,980,4121,1775,
            4486,589,2649,7416,294,293,2060,301,652,7420,
            4345,8157,7423,7438,7426,7441,7444,7432,7429,7953,
            7435,7955,7954,7957,7956,7959,709,294,293,1050,
            464,652,1098,3344,892,3254,625,8210,522,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,522,8011,
            506,528,7873,7873,7873,7481,7873,4910,7873,1793,
            7873,5673,8160,932,4433,1940,1942,2128,924,980,
            4121,1775,4486,589,29,7673,7673,5992,7673,7673,
            7673,7673,7673,7673,7673,7673,7673,7673,7673,7673,
            7673,7673,7673,7673,7673,7673,7673,7673,7673,401,
            2114,7673,465,652,2412,7673,403,8307,503,652,
            7873,8314,7876,7873,7873,7673,4539,7673,7673,7673,
            8041,8011,8043,8042,7673,529,1197,7673,8312,8310,
            8316,8308,8309,8317,8318,8311,8313,2252,7873,7873,
            7481,378,7673,7886,7889,7893,7895,7894,7891,7892,
            671,7890,6840,6877,1315,7673,2251,7673,525,652,
            7673,7673,5992,7673,4751,7673,7673,7673,4242,7673,
            7673,7873,422,7876,4345,8157,7886,7889,7893,7895,
            7894,7891,7892,245,7890,7490,2305,3943,7873,4033,
            7876,326,431,1050,139,7460,1098,3344,892,3254,
            625,8210,7873,8217,8218,8219,8220,8222,8223,8226,
            8224,8225,5992,431,431,431,431,431,431,431,
            431,431,8212,1793,671,1514,390,932,4433,1940,
            1942,2128,924,980,4121,1775,4486,589,7873,407,
            7876,4345,8157,7886,7889,7893,7895,7894,7891,7892,
            7873,7890,8255,7873,8254,538,4592,7481,5770,7873,
            1050,7876,520,1098,3344,892,3254,625,8210,109,
            8217,8218,8219,8220,8222,8223,8226,8224,8225,5992,
            7873,937,2252,7682,1794,416,572,7873,2366,451,
            1793,655,2411,7873,2534,4433,1940,1942,2128,2533,
            2535,4121,1775,4486,589,470,652,7876,4645,6726,
            7886,7889,7893,7895,7894,7891,7892,7873,7890,7873,
            2939,7935,2246,508,7873,49,7810,1050,51,977,
            1098,3344,2693,3254,625,8210,7873,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,2584,2252,7473,29,
            10,3763,3853,3434,3673,468,652,7876,4645,1735,
            7886,7889,7893,7895,7894,7891,7892,7477,7890,5069,
            448,7873,6045,7691,532,2213,7873,1050,6085,7873,
            1098,3344,2693,3254,625,8210,332,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,494,652,7783,1712,
            7879,3763,3853,3434,3673,7873,652,7876,4645,4698,
            7886,7889,7893,7895,7894,7891,7892,7873,7890,508,
            8378,8123,657,7912,714,49,410,1050,51,7873,
            1098,3344,2693,3254,625,8210,7873,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,7873,7873,7473,7676,
            2812,3763,3853,3434,3673,7873,1778,7876,4645,2250,
            7886,7889,7893,7895,7894,7891,7892,7477,7890,2494,
            7694,641,7873,2744,7876,49,238,1050,51,50,
            1098,3344,52,3254,625,8210,424,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,6726,2808,7473,29,
            404,3763,3853,3434,3673,7873,6446,7876,4645,7873,
            7886,7889,7893,7895,7894,7891,7892,7477,7890,377,
            714,56,7873,652,7783,1530,538,1050,7873,409,
            1098,3344,538,3254,625,8210,892,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,6840,6877,7873,7873,
            5992,3763,3853,3434,3673,7873,5992,7873,8238,7876,
            4645,1138,7886,7889,7893,7895,7894,7891,7892,7873,
            7890,1154,7960,7697,7469,5722,1733,49,408,1050,
            51,418,1098,3344,2744,3254,625,8210,417,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,7873,6726,
            7473,7676,7906,3763,3853,3434,3673,7873,411,7876,
            4645,1619,7886,7889,7893,7895,7894,7891,7892,7477,
            7890,7873,7700,2654,4804,405,7873,7870,2655,1050,
            7979,460,1098,3344,538,3254,625,8210,29,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,6726,5863,
            7873,6802,7786,3763,3853,3434,3673,466,7670,7876,
            4645,450,7886,7889,7893,7895,7894,7891,7892,1938,
            7890,6840,6877,4963,7873,6045,1514,406,6726,1050,
            7667,6085,1098,3344,2744,3254,625,8210,420,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,2649,7873,
            464,652,2060,3763,3853,3434,3673,7873,652,7783,
            4645,378,7886,7889,7893,7895,7894,7891,7892,8011,
            7890,7873,7873,6840,6877,4857,7873,538,7873,1050,
            8209,463,1098,3344,4751,3254,625,8210,516,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,167,7685,
            7873,5992,461,3763,3853,3434,3673,7873,2366,7876,
            4645,7873,7886,7889,7893,7895,7894,7891,7892,1514,
            7890,7873,2298,7873,7873,8194,5589,8195,8196,1050,
            5817,8208,1098,3344,7873,3254,625,8210,8197,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,7804,143,
            7688,7873,7807,3763,3853,3434,3673,456,7873,7876,
            4645,7873,7886,7889,7893,7895,7894,7891,7892,2649,
            7890,7873,7873,2060,2252,4189,257,7873,315,1050,
            7873,2370,1098,3344,7873,3254,625,8210,7873,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,7873,675,
            1791,7873,11,3763,3853,3434,3673,496,1424,7876,
            4645,7873,7886,7889,7893,7895,7894,7891,7892,1938,
            7890,6914,5904,2992,6764,42,1191,448,5442,1050,
            8249,8243,1098,3344,497,3254,625,8210,7873,8217,
            8218,8219,8220,8222,8223,8226,8224,8225,11,7873,
            4963,8248,5175,3763,3853,3434,3673,514,7447,7453,
            7873,7978,7450,7450,7450,7450,7450,7450,7450,1937,
            7450,1899,1901,591,1898,1841,1795,5122,484,510,
            592,7457,536,7873,892,522,7447,7873,522,7946,
            471,423,7873,477,652,6597,7873,2038,522,2035,
            2036,2032,2033,2007,7958,8088,484,985,7873,8023,
            8089,7996,7997,515,7447,7453,8119,7978,7450,7450,
            7450,7450,7450,7450,7450,1937,7450,1899,1901,591,
            1898,1841,1795,763,484,510,1421,7457,518,7873,
            892,8024,6981,127,522,7873,7873,7873,419,7941,
            458,652,7420,4345,522,7423,7438,7426,7441,7444,
            7432,7429,7873,7435,874,8023,2252,7996,7997,8011,
            526,7873,1050,5431,421,1098,3344,5770,3254,625,
            8210,153,8217,8218,8219,8220,8222,8223,8226,8224,
            8225,8107,425,458,652,7420,4345,8024,7423,7438,
            7426,7441,7444,7432,7429,7873,7435,7873,3111,7873,
            7873,7873,8011,8315,3201,1050,5863,7873,1098,3344,
            577,3254,625,8210,647,8217,8218,8219,8220,8222,
            8223,8226,8224,8225,522,7447,7453,4398,7978,7450,
            7450,7450,7450,7450,7450,7450,1937,7450,1899,1901,
            591,1898,1841,1795,449,484,510,412,7457,7873,
            7985,892,8238,8239,7873,7873,5817,7876,4345,7873,
            7886,7889,7893,7895,7894,7891,7892,2494,7890,514,
            11,5722,7873,492,2446,3291,8023,1050,7996,7997,
            1098,3344,7873,3254,625,8210,8169,8217,8218,8219,
            8220,8222,8223,8226,8224,8225,7873,7873,7876,4645,
            3381,7886,7889,7893,7895,7894,7891,7892,8024,7890,
            7873,7873,8237,7873,7213,469,8366,482,1050,49,
            7873,1098,51,413,7943,625,8210,91,8217,8218,
            8219,8220,8222,8223,8226,8224,8225,6035,7873,7473,
            6966,7873,7473,7676,3434,3673,454,7679,7876,4345,
            46,7886,7889,7893,7895,7894,7891,7892,7780,7890,
            30,7477,7873,258,7942,7873,6485,6368,1050,7873,
            1257,1098,3344,11,3254,625,8210,7873,8217,8218,
            8219,8220,8222,8223,8226,8224,8225,500,7873,7736,
            7770,5489,7760,7757,7745,7739,7742,7751,7748,995,
            7754,7873,7873,7873,6329,5228,1672,7873,45,7777,
            5281,5992,7766,467,8115,7873,7763,7773,7873,7727,
            7724,7721,7718,7715,7712,7730,7709,7733,148,7528,
            7517,11,2541,7517,7517,7517,7517,7517,7517,7517,
            7528,7517,7528,7528,7528,7524,7524,7520,7873,192,
            534,7873,7873,8179,7873,892,7789,276,7217,84,
            1271,7873,483,7873,495,7873,3524,7876,2650,84,
            7886,7889,7893,7895,7894,7891,7892,4751,7890,146,
            7563,7547,121,121,7540,7540,7540,7540,7540,7540,
            7540,7563,7540,7563,7563,7558,7554,7554,7543,7873,
            190,7873,7873,7551,8003,1370,7873,7801,7876,7873,
            82,7886,7889,7893,7895,7894,7891,7892,1312,7890,
            82,2119,8036,7873,7873,7873,6911,7873,8001,8245,
            145,7592,7576,120,120,7569,7569,7569,7569,7569,
            7569,7569,7592,7569,7592,7592,7587,7583,7583,7572,
            6119,189,7873,7873,7580,3620,7873,8183,523,652,
            7873,81,7873,7873,7873,3710,3800,214,7867,8120,
            7953,81,7955,7954,7957,7956,7959,7958,7873,7873,
            8247,144,7621,7605,119,119,7598,7598,7598,7598,
            7598,7598,7598,7621,7598,7621,7621,7616,7612,7612,
            7601,8044,188,86,7646,7609,7873,490,535,8091,
            7873,6181,80,485,7643,7646,7873,7646,7646,7646,
            7646,7646,80,8171,193,8061,2369,8063,8062,8065,
            8064,8066,229,7634,7627,118,118,7627,7627,7627,
            7627,7627,7627,7627,7634,7627,7634,7634,7634,7630,
            7630,7639,488,187,7873,3890,513,652,7873,7873,
            8178,8069,4277,79,486,7873,511,652,7991,317,
            7993,7992,7994,79,8244,7995,1312,7873,8017,8002,
            8019,8018,8021,8020,8025,8022,117,117,7873,7813,
            7813,6119,7813,7813,7813,7813,7813,7813,7813,7813,
            7813,7813,7813,7813,7813,7813,7813,7813,7873,7813,
            7996,7997,6914,7873,7873,8177,204,3980,8023,7813,
            7873,7873,8049,2871,7873,6541,7873,472,2617,7813,
            7873,7816,7816,7813,7816,7816,7816,7816,7816,7816,
            7816,7816,7816,7816,7816,7816,7816,7816,7816,7816,
            8024,7816,7873,7873,7873,7873,7873,8046,7967,1938,
            8045,7816,7873,7873,7873,7873,8047,8094,8084,7873,
            7873,7816,476,7447,7798,7816,8076,7798,7798,7798,
            7798,7798,7798,7798,2664,7798,2035,2036,2661,2663,
            2007,2660,7873,484,4070,7873,7873,7873,7873,7873,
            7873,7873,7873,522,7873,7873,7873,7873,7873,7873,
            7873,7873,1636,522,476,7447,7798,480,8076,7798,
            7798,7798,7798,7798,7798,7798,2664,7798,2035,2036,
            2661,2663,2007,2660,7873,484,143,7493,7497,7873,
            7873,7873,7873,7873,7873,522,1848,7873,7497,7873,
            7497,7497,7873,135,1742,522,149,7506,7500,481,
            7497,7500,7500,7500,7500,7500,7500,7500,7506,7500,
            7506,7506,7506,7503,7503,7506,2411,522,7447,7873,
            7873,7946,7873,7873,140,7873,7873,85,7873,2038,
            7873,2035,2036,2032,2033,2007,7958,85,484,8246,
            3044,7873,2869,2870,7873,8053,1946,2411,2874,7873,
            122,122,522,7447,7798,7873,8100,7798,7798,7798,
            7798,7798,7798,7798,2664,7798,2035,2036,2661,2663,
            2007,2660,7873,484,80,7858,7855,343,7873,7855,
            7855,7855,7855,7855,7855,7855,7858,7855,7661,7661,
            7848,7863,7661,7852,341,188,215,474,215,522,
            7447,7798,527,8100,7798,7798,7798,7798,7798,7798,
            7798,2664,7798,2035,2036,2661,2663,2007,2660,7873,
            484,7484,7873,7873,7873,84,7649,7873,433,7873,
            7873,7873,7873,7873,7873,7873,7873,7649,7487,7649,
            7649,7649,7649,7649,475,432,192,1954,7873,433,
            433,433,433,433,433,433,433,433,7873,7873,
            7873,7873,7873,152,7513,7873,432,432,432,432,
            432,432,432,432,432,7513,7873,7513,7513,7513,
            7513,7513,7510,7873,193,7873,7873,7873,7873,7873,
            7873,147,7536,7873,86,7873,7873,7873,7873,209,
            7822,7873,7873,7536,86,7536,7536,7536,7536,7536,
            7533,7822,191,7649,7649,7822,7649,7649,7826,7873,
            192,7873,83,7873,7873,7873,7873,216,7844,7873,
            84,7873,83,7873,7873,138,7463,7873,7873,7844,
            84,7652,7652,7652,7844,7652,83,85,191,85,
            85,85,85,85,7463,229,7466,7873,83,7873,
            7873,7873,7873,210,7819,7873,85,79,83,79,
            79,79,79,79,7466,7819,85,85,85,7819,
            85,85,7819,7873,7873,7873,79,7873,7873,7873,
            7873,83,7652,7873,85,7873,79,7873,7873,82,
            7655,7873,7873,7652,85,7652,7652,7652,7652,7652,
            7873,7655,191,7655,7655,7655,7655,7655,81,7658,
            190,7873,7873,7873,415,414,80,7661,7873,7873,
            7658,7873,7658,7658,7658,7658,7658,7873,7661,189,
            7661,7661,7661,7661,7661,79,7664,188,7703,7706,
            7873,7873,7873,7873,7873,479,652,7664,7873,7664,
            7664,7664,7664,7664,7873,7873,187,8081,6368,6368,
            7873,8082,7873,7873,8083,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,7873,7873,7873,7873,7873,
            7873,7873,7873,7873,7873,6329,6329,1672,1672
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            1014,1030,1017,1,876,116,498,114,1018,980,
            1017,63,118,791,488,488,490,480,480,296,
            304,690,690,690,183,791,715,662,429,429,
            429,429,690,234,645,708,865,574,440,440,
            662,662,566,441,575,376,376,378,378,662,
            690,194,790,790,762,690,662,242,180,421,
            873,490,888,500,406,406,864,402,958,955,
            958,401,401,401,401,615,621,952,498,394,
            612,612,612,612,612,612,612,1018,498,428,
            429,428,431,433,324,326,436,498,498,28,
            662,662,534,662,1012,368,662,662,439,662,
            452,662,662,457,454,460,459,465,463,467,
            466,469,468,305,498,111,873,731,305,822,
            873,906,194,648,648,498,662,451,662,250,
            503,662,506,791,791,791,662,791,60,421,
            172,498,498,436,406,223,622,498,428,536,
            498,429,370,653,508,169,307,504,791,653,
            490,368,368,724,646,646,662,662,662,662,
            662,490,662,921,662,1012,662,662,662,662,
            662,662,662,662,662,439,429,498,368,381,
            498,388,648,244,569,574,321,793,574,321,
            373,822,822,498,873,662,368,690,368,61,
            690,175,242,498,690,388,245,653,498,436,
            498,317,498,368,368,725,381,658,624,370,
            791,498,822,661,242,498,308,662,762,208,
            436,194,194,725,666,368,574,822,454,454,
            329,459,662,459,459,983,457,463,460,460,
            466,465,504,468,467,873,690,662,690,906,
            490,490,822,659,822,690,690,498,791,242,
            662,242,242,488,824,240,357,498,498,312,
            690,242,309,537,498,57,57,791,428,530,
            241,384,169,498,368,791,650,656,177,690,
            690,690,708,662,459,662,457,662,498,731,
            731,569,569,57,57,731,731,373,917,368,
            368,490,183,648,429,111,498,368,490,382,
            387,822,357,601,242,241,498,534,537,532,
            498,532,498,242,194,735,194,28,662,662,
            194,457,690,368,368,534,661,368,368,690,
            917,504,538,255,917,791,242,436,534,249,
            690,690,435,488,498,387,368,534,490,601,
            601,480,479,486,490,477,477,477,861,861,
            601,475,498,533,237,166,953,368,381,791,
            368,368,731,573,731,534,917,504,504,692,
            254,727,54,731,731,498,436,436,534,864,
            475,534,953,238,731,534,194,762,194,194,
            368,368,690,368,368,647,690,474,223,368,
            791,656,573,731,791,791,368,498,735,194,
            368,391,313,368,791,791,537,791,194
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            31,41,85,66,65,52,63,59,58,60,
            64,57,27,62,56,61,12,15,14,17,
            16,18,104,106,108,109,110,4,19,1,
            26,28,29,32,33,34,35,36,37,39,
            40,38,22,30,3,9,8,6,13,10,
            11,7,5,2,25,0,45,43,0,97,
            98,0,107,31,41,19,1,12,15,14,
            17,16,18,61,56,62,27,4,22,3,
            29,40,38,32,33,34,35,36,37,39,
            28,26,57,64,60,58,59,63,52,65,
            66,2,5,6,13,10,11,7,9,8,
            30,25,0,2,1,100,0,105,31,41,
            19,12,15,14,17,16,18,61,56,62,
            27,4,25,22,30,3,29,40,38,32,
            33,34,35,36,37,39,28,26,57,64,
            60,58,59,63,52,65,66,5,6,13,
            10,11,7,9,8,1,2,0,27,111,
            0,27,101,0,98,97,94,71,67,105,
            107,85,45,31,41,19,1,12,15,14,
            17,16,18,66,65,52,63,59,58,60,
            64,57,4,27,62,56,61,25,30,3,
            29,40,38,32,33,34,35,36,37,39,
            28,26,2,9,8,6,13,10,11,7,
            5,22,0,23,42,0,3,50,45,4,
            43,27,0,25,43,44,82,0,25,24,
            29,2,0,45,71,67,66,65,52,63,
            59,58,60,64,57,26,28,29,32,33,
            34,35,36,37,39,40,38,25,22,30,
            3,4,27,62,56,61,9,8,6,13,
            10,11,7,5,2,1,12,15,14,17,
            16,19,18,41,31,0,24,111,27,82,
            0,27,4,101,23,0,27,82,24,0,
            27,23,0,3,111,42,27,96,86,87,
            68,89,43,50,4,91,53,92,95,45,
            24,81,93,44,17,31,41,83,21,14,
            15,12,16,18,22,23,5,6,7,8,
            9,10,11,13,2,1,19,20,0,2,
            69,0,3,24,0,42,23,26,28,4,
            20,43,0,27,24,42,68,44,43,0,
            4,67,0,20,43,4,45,100,42,3,
            21,54,55,31,41,17,5,6,7,8,
            19,9,10,11,84,13,16,18,52,22,
            24,2,1,12,15,14,0,4,42,0,
            107,0,105,0,96,2,23,0,3,42,
            73,74,75,76,77,78,79,80,51,72,
            23,28,26,69,90,88,47,46,70,44,
            81,83,93,87,68,92,86,89,20,50,
            53,95,91,43,45,4,22,24,21,17,
            31,41,14,15,18,12,16,19,1,5,
            6,13,10,11,7,9,8,2,0,27,
            4,0,4,50,0,56,0,24,17,5,
            6,7,31,8,41,19,9,10,21,11,
            14,15,12,13,16,18,22,51,23,1,
            2,43,4,45,0,20,27,1,49,48,
            3,29,32,33,34,35,36,37,39,40,
            38,9,8,6,13,10,11,7,5,25,
            22,30,47,46,2,28,26,0,43,44,
            23,0,27,23,26,86,46,87,88,68,
            89,20,69,43,90,50,91,53,92,95,
            47,28,24,70,81,93,44,83,22,42,
            45,4,5,6,7,8,9,10,11,13,
            2,31,41,19,12,15,14,17,16,18,
            1,21,0,26,86,46,87,88,68,89,
            69,90,91,3,92,95,47,28,51,70,
            81,93,44,83,24,42,20,23,0,50,
            51,23,4,43,0,94,0,1,43,45,
            27,47,46,26,28,22,30,25,29,5,
            6,13,10,11,7,9,8,2,40,38,
            32,33,34,35,36,37,39,49,48,3,
            0,86,46,87,88,68,89,69,90,91,
            92,95,47,70,81,93,83,26,3,28,
            24,50,42,23,75,76,73,79,72,80,
            74,77,78,44,51,0,20,43,23,0,
            47,46,49,48,20,2,25,22,30,3,
            29,5,6,13,10,11,7,9,8,40,
            38,32,33,34,35,36,37,39,28,26,
            0,47,46,22,30,3,25,29,5,6,
            13,10,11,7,9,8,40,38,32,33,
            34,35,36,37,39,49,48,26,28,2,
            4,0,47,46,22,30,3,25,29,5,
            6,13,10,11,7,9,8,2,40,38,
            32,33,34,35,36,37,39,49,48,26,
            28,53,0,26,4,27,45,28,57,58,
            31,59,60,41,19,61,62,14,15,63,
            16,18,64,52,65,66,56,30,3,25,
            29,40,38,32,33,34,35,36,37,39,
            17,12,1,22,9,8,6,13,10,11,
            7,5,2,24,0,85,22,31,41,21,
            4,17,18,52,84,27,24,5,6,7,
            8,9,10,11,13,2,1,12,15,14,
            16,19,54,55,0,91,5,6,13,10,
            11,7,9,8,2,0,45,71,67,0,
            47,46,22,30,3,25,29,5,6,13,
            10,11,7,9,8,2,40,38,32,33,
            34,35,36,37,39,49,48,26,28,51,
            0,85,45,4,54,55,27,24,5,6,
            7,8,21,9,10,11,84,13,52,22,
            31,41,1,17,14,15,12,18,19,2,
            16,0,28,26,49,48,3,29,32,33,
            34,35,36,37,39,40,38,2,9,8,
            6,13,10,11,7,5,25,22,30,47,
            46,44,0,100,102,103,99,21,31,41,
            12,15,14,17,16,19,18,4,1,85,
            0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            205,60,17,50,172,60,9,76,199,59,
            26,50,50,60,76,150,59,60,60,176,
            60,60,60,60,50,60,39,57,60,60,
            60,60,60,60,167,60,7,60,60,60,
            132,132,60,60,60,60,60,60,60,57,
            60,120,103,103,57,60,57,3,67,150,
            34,59,41,129,76,150,35,60,60,3,
            60,60,60,60,60,43,60,181,81,60,
            60,60,60,60,60,60,60,202,9,60,
            60,60,60,60,167,60,118,59,59,142,
            57,57,60,57,60,60,132,132,60,137,
            60,132,132,60,60,60,60,60,60,60,
            60,60,60,60,59,60,166,57,60,60,
            78,59,120,161,161,9,57,60,57,166,
            60,57,60,60,60,60,57,60,15,76,
            45,37,1,118,76,59,60,59,60,131,
            59,60,59,60,60,30,35,60,60,60,
            59,60,60,60,60,153,132,132,132,132,
            132,59,132,132,132,60,132,132,132,132,
            132,132,57,132,132,60,60,59,60,60,
            59,60,60,63,60,152,97,57,152,97,
            167,60,60,59,167,57,60,60,60,13,
            60,47,95,59,60,60,65,60,83,60,
            59,35,59,60,60,60,60,132,60,59,
            60,118,60,57,19,9,24,57,57,53,
            118,120,86,60,132,60,60,60,60,60,
            60,60,132,60,60,132,60,60,60,60,
            60,60,60,60,60,166,60,57,60,59,
            59,59,60,57,60,60,60,59,60,5,
            57,3,3,209,164,60,192,1,9,45,
            60,101,105,132,21,11,60,60,60,155,
            60,167,30,9,60,60,60,60,60,60,
            60,60,60,132,60,132,60,132,59,57,
            57,60,60,11,60,57,57,167,178,60,
            60,59,50,60,60,60,59,60,59,60,
            115,60,192,188,109,60,9,60,132,11,
            59,60,9,113,120,53,120,142,57,57,
            86,60,60,60,60,60,57,60,60,60,
            170,60,147,49,169,60,3,118,60,166,
            60,60,117,208,9,99,60,60,59,60,
            60,60,60,111,59,60,60,60,76,150,
            188,185,9,32,61,158,172,60,60,60,
            60,60,57,135,57,60,28,60,60,60,
            67,60,59,57,57,118,59,118,60,35,
            196,60,172,135,57,60,120,57,86,86,
            60,60,60,60,60,60,60,60,59,60,
            60,60,135,57,60,60,60,83,53,86,
            60,107,45,60,60,60,132,60,86
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            4,0,54,0,240,0,86,6,2,0,
            145,0,247,0,245,0,203,0,217,0,
            179,178,0,206,0,161,0,119,0,167,
            0,219,0,212,108,0,214,0,248,0,
            112,0,88,0,149,0,186,0,119,100,
            41,95,19,18,26,27,23,24,1,0,
            221,0,196,0,191,0,95,1,19,23,
            18,24,26,27,97,41,0,1,85,0,
            198,0,1,170,0,1,57,26,27,18,
            19,23,24,0,213,0,111,0,158,0,
            229,0,185,0,226,0,232,0,225,0,
            115,0,122,0,194,0,188,96,0,26,
            27,18,19,23,24,1,56,0,210,0,
            235,20,1,0,153,0,23,24,1,6,
            0,26,27,18,19,99,1,23,24,53,
            0,144,120,0,220,53,0,53,152,0,
            120,187,0,20,215,1,86,0,180,154,
            0,147,41,133,0,76,0,243,154,0,
            41,133,123,0,228,41,0,41,79,92,
            0,173,53,171,0,41,175,0,204,41,
            0,41,162,0,53,200,0,150,53,99,
            0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            23,119,12,21,67,69,72,78,85,92,
            94,101,103,99,100,104,65,105,83,13,
            93,115,24,36,106,1,28,34,96,109,
            73,59,60,61,62,63,64,82,97,113,
            79,17,16,42,31,3,33,5,32,20,
            40,108,25,112,116,117,66,68,75,77,
            86,88,102,107,110,114,76,9,14,37,
            70,4,8,11,15,19,27,30,35,38,
            39,81,91,95,118,2,6,7,10,18,
            22,26,41,80,29,48,71,84,90,98,
            111,57,58,49,50,51,52,53,54,55,
            89,43,44,45,46,47,74,87,120
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            121,128,127,126,125,123,0,0,0,122,
            124,0,130,138,139,140,183,217,218,229,
            0,0,230,231,0,215,216,236,0,0,
            238,0,237,0,250,239,240,241,242,243,
            150,0,0,0,244,245,246,247,205,248,
            249,159,172,177,214,210,212,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,149,0,0,146,0,
            148,171,0,170,134,0,0,190,232,0,
            0,187,0,189,211,157,209,0,169,208,
            213,0,0,0,0,0,129,0,0,156,
            160,162,174,182,195,197,201,0,223,234,
            0,147,154,0,0,0,0,0,0,0,
            155,161,163,0,173,0,181,0,0,194,
            0,196,225,235,0,0,153,158,0,167,
            0,186,0,222,0,0,131,133,136,0,
            143,145,0,0,0,0,0,0,165,166,
            0,0,168,176,193,0,200,203,204,221,
            0,0,0,0,0,228,233,0,0,0,
            0,0,0,132,135,0,0,137,141,0,
            0,0,142,144,0,0,151,0,152,164,
            175,178,179,180,0,0,184,0,0,185,
            0,0,0,0,188,191,0,192,198,0,
            199,0,0,0,202,0,206,0,207,219,
            0,0,220,224,226,0,227,251,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            32,62,132,132,23,41,48,292,74,364,
            318,114,177,238,238,143,143,224,278,287,
            352,395,381,386,13,19,55,91,211,274,
            283,391,400,424,439,6,84,102,195,195,
            217,247,123,247,247,154,154,59,81,97,
            106,111,199,204,229,271,308,334,343,449,
            459,229,428,324,186,207,236,269,435,1,
            264,332,264,419,346,406,264,443,311,357,
            311,299,357,371
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            30,71,140,120,30,30,30,109,71,183,
            109,120,183,244,256,149,165,109,30,30,
            215,30,183,183,17,17,30,95,215,215,
            215,215,404,30,109,10,88,88,140,120,
            221,120,127,251,259,158,170,17,30,100,
            109,109,202,202,109,215,215,215,30,215,
            462,232,431,327,189,209,109,109,437,3,
            266,266,416,421,348,408,412,445,313,359,
            337,301,452,373
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            18,19,105,74,18,18,18,177,19,216,
            176,75,67,103,60,105,74,65,44,42,
            217,212,216,216,24,24,18,73,240,111,
            118,213,127,170,128,49,186,71,104,61,
            66,59,75,103,60,105,74,144,20,73,
            72,70,119,119,65,54,229,225,222,122,
            85,65,133,176,67,180,64,98,129,34,
            95,138,99,172,152,127,150,128,92,79,
            91,177,78,216
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            20,20,20,20,20,20,20,4,20,20,
            4,20,20,94,94,4,4,4,20,20,
            45,20,20,20,53,53,20,98,45,45,
            45,45,27,20,4,50,20,20,20,20,
            20,20,50,20,20,4,4,53,20,97,
            4,4,50,50,4,45,45,45,20,45,
            44,50,6,6,56,19,4,4,27,51,
            6,6,6,43,2,24,6,6,1,41,
            21,6,31,42
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static char scopeStateSet[] = {
            151,151,144,227,151,151,151,15,151,74,
            3,227,227,144,227,144,227,227,259,259,
            32,60,74,74,151,151,151,227,30,39,
            114,37,302,34,302,76,45,227,144,227,
            227,227,227,144,227,144,227,48,151,227,
            227,227,18,18,227,120,28,11,1,6,
            62,227,302,3,227,21,227,239,302,185,
            248,13,53,57,24,302,56,302,296,288,
            296,15,288,74
        };
    };
    public final static char scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            154,0,367,170,0,171,91,169,0,50,
            168,0,171,23,139,0,53,0,171,23,
            133,0,206,3,120,204,42,121,0,20,
            0,206,3,120,205,42,25,42,132,0,
            206,3,120,205,42,25,0,206,3,120,
            205,42,136,0,206,3,135,0,171,23,
            0,206,3,205,120,205,29,42,136,0,
            20,272,0,206,3,205,124,205,29,0,
            171,3,0,218,3,97,0,20,173,0,
            365,173,66,0,366,0,173,66,0,364,
            0,171,3,52,0,171,65,0,4,0,
            274,63,0,171,50,218,3,61,0,20,
            175,0,218,3,61,0,50,171,20,175,
            0,301,4,274,4,300,3,61,0,20,
            220,0,274,4,300,3,61,0,4,301,
            20,220,0,300,3,61,0,4,274,4,
            301,20,220,0,4,301,20,175,0,4,
            274,4,301,20,175,0,171,3,56,175,
            60,0,20,4,0,175,60,0,56,3,
            171,20,4,0,171,3,56,0,271,71,
            0,50,0,363,71,0,273,0,219,0,
            361,360,27,0,45,0,171,3,64,0,
            20,359,0,171,50,171,57,0,171,57,
            0,50,171,4,0,174,0,220,20,171,
            3,62,0,94,220,0,171,3,62,0,
            20,220,94,220,0,94,175,0,20,220,
            94,175,0,202,0,129,250,0,214,0,
            225,27,0,264,357,27,0,236,3,121,
            1,0,264,355,27,0,353,3,121,1,
            0,351,20,3,120,129,260,0,260,0,
            129,120,3,20,351,4,0,349,27,0,
            212,0,1,21,120,348,0,268,289,288,
            227,260,0,227,260,0,288,289,268,4,
            0,258,0,346,27,0,21,120,227,343,
            344,0,206,3,0,240,0,120,340,272,
            0,338,264,337,27,0,199,0,41,120,
            286,336,0,206,3,25,205,42,136,0,
            136,0,42,205,25,3,206,20,4,0,
            206,3,25,205,0,206,3,30,205,0,
            225,334,27,0,290,3,333,227,0,268,
            331,255,0,332,0,255,0,331,268,332,
            0,129,307,215,0,129,215,0,292,0,
            43,269,0,290,3,120,0,227,253,0,
            288,289,268,0,252,0,329,0,250,129,
            249,0,249,0,129,250,4,0,265,27,
            0,31,120,227,325,286,241,0,314,24,
            0,44,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            1153,0,7035,6911,0,3044,3043,2369,2037,0,
            1947,0,7035,6911,7091,6966,0,872,1106,2052,
            5861,6035,0,5435,2060,5431,0,1897,0,592,
            0,723,0,1517,1410,0,1456,0,3471,2744,
            2939,1621,1519,0,1089,644,0,5419,5418,5520,
            5437,0,5489,6597,5386,7217,7213,6981,0,939,
            0,1271,1945,1900,1191,1794,1688,1138,1273,641,
            1582,625,1476,5442,0,3980,4277,3890,3800,3710,
            3620,3524,2060,3471,5281,5228,3381,3291,3201,3111,
            5589,5175,2744,5122,4189,5069,2939,5016,4963,4910,
            4857,4804,4751,4698,2812,4645,5334,4592,4539,4486,
            4121,4433,4345,4070,3052,2992,2693,2305,0,2617,
            6181,1325,6119,2119,1106,2541,2446,999,1421,985,
            2370,2213,6580,591,2204,1226,589,2128,892,785,
            678,5897,540,1954,1848,1742,1636,1530,1424,0,
            4070,3052,5589,6802,4398,2992,5442,6764,6446,5904,
            2693,5722,5673,5817,5770,6085,6045,5863,6726,6407,
            6368,6329,4242,4033,3943,6877,6840,2305,3853,3763,
            3673,3434,3344,3254,6541,3980,4277,3890,3800,3710,
            3620,3524,2060,3471,5281,5228,5489,6485,3381,3291,
            3201,3111,5175,2744,5122,6914,4189,5069,2939,5016,
            4963,4910,4857,4804,4751,4698,2812,4645,5334,4592,
            4539,5386,4486,4121,4433,4345,1954,1848,1742,1636,
            2617,1530,2541,2446,1424,2370,2213,2128,1325,1106,
            999,1226,892,785,678,540,0,1325,1106,5489,
            999,5386,1226,892,785,678,540,0,4070,5435,
            2249,1221,2003,7217,2060,5489,3052,7213,5431,2992,
            6981,6597,2693,2305,1101,994,5386,1049,724,887,
            1044,1152,5964,2123,781,728,7209,1325,1106,999,
            1226,892,785,678,540,7035,6911,7091,6966,7200,
            7146,6181,6119,6580,5897,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,308,319,103,102,240,1,172,320,99,
            322,106,104,214,172,203,202,19,160,200,
            199,61,56,62,27,174,154,3,22,134,
            132,25,135,129,121,120,29,139,143,142,
            28,26,147,133,136,138,137,146,145,57,
            64,60,58,59,63,52,65,66,219,256,
            255,249,251,252,172,254,253,19,18,16,
            17,14,15,12,160,213,212,266,100,121,
            18,16,17,14,15,12,160,323,16,121,
            318,120,225,225,121,120,129,41,31,3,
            3,3,225,367,44,171,48,49,120,3,
            147,46,47,156,155,158,157,164,159,166,
            165,169,167,42,42,42,42,3,42,23,
            42,24,50,124,125,205,23,133,23,42,
            171,3,175,304,304,274,3,171,173,172,
            331,227,24,129,172,227,1,21,317,3,
            42,121,42,250,215,120,120,218,300,262,
            202,171,171,44,130,125,46,47,88,90,
            69,83,81,44,24,44,70,68,87,93,
            86,92,91,95,89,120,25,205,206,208,
            204,314,129,91,130,306,239,23,306,239,
            124,171,171,205,29,50,171,56,171,365,
            97,364,268,101,333,326,123,250,288,129,
            21,120,42,236,353,298,354,27,120,42,
            69,43,23,51,286,111,227,50,4,43,
            129,20,20,44,20,275,239,23,155,155,
            130,157,51,157,157,44,156,159,158,158,
            165,164,171,167,166,42,120,43,120,43,
            25,82,23,27,171,205,120,205,171,20,
            3,20,98,3,27,330,3,43,82,289,
            120,120,227,51,43,355,356,69,120,27,
            328,121,325,82,171,274,215,220,176,61,
            56,62,120,20,157,44,156,50,205,3,
            3,130,130,357,358,3,3,120,27,171,
            218,202,334,133,136,205,43,290,202,292,
            124,23,3,27,343,345,82,264,43,337,
            240,339,43,286,20,4,94,3,3,3,
            50,156,120,206,206,264,43,206,206,205,
            360,67,71,273,362,20,20,129,225,42,
            25,30,129,43,68,313,290,349,260,211,
            198,19,16,259,258,160,17,12,172,261,
            350,27,43,264,120,43,27,301,262,300,
            171,171,3,20,3,361,273,271,363,120,
            219,215,205,3,3,307,129,129,346,260,
            347,338,4,340,3,265,20,4,20,20,
            206,206,25,206,206,215,120,250,227,206,
            274,220,20,3,20,20,3,288,4,94,
            206,20,289,301,20,351,67,268,20
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "--",
            "|",
            "-",
            "-=",
            "!",
            "!=",
            "%",
            "%=",
            "&",
            "&&",
            "&=",
            "(",
            ")",
            "*",
            "*=",
            ",",
            ".",
            "/",
            "/=",
            ":",
            ";",
            "?",
            "@",
            "[",
            "]",
            "^",
            "^=",
            "{",
            "||",
            "|=",
            "}",
            "~",
            "+",
            "++",
            "+=",
            "<",
            "<<",
            "<<=",
            "<=",
            "=",
            "==",
            ">",
            ">=",
            ">>",
            ">>=",
            ">>>",
            ">>>=",
            "...",
            "$BeginAction",
            "$EndAction",
            "$BeginJava",
            "$EndJava",
            "$NoAction",
            "$NullAction",
            "$BadAction",
            "$empty",
            "ClassBodyDeclarationsoptMarker",
            "LPGUserActionMarker",
            "IntegerLiteral",
            "LongLiteral",
            "FloatingPointLiteral",
            "DoubleLiteral",
            "CharacterLiteral",
            "StringLiteral",
            "abstract",
            "assert",
            "boolean",
            "break",
            "byte",
            "case",
            "catch",
            "char",
            "class",
            "const",
            "continue",
            "default",
            "do",
            "double",
            "enum",
            "else",
            "extends",
            "false",
            "final",
            "finally",
            "float",
            "for",
            "goto",
            "if",
            "implements",
            "import",
            "instanceof",
            "int",
            "interface",
            "long",
            "native",
            "new",
            "null",
            "package",
            "private",
            "protected",
            "public",
            "return",
            "short",
            "static",
            "strictfp",
            "super",
            "switch",
            "synchronized",
            "this",
            "throw",
            "throws",
            "transient",
            "true",
            "try",
            "void",
            "volatile",
            "while",
            "EOF_TOKEN",
            "IDENTIFIER",
            "ERROR_TOKEN",
            "identifier",
            "Type",
            "PrimitiveType",
            "ReferenceType",
            "ClassOrInterfaceType",
            "TypeVariable",
            "ClassType",
            "TypeName",
            "InterfaceType",
            "ClassName",
            "TypeParameter",
            "AdditionalBoundList",
            "AdditionalBound",
            "TypeArguments",
            "ActualTypeArgumentList",
            "ActualTypeArgument",
            "PackageName",
            "ExpressionName",
            "AmbiguousName",
            "MethodName",
            "PackageOrTypeName",
            "ImportDeclarations",
            "ImportDeclaration",
            "TypeDeclarations",
            "TypeDeclaration",
            "EnumDeclaration",
            "ClassBody",
            "ClassModifiers",
            "ClassModifier",
            "Annotation",
            "TypeParameterList",
            "InterfaceTypeList",
            "ClassBodyDeclarations",
            "ClassBodyDeclaration",
            "VariableDeclarators",
            "VariableDeclarator",
            "VariableDeclaratorId",
            "VariableInitializer",
            "Expression",
            "ArrayInitializer",
            "FieldModifiers",
            "FieldModifier",
            "MethodHeader",
            "MethodBody",
            "ResultType",
            "MethodDeclarator",
            "LastFormalParameter",
            "FormalParameters",
            "FormalParameter",
            "VariableModifiers",
            "VariableModifier",
            "Annotations",
            "MethodModifiers",
            "MethodModifier",
            "ExceptionTypeList",
            "ExceptionType",
            "Block",
            "ConstructorDeclarator",
            "ConstructorBody",
            "SimpleTypeName",
            "ConstructorModifiers",
            "ConstructorModifier",
            "Primary",
            "EnumBody",
            "EnumConstants",
            "EnumConstant",
            "AnnotationTypeDeclaration",
            "InterfaceBody",
            "InterfaceModifiers",
            "InterfaceModifier",
            "ExtendsInterfaces",
            "InterfaceMemberDeclarations",
            "InterfaceMemberDeclaration",
            "ConstantModifiers",
            "ConstantModifier",
            "AbstractMethodModifiers",
            "AbstractMethodModifier",
            "AnnotationTypeBody",
            "AnnotationTypeElementDeclarati" +
            "ons",
            "AnnotationTypeElementDeclarati" +
            "on",
            "ElementValue",
            "ElementValuePairs",
            "ElementValuePair",
            "SimpleName",
            "ConditionalExpression",
            "ElementValues",
            "VariableInitializers",
            "BlockStatements",
            "BlockStatement",
            "Statement",
            "LocalVariableDeclaration",
            "StatementWithoutTrailingSubsta" +
            "tement",
            "StatementNoShortIf",
            "StatementExpression",
            "PostIncrementExpression",
            "PostDecrementExpression",
            "MethodInvocation",
            "ClassInstanceCreationExpressio" +
            "n",
            "SwitchBlock",
            "SwitchBlockStatementGroups",
            "SwitchBlockStatementGroup",
            "SwitchLabels",
            "SwitchLabel",
            "ConstantExpression",
            "StatementExpressionList",
            "Catches",
            "Finally",
            "CatchClause",
            "PrimaryNoNewArray",
            "FieldAccess",
            "ArrayAccess",
            "ArgumentList",
            "DimExprs",
            "Dims",
            "DimExpr",
            "PostfixExpression",
            "UnaryExpression",
            "UnaryExpressionNotPlusMinus",
            "MultiplicativeExpression",
            "AdditiveExpression",
            "ShiftExpression",
            "RelationalExpression",
            "EqualityExpression",
            "AndExpression",
            "ExclusiveOrExpression",
            "InclusiveOrExpression",
            "ConditionalAndExpression",
            "ConditionalOrExpression",
            "AssignmentExpression",
            "LeftHandSide",
            "AssignmentOperator"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
