
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2007 IBM Corporation.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
//Contributors:
//    Philippe Charles (pcharles@us.ibm.com) - initial API and implementation

////////////////////////////////////////////////////////////////////////////////

package org.eclipse.imp.lpg.parser;

public interface LPGLexersym {
    public final static int
      Char_CtlCharNotWS = 102,
      Char_LF = 7,
      Char_CR = 8,
      Char_HT = 1,
      Char_FF = 2,
      Char_a = 15,
      Char_b = 40,
      Char_c = 24,
      Char_d = 30,
      Char_e = 5,
      Char_f = 36,
      Char_g = 44,
      Char_h = 52,
      Char_i = 13,
      Char_j = 68,
      Char_k = 48,
      Char_l = 17,
      Char_m = 31,
      Char_n = 26,
      Char_o = 22,
      Char_p = 32,
      Char_q = 56,
      Char_r = 11,
      Char_s = 20,
      Char_t = 9,
      Char_u = 38,
      Char_v = 50,
      Char_w = 54,
      Char_x = 42,
      Char_y = 46,
      Char_z = 69,
      Char__ = 27,
      Char_A = 16,
      Char_B = 41,
      Char_C = 25,
      Char_D = 33,
      Char_E = 6,
      Char_F = 37,
      Char_G = 45,
      Char_H = 53,
      Char_I = 14,
      Char_J = 70,
      Char_K = 49,
      Char_L = 18,
      Char_M = 34,
      Char_N = 28,
      Char_O = 23,
      Char_P = 35,
      Char_Q = 57,
      Char_R = 12,
      Char_S = 21,
      Char_T = 10,
      Char_U = 39,
      Char_V = 51,
      Char_W = 55,
      Char_X = 43,
      Char_Y = 47,
      Char_Z = 71,
      Char_0 = 58,
      Char_1 = 59,
      Char_2 = 60,
      Char_3 = 61,
      Char_4 = 62,
      Char_5 = 63,
      Char_6 = 64,
      Char_7 = 65,
      Char_8 = 66,
      Char_9 = 67,
      Char_AfterASCII = 72,
      Char_Space = 3,
      Char_DoubleQuote = 97,
      Char_SingleQuote = 98,
      Char_Percent = 74,
      Char_VerticalBar = 75,
      Char_Exclamation = 76,
      Char_AtSign = 77,
      Char_BackQuote = 78,
      Char_Tilde = 79,
      Char_Sharp = 92,
      Char_DollarSign = 100,
      Char_Ampersand = 80,
      Char_Caret = 81,
      Char_Colon = 82,
      Char_SemiColon = 83,
      Char_BackSlash = 84,
      Char_LeftBrace = 85,
      Char_RightBrace = 86,
      Char_LeftBracket = 93,
      Char_RightBracket = 94,
      Char_QuestionMark = 73,
      Char_Comma = 4,
      Char_Dot = 87,
      Char_LessThan = 99,
      Char_GreaterThan = 95,
      Char_Plus = 88,
      Char_Minus = 29,
      Char_Slash = 89,
      Char_Star = 90,
      Char_LeftParen = 96,
      Char_RightParen = 91,
      Char_Equal = 19,
      Char_EOF = 101;

    public final static String orderedTerminalSymbols[] = {
                 "",
                 "HT",
                 "FF",
                 "Space",
                 "Comma",
                 "e",
                 "E",
                 "LF",
                 "CR",
                 "t",
                 "T",
                 "r",
                 "R",
                 "i",
                 "I",
                 "a",
                 "A",
                 "l",
                 "L",
                 "Equal",
                 "s",
                 "S",
                 "o",
                 "O",
                 "c",
                 "C",
                 "n",
                 "_",
                 "N",
                 "Minus",
                 "d",
                 "m",
                 "p",
                 "D",
                 "M",
                 "P",
                 "f",
                 "F",
                 "u",
                 "U",
                 "b",
                 "B",
                 "x",
                 "X",
                 "g",
                 "G",
                 "y",
                 "Y",
                 "k",
                 "K",
                 "v",
                 "V",
                 "h",
                 "H",
                 "w",
                 "W",
                 "q",
                 "Q",
                 "0",
                 "1",
                 "2",
                 "3",
                 "4",
                 "5",
                 "6",
                 "7",
                 "8",
                 "9",
                 "j",
                 "z",
                 "J",
                 "Z",
                 "AfterASCII",
                 "QuestionMark",
                 "Percent",
                 "VerticalBar",
                 "Exclamation",
                 "AtSign",
                 "BackQuote",
                 "Tilde",
                 "Ampersand",
                 "Caret",
                 "Colon",
                 "SemiColon",
                 "BackSlash",
                 "LeftBrace",
                 "RightBrace",
                 "Dot",
                 "Plus",
                 "Slash",
                 "Star",
                 "RightParen",
                 "Sharp",
                 "LeftBracket",
                 "RightBracket",
                 "GreaterThan",
                 "LeftParen",
                 "DoubleQuote",
                 "SingleQuote",
                 "LessThan",
                 "DollarSign",
                 "EOF",
                 "CtlCharNotWS"
             };

    public final static int numTokenKinds = orderedTerminalSymbols.length;
    public final static boolean isValidForParser = true;
}
