
////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2007 IBM Corporation.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
//Contributors:
//    Philippe Charles (pcharles@us.ibm.com) - initial API and implementation

////////////////////////////////////////////////////////////////////////////////

package org.eclipse.imp.lpg.parser;

public class LPGLexerprs implements lpg.runtime.ParseTable, LPGLexersym {
    public final static int ERROR_SYMBOL = 0;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 0;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 0;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 0;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 1082;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 102;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 7246;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 1136;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 193;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 295;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 1492;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 0;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 101;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 103;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 6109;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 6110;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return LPGLexersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,1,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,1,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,1,1,0,0,1,0,
            1,0,1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            107,108,16,31,29,20,12,23,30,26,
            14,25,15,24,17,27,32,13,35,18,
            36,22,33,19,11,34,28,21,37,38,
            54,112,74,113,114,109,47,56,57,41,
            111,91,118,40,4,100,119,120,123,124,
            126,127,128,133,134,135,140,144,145,146,
            151,152,155,157,160,164,168,169,170,171,
            172,173,174,175,176,177,183,184,186,188,
            189,192,193,39,45,49,50,53,58,61,
            66,69,72,79,89,92,102,103,104,106,
            110,115,117,121,122,129,130,131,132,136,
            137,141,142,143,147,148,149,150,153,154,
            158,159,161,162,163,165,166,167,178,179,
            180,181,182,191,2,3,5,6,7,8,
            9,10,42,43,44,46,48,51,52,55,
            59,60,62,63,64,65,67,68,70,71,
            73,75,76,77,78,80,81,82,83,84,
            85,86,87,88,90,93,94,95,96,97,
            98,99,101,105,116,125,138,139,156,185,
            187,190,1
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,1,1,1,1,1,1,2,1,1,
            2,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,2,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,0,2,0,2,1,2,2,2,
            3,2,1,2,1,1,1,1,0,2,
            3,2,1,2,1,1,1,1,0,2,
            3,2,1,2,1,1,1,1,0,2,
            3,2,5,5,5,1,1,1,3,3,
            4,1,2,2,1,1,1,1,2,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,2,1,1,
            2,3,4,5,6,7,2,2,2,3,
            4,5,2,3,4,2,2,3,4,5,
            6,7,8,9,2,1,2,1,1,2,
            2,2,3,3,5,3,8,1,0,1,
            1,2,4,1,1,1,1,2,3,2,
            1,1,1,2,1,1,1,0,2,1,
            3,1,18,12,2,1,1,1,6,13,
            2,6,8,2,2,3,10,2,3,6,
            13,2,1,6,9,2,3,9,2,3,
            4,2,3,9,6,13,2,6,8,6,
            8,6,8,2,3,5,2,3,4,2,
            3,10,2,6,6,6,10,14,18,16,
            2,1,1,2,3,6,18,2,6,7,
            6,11,2,6,6,2,3,5,2,3,
            6,2,3,12,2,18,7,6,8,2,
            6,16,2,6,17,19,2,2,3,6,
            10,4,2,2,2,3,4,6,6,6,
            9,2,2,3,6,5,9,7,7,2,
            3,8,2,6,9,2,6,13,2,2,
            3,12,2,6,7,6,21,10,2,6,
            6,2,3,8,6,20,2,1,3,1,
            3,4,3,6,2,6,8,2,2,3,
            5,2,3,11,2,2,3,15,2,2,
            3,6,2,3,9,2,3,13,2,2,
            3,18,2,2,3,3,2,3,13,4,
            2,2,3,6,6,6,6,8,2,6,
            8,2,6,8,18,8,2,3,6,5,
            2,3,6,5,1,9,4,2,3,6,
            9,1,4,9,13,2,2,3,7,2,
            3,6,7,1,7,8,6,12,2,2,
            3,8,2,3,4,10
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            135,135,135,135,135,135,135,135,135,135,
            135,135,135,135,135,25,25,25,25,25,
            25,25,25,25,25,7,7,18,18,11,
            11,13,13,3,3,15,15,20,20,24,
            24,6,6,28,28,22,22,8,8,14,
            14,12,12,10,10,16,16,27,27,5,
            5,9,9,4,4,17,17,23,23,26,
            26,19,19,21,21,29,29,30,30,30,
            30,30,30,30,30,30,30,30,30,30,
            30,30,30,30,30,30,30,30,30,30,
            30,30,30,30,30,84,84,84,44,44,
            44,143,143,143,143,143,143,143,143,143,
            143,143,143,143,143,143,143,143,143,143,
            143,143,143,143,143,143,143,143,144,144,
            144,144,144,144,144,144,144,144,144,144,
            144,144,144,144,144,144,144,144,144,144,
            144,144,144,144,144,144,144,145,145,145,
            145,145,145,145,145,145,145,145,145,145,
            145,145,145,145,145,145,145,145,145,145,
            145,145,145,145,145,145,85,85,85,85,
            85,85,85,85,85,85,85,85,85,85,
            85,85,85,85,85,85,85,85,85,85,
            85,85,85,85,85,146,146,146,146,146,
            146,146,146,146,146,146,146,146,146,146,
            146,146,146,146,146,146,146,146,146,146,
            146,146,146,146,37,37,37,37,37,37,
            37,37,37,37,37,37,37,37,37,37,
            37,37,37,37,37,37,37,37,37,37,
            37,37,37,37,147,147,147,147,147,147,
            147,147,147,147,147,147,147,147,147,147,
            147,147,147,147,147,147,147,147,147,147,
            147,40,40,40,40,40,40,40,40,40,
            40,40,40,40,40,40,40,40,40,40,
            40,40,40,40,40,40,40,40,40,40,
            86,86,86,86,86,86,86,86,86,86,
            86,86,86,86,86,86,86,86,86,86,
            86,86,86,86,86,86,86,86,86,87,
            87,87,87,87,87,87,87,87,87,87,
            87,87,87,87,87,87,87,87,87,87,
            87,87,87,87,87,87,87,87,148,148,
            148,148,148,148,148,148,148,148,148,148,
            148,148,148,148,148,148,148,148,148,148,
            148,148,148,148,148,148,148,148,149,149,
            149,149,149,149,149,149,149,149,149,149,
            149,149,149,149,149,149,149,149,149,149,
            149,149,149,149,149,149,149,149,88,88,
            88,88,88,88,88,88,88,88,88,88,
            88,88,88,88,88,88,88,88,88,88,
            88,88,88,88,88,88,88,88,31,31,
            31,31,31,31,31,31,31,31,31,31,
            31,31,31,31,31,31,31,31,31,31,
            31,31,150,150,150,150,150,150,150,150,
            150,150,150,150,150,150,150,150,150,150,
            150,38,38,39,39,39,39,136,136,89,
            89,89,89,89,89,151,151,151,151,151,
            151,152,152,152,152,152,152,90,90,90,
            90,90,90,153,153,154,154,155,155,45,
            45,141,142,156,156,91,91,91,91,157,
            157,157,157,158,158,92,92,92,92,159,
            159,159,159,160,160,93,93,93,93,161,
            161,161,161,140,140,140,139,139,139,33,
            33,33,138,138,138,164,164,164,163,163,
            94,94,94,94,94,94,94,94,94,94,
            94,94,94,94,94,94,94,94,94,94,
            94,94,94,94,94,94,94,166,166,166,
            166,166,166,166,166,166,166,166,166,166,
            166,166,166,166,166,166,166,166,166,166,
            166,166,166,166,167,167,167,167,167,167,
            167,167,167,167,167,167,167,167,167,167,
            167,167,167,167,167,167,167,167,167,167,
            167,168,168,168,168,168,168,168,168,168,
            168,168,168,168,168,168,168,168,168,168,
            168,168,168,168,168,168,168,168,169,169,
            169,169,169,169,169,169,169,169,169,169,
            169,169,169,169,169,169,169,169,169,169,
            169,169,169,169,169,170,170,170,170,170,
            170,170,170,170,170,170,170,170,170,170,
            170,170,170,170,170,170,170,170,170,170,
            170,170,171,171,172,172,172,173,173,173,
            174,174,174,95,95,95,175,175,175,42,
            42,42,165,165,165,96,96,96,176,176,
            176,177,177,177,178,178,178,179,179,179,
            180,180,180,162,162,181,181,181,181,181,
            181,181,181,181,181,181,181,182,182,182,
            182,182,182,182,182,182,182,182,182,182,
            182,182,182,182,182,182,46,46,137,183,
            183,97,97,97,97,97,99,98,100,36,
            36,36,101,41,32,32,32,34,34,34,
            34,35,35,35,35,1,1,1,2,2,
            184,184,185,102,103,103,43,47,48,102,
            104,104,102,105,105,102,102,49,102,102,
            102,50,50,186,186,186,102,102,51,102,
            102,52,102,102,53,102,106,106,102,107,
            102,108,102,109,102,102,54,102,102,55,
            102,102,56,56,102,110,102,102,102,102,
            111,111,187,188,102,102,102,57,57,102,
            112,102,113,113,102,114,102,102,58,102,
            102,59,102,102,60,60,102,115,102,116,
            116,102,117,117,102,118,118,118,102,102,
            102,61,61,61,61,102,102,62,102,119,
            102,120,120,102,102,102,63,189,189,189,
            102,102,64,64,102,121,121,102,122,122,
            102,102,65,65,102,123,102,124,124,124,
            102,125,102,102,66,102,126,126,127,127,
            127,127,127,127,127,127,102,128,128,102,
            102,67,102,102,68,68,102,102,69,69,
            102,102,70,102,102,71,102,102,72,72,
            102,102,73,73,102,102,74,102,102,75,
            75,75,102,102,76,102,129,102,130,130,
            102,131,131,102,132,102,133,102,102,102,
            77,102,102,102,78,190,190,190,102,102,
            102,79,191,191,191,191,191,102,102,80,
            102,102,102,81,192,192,192,102,134,134,
            102,102,82,102,102,83,83,4454,917,1915,
            1298,1572,1301,1357,1167,1225,3219,1571,1264,1309,
            1159,1653,1436,1221,716,1158,1922,1573,4694,4971,
            1359,1453,2093,1360,3128,3131,3178,4760,6429,4541,
            3135,1414,927,3661,912,862,1877,864,2109,3088,
            901,5113,3565,5109,1169,895,3556,3555,3552,3551,
            3514,3471,3467,3466,3425,3384,3383,3377,3299,3296,
            3285,3251,3242,3177,3089,2192,2191,2188,2187,2112,
            2053,2052,2049,2048,1878,1836,1835,1795,1794,1753,
            1222,4843,1019,715,1713,5171,1445,1029,1667,1037,
            1023,3647,3295,994,6165,3596,1048,1139,1408,890,
            3564,3560,3559,3513,3510,3509,3474,3429,3428,3424,
            3390,3387,3374,3373,3334,3333,3292,3286,3246,3245,
            3237,3231,3181,3139,4561,3134,2008,2007,2004,2003,
            1923,1754,861,4512,2094,7279,1298,1572,1301,1357,
            1167,1225,3219,1571,1264,1309,1159,1653,1436,1221,
            1018,1158,1922,1573,1031,3057,1359,1453,4795,1360,
            3128,4812,951,1924,2096,1059,1055,3289,3973,5012,
            1607,3338,943,2235,958,4469,3650,1636,1712,872,
            1013,1409,3556,3555,3552,3551,3514,3471,3467,3466,
            3425,3384,3383,3377,3299,3296,3285,3251,3242,3177,
            3089,2192,2191,2188,2187,2112,2053,2052,2049,2048,
            1878,1836,1835,1795,1794,1753,1222,4876,6203,5041,
            4619,983,3707,1129,4615,3705,3806,3843,3220,3602,
            987,3646,980,4327,1408,891,3564,3560,3559,3513,
            3510,3509,3474,3429,3428,3424,3390,3387,3374,3373,
            3334,3333,3292,3286,3246,3245,3237,3231,3181,3139,
            6972,3134,2008,2007,2004,2003,1923,1754,4570,5166,
            2002,1425,1921,1301,5118,1433,1225,1635,3945,1264,
            1658,4244,4967,1358,1661,4884,1158,1922,1573,4457,
            1924,1876,918,5140,1360,3128,4994,4816,3338,943,
            912,958,1310,3601,4944,5053,3220,863,4602,3146,
            1169,4487,963,2022,2843,4601,3597,4414,4379,4376,
            4375,4372,4371,4368,4367,4364,4363,4356,4355,4293,
            4290,4289,4285,4281,4277,4276,4272,4271,4268,4263,
            4258,4255,4252,4238,4198,4197,4194,4193,4124,4057,
            3972,3913,1,4337,6174,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,6444,4702,1798,860,1234,1137,5057,
            1582,537,538,538,5056,1516,889,3478,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5286,4802,5033,6161,6482,3885,2339,3704,5286,3888,
            5460,5461,1119,3517,1019,1016,975,1092,3599,859,
            1234,1137,4020,3094,1273,880,880,880,880,880,
            880,880,880,880,880,880,880,880,880,880,
            880,880,880,880,880,880,880,880,880,880,
            880,880,880,880,880,4786,889,1223,1494,3,
            2269,5,6,1493,1373,4668,4687,4616,3669,3652,
            4463,3842,1757,3658,5192,3841,3470,4264,1069,4471,
            856,1073,4464,4593,1798,3810,618,1081,5181,3660,
            1644,5003,2235,2699,1002,3650,4945,4753,4825,1013,
            1023,3224,2095,1798,3611,1429,1718,889,4603,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,877,881,
            1592,5611,6441,4649,889,4980,4674,1718,889,5611,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5627,1019,1019,2099,2195,1120,1718,889,
            5627,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            877,881,1592,5628,1019,1019,3058,3189,1220,1718,
            889,5628,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,877,881,1592,5634,1019,1019,3745,3776,1221,
            1718,889,5634,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,877,881,1592,5914,5194,5216,1019,3707,
            3807,2411,4949,3806,1321,1718,889,5914,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5917,4012,4444,1019,4481,3844,4946,3706,4947,4467,
            1718,889,5917,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,877,881,1592,5920,1718,889,8306,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,877,881,
            1592,5923,4708,1019,1019,3846,3849,1019,1019,3851,
            3889,1718,889,5923,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,6036,3565,1019,1019,
            3893,3895,1019,1019,3897,3900,8310,1718,889,6036,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,6039,4643,6143,6443,4558,6170,5009,6538,
            889,1116,3853,4605,5032,6039,4457,5412,2483,5243,
            4604,4459,1019,4456,3902,1718,889,5920,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            6043,1819,889,1322,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,6044,1019,1019,3904,
            3907,1019,1019,3909,3911,4500,889,1718,889,6044,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5071,1718,889,6966,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,877,881,1592,5236,4308,
            6110,4484,613,613,613,613,613,613,613,613,
            613,613,613,613,613,613,613,613,613,613,
            613,613,613,613,614,613,613,613,613,613,
            6110,1718,889,6043,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,5239,1718,889,6967,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5244,1718,889,4600,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,877,881,1592,5247,1718,
            889,6990,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,877,881,1592,5248,1718,889,3125,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5252,1718,889,7002,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,5255,1718,889,4970,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5256,1718,889,7003,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,877,881,1592,5259,1718,
            889,4972,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,877,881,1592,5266,1718,889,7006,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5267,1718,889,1168,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,5270,1718,889,7026,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5274,1718,889,4999,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,877,881,1592,5275,1718,
            889,7034,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,877,881,1592,5279,1718,889,5007,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5282,1718,889,7042,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,5290,1718,889,5014,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,877,
            881,1592,5291,1718,889,7056,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,877,881,1592,5294,1718,
            889,5038,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,877,881,1592,5295,1718,889,817,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,877,881,1592,
            5301,1718,889,6110,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,877,881,1592,5302,102,6185,889,
            580,580,580,580,580,580,580,580,580,580,
            580,580,580,580,580,580,580,580,580,580,
            580,580,580,580,580,580,580,580,5261,1019,
            4572,3947,4458,873,203,580,580,600,600,600,
            600,600,600,600,600,600,600,600,600,600,
            600,600,600,600,600,600,600,600,600,600,
            600,600,600,600,600,6251,5697,6483,4960,5095,
            5504,5109,600,600,1019,1809,3952,5408,5097,1019,
            4004,3954,1400,2555,580,3600,304,6110,580,590,
            590,590,590,590,590,590,590,590,590,590,
            590,590,590,590,590,590,590,590,590,590,
            590,590,590,590,590,590,590,1019,5279,3958,
            600,1019,2627,3960,590,590,590,600,4381,6542,
            889,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3252,3520,3520,3520,3520,3520,4623,
            1910,4834,3669,3652,4877,3842,5463,3658,4251,3841,
            3470,1019,1069,3962,1089,1073,3657,1019,590,3964,
            3651,1081,1019,3660,3966,1019,1019,3968,3970,857,
            5689,1019,405,4005,3302,581,581,581,581,581,
            581,581,581,581,581,581,581,581,581,581,
            581,581,581,581,581,581,581,581,581,581,
            581,581,581,4711,889,1019,1019,4035,4037,6361,
            581,581,1019,5264,4039,4779,1019,1574,4041,1019,
            4468,4043,506,4380,3342,601,601,601,601,601,
            601,601,601,601,601,601,601,601,601,601,
            601,601,601,601,601,601,601,601,601,601,
            601,601,601,1019,1019,4045,4047,6110,1510,581,
            601,601,607,581,4415,591,591,591,591,591,
            591,591,591,591,591,591,591,591,591,591,
            591,591,591,591,591,591,591,591,591,591,
            591,591,591,1019,1019,4049,4051,1019,7015,4053,
            591,591,591,1019,1019,4055,4091,1019,601,4122,
            1019,4992,4128,1213,889,601,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,1019,1019,4131,4133,1019,1019,
            4135,4137,6110,5260,591,1314,889,5260,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,1019,1019,4139,4141,
            6227,1019,5263,4143,1019,5287,4145,5260,708,5287,
            4612,570,570,570,570,570,570,570,570,570,
            570,570,570,570,570,570,570,570,570,570,
            570,570,570,570,570,570,570,570,570,1019,
            1019,4147,4149,1019,1019,4151,4185,5297,570,5287,
            1415,4470,570,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1019,1019,4187,4189,1019,1019,4191,4326,1019,
            1019,4359,4417,6110,1019,1011,4421,570,570,570,
            570,570,570,570,570,570,570,570,570,570,
            570,570,570,570,570,570,570,570,570,570,
            570,570,570,570,570,570,1019,4878,4454,5315,
            4956,6395,6430,2771,3378,570,4496,6110,1839,570,
            567,1920,4479,4473,855,855,855,855,855,855,
            855,855,855,855,855,855,855,855,855,855,
            855,855,855,855,855,855,855,855,855,855,
            855,855,4877,4887,5467,5469,4622,4539,855,6305,
            4831,6294,6445,855,570,6066,4482,4783,6178,4494,
            6349,6976,4120,1076,4485,2915,4609,857,857,6968,
            985,4960,4608,2020,4565,4294,846,846,846,846,
            846,846,846,846,846,846,846,846,846,846,
            846,846,846,846,846,846,846,846,846,846,
            846,846,846,846,6969,6971,2122,6975,6110,4710,
            846,1523,4706,2120,4613,846,839,839,839,839,
            839,839,839,839,839,839,839,839,839,839,
            839,839,839,839,839,839,839,839,839,839,
            839,839,839,839,2220,6195,889,838,838,838,
            838,838,838,838,838,838,838,838,838,838,
            838,838,838,838,838,838,838,838,838,838,
            838,838,838,838,838,2320,6199,889,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            837,3520,3520,3520,3520,3520,6977,6205,889,6110,
            3920,4663,837,619,619,619,619,619,619,619,
            619,619,619,619,619,619,619,619,619,619,
            619,619,619,619,619,619,619,619,619,619,
            619,5333,6257,6997,6209,889,6219,889,4610,6229,
            889,6233,889,4014,4606,2420,4532,839,847,847,
            847,847,847,847,847,4090,847,847,847,847,
            847,847,847,847,847,847,847,847,847,847,
            847,847,847,847,847,6970,839,838,4842,6239,
            889,865,847,6546,889,6550,889,6554,889,4616,
            6558,889,6562,889,6576,889,4233,6580,889,6584,
            889,6588,889,1019,1617,4781,838,843,843,843,
            843,843,843,843,843,843,843,843,843,843,
            843,843,843,843,843,843,843,843,843,843,
            843,843,843,843,843,7000,837,6592,889,847,
            4962,847,6243,889,6253,889,6110,619,6596,889,
            6263,889,6267,889,6273,889,6600,889,6277,889,
            6287,889,1019,809,4853,619,566,566,566,566,
            566,566,566,566,566,566,566,566,566,566,
            566,566,566,566,566,566,566,566,566,566,
            566,566,566,566,910,6604,889,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,6297,889,6301,889,6307,
            889,6608,889,6311,889,6321,889,6331,889,6335,
            889,6341,889,6612,889,6616,889,1019,2520,4877,
            843,840,840,840,840,840,840,840,840,840,
            840,840,840,840,840,840,840,840,840,840,
            840,840,840,840,840,840,840,840,840,843,
            2620,6620,889,848,848,848,848,848,848,848,
            848,848,848,848,848,848,4325,848,848,848,
            848,848,848,848,848,848,848,848,848,848,
            5060,566,6345,889,1019,566,4879,848,6355,889,
            4996,6365,889,6369,889,6375,889,6379,889,6626,
            889,6630,889,6634,889,6389,889,6399,889,6403,
            889,6409,889,564,2720,564,4997,844,844,844,
            844,844,844,844,844,844,844,844,844,844,
            844,844,844,844,844,844,844,844,844,844,
            844,844,844,844,844,6638,889,6642,889,6646,
            889,6413,889,1019,1019,4881,4883,1019,1019,4885,
            4887,2820,6110,840,841,841,841,841,841,841,
            841,841,841,841,841,841,841,841,841,841,
            841,841,841,841,841,841,841,841,841,841,
            841,841,840,4744,4704,889,4786,889,1019,844,
            4889,5060,4808,889,2222,5226,5207,4943,5222,844,
            5225,5388,1019,5231,4891,1019,848,4893,1019,4979,
            4895,856,5227,1019,6978,4897,848,856,1019,5046,
            4899,1019,1019,4901,4903,1038,1019,1019,4905,4907,
            4959,1019,3642,4909,6110,1019,841,4911,3643,1019,
            1019,4913,4915,1019,1112,4917,841,568,568,568,
            568,568,568,568,568,568,568,568,568,568,
            568,568,568,568,568,568,568,568,568,568,
            568,568,568,568,568,2920,6650,889,849,4500,
            849,849,849,849,849,849,849,849,849,849,
            849,849,849,849,849,849,849,849,849,849,
            849,849,849,849,849,1019,1019,4919,4921,6423,
            889,5221,849,1019,1019,4923,4925,1019,1019,4927,
            4929,1019,1019,4931,4933,1019,1019,4935,4937,1019,
            7040,4939,568,3020,568,4998,845,845,845,845,
            845,845,845,845,845,845,845,845,845,845,
            845,845,845,845,845,845,845,845,845,845,
            845,845,845,845,1019,5351,4941,6433,889,939,
            845,6437,889,3120,6110,845,842,842,842,842,
            842,842,842,842,842,842,842,842,842,842,
            842,842,842,842,842,842,842,842,842,842,
            842,842,842,842,6654,889,6383,5342,2322,6529,
            842,921,4966,2422,7005,842,4969,7014,7007,7018,
            7024,4644,4737,5415,4973,4975,4964,4977,4986,5387,
            4988,4994,5414,4983,7025,2522,997,7043,5004,5062,
            889,5000,849,5299,5459,5002,2622,5023,5040,5027,
            3220,3127,849,850,850,850,4535,850,850,850,
            850,850,850,850,850,850,850,850,850,850,
            850,850,850,850,850,850,850,850,850,850,
            913,1019,5495,2197,6110,3320,5041,850,851,851,
            851,851,851,851,851,4570,851,851,851,851,
            851,851,851,851,851,851,851,851,851,851,
            851,851,851,851,851,7064,1019,1019,4811,4814,
            3420,5047,851,852,852,852,852,852,852,852,
            852,852,4676,852,852,852,852,852,852,852,
            852,852,852,852,852,852,852,852,852,852,
            7041,5061,5441,7044,7058,7054,5496,852,5450,5513,
            7060,5033,7059,7068,5008,7095,7067,5019,5036,5064,
            4469,5017,5070,5039,5044,5030,5042,6110,5052,851,
            4116,851,5058,878,878,878,878,878,878,878,
            878,878,878,878,878,878,878,878,878,878,
            878,878,878,878,878,878,878,878,878,878,
            878,878,878,7076,1019,1019,4828,4234,850,5067,
            1019,1019,5080,2233,2722,5298,3520,5124,850,853,
            853,853,853,853,853,4780,853,853,853,853,
            853,853,853,853,853,853,853,853,853,853,
            853,853,853,853,853,853,6532,4724,889,1019,
            5522,2301,1019,853,2337,1019,6110,2373,5226,5207,
            1019,5222,2409,5225,5069,5075,5231,1019,1019,4707,
            2445,1019,1019,2481,2517,5227,1019,5514,2553,852,
            1019,1019,3393,3283,1019,5101,1625,4212,1038,852,
            879,879,879,879,879,879,879,879,879,879,
            879,879,879,879,879,879,879,879,879,879,
            879,879,879,879,879,879,879,879,879,879,
            3620,6658,889,854,854,854,854,854,854,854,
            854,854,854,854,854,854,854,854,854,854,
            854,854,854,854,854,854,854,854,854,854,
            854,4929,889,6110,4965,889,5567,854,5213,1019,
            3945,4236,854,5207,5206,7100,2097,5198,4897,889,
            5084,1019,5214,4242,5251,1019,1019,2589,2625,5219,
            5207,6110,1019,5215,2661,1019,853,5082,1019,1019,
            2697,2733,1124,6662,889,1112,853,1019,1019,2769,
            2805,1019,1019,1535,3435,1019,1019,2841,2877,1105,
            1019,1019,2913,2949,1019,6110,4489,6666,889,6670,
            889,6674,889,6678,889,6682,889,6686,889,6690,
            889,6694,889,6698,889,6702,889,6706,889,6710,
            889,6714,889,6718,889,6722,889,6726,889,6730,
            889,6734,889,6738,889,6742,889,6746,889,6750,
            889,6754,889,6758,889,6762,889,6766,889,6770,
            889,6774,889,6778,889,6782,889,6786,889,6790,
            889,6794,889,7057,5585,7096,7101,7079,4463,7103,
            1019,4487,2985,5051,1019,1019,3021,5088,5086,5603,
            7104,4459,7108,5090,5604,5085,7105,5621,5094,7113,
            5639,5100,5657,7114,5091,7115,5099,7118,5117,7131,
            7132,5114,5106,7133,936,5102,5702,5104,7136,5118,
            968,5120,2822,5125,7134,5128,7137,5684,5013,7142,
            7144,5131,7140,5202,7160,5208,5146,7145,7168,7143,
            5136,5132,5134,1006,5729,5151,5122,7174,5218,7177,
            5148,5161,5155,7176,5126,1275,5147,5738,5157,5153,
            7179,1051,2922,7164,5141,5160,7182,5152,5756,7189,
            3022,5153,5757,5169,5801,5167,5828,7197,5175,5137,
            5176,7201,3122,5168,5177,5180,3222,5802,5829,1104,
            3322,5182,5056,1100,5873,5181,5183,7200,5187,7198,
            7204,1019,5166,5404,5194,3422,5193,5170,5196,5191,
            6470,889,6474,889,3522,5838,7210,5009,6478,889,
            7214,7219,5195,5060,7205,7206,5306,7229,5308,7222,
            7244,7247,7249,5314,7251,5315,7258,5317,5318,7254,
            5323,5311,5310,7257,7207,5324,5313,5891,5909,5320,
            3622,5333,7241,945,7266,7269,7259,5321,7272,965,
            5336,5918,7274,5337,7282,5339,7275,7298,5335,5240,
            5342,5919,5334,5344,971,5338,7286,3722,7288,5349,
            5343,7294,5622,7297,5351,7293,5345,7303,999,5355,
            5945,5972,5358,5360,5361,5365,7318,7299,7319,7315,
            7300,5371,5359,5366,5373,7323,3822,5973,1084,5377,
            7324,3922,7326,7331,5382,5380,1086,7208,5385,1062,
            5384,7334,5376,7337,7320,6035,7356,5389,7358,5505,
            5392,5396,1019,5397,5406,5383,4118,7351,1019,5402,
            5409,5378,5390,4214,7353,7343,5411,5408,1019,7357,
            5421,1019,6000,5425,5414,6009,7359,7362,6110,5419,
            1045,7364,5415,5427,5428,1019,1019,1676,5432,1019,
            4310,5434,5429,5540,1019,5430,5436,1019,1019,5439,
            5441,1019,1019,5443,5447,1019,1019,5449,5452,1019,
            1019,5454,5456,1019,7371,5458,1019,1019,5473,5475,
            1019,1019,5477,1717,1019,1019,5481,5483,6110,1019,
            5462,5485,1019,1019,5487,1758,1019,1019,5489,5491,
            1019,1019,5493,5495,1019,1019,5497,5499,1019,7366,
            5501,1019,1019,5506,5508,1019,7385,1799,6053,5503,
            7372,7387,5465,7383,7390,7384,5510,7396,6054,5517,
            7393,7392,5521,6081,6090,5531,5525,5512,5523,5511,
            5524,5526,5530,7397,7409,7417,7386,7425,7146,7422,
            5538,5542,6117,7430,7427,7419,977,5518,5537,7233,
            5545,7423,5546,5549,5550,7439,5551,960,7431,7436,
            6116,7437,1025,5558,5559,7444,6973,5553,5563,5535,
            5562,7458,5557,7459,5566,5543,7469,7460,7450,5568,
            7472,5567,7470,5739,7484,7461,3221,5575,5583,7488,
            7491,5582,7490,5588,5576,1119,7492,7501,5592,5593,
            5594,5564,7466,5587,6798,889,6802,889,7504,6806,
            889,7505,7511,5574,7510,7518,5601,5599,5598,7512,
            5597,6810,889,5602,3090,6814,889,7513,7514,7515,
            7524,5603,6818,889,6822,889,6826,889,1039,6830,
            889,6834,889,6838,889,1041,5607,6842,889,6846,
            889,5609,6850,889,6854,889,6858,889,6862,889,
            7523,7525,7534,6866,889,7562,5620,6870,889,6874,
            889,5638,5617,6878,889,6882,889,6886,889,6110,
            5619,6890,889,6894,889,6898,889,6902,889,6906,
            889,6910,889,6914,889,6918,889,6922,889,6926,
            889,6930,889,7522,7552,7548,6934,889,6938,889,
            7533,7521,7569,5631,903,5632,5639,7577,7545,5608,
            5640,7563,5624,7580,7531,7591,7593,5641,933,931,
            7595,7602,5621,929,5646,7594,5645,7605,7606,5652,
            7581,5654,7609,7613,5648,7610,7574,5667,979,7626,
            7592,7628,5666,7637,5662,5658,5656,7619,7639,7614,
            5647,1047,7646,7627,7635,5677,7629,7658,7630,5668,
            1088,5674,1012,5678,7647,7654,4963,6110,5659,5679,
            1034,5676,7665,7678,1096,5687,1094,7669,7680,5660,
            5683,1091,7687,7672,7673,5691,1132,7701,7657,7688,
            873,7681,7699,7691,5698,5693,5695,7705,7713,7708,
            1107,1019,5690,5708,5707,5699,1042,7718,5706,7722,
            7725,7711,1113,5710,7726,5711,5713,1019,1019,5717,
            5719,7734,7737,867,1019,5726,5721,1123,7729,7745,
            7733,7741,5730,918,5715,7752,7755,7756,7763,5728,
            924,5731,7766,5732,7764,5738,7799,5733,7767,7773,
            7775,1015,7768,5734,5736,5744,7776,7781,7784,5740,
            5749,5748,5747,5751,7794,1001,7802,7804,7809,7774,
            5750,6110,5758,7821,5757,5752,5763,7805,5766,7817,
            7818,7814,1065,7826,5765,7831,5759,7845,7836,7839,
            1111,5780,5767,5769,5768,5778,7840,7843,6490,889,
            7837,7844,5777,7846,5781,7849,5779,6499,889,4663,
            889,6507,889,5803,5784,5788,7856,5792,7859,5799,
            7872,7873,7874,7881,7879,5808,7884,5813,7887,907,
            7889,5814,5810,5815,7876,942,5816,7906,7907,7900,
            7901,7908,7885,5822,5820,5826,991,7916,7909,7913,
            5828,5817,5824,7910,5804,7928,7923,7926,7944,7930,
            5838,1136,5831,5840,5832,5830,5839,7934,7931,7939,
            7948,7955,5843,5854,7947,5847,5842,5850,7956,1019,
            5848,1840,7958,1044,1019,1019,1885,1930,5857,7976,
            1019,5853,5862,7961,7962,5856,5860,1019,7965,1966,
            7979,5865,914,7989,7980,7982,7981,7983,5866,5869,
            7984,5868,7996,5872,7990,5876,7997,5881,6504,5873,
            7993,8014,8002,5889,5882,962,5887,5893,8025,8017,
            8010,1054,8026,8032,5875,5894,5898,8033,8029,5896,
            8039,1125,5895,8036,8048,5901,8046,6144,5897,5899,
            8005,5906,6942,889,5885,8051,8054,1009,8049,8053,
            1008,5908,8057,8062,5926,8082,8078,5927,5928,5932,
            974,8079,8081,5921,5934,8090,5915,8089,5935,8083,
            894,5937,5933,8086,8091,8092,8102,8117,8096,8105,
            1128,8110,1022,1126,5952,5936,8125,5941,8106,5953,
            5957,5938,5940,5955,1019,8132,5958,1019,5960,5963,
            1019,8140,5967,1019,5969,5970,8133,8115,8144,900,
            911,5972,8129,8148,8141,8147,8156,8154,8151,8244,
            8159,8158,6025,5983,5974,5975,5980,5978,926,5982,
            1079,5984,8167,8170,1018,8174,1068,8181,6512,889,
            8163,5989,1114,6519,889,6110,1106,4888,889,8186,
            6524,889,8189,1007,8192,8200,6002,915,8197,6004,
            8205,6003,8206,8211,8214,6005,5939,6006,6015,8217,
            1019,6007,2011,1019,1019,2057,2115,1019,1019,6019,
            2151,6010,8218,8219,8225,8222,8226,8235,8227,6008,
            8242,6022,8230,6024,6023,8246,1058,6034,6012,6946,
            889,6027,8241,8253,8251,8266,6040,8263,3649,6110,
            6047,950,6035,982,8270,8269,1019,6049,6053,1019,
            8273,6055,6050,1019,1019,6057,6063,8276,6065,8283,
            8279,6110,6060,4382,889,4513,889,6484,889,1115,
            8301,6071,6070,6534,889,8289,8292,6083,957,6082,
            8303,8284,1019,1019,6085,6087,1019,6084,6089,1019,
            1072,6092,8302,8280,8296,6950,889,6954,889,6958,
            889,986,6962,889,8326,6096,8328,1036,8315,6098,
            6110,6110,6110,6094,6110,6110,6110,1027,6110,6110
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck0 {
        public final static byte termCheck0[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,100,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,99,100,0,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            97,98,99,100,0,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,95,
            96,97,98,99,100,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,91,92,93,94,
            95,96,97,98,99,100,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,100,0,1,2,
            3,4,5,6,0,0,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,91,92,
            93,94,95,96,97,98,99,100,0,1,
            2,3,4,5,6,101,0,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,91,
            92,93,94,95,96,97,98,99,100,0,
            1,2,3,4,5,6,0,0,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,100,
            0,1,2,3,4,5,6,0,0,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,0,1,2,3,4,5,6,0,0,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,100,0,1,2,3,4,5,6,0,
            0,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,93,94,95,96,97,
            98,99,100,0,1,2,3,4,5,6,
            0,0,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,83,84,85,86,
            87,88,89,90,91,92,93,94,95,96,
            97,98,99,100,0,1,2,3,4,5,
            6,0,0,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,83,84,85,
            86,87,88,89,90,91,92,93,94,0,
            96,97,98,99,100,0,1,2,3,0,
            5,6,13,14,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,0,92,93,94,
            95,96,97,98,99,100,0,11,12,0,
            4,5,6,17,18,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,100,0,1,2,
            3,0,5,6,0,0,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            83,84,85,86,87,88,89,90,0,92,
            93,94,95,0,97,98,99,100,0,1,
            2,3,0,5,6,17,18,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,83,84,85,86,87,88,89,90,0,
            92,93,94,95,0,97,98,99,100,0,
            0,7,8,4,5,6,17,18,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,92,93,94,95,96,97,98,99,0,
            0,0,0,4,5,6,5,6,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            91,0,0,0,95,96,97,98,99,0,
            7,8,11,12,5,6,15,16,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,83,84,85,86,87,88,89,90,
            0,92,93,94,95,0,0,0,0,100,
            5,6,5,6,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,0,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,83,84,
            85,86,87,88,89,90,0,92,93,94,
            95,0,0,0,0,100,5,6,5,6,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            0,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,0,92,93,94,95,0,0,0,
            0,100,5,6,5,6,9,10,11,12,
            13,14,15,16,17,18,0,20,21,22,
            23,24,25,26,27,28,0,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            0,0,1,2,3,5,6,0,0,9,
            10,11,12,13,14,15,16,17,18,73,
            20,21,22,23,24,25,26,27,28,73,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,0,1,
            2,3,4,0,0,7,8,0,68,69,
            70,71,72,0,11,12,0,19,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,91,20,21,22,23,24,25,26,
            0,28,29,30,31,32,33,34,35,36,
            37,11,12,40,41,42,43,44,45,0,
            1,2,3,50,51,52,53,54,55,56,
            57,0,0,1,2,3,5,6,19,0,
            9,10,11,12,13,14,15,16,17,18,
            74,20,21,22,23,24,25,26,0,28,
            0,30,31,32,33,34,35,36,37,9,
            10,40,41,42,43,44,45,0,20,21,
            0,50,51,52,53,54,55,56,57,0,
            0,0,15,16,5,6,5,6,9,10,
            11,12,22,23,15,16,17,18,31,20,
            21,34,0,24,25,26,0,28,27,30,
            29,32,33,91,35,36,37,15,16,40,
            41,42,43,44,45,0,24,25,0,50,
            51,0,0,54,55,56,57,5,6,0,
            0,9,10,15,16,13,14,22,23,17,
            18,0,0,0,22,23,24,25,0,1,
            2,3,30,32,32,33,35,35,36,37,
            38,39,0,1,2,3,4,0,46,47,
            48,49,5,6,52,53,9,10,36,37,
            13,14,40,41,17,18,0,44,45,22,
            23,24,25,0,0,9,10,30,0,32,
            33,0,35,0,1,2,3,0,15,16,
            0,1,2,3,0,48,49,0,32,52,
            53,35,0,0,1,2,3,24,25,26,
            29,28,22,23,31,32,29,34,35,46,
            47,31,0,0,34,42,43,24,25,26,
            0,28,0,91,31,32,0,34,35,0,
            17,18,0,11,12,42,43,0,9,10,
            27,68,29,70,15,16,24,25,0,20,
            21,0,0,24,25,0,1,2,3,30,
            0,68,33,70,0,17,18,38,39,40,
            41,0,0,9,10,11,12,0,1,2,
            3,0,11,12,20,21,5,6,36,37,
            9,10,11,12,30,31,32,33,34,35,
            0,30,31,0,33,34,42,43,0,38,
            39,0,0,58,59,60,61,62,63,64,
            65,66,67,11,12,13,14,15,16,17,
            18,31,20,21,34,58,59,60,61,62,
            63,64,65,66,67,0,0,0,36,37,
            0,40,41,0,9,10,0,0,1,2,
            3,4,15,16,11,12,0,1,2,3,
            0,26,69,28,71,30,31,0,33,34,
            0,36,37,30,31,32,33,34,35,0,
            24,25,26,0,28,42,43,0,0,1,
            2,3,36,37,58,59,60,61,62,63,
            64,65,66,67,58,59,60,61,62,63,
            64,65,66,67,26,0,28,0,30,0,
            32,33,0,35,0,1,2,3,13,14,
            0,9,10,9,10,5,6,0,91,0,
            0,1,2,3,4,15,16,7,8,27,
            26,29,28,0,24,25,0,38,39,19,
            30,0,0,33,40,41,13,14,15,16,
            0,0,0,11,12,22,23,15,16,0,
            9,10,20,21,0,32,15,16,35,17,
            18,0,0,22,23,24,25,5,6,27,
            0,29,0,11,12,5,6,15,16,9,
            10,0,0,13,14,15,16,5,6,0,
            0,0,1,2,3,13,14,0,36,37,
            9,10,20,21,22,23,0,1,2,3,
            4,22,23,7,8,0,27,26,29,28,
            0,1,2,3,4,19,0,7,8,0,
            1,2,3,4,44,45,7,8,0,19,
            0,0,0,1,2,3,4,0,19,7,
            8,0,1,2,3,4,9,10,7,8,
            0,19,24,25,0,1,2,3,4,0,
            19,7,8,0,1,2,3,4,9,10,
            7,8,0,19,15,16,0,1,2,3,
            4,0,19,7,8,0,1,2,3,4,
            0,0,7,8,0,19,0,38,39,27,
            0,29,0,13,14,15,16,17,18,9,
            10,0,0,0,0,15,16,0,5,6,
            48,49,11,12,24,25,13,14,15,16,
            0,1,2,3,4,0,0,7,8,0,
            1,2,3,4,9,10,7,8,0,1,
            2,3,4,42,43,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,9,10,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,9,
            10,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,9,10,7,
            8,0,1,2,3,4,0,0,7,8,
            0,1,2,3,4,9,10,7,8,0,
            1,2,3,4,0,0,7,8,0,1,
            2,3,4,9,10,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,0,0,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,9,
            10,7,8,0,1,2,3,4,36,37,
            7,8,0,1,2,3,4,36,37,7,
            8,0,1,2,3,4,0,0,7,8,
            0,1,2,3,4,9,10,7,8,0,
            1,2,3,4,17,18,7,8,0,1,
            2,3,4,0,0,7,8,0,1,2,
            3,4,9,10,7,8,0,1,2,3,
            4,17,18,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,0,
            0,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,9,10,7,
            8,0,1,2,3,4,36,37,7,8,
            0,1,2,3,4,36,37,7,8,0,
            1,2,3,4,0,0,7,8,0,1,
            2,3,4,9,10,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,0,0,7,8,0,1,2,3,4,
            17,18,7,8,0,1,2,3,4,44,
            45,7,8,0,1,2,3,4,36,37,
            7,8,0,1,2,3,4,36,37,7,
            8,0,1,2,3,4,0,0,7,8,
            0,1,2,3,4,9,10,7,8,0,
            1,2,3,4,0,0,7,8,0,1,
            2,3,4,9,10,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,9,10,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,9,
            10,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,44,45,7,
            8,0,1,2,3,4,0,0,7,8,
            0,1,2,3,4,44,45,7,8,0,
            1,2,3,4,36,37,7,8,0,1,
            2,3,4,0,0,7,8,0,1,2,
            3,4,36,37,7,8,0,1,2,3,
            4,0,0,7,8,0,1,2,3,4,
            9,10,7,8,0,1,2,3,4,36,
            37,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,0,0,7,
            8,0,1,2,3,4,9,10,7,8,
            0,1,2,3,4,0,0,7,8,0,
            1,2,3,4,36,37,7,8,0,1,
            2,3,4,17,18,7,8,0,1,2,
            3,4,44,45,7,8,0,1,2,3,
            4,36,37,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,9,
            10,7,8,0,1,2,3,4,17,18,
            7,8,0,1,2,3,4,0,0,7,
            8,0,1,2,3,4,0,0,7,8,
            0,1,2,3,4,17,18,7,8,0,
            1,2,3,4,17,18,7,8,0,1,
            2,3,4,36,37,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,9,10,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,4,9,
            10,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,0,0,7,
            8,0,1,2,3,4,9,10,7,8,
            0,1,2,3,4,17,18,7,8,0,
            1,2,3,4,0,0,7,8,0,1,
            2,3,4,9,10,7,8,0,1,2,
            3,4,54,55,7,8,0,1,2,3,
            4,0,0,7,8,0,1,2,3,4,
            9,10,7,8,0,1,2,3,4,17,
            18,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,0,0,7,
            8,0,1,2,3,4,17,18,7,8,
            0,1,2,3,4,17,18,7,8,0,
            1,2,3,4,0,0,7,8,0,1,
            2,3,4,9,10,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,9,10,7,8,0,1,2,3,4,
            17,18,7,8,0,1,2,3,4,0,
            0,7,8,0,1,2,3,4,0,0,
            7,8,0,1,2,3,4,17,18,7,
            8,0,1,2,3,4,17,18,7,8,
            0,1,2,3,4,0,0,7,8,0,
            1,2,3,4,9,10,7,8,0,1,
            2,3,4,17,18,7,8,0,1,2,
            3,4,0,0,7,8,0,1,2,3,
            4,0,0,7,8,0,1,2,3,4,
            0,0,7,8,0,1,2,3,26,0,
            28,7,8,0,1,2,3,0,9,10,
            7,8,22,23,0,1,2,3,11,12,
            30,22,23,33,0,1,2,3,0,1,
            2,3,0,19,0,1,2,3,0,1,
            2,3,69,19,71,13,14,19,0,1,
            2,3,0,19,22,23,0,19,0,1,
            2,3,0,1,2,3,0,19,0,1,
            2,3,0,1,2,3,0,19,22,23,
            0,19,0,1,2,3,0,19,0,9,
            10,19,0,1,2,3,0,1,2,3,
            0,19,0,1,2,3,0,1,2,3,
            30,19,26,33,28,19,0,1,2,3,
            0,19,0,0,0,19,0,1,2,3,
            0,1,2,3,0,19,0,1,2,3,
            0,1,2,3,0,19,0,13,14,19,
            0,1,2,3,31,19,0,34,0,19,
            0,1,2,3,0,1,2,3,0,19,
            0,1,2,3,0,1,2,3,0,19,
            46,47,0,19,0,1,2,3,0,19,
            0,13,14,19,0,1,2,3,0,1,
            2,3,0,19,0,1,2,3,0,1,
            2,3,0,19,24,25,0,19,0,1,
            2,3,0,19,0,13,14,19,0,1,
            2,3,0,1,2,3,0,19,0,1,
            2,3,0,1,2,3,0,19,24,25,
            0,19,0,1,2,3,0,19,0,0,
            0,19,0,1,2,3,0,1,2,3,
            0,19,0,0,0,5,6,5,6,9,
            10,19,0,24,25,19,13,14,30,15,
            16,33,20,21,36,37,0,24,25,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,0,0,1,2,3,5,6,0,
            1,2,3,4,13,14,15,16,0,1,
            2,3,4,0,22,23,0,1,2,3,
            4,0,1,2,3,4,13,14,0,1,
            2,3,4,0,1,2,3,4,0,0,
            27,0,29,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,96,38,39,0,96,
            0,40,41,96,91,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,91,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,1,2,3,0,
            1,2,3,0,1,2,3,0,1,2,
            3,0,1,2,3,0,0,0,0,0,
            0,0,0,0,0,0,0,0,11,12,
            0,9,10,15,16,11,12,11,12,0,
            20,21,27,27,29,29,0,22,23,0,
            31,0,0,34,0,0,0,11,12,32,
            11,12,35,0,0,0,27,0,29,48,
            49,15,16,0,0,0,22,23,27,27,
            29,29,27,0,29,22,23,20,21,0,
            0,0,0,0,30,22,23,33,24,25,
            11,12,27,0,29,0,0,0,0,0,
            27,0,29,0,22,23,0,0,27,0,
            29,31,15,16,34,0,13,14,0,0,
            13,14,27,30,29,26,33,28,13,14,
            32,48,49,35,0,0,40,41,32,0,
            0,35,0,0,0,11,12,0,13,14,
            11,12,0,0,0,15,16,0,40,41,
            13,14,20,21,11,12,22,23,11,12,
            0,0,0,0,31,0,0,34,26,0,
            28,0,0,0,0,0,32,11,12,35,
            5,6,22,23,22,23,13,14,27,0,
            29,0,27,0,29,24,25,0,26,0,
            28,38,39,0,30,0,0,33,0,20,
            21,0,15,16,11,12,11,12,0,13,
            14,52,53,15,16,32,0,0,35,0,
            0,13,14,0,0,0,0,0,27,0,
            29,15,16,0,15,16,13,14,0,22,
            23,0,13,14,24,25,13,14,0,22,
            23,0,0,15,16,0,30,5,6,33,
            0,13,14,0,40,41,0,26,0,28,
            0,46,47,0,11,12,0,0,0,13,
            14,13,14,13,14,0,13,14,0,13,
            14,0,32,0,0,35,11,12,0,11,
            12,0,11,12,27,0,29,0,30,15,
            16,33,0,0,13,14,0,0,0,0,
            13,14,0,30,11,12,33,15,16,13,
            14,26,0,28,0,13,14,0,0,0,
            42,43,0,0,27,0,29,0,11,12,
            0,13,14,0,20,21,0,0,13,14,
            42,43,0,20,21,15,16,48,49,27,
            0,29,0,20,21,0,0,0,0,40,
            41,0,26,0,28,0,11,12,11,12,
            0,0,22,23,22,23,15,16,22,23,
            38,39,0,0,0,0,0,22,23,0,
            32,0,0,35,31,0,0,34,15,16,
            11,12,32,11,12,35,22,23,0,38,
            39,20,21,27,32,29,0,35,0,24,
            25,0,0,27,0,29,0,11,12,0,
            0,46,47,11,12,0,0,0,0,31,
            5,6,34,0,20,21,20,21,27,0,
            29,15,16,24,25,17,18,0,0,0,
            0,31,5,6,34,0,48,49,0,0,
            27,0,29,5,6,17,18,17,18,30,
            11,12,33,0,13,14,27,0,29,0,
            0,0,9,10,5,6,5,6,11,12,
            0,36,37,0,0,5,6,17,18,0,
            0,0,0,0,0,11,12,0,9,10,
            0,0,0,0,0,5,6,0,0,26,
            0,28,0,0,17,18,26,26,28,28,
            17,18,9,10,0,0,32,0,26,35,
            28,0,0,32,42,43,35,27,26,29,
            28,0,0,50,51,0,42,43,0,22,
            23,20,21,0,13,14,0,9,10,0,
            0,5,6,0,40,41,24,25,9,10,
            0,0,0,0,0,5,6,5,6,5,
            6,0,9,10,0,0,5,6,0,0,
            5,6,0,0,5,6,36,37,0,15,
            16,9,10,50,51,0,0,0,0,0,
            5,6,5,6,0,27,0,29,0,48,
            49,5,6,5,6,0,0,0,0,31,
            5,6,34,0,20,21,0,0,30,46,
            47,33,5,6,0,0,40,41,0,5,
            6,0,0,20,21,46,47,0,32,0,
            0,35,5,6,5,6,0,0,20,21,
            0,5,6,0,22,23,0,26,0,28,
            0,0,15,16,0,5,6,0,52,53,
            0,31,0,0,34,17,18,0,0,15,
            16,0,15,16,0,0,36,37,0,0,
            13,14,0,0,13,14,0,13,14,27,
            0,29,9,10,0,20,21,11,12,5,
            6,0,24,25,0,0,24,25,48,49,
            20,21,0,0,0,0,0,0,17,18,
            5,6,0,0,0,0,0,0,24,25,
            0,15,16,0,0,5,6,32,5,6,
            35,24,25,0,32,20,21,35,0,36,
            37,0,30,0,0,33,13,14,0,11,
            12,38,39,0,11,12,0,0,17,18,
            0,5,6,15,16,0,9,10,54,55,
            0,11,12,20,21,0,0,0,0,0,
            36,37,0,0,0,0,11,12,0,24,
            25,13,14,9,10,0,17,18,0,0,
            5,6,20,21,0,17,18,31,38,39,
            34,0,0,0,31,0,31,34,0,34,
            0,9,10,0,0,27,0,29,0,9,
            10,20,21,15,16,22,23,11,12,0,
            0,13,14,20,21,0,0,0,0,0,
            11,12,0,38,39,0,9,10,13,14,
            5,6,0,17,18,0,26,0,28,0,
            0,22,23,0,50,51,24,25,0,31,
            15,16,34,0,22,23,0,0,5,6,
            17,18,5,6,0,0,26,0,28,30,
            0,0,33,0,0,5,6,13,14,31,
            13,14,34,46,47,0,15,16,0,0,
            0,0,0,0,38,39,22,23,0,0,
            11,12,0,38,39,0,0,5,6,17,
            18,0,24,25,0,30,11,12,33,0,
            22,23,31,0,31,34,0,34,22,23,
            11,12,42,43,0,0,13,14,0,5,
            6,0,0,44,45,0,5,6,0,38,
            39,9,10,15,16,0,30,0,0,33,
            0,0,0,0,50,51,0,32,11,12,
            35,0,24,25,11,12,31,11,12,34,
            20,21,20,21,13,14,31,0,0,34,
            0,0,0,5,6,0,9,10,0,0,
            0,0,0,13,14,0,48,49,0,11,
            12,0,13,14,0,0,11,12,27,0,
            29,26,30,28,0,33,0,0,17,18,
            30,5,6,33,0,0,17,18,0,38,
            39,0,0,9,10,31,5,6,34,0,
            0,9,10,0,5,6,0,0,5,6,
            0,46,47,0,26,0,28,0,0,0,
            46,47,0,0,24,25,0,17,18,0,
            15,16,26,0,28,9,10,20,21,26,
            0,28,24,25,0,0,13,14,0,20,
            21
        };
    };

    public interface TermCheck1 {
        public final static byte termCheck1[] = {
            0,30,46,47,33,0,9,10,0,20,
            21,17,18,0,0,15,16,9,10,0,
            15,16,0,9,10,0,0,0,15,16,
            0,9,10,0,0,0,17,18,0,0,
            0,15,16,0,17,18,0,17,18,0,
            0,26,0,28,0,22,23,5,6,0,
            26,0,28,20,21,15,16,13,14,20,
            21,0,11,12,0,40,41,0,0,20,
            21,0,44,45,0,11,12,0,0,0,
            0,0,0,22,23,17,18,0,17,18,
            0,0,5,6,0,5,6,20,21,0,
            0,0,20,21,0,38,39,26,0,28,
            36,37,0,0,15,16,15,16,24,25,
            20,21,44,45,0,0,0,0,0,5,
            6,5,6,20,21,0,32,0,0,35,
            32,0,0,35,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0
        };
    };

    public final static byte termCheck[] = new byte[TermCheck0.termCheck0.length + TermCheck1.termCheck1.length];
    {
        int index = 0;
        System.arraycopy(TermCheck0.termCheck0, 0, termCheck, index, TermCheck0.termCheck0.length);
        index += TermCheck0.termCheck0.length;
        System.arraycopy(TermCheck1.termCheck1, 0, termCheck, index, TermCheck1.termCheck1.length);
    };
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction0 {
        public final static char termAction0[] = {0,
            6110,1582,1582,1582,1757,1757,1757,1582,1582,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,3914,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,1757,1757,1757,1757,1757,1757,
            1757,1757,1757,1757,3855,3673,1757,1757,1757,1757,
            1757,1757,3713,1757,1757,1757,1757,1757,1757,3744,
            1757,1757,6119,6123,6124,1757,1757,1154,2987,3775,
            6722,6110,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6683,6690,6690,
            6690,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6692,6690,6690,6690,6690,6690,6690,6690,6690,6690,
            6690,6690,6110,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6710,6703,6710,6710,6710,6710,6710,
            6710,6712,6710,6710,6710,6710,6710,6710,6710,6710,
            6710,6710,6710,6110,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6700,6700,6700,6700,6700,6700,
            6693,6700,6702,6700,6700,6700,6700,6700,6700,6700,
            6700,6700,6700,6700,6110,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6684,6691,6691,6691,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6715,6691,6691,6691,6691,6691,6691,
            6691,6691,6691,6691,6691,6110,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6711,6704,6711,6711,
            6711,6711,6711,6711,6714,6711,6711,6711,6711,6711,
            6711,6711,6711,6711,6711,6711,6110,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,6701,6701,6701,
            6701,6701,6701,6694,6701,6713,6701,6701,6701,6701,
            6701,6701,6701,6701,6701,6701,6701,2,6680,6680,
            6680,6680,6680,6680,6110,565,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6110,6676,
            6676,6676,6676,6676,6676,6109,563,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6676,6676,6676,6676,6676,
            6676,6676,6676,6676,6676,6720,6676,6676,6676,6110,
            6674,6674,6674,6674,6674,6674,579,599,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6674,6674,6674,
            6674,6674,6674,6674,6674,6674,6674,6719,6674,6674,
            868,6680,6680,6680,6680,6680,6680,589,888,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6680,6680,6680,6680,6680,6680,6680,6680,6680,
            6680,6110,6678,6678,6678,6678,6678,6678,537,618,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6678,6678,6678,6678,
            6678,6678,6678,6678,6678,6678,6721,6678,6678,6678,
            6678,6678,6110,6999,6999,6999,5260,5260,5260,5,
            567,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,5260,5260,5260,5260,5260,5260,5260,
            5260,5260,5260,6110,6999,6999,6999,5287,5287,5287,
            877,856,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,5287,5287,5287,5287,5287,5287,
            5287,5287,5287,5287,6110,1839,1839,1839,1839,1839,
            1839,6110,6110,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,1839,
            1839,1839,1839,1839,1839,1839,1839,1839,1839,6110,
            1839,1839,1839,1839,1839,6110,6999,6999,6999,6110,
            1884,1884,4415,4415,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,4630,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,6110,1884,1884,1884,
            1884,5283,1154,2987,3188,1884,829,4469,4469,6110,
            6953,6953,6953,1712,1712,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6679,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,6953,6953,6953,6953,6953,6953,6953,6953,6953,
            6953,4154,6953,6953,6953,6953,6953,6110,6999,6999,
            6999,6110,1884,1884,6110,6110,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,4630,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,6110,1884,
            1884,1884,1884,6110,1154,2987,3188,1884,6110,6999,
            6999,6999,6110,1884,1884,2555,2555,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,4630,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,1884,
            1884,1884,1884,1884,1884,1884,1884,1884,1884,6110,
            1884,1884,1884,1884,6110,1154,2987,3188,1884,5,
            6110,6974,6974,6965,6965,6965,4251,4251,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,6965,
            6965,6965,6965,6965,6965,6965,6965,6965,6965,12,
            6110,6110,6110,6956,6956,6956,3597,3597,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,6956,
            6956,6956,6956,6956,6956,6956,6956,6956,6956,827,
            6110,6110,6110,6949,6949,6949,4710,4710,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,4058,6949,6949,6949,6949,6949,6949,6949,6949,
            6949,6949,6949,6949,6949,6949,6949,6949,6949,826,
            6110,6110,6110,6948,6948,6948,4943,4943,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,6948,
            6948,6948,6948,6948,6948,1138,6948,6948,6948,6948,
            6948,1432,6948,6948,6948,6948,1290,6948,6948,6948,
            6948,6948,6948,6948,6948,6948,6948,6948,6948,825,
            6110,6110,6110,6947,3520,3520,7031,7031,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,6947,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,6947,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,6947,6947,6947,
            6947,6947,6947,6947,6947,6947,6947,3520,3520,3520,
            3520,3520,6947,6947,6947,6947,6947,6947,6947,6947,
            6947,6947,6947,6947,6947,6947,6947,6947,6947,6947,
            6947,6947,6947,6947,6947,6947,6947,6947,6947,830,
            6110,6110,6110,6957,6957,6957,4969,4969,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,4090,4090,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,6957,
            6957,6957,6957,6957,6957,6957,6957,6957,6957,828,
            6110,6110,6110,6950,6950,6950,5004,5004,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,4201,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,6950,
            6950,6950,6950,6950,6950,6950,6950,6950,6950,831,
            6110,6110,6110,6958,6958,6958,5027,5027,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,4325,6958,6958,4325,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,6958,
            6958,6958,6958,6958,6958,6958,6958,6958,6958,572,
            6110,6110,6110,6954,6954,6954,5124,5124,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,10966,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,6954,
            6954,6954,6954,6954,6954,6954,6954,6954,6954,571,
            6110,6110,6110,6951,6951,6951,5128,5128,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,11066,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,6951,
            6951,6951,6951,6951,6951,6951,6951,6951,6951,832,
            6110,6110,6110,6959,6959,6959,5160,5160,4500,4500,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6959,
            6959,6959,6959,6959,6959,6959,6959,6959,6959,6110,
            6110,6110,6110,6955,6955,6955,5169,5169,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6955,
            6955,6955,6955,6955,6955,6955,6955,6955,6955,6110,
            6110,6110,6110,6952,6952,6952,5180,5180,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,6952,
            6952,6952,6952,6952,6952,6952,6952,6952,6952,833,
            6110,6110,6110,6960,6960,6960,7214,7214,6960,6960,
            6960,6960,4535,4535,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,6960,
            6960,6960,6960,6960,6960,6960,6960,6960,6960,834,
            6110,6110,6110,6961,6961,6961,7210,7210,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,4570,4570,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,6961,
            6961,6961,6961,6961,6961,6961,6961,6961,6961,835,
            6110,1135,6110,6962,6962,6962,5196,5196,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,4676,6962,4676,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,6962,
            6962,6962,6962,6962,6962,6962,6962,6962,6962,836,
            6110,6110,6110,6963,6963,6963,5009,5009,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,4780,
            4780,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,6963,
            6963,6963,6963,6963,6963,6963,6963,6963,6963,867,
            6110,6110,6110,6964,6964,6964,7055,7055,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,6964,
            6964,6964,6964,6964,6964,6964,6964,6964,6964,572,
            6110,6110,6110,4383,4383,4383,5343,5343,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,4383,
            4383,4383,4383,4383,4383,4383,4383,4383,4383,571,
            6110,6110,6110,4423,4423,4423,5377,5377,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,4423,
            4423,4423,4423,4423,4423,4423,4423,4423,4423,5,
            6110,6110,6110,6729,6729,6729,5382,5382,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6729,6729,6729,6729,6729,6729,6729,6729,6729,
            6729,6110,6110,6110,6729,6729,6729,6729,6729,883,
            6975,6975,4946,4946,6990,6990,4947,4947,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,4747,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6990,6990,6990,6990,6990,6990,6990,6990,6990,6990,
            6110,6990,6990,6990,6990,882,6110,6110,6110,6990,
            6988,6988,5402,5402,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6110,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6988,6988,6988,6988,
            6988,6988,6988,6988,6988,6988,6110,6988,6988,6988,
            6988,884,6110,6110,6110,6988,6989,6989,5411,5411,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6110,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6989,6989,6989,6989,6989,6989,6989,6989,
            6989,6989,6110,6989,6989,6989,6989,4,6110,6110,
            6110,6989,6723,6723,5540,5540,6723,6723,6723,6723,
            6723,6723,6723,6723,6723,6723,10,6723,6723,6723,
            6723,6723,6723,6723,6723,6723,7,6723,6723,6723,
            6723,6723,6723,6723,6723,6723,6723,6723,6723,6723,
            6723,6723,6723,6723,6723,6723,6723,6723,6723,6723,
            6723,6723,6723,6723,6723,6724,6724,6724,6724,6724,
            6724,6724,6724,6724,6724,6723,6723,6723,6723,6723,
            6110,6110,6999,6999,6999,3520,3520,6110,6110,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,6121,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,6118,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,3520,3520,
            3520,3520,3520,3520,3520,3520,3520,3520,1120,6999,
            6999,6999,6999,6110,6110,6999,6999,6110,3520,3520,
            3520,3520,3520,6110,3706,3706,858,6999,1298,1298,
            6972,6972,1572,1572,1301,1301,1357,1357,1167,1167,
            1225,1225,6072,3219,3219,1571,1571,1264,1264,1309,
            6110,1309,1524,1159,1653,1221,1159,1653,1221,1436,
            1436,4467,4467,1158,1158,1922,1922,1573,1573,6110,
            6999,6999,6999,1359,1359,1453,1453,1360,1360,3128,
            3128,6110,6110,6999,6999,6999,1298,1298,4531,6110,
            1572,1572,1301,1301,1357,1357,1167,1167,1225,1225,
            1637,3219,3219,1571,1571,1264,1264,1309,6110,1309,
            6110,1159,1653,1221,1159,1653,1221,1436,1436,3661,
            3661,1158,1158,1922,1922,1573,1573,6110,4482,4482,
            6110,1359,1359,1453,1453,1360,1360,3128,3128,6110,
            6110,869,4605,4605,1425,1425,6983,6983,1921,1921,
            1301,1301,2094,2094,1433,1433,1225,1225,4604,1635,
            1635,4604,6110,1264,1264,1658,6110,1658,5697,4244,
            5697,1661,4244,6073,1661,1358,1358,1644,1644,1158,
            1158,1922,1922,1573,1573,6110,7112,7112,6110,1876,
            1876,6110,6110,1360,1360,3128,3128,3669,3669,6110,
            6110,3652,3652,3843,3843,3842,3842,4264,4264,3658,
            3658,6110,6110,6110,3841,3841,3470,3470,1133,12457,
            12457,12457,7179,4120,7183,7179,4120,7183,7199,7199,
            3657,3657,6110,6999,6999,6999,5795,6110,3651,3651,
            7191,7191,3669,3669,3660,3660,3652,3652,2483,2483,
            3842,3842,4459,4459,3658,3658,6110,5000,5000,3841,
            3841,3470,3470,6110,6110,4463,4463,7179,6110,7183,
            7179,6110,7183,6110,6999,6999,6999,6110,3131,3131,
            6110,6999,6999,6999,6110,7191,7191,6110,4464,3660,
            3660,4464,6110,6110,6999,6999,6999,1968,2056,5207,
            6679,5207,5264,5264,5222,5225,1524,5222,5225,3088,
            3088,1574,6110,869,1574,5231,5231,1968,2056,5207,
            6110,5207,6110,5800,5222,5225,6110,5222,5225,6110,
            5060,5060,6110,2095,2095,5231,5231,6110,1414,1414,
            5046,5227,5046,5227,7022,7022,4603,4603,993,1877,
            1877,6110,6110,2109,2109,6110,6999,6999,6999,7011,
            6110,5227,7011,5227,6110,4380,4380,1169,1169,7005,
            7005,6110,6110,7061,7061,1924,1924,6110,6999,6999,
            6999,6110,2339,2339,3289,3289,2096,2096,4608,4608,
            7169,7169,7165,7165,3338,7053,7068,3338,7053,7068,
            6110,7129,7126,6110,7129,7126,1636,1636,6110,3599,
            3599,6110,6110,2153,2153,2153,2153,2153,2153,2153,
            2153,2153,2153,1445,1445,7139,7139,1667,1667,7147,
            7147,4485,7133,7133,4485,2153,2153,2153,2153,2153,
            2153,2153,2153,2153,2153,6110,888,6110,7158,7158,
            6110,4233,4233,6110,7093,7093,888,6110,6999,6999,
            6999,5994,3378,3378,1924,1924,6110,6999,6999,6999,
            6110,3602,5689,3602,5689,7097,3646,6110,7097,3646,
            6110,7090,7090,3338,7053,7068,3338,7053,7068,6110,
            5219,5219,5207,6110,5207,4944,4944,6110,6110,6999,
            6999,6999,5215,5215,6967,6967,6967,6967,6967,6967,
            6967,6967,6967,6967,6967,6967,6967,6967,6967,6967,
            6967,6967,6967,6967,5207,6110,5207,6110,5206,6110,
            5198,5206,1123,5198,6110,6999,6999,6999,4496,4496,
            6110,869,869,5213,5213,2093,2093,6110,5997,6110,
            1108,6999,6999,6999,6999,3178,3178,6999,6999,5690,
            2097,5690,2097,6110,3135,3135,6110,3600,3600,6999,
            7037,6110,6110,7037,5214,5214,1310,1310,3601,3601,
            6110,6110,992,4945,4945,3220,3220,4825,4825,6110,
            2235,2235,7133,7133,6110,7073,3650,3650,7073,869,
            869,6110,6110,6982,6982,7123,7123,3885,3885,5141,
            6110,5141,6110,3704,3704,3707,3707,3888,3888,7239,
            7239,6110,6110,3705,3705,3806,3806,4602,4602,869,
            6110,6110,6999,6999,6999,4487,4487,6110,7202,7202,
            5299,5299,2843,2843,4601,4601,1101,6999,6999,6999,
            6999,4996,4996,6999,6999,6110,4997,3127,4997,3127,
            1097,6999,6999,6999,6999,6999,6110,6999,6999,1003,
            6999,6999,6999,6999,5017,5017,6999,6999,6110,6999,
            6110,6110,988,6999,6999,6999,6999,904,6999,6999,
            6999,954,6999,6999,6999,6999,3945,3945,6999,6999,
            6110,6999,1400,1400,908,6999,6999,6999,6999,6110,
            6999,6999,6999,908,6999,6999,6999,6999,4816,4816,
            6999,6999,1080,6999,7022,7022,908,6999,6999,6999,
            6999,6110,6999,6999,6999,6110,2002,2002,2002,7002,
            6110,6110,6973,6973,6110,6999,6110,1169,1169,5170,
            6110,5170,6110,3647,3647,3295,3295,7104,7104,2235,
            2235,6110,6110,6110,6110,3650,3650,6110,3707,3707,
            869,869,4471,4471,7123,7123,4949,4949,3806,3806,
            1133,6999,6999,6999,6999,6110,6110,6999,6999,1130,
            6999,6999,6999,6999,2411,2411,6999,6999,1117,6999,
            6999,6999,6999,2699,2699,6999,6999,1082,6999,6999,
            6999,6999,6110,6110,6999,6999,1077,6999,6999,6999,
            6999,4456,4456,6999,6999,1074,6999,6999,6999,6999,
            6110,6110,6999,6999,1070,6999,6999,6999,6999,4458,
            4458,6999,6999,1066,6999,6999,6999,6999,6110,6110,
            6999,6999,1063,6999,6999,6999,6999,2627,2627,6999,
            6999,1060,6999,6999,6999,6999,6110,6110,6999,6999,
            1056,6999,6999,6999,6999,4470,4470,6999,6999,1052,
            6999,6999,6999,6999,6110,6110,6999,6999,1049,6999,
            6999,6999,6999,2771,2771,6999,6999,1032,6999,6999,
            6999,6999,6110,6110,6999,6999,1020,6999,6999,6999,
            6999,6110,6110,6999,6999,1010,6999,6999,6999,6999,
            6110,6110,6999,6999,995,6999,6999,6999,6999,7049,
            7049,6999,6999,972,6999,6999,6999,6999,4532,4532,
            6999,6999,969,6999,6999,6999,6999,4737,4737,6999,
            6999,966,6999,6999,6999,6999,6110,6110,6999,6999,
            940,6999,6999,6999,6999,4983,4983,6999,6999,937,
            6999,6999,6999,6999,4979,4979,6999,6999,934,6999,
            6999,6999,6999,6110,6110,6999,6999,922,6999,6999,
            6999,6999,7107,7107,6999,6999,919,6999,6999,6999,
            6999,4994,4994,6999,6999,916,6999,6999,6999,6999,
            6110,6110,6999,6999,905,6999,6999,6999,6999,6110,
            6110,6999,6999,1134,6999,6999,6999,6999,6110,6110,
            6999,6999,1131,6999,6999,6999,6999,5040,5040,6999,
            6999,1121,6999,6999,6999,6999,5019,5019,6999,6999,
            1118,6999,6999,6999,6999,5039,5039,6999,6999,1109,
            6999,6999,6999,6999,6110,6110,6999,6999,1102,6999,
            6999,6999,6999,5041,5041,6999,6999,1098,6999,6999,
            6999,6999,6110,6110,6999,6999,1083,6999,6999,6999,
            6999,6110,6110,6999,6999,1078,6999,6999,6999,6999,
            5101,5101,6999,6999,1075,6999,6999,6999,6999,5042,
            5042,6999,6999,1071,6999,6999,6999,6999,5044,5044,
            6999,6999,1067,6999,6999,6999,6999,5075,5075,6999,
            6999,1064,6999,6999,6999,6999,6110,6110,6999,6999,
            1061,6999,6999,6999,6999,3945,3945,6999,6999,1057,
            6999,6999,6999,6999,6110,6110,6999,6999,1053,6999,
            6999,6999,6999,4463,4463,6999,6999,1050,6999,6999,
            6999,6999,6110,6110,6999,6999,1033,6999,6999,6999,
            6999,5090,5090,6999,6999,1021,6999,6999,6999,6999,
            6110,6110,6999,6999,1011,6999,6999,6999,6999,5100,
            5100,6999,6999,1004,6999,6999,6999,6999,6110,6110,
            6999,6999,996,6999,6999,6999,6999,7046,7046,6999,
            6999,989,6999,6999,6999,6999,6110,6110,6999,6999,
            973,6999,6999,6999,6999,5359,5359,6999,6999,970,
            6999,6999,6999,6999,5102,5102,6999,6999,967,6999,
            6999,6999,6999,6110,6110,6999,6999,955,6999,6999,
            6999,6999,5104,5104,6999,6999,941,6999,6999,6999,
            6999,6110,6110,6999,6999,938,6999,6999,6999,6999,
            7078,7078,6999,6999,935,6999,6999,6999,6999,5134,
            5134,6999,6999,923,6999,6999,6999,6999,6110,6110,
            6999,6999,920,6999,6999,6999,6999,6110,6110,6999,
            6999,917,6999,6999,6999,6999,7161,7161,6999,6999,
            909,6999,6999,6999,6999,6110,6110,6999,6999,906,
            6999,6999,6999,6999,5153,5153,6999,6999,1127,6999,
            6999,6999,6999,5176,5176,6999,6999,1122,6999,6999,
            6999,6999,5587,5587,6999,6999,1110,6999,6999,6999,
            6999,5168,5168,6999,6999,1103,6999,6999,6999,6999,
            6110,6110,6999,6999,1099,6999,6999,6999,6999,5175,
            5175,6999,6999,1093,6999,6999,6999,6999,5181,5181,
            6999,6999,1090,6999,6999,6999,6999,6110,6110,6999,
            6999,1087,6999,6999,6999,6999,6110,6110,6999,6999,
            1085,6999,6999,6999,6999,5183,5183,6999,6999,1046,
            6999,6999,6999,6999,5060,5060,6999,6999,1035,6999,
            6999,6999,6999,5182,5182,6999,6999,1030,6999,6999,
            6999,6999,6110,6110,6999,6999,1026,6999,6999,6999,
            6999,5187,5187,6999,6999,1024,6999,6999,6999,6999,
            6110,6110,6999,6999,1017,6999,6999,6999,6999,5333,
            5333,6999,6999,1014,6999,6999,6999,6999,6110,6110,
            6999,6999,1005,6999,6999,6999,6999,6110,6110,6999,
            6999,1000,6999,6999,6999,6999,5339,5339,6999,6999,
            998,6999,6999,6999,6999,5349,5349,6999,6999,990,
            6999,6999,6999,6999,6110,6110,6999,6999,984,6999,
            6999,6999,6999,5361,5361,6999,6999,981,6999,6999,
            6999,6999,7081,7081,6999,6999,978,6999,6999,6999,
            6999,6110,6110,6999,6999,964,6999,6999,6999,6999,
            5365,5365,6999,6999,961,6999,6999,6999,6999,5380,
            5380,6999,6999,959,6999,6999,6999,6999,6110,6110,
            6999,6999,956,6999,6999,6999,6999,6110,6110,6999,
            6999,946,6999,6999,6999,6999,7155,7155,6999,6999,
            944,6999,6999,6999,6999,5427,5427,6999,6999,932,
            6999,6999,6999,6999,6110,6110,6999,6999,930,6999,
            6999,6999,6999,5505,5505,6999,6999,928,6999,6999,
            6999,6999,6110,6110,6999,6999,925,6999,6999,6999,
            6999,5465,5465,6999,6999,910,6999,6999,6999,6999,
            5525,5525,6999,6999,902,6999,6999,6999,6999,6110,
            6110,6999,6999,899,6999,6999,6999,6999,6110,6110,
            6999,6999,947,6999,6999,6999,6999,5526,5526,6999,
            6999,948,6999,6999,6999,6999,5530,5530,6999,6999,
            1095,6999,6999,6999,6999,6110,6110,6999,6999,976,
            6999,6999,6999,6999,5559,5559,6999,6999,949,6999,
            6999,6999,6999,5545,5545,6999,6999,893,6999,6999,
            6999,6999,6110,6110,6999,6999,893,6999,6999,6999,
            6999,6110,6110,6999,6999,893,6995,6995,6995,6995,
            6110,6110,6995,6995,6110,3596,3596,3596,4457,6110,
            4457,6971,6971,1,6648,6648,6648,6110,7226,7226,
            6648,6648,3517,3517,1120,11685,11685,11685,7186,7186,
            7085,5412,5412,7085,1108,12227,12227,12227,1101,12323,
            12323,12323,6110,4566,1097,12337,12337,12337,6110,6999,
            6999,6999,5915,4567,5915,4615,4615,4664,6110,6999,
            6999,6999,6110,4665,3220,3220,6110,4670,6110,6999,
            6999,6999,6110,6999,6999,6999,6110,4671,6110,6999,
            6999,6999,6110,6999,6999,6999,6110,4709,4612,4612,
            6110,4712,6110,6999,6999,6999,6110,4715,6110,5095,
            5095,4720,6110,6999,6999,6999,6110,6999,6999,6999,
            6110,4727,6110,6999,6999,6999,6110,6999,6999,6999,
            5097,4728,4606,5097,4606,4731,6110,6999,6999,6999,
            6110,4732,6110,6110,6110,4736,1003,12346,12346,12346,
            6110,6999,6999,6999,6110,4740,6110,6999,6999,6999,
            988,12359,12359,12359,6110,4741,6110,6066,6066,4744,
            6110,6999,6999,6999,2915,4819,6110,2915,6110,4831,
            6110,6999,6999,6999,6110,6999,6999,6999,6110,4835,
            6110,6999,6999,6999,6110,6999,6999,6999,6110,4836,
            7095,7095,6110,4842,6110,6999,6999,6999,6110,4845,
            6110,4609,4609,4848,6110,6999,6999,6999,954,12368,
            12368,12368,6110,4849,6110,6999,6999,6999,6110,6999,
            6999,6999,6110,4857,4468,4468,6110,4858,6110,6999,
            6999,6999,6110,4861,6110,4966,4966,4862,6110,6999,
            6999,6999,6110,6999,6999,6999,6110,4865,6110,6999,
            6999,6999,908,12390,12381,12403,6110,4866,4479,4479,
            6110,4870,6110,6999,6999,6999,6110,4871,6110,6110,
            6110,4874,6110,6999,6999,6999,6110,6999,6999,6999,
            6110,4950,6110,6110,6110,4980,4980,5009,5009,4674,
            4674,4954,6110,4473,4473,4955,5057,5057,5113,4494,
            4494,5113,5032,5032,5109,5109,6110,5056,5056,6110,
            6999,6999,6999,6110,6999,6999,6999,6110,6999,6999,
            6999,6110,6110,6110,6999,6999,6999,5504,5504,6110,
            6999,6999,6999,5789,5460,5460,5461,5461,6110,6999,
            6999,6999,5794,1028,5408,5408,6110,6999,6999,6999,
            5807,6110,6999,6999,6999,5990,869,869,6110,6999,
            6999,6999,5993,6110,6999,6999,6999,5998,6110,6110,
            5885,6110,5885,6110,6999,6999,6999,1130,12466,12466,
            12466,1117,12475,12475,12475,1082,12484,12484,12484,1077,
            12493,12493,12493,1074,12502,12502,12502,1070,12511,12511,
            12511,1066,12520,12520,12520,5235,4964,4964,6110,5271,
            6110,5069,5069,5305,6076,1063,12529,12529,12529,1060,
            12538,12538,12538,1056,12547,12547,12547,1052,12556,12556,
            12556,1049,12565,12565,12565,1032,12574,12574,12574,1020,
            12583,12583,12583,1010,12592,12592,12592,995,12601,12601,
            12601,972,12610,12610,12610,969,12619,12619,12619,966,
            12628,12628,12628,6110,6079,940,12637,12637,12637,937,
            12646,12646,12646,934,12655,12655,12655,922,12664,12664,
            12664,919,12673,12673,12673,916,12682,12682,12682,905,
            12691,12691,12691,866,6999,6999,6999,1134,12700,12700,
            12700,1131,12709,12709,12709,1121,12718,12718,12718,1118,
            12727,12727,12727,1109,12736,12736,12736,1102,12745,12745,
            12745,1098,12754,12754,12754,1083,12763,12763,12763,1078,
            12772,12772,12772,1075,12781,12781,12781,1071,12790,12790,
            12790,1067,12799,12799,12799,1064,12808,12808,12808,1061,
            12817,12817,12817,1057,12826,12826,12826,1053,12835,12835,
            12835,1050,12844,12844,12844,1033,12853,12853,12853,1021,
            12862,12862,12862,1011,12871,12871,12871,1004,12880,12880,
            12880,996,12889,12889,12889,989,12898,12898,12898,973,
            12907,12907,12907,970,12916,12916,12916,967,12925,12925,
            12925,955,12934,12934,12934,941,12943,12943,12943,938,
            12952,12952,12952,935,12961,12961,12961,923,12970,12970,
            12970,920,12979,12979,12979,917,12988,12988,12988,909,
            12997,12997,12997,906,13006,13006,13006,1127,13015,13015,
            13015,1122,13024,13024,13024,1110,13033,13033,13033,1103,
            13042,13042,13042,1099,13051,13051,13051,1093,13060,13060,
            13060,1090,13069,13069,13069,1087,13078,13078,13078,1085,
            13087,13087,13087,1046,13096,13096,13096,1035,13105,13105,
            13105,1030,13114,13114,13114,1026,13123,13123,13123,1024,
            13132,13132,13132,1017,13141,13141,13141,1014,13150,13150,
            13150,1005,13159,13159,13159,1000,13168,13168,13168,998,
            13177,13177,13177,990,13186,13186,13186,984,13195,13195,
            13195,981,13204,13204,13204,978,13213,13213,13213,964,
            13222,13222,13222,961,13231,13231,13231,959,13240,13240,
            13240,956,13249,13249,13249,946,13258,13258,13258,944,
            13267,13267,13267,932,13276,13276,13276,930,13285,13285,
            13285,928,13294,13294,13294,925,13303,13303,13303,910,
            13312,13312,13312,902,13321,13321,13321,899,13330,13330,
            13330,947,13339,13339,13339,948,13348,13348,13348,1095,
            13357,13357,13357,976,13366,13366,13366,949,13375,13375,
            13375,893,13393,13384,13402,869,869,6110,6110,6110,
            6110,6110,6110,6110,6110,6110,6110,6110,4565,4565,
            6110,5562,5562,1523,1523,4706,4706,4663,4663,869,
            4613,4613,4484,4600,4484,4600,6110,4960,4960,6110,
            4616,869,869,4616,6110,869,6110,4610,4610,4959,
            4962,4962,4959,6110,6110,6110,3125,6110,3125,4967,
            4967,4975,4975,6110,6110,869,4973,4973,4970,4972,
            4970,4972,1168,869,1168,4977,4977,4986,4986,6110,
            6110,869,6110,6110,4992,4988,4988,4992,5002,5002,
            4998,4998,4999,6110,4999,869,6110,6110,6110,6110,
            5007,6110,5007,6110,5023,5023,6110,6110,5014,6110,
            5014,5008,5033,5033,5008,6110,5047,5047,6110,6110,
            5064,5064,5038,5036,5038,5070,5036,5070,5067,5067,
            5052,5030,5030,5052,6110,6110,4459,4459,5058,6110,
            6110,5058,6110,6110,6110,4469,4469,6110,4487,4487,
            5084,5084,6110,6110,6110,5051,5051,6110,5085,5085,
            5094,5094,5086,5086,5117,5117,5099,5099,5106,5106,
            6110,869,6110,6110,5091,869,6110,5091,5114,6110,
            5114,6110,6110,6110,6110,6110,5120,5131,5131,5120,
            5542,5542,5118,5118,5125,5125,5146,5146,5122,6110,
            5122,6110,5126,6110,5126,5136,5136,6110,5161,6110,
            5161,5132,5132,6110,5148,6110,6110,5148,6110,7116,
            7116,869,5151,5151,5155,5155,5157,5157,6110,1275,
            1275,5147,5147,5152,5152,5137,6110,6110,5137,6110,
            6110,5167,5167,6110,6110,6110,6110,6110,5166,6110,
            5166,5177,5177,6110,5194,5194,5193,5193,6110,5191,
            5191,6110,5195,5195,5056,5056,5306,5306,6110,5389,
            5389,6110,6110,5308,5308,6110,5321,5546,5546,5321,
            6110,5314,5314,6110,5310,5310,6110,5311,6110,5311,
            6110,5313,5313,6110,5315,5315,6110,869,6110,5317,
            5317,5318,5318,5323,5323,6110,5324,5324,6110,5320,
            5320,6110,5335,6110,6110,5335,7075,7075,6110,5336,
            5336,6110,5337,5337,5334,6110,5334,6110,5240,5344,
            5344,5240,6110,6110,5342,5342,6110,869,6110,6110,
            5351,5351,6110,5338,5345,5345,5338,5358,5358,5355,
            5355,7109,6110,7109,6110,5360,5360,6110,6110,6110,
            7141,7141,869,6110,5366,6110,5366,6110,5371,5371,
            6110,5373,5373,6110,7194,7194,6110,6110,5385,5385,
            7196,7196,6110,7172,7172,5384,5384,5376,5376,5378,
            6110,5378,6110,5392,5392,6110,6110,6110,1040,5390,
            5390,6110,5383,6110,5383,6110,5396,5396,5397,5397,
            6110,6110,5408,5408,5414,5414,5428,5428,5419,5419,
            5415,5415,6110,6110,6110,6110,869,5503,5503,6110,
            5429,6110,6110,5429,5430,6110,869,5430,5521,5521,
            5517,5517,5462,5531,5531,5462,5510,5510,6110,5512,
            5512,5524,5524,5518,5511,5518,6110,5511,6110,5523,
            5523,869,6110,5535,6110,5535,6110,5538,5538,6110,
            6110,7070,7070,5551,5551,6110,6110,6110,6110,5537,
            7135,7135,5537,869,7087,7087,5549,5549,5543,6110,
            5543,5563,5563,5550,5550,5558,5558,6110,6110,869,
            6110,5557,5566,5566,5557,6110,5553,5553,6110,6110,
            5564,6110,5564,5568,5568,5567,5567,5588,5588,5582,
            5575,5575,5582,6110,3221,3221,5574,6110,5574,6110,
            6110,6110,5583,5583,7229,7229,5593,5593,5576,5576,
            6110,5599,5599,6110,6110,5594,5594,5592,5592,6110,
            6110,6110,6110,6110,6110,5601,5601,6110,5598,5598,
            6110,6110,6110,6110,6110,7013,7013,6110,6110,5597,
            869,5597,6110,6110,5602,5602,3090,5603,3090,5603,
            7149,7149,5620,5620,6110,6110,7151,6110,5617,7151,
            5617,6110,6110,5608,5607,5607,5608,5647,5624,5647,
            5624,6110,6110,5609,5609,6110,5619,5619,6110,5632,
            5632,5631,5631,6110,5638,5638,6110,5639,5639,6110,
            6110,5640,5640,6110,5645,5645,5621,5621,5641,5641,
            6110,6110,6110,6110,6110,7043,7043,7041,7041,7039,
            7039,6110,5652,5652,6110,6110,5646,5646,869,6110,
            5654,5654,6110,6110,7089,7089,5658,5658,6110,5648,
            5648,5667,5667,5668,5668,6110,6110,6110,6110,6110,
            5666,5666,5662,5662,6110,5659,6110,5659,6110,7122,
            7122,5656,5656,7157,7157,6110,6110,6110,6110,5674,
            5677,5677,5674,6110,5678,5678,6110,6110,5679,7144,
            7144,5679,7198,7198,6110,6110,5676,5676,6110,5687,
            5687,6110,6110,7206,7206,5660,5660,6110,5683,6110,
            6110,5683,7204,7204,7201,7201,6110,6110,7242,7242,
            6110,5691,5691,6110,5698,5698,6110,5693,6110,5693,
            6110,6110,5695,5695,1043,6983,6983,6110,7223,7223,
            6110,5699,869,6110,5699,7217,7217,6110,6110,5707,
            5707,6110,7152,7152,6110,6110,5706,5706,6110,6110,
            5710,5710,6110,6110,5711,5711,6110,5713,5713,5715,
            6110,5715,5726,5726,6110,6977,6977,7233,7233,5730,
            5730,6110,5728,5728,6110,6110,5731,5731,7028,7028,
            7034,7034,6110,6110,6110,6110,6110,6110,5732,5732,
            5738,5738,6110,6110,6110,6110,6110,6110,5733,5733,
            6110,5744,5744,6110,6110,5749,5749,5734,5748,5748,
            5734,5751,5751,6110,5736,7111,7111,5736,6110,5740,
            5740,6110,5747,6110,6110,5747,5750,5750,6110,7125,
            7125,5759,5759,6110,5758,5758,6110,6110,5757,5757,
            6110,7175,7175,5752,5752,6110,5765,5765,5763,5763,
            6110,5766,5766,7221,7221,6110,6110,6110,6110,6110,
            5767,5767,6110,6110,6110,6110,5769,5769,6110,5768,
            5768,5778,5778,5780,5780,6110,5781,5781,869,6110,
            5799,5799,5779,5779,6110,5803,5803,5784,5777,5777,
            5784,6110,6110,6110,5788,6110,5792,5788,6110,5792,
            6110,5808,5808,6110,6110,5804,6110,5804,6110,5813,
            5813,7017,7017,5814,5814,5810,5810,5815,5815,6110,
            6110,5816,5816,7052,7052,6110,6110,6110,6110,6110,
            5820,5820,6110,5817,5817,6110,5826,5826,5822,5822,
            5828,5828,6110,7101,7101,6110,5824,6110,5824,6110,
            6110,5840,5840,6110,5830,5830,5838,5838,6110,5831,
            5832,5832,5831,6110,5839,5839,6110,6110,7246,7246,
            5847,5847,5854,5854,6110,6110,5848,6110,5848,5843,
            6110,6110,5843,6110,6110,5860,5860,5850,5850,7154,
            5857,5857,7154,5842,5842,6110,5865,5865,6110,6110,
            6110,6110,6110,6110,5853,5853,5866,5866,6110,6110,
            5869,5869,6110,5856,5856,6110,6110,5889,5889,5876,
            5876,6110,5868,5868,6110,7024,5881,5881,7024,6110,
            5872,5872,5873,6110,5882,5873,6110,5882,5887,5887,
            5894,5894,7072,7072,6110,6110,5893,5893,6110,7164,
            7164,6110,6110,5875,5875,6110,5898,5898,6110,5896,
            5896,7235,7235,5901,5901,6110,5895,6110,6110,5895,
            6110,6110,6110,6110,5921,5921,6110,5897,5899,5899,
            5897,6110,5906,5906,5908,5908,7119,5927,5927,7119,
            5926,5926,5928,5928,5932,5932,7118,6110,6110,7118,
            6110,869,6110,5934,5934,6110,7084,7084,6110,6110,
            6110,6110,6110,5935,5935,6110,7004,7004,6110,5933,
            5933,6110,5937,5937,6110,6110,7236,7236,5938,6110,
            5938,5936,7132,5936,6110,7132,6110,6110,5952,5952,
            5941,7238,7238,5941,6110,6110,5953,5953,6110,5940,
            5940,6110,6110,5957,5957,5955,5960,5960,5955,6110,
            6110,7021,7021,6110,5969,5969,6110,6110,5972,5972,
            6110,7010,7010,6110,5974,6110,5974,6110,6110,6110,
            7036,7036,6110,6110,5975,5975,6110,5980,5980,6110,
            5983,5983,5978,6110,5978,7178,7178,7189,7189,5982,
            6110,5982,5984,5984,6110,6110,5989,5989,6110,7224,
            7224
        };
    };

    public interface TermAction1 {
        public final static char termAction1[] = {
            6110,7117,7128,7128,7117,6110,6002,6002,6110,7216,
            7216,7025,7025,6110,6110,6003,6003,6004,6004,6110,
            6005,6005,6110,5939,5939,6110,6110,6110,6006,6006,
            6110,6015,6015,6110,6110,6110,6007,6007,6110,6110,
            6110,6008,6008,6110,6022,6022,6110,6024,6024,6110,
            6110,6010,6110,6010,6110,6023,6023,6025,6025,6110,
            6012,6110,6012,7168,7168,6034,6034,6027,6027,7060,
            7060,6110,3649,3649,6110,6040,6040,6110,6110,7092,
            7092,6110,6035,6035,6110,6047,6047,6110,6110,6110,
            6110,6110,6110,6049,6049,6050,6050,6110,6065,6065,
            6110,6110,7067,7067,6110,6082,6082,7225,7225,6110,
            6110,6110,7182,7182,1040,6060,6060,6071,1040,6071,
            6070,6070,6110,6110,6083,6083,6084,6084,6096,6096,
            7096,7096,6094,6094,6110,6110,6110,6110,6110,7146,
            7146,6098,6098,7137,7137,6110,29,6110,6110,29,
            30,6110,6110,30
        };
    };

    public final static char termAction[] = new char[TermAction0.termAction0.length + TermAction1.termAction1.length];
    {
        int index = 0;
        System.arraycopy(TermAction0.termAction0, 0, termAction, index, TermAction0.termAction0.length);
        index += TermAction0.termAction0.length;
        System.arraycopy(TermAction1.termAction1, 0, termAction, index, TermAction1.termAction1.length);
    };
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
