package org.eclipse.imp.lpg.parser;

import lpg.runtime.*;
import org.eclipse.imp.parser.IParser;
import org.eclipse.imp.parser.SymbolTable;
    import java.util.ArrayList;
    import java.util.List;
    import java.util.Map;
    import java.util.HashMap;
    import java.util.Set;
 
public class LPGParser implements RuleAction, IParser
{
    private PrsStream prsStream = null;
    
    private boolean unimplementedSymbolsWarning = false;

    private static ParseTable prsTable = new LPGParserprs();
    public ParseTable getParseTable() { return prsTable; }

    private DeterministicParser dtParser = null;
    public DeterministicParser getParser() { return dtParser; }

    private void setResult(Object object) { dtParser.setSym1(object); }
    public Object getRhsSym(int i) { return dtParser.getSym(i); }

    public int getRhsTokenIndex(int i) { return dtParser.getToken(i); }
    public IToken getRhsIToken(int i) { return prsStream.getIToken(getRhsTokenIndex(i)); }
    
    public int getRhsFirstTokenIndex(int i) { return dtParser.getFirstToken(i); }
    public IToken getRhsFirstIToken(int i) { return prsStream.getIToken(getRhsFirstTokenIndex(i)); }

    public int getRhsLastTokenIndex(int i) { return dtParser.getLastToken(i); }
    public IToken getRhsLastIToken(int i) { return prsStream.getIToken(getRhsLastTokenIndex(i)); }

    public int getLeftSpan() { return dtParser.getFirstToken(); }
    public IToken getLeftIToken()  { return prsStream.getIToken(getLeftSpan()); }

    public int getRightSpan() { return dtParser.getLastToken(); }
    public IToken getRightIToken() { return prsStream.getIToken(getRightSpan()); }

    public int getRhsErrorTokenIndex(int i)
    {
        int index = dtParser.getToken(i);
        IToken err = prsStream.getIToken(index);
        return (err instanceof ErrorToken ? index : 0);
    }
    public ErrorToken getRhsErrorIToken(int i)
    {
        int index = dtParser.getToken(i);
        IToken err = prsStream.getIToken(index);
        return (ErrorToken) (err instanceof ErrorToken ? err : null);
    }

    public void reset(ILexStream lexStream)
    {
        prsStream = new PrsStream(lexStream);
        dtParser.reset(prsStream);

        try
        {
            prsStream.remapTerminalSymbols(orderedTerminalSymbols(), prsTable.getEoftSymbol());
        }
        catch(NullExportedSymbolsException e) {
        }
        catch(NullTerminalSymbolsException e) {
        }
        catch(UnimplementedTerminalsException e)
        {
            if (unimplementedSymbolsWarning) {
                java.util.ArrayList unimplemented_symbols = e.getSymbols();
                System.out.println("The Lexer will not scan the following token(s):");
                for (int i = 0; i < unimplemented_symbols.size(); i++)
                {
                    Integer id = (Integer) unimplemented_symbols.get(i);
                    System.out.println("    " + LPGParsersym.orderedTerminalSymbols[id.intValue()]);               
                }
                System.out.println();
            }
        }
        catch(UndefinedEofSymbolException e)
        {
            throw new Error(new UndefinedEofSymbolException
                                ("The Lexer does not implement the Eof symbol " +
                                 LPGParsersym.orderedTerminalSymbols[prsTable.getEoftSymbol()]));
        }
    }
    
    public LPGParser()
    {
        try
        {
            dtParser = new DeterministicParser(prsStream, prsTable, (RuleAction) this);
        }
        catch (NotDeterministicParseTableException e)
        {
            throw new Error(new NotDeterministicParseTableException
                                ("Regenerate LPGParserprs.java with -NOBACKTRACK option"));
        }
        catch (BadParseSymFileException e)
        {
            throw new Error(new BadParseSymFileException("Bad Parser Symbol File -- LPGParsersym.java. Regenerate LPGParserprs.java"));
        }
    }

    public LPGParser(ILexStream lexStream)
    {
        this();
        reset(lexStream);
    }

    public int numTokenKinds() { return LPGParsersym.numTokenKinds; }
    public String[] orderedTerminalSymbols() { return LPGParsersym.orderedTerminalSymbols; }
    public String getTokenKindName(int kind) { return LPGParsersym.orderedTerminalSymbols[kind]; }            
    public int getEOFTokenKind() { return prsTable.getEoftSymbol(); }
    public IPrsStream getIPrsStream() { return prsStream; }

    /**
     * @deprecated replaced by {@link #getIPrsStream()}
     *
     */
    public PrsStream getPrsStream() { return prsStream; }

    /**
     * @deprecated replaced by {@link #getIPrsStream()}
     *
     */
    public PrsStream getParseStream() { return prsStream; }

    public Object parser()
    {
        return parser(null, 0);
    }
        
    public Object parser(Monitor monitor)
    {
        return parser(monitor, 0);
    }
        
    public Object parser(int error_repair_count)
    {
        return parser(null, error_repair_count);
    }
        
    public Object parser(Monitor monitor, int error_repair_count)
    {
        dtParser.setMonitor(monitor);

        try
        {
            return (Object) dtParser.parse();
        }
        catch (BadParseException e)
        {
            prsStream.reset(e.error_token); // point to error token

            DiagnoseParser diagnoseParser = new DiagnoseParser(prsStream, prsTable);
            diagnoseParser.diagnose(e.error_token);
        }

        return null;
    }

    //
    // Additional entry points, if any
    //
    

    protected static SymbolTable<ASTNode> symtab= new SymbolTable<ASTNode>();
     static public abstract class ASTNode implements IAst
    {
        public IAst getNextAst() { return null; }
        protected IToken leftIToken,
                         rightIToken;
        protected IAst parent = null;
        protected void setParent(IAst parent) { this.parent = parent; }
        public IAst getParent() { return parent; }

        public IToken getLeftIToken() { return leftIToken; }
        public IToken getRightIToken() { return rightIToken; }
        public IToken[] getPrecedingAdjuncts() { return leftIToken.getPrecedingAdjuncts(); }
        public IToken[] getFollowingAdjuncts() { return rightIToken.getFollowingAdjuncts(); }

        public String toString()
        {
            return leftIToken.getILexStream().toString(leftIToken.getStartOffset(), rightIToken.getEndOffset());
        }

        public ASTNode(IToken token) { this.leftIToken = this.rightIToken = token; }
        public ASTNode(IToken leftIToken, IToken rightIToken)
        {
            this.leftIToken = leftIToken;
            this.rightIToken = rightIToken;
        }

        void initialize() {}

        /**
         * A list of all children of this node, excluding the null ones.
         */
        public java.util.ArrayList getChildren()
        {
            java.util.ArrayList list = getAllChildren();
            int k = -1;
            for (int i = 0; i < list.size(); i++)
            {
                Object element = list.get(i);
                if (element != null)
                {
                    if (++k != i)
                        list.set(k, element);
                }
            }
            for (int i = list.size() - 1; i > k; i--) // remove extraneous elements
                list.remove(i);
            return list;
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public abstract java.util.ArrayList getAllChildren();

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ASTNode)) return false;
            ASTNode other = (ASTNode) o;
            return getLeftIToken().getILexStream() == other.getLeftIToken().getILexStream() &&
                   getLeftIToken().getTokenIndex() == other.getLeftIToken().getTokenIndex() &&
                   getRightIToken().getILexStream() == other.getRightIToken().getILexStream() &&
                   getRightIToken().getTokenIndex() == other.getRightIToken().getTokenIndex();
        }

        public int hashCode()
        {
            int hash = 7;
            if (getLeftIToken().getILexStream() != null) hash = hash * 31 + getLeftIToken().getILexStream().hashCode();
            hash = hash * 31 + getLeftIToken().getTokenIndex();
            if (getRightIToken().getILexStream() != null) hash = hash * 31 + getRightIToken().getILexStream().hashCode();
            hash = hash * 31 + getRightIToken().getTokenIndex();
            return hash;
        }
        public abstract void accept(IAstVisitor v);
    }

    static public abstract class AbstractASTNodeList extends ASTNode implements IAbstractArrayList<ASTNode>
    {
        private boolean leftRecursive;
        private java.util.ArrayList list;
        public int size() { return list.size(); }
        public java.util.List getList() { return list; }
        public ASTNode getElementAt(int i) { return (ASTNode) list.get(leftRecursive ? i : list.size() - 1 - i); }
        public java.util.ArrayList getArrayList()
        {
            if (! leftRecursive) // reverse the list 
            {
                for (int i = 0, n = list.size() - 1; i < n; i++, n--)
                {
                    Object ith = list.get(i),
                           nth = list.get(n);
                    list.set(i, nth);
                    list.set(n, ith);
                }
                leftRecursive = true;
            }
            return list;
        }
        public void add(ASTNode element)
        {
            list.add(element);
            if (leftRecursive)
                 rightIToken = element.getRightIToken();
            else leftIToken = element.getLeftIToken();
        }

        public AbstractASTNodeList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken);
            this.leftRecursive = leftRecursive;
            list = new java.util.ArrayList();
        }

        public AbstractASTNodeList(ASTNode element, boolean leftRecursive)
        {
            this(element.getLeftIToken(), element.getRightIToken(), leftRecursive);
            list.add(element);
        }

        /**
         * Make a copy of the list and return it. Note that we obtain the local list by
         * invoking getArrayList so as to make sure that the list we return is in proper order.
         */
        public java.util.ArrayList getAllChildren()
        {
            return (java.util.ArrayList) getArrayList().clone();
        }

    }

    static public class ASTNodeToken extends ASTNode implements IASTNodeToken
    {
        public ASTNodeToken(IToken token) { super(token); }
        public IToken getIToken() { return leftIToken; }
        public String toString() { return leftIToken.toString(); }

        /**
         * A token class has no children. So, we return the empty list.
         */
        public java.util.ArrayList getAllChildren() { return new java.util.ArrayList(); }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ASTNodeToken)) return false;
            ASTNodeToken other = (ASTNodeToken) o;
            return getIToken().getILexStream() == other.getIToken().getILexStream() &&
                   getIToken().getTokenIndex() == other.getIToken().getTokenIndex();
        }

        public int hashCode()
        {
            int hash = 7;
            if (getIToken().getILexStream() != null) hash = hash * 31 + getIToken().getILexStream().hashCode();
            hash = hash * 31 + getIToken().getTokenIndex();
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>alias_lhs_macro_name
     *<li>macro_segment
     *<li>optMacroName
     *<li>include_segment
     *<li>RuleName
     *<li>symAttrs
     *<li>action_segment
     *<li>recover_symbol
     *<li>END_KEY_OPT
     *<li>alias_rhs__SYMBOL
     *<li>alias_rhs__MACRO_NAME
     *<li>alias_rhs__ERROR_KEY
     *<li>alias_rhs__EOL_KEY
     *<li>alias_rhs__EOF_KEY
     *<li>alias_rhs__EMPTY_KEY
     *<li>alias_rhs__IDENTIFIER_KEY
     *<li>macro_name_symbol__MACRO_NAME
     *<li>macro_name_symbol__SYMBOL
     *<li>name__SYMBOL
     *<li>name__MACRO_NAME
     *<li>name__EMPTY_KEY
     *<li>name__ERROR_KEY
     *<li>name__EOL_KEY
     *<li>name__IDENTIFIER_KEY
     *<li>produces__EQUIVALENCE
     *<li>produces__PRIORITY_EQUIVALENCE
     *<li>produces__ARROW
     *<li>produces__PRIORITY_ARROW
     *<li>symWithAttrs__EMPTY_KEY
     *<li>symWithAttrs__SYMBOL_optAttrList
     *<li>start_symbol__SYMBOL
     *<li>start_symbol__MACRO_NAME
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface IASTNodeToken
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>LPG</b>
     */
    public interface ILPG
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>option_specList</b>
     */
    public interface Ioptions_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>LPG_itemList</b>
     */
    public interface ILPG_INPUT
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>AliasSeg
     *<li>AstSeg
     *<li>DefineSeg
     *<li>EofSeg
     *<li>EolSeg
     *<li>ErrorSeg
     *<li>ExportSeg
     *<li>GlobalsSeg
     *<li>HeadersSeg
     *<li>IdentifierSeg
     *<li>ImportSeg
     *<li>IncludeSeg
     *<li>KeywordsSeg
     *<li>NamesSeg
     *<li>NoticeSeg
     *<li>RulesSeg
     *<li>SoftKeywordsSeg
     *<li>StartSeg
     *<li>TerminalsSeg
     *<li>TrailersSeg
     *<li>TypesSeg
     *<li>RecoverSeg
     *<li>PredecessorSeg
     *</ul>
     *</b>
     */
    public interface ILPG_item
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>aliasSpecList</b>
     */
    public interface Ialias_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>END_KEY_OPT</b>
     */
    public interface IEND_KEY_OPT extends IASTNodeToken {}

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Iast_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>defineSpecList</b>
     */
    public interface Idefine_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Ieof_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Ieol_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Ierror_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>terminal_symbolList</b>
     */
    public interface Iexport_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Iglobals_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Iheaders_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Iidentifier_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>import_segment</b>
     */
    public interface Iimport_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>include_segment</b>
     */
    public interface Iinclude_segment extends IASTNodeToken {}

    /**
     * is implemented by <b>keywordSpecList</b>
     */
    public interface Ikeywords_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>nameSpecList</b>
     */
    public interface Inames_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Inotice_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>rules_segment</b>
     */
    public interface Irules_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>start_symbolList</b>
     */
    public interface Istart_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>terminalList</b>
     */
    public interface Iterminals_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Itrailers_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>type_declarationsList</b>
     */
    public interface Itypes_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>SYMBOLList</b>
     */
    public interface Irecover_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>symbol_pairList</b>
     */
    public interface Ipredecessor_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>option_spec</b>
     */
    public interface Ioption_spec
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>optionList</b>
     */
    public interface Ioption_list
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>option</b>
     */
    public interface Ioption
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>option_value__EQUAL_SYMBOL
     *<li>option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN
     *</ul>
     *</b>
     */
    public interface Ioption_value
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>SYMBOLList</b>
     */
    public interface Isymbol_list
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>aliasSpec__ERROR_KEY_produces_alias_rhs
     *<li>aliasSpec__EOL_KEY_produces_alias_rhs
     *<li>aliasSpec__EOF_KEY_produces_alias_rhs
     *<li>aliasSpec__IDENTIFIER_KEY_produces_alias_rhs
     *<li>aliasSpec__SYMBOL_produces_alias_rhs
     *<li>aliasSpec__alias_lhs_macro_name_produces_alias_rhs
     *</ul>
     *</b>
     */
    public interface IaliasSpec
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>produces__EQUIVALENCE
     *<li>produces__PRIORITY_EQUIVALENCE
     *<li>produces__ARROW
     *<li>produces__PRIORITY_ARROW
     *</ul>
     *</b>
     */
    public interface Iproduces extends IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>alias_rhs__SYMBOL
     *<li>alias_rhs__MACRO_NAME
     *<li>alias_rhs__ERROR_KEY
     *<li>alias_rhs__EOL_KEY
     *<li>alias_rhs__EOF_KEY
     *<li>alias_rhs__EMPTY_KEY
     *<li>alias_rhs__IDENTIFIER_KEY
     *</ul>
     *</b>
     */
    public interface Ialias_rhs extends IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>alias_lhs_macro_name</b>
     */
    public interface Ialias_lhs_macro_name extends IASTNodeToken {}

    /**
     * is implemented by <b>action_segmentList</b>
     */
    public interface Iaction_segment_list extends Iast_segment, Iheaders_segment, Itrailers_segment {}

    /**
     * is implemented by <b>defineSpec</b>
     */
    public interface IdefineSpec
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>macro_name_symbol__MACRO_NAME
     *<li>macro_name_symbol__SYMBOL
     *</ul>
     *</b>
     */
    public interface Imacro_name_symbol extends IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>macro_segment</b>
     */
    public interface Imacro_segment extends IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Iterminal_symbol extends Ieol_segment, Ieof_segment, Ierror_segment, Iidentifier_segment, IkeywordSpec, IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>action_segment</b>
     */
    public interface Iaction_segment extends Iopt_action_segment, IASTNodeToken {}

    /**
     * is implemented by <b>drop_commandList</b>
     */
    public interface Idrop_command_list
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>drop_command__DROPSYMBOLS_KEY_drop_symbols
     *<li>drop_command__DROPRULES_KEY_drop_rules
     *</ul>
     *</b>
     */
    public interface Idrop_command
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>SYMBOLList</b>
     */
    public interface Idrop_symbols
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>drop_ruleList</b>
     */
    public interface Idrop_rules
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>drop_rule</b>
     */
    public interface Idrop_rule
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>optMacroName</b>
     */
    public interface IoptMacroName extends IASTNodeToken {}

    /**
     * is implemented by <b>ruleList</b>
     */
    public interface IruleList
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>keywordSpec
     *<li>terminal_symbol__SYMBOL
     *<li>terminal_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface IkeywordSpec
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>name__SYMBOL
     *<li>name__MACRO_NAME
     *<li>name__EMPTY_KEY
     *<li>name__ERROR_KEY
     *<li>name__EOL_KEY
     *<li>name__IDENTIFIER_KEY
     *</ul>
     *</b>
     */
    public interface Iname extends IASTNodeToken {}

    /**
     * is implemented by <b>nameSpec</b>
     */
    public interface InameSpec
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>nonTermList</b>
     */
    public interface InonTermList
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>nonTerm</b>
     */
    public interface InonTerm
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>RuleName</b>
     */
    public interface IruleNameWithAttributes extends IASTNodeToken {}

    /**
     * is implemented by <b>rule</b>
     */
    public interface Irule
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>symWithAttrsList</b>
     */
    public interface IsymWithAttrsList
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>action_segment</b>
     */
    public interface Iopt_action_segment
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by:
     *<b>
     *<ul>
     *<li>symWithAttrs__EMPTY_KEY
     *<li>symWithAttrs__SYMBOL_optAttrList
     *</ul>
     *</b>
     */
    public interface IsymWithAttrs extends IASTNodeToken {}

    /**
     * is implemented by <b>symAttrs</b>
     */
    public interface IoptAttrList extends IASTNodeToken {}

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by:
     *<b>
     *<ul>
     *<li>start_symbol__SYMBOL
     *<li>start_symbol__MACRO_NAME
     *</ul>
     *</b>
     */
    public interface Istart_symbol extends IASTNodeToken {}

    /**
     * is implemented by <b>terminal</b>
     */
    public interface Iterminal
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>optTerminalAlias</b>
     */
    public interface IoptTerminalAlias
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>type_declarations</b>
     */
    public interface Itype_declarations
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>SYMBOLList</b>
     */
    public interface IbarSymbolList
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is implemented by <b>symbol_pair</b>
     */
    public interface Isymbol_pair
    {
        public IToken getLeftIToken();
        public IToken getRightIToken();

        void accept(IAstVisitor v);
    }

    /**
     * is always implemented by <b>ASTNodeToken</b>. It is also implemented by <b>recover_symbol</b>
     */
    public interface Irecover_symbol extends IASTNodeToken {}

    /**
     *<b>
     *<li>Rule 1:  LPG ::= options_segment LPG_INPUT
     *</b>
     */
    static public class LPG extends ASTNode implements ILPG
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        private option_specList _options_segment;
        private LPG_itemList _LPG_INPUT;

        public option_specList getoptions_segment() { return _options_segment; }
        public LPG_itemList getLPG_INPUT() { return _LPG_INPUT; }

        public LPG(LPGParser environment, IToken leftIToken, IToken rightIToken,
                   option_specList _options_segment,
                   LPG_itemList _LPG_INPUT)
        {
            super(leftIToken, rightIToken);

            this.environment = environment;
            this._options_segment = _options_segment;
            ((ASTNode) _options_segment).setParent(this);
            this._LPG_INPUT = _LPG_INPUT;
            ((ASTNode) _LPG_INPUT).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_options_segment);
            list.add(_LPG_INPUT);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof LPG)) return false;
            if (! super.equals(o)) return false;
            LPG other = (LPG) o;
            if (! _options_segment.equals(other._options_segment)) return false;
            if (! _LPG_INPUT.equals(other._LPG_INPUT)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_options_segment.hashCode());
            hash = hash * 31 + (_LPG_INPUT.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _options_segment.accept(v);
                _LPG_INPUT.accept(v);
            }
            v.endVisit(this);
        }

    public SymbolTable<ASTNode> symbolTable;
    void initialize() { symbolTable = symtab; }
     }

    /**
     *<b>
     *<li>Rule 2:  LPG_INPUT ::= $Empty
     *<li>Rule 3:  LPG_INPUT ::= LPG_INPUT LPG_item
     *</b>
     */
    static public class LPG_itemList extends AbstractASTNodeList implements ILPG_INPUT
    {
        public ILPG_item getLPG_itemAt(int i) { return (ILPG_item) getElementAt(i); }

        public LPG_itemList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public LPG_itemList(ILPG_item _LPG_item, boolean leftRecursive)
        {
            super((ASTNode) _LPG_item, leftRecursive);
            ((ASTNode) _LPG_item).setParent(this);
        }

        public void add(ILPG_item _LPG_item)
        {
            super.add((ASTNode) _LPG_item);
            ((ASTNode) _LPG_item).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof LPG_itemList)) return false;
            if (! super.equals(o)) return false;
            LPG_itemList other = (LPG_itemList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                ILPG_item element = getLPG_itemAt(i);
                    if (! element.equals(other.getLPG_itemAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getLPG_itemAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    ILPG_item element = getLPG_itemAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 4:  LPG_item ::= ALIAS_KEY$ alias_segment END_KEY_OPT$
     *</b>
     */
    static public class AliasSeg extends ASTNode implements ILPG_item
    {
        private aliasSpecList _alias_segment;

        public aliasSpecList getalias_segment() { return _alias_segment; }

        public AliasSeg(IToken leftIToken, IToken rightIToken,
                        aliasSpecList _alias_segment)
        {
            super(leftIToken, rightIToken);

            this._alias_segment = _alias_segment;
            ((ASTNode) _alias_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_alias_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof AliasSeg)) return false;
            if (! super.equals(o)) return false;
            AliasSeg other = (AliasSeg) o;
            if (! _alias_segment.equals(other._alias_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_alias_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _alias_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 5:  LPG_item ::= AST_KEY$ ast_segment END_KEY_OPT$
     *</b>
     */
    static public class AstSeg extends ASTNode implements ILPG_item
    {
        private action_segmentList _ast_segment;

        public action_segmentList getast_segment() { return _ast_segment; }

        public AstSeg(IToken leftIToken, IToken rightIToken,
                      action_segmentList _ast_segment)
        {
            super(leftIToken, rightIToken);

            this._ast_segment = _ast_segment;
            ((ASTNode) _ast_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_ast_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof AstSeg)) return false;
            if (! super.equals(o)) return false;
            AstSeg other = (AstSeg) o;
            if (! _ast_segment.equals(other._ast_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_ast_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _ast_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 6:  LPG_item ::= DEFINE_KEY$ define_segment END_KEY_OPT$
     *</b>
     */
    static public class DefineSeg extends ASTNode implements ILPG_item
    {
        private defineSpecList _define_segment;

        public defineSpecList getdefine_segment() { return _define_segment; }

        public DefineSeg(IToken leftIToken, IToken rightIToken,
                         defineSpecList _define_segment)
        {
            super(leftIToken, rightIToken);

            this._define_segment = _define_segment;
            ((ASTNode) _define_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_define_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof DefineSeg)) return false;
            if (! super.equals(o)) return false;
            DefineSeg other = (DefineSeg) o;
            if (! _define_segment.equals(other._define_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_define_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _define_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 7:  LPG_item ::= EOF_KEY$ eof_segment END_KEY_OPT$
     *</b>
     */
    static public class EofSeg extends ASTNode implements ILPG_item
    {
        private Ieof_segment _eof_segment;

        public Ieof_segment geteof_segment() { return _eof_segment; }

        public EofSeg(IToken leftIToken, IToken rightIToken,
                      Ieof_segment _eof_segment)
        {
            super(leftIToken, rightIToken);

            this._eof_segment = _eof_segment;
            ((ASTNode) _eof_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_eof_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof EofSeg)) return false;
            if (! super.equals(o)) return false;
            EofSeg other = (EofSeg) o;
            if (! _eof_segment.equals(other._eof_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_eof_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _eof_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 8:  LPG_item ::= EOL_KEY$ eol_segment END_KEY_OPT$
     *</b>
     */
    static public class EolSeg extends ASTNode implements ILPG_item
    {
        private Ieol_segment _eol_segment;

        public Ieol_segment geteol_segment() { return _eol_segment; }

        public EolSeg(IToken leftIToken, IToken rightIToken,
                      Ieol_segment _eol_segment)
        {
            super(leftIToken, rightIToken);

            this._eol_segment = _eol_segment;
            ((ASTNode) _eol_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_eol_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof EolSeg)) return false;
            if (! super.equals(o)) return false;
            EolSeg other = (EolSeg) o;
            if (! _eol_segment.equals(other._eol_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_eol_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _eol_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 9:  LPG_item ::= ERROR_KEY$ error_segment END_KEY_OPT$
     *</b>
     */
    static public class ErrorSeg extends ASTNode implements ILPG_item
    {
        private Ierror_segment _error_segment;

        public Ierror_segment geterror_segment() { return _error_segment; }

        public ErrorSeg(IToken leftIToken, IToken rightIToken,
                        Ierror_segment _error_segment)
        {
            super(leftIToken, rightIToken);

            this._error_segment = _error_segment;
            ((ASTNode) _error_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_error_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ErrorSeg)) return false;
            if (! super.equals(o)) return false;
            ErrorSeg other = (ErrorSeg) o;
            if (! _error_segment.equals(other._error_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_error_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _error_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 10:  LPG_item ::= EXPORT_KEY$ export_segment END_KEY_OPT$
     *</b>
     */
    static public class ExportSeg extends ASTNode implements ILPG_item
    {
        private terminal_symbolList _export_segment;

        public terminal_symbolList getexport_segment() { return _export_segment; }

        public ExportSeg(IToken leftIToken, IToken rightIToken,
                         terminal_symbolList _export_segment)
        {
            super(leftIToken, rightIToken);

            this._export_segment = _export_segment;
            ((ASTNode) _export_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_export_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ExportSeg)) return false;
            if (! super.equals(o)) return false;
            ExportSeg other = (ExportSeg) o;
            if (! _export_segment.equals(other._export_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_export_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _export_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 11:  LPG_item ::= GLOBALS_KEY$ globals_segment END_KEY_OPT$
     *</b>
     */
    static public class GlobalsSeg extends ASTNode implements ILPG_item
    {
        private action_segmentList _globals_segment;

        public action_segmentList getglobals_segment() { return _globals_segment; }

        public GlobalsSeg(IToken leftIToken, IToken rightIToken,
                          action_segmentList _globals_segment)
        {
            super(leftIToken, rightIToken);

            this._globals_segment = _globals_segment;
            ((ASTNode) _globals_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_globals_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof GlobalsSeg)) return false;
            if (! super.equals(o)) return false;
            GlobalsSeg other = (GlobalsSeg) o;
            if (! _globals_segment.equals(other._globals_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_globals_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _globals_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 12:  LPG_item ::= HEADERS_KEY$ headers_segment END_KEY_OPT$
     *</b>
     */
    static public class HeadersSeg extends ASTNode implements ILPG_item
    {
        private action_segmentList _headers_segment;

        public action_segmentList getheaders_segment() { return _headers_segment; }

        public HeadersSeg(IToken leftIToken, IToken rightIToken,
                          action_segmentList _headers_segment)
        {
            super(leftIToken, rightIToken);

            this._headers_segment = _headers_segment;
            ((ASTNode) _headers_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_headers_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof HeadersSeg)) return false;
            if (! super.equals(o)) return false;
            HeadersSeg other = (HeadersSeg) o;
            if (! _headers_segment.equals(other._headers_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_headers_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _headers_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 13:  LPG_item ::= IDENTIFIER_KEY$ identifier_segment END_KEY_OPT$
     *</b>
     */
    static public class IdentifierSeg extends ASTNode implements ILPG_item
    {
        private Iidentifier_segment _identifier_segment;

        public Iidentifier_segment getidentifier_segment() { return _identifier_segment; }

        public IdentifierSeg(IToken leftIToken, IToken rightIToken,
                             Iidentifier_segment _identifier_segment)
        {
            super(leftIToken, rightIToken);

            this._identifier_segment = _identifier_segment;
            ((ASTNode) _identifier_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_identifier_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof IdentifierSeg)) return false;
            if (! super.equals(o)) return false;
            IdentifierSeg other = (IdentifierSeg) o;
            if (! _identifier_segment.equals(other._identifier_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_identifier_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _identifier_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 14:  LPG_item ::= IMPORT_KEY$ import_segment END_KEY_OPT$
     *</b>
     */
    static public class ImportSeg extends ASTNode implements ILPG_item
    {
        private import_segment _import_segment;

        public import_segment getimport_segment() { return _import_segment; }

        public ImportSeg(IToken leftIToken, IToken rightIToken,
                         import_segment _import_segment)
        {
            super(leftIToken, rightIToken);

            this._import_segment = _import_segment;
            ((ASTNode) _import_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_import_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ImportSeg)) return false;
            if (! super.equals(o)) return false;
            ImportSeg other = (ImportSeg) o;
            if (! _import_segment.equals(other._import_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_import_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _import_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 15:  LPG_item ::= INCLUDE_KEY$ include_segment END_KEY_OPT$
     *</b>
     */
    static public class IncludeSeg extends ASTNode implements ILPG_item
    {
        private include_segment _include_segment;

        public include_segment getinclude_segment() { return _include_segment; }

        public IncludeSeg(IToken leftIToken, IToken rightIToken,
                          include_segment _include_segment)
        {
            super(leftIToken, rightIToken);

            this._include_segment = _include_segment;
            ((ASTNode) _include_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_include_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof IncludeSeg)) return false;
            if (! super.equals(o)) return false;
            IncludeSeg other = (IncludeSeg) o;
            if (! _include_segment.equals(other._include_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_include_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _include_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 16:  LPG_item ::= KEYWORDS_KEY$ keywords_segment END_KEY_OPT$
     *</b>
     */
    static public class KeywordsSeg extends ASTNode implements ILPG_item
    {
        private keywordSpecList _keywords_segment;

        public keywordSpecList getkeywords_segment() { return _keywords_segment; }

        public KeywordsSeg(IToken leftIToken, IToken rightIToken,
                           keywordSpecList _keywords_segment)
        {
            super(leftIToken, rightIToken);

            this._keywords_segment = _keywords_segment;
            ((ASTNode) _keywords_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_keywords_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof KeywordsSeg)) return false;
            if (! super.equals(o)) return false;
            KeywordsSeg other = (KeywordsSeg) o;
            if (! _keywords_segment.equals(other._keywords_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_keywords_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _keywords_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 17:  LPG_item ::= NAMES_KEY$ names_segment END_KEY_OPT$
     *</b>
     */
    static public class NamesSeg extends ASTNode implements ILPG_item
    {
        private nameSpecList _names_segment;

        public nameSpecList getnames_segment() { return _names_segment; }

        public NamesSeg(IToken leftIToken, IToken rightIToken,
                        nameSpecList _names_segment)
        {
            super(leftIToken, rightIToken);

            this._names_segment = _names_segment;
            ((ASTNode) _names_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_names_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof NamesSeg)) return false;
            if (! super.equals(o)) return false;
            NamesSeg other = (NamesSeg) o;
            if (! _names_segment.equals(other._names_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_names_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _names_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 18:  LPG_item ::= NOTICE_KEY$ notice_segment END_KEY_OPT$
     *</b>
     */
    static public class NoticeSeg extends ASTNode implements ILPG_item
    {
        private action_segmentList _notice_segment;

        public action_segmentList getnotice_segment() { return _notice_segment; }

        public NoticeSeg(IToken leftIToken, IToken rightIToken,
                         action_segmentList _notice_segment)
        {
            super(leftIToken, rightIToken);

            this._notice_segment = _notice_segment;
            ((ASTNode) _notice_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_notice_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof NoticeSeg)) return false;
            if (! super.equals(o)) return false;
            NoticeSeg other = (NoticeSeg) o;
            if (! _notice_segment.equals(other._notice_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_notice_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _notice_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 19:  LPG_item ::= RULES_KEY$ rules_segment END_KEY_OPT$
     *</b>
     */
    static public class RulesSeg extends ASTNode implements ILPG_item
    {
        private rules_segment _rules_segment;

        public rules_segment getrules_segment() { return _rules_segment; }

        public RulesSeg(IToken leftIToken, IToken rightIToken,
                        rules_segment _rules_segment)
        {
            super(leftIToken, rightIToken);

            this._rules_segment = _rules_segment;
            ((ASTNode) _rules_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_rules_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof RulesSeg)) return false;
            if (! super.equals(o)) return false;
            RulesSeg other = (RulesSeg) o;
            if (! _rules_segment.equals(other._rules_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_rules_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _rules_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 20:  LPG_item ::= SOFT_KEYWORDS_KEY$ keywords_segment END_KEY_OPT$
     *</b>
     */
    static public class SoftKeywordsSeg extends ASTNode implements ILPG_item
    {
        private keywordSpecList _keywords_segment;

        public keywordSpecList getkeywords_segment() { return _keywords_segment; }

        public SoftKeywordsSeg(IToken leftIToken, IToken rightIToken,
                               keywordSpecList _keywords_segment)
        {
            super(leftIToken, rightIToken);

            this._keywords_segment = _keywords_segment;
            ((ASTNode) _keywords_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_keywords_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof SoftKeywordsSeg)) return false;
            if (! super.equals(o)) return false;
            SoftKeywordsSeg other = (SoftKeywordsSeg) o;
            if (! _keywords_segment.equals(other._keywords_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_keywords_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _keywords_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 21:  LPG_item ::= START_KEY$ start_segment END_KEY_OPT$
     *</b>
     */
    static public class StartSeg extends ASTNode implements ILPG_item
    {
        private start_symbolList _start_segment;

        public start_symbolList getstart_segment() { return _start_segment; }

        public StartSeg(IToken leftIToken, IToken rightIToken,
                        start_symbolList _start_segment)
        {
            super(leftIToken, rightIToken);

            this._start_segment = _start_segment;
            ((ASTNode) _start_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_start_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof StartSeg)) return false;
            if (! super.equals(o)) return false;
            StartSeg other = (StartSeg) o;
            if (! _start_segment.equals(other._start_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_start_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _start_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 22:  LPG_item ::= TERMINALS_KEY$ terminals_segment END_KEY_OPT$
     *</b>
     */
    static public class TerminalsSeg extends ASTNode implements ILPG_item
    {
        private terminalList _terminals_segment;

        public terminalList getterminals_segment() { return _terminals_segment; }

        public TerminalsSeg(IToken leftIToken, IToken rightIToken,
                            terminalList _terminals_segment)
        {
            super(leftIToken, rightIToken);

            this._terminals_segment = _terminals_segment;
            ((ASTNode) _terminals_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_terminals_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof TerminalsSeg)) return false;
            if (! super.equals(o)) return false;
            TerminalsSeg other = (TerminalsSeg) o;
            if (! _terminals_segment.equals(other._terminals_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_terminals_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _terminals_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 23:  LPG_item ::= TRAILERS_KEY$ trailers_segment END_KEY_OPT$
     *</b>
     */
    static public class TrailersSeg extends ASTNode implements ILPG_item
    {
        private action_segmentList _trailers_segment;

        public action_segmentList gettrailers_segment() { return _trailers_segment; }

        public TrailersSeg(IToken leftIToken, IToken rightIToken,
                           action_segmentList _trailers_segment)
        {
            super(leftIToken, rightIToken);

            this._trailers_segment = _trailers_segment;
            ((ASTNode) _trailers_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_trailers_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof TrailersSeg)) return false;
            if (! super.equals(o)) return false;
            TrailersSeg other = (TrailersSeg) o;
            if (! _trailers_segment.equals(other._trailers_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_trailers_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _trailers_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 24:  LPG_item ::= TYPES_KEY$ types_segment END_KEY_OPT$
     *</b>
     */
    static public class TypesSeg extends ASTNode implements ILPG_item
    {
        private type_declarationsList _types_segment;

        public type_declarationsList gettypes_segment() { return _types_segment; }

        public TypesSeg(IToken leftIToken, IToken rightIToken,
                        type_declarationsList _types_segment)
        {
            super(leftIToken, rightIToken);

            this._types_segment = _types_segment;
            ((ASTNode) _types_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_types_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof TypesSeg)) return false;
            if (! super.equals(o)) return false;
            TypesSeg other = (TypesSeg) o;
            if (! _types_segment.equals(other._types_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_types_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _types_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 25:  LPG_item ::= RECOVER_KEY$ recover_segment END_KEY_OPT$
     *</b>
     */
    static public class RecoverSeg extends ASTNode implements ILPG_item
    {
        private SYMBOLList _recover_segment;

        public SYMBOLList getrecover_segment() { return _recover_segment; }

        public RecoverSeg(IToken leftIToken, IToken rightIToken,
                          SYMBOLList _recover_segment)
        {
            super(leftIToken, rightIToken);

            this._recover_segment = _recover_segment;
            ((ASTNode) _recover_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_recover_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof RecoverSeg)) return false;
            if (! super.equals(o)) return false;
            RecoverSeg other = (RecoverSeg) o;
            if (! _recover_segment.equals(other._recover_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_recover_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _recover_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 26:  LPG_item ::= DISJOINTPREDECESSORSETS_KEY$ predecessor_segment END_KEY_OPT$
     *</b>
     */
    static public class PredecessorSeg extends ASTNode implements ILPG_item
    {
        private symbol_pairList _predecessor_segment;

        public symbol_pairList getpredecessor_segment() { return _predecessor_segment; }

        public PredecessorSeg(IToken leftIToken, IToken rightIToken,
                              symbol_pairList _predecessor_segment)
        {
            super(leftIToken, rightIToken);

            this._predecessor_segment = _predecessor_segment;
            ((ASTNode) _predecessor_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_predecessor_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof PredecessorSeg)) return false;
            if (! super.equals(o)) return false;
            PredecessorSeg other = (PredecessorSeg) o;
            if (! _predecessor_segment.equals(other._predecessor_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_predecessor_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _predecessor_segment.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 27:  options_segment ::= $Empty
     *<li>Rule 28:  options_segment ::= options_segment option_spec
     *</b>
     */
    static public class option_specList extends AbstractASTNodeList implements Ioptions_segment
    {
        public option_spec getoption_specAt(int i) { return (option_spec) getElementAt(i); }

        public option_specList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public option_specList(option_spec _option_spec, boolean leftRecursive)
        {
            super((ASTNode) _option_spec, leftRecursive);
            ((ASTNode) _option_spec).setParent(this);
        }

        public void add(option_spec _option_spec)
        {
            super.add((ASTNode) _option_spec);
            ((ASTNode) _option_spec).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof option_specList)) return false;
            if (! super.equals(o)) return false;
            option_specList other = (option_specList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                option_spec element = getoption_specAt(i);
                    if (! element.equals(other.getoption_specAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getoption_specAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    option_spec element = getoption_specAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 29:  option_spec ::= OPTIONS_KEY$ option_list
     *</b>
     */
    static public class option_spec extends ASTNode implements Ioption_spec
    {
        private optionList _option_list;

        public optionList getoption_list() { return _option_list; }

        public option_spec(IToken leftIToken, IToken rightIToken,
                           optionList _option_list)
        {
            super(leftIToken, rightIToken);

            this._option_list = _option_list;
            ((ASTNode) _option_list).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_option_list);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof option_spec)) return false;
            if (! super.equals(o)) return false;
            option_spec other = (option_spec) o;
            if (! _option_list.equals(other._option_list)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_option_list.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _option_list.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 30:  option_list ::= option
     *<li>Rule 31:  option_list ::= option_list ,$ option
     *</b>
     */
    static public class optionList extends AbstractASTNodeList implements Ioption_list
    {
        public option getoptionAt(int i) { return (option) getElementAt(i); }

        public optionList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public optionList(option _option, boolean leftRecursive)
        {
            super((ASTNode) _option, leftRecursive);
            ((ASTNode) _option).setParent(this);
        }

        public void add(option _option)
        {
            super.add((ASTNode) _option);
            ((ASTNode) _option).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof optionList)) return false;
            if (! super.equals(o)) return false;
            optionList other = (optionList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                option element = getoptionAt(i);
                    if (! element.equals(other.getoptionAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getoptionAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    option element = getoptionAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 32:  option ::= SYMBOL option_value
     *</b>
     */
    static public class option extends ASTNode implements Ioption
    {
        private ASTNodeToken _SYMBOL;
        private Ioption_value _option_value;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        /**
         * The value returned by <b>getoption_value</b> may be <b>null</b>
         */
        public Ioption_value getoption_value() { return _option_value; }

        public option(IToken leftIToken, IToken rightIToken,
                      ASTNodeToken _SYMBOL,
                      Ioption_value _option_value)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._option_value = _option_value;
            if (_option_value != null) ((ASTNode) _option_value).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_option_value);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof option)) return false;
            if (! super.equals(o)) return false;
            option other = (option) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (_option_value == null)
                if (other._option_value != null) return false;
                else; // continue
            else if (! _option_value.equals(other._option_value)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_option_value == null ? 0 : _option_value.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                if (_option_value != null) _option_value.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 36:  symbol_list ::= SYMBOL
     *<li>Rule 37:  symbol_list ::= symbol_list ,$ SYMBOL
     *<li>Rule 75:  drop_symbols ::= SYMBOL
     *<li>Rule 76:  drop_symbols ::= drop_symbols SYMBOL
     *<li>Rule 136:  barSymbolList ::= SYMBOL
     *<li>Rule 137:  barSymbolList ::= barSymbolList |$ SYMBOL
     *<li>Rule 141:  recover_segment ::= $Empty
     *<li>Rule 142:  recover_segment ::= recover_segment recover_symbol
     *</b>
     */
    static public class SYMBOLList extends AbstractASTNodeList implements Isymbol_list, Idrop_symbols, IbarSymbolList, Irecover_segment
    {
        public ASTNodeToken getSYMBOLAt(int i) { return (ASTNodeToken) getElementAt(i); }

        public SYMBOLList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public SYMBOLList(ASTNodeToken _SYMBOL, boolean leftRecursive)
        {
            super((ASTNode) _SYMBOL, leftRecursive);
            ((ASTNode) _SYMBOL).setParent(this);
        }

        public void add(ASTNodeToken _SYMBOL)
        {
            super.add((ASTNode) _SYMBOL);
            ((ASTNode) _SYMBOL).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof SYMBOLList)) return false;
            if (! super.equals(o)) return false;
            SYMBOLList other = (SYMBOLList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                ASTNodeToken element = getSYMBOLAt(i);
                    if (! element.equals(other.getSYMBOLAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getSYMBOLAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    ASTNodeToken element = getSYMBOLAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 38:  alias_segment ::= aliasSpec
     *<li>Rule 39:  alias_segment ::= alias_segment aliasSpec
     *</b>
     */
    static public class aliasSpecList extends AbstractASTNodeList implements Ialias_segment
    {
        public IaliasSpec getaliasSpecAt(int i) { return (IaliasSpec) getElementAt(i); }

        public aliasSpecList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public aliasSpecList(IaliasSpec _aliasSpec, boolean leftRecursive)
        {
            super((ASTNode) _aliasSpec, leftRecursive);
            ((ASTNode) _aliasSpec).setParent(this);
        }

        public void add(IaliasSpec _aliasSpec)
        {
            super.add((ASTNode) _aliasSpec);
            ((ASTNode) _aliasSpec).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpecList)) return false;
            if (! super.equals(o)) return false;
            aliasSpecList other = (aliasSpecList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                IaliasSpec element = getaliasSpecAt(i);
                    if (! element.equals(other.getaliasSpecAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getaliasSpecAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    IaliasSpec element = getaliasSpecAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 46:  alias_lhs_macro_name ::= MACRO_NAME
     *</b>
     */
    static public class alias_lhs_macro_name extends ASTNodeToken implements Ialias_lhs_macro_name
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public alias_lhs_macro_name(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 55:  define_segment ::= defineSpec
     *<li>Rule 56:  define_segment ::= define_segment defineSpec
     *</b>
     */
    static public class defineSpecList extends AbstractASTNodeList implements Idefine_segment
    {
        public defineSpec getdefineSpecAt(int i) { return (defineSpec) getElementAt(i); }

        public defineSpecList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public defineSpecList(defineSpec _defineSpec, boolean leftRecursive)
        {
            super((ASTNode) _defineSpec, leftRecursive);
            ((ASTNode) _defineSpec).setParent(this);
        }

        public void add(defineSpec _defineSpec)
        {
            super.add((ASTNode) _defineSpec);
            ((ASTNode) _defineSpec).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof defineSpecList)) return false;
            if (! super.equals(o)) return false;
            defineSpecList other = (defineSpecList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                defineSpec element = getdefineSpecAt(i);
                    if (! element.equals(other.getdefineSpecAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getdefineSpecAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    defineSpec element = getdefineSpecAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 57:  defineSpec ::= macro_name_symbol macro_segment
     *</b>
     */
    static public class defineSpec extends ASTNode implements IdefineSpec
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        private Imacro_name_symbol _macro_name_symbol;
        private macro_segment _macro_segment;

        public Imacro_name_symbol getmacro_name_symbol() { return _macro_name_symbol; }
        public macro_segment getmacro_segment() { return _macro_segment; }

        public defineSpec(LPGParser environment, IToken leftIToken, IToken rightIToken,
                          Imacro_name_symbol _macro_name_symbol,
                          macro_segment _macro_segment)
        {
            super(leftIToken, rightIToken);

            this.environment = environment;
            this._macro_name_symbol = _macro_name_symbol;
            ((ASTNode) _macro_name_symbol).setParent(this);
            this._macro_segment = _macro_segment;
            ((ASTNode) _macro_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_macro_name_symbol);
            list.add(_macro_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof defineSpec)) return false;
            if (! super.equals(o)) return false;
            defineSpec other = (defineSpec) o;
            if (! _macro_name_symbol.equals(other._macro_name_symbol)) return false;
            if (! _macro_segment.equals(other._macro_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_macro_name_symbol.hashCode());
            hash = hash * 31 + (_macro_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _macro_name_symbol.accept(v);
                _macro_segment.accept(v);
            }
            v.endVisit(this);
        }

    void initialize() { symtab.put(_macro_name_symbol.toString(), this); }
     }

    /**
     *<b>
     *<li>Rule 60:  macro_segment ::= BLOCK
     *</b>
     */
    static public class macro_segment extends ASTNodeToken implements Imacro_segment
    {
        public IToken getBLOCK() { return leftIToken; }

        public macro_segment(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 64:  export_segment ::= terminal_symbol
     *<li>Rule 65:  export_segment ::= export_segment terminal_symbol
     *</b>
     */
    static public class terminal_symbolList extends AbstractASTNodeList implements Iexport_segment
    {
        public Iterminal_symbol getterminal_symbolAt(int i) { return (Iterminal_symbol) getElementAt(i); }

        public terminal_symbolList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public terminal_symbolList(Iterminal_symbol _terminal_symbol, boolean leftRecursive)
        {
            super((ASTNode) _terminal_symbol, leftRecursive);
            ((ASTNode) _terminal_symbol).setParent(this);
        }

        public void add(Iterminal_symbol _terminal_symbol)
        {
            super.add((ASTNode) _terminal_symbol);
            ((ASTNode) _terminal_symbol).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof terminal_symbolList)) return false;
            if (! super.equals(o)) return false;
            terminal_symbolList other = (terminal_symbolList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                Iterminal_symbol element = getterminal_symbolAt(i);
                    if (! element.equals(other.getterminal_symbolAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getterminal_symbolAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    Iterminal_symbol element = getterminal_symbolAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 66:  globals_segment ::= action_segment
     *<li>Rule 67:  globals_segment ::= globals_segment action_segment
     *<li>Rule 96:  notice_segment ::= action_segment
     *<li>Rule 97:  notice_segment ::= notice_segment action_segment
     *<li>Rule 146:  action_segment_list ::= $Empty
     *<li>Rule 147:  action_segment_list ::= action_segment_list action_segment
     *</b>
     */
    static public class action_segmentList extends AbstractASTNodeList implements Iglobals_segment, Inotice_segment, Iaction_segment_list
    {
        public action_segment getaction_segmentAt(int i) { return (action_segment) getElementAt(i); }

        public action_segmentList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public action_segmentList(action_segment _action_segment, boolean leftRecursive)
        {
            super((ASTNode) _action_segment, leftRecursive);
            ((ASTNode) _action_segment).setParent(this);
        }

        public void add(action_segment _action_segment)
        {
            super.add((ASTNode) _action_segment);
            ((ASTNode) _action_segment).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof action_segmentList)) return false;
            if (! super.equals(o)) return false;
            action_segmentList other = (action_segmentList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                action_segment element = getaction_segmentAt(i);
                    if (! element.equals(other.getaction_segmentAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getaction_segmentAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    action_segment element = getaction_segmentAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 70:  import_segment ::= SYMBOL drop_command_list
     *</b>
     */
    static public class import_segment extends ASTNode implements Iimport_segment
    {
        private ASTNodeToken _SYMBOL;
        private drop_commandList _drop_command_list;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        public drop_commandList getdrop_command_list() { return _drop_command_list; }

        public import_segment(IToken leftIToken, IToken rightIToken,
                              ASTNodeToken _SYMBOL,
                              drop_commandList _drop_command_list)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._drop_command_list = _drop_command_list;
            ((ASTNode) _drop_command_list).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_drop_command_list);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof import_segment)) return false;
            if (! super.equals(o)) return false;
            import_segment other = (import_segment) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (! _drop_command_list.equals(other._drop_command_list)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_drop_command_list.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                _drop_command_list.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 71:  drop_command_list ::= $Empty
     *<li>Rule 72:  drop_command_list ::= drop_command_list drop_command
     *</b>
     */
    static public class drop_commandList extends AbstractASTNodeList implements Idrop_command_list
    {
        public Idrop_command getdrop_commandAt(int i) { return (Idrop_command) getElementAt(i); }

        public drop_commandList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public drop_commandList(Idrop_command _drop_command, boolean leftRecursive)
        {
            super((ASTNode) _drop_command, leftRecursive);
            ((ASTNode) _drop_command).setParent(this);
        }

        public void add(Idrop_command _drop_command)
        {
            super.add((ASTNode) _drop_command);
            ((ASTNode) _drop_command).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof drop_commandList)) return false;
            if (! super.equals(o)) return false;
            drop_commandList other = (drop_commandList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                Idrop_command element = getdrop_commandAt(i);
                    if (! element.equals(other.getdrop_commandAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getdrop_commandAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    Idrop_command element = getdrop_commandAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 77:  drop_rules ::= drop_rule
     *<li>Rule 78:  drop_rules ::= drop_rules drop_rule
     *</b>
     */
    static public class drop_ruleList extends AbstractASTNodeList implements Idrop_rules
    {
        public drop_rule getdrop_ruleAt(int i) { return (drop_rule) getElementAt(i); }

        public drop_ruleList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public drop_ruleList(drop_rule _drop_rule, boolean leftRecursive)
        {
            super((ASTNode) _drop_rule, leftRecursive);
            ((ASTNode) _drop_rule).setParent(this);
        }

        public void add(drop_rule _drop_rule)
        {
            super.add((ASTNode) _drop_rule);
            ((ASTNode) _drop_rule).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof drop_ruleList)) return false;
            if (! super.equals(o)) return false;
            drop_ruleList other = (drop_ruleList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                drop_rule element = getdrop_ruleAt(i);
                    if (! element.equals(other.getdrop_ruleAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getdrop_ruleAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    drop_rule element = getdrop_ruleAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 79:  drop_rule ::= SYMBOL optMacroName produces ruleList
     *</b>
     */
    static public class drop_rule extends ASTNode implements Idrop_rule
    {
        private ASTNodeToken _SYMBOL;
        private optMacroName _optMacroName;
        private Iproduces _produces;
        private ruleList _ruleList;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        /**
         * The value returned by <b>getoptMacroName</b> may be <b>null</b>
         */
        public optMacroName getoptMacroName() { return _optMacroName; }
        public Iproduces getproduces() { return _produces; }
        public ruleList getruleList() { return _ruleList; }

        public drop_rule(IToken leftIToken, IToken rightIToken,
                         ASTNodeToken _SYMBOL,
                         optMacroName _optMacroName,
                         Iproduces _produces,
                         ruleList _ruleList)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._optMacroName = _optMacroName;
            if (_optMacroName != null) ((ASTNode) _optMacroName).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._ruleList = _ruleList;
            ((ASTNode) _ruleList).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_optMacroName);
            list.add(_produces);
            list.add(_ruleList);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof drop_rule)) return false;
            if (! super.equals(o)) return false;
            drop_rule other = (drop_rule) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (_optMacroName == null)
                if (other._optMacroName != null) return false;
                else; // continue
            else if (! _optMacroName.equals(other._optMacroName)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _ruleList.equals(other._ruleList)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_optMacroName == null ? 0 : _optMacroName.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_ruleList.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                if (_optMacroName != null) _optMacroName.accept(v);
                _produces.accept(v);
                _ruleList.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<em>
     *<li>Rule 80:  optMacroName ::= $Empty
     *</em>
     *<p>
     *<b>
     *<li>Rule 81:  optMacroName ::= MACRO_NAME
     *</b>
     */
    static public class optMacroName extends ASTNodeToken implements IoptMacroName
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public optMacroName(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 82:  include_segment ::= SYMBOL
     *</b>
     */
    static public class include_segment extends ASTNodeToken implements Iinclude_segment
    {
        public IToken getSYMBOL() { return leftIToken; }

        public include_segment(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 83:  keywords_segment ::= keywordSpec
     *<li>Rule 84:  keywords_segment ::= keywords_segment keywordSpec
     *</b>
     */
    static public class keywordSpecList extends AbstractASTNodeList implements Ikeywords_segment
    {
        public IkeywordSpec getkeywordSpecAt(int i) { return (IkeywordSpec) getElementAt(i); }

        public keywordSpecList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public keywordSpecList(IkeywordSpec _keywordSpec, boolean leftRecursive)
        {
            super((ASTNode) _keywordSpec, leftRecursive);
            ((ASTNode) _keywordSpec).setParent(this);
        }

        public void add(IkeywordSpec _keywordSpec)
        {
            super.add((ASTNode) _keywordSpec);
            ((ASTNode) _keywordSpec).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof keywordSpecList)) return false;
            if (! super.equals(o)) return false;
            keywordSpecList other = (keywordSpecList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                IkeywordSpec element = getkeywordSpecAt(i);
                    if (! element.equals(other.getkeywordSpecAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getkeywordSpecAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    IkeywordSpec element = getkeywordSpecAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<em>
     *<li>Rule 85:  keywordSpec ::= terminal_symbol
     *</em>
     *<p>
     *<b>
     *<li>Rule 86:  keywordSpec ::= terminal_symbol produces name
     *</b>
     */
    static public class keywordSpec extends ASTNode implements IkeywordSpec
    {
        private Iterminal_symbol _terminal_symbol;
        private Iproduces _produces;
        private Iname _name;

        public Iterminal_symbol getterminal_symbol() { return _terminal_symbol; }
        public Iproduces getproduces() { return _produces; }
        public Iname getname() { return _name; }

        public keywordSpec(IToken leftIToken, IToken rightIToken,
                           Iterminal_symbol _terminal_symbol,
                           Iproduces _produces,
                           Iname _name)
        {
            super(leftIToken, rightIToken);

            this._terminal_symbol = _terminal_symbol;
            ((ASTNode) _terminal_symbol).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._name = _name;
            ((ASTNode) _name).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_terminal_symbol);
            list.add(_produces);
            list.add(_name);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof keywordSpec)) return false;
            if (! super.equals(o)) return false;
            keywordSpec other = (keywordSpec) o;
            if (! _terminal_symbol.equals(other._terminal_symbol)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _name.equals(other._name)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_terminal_symbol.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_name.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _terminal_symbol.accept(v);
                _produces.accept(v);
                _name.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 87:  names_segment ::= nameSpec
     *<li>Rule 88:  names_segment ::= names_segment nameSpec
     *</b>
     */
    static public class nameSpecList extends AbstractASTNodeList implements Inames_segment
    {
        public nameSpec getnameSpecAt(int i) { return (nameSpec) getElementAt(i); }

        public nameSpecList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public nameSpecList(nameSpec _nameSpec, boolean leftRecursive)
        {
            super((ASTNode) _nameSpec, leftRecursive);
            ((ASTNode) _nameSpec).setParent(this);
        }

        public void add(nameSpec _nameSpec)
        {
            super.add((ASTNode) _nameSpec);
            ((ASTNode) _nameSpec).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof nameSpecList)) return false;
            if (! super.equals(o)) return false;
            nameSpecList other = (nameSpecList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                nameSpec element = getnameSpecAt(i);
                    if (! element.equals(other.getnameSpecAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getnameSpecAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    nameSpec element = getnameSpecAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 89:  nameSpec ::= name produces name
     *</b>
     */
    static public class nameSpec extends ASTNode implements InameSpec
    {
        private Iname _name;
        private Iproduces _produces;
        private Iname _name3;

        public Iname getname() { return _name; }
        public Iproduces getproduces() { return _produces; }
        public Iname getname3() { return _name3; }

        public nameSpec(IToken leftIToken, IToken rightIToken,
                        Iname _name,
                        Iproduces _produces,
                        Iname _name3)
        {
            super(leftIToken, rightIToken);

            this._name = _name;
            ((ASTNode) _name).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._name3 = _name3;
            ((ASTNode) _name3).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_name);
            list.add(_produces);
            list.add(_name3);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof nameSpec)) return false;
            if (! super.equals(o)) return false;
            nameSpec other = (nameSpec) o;
            if (! _name.equals(other._name)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _name3.equals(other._name3)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_name.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_name3.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _name.accept(v);
                _produces.accept(v);
                _name3.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 98:  rules_segment ::= action_segment_list nonTermList
     *</b>
     */
    static public class rules_segment extends ASTNode implements Irules_segment
    {
        private action_segmentList _action_segment_list;
        private nonTermList _nonTermList;

        public action_segmentList getaction_segment_list() { return _action_segment_list; }
        public nonTermList getnonTermList() { return _nonTermList; }

        public rules_segment(IToken leftIToken, IToken rightIToken,
                             action_segmentList _action_segment_list,
                             nonTermList _nonTermList)
        {
            super(leftIToken, rightIToken);

            this._action_segment_list = _action_segment_list;
            ((ASTNode) _action_segment_list).setParent(this);
            this._nonTermList = _nonTermList;
            ((ASTNode) _nonTermList).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_action_segment_list);
            list.add(_nonTermList);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof rules_segment)) return false;
            if (! super.equals(o)) return false;
            rules_segment other = (rules_segment) o;
            if (! _action_segment_list.equals(other._action_segment_list)) return false;
            if (! _nonTermList.equals(other._nonTermList)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_action_segment_list.hashCode());
            hash = hash * 31 + (_nonTermList.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _action_segment_list.accept(v);
                _nonTermList.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 99:  nonTermList ::= $Empty
     *<li>Rule 100:  nonTermList ::= nonTermList nonTerm
     *</b>
     */
    static public class nonTermList extends AbstractASTNodeList implements InonTermList
    {
        public nonTerm getnonTermAt(int i) { return (nonTerm) getElementAt(i); }

        public nonTermList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public nonTermList(nonTerm _nonTerm, boolean leftRecursive)
        {
            super((ASTNode) _nonTerm, leftRecursive);
            ((ASTNode) _nonTerm).setParent(this);
        }

        public void add(nonTerm _nonTerm)
        {
            super.add((ASTNode) _nonTerm);
            ((ASTNode) _nonTerm).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof nonTermList)) return false;
            if (! super.equals(o)) return false;
            nonTermList other = (nonTermList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                nonTerm element = getnonTermAt(i);
                    if (! element.equals(other.getnonTermAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getnonTermAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    nonTerm element = getnonTermAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 101:  nonTerm ::= ruleNameWithAttributes produces ruleList
     *</b>
     */
    static public class nonTerm extends ASTNode implements InonTerm
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        private RuleName _ruleNameWithAttributes;
        private Iproduces _produces;
        private ruleList _ruleList;

        public RuleName getruleNameWithAttributes() { return _ruleNameWithAttributes; }
        public Iproduces getproduces() { return _produces; }
        public ruleList getruleList() { return _ruleList; }

        public nonTerm(LPGParser environment, IToken leftIToken, IToken rightIToken,
                       RuleName _ruleNameWithAttributes,
                       Iproduces _produces,
                       ruleList _ruleList)
        {
            super(leftIToken, rightIToken);

            this.environment = environment;
            this._ruleNameWithAttributes = _ruleNameWithAttributes;
            ((ASTNode) _ruleNameWithAttributes).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._ruleList = _ruleList;
            ((ASTNode) _ruleList).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_ruleNameWithAttributes);
            list.add(_produces);
            list.add(_ruleList);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof nonTerm)) return false;
            if (! super.equals(o)) return false;
            nonTerm other = (nonTerm) o;
            if (! _ruleNameWithAttributes.equals(other._ruleNameWithAttributes)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _ruleList.equals(other._ruleList)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_ruleNameWithAttributes.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_ruleList.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _ruleNameWithAttributes.accept(v);
                _produces.accept(v);
                _ruleList.accept(v);
            }
            v.endVisit(this);
        }

    void initialize() { symtab.put(_ruleNameWithAttributes.getSYMBOL().toString(), this); }
     }

    /**
     *<b>
     *<li>Rule 102:  ruleNameWithAttributes ::= SYMBOL
     *<li>Rule 103:  ruleNameWithAttributes ::= SYMBOL MACRO_NAME$className
     *<li>Rule 104:  ruleNameWithAttributes ::= SYMBOL MACRO_NAME$className MACRO_NAME$arrayElement
     *</b>
     */
    static public class RuleName extends ASTNode implements IruleNameWithAttributes
    {
        private ASTNodeToken _SYMBOL;
        private ASTNodeToken _className;
        private ASTNodeToken _arrayElement;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        /**
         * The value returned by <b>getclassName</b> may be <b>null</b>
         */
        public ASTNodeToken getclassName() { return _className; }
        /**
         * The value returned by <b>getarrayElement</b> may be <b>null</b>
         */
        public ASTNodeToken getarrayElement() { return _arrayElement; }

        public RuleName(IToken leftIToken, IToken rightIToken,
                        ASTNodeToken _SYMBOL,
                        ASTNodeToken _className,
                        ASTNodeToken _arrayElement)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._className = _className;
            if (_className != null) ((ASTNode) _className).setParent(this);
            this._arrayElement = _arrayElement;
            if (_arrayElement != null) ((ASTNode) _arrayElement).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_className);
            list.add(_arrayElement);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof RuleName)) return false;
            if (! super.equals(o)) return false;
            RuleName other = (RuleName) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (_className == null)
                if (other._className != null) return false;
                else; // continue
            else if (! _className.equals(other._className)) return false;
            if (_arrayElement == null)
                if (other._arrayElement != null) return false;
                else; // continue
            else if (! _arrayElement.equals(other._arrayElement)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_className == null ? 0 : _className.hashCode());
            hash = hash * 31 + (_arrayElement == null ? 0 : _arrayElement.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                if (_className != null) _className.accept(v);
                if (_arrayElement != null) _arrayElement.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 105:  ruleList ::= rule
     *<li>Rule 106:  ruleList ::= ruleList |$ rule
     *</b>
     */
    static public class ruleList extends AbstractASTNodeList implements IruleList
    {
        public rule getruleAt(int i) { return (rule) getElementAt(i); }

        public ruleList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public ruleList(rule _rule, boolean leftRecursive)
        {
            super((ASTNode) _rule, leftRecursive);
            ((ASTNode) _rule).setParent(this);
        }

        public void add(rule _rule)
        {
            super.add((ASTNode) _rule);
            ((ASTNode) _rule).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof ruleList)) return false;
            if (! super.equals(o)) return false;
            ruleList other = (ruleList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                rule element = getruleAt(i);
                    if (! element.equals(other.getruleAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getruleAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    rule element = getruleAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 111:  rule ::= symWithAttrsList opt_action_segment
     *</b>
     */
    static public class rule extends ASTNode implements Irule
    {
        private symWithAttrsList _symWithAttrsList;
        private action_segment _opt_action_segment;

        public symWithAttrsList getsymWithAttrsList() { return _symWithAttrsList; }
        /**
         * The value returned by <b>getopt_action_segment</b> may be <b>null</b>
         */
        public action_segment getopt_action_segment() { return _opt_action_segment; }

        public rule(IToken leftIToken, IToken rightIToken,
                    symWithAttrsList _symWithAttrsList,
                    action_segment _opt_action_segment)
        {
            super(leftIToken, rightIToken);

            this._symWithAttrsList = _symWithAttrsList;
            ((ASTNode) _symWithAttrsList).setParent(this);
            this._opt_action_segment = _opt_action_segment;
            if (_opt_action_segment != null) ((ASTNode) _opt_action_segment).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_symWithAttrsList);
            list.add(_opt_action_segment);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof rule)) return false;
            if (! super.equals(o)) return false;
            rule other = (rule) o;
            if (! _symWithAttrsList.equals(other._symWithAttrsList)) return false;
            if (_opt_action_segment == null)
                if (other._opt_action_segment != null) return false;
                else; // continue
            else if (! _opt_action_segment.equals(other._opt_action_segment)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_symWithAttrsList.hashCode());
            hash = hash * 31 + (_opt_action_segment == null ? 0 : _opt_action_segment.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _symWithAttrsList.accept(v);
                if (_opt_action_segment != null) _opt_action_segment.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 112:  symWithAttrsList ::= $Empty
     *<li>Rule 113:  symWithAttrsList ::= symWithAttrsList symWithAttrs
     *</b>
     */
    static public class symWithAttrsList extends AbstractASTNodeList implements IsymWithAttrsList
    {
        public IsymWithAttrs getsymWithAttrsAt(int i) { return (IsymWithAttrs) getElementAt(i); }

        public symWithAttrsList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public symWithAttrsList(IsymWithAttrs _symWithAttrs, boolean leftRecursive)
        {
            super((ASTNode) _symWithAttrs, leftRecursive);
            ((ASTNode) _symWithAttrs).setParent(this);
        }

        public void add(IsymWithAttrs _symWithAttrs)
        {
            super.add((ASTNode) _symWithAttrs);
            ((ASTNode) _symWithAttrs).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof symWithAttrsList)) return false;
            if (! super.equals(o)) return false;
            symWithAttrsList other = (symWithAttrsList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                IsymWithAttrs element = getsymWithAttrsAt(i);
                    if (! element.equals(other.getsymWithAttrsAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getsymWithAttrsAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    IsymWithAttrs element = getsymWithAttrsAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 116:  optAttrList ::= $Empty
     *<li>Rule 117:  optAttrList ::= MACRO_NAME
     *</b>
     */
    static public class symAttrs extends ASTNode implements IoptAttrList
    {
        private ASTNodeToken _MACRO_NAME;

        /**
         * The value returned by <b>getMACRO_NAME</b> may be <b>null</b>
         */
        public ASTNodeToken getMACRO_NAME() { return _MACRO_NAME; }

        public symAttrs(IToken leftIToken, IToken rightIToken,
                        ASTNodeToken _MACRO_NAME)
        {
            super(leftIToken, rightIToken);

            this._MACRO_NAME = _MACRO_NAME;
            if (_MACRO_NAME != null) ((ASTNode) _MACRO_NAME).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_MACRO_NAME);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof symAttrs)) return false;
            if (! super.equals(o)) return false;
            symAttrs other = (symAttrs) o;
            if (_MACRO_NAME == null)
                if (other._MACRO_NAME != null) return false;
                else; // continue
            else if (! _MACRO_NAME.equals(other._MACRO_NAME)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_MACRO_NAME == null ? 0 : _MACRO_NAME.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                if (_MACRO_NAME != null) _MACRO_NAME.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 120:  action_segment ::= BLOCK
     *</b>
     */
    static public class action_segment extends ASTNodeToken implements Iaction_segment
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        public IToken getBLOCK() { return leftIToken; }

        public action_segment(LPGParser environment, IToken token)        {
            super(token);
            this.environment = environment;
            initialize();
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }

        private JavaParser.Ast ast;
        public JavaParser.Ast getAst() { return ast; }
        public void setAst(JavaParser.Ast ast) { this.ast = ast; }
    }

    /**
     *<b>
     *<li>Rule 121:  start_segment ::= start_symbol
     *<li>Rule 122:  start_segment ::= start_segment start_symbol
     *</b>
     */
    static public class start_symbolList extends AbstractASTNodeList implements Istart_segment
    {
        public Istart_symbol getstart_symbolAt(int i) { return (Istart_symbol) getElementAt(i); }

        public start_symbolList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public start_symbolList(Istart_symbol _start_symbol, boolean leftRecursive)
        {
            super((ASTNode) _start_symbol, leftRecursive);
            ((ASTNode) _start_symbol).setParent(this);
        }

        public void add(Istart_symbol _start_symbol)
        {
            super.add((ASTNode) _start_symbol);
            ((ASTNode) _start_symbol).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof start_symbolList)) return false;
            if (! super.equals(o)) return false;
            start_symbolList other = (start_symbolList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                Istart_symbol element = getstart_symbolAt(i);
                    if (! element.equals(other.getstart_symbolAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getstart_symbolAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    Istart_symbol element = getstart_symbolAt(i);
                    element.accept(v);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 125:  terminals_segment ::= terminal
     *<li>Rule 126:  terminals_segment ::= terminals_segment terminal
     *</b>
     */
    static public class terminalList extends AbstractASTNodeList implements Iterminals_segment
    {
        public terminal getterminalAt(int i) { return (terminal) getElementAt(i); }

        public terminalList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public terminalList(terminal _terminal, boolean leftRecursive)
        {
            super((ASTNode) _terminal, leftRecursive);
            ((ASTNode) _terminal).setParent(this);
        }

        public void add(terminal _terminal)
        {
            super.add((ASTNode) _terminal);
            ((ASTNode) _terminal).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof terminalList)) return false;
            if (! super.equals(o)) return false;
            terminalList other = (terminalList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                terminal element = getterminalAt(i);
                    if (! element.equals(other.getterminalAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getterminalAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    terminal element = getterminalAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 127:  terminal ::= terminal_symbol optTerminalAlias
     *</b>
     */
    static public class terminal extends ASTNode implements Iterminal
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        private Iterminal_symbol _terminal_symbol;
        private optTerminalAlias _optTerminalAlias;

        public Iterminal_symbol getterminal_symbol() { return _terminal_symbol; }
        /**
         * The value returned by <b>getoptTerminalAlias</b> may be <b>null</b>
         */
        public optTerminalAlias getoptTerminalAlias() { return _optTerminalAlias; }

        public terminal(LPGParser environment, IToken leftIToken, IToken rightIToken,
                        Iterminal_symbol _terminal_symbol,
                        optTerminalAlias _optTerminalAlias)
        {
            super(leftIToken, rightIToken);

            this.environment = environment;
            this._terminal_symbol = _terminal_symbol;
            ((ASTNode) _terminal_symbol).setParent(this);
            this._optTerminalAlias = _optTerminalAlias;
            if (_optTerminalAlias != null) ((ASTNode) _optTerminalAlias).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_terminal_symbol);
            list.add(_optTerminalAlias);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof terminal)) return false;
            if (! super.equals(o)) return false;
            terminal other = (terminal) o;
            if (! _terminal_symbol.equals(other._terminal_symbol)) return false;
            if (_optTerminalAlias == null)
                if (other._optTerminalAlias != null) return false;
                else; // continue
            else if (! _optTerminalAlias.equals(other._optTerminalAlias)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_terminal_symbol.hashCode());
            hash = hash * 31 + (_optTerminalAlias == null ? 0 : _optTerminalAlias.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _terminal_symbol.accept(v);
                if (_optTerminalAlias != null) _optTerminalAlias.accept(v);
            }
            v.endVisit(this);
        }

    void initialize() { symtab.put(_terminal_symbol.toString(), this); }
     }

    /**
     *<em>
     *<li>Rule 128:  optTerminalAlias ::= $Empty
     *</em>
     *<p>
     *<b>
     *<li>Rule 129:  optTerminalAlias ::= produces name
     *</b>
     */
    static public class optTerminalAlias extends ASTNode implements IoptTerminalAlias
    {
        private Iproduces _produces;
        private Iname _name;

        public Iproduces getproduces() { return _produces; }
        public Iname getname() { return _name; }

        public optTerminalAlias(IToken leftIToken, IToken rightIToken,
                                Iproduces _produces,
                                Iname _name)
        {
            super(leftIToken, rightIToken);

            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._name = _name;
            ((ASTNode) _name).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_produces);
            list.add(_name);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof optTerminalAlias)) return false;
            if (! super.equals(o)) return false;
            optTerminalAlias other = (optTerminalAlias) o;
            if (! _produces.equals(other._produces)) return false;
            if (! _name.equals(other._name)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_name.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _produces.accept(v);
                _name.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 133:  types_segment ::= type_declarations
     *<li>Rule 134:  types_segment ::= types_segment type_declarations
     *</b>
     */
    static public class type_declarationsList extends AbstractASTNodeList implements Itypes_segment
    {
        public type_declarations gettype_declarationsAt(int i) { return (type_declarations) getElementAt(i); }

        public type_declarationsList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public type_declarationsList(type_declarations _type_declarations, boolean leftRecursive)
        {
            super((ASTNode) _type_declarations, leftRecursive);
            ((ASTNode) _type_declarations).setParent(this);
        }

        public void add(type_declarations _type_declarations)
        {
            super.add((ASTNode) _type_declarations);
            ((ASTNode) _type_declarations).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof type_declarationsList)) return false;
            if (! super.equals(o)) return false;
            type_declarationsList other = (type_declarationsList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                type_declarations element = gettype_declarationsAt(i);
                    if (! element.equals(other.gettype_declarationsAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (gettype_declarationsAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    type_declarations element = gettype_declarationsAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 135:  type_declarations ::= SYMBOL produces barSymbolList
     *</b>
     */
    static public class type_declarations extends ASTNode implements Itype_declarations
    {
        private ASTNodeToken _SYMBOL;
        private Iproduces _produces;
        private SYMBOLList _barSymbolList;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        public Iproduces getproduces() { return _produces; }
        public SYMBOLList getbarSymbolList() { return _barSymbolList; }

        public type_declarations(IToken leftIToken, IToken rightIToken,
                                 ASTNodeToken _SYMBOL,
                                 Iproduces _produces,
                                 SYMBOLList _barSymbolList)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._barSymbolList = _barSymbolList;
            ((ASTNode) _barSymbolList).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_produces);
            list.add(_barSymbolList);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof type_declarations)) return false;
            if (! super.equals(o)) return false;
            type_declarations other = (type_declarations) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _barSymbolList.equals(other._barSymbolList)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_barSymbolList.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                _produces.accept(v);
                _barSymbolList.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 138:  predecessor_segment ::= $Empty
     *<li>Rule 139:  predecessor_segment ::= predecessor_segment symbol_pair
     *</b>
     */
    static public class symbol_pairList extends AbstractASTNodeList implements Ipredecessor_segment
    {
        public symbol_pair getsymbol_pairAt(int i) { return (symbol_pair) getElementAt(i); }

        public symbol_pairList(IToken leftIToken, IToken rightIToken, boolean leftRecursive)
        {
            super(leftIToken, rightIToken, leftRecursive);
        }

        public symbol_pairList(symbol_pair _symbol_pair, boolean leftRecursive)
        {
            super((ASTNode) _symbol_pair, leftRecursive);
            ((ASTNode) _symbol_pair).setParent(this);
        }

        public void add(symbol_pair _symbol_pair)
        {
            super.add((ASTNode) _symbol_pair);
            ((ASTNode) _symbol_pair).setParent(this);
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof symbol_pairList)) return false;
            if (! super.equals(o)) return false;
            symbol_pairList other = (symbol_pairList    ) o;
            if (size() != other.size()) return false;
            for (int i = 0; i < size(); i++)
            {
                symbol_pair element = getsymbol_pairAt(i);
                    if (! element.equals(other.getsymbol_pairAt(i))) return false;
            }
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            for (int i = 0; i < size(); i++)
                hash = hash * 31 + (getsymbol_pairAt(i).hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }
        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                for (int i = 0; i < size(); i++)
                {
                    symbol_pair element = getsymbol_pairAt(i);
                    if (! v.preVisit(element)) continue;
                    element.enter(v);
                    v.postVisit(element);
                }
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 140:  symbol_pair ::= SYMBOL SYMBOL
     *</b>
     */
    static public class symbol_pair extends ASTNode implements Isymbol_pair
    {
        private ASTNodeToken _SYMBOL;
        private ASTNodeToken _SYMBOL2;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        public ASTNodeToken getSYMBOL2() { return _SYMBOL2; }

        public symbol_pair(IToken leftIToken, IToken rightIToken,
                           ASTNodeToken _SYMBOL,
                           ASTNodeToken _SYMBOL2)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._SYMBOL2 = _SYMBOL2;
            ((ASTNode) _SYMBOL2).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_SYMBOL2);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof symbol_pair)) return false;
            if (! super.equals(o)) return false;
            symbol_pair other = (symbol_pair) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (! _SYMBOL2.equals(other._SYMBOL2)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_SYMBOL2.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                _SYMBOL2.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 143:  recover_symbol ::= SYMBOL
     *</b>
     */
    static public class recover_symbol extends ASTNodeToken implements Irecover_symbol
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        public IToken getSYMBOL() { return leftIToken; }

        public recover_symbol(LPGParser environment, IToken token)        {
            super(token);
            this.environment = environment;
            initialize();
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }

    void initialize() {
       symtab.put(getSYMBOL().toString(), this);
    }
     }

    /**
     *<em>
     *<li>Rule 144:  END_KEY_OPT ::= $Empty
     *</em>
     *<p>
     *<b>
     *<li>Rule 145:  END_KEY_OPT ::= END_KEY
     *</b>
     */
    static public class END_KEY_OPT extends ASTNodeToken implements IEND_KEY_OPT
    {
        public IToken getEND_KEY() { return leftIToken; }

        public END_KEY_OPT(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 34:  option_value ::= =$ SYMBOL
     *</b>
     */
    static public class option_value__EQUAL_SYMBOL extends ASTNode implements Ioption_value
    {
        private ASTNodeToken _SYMBOL;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }

        public option_value__EQUAL_SYMBOL(IToken leftIToken, IToken rightIToken,
                                          ASTNodeToken _SYMBOL)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof option_value__EQUAL_SYMBOL)) return false;
            if (! super.equals(o)) return false;
            option_value__EQUAL_SYMBOL other = (option_value__EQUAL_SYMBOL) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _SYMBOL.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 35:  option_value ::= =$ ($ symbol_list )$
     *</b>
     */
    static public class option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN extends ASTNode implements Ioption_value
    {
        private SYMBOLList _symbol_list;

        public SYMBOLList getsymbol_list() { return _symbol_list; }

        public option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN(IToken leftIToken, IToken rightIToken,
                                                                      SYMBOLList _symbol_list)
        {
            super(leftIToken, rightIToken);

            this._symbol_list = _symbol_list;
            ((ASTNode) _symbol_list).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_symbol_list);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN)) return false;
            if (! super.equals(o)) return false;
            option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN other = (option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN) o;
            if (! _symbol_list.equals(other._symbol_list)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_symbol_list.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
                _symbol_list.accept(v);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 40:  aliasSpec ::= ERROR_KEY produces alias_rhs
     *</b>
     */
    static public class aliasSpec__ERROR_KEY_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private ASTNodeToken _ERROR_KEY;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public ASTNodeToken getERROR_KEY() { return _ERROR_KEY; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__ERROR_KEY_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                       ASTNodeToken _ERROR_KEY,
                                                       Iproduces _produces,
                                                       Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._ERROR_KEY = _ERROR_KEY;
            ((ASTNode) _ERROR_KEY).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_ERROR_KEY);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__ERROR_KEY_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__ERROR_KEY_produces_alias_rhs other = (aliasSpec__ERROR_KEY_produces_alias_rhs) o;
            if (! _ERROR_KEY.equals(other._ERROR_KEY)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_ERROR_KEY.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _ERROR_KEY.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 41:  aliasSpec ::= EOL_KEY produces alias_rhs
     *</b>
     */
    static public class aliasSpec__EOL_KEY_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private ASTNodeToken _EOL_KEY;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public ASTNodeToken getEOL_KEY() { return _EOL_KEY; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__EOL_KEY_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                     ASTNodeToken _EOL_KEY,
                                                     Iproduces _produces,
                                                     Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._EOL_KEY = _EOL_KEY;
            ((ASTNode) _EOL_KEY).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_EOL_KEY);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__EOL_KEY_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__EOL_KEY_produces_alias_rhs other = (aliasSpec__EOL_KEY_produces_alias_rhs) o;
            if (! _EOL_KEY.equals(other._EOL_KEY)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_EOL_KEY.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _EOL_KEY.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 42:  aliasSpec ::= EOF_KEY produces alias_rhs
     *</b>
     */
    static public class aliasSpec__EOF_KEY_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private ASTNodeToken _EOF_KEY;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public ASTNodeToken getEOF_KEY() { return _EOF_KEY; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__EOF_KEY_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                     ASTNodeToken _EOF_KEY,
                                                     Iproduces _produces,
                                                     Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._EOF_KEY = _EOF_KEY;
            ((ASTNode) _EOF_KEY).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_EOF_KEY);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__EOF_KEY_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__EOF_KEY_produces_alias_rhs other = (aliasSpec__EOF_KEY_produces_alias_rhs) o;
            if (! _EOF_KEY.equals(other._EOF_KEY)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_EOF_KEY.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _EOF_KEY.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 43:  aliasSpec ::= IDENTIFIER_KEY produces alias_rhs
     *</b>
     */
    static public class aliasSpec__IDENTIFIER_KEY_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private ASTNodeToken _IDENTIFIER_KEY;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public ASTNodeToken getIDENTIFIER_KEY() { return _IDENTIFIER_KEY; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__IDENTIFIER_KEY_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                            ASTNodeToken _IDENTIFIER_KEY,
                                                            Iproduces _produces,
                                                            Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._IDENTIFIER_KEY = _IDENTIFIER_KEY;
            ((ASTNode) _IDENTIFIER_KEY).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_IDENTIFIER_KEY);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__IDENTIFIER_KEY_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__IDENTIFIER_KEY_produces_alias_rhs other = (aliasSpec__IDENTIFIER_KEY_produces_alias_rhs) o;
            if (! _IDENTIFIER_KEY.equals(other._IDENTIFIER_KEY)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_IDENTIFIER_KEY.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _IDENTIFIER_KEY.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 44:  aliasSpec ::= SYMBOL produces alias_rhs
     *</b>
     */
    static public class aliasSpec__SYMBOL_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private ASTNodeToken _SYMBOL;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__SYMBOL_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                    ASTNodeToken _SYMBOL,
                                                    Iproduces _produces,
                                                    Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__SYMBOL_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__SYMBOL_produces_alias_rhs other = (aliasSpec__SYMBOL_produces_alias_rhs) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 45:  aliasSpec ::= alias_lhs_macro_name produces alias_rhs
     *</b>
     */
    static public class aliasSpec__alias_lhs_macro_name_produces_alias_rhs extends ASTNode implements IaliasSpec
    {
        private alias_lhs_macro_name _alias_lhs_macro_name;
        private Iproduces _produces;
        private Ialias_rhs _alias_rhs;

        public alias_lhs_macro_name getalias_lhs_macro_name() { return _alias_lhs_macro_name; }
        public Iproduces getproduces() { return _produces; }
        public Ialias_rhs getalias_rhs() { return _alias_rhs; }

        public aliasSpec__alias_lhs_macro_name_produces_alias_rhs(IToken leftIToken, IToken rightIToken,
                                                                  alias_lhs_macro_name _alias_lhs_macro_name,
                                                                  Iproduces _produces,
                                                                  Ialias_rhs _alias_rhs)
        {
            super(leftIToken, rightIToken);

            this._alias_lhs_macro_name = _alias_lhs_macro_name;
            ((ASTNode) _alias_lhs_macro_name).setParent(this);
            this._produces = _produces;
            ((ASTNode) _produces).setParent(this);
            this._alias_rhs = _alias_rhs;
            ((ASTNode) _alias_rhs).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_alias_lhs_macro_name);
            list.add(_produces);
            list.add(_alias_rhs);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof aliasSpec__alias_lhs_macro_name_produces_alias_rhs)) return false;
            if (! super.equals(o)) return false;
            aliasSpec__alias_lhs_macro_name_produces_alias_rhs other = (aliasSpec__alias_lhs_macro_name_produces_alias_rhs) o;
            if (! _alias_lhs_macro_name.equals(other._alias_lhs_macro_name)) return false;
            if (! _produces.equals(other._produces)) return false;
            if (! _alias_rhs.equals(other._alias_rhs)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_alias_lhs_macro_name.hashCode());
            hash = hash * 31 + (_produces.hashCode());
            hash = hash * 31 + (_alias_rhs.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _alias_lhs_macro_name.accept(v);
                _produces.accept(v);
                _alias_rhs.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 47:  alias_rhs ::= SYMBOL
     *</b>
     */
    static public class alias_rhs__SYMBOL extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getSYMBOL() { return leftIToken; }

        public alias_rhs__SYMBOL(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 48:  alias_rhs ::= MACRO_NAME
     *</b>
     */
    static public class alias_rhs__MACRO_NAME extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public alias_rhs__MACRO_NAME(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 49:  alias_rhs ::= ERROR_KEY
     *</b>
     */
    static public class alias_rhs__ERROR_KEY extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getERROR_KEY() { return leftIToken; }

        public alias_rhs__ERROR_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 50:  alias_rhs ::= EOL_KEY
     *</b>
     */
    static public class alias_rhs__EOL_KEY extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getEOL_KEY() { return leftIToken; }

        public alias_rhs__EOL_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 51:  alias_rhs ::= EOF_KEY
     *</b>
     */
    static public class alias_rhs__EOF_KEY extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getEOF_KEY() { return leftIToken; }

        public alias_rhs__EOF_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 52:  alias_rhs ::= EMPTY_KEY
     *</b>
     */
    static public class alias_rhs__EMPTY_KEY extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getEMPTY_KEY() { return leftIToken; }

        public alias_rhs__EMPTY_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 53:  alias_rhs ::= IDENTIFIER_KEY
     *</b>
     */
    static public class alias_rhs__IDENTIFIER_KEY extends ASTNodeToken implements Ialias_rhs
    {
        public IToken getIDENTIFIER_KEY() { return leftIToken; }

        public alias_rhs__IDENTIFIER_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 58:  macro_name_symbol ::= MACRO_NAME
     *</b>
     */
    static public class macro_name_symbol__MACRO_NAME extends ASTNodeToken implements Imacro_name_symbol
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public macro_name_symbol__MACRO_NAME(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 59:  macro_name_symbol ::= SYMBOL
     *</b>
     */
    static public class macro_name_symbol__SYMBOL extends ASTNodeToken implements Imacro_name_symbol
    {
        public IToken getSYMBOL() { return leftIToken; }

        public macro_name_symbol__SYMBOL(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 73:  drop_command ::= DROPSYMBOLS_KEY drop_symbols
     *</b>
     */
    static public class drop_command__DROPSYMBOLS_KEY_drop_symbols extends ASTNode implements Idrop_command
    {
        private ASTNodeToken _DROPSYMBOLS_KEY;
        private SYMBOLList _drop_symbols;

        public ASTNodeToken getDROPSYMBOLS_KEY() { return _DROPSYMBOLS_KEY; }
        public SYMBOLList getdrop_symbols() { return _drop_symbols; }

        public drop_command__DROPSYMBOLS_KEY_drop_symbols(IToken leftIToken, IToken rightIToken,
                                                          ASTNodeToken _DROPSYMBOLS_KEY,
                                                          SYMBOLList _drop_symbols)
        {
            super(leftIToken, rightIToken);

            this._DROPSYMBOLS_KEY = _DROPSYMBOLS_KEY;
            ((ASTNode) _DROPSYMBOLS_KEY).setParent(this);
            this._drop_symbols = _drop_symbols;
            ((ASTNode) _drop_symbols).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_DROPSYMBOLS_KEY);
            list.add(_drop_symbols);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof drop_command__DROPSYMBOLS_KEY_drop_symbols)) return false;
            if (! super.equals(o)) return false;
            drop_command__DROPSYMBOLS_KEY_drop_symbols other = (drop_command__DROPSYMBOLS_KEY_drop_symbols) o;
            if (! _DROPSYMBOLS_KEY.equals(other._DROPSYMBOLS_KEY)) return false;
            if (! _drop_symbols.equals(other._drop_symbols)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_DROPSYMBOLS_KEY.hashCode());
            hash = hash * 31 + (_drop_symbols.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _DROPSYMBOLS_KEY.accept(v);
                _drop_symbols.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 74:  drop_command ::= DROPRULES_KEY drop_rules
     *</b>
     */
    static public class drop_command__DROPRULES_KEY_drop_rules extends ASTNode implements Idrop_command
    {
        private ASTNodeToken _DROPRULES_KEY;
        private drop_ruleList _drop_rules;

        public ASTNodeToken getDROPRULES_KEY() { return _DROPRULES_KEY; }
        public drop_ruleList getdrop_rules() { return _drop_rules; }

        public drop_command__DROPRULES_KEY_drop_rules(IToken leftIToken, IToken rightIToken,
                                                      ASTNodeToken _DROPRULES_KEY,
                                                      drop_ruleList _drop_rules)
        {
            super(leftIToken, rightIToken);

            this._DROPRULES_KEY = _DROPRULES_KEY;
            ((ASTNode) _DROPRULES_KEY).setParent(this);
            this._drop_rules = _drop_rules;
            ((ASTNode) _drop_rules).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_DROPRULES_KEY);
            list.add(_drop_rules);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof drop_command__DROPRULES_KEY_drop_rules)) return false;
            if (! super.equals(o)) return false;
            drop_command__DROPRULES_KEY_drop_rules other = (drop_command__DROPRULES_KEY_drop_rules) o;
            if (! _DROPRULES_KEY.equals(other._DROPRULES_KEY)) return false;
            if (! _drop_rules.equals(other._drop_rules)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_DROPRULES_KEY.hashCode());
            hash = hash * 31 + (_drop_rules.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _DROPRULES_KEY.accept(v);
                _drop_rules.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 90:  name ::= SYMBOL
     *</b>
     */
    static public class name__SYMBOL extends ASTNodeToken implements Iname
    {
        public IToken getSYMBOL() { return leftIToken; }

        public name__SYMBOL(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 91:  name ::= MACRO_NAME
     *</b>
     */
    static public class name__MACRO_NAME extends ASTNodeToken implements Iname
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public name__MACRO_NAME(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 92:  name ::= EMPTY_KEY
     *</b>
     */
    static public class name__EMPTY_KEY extends ASTNodeToken implements Iname
    {
        public IToken getEMPTY_KEY() { return leftIToken; }

        public name__EMPTY_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 93:  name ::= ERROR_KEY
     *</b>
     */
    static public class name__ERROR_KEY extends ASTNodeToken implements Iname
    {
        public IToken getERROR_KEY() { return leftIToken; }

        public name__ERROR_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 94:  name ::= EOL_KEY
     *</b>
     */
    static public class name__EOL_KEY extends ASTNodeToken implements Iname
    {
        public IToken getEOL_KEY() { return leftIToken; }

        public name__EOL_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 95:  name ::= IDENTIFIER_KEY
     *</b>
     */
    static public class name__IDENTIFIER_KEY extends ASTNodeToken implements Iname
    {
        public IToken getIDENTIFIER_KEY() { return leftIToken; }

        public name__IDENTIFIER_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 107:  produces ::= ::=
     *</b>
     */
    static public class produces__EQUIVALENCE extends ASTNodeToken implements Iproduces
    {
        public IToken getEQUIVALENCE() { return leftIToken; }

        public produces__EQUIVALENCE(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 108:  produces ::= ::=?
     *</b>
     */
    static public class produces__PRIORITY_EQUIVALENCE extends ASTNodeToken implements Iproduces
    {
        public IToken getPRIORITY_EQUIVALENCE() { return leftIToken; }

        public produces__PRIORITY_EQUIVALENCE(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 109:  produces ::= ->
     *</b>
     */
    static public class produces__ARROW extends ASTNodeToken implements Iproduces
    {
        public IToken getARROW() { return leftIToken; }

        public produces__ARROW(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 110:  produces ::= ->?
     *</b>
     */
    static public class produces__PRIORITY_ARROW extends ASTNodeToken implements Iproduces
    {
        public IToken getPRIORITY_ARROW() { return leftIToken; }

        public produces__PRIORITY_ARROW(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 114:  symWithAttrs ::= EMPTY_KEY
     *</b>
     */
    static public class symWithAttrs__EMPTY_KEY extends ASTNodeToken implements IsymWithAttrs
    {
        public IToken getEMPTY_KEY() { return leftIToken; }

        public symWithAttrs__EMPTY_KEY(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 115:  symWithAttrs ::= SYMBOL optAttrList
     *</b>
     */
    static public class symWithAttrs__SYMBOL_optAttrList extends ASTNode implements IsymWithAttrs
    {
        private ASTNodeToken _SYMBOL;
        private symAttrs _optAttrList;

        public ASTNodeToken getSYMBOL() { return _SYMBOL; }
        /**
         * The value returned by <b>getoptAttrList</b> may be <b>null</b>
         */
        public symAttrs getoptAttrList() { return _optAttrList; }

        public symWithAttrs__SYMBOL_optAttrList(IToken leftIToken, IToken rightIToken,
                                                ASTNodeToken _SYMBOL,
                                                symAttrs _optAttrList)
        {
            super(leftIToken, rightIToken);

            this._SYMBOL = _SYMBOL;
            ((ASTNode) _SYMBOL).setParent(this);
            this._optAttrList = _optAttrList;
            if (_optAttrList != null) ((ASTNode) _optAttrList).setParent(this);
            initialize();
        }

        /**
         * A list of all children of this node, including the null ones.
         */
        public java.util.ArrayList getAllChildren()
        {
            java.util.ArrayList list = new java.util.ArrayList();
            list.add(_SYMBOL);
            list.add(_optAttrList);
            return list;
        }

        public boolean equals(Object o)
        {
            if (o == this) return true;
            if (! (o instanceof symWithAttrs__SYMBOL_optAttrList)) return false;
            if (! super.equals(o)) return false;
            symWithAttrs__SYMBOL_optAttrList other = (symWithAttrs__SYMBOL_optAttrList) o;
            if (! _SYMBOL.equals(other._SYMBOL)) return false;
            if (_optAttrList == null)
                if (other._optAttrList != null) return false;
                else; // continue
            else if (! _optAttrList.equals(other._optAttrList)) return false;
            return true;
        }

        public int hashCode()
        {
            int hash = super.hashCode();
            hash = hash * 31 + (_SYMBOL.hashCode());
            hash = hash * 31 + (_optAttrList == null ? 0 : _optAttrList.hashCode());
            return hash;
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            boolean checkChildren = v.visit(this);
            if (checkChildren)
            {
                _SYMBOL.accept(v);
                if (_optAttrList != null) _optAttrList.accept(v);
            }
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 123:  start_symbol ::= SYMBOL
     *</b>
     */
    static public class start_symbol__SYMBOL extends ASTNodeToken implements Istart_symbol
    {
        public IToken getSYMBOL() { return leftIToken; }

        public start_symbol__SYMBOL(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 124:  start_symbol ::= MACRO_NAME
     *</b>
     */
    static public class start_symbol__MACRO_NAME extends ASTNodeToken implements Istart_symbol
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public start_symbol__MACRO_NAME(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    /**
     *<b>
     *<li>Rule 130:  terminal_symbol ::= SYMBOL
     *</b>
     */
    static public class terminal_symbol__SYMBOL extends ASTNodeToken implements Iterminal_symbol
    {
        private LPGParser environment;
        public LPGParser getEnvironment() { return environment; }

        public IToken getSYMBOL() { return leftIToken; }

        public terminal_symbol__SYMBOL(LPGParser environment, IToken token)        {
            super(token);
            this.environment = environment;
            initialize();
        }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }

    void initialize() { symtab.put(getSYMBOL().toString(), this); }
     }

    /**
     *<b>
     *<li>Rule 131:  terminal_symbol ::= MACRO_NAME
     *</b>
     */
    static public class terminal_symbol__MACRO_NAME extends ASTNodeToken implements Iterminal_symbol
    {
        public IToken getMACRO_NAME() { return leftIToken; }

        public terminal_symbol__MACRO_NAME(IToken token) { super(token); initialize(); }

        public void accept(IAstVisitor v)
        {
            if (! v.preVisit(this)) return;
            enter((Visitor) v);
            v.postVisit(this);
        }

        public void enter(Visitor v)
        {
            v.visit(this);
            v.endVisit(this);
        }
    }

    public interface Visitor extends IAstVisitor
    {
        boolean visit(ASTNode n);
        void endVisit(ASTNode n);

        boolean visit(ASTNodeToken n);
        void endVisit(ASTNodeToken n);

        boolean visit(LPG n);
        void endVisit(LPG n);

        boolean visit(LPG_itemList n);
        void endVisit(LPG_itemList n);

        boolean visit(AliasSeg n);
        void endVisit(AliasSeg n);

        boolean visit(AstSeg n);
        void endVisit(AstSeg n);

        boolean visit(DefineSeg n);
        void endVisit(DefineSeg n);

        boolean visit(EofSeg n);
        void endVisit(EofSeg n);

        boolean visit(EolSeg n);
        void endVisit(EolSeg n);

        boolean visit(ErrorSeg n);
        void endVisit(ErrorSeg n);

        boolean visit(ExportSeg n);
        void endVisit(ExportSeg n);

        boolean visit(GlobalsSeg n);
        void endVisit(GlobalsSeg n);

        boolean visit(HeadersSeg n);
        void endVisit(HeadersSeg n);

        boolean visit(IdentifierSeg n);
        void endVisit(IdentifierSeg n);

        boolean visit(ImportSeg n);
        void endVisit(ImportSeg n);

        boolean visit(IncludeSeg n);
        void endVisit(IncludeSeg n);

        boolean visit(KeywordsSeg n);
        void endVisit(KeywordsSeg n);

        boolean visit(NamesSeg n);
        void endVisit(NamesSeg n);

        boolean visit(NoticeSeg n);
        void endVisit(NoticeSeg n);

        boolean visit(RulesSeg n);
        void endVisit(RulesSeg n);

        boolean visit(SoftKeywordsSeg n);
        void endVisit(SoftKeywordsSeg n);

        boolean visit(StartSeg n);
        void endVisit(StartSeg n);

        boolean visit(TerminalsSeg n);
        void endVisit(TerminalsSeg n);

        boolean visit(TrailersSeg n);
        void endVisit(TrailersSeg n);

        boolean visit(TypesSeg n);
        void endVisit(TypesSeg n);

        boolean visit(RecoverSeg n);
        void endVisit(RecoverSeg n);

        boolean visit(PredecessorSeg n);
        void endVisit(PredecessorSeg n);

        boolean visit(option_specList n);
        void endVisit(option_specList n);

        boolean visit(option_spec n);
        void endVisit(option_spec n);

        boolean visit(optionList n);
        void endVisit(optionList n);

        boolean visit(option n);
        void endVisit(option n);

        boolean visit(SYMBOLList n);
        void endVisit(SYMBOLList n);

        boolean visit(aliasSpecList n);
        void endVisit(aliasSpecList n);

        boolean visit(alias_lhs_macro_name n);
        void endVisit(alias_lhs_macro_name n);

        boolean visit(defineSpecList n);
        void endVisit(defineSpecList n);

        boolean visit(defineSpec n);
        void endVisit(defineSpec n);

        boolean visit(macro_segment n);
        void endVisit(macro_segment n);

        boolean visit(terminal_symbolList n);
        void endVisit(terminal_symbolList n);

        boolean visit(action_segmentList n);
        void endVisit(action_segmentList n);

        boolean visit(import_segment n);
        void endVisit(import_segment n);

        boolean visit(drop_commandList n);
        void endVisit(drop_commandList n);

        boolean visit(drop_ruleList n);
        void endVisit(drop_ruleList n);

        boolean visit(drop_rule n);
        void endVisit(drop_rule n);

        boolean visit(optMacroName n);
        void endVisit(optMacroName n);

        boolean visit(include_segment n);
        void endVisit(include_segment n);

        boolean visit(keywordSpecList n);
        void endVisit(keywordSpecList n);

        boolean visit(keywordSpec n);
        void endVisit(keywordSpec n);

        boolean visit(nameSpecList n);
        void endVisit(nameSpecList n);

        boolean visit(nameSpec n);
        void endVisit(nameSpec n);

        boolean visit(rules_segment n);
        void endVisit(rules_segment n);

        boolean visit(nonTermList n);
        void endVisit(nonTermList n);

        boolean visit(nonTerm n);
        void endVisit(nonTerm n);

        boolean visit(RuleName n);
        void endVisit(RuleName n);

        boolean visit(ruleList n);
        void endVisit(ruleList n);

        boolean visit(rule n);
        void endVisit(rule n);

        boolean visit(symWithAttrsList n);
        void endVisit(symWithAttrsList n);

        boolean visit(symAttrs n);
        void endVisit(symAttrs n);

        boolean visit(action_segment n);
        void endVisit(action_segment n);

        boolean visit(start_symbolList n);
        void endVisit(start_symbolList n);

        boolean visit(terminalList n);
        void endVisit(terminalList n);

        boolean visit(terminal n);
        void endVisit(terminal n);

        boolean visit(optTerminalAlias n);
        void endVisit(optTerminalAlias n);

        boolean visit(type_declarationsList n);
        void endVisit(type_declarationsList n);

        boolean visit(type_declarations n);
        void endVisit(type_declarations n);

        boolean visit(symbol_pairList n);
        void endVisit(symbol_pairList n);

        boolean visit(symbol_pair n);
        void endVisit(symbol_pair n);

        boolean visit(recover_symbol n);
        void endVisit(recover_symbol n);

        boolean visit(END_KEY_OPT n);
        void endVisit(END_KEY_OPT n);

        boolean visit(option_value__EQUAL_SYMBOL n);
        void endVisit(option_value__EQUAL_SYMBOL n);

        boolean visit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN n);
        void endVisit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN n);

        boolean visit(aliasSpec__ERROR_KEY_produces_alias_rhs n);
        void endVisit(aliasSpec__ERROR_KEY_produces_alias_rhs n);

        boolean visit(aliasSpec__EOL_KEY_produces_alias_rhs n);
        void endVisit(aliasSpec__EOL_KEY_produces_alias_rhs n);

        boolean visit(aliasSpec__EOF_KEY_produces_alias_rhs n);
        void endVisit(aliasSpec__EOF_KEY_produces_alias_rhs n);

        boolean visit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs n);
        void endVisit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs n);

        boolean visit(aliasSpec__SYMBOL_produces_alias_rhs n);
        void endVisit(aliasSpec__SYMBOL_produces_alias_rhs n);

        boolean visit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs n);
        void endVisit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs n);

        boolean visit(alias_rhs__SYMBOL n);
        void endVisit(alias_rhs__SYMBOL n);

        boolean visit(alias_rhs__MACRO_NAME n);
        void endVisit(alias_rhs__MACRO_NAME n);

        boolean visit(alias_rhs__ERROR_KEY n);
        void endVisit(alias_rhs__ERROR_KEY n);

        boolean visit(alias_rhs__EOL_KEY n);
        void endVisit(alias_rhs__EOL_KEY n);

        boolean visit(alias_rhs__EOF_KEY n);
        void endVisit(alias_rhs__EOF_KEY n);

        boolean visit(alias_rhs__EMPTY_KEY n);
        void endVisit(alias_rhs__EMPTY_KEY n);

        boolean visit(alias_rhs__IDENTIFIER_KEY n);
        void endVisit(alias_rhs__IDENTIFIER_KEY n);

        boolean visit(macro_name_symbol__MACRO_NAME n);
        void endVisit(macro_name_symbol__MACRO_NAME n);

        boolean visit(macro_name_symbol__SYMBOL n);
        void endVisit(macro_name_symbol__SYMBOL n);

        boolean visit(drop_command__DROPSYMBOLS_KEY_drop_symbols n);
        void endVisit(drop_command__DROPSYMBOLS_KEY_drop_symbols n);

        boolean visit(drop_command__DROPRULES_KEY_drop_rules n);
        void endVisit(drop_command__DROPRULES_KEY_drop_rules n);

        boolean visit(name__SYMBOL n);
        void endVisit(name__SYMBOL n);

        boolean visit(name__MACRO_NAME n);
        void endVisit(name__MACRO_NAME n);

        boolean visit(name__EMPTY_KEY n);
        void endVisit(name__EMPTY_KEY n);

        boolean visit(name__ERROR_KEY n);
        void endVisit(name__ERROR_KEY n);

        boolean visit(name__EOL_KEY n);
        void endVisit(name__EOL_KEY n);

        boolean visit(name__IDENTIFIER_KEY n);
        void endVisit(name__IDENTIFIER_KEY n);

        boolean visit(produces__EQUIVALENCE n);
        void endVisit(produces__EQUIVALENCE n);

        boolean visit(produces__PRIORITY_EQUIVALENCE n);
        void endVisit(produces__PRIORITY_EQUIVALENCE n);

        boolean visit(produces__ARROW n);
        void endVisit(produces__ARROW n);

        boolean visit(produces__PRIORITY_ARROW n);
        void endVisit(produces__PRIORITY_ARROW n);

        boolean visit(symWithAttrs__EMPTY_KEY n);
        void endVisit(symWithAttrs__EMPTY_KEY n);

        boolean visit(symWithAttrs__SYMBOL_optAttrList n);
        void endVisit(symWithAttrs__SYMBOL_optAttrList n);

        boolean visit(start_symbol__SYMBOL n);
        void endVisit(start_symbol__SYMBOL n);

        boolean visit(start_symbol__MACRO_NAME n);
        void endVisit(start_symbol__MACRO_NAME n);

        boolean visit(terminal_symbol__SYMBOL n);
        void endVisit(terminal_symbol__SYMBOL n);

        boolean visit(terminal_symbol__MACRO_NAME n);
        void endVisit(terminal_symbol__MACRO_NAME n);

    }

    static public abstract class AbstractVisitor implements Visitor
    {
        public abstract void unimplementedVisitor(String s);

        public boolean preVisit(IAst element) { return true; }

        public void postVisit(IAst element) {}

        public boolean visit(ASTNodeToken n) { unimplementedVisitor("visit(ASTNodeToken)"); return true; }
        public void endVisit(ASTNodeToken n) { unimplementedVisitor("endVisit(ASTNodeToken)"); }

        public boolean visit(LPG n) { unimplementedVisitor("visit(LPG)"); return true; }
        public void endVisit(LPG n) { unimplementedVisitor("endVisit(LPG)"); }

        public boolean visit(LPG_itemList n) { unimplementedVisitor("visit(LPG_itemList)"); return true; }
        public void endVisit(LPG_itemList n) { unimplementedVisitor("endVisit(LPG_itemList)"); }

        public boolean visit(AliasSeg n) { unimplementedVisitor("visit(AliasSeg)"); return true; }
        public void endVisit(AliasSeg n) { unimplementedVisitor("endVisit(AliasSeg)"); }

        public boolean visit(AstSeg n) { unimplementedVisitor("visit(AstSeg)"); return true; }
        public void endVisit(AstSeg n) { unimplementedVisitor("endVisit(AstSeg)"); }

        public boolean visit(DefineSeg n) { unimplementedVisitor("visit(DefineSeg)"); return true; }
        public void endVisit(DefineSeg n) { unimplementedVisitor("endVisit(DefineSeg)"); }

        public boolean visit(EofSeg n) { unimplementedVisitor("visit(EofSeg)"); return true; }
        public void endVisit(EofSeg n) { unimplementedVisitor("endVisit(EofSeg)"); }

        public boolean visit(EolSeg n) { unimplementedVisitor("visit(EolSeg)"); return true; }
        public void endVisit(EolSeg n) { unimplementedVisitor("endVisit(EolSeg)"); }

        public boolean visit(ErrorSeg n) { unimplementedVisitor("visit(ErrorSeg)"); return true; }
        public void endVisit(ErrorSeg n) { unimplementedVisitor("endVisit(ErrorSeg)"); }

        public boolean visit(ExportSeg n) { unimplementedVisitor("visit(ExportSeg)"); return true; }
        public void endVisit(ExportSeg n) { unimplementedVisitor("endVisit(ExportSeg)"); }

        public boolean visit(GlobalsSeg n) { unimplementedVisitor("visit(GlobalsSeg)"); return true; }
        public void endVisit(GlobalsSeg n) { unimplementedVisitor("endVisit(GlobalsSeg)"); }

        public boolean visit(HeadersSeg n) { unimplementedVisitor("visit(HeadersSeg)"); return true; }
        public void endVisit(HeadersSeg n) { unimplementedVisitor("endVisit(HeadersSeg)"); }

        public boolean visit(IdentifierSeg n) { unimplementedVisitor("visit(IdentifierSeg)"); return true; }
        public void endVisit(IdentifierSeg n) { unimplementedVisitor("endVisit(IdentifierSeg)"); }

        public boolean visit(ImportSeg n) { unimplementedVisitor("visit(ImportSeg)"); return true; }
        public void endVisit(ImportSeg n) { unimplementedVisitor("endVisit(ImportSeg)"); }

        public boolean visit(IncludeSeg n) { unimplementedVisitor("visit(IncludeSeg)"); return true; }
        public void endVisit(IncludeSeg n) { unimplementedVisitor("endVisit(IncludeSeg)"); }

        public boolean visit(KeywordsSeg n) { unimplementedVisitor("visit(KeywordsSeg)"); return true; }
        public void endVisit(KeywordsSeg n) { unimplementedVisitor("endVisit(KeywordsSeg)"); }

        public boolean visit(NamesSeg n) { unimplementedVisitor("visit(NamesSeg)"); return true; }
        public void endVisit(NamesSeg n) { unimplementedVisitor("endVisit(NamesSeg)"); }

        public boolean visit(NoticeSeg n) { unimplementedVisitor("visit(NoticeSeg)"); return true; }
        public void endVisit(NoticeSeg n) { unimplementedVisitor("endVisit(NoticeSeg)"); }

        public boolean visit(RulesSeg n) { unimplementedVisitor("visit(RulesSeg)"); return true; }
        public void endVisit(RulesSeg n) { unimplementedVisitor("endVisit(RulesSeg)"); }

        public boolean visit(SoftKeywordsSeg n) { unimplementedVisitor("visit(SoftKeywordsSeg)"); return true; }
        public void endVisit(SoftKeywordsSeg n) { unimplementedVisitor("endVisit(SoftKeywordsSeg)"); }

        public boolean visit(StartSeg n) { unimplementedVisitor("visit(StartSeg)"); return true; }
        public void endVisit(StartSeg n) { unimplementedVisitor("endVisit(StartSeg)"); }

        public boolean visit(TerminalsSeg n) { unimplementedVisitor("visit(TerminalsSeg)"); return true; }
        public void endVisit(TerminalsSeg n) { unimplementedVisitor("endVisit(TerminalsSeg)"); }

        public boolean visit(TrailersSeg n) { unimplementedVisitor("visit(TrailersSeg)"); return true; }
        public void endVisit(TrailersSeg n) { unimplementedVisitor("endVisit(TrailersSeg)"); }

        public boolean visit(TypesSeg n) { unimplementedVisitor("visit(TypesSeg)"); return true; }
        public void endVisit(TypesSeg n) { unimplementedVisitor("endVisit(TypesSeg)"); }

        public boolean visit(RecoverSeg n) { unimplementedVisitor("visit(RecoverSeg)"); return true; }
        public void endVisit(RecoverSeg n) { unimplementedVisitor("endVisit(RecoverSeg)"); }

        public boolean visit(PredecessorSeg n) { unimplementedVisitor("visit(PredecessorSeg)"); return true; }
        public void endVisit(PredecessorSeg n) { unimplementedVisitor("endVisit(PredecessorSeg)"); }

        public boolean visit(option_specList n) { unimplementedVisitor("visit(option_specList)"); return true; }
        public void endVisit(option_specList n) { unimplementedVisitor("endVisit(option_specList)"); }

        public boolean visit(option_spec n) { unimplementedVisitor("visit(option_spec)"); return true; }
        public void endVisit(option_spec n) { unimplementedVisitor("endVisit(option_spec)"); }

        public boolean visit(optionList n) { unimplementedVisitor("visit(optionList)"); return true; }
        public void endVisit(optionList n) { unimplementedVisitor("endVisit(optionList)"); }

        public boolean visit(option n) { unimplementedVisitor("visit(option)"); return true; }
        public void endVisit(option n) { unimplementedVisitor("endVisit(option)"); }

        public boolean visit(SYMBOLList n) { unimplementedVisitor("visit(SYMBOLList)"); return true; }
        public void endVisit(SYMBOLList n) { unimplementedVisitor("endVisit(SYMBOLList)"); }

        public boolean visit(aliasSpecList n) { unimplementedVisitor("visit(aliasSpecList)"); return true; }
        public void endVisit(aliasSpecList n) { unimplementedVisitor("endVisit(aliasSpecList)"); }

        public boolean visit(alias_lhs_macro_name n) { unimplementedVisitor("visit(alias_lhs_macro_name)"); return true; }
        public void endVisit(alias_lhs_macro_name n) { unimplementedVisitor("endVisit(alias_lhs_macro_name)"); }

        public boolean visit(defineSpecList n) { unimplementedVisitor("visit(defineSpecList)"); return true; }
        public void endVisit(defineSpecList n) { unimplementedVisitor("endVisit(defineSpecList)"); }

        public boolean visit(defineSpec n) { unimplementedVisitor("visit(defineSpec)"); return true; }
        public void endVisit(defineSpec n) { unimplementedVisitor("endVisit(defineSpec)"); }

        public boolean visit(macro_segment n) { unimplementedVisitor("visit(macro_segment)"); return true; }
        public void endVisit(macro_segment n) { unimplementedVisitor("endVisit(macro_segment)"); }

        public boolean visit(terminal_symbolList n) { unimplementedVisitor("visit(terminal_symbolList)"); return true; }
        public void endVisit(terminal_symbolList n) { unimplementedVisitor("endVisit(terminal_symbolList)"); }

        public boolean visit(action_segmentList n) { unimplementedVisitor("visit(action_segmentList)"); return true; }
        public void endVisit(action_segmentList n) { unimplementedVisitor("endVisit(action_segmentList)"); }

        public boolean visit(import_segment n) { unimplementedVisitor("visit(import_segment)"); return true; }
        public void endVisit(import_segment n) { unimplementedVisitor("endVisit(import_segment)"); }

        public boolean visit(drop_commandList n) { unimplementedVisitor("visit(drop_commandList)"); return true; }
        public void endVisit(drop_commandList n) { unimplementedVisitor("endVisit(drop_commandList)"); }

        public boolean visit(drop_ruleList n) { unimplementedVisitor("visit(drop_ruleList)"); return true; }
        public void endVisit(drop_ruleList n) { unimplementedVisitor("endVisit(drop_ruleList)"); }

        public boolean visit(drop_rule n) { unimplementedVisitor("visit(drop_rule)"); return true; }
        public void endVisit(drop_rule n) { unimplementedVisitor("endVisit(drop_rule)"); }

        public boolean visit(optMacroName n) { unimplementedVisitor("visit(optMacroName)"); return true; }
        public void endVisit(optMacroName n) { unimplementedVisitor("endVisit(optMacroName)"); }

        public boolean visit(include_segment n) { unimplementedVisitor("visit(include_segment)"); return true; }
        public void endVisit(include_segment n) { unimplementedVisitor("endVisit(include_segment)"); }

        public boolean visit(keywordSpecList n) { unimplementedVisitor("visit(keywordSpecList)"); return true; }
        public void endVisit(keywordSpecList n) { unimplementedVisitor("endVisit(keywordSpecList)"); }

        public boolean visit(keywordSpec n) { unimplementedVisitor("visit(keywordSpec)"); return true; }
        public void endVisit(keywordSpec n) { unimplementedVisitor("endVisit(keywordSpec)"); }

        public boolean visit(nameSpecList n) { unimplementedVisitor("visit(nameSpecList)"); return true; }
        public void endVisit(nameSpecList n) { unimplementedVisitor("endVisit(nameSpecList)"); }

        public boolean visit(nameSpec n) { unimplementedVisitor("visit(nameSpec)"); return true; }
        public void endVisit(nameSpec n) { unimplementedVisitor("endVisit(nameSpec)"); }

        public boolean visit(rules_segment n) { unimplementedVisitor("visit(rules_segment)"); return true; }
        public void endVisit(rules_segment n) { unimplementedVisitor("endVisit(rules_segment)"); }

        public boolean visit(nonTermList n) { unimplementedVisitor("visit(nonTermList)"); return true; }
        public void endVisit(nonTermList n) { unimplementedVisitor("endVisit(nonTermList)"); }

        public boolean visit(nonTerm n) { unimplementedVisitor("visit(nonTerm)"); return true; }
        public void endVisit(nonTerm n) { unimplementedVisitor("endVisit(nonTerm)"); }

        public boolean visit(RuleName n) { unimplementedVisitor("visit(RuleName)"); return true; }
        public void endVisit(RuleName n) { unimplementedVisitor("endVisit(RuleName)"); }

        public boolean visit(ruleList n) { unimplementedVisitor("visit(ruleList)"); return true; }
        public void endVisit(ruleList n) { unimplementedVisitor("endVisit(ruleList)"); }

        public boolean visit(rule n) { unimplementedVisitor("visit(rule)"); return true; }
        public void endVisit(rule n) { unimplementedVisitor("endVisit(rule)"); }

        public boolean visit(symWithAttrsList n) { unimplementedVisitor("visit(symWithAttrsList)"); return true; }
        public void endVisit(symWithAttrsList n) { unimplementedVisitor("endVisit(symWithAttrsList)"); }

        public boolean visit(symAttrs n) { unimplementedVisitor("visit(symAttrs)"); return true; }
        public void endVisit(symAttrs n) { unimplementedVisitor("endVisit(symAttrs)"); }

        public boolean visit(action_segment n) { unimplementedVisitor("visit(action_segment)"); return true; }
        public void endVisit(action_segment n) { unimplementedVisitor("endVisit(action_segment)"); }

        public boolean visit(start_symbolList n) { unimplementedVisitor("visit(start_symbolList)"); return true; }
        public void endVisit(start_symbolList n) { unimplementedVisitor("endVisit(start_symbolList)"); }

        public boolean visit(terminalList n) { unimplementedVisitor("visit(terminalList)"); return true; }
        public void endVisit(terminalList n) { unimplementedVisitor("endVisit(terminalList)"); }

        public boolean visit(terminal n) { unimplementedVisitor("visit(terminal)"); return true; }
        public void endVisit(terminal n) { unimplementedVisitor("endVisit(terminal)"); }

        public boolean visit(optTerminalAlias n) { unimplementedVisitor("visit(optTerminalAlias)"); return true; }
        public void endVisit(optTerminalAlias n) { unimplementedVisitor("endVisit(optTerminalAlias)"); }

        public boolean visit(type_declarationsList n) { unimplementedVisitor("visit(type_declarationsList)"); return true; }
        public void endVisit(type_declarationsList n) { unimplementedVisitor("endVisit(type_declarationsList)"); }

        public boolean visit(type_declarations n) { unimplementedVisitor("visit(type_declarations)"); return true; }
        public void endVisit(type_declarations n) { unimplementedVisitor("endVisit(type_declarations)"); }

        public boolean visit(symbol_pairList n) { unimplementedVisitor("visit(symbol_pairList)"); return true; }
        public void endVisit(symbol_pairList n) { unimplementedVisitor("endVisit(symbol_pairList)"); }

        public boolean visit(symbol_pair n) { unimplementedVisitor("visit(symbol_pair)"); return true; }
        public void endVisit(symbol_pair n) { unimplementedVisitor("endVisit(symbol_pair)"); }

        public boolean visit(recover_symbol n) { unimplementedVisitor("visit(recover_symbol)"); return true; }
        public void endVisit(recover_symbol n) { unimplementedVisitor("endVisit(recover_symbol)"); }

        public boolean visit(END_KEY_OPT n) { unimplementedVisitor("visit(END_KEY_OPT)"); return true; }
        public void endVisit(END_KEY_OPT n) { unimplementedVisitor("endVisit(END_KEY_OPT)"); }

        public boolean visit(option_value__EQUAL_SYMBOL n) { unimplementedVisitor("visit(option_value__EQUAL_SYMBOL)"); return true; }
        public void endVisit(option_value__EQUAL_SYMBOL n) { unimplementedVisitor("endVisit(option_value__EQUAL_SYMBOL)"); }

        public boolean visit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN n) { unimplementedVisitor("visit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN)"); return true; }
        public void endVisit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN n) { unimplementedVisitor("endVisit(option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN)"); }

        public boolean visit(aliasSpec__ERROR_KEY_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__ERROR_KEY_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__ERROR_KEY_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__ERROR_KEY_produces_alias_rhs)"); }

        public boolean visit(aliasSpec__EOL_KEY_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__EOL_KEY_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__EOL_KEY_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__EOL_KEY_produces_alias_rhs)"); }

        public boolean visit(aliasSpec__EOF_KEY_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__EOF_KEY_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__EOF_KEY_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__EOF_KEY_produces_alias_rhs)"); }

        public boolean visit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__IDENTIFIER_KEY_produces_alias_rhs)"); }

        public boolean visit(aliasSpec__SYMBOL_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__SYMBOL_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__SYMBOL_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__SYMBOL_produces_alias_rhs)"); }

        public boolean visit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs n) { unimplementedVisitor("visit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs)"); return true; }
        public void endVisit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs n) { unimplementedVisitor("endVisit(aliasSpec__alias_lhs_macro_name_produces_alias_rhs)"); }

        public boolean visit(alias_rhs__SYMBOL n) { unimplementedVisitor("visit(alias_rhs__SYMBOL)"); return true; }
        public void endVisit(alias_rhs__SYMBOL n) { unimplementedVisitor("endVisit(alias_rhs__SYMBOL)"); }

        public boolean visit(alias_rhs__MACRO_NAME n) { unimplementedVisitor("visit(alias_rhs__MACRO_NAME)"); return true; }
        public void endVisit(alias_rhs__MACRO_NAME n) { unimplementedVisitor("endVisit(alias_rhs__MACRO_NAME)"); }

        public boolean visit(alias_rhs__ERROR_KEY n) { unimplementedVisitor("visit(alias_rhs__ERROR_KEY)"); return true; }
        public void endVisit(alias_rhs__ERROR_KEY n) { unimplementedVisitor("endVisit(alias_rhs__ERROR_KEY)"); }

        public boolean visit(alias_rhs__EOL_KEY n) { unimplementedVisitor("visit(alias_rhs__EOL_KEY)"); return true; }
        public void endVisit(alias_rhs__EOL_KEY n) { unimplementedVisitor("endVisit(alias_rhs__EOL_KEY)"); }

        public boolean visit(alias_rhs__EOF_KEY n) { unimplementedVisitor("visit(alias_rhs__EOF_KEY)"); return true; }
        public void endVisit(alias_rhs__EOF_KEY n) { unimplementedVisitor("endVisit(alias_rhs__EOF_KEY)"); }

        public boolean visit(alias_rhs__EMPTY_KEY n) { unimplementedVisitor("visit(alias_rhs__EMPTY_KEY)"); return true; }
        public void endVisit(alias_rhs__EMPTY_KEY n) { unimplementedVisitor("endVisit(alias_rhs__EMPTY_KEY)"); }

        public boolean visit(alias_rhs__IDENTIFIER_KEY n) { unimplementedVisitor("visit(alias_rhs__IDENTIFIER_KEY)"); return true; }
        public void endVisit(alias_rhs__IDENTIFIER_KEY n) { unimplementedVisitor("endVisit(alias_rhs__IDENTIFIER_KEY)"); }

        public boolean visit(macro_name_symbol__MACRO_NAME n) { unimplementedVisitor("visit(macro_name_symbol__MACRO_NAME)"); return true; }
        public void endVisit(macro_name_symbol__MACRO_NAME n) { unimplementedVisitor("endVisit(macro_name_symbol__MACRO_NAME)"); }

        public boolean visit(macro_name_symbol__SYMBOL n) { unimplementedVisitor("visit(macro_name_symbol__SYMBOL)"); return true; }
        public void endVisit(macro_name_symbol__SYMBOL n) { unimplementedVisitor("endVisit(macro_name_symbol__SYMBOL)"); }

        public boolean visit(drop_command__DROPSYMBOLS_KEY_drop_symbols n) { unimplementedVisitor("visit(drop_command__DROPSYMBOLS_KEY_drop_symbols)"); return true; }
        public void endVisit(drop_command__DROPSYMBOLS_KEY_drop_symbols n) { unimplementedVisitor("endVisit(drop_command__DROPSYMBOLS_KEY_drop_symbols)"); }

        public boolean visit(drop_command__DROPRULES_KEY_drop_rules n) { unimplementedVisitor("visit(drop_command__DROPRULES_KEY_drop_rules)"); return true; }
        public void endVisit(drop_command__DROPRULES_KEY_drop_rules n) { unimplementedVisitor("endVisit(drop_command__DROPRULES_KEY_drop_rules)"); }

        public boolean visit(name__SYMBOL n) { unimplementedVisitor("visit(name__SYMBOL)"); return true; }
        public void endVisit(name__SYMBOL n) { unimplementedVisitor("endVisit(name__SYMBOL)"); }

        public boolean visit(name__MACRO_NAME n) { unimplementedVisitor("visit(name__MACRO_NAME)"); return true; }
        public void endVisit(name__MACRO_NAME n) { unimplementedVisitor("endVisit(name__MACRO_NAME)"); }

        public boolean visit(name__EMPTY_KEY n) { unimplementedVisitor("visit(name__EMPTY_KEY)"); return true; }
        public void endVisit(name__EMPTY_KEY n) { unimplementedVisitor("endVisit(name__EMPTY_KEY)"); }

        public boolean visit(name__ERROR_KEY n) { unimplementedVisitor("visit(name__ERROR_KEY)"); return true; }
        public void endVisit(name__ERROR_KEY n) { unimplementedVisitor("endVisit(name__ERROR_KEY)"); }

        public boolean visit(name__EOL_KEY n) { unimplementedVisitor("visit(name__EOL_KEY)"); return true; }
        public void endVisit(name__EOL_KEY n) { unimplementedVisitor("endVisit(name__EOL_KEY)"); }

        public boolean visit(name__IDENTIFIER_KEY n) { unimplementedVisitor("visit(name__IDENTIFIER_KEY)"); return true; }
        public void endVisit(name__IDENTIFIER_KEY n) { unimplementedVisitor("endVisit(name__IDENTIFIER_KEY)"); }

        public boolean visit(produces__EQUIVALENCE n) { unimplementedVisitor("visit(produces__EQUIVALENCE)"); return true; }
        public void endVisit(produces__EQUIVALENCE n) { unimplementedVisitor("endVisit(produces__EQUIVALENCE)"); }

        public boolean visit(produces__PRIORITY_EQUIVALENCE n) { unimplementedVisitor("visit(produces__PRIORITY_EQUIVALENCE)"); return true; }
        public void endVisit(produces__PRIORITY_EQUIVALENCE n) { unimplementedVisitor("endVisit(produces__PRIORITY_EQUIVALENCE)"); }

        public boolean visit(produces__ARROW n) { unimplementedVisitor("visit(produces__ARROW)"); return true; }
        public void endVisit(produces__ARROW n) { unimplementedVisitor("endVisit(produces__ARROW)"); }

        public boolean visit(produces__PRIORITY_ARROW n) { unimplementedVisitor("visit(produces__PRIORITY_ARROW)"); return true; }
        public void endVisit(produces__PRIORITY_ARROW n) { unimplementedVisitor("endVisit(produces__PRIORITY_ARROW)"); }

        public boolean visit(symWithAttrs__EMPTY_KEY n) { unimplementedVisitor("visit(symWithAttrs__EMPTY_KEY)"); return true; }
        public void endVisit(symWithAttrs__EMPTY_KEY n) { unimplementedVisitor("endVisit(symWithAttrs__EMPTY_KEY)"); }

        public boolean visit(symWithAttrs__SYMBOL_optAttrList n) { unimplementedVisitor("visit(symWithAttrs__SYMBOL_optAttrList)"); return true; }
        public void endVisit(symWithAttrs__SYMBOL_optAttrList n) { unimplementedVisitor("endVisit(symWithAttrs__SYMBOL_optAttrList)"); }

        public boolean visit(start_symbol__SYMBOL n) { unimplementedVisitor("visit(start_symbol__SYMBOL)"); return true; }
        public void endVisit(start_symbol__SYMBOL n) { unimplementedVisitor("endVisit(start_symbol__SYMBOL)"); }

        public boolean visit(start_symbol__MACRO_NAME n) { unimplementedVisitor("visit(start_symbol__MACRO_NAME)"); return true; }
        public void endVisit(start_symbol__MACRO_NAME n) { unimplementedVisitor("endVisit(start_symbol__MACRO_NAME)"); }

        public boolean visit(terminal_symbol__SYMBOL n) { unimplementedVisitor("visit(terminal_symbol__SYMBOL)"); return true; }
        public void endVisit(terminal_symbol__SYMBOL n) { unimplementedVisitor("endVisit(terminal_symbol__SYMBOL)"); }

        public boolean visit(terminal_symbol__MACRO_NAME n) { unimplementedVisitor("visit(terminal_symbol__MACRO_NAME)"); return true; }
        public void endVisit(terminal_symbol__MACRO_NAME n) { unimplementedVisitor("endVisit(terminal_symbol__MACRO_NAME)"); }


        public boolean visit(ASTNode n)
        {
            if (n instanceof ASTNodeToken) return visit((ASTNodeToken) n);
            else if (n instanceof LPG) return visit((LPG) n);
            else if (n instanceof LPG_itemList) return visit((LPG_itemList) n);
            else if (n instanceof AliasSeg) return visit((AliasSeg) n);
            else if (n instanceof AstSeg) return visit((AstSeg) n);
            else if (n instanceof DefineSeg) return visit((DefineSeg) n);
            else if (n instanceof EofSeg) return visit((EofSeg) n);
            else if (n instanceof EolSeg) return visit((EolSeg) n);
            else if (n instanceof ErrorSeg) return visit((ErrorSeg) n);
            else if (n instanceof ExportSeg) return visit((ExportSeg) n);
            else if (n instanceof GlobalsSeg) return visit((GlobalsSeg) n);
            else if (n instanceof HeadersSeg) return visit((HeadersSeg) n);
            else if (n instanceof IdentifierSeg) return visit((IdentifierSeg) n);
            else if (n instanceof ImportSeg) return visit((ImportSeg) n);
            else if (n instanceof IncludeSeg) return visit((IncludeSeg) n);
            else if (n instanceof KeywordsSeg) return visit((KeywordsSeg) n);
            else if (n instanceof NamesSeg) return visit((NamesSeg) n);
            else if (n instanceof NoticeSeg) return visit((NoticeSeg) n);
            else if (n instanceof RulesSeg) return visit((RulesSeg) n);
            else if (n instanceof SoftKeywordsSeg) return visit((SoftKeywordsSeg) n);
            else if (n instanceof StartSeg) return visit((StartSeg) n);
            else if (n instanceof TerminalsSeg) return visit((TerminalsSeg) n);
            else if (n instanceof TrailersSeg) return visit((TrailersSeg) n);
            else if (n instanceof TypesSeg) return visit((TypesSeg) n);
            else if (n instanceof RecoverSeg) return visit((RecoverSeg) n);
            else if (n instanceof PredecessorSeg) return visit((PredecessorSeg) n);
            else if (n instanceof option_specList) return visit((option_specList) n);
            else if (n instanceof option_spec) return visit((option_spec) n);
            else if (n instanceof optionList) return visit((optionList) n);
            else if (n instanceof option) return visit((option) n);
            else if (n instanceof SYMBOLList) return visit((SYMBOLList) n);
            else if (n instanceof aliasSpecList) return visit((aliasSpecList) n);
            else if (n instanceof alias_lhs_macro_name) return visit((alias_lhs_macro_name) n);
            else if (n instanceof defineSpecList) return visit((defineSpecList) n);
            else if (n instanceof defineSpec) return visit((defineSpec) n);
            else if (n instanceof macro_segment) return visit((macro_segment) n);
            else if (n instanceof terminal_symbolList) return visit((terminal_symbolList) n);
            else if (n instanceof action_segmentList) return visit((action_segmentList) n);
            else if (n instanceof import_segment) return visit((import_segment) n);
            else if (n instanceof drop_commandList) return visit((drop_commandList) n);
            else if (n instanceof drop_ruleList) return visit((drop_ruleList) n);
            else if (n instanceof drop_rule) return visit((drop_rule) n);
            else if (n instanceof optMacroName) return visit((optMacroName) n);
            else if (n instanceof include_segment) return visit((include_segment) n);
            else if (n instanceof keywordSpecList) return visit((keywordSpecList) n);
            else if (n instanceof keywordSpec) return visit((keywordSpec) n);
            else if (n instanceof nameSpecList) return visit((nameSpecList) n);
            else if (n instanceof nameSpec) return visit((nameSpec) n);
            else if (n instanceof rules_segment) return visit((rules_segment) n);
            else if (n instanceof nonTermList) return visit((nonTermList) n);
            else if (n instanceof nonTerm) return visit((nonTerm) n);
            else if (n instanceof RuleName) return visit((RuleName) n);
            else if (n instanceof ruleList) return visit((ruleList) n);
            else if (n instanceof rule) return visit((rule) n);
            else if (n instanceof symWithAttrsList) return visit((symWithAttrsList) n);
            else if (n instanceof symAttrs) return visit((symAttrs) n);
            else if (n instanceof action_segment) return visit((action_segment) n);
            else if (n instanceof start_symbolList) return visit((start_symbolList) n);
            else if (n instanceof terminalList) return visit((terminalList) n);
            else if (n instanceof terminal) return visit((terminal) n);
            else if (n instanceof optTerminalAlias) return visit((optTerminalAlias) n);
            else if (n instanceof type_declarationsList) return visit((type_declarationsList) n);
            else if (n instanceof type_declarations) return visit((type_declarations) n);
            else if (n instanceof symbol_pairList) return visit((symbol_pairList) n);
            else if (n instanceof symbol_pair) return visit((symbol_pair) n);
            else if (n instanceof recover_symbol) return visit((recover_symbol) n);
            else if (n instanceof END_KEY_OPT) return visit((END_KEY_OPT) n);
            else if (n instanceof option_value__EQUAL_SYMBOL) return visit((option_value__EQUAL_SYMBOL) n);
            else if (n instanceof option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN) return visit((option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN) n);
            else if (n instanceof aliasSpec__ERROR_KEY_produces_alias_rhs) return visit((aliasSpec__ERROR_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__EOL_KEY_produces_alias_rhs) return visit((aliasSpec__EOL_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__EOF_KEY_produces_alias_rhs) return visit((aliasSpec__EOF_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__IDENTIFIER_KEY_produces_alias_rhs) return visit((aliasSpec__IDENTIFIER_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__SYMBOL_produces_alias_rhs) return visit((aliasSpec__SYMBOL_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__alias_lhs_macro_name_produces_alias_rhs) return visit((aliasSpec__alias_lhs_macro_name_produces_alias_rhs) n);
            else if (n instanceof alias_rhs__SYMBOL) return visit((alias_rhs__SYMBOL) n);
            else if (n instanceof alias_rhs__MACRO_NAME) return visit((alias_rhs__MACRO_NAME) n);
            else if (n instanceof alias_rhs__ERROR_KEY) return visit((alias_rhs__ERROR_KEY) n);
            else if (n instanceof alias_rhs__EOL_KEY) return visit((alias_rhs__EOL_KEY) n);
            else if (n instanceof alias_rhs__EOF_KEY) return visit((alias_rhs__EOF_KEY) n);
            else if (n instanceof alias_rhs__EMPTY_KEY) return visit((alias_rhs__EMPTY_KEY) n);
            else if (n instanceof alias_rhs__IDENTIFIER_KEY) return visit((alias_rhs__IDENTIFIER_KEY) n);
            else if (n instanceof macro_name_symbol__MACRO_NAME) return visit((macro_name_symbol__MACRO_NAME) n);
            else if (n instanceof macro_name_symbol__SYMBOL) return visit((macro_name_symbol__SYMBOL) n);
            else if (n instanceof drop_command__DROPSYMBOLS_KEY_drop_symbols) return visit((drop_command__DROPSYMBOLS_KEY_drop_symbols) n);
            else if (n instanceof drop_command__DROPRULES_KEY_drop_rules) return visit((drop_command__DROPRULES_KEY_drop_rules) n);
            else if (n instanceof name__SYMBOL) return visit((name__SYMBOL) n);
            else if (n instanceof name__MACRO_NAME) return visit((name__MACRO_NAME) n);
            else if (n instanceof name__EMPTY_KEY) return visit((name__EMPTY_KEY) n);
            else if (n instanceof name__ERROR_KEY) return visit((name__ERROR_KEY) n);
            else if (n instanceof name__EOL_KEY) return visit((name__EOL_KEY) n);
            else if (n instanceof name__IDENTIFIER_KEY) return visit((name__IDENTIFIER_KEY) n);
            else if (n instanceof produces__EQUIVALENCE) return visit((produces__EQUIVALENCE) n);
            else if (n instanceof produces__PRIORITY_EQUIVALENCE) return visit((produces__PRIORITY_EQUIVALENCE) n);
            else if (n instanceof produces__ARROW) return visit((produces__ARROW) n);
            else if (n instanceof produces__PRIORITY_ARROW) return visit((produces__PRIORITY_ARROW) n);
            else if (n instanceof symWithAttrs__EMPTY_KEY) return visit((symWithAttrs__EMPTY_KEY) n);
            else if (n instanceof symWithAttrs__SYMBOL_optAttrList) return visit((symWithAttrs__SYMBOL_optAttrList) n);
            else if (n instanceof start_symbol__SYMBOL) return visit((start_symbol__SYMBOL) n);
            else if (n instanceof start_symbol__MACRO_NAME) return visit((start_symbol__MACRO_NAME) n);
            else if (n instanceof terminal_symbol__SYMBOL) return visit((terminal_symbol__SYMBOL) n);
            else if (n instanceof terminal_symbol__MACRO_NAME) return visit((terminal_symbol__MACRO_NAME) n);
            throw new UnsupportedOperationException("visit(" + n.getClass().toString() + ")");
        }
        public void endVisit(ASTNode n)
        {
            if (n instanceof ASTNodeToken) endVisit((ASTNodeToken) n);
            else if (n instanceof LPG) endVisit((LPG) n);
            else if (n instanceof LPG_itemList) endVisit((LPG_itemList) n);
            else if (n instanceof AliasSeg) endVisit((AliasSeg) n);
            else if (n instanceof AstSeg) endVisit((AstSeg) n);
            else if (n instanceof DefineSeg) endVisit((DefineSeg) n);
            else if (n instanceof EofSeg) endVisit((EofSeg) n);
            else if (n instanceof EolSeg) endVisit((EolSeg) n);
            else if (n instanceof ErrorSeg) endVisit((ErrorSeg) n);
            else if (n instanceof ExportSeg) endVisit((ExportSeg) n);
            else if (n instanceof GlobalsSeg) endVisit((GlobalsSeg) n);
            else if (n instanceof HeadersSeg) endVisit((HeadersSeg) n);
            else if (n instanceof IdentifierSeg) endVisit((IdentifierSeg) n);
            else if (n instanceof ImportSeg) endVisit((ImportSeg) n);
            else if (n instanceof IncludeSeg) endVisit((IncludeSeg) n);
            else if (n instanceof KeywordsSeg) endVisit((KeywordsSeg) n);
            else if (n instanceof NamesSeg) endVisit((NamesSeg) n);
            else if (n instanceof NoticeSeg) endVisit((NoticeSeg) n);
            else if (n instanceof RulesSeg) endVisit((RulesSeg) n);
            else if (n instanceof SoftKeywordsSeg) endVisit((SoftKeywordsSeg) n);
            else if (n instanceof StartSeg) endVisit((StartSeg) n);
            else if (n instanceof TerminalsSeg) endVisit((TerminalsSeg) n);
            else if (n instanceof TrailersSeg) endVisit((TrailersSeg) n);
            else if (n instanceof TypesSeg) endVisit((TypesSeg) n);
            else if (n instanceof RecoverSeg) endVisit((RecoverSeg) n);
            else if (n instanceof PredecessorSeg) endVisit((PredecessorSeg) n);
            else if (n instanceof option_specList) endVisit((option_specList) n);
            else if (n instanceof option_spec) endVisit((option_spec) n);
            else if (n instanceof optionList) endVisit((optionList) n);
            else if (n instanceof option) endVisit((option) n);
            else if (n instanceof SYMBOLList) endVisit((SYMBOLList) n);
            else if (n instanceof aliasSpecList) endVisit((aliasSpecList) n);
            else if (n instanceof alias_lhs_macro_name) endVisit((alias_lhs_macro_name) n);
            else if (n instanceof defineSpecList) endVisit((defineSpecList) n);
            else if (n instanceof defineSpec) endVisit((defineSpec) n);
            else if (n instanceof macro_segment) endVisit((macro_segment) n);
            else if (n instanceof terminal_symbolList) endVisit((terminal_symbolList) n);
            else if (n instanceof action_segmentList) endVisit((action_segmentList) n);
            else if (n instanceof import_segment) endVisit((import_segment) n);
            else if (n instanceof drop_commandList) endVisit((drop_commandList) n);
            else if (n instanceof drop_ruleList) endVisit((drop_ruleList) n);
            else if (n instanceof drop_rule) endVisit((drop_rule) n);
            else if (n instanceof optMacroName) endVisit((optMacroName) n);
            else if (n instanceof include_segment) endVisit((include_segment) n);
            else if (n instanceof keywordSpecList) endVisit((keywordSpecList) n);
            else if (n instanceof keywordSpec) endVisit((keywordSpec) n);
            else if (n instanceof nameSpecList) endVisit((nameSpecList) n);
            else if (n instanceof nameSpec) endVisit((nameSpec) n);
            else if (n instanceof rules_segment) endVisit((rules_segment) n);
            else if (n instanceof nonTermList) endVisit((nonTermList) n);
            else if (n instanceof nonTerm) endVisit((nonTerm) n);
            else if (n instanceof RuleName) endVisit((RuleName) n);
            else if (n instanceof ruleList) endVisit((ruleList) n);
            else if (n instanceof rule) endVisit((rule) n);
            else if (n instanceof symWithAttrsList) endVisit((symWithAttrsList) n);
            else if (n instanceof symAttrs) endVisit((symAttrs) n);
            else if (n instanceof action_segment) endVisit((action_segment) n);
            else if (n instanceof start_symbolList) endVisit((start_symbolList) n);
            else if (n instanceof terminalList) endVisit((terminalList) n);
            else if (n instanceof terminal) endVisit((terminal) n);
            else if (n instanceof optTerminalAlias) endVisit((optTerminalAlias) n);
            else if (n instanceof type_declarationsList) endVisit((type_declarationsList) n);
            else if (n instanceof type_declarations) endVisit((type_declarations) n);
            else if (n instanceof symbol_pairList) endVisit((symbol_pairList) n);
            else if (n instanceof symbol_pair) endVisit((symbol_pair) n);
            else if (n instanceof recover_symbol) endVisit((recover_symbol) n);
            else if (n instanceof END_KEY_OPT) endVisit((END_KEY_OPT) n);
            else if (n instanceof option_value__EQUAL_SYMBOL) endVisit((option_value__EQUAL_SYMBOL) n);
            else if (n instanceof option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN) endVisit((option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN) n);
            else if (n instanceof aliasSpec__ERROR_KEY_produces_alias_rhs) endVisit((aliasSpec__ERROR_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__EOL_KEY_produces_alias_rhs) endVisit((aliasSpec__EOL_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__EOF_KEY_produces_alias_rhs) endVisit((aliasSpec__EOF_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__IDENTIFIER_KEY_produces_alias_rhs) endVisit((aliasSpec__IDENTIFIER_KEY_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__SYMBOL_produces_alias_rhs) endVisit((aliasSpec__SYMBOL_produces_alias_rhs) n);
            else if (n instanceof aliasSpec__alias_lhs_macro_name_produces_alias_rhs) endVisit((aliasSpec__alias_lhs_macro_name_produces_alias_rhs) n);
            else if (n instanceof alias_rhs__SYMBOL) endVisit((alias_rhs__SYMBOL) n);
            else if (n instanceof alias_rhs__MACRO_NAME) endVisit((alias_rhs__MACRO_NAME) n);
            else if (n instanceof alias_rhs__ERROR_KEY) endVisit((alias_rhs__ERROR_KEY) n);
            else if (n instanceof alias_rhs__EOL_KEY) endVisit((alias_rhs__EOL_KEY) n);
            else if (n instanceof alias_rhs__EOF_KEY) endVisit((alias_rhs__EOF_KEY) n);
            else if (n instanceof alias_rhs__EMPTY_KEY) endVisit((alias_rhs__EMPTY_KEY) n);
            else if (n instanceof alias_rhs__IDENTIFIER_KEY) endVisit((alias_rhs__IDENTIFIER_KEY) n);
            else if (n instanceof macro_name_symbol__MACRO_NAME) endVisit((macro_name_symbol__MACRO_NAME) n);
            else if (n instanceof macro_name_symbol__SYMBOL) endVisit((macro_name_symbol__SYMBOL) n);
            else if (n instanceof drop_command__DROPSYMBOLS_KEY_drop_symbols) endVisit((drop_command__DROPSYMBOLS_KEY_drop_symbols) n);
            else if (n instanceof drop_command__DROPRULES_KEY_drop_rules) endVisit((drop_command__DROPRULES_KEY_drop_rules) n);
            else if (n instanceof name__SYMBOL) endVisit((name__SYMBOL) n);
            else if (n instanceof name__MACRO_NAME) endVisit((name__MACRO_NAME) n);
            else if (n instanceof name__EMPTY_KEY) endVisit((name__EMPTY_KEY) n);
            else if (n instanceof name__ERROR_KEY) endVisit((name__ERROR_KEY) n);
            else if (n instanceof name__EOL_KEY) endVisit((name__EOL_KEY) n);
            else if (n instanceof name__IDENTIFIER_KEY) endVisit((name__IDENTIFIER_KEY) n);
            else if (n instanceof produces__EQUIVALENCE) endVisit((produces__EQUIVALENCE) n);
            else if (n instanceof produces__PRIORITY_EQUIVALENCE) endVisit((produces__PRIORITY_EQUIVALENCE) n);
            else if (n instanceof produces__ARROW) endVisit((produces__ARROW) n);
            else if (n instanceof produces__PRIORITY_ARROW) endVisit((produces__PRIORITY_ARROW) n);
            else if (n instanceof symWithAttrs__EMPTY_KEY) endVisit((symWithAttrs__EMPTY_KEY) n);
            else if (n instanceof symWithAttrs__SYMBOL_optAttrList) endVisit((symWithAttrs__SYMBOL_optAttrList) n);
            else if (n instanceof start_symbol__SYMBOL) endVisit((start_symbol__SYMBOL) n);
            else if (n instanceof start_symbol__MACRO_NAME) endVisit((start_symbol__MACRO_NAME) n);
            else if (n instanceof terminal_symbol__SYMBOL) endVisit((terminal_symbol__SYMBOL) n);
            else if (n instanceof terminal_symbol__MACRO_NAME) endVisit((terminal_symbol__MACRO_NAME) n);
            throw new UnsupportedOperationException("visit(" + n.getClass().toString() + ")");
        }
    }

    public void ruleAction(int ruleNumber)
    {
        switch (ruleNumber)
        {

            //
            // Rule 1:  LPG ::= options_segment LPG_INPUT
            //
            case 1: {
                setResult(
                    new LPG(LPGParser.this, getLeftIToken(), getRightIToken(),
                            (option_specList)getRhsSym(1),
                            (LPG_itemList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 2:  LPG_INPUT ::= $Empty
            //
            case 2: {
                setResult(
                    new LPG_itemList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 3:  LPG_INPUT ::= LPG_INPUT LPG_item
            //
            case 3: {
                ((LPG_itemList)getRhsSym(1)).add((ILPG_item)getRhsSym(2));
                break;
            }
            //
            // Rule 4:  LPG_item ::= ALIAS_KEY$ alias_segment END_KEY_OPT$
            //
            case 4: {
                setResult(
                    new AliasSeg(getLeftIToken(), getRightIToken(),
                                 (aliasSpecList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 5:  LPG_item ::= AST_KEY$ ast_segment END_KEY_OPT$
            //
            case 5: {
                setResult(
                    new AstSeg(getLeftIToken(), getRightIToken(),
                               (action_segmentList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 6:  LPG_item ::= DEFINE_KEY$ define_segment END_KEY_OPT$
            //
            case 6: {
                setResult(
                    new DefineSeg(getLeftIToken(), getRightIToken(),
                                  (defineSpecList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 7:  LPG_item ::= EOF_KEY$ eof_segment END_KEY_OPT$
            //
            case 7: {
                setResult(
                    new EofSeg(getLeftIToken(), getRightIToken(),
                               (Ieof_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 8:  LPG_item ::= EOL_KEY$ eol_segment END_KEY_OPT$
            //
            case 8: {
                setResult(
                    new EolSeg(getLeftIToken(), getRightIToken(),
                               (Ieol_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 9:  LPG_item ::= ERROR_KEY$ error_segment END_KEY_OPT$
            //
            case 9: {
                setResult(
                    new ErrorSeg(getLeftIToken(), getRightIToken(),
                                 (Ierror_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 10:  LPG_item ::= EXPORT_KEY$ export_segment END_KEY_OPT$
            //
            case 10: {
                setResult(
                    new ExportSeg(getLeftIToken(), getRightIToken(),
                                  (terminal_symbolList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 11:  LPG_item ::= GLOBALS_KEY$ globals_segment END_KEY_OPT$
            //
            case 11: {
                setResult(
                    new GlobalsSeg(getLeftIToken(), getRightIToken(),
                                   (action_segmentList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 12:  LPG_item ::= HEADERS_KEY$ headers_segment END_KEY_OPT$
            //
            case 12: {
                setResult(
                    new HeadersSeg(getLeftIToken(), getRightIToken(),
                                   (action_segmentList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 13:  LPG_item ::= IDENTIFIER_KEY$ identifier_segment END_KEY_OPT$
            //
            case 13: {
                setResult(
                    new IdentifierSeg(getLeftIToken(), getRightIToken(),
                                      (Iidentifier_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 14:  LPG_item ::= IMPORT_KEY$ import_segment END_KEY_OPT$
            //
            case 14: {
                setResult(
                    new ImportSeg(getLeftIToken(), getRightIToken(),
                                  (import_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 15:  LPG_item ::= INCLUDE_KEY$ include_segment END_KEY_OPT$
            //
            case 15: {
                setResult(
                    new IncludeSeg(getLeftIToken(), getRightIToken(),
                                   (include_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 16:  LPG_item ::= KEYWORDS_KEY$ keywords_segment END_KEY_OPT$
            //
            case 16: {
                setResult(
                    new KeywordsSeg(getLeftIToken(), getRightIToken(),
                                    (keywordSpecList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 17:  LPG_item ::= NAMES_KEY$ names_segment END_KEY_OPT$
            //
            case 17: {
                setResult(
                    new NamesSeg(getLeftIToken(), getRightIToken(),
                                 (nameSpecList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 18:  LPG_item ::= NOTICE_KEY$ notice_segment END_KEY_OPT$
            //
            case 18: {
                setResult(
                    new NoticeSeg(getLeftIToken(), getRightIToken(),
                                  (action_segmentList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 19:  LPG_item ::= RULES_KEY$ rules_segment END_KEY_OPT$
            //
            case 19: {
                setResult(
                    new RulesSeg(getLeftIToken(), getRightIToken(),
                                 (rules_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 20:  LPG_item ::= SOFT_KEYWORDS_KEY$ keywords_segment END_KEY_OPT$
            //
            case 20: {
                setResult(
                    new SoftKeywordsSeg(getLeftIToken(), getRightIToken(),
                                        (keywordSpecList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 21:  LPG_item ::= START_KEY$ start_segment END_KEY_OPT$
            //
            case 21: {
                setResult(
                    new StartSeg(getLeftIToken(), getRightIToken(),
                                 (start_symbolList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 22:  LPG_item ::= TERMINALS_KEY$ terminals_segment END_KEY_OPT$
            //
            case 22: {
                setResult(
                    new TerminalsSeg(getLeftIToken(), getRightIToken(),
                                     (terminalList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 23:  LPG_item ::= TRAILERS_KEY$ trailers_segment END_KEY_OPT$
            //
            case 23: {
                setResult(
                    new TrailersSeg(getLeftIToken(), getRightIToken(),
                                    (action_segmentList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 24:  LPG_item ::= TYPES_KEY$ types_segment END_KEY_OPT$
            //
            case 24: {
                setResult(
                    new TypesSeg(getLeftIToken(), getRightIToken(),
                                 (type_declarationsList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 25:  LPG_item ::= RECOVER_KEY$ recover_segment END_KEY_OPT$
            //
            case 25: {
                setResult(
                    new RecoverSeg(getLeftIToken(), getRightIToken(),
                                   (SYMBOLList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 26:  LPG_item ::= DISJOINTPREDECESSORSETS_KEY$ predecessor_segment END_KEY_OPT$
            //
            case 26: {
                setResult(
                    new PredecessorSeg(getLeftIToken(), getRightIToken(),
                                       (symbol_pairList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 27:  options_segment ::= $Empty
            //
            case 27: {
                setResult(
                    new option_specList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 28:  options_segment ::= options_segment option_spec
            //
            case 28: {
                ((option_specList)getRhsSym(1)).add((option_spec)getRhsSym(2));
                break;
            }
            //
            // Rule 29:  option_spec ::= OPTIONS_KEY$ option_list
            //
            case 29: {
                setResult(
                    new option_spec(getLeftIToken(), getRightIToken(),
                                    (optionList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 30:  option_list ::= option
            //
            case 30: {
                setResult(
                    new optionList((option)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 31:  option_list ::= option_list ,$ option
            //
            case 31: {
                ((optionList)getRhsSym(1)).add((option)getRhsSym(3));
                break;
            }
            //
            // Rule 32:  option ::= SYMBOL option_value
            //
            case 32: {
                setResult(
                    new option(getLeftIToken(), getRightIToken(),
                               new ASTNodeToken(getRhsIToken(1)),
                               (Ioption_value)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 33:  option_value ::= $Empty
            //
            case 33: {
                setResult(null);
                break;
            }
            //
            // Rule 34:  option_value ::= =$ SYMBOL
            //
            case 34: {
                setResult(
                    new option_value__EQUAL_SYMBOL(getLeftIToken(), getRightIToken(),
                                                   new ASTNodeToken(getRhsIToken(2)))
                );
                break;
            }
            //
            // Rule 35:  option_value ::= =$ ($ symbol_list )$
            //
            case 35: {
                setResult(
                    new option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN(getLeftIToken(), getRightIToken(),
                                                                               (SYMBOLList)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 36:  symbol_list ::= SYMBOL
            //
            case 36: {
                setResult(
                    new SYMBOLList(new ASTNodeToken(getRhsIToken(1)), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 37:  symbol_list ::= symbol_list ,$ SYMBOL
            //
            case 37: {
                ((SYMBOLList)getRhsSym(1)).add(new ASTNodeToken(getRhsIToken(3)));
                break;
            }
            //
            // Rule 38:  alias_segment ::= aliasSpec
            //
            case 38: {
                setResult(
                    new aliasSpecList((IaliasSpec)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 39:  alias_segment ::= alias_segment aliasSpec
            //
            case 39: {
                ((aliasSpecList)getRhsSym(1)).add((IaliasSpec)getRhsSym(2));
                break;
            }
            //
            // Rule 40:  aliasSpec ::= ERROR_KEY produces alias_rhs
            //
            case 40: {
                setResult(
                    new aliasSpec__ERROR_KEY_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                                new ASTNodeToken(getRhsIToken(1)),
                                                                (Iproduces)getRhsSym(2),
                                                                (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 41:  aliasSpec ::= EOL_KEY produces alias_rhs
            //
            case 41: {
                setResult(
                    new aliasSpec__EOL_KEY_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                              new ASTNodeToken(getRhsIToken(1)),
                                                              (Iproduces)getRhsSym(2),
                                                              (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 42:  aliasSpec ::= EOF_KEY produces alias_rhs
            //
            case 42: {
                setResult(
                    new aliasSpec__EOF_KEY_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                              new ASTNodeToken(getRhsIToken(1)),
                                                              (Iproduces)getRhsSym(2),
                                                              (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 43:  aliasSpec ::= IDENTIFIER_KEY produces alias_rhs
            //
            case 43: {
                setResult(
                    new aliasSpec__IDENTIFIER_KEY_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                                     new ASTNodeToken(getRhsIToken(1)),
                                                                     (Iproduces)getRhsSym(2),
                                                                     (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 44:  aliasSpec ::= SYMBOL produces alias_rhs
            //
            case 44: {
                setResult(
                    new aliasSpec__SYMBOL_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                             new ASTNodeToken(getRhsIToken(1)),
                                                             (Iproduces)getRhsSym(2),
                                                             (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 45:  aliasSpec ::= alias_lhs_macro_name produces alias_rhs
            //
            case 45: {
                setResult(
                    new aliasSpec__alias_lhs_macro_name_produces_alias_rhs(getLeftIToken(), getRightIToken(),
                                                                           (alias_lhs_macro_name)getRhsSym(1),
                                                                           (Iproduces)getRhsSym(2),
                                                                           (Ialias_rhs)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 46:  alias_lhs_macro_name ::= MACRO_NAME
            //
            case 46: {
                setResult(
                    new alias_lhs_macro_name(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 47:  alias_rhs ::= SYMBOL
            //
            case 47: {
                setResult(
                    new alias_rhs__SYMBOL(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 48:  alias_rhs ::= MACRO_NAME
            //
            case 48: {
                setResult(
                    new alias_rhs__MACRO_NAME(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 49:  alias_rhs ::= ERROR_KEY
            //
            case 49: {
                setResult(
                    new alias_rhs__ERROR_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 50:  alias_rhs ::= EOL_KEY
            //
            case 50: {
                setResult(
                    new alias_rhs__EOL_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 51:  alias_rhs ::= EOF_KEY
            //
            case 51: {
                setResult(
                    new alias_rhs__EOF_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 52:  alias_rhs ::= EMPTY_KEY
            //
            case 52: {
                setResult(
                    new alias_rhs__EMPTY_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 53:  alias_rhs ::= IDENTIFIER_KEY
            //
            case 53: {
                setResult(
                    new alias_rhs__IDENTIFIER_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 54:  ast_segment ::= action_segment_list
            //
            case 54:
                break;
            //
            // Rule 55:  define_segment ::= defineSpec
            //
            case 55: {
                setResult(
                    new defineSpecList((defineSpec)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 56:  define_segment ::= define_segment defineSpec
            //
            case 56: {
                ((defineSpecList)getRhsSym(1)).add((defineSpec)getRhsSym(2));
                break;
            }
            //
            // Rule 57:  defineSpec ::= macro_name_symbol macro_segment
            //
            case 57: {
                setResult(
                    new defineSpec(LPGParser.this, getLeftIToken(), getRightIToken(),
                                   (Imacro_name_symbol)getRhsSym(1),
                                   (macro_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 58:  macro_name_symbol ::= MACRO_NAME
            //
            case 58: {
                setResult(
                    new macro_name_symbol__MACRO_NAME(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 59:  macro_name_symbol ::= SYMBOL
            //
            case 59: {
                setResult(
                    new macro_name_symbol__SYMBOL(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 60:  macro_segment ::= BLOCK
            //
            case 60: {
                setResult(
                    new macro_segment(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 61:  eol_segment ::= terminal_symbol
            //
            case 61:
                break;
            //
            // Rule 62:  eof_segment ::= terminal_symbol
            //
            case 62:
                break;
            //
            // Rule 63:  error_segment ::= terminal_symbol
            //
            case 63:
                break;
            //
            // Rule 64:  export_segment ::= terminal_symbol
            //
            case 64: {
                setResult(
                    new terminal_symbolList((Iterminal_symbol)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 65:  export_segment ::= export_segment terminal_symbol
            //
            case 65: {
                ((terminal_symbolList)getRhsSym(1)).add((Iterminal_symbol)getRhsSym(2));
                break;
            }
            //
            // Rule 66:  globals_segment ::= action_segment
            //
            case 66: {
                setResult(
                    new action_segmentList((action_segment)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 67:  globals_segment ::= globals_segment action_segment
            //
            case 67: {
                ((action_segmentList)getRhsSym(1)).add((action_segment)getRhsSym(2));
                break;
            }
            //
            // Rule 68:  headers_segment ::= action_segment_list
            //
            case 68:
                break;
            //
            // Rule 69:  identifier_segment ::= terminal_symbol
            //
            case 69:
                break;
            //
            // Rule 70:  import_segment ::= SYMBOL drop_command_list
            //
            case 70: {
                setResult(
                    new import_segment(getLeftIToken(), getRightIToken(),
                                       new ASTNodeToken(getRhsIToken(1)),
                                       (drop_commandList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 71:  drop_command_list ::= $Empty
            //
            case 71: {
                setResult(
                    new drop_commandList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 72:  drop_command_list ::= drop_command_list drop_command
            //
            case 72: {
                ((drop_commandList)getRhsSym(1)).add((Idrop_command)getRhsSym(2));
                break;
            }
            //
            // Rule 73:  drop_command ::= DROPSYMBOLS_KEY drop_symbols
            //
            case 73: {
                setResult(
                    new drop_command__DROPSYMBOLS_KEY_drop_symbols(getLeftIToken(), getRightIToken(),
                                                                   new ASTNodeToken(getRhsIToken(1)),
                                                                   (SYMBOLList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 74:  drop_command ::= DROPRULES_KEY drop_rules
            //
            case 74: {
                setResult(
                    new drop_command__DROPRULES_KEY_drop_rules(getLeftIToken(), getRightIToken(),
                                                               new ASTNodeToken(getRhsIToken(1)),
                                                               (drop_ruleList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 75:  drop_symbols ::= SYMBOL
            //
            case 75: {
                setResult(
                    new SYMBOLList(new ASTNodeToken(getRhsIToken(1)), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 76:  drop_symbols ::= drop_symbols SYMBOL
            //
            case 76: {
                ((SYMBOLList)getRhsSym(1)).add(new ASTNodeToken(getRhsIToken(2)));
                break;
            }
            //
            // Rule 77:  drop_rules ::= drop_rule
            //
            case 77: {
                setResult(
                    new drop_ruleList((drop_rule)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 78:  drop_rules ::= drop_rules drop_rule
            //
            case 78: {
                ((drop_ruleList)getRhsSym(1)).add((drop_rule)getRhsSym(2));
                break;
            }
            //
            // Rule 79:  drop_rule ::= SYMBOL optMacroName produces ruleList
            //
            case 79: {
                setResult(
                    new drop_rule(getLeftIToken(), getRightIToken(),
                                  new ASTNodeToken(getRhsIToken(1)),
                                  (optMacroName)getRhsSym(2),
                                  (Iproduces)getRhsSym(3),
                                  (ruleList)getRhsSym(4))
                );
                break;
            }
            //
            // Rule 80:  optMacroName ::= $Empty
            //
            case 80: {
                setResult(null);
                break;
            }
            //
            // Rule 81:  optMacroName ::= MACRO_NAME
            //
            case 81: {
                setResult(
                    new optMacroName(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 82:  include_segment ::= SYMBOL
            //
            case 82: {
                setResult(
                    new include_segment(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 83:  keywords_segment ::= keywordSpec
            //
            case 83: {
                setResult(
                    new keywordSpecList((IkeywordSpec)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 84:  keywords_segment ::= keywords_segment keywordSpec
            //
            case 84: {
                ((keywordSpecList)getRhsSym(1)).add((IkeywordSpec)getRhsSym(2));
                break;
            }
            //
            // Rule 85:  keywordSpec ::= terminal_symbol
            //
            case 85:
                break;
            //
            // Rule 86:  keywordSpec ::= terminal_symbol produces name
            //
            case 86: {
                setResult(
                    new keywordSpec(getLeftIToken(), getRightIToken(),
                                    (Iterminal_symbol)getRhsSym(1),
                                    (Iproduces)getRhsSym(2),
                                    (Iname)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 87:  names_segment ::= nameSpec
            //
            case 87: {
                setResult(
                    new nameSpecList((nameSpec)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 88:  names_segment ::= names_segment nameSpec
            //
            case 88: {
                ((nameSpecList)getRhsSym(1)).add((nameSpec)getRhsSym(2));
                break;
            }
            //
            // Rule 89:  nameSpec ::= name produces name
            //
            case 89: {
                setResult(
                    new nameSpec(getLeftIToken(), getRightIToken(),
                                 (Iname)getRhsSym(1),
                                 (Iproduces)getRhsSym(2),
                                 (Iname)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 90:  name ::= SYMBOL
            //
            case 90: {
                setResult(
                    new name__SYMBOL(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 91:  name ::= MACRO_NAME
            //
            case 91: {
                setResult(
                    new name__MACRO_NAME(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 92:  name ::= EMPTY_KEY
            //
            case 92: {
                setResult(
                    new name__EMPTY_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 93:  name ::= ERROR_KEY
            //
            case 93: {
                setResult(
                    new name__ERROR_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 94:  name ::= EOL_KEY
            //
            case 94: {
                setResult(
                    new name__EOL_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 95:  name ::= IDENTIFIER_KEY
            //
            case 95: {
                setResult(
                    new name__IDENTIFIER_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 96:  notice_segment ::= action_segment
            //
            case 96: {
                setResult(
                    new action_segmentList((action_segment)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 97:  notice_segment ::= notice_segment action_segment
            //
            case 97: {
                ((action_segmentList)getRhsSym(1)).add((action_segment)getRhsSym(2));
                break;
            }
            //
            // Rule 98:  rules_segment ::= action_segment_list nonTermList
            //
            case 98: {
                setResult(
                    new rules_segment(getLeftIToken(), getRightIToken(),
                                      (action_segmentList)getRhsSym(1),
                                      (nonTermList)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 99:  nonTermList ::= $Empty
            //
            case 99: {
                setResult(
                    new nonTermList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 100:  nonTermList ::= nonTermList nonTerm
            //
            case 100: {
                ((nonTermList)getRhsSym(1)).add((nonTerm)getRhsSym(2));
                break;
            }
            //
            // Rule 101:  nonTerm ::= ruleNameWithAttributes produces ruleList
            //
            case 101: {
                setResult(
                    new nonTerm(LPGParser.this, getLeftIToken(), getRightIToken(),
                                (RuleName)getRhsSym(1),
                                (Iproduces)getRhsSym(2),
                                (ruleList)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 102:  ruleNameWithAttributes ::= SYMBOL
            //
            case 102: {
                setResult(
                    new RuleName(getLeftIToken(), getRightIToken(),
                                 new ASTNodeToken(getRhsIToken(1)),
                                 (ASTNodeToken)null,
                                 (ASTNodeToken)null)
                );
                break;
            }
            //
            // Rule 103:  ruleNameWithAttributes ::= SYMBOL MACRO_NAME$className
            //
            case 103: {
                setResult(
                    new RuleName(getLeftIToken(), getRightIToken(),
                                 new ASTNodeToken(getRhsIToken(1)),
                                 new ASTNodeToken(getRhsIToken(2)),
                                 (ASTNodeToken)null)
                );
                break;
            }
            //
            // Rule 104:  ruleNameWithAttributes ::= SYMBOL MACRO_NAME$className MACRO_NAME$arrayElement
            //
            case 104: {
                setResult(
                    new RuleName(getLeftIToken(), getRightIToken(),
                                 new ASTNodeToken(getRhsIToken(1)),
                                 new ASTNodeToken(getRhsIToken(2)),
                                 new ASTNodeToken(getRhsIToken(3)))
                );
                break;
            }
            //
            // Rule 105:  ruleList ::= rule
            //
            case 105: {
                setResult(
                    new ruleList((rule)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 106:  ruleList ::= ruleList |$ rule
            //
            case 106: {
                ((ruleList)getRhsSym(1)).add((rule)getRhsSym(3));
                break;
            }
            //
            // Rule 107:  produces ::= ::=
            //
            case 107: {
                setResult(
                    new produces__EQUIVALENCE(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 108:  produces ::= ::=?
            //
            case 108: {
                setResult(
                    new produces__PRIORITY_EQUIVALENCE(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 109:  produces ::= ->
            //
            case 109: {
                setResult(
                    new produces__ARROW(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 110:  produces ::= ->?
            //
            case 110: {
                setResult(
                    new produces__PRIORITY_ARROW(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 111:  rule ::= symWithAttrsList opt_action_segment
            //
            case 111: {
                setResult(
                    new rule(getLeftIToken(), getRightIToken(),
                             (symWithAttrsList)getRhsSym(1),
                             (action_segment)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 112:  symWithAttrsList ::= $Empty
            //
            case 112: {
                setResult(
                    new symWithAttrsList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 113:  symWithAttrsList ::= symWithAttrsList symWithAttrs
            //
            case 113: {
                ((symWithAttrsList)getRhsSym(1)).add((IsymWithAttrs)getRhsSym(2));
                break;
            }
            //
            // Rule 114:  symWithAttrs ::= EMPTY_KEY
            //
            case 114: {
                setResult(
                    new symWithAttrs__EMPTY_KEY(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 115:  symWithAttrs ::= SYMBOL optAttrList
            //
            case 115: {
                setResult(
                    new symWithAttrs__SYMBOL_optAttrList(getLeftIToken(), getRightIToken(),
                                                         new ASTNodeToken(getRhsIToken(1)),
                                                         (symAttrs)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 116:  optAttrList ::= $Empty
            //
            case 116: {
                setResult(
                    new symAttrs(getLeftIToken(), getRightIToken(),
                                 (ASTNodeToken)null)
                );
                break;
            }
            //
            // Rule 117:  optAttrList ::= MACRO_NAME
            //
            case 117: {
                setResult(
                    new symAttrs(getLeftIToken(), getRightIToken(),
                                 new ASTNodeToken(getRhsIToken(1)))
                );
                break;
            }
            //
            // Rule 118:  opt_action_segment ::= $Empty
            //
            case 118: {
                setResult(null);
                break;
            }
            //
            // Rule 119:  opt_action_segment ::= action_segment
            //
            case 119:
                break;
            //
            // Rule 120:  action_segment ::= BLOCK
            //
            case 120: {
                setResult(
                    new action_segment(LPGParser.this, getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 121:  start_segment ::= start_symbol
            //
            case 121: {
                setResult(
                    new start_symbolList((Istart_symbol)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 122:  start_segment ::= start_segment start_symbol
            //
            case 122: {
                ((start_symbolList)getRhsSym(1)).add((Istart_symbol)getRhsSym(2));
                break;
            }
            //
            // Rule 123:  start_symbol ::= SYMBOL
            //
            case 123: {
                setResult(
                    new start_symbol__SYMBOL(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 124:  start_symbol ::= MACRO_NAME
            //
            case 124: {
                setResult(
                    new start_symbol__MACRO_NAME(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 125:  terminals_segment ::= terminal
            //
            case 125: {
                setResult(
                    new terminalList((terminal)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 126:  terminals_segment ::= terminals_segment terminal
            //
            case 126: {
                ((terminalList)getRhsSym(1)).add((terminal)getRhsSym(2));
                break;
            }
            //
            // Rule 127:  terminal ::= terminal_symbol optTerminalAlias
            //
            case 127: {
                setResult(
                    new terminal(LPGParser.this, getLeftIToken(), getRightIToken(),
                                 (Iterminal_symbol)getRhsSym(1),
                                 (optTerminalAlias)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 128:  optTerminalAlias ::= $Empty
            //
            case 128: {
                setResult(null);
                break;
            }
            //
            // Rule 129:  optTerminalAlias ::= produces name
            //
            case 129: {
                setResult(
                    new optTerminalAlias(getLeftIToken(), getRightIToken(),
                                         (Iproduces)getRhsSym(1),
                                         (Iname)getRhsSym(2))
                );
                break;
            }
            //
            // Rule 130:  terminal_symbol ::= SYMBOL
            //
            case 130: {
                setResult(
                    new terminal_symbol__SYMBOL(LPGParser.this, getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 131:  terminal_symbol ::= MACRO_NAME
            //
            case 131: {
                setResult(
                    new terminal_symbol__MACRO_NAME(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 132:  trailers_segment ::= action_segment_list
            //
            case 132:
                break;
            //
            // Rule 133:  types_segment ::= type_declarations
            //
            case 133: {
                setResult(
                    new type_declarationsList((type_declarations)getRhsSym(1), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 134:  types_segment ::= types_segment type_declarations
            //
            case 134: {
                ((type_declarationsList)getRhsSym(1)).add((type_declarations)getRhsSym(2));
                break;
            }
            //
            // Rule 135:  type_declarations ::= SYMBOL produces barSymbolList
            //
            case 135: {
                setResult(
                    new type_declarations(getLeftIToken(), getRightIToken(),
                                          new ASTNodeToken(getRhsIToken(1)),
                                          (Iproduces)getRhsSym(2),
                                          (SYMBOLList)getRhsSym(3))
                );
                break;
            }
            //
            // Rule 136:  barSymbolList ::= SYMBOL
            //
            case 136: {
                setResult(
                    new SYMBOLList(new ASTNodeToken(getRhsIToken(1)), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 137:  barSymbolList ::= barSymbolList |$ SYMBOL
            //
            case 137: {
                ((SYMBOLList)getRhsSym(1)).add(new ASTNodeToken(getRhsIToken(3)));
                break;
            }
            //
            // Rule 138:  predecessor_segment ::= $Empty
            //
            case 138: {
                setResult(
                    new symbol_pairList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 139:  predecessor_segment ::= predecessor_segment symbol_pair
            //
            case 139: {
                ((symbol_pairList)getRhsSym(1)).add((symbol_pair)getRhsSym(2));
                break;
            }
            //
            // Rule 140:  symbol_pair ::= SYMBOL SYMBOL
            //
            case 140: {
                setResult(
                    new symbol_pair(getLeftIToken(), getRightIToken(),
                                    new ASTNodeToken(getRhsIToken(1)),
                                    new ASTNodeToken(getRhsIToken(2)))
                );
                break;
            }
            //
            // Rule 141:  recover_segment ::= $Empty
            //
            case 141: {
                setResult(
                    new SYMBOLList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 142:  recover_segment ::= recover_segment recover_symbol
            //
            case 142: {
                setResult((SYMBOLList)getRhsSym(1));
                break;
            }
            //
            // Rule 143:  recover_symbol ::= SYMBOL
            //
            case 143: {
                setResult(
                    new recover_symbol(LPGParser.this, getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 144:  END_KEY_OPT ::= $Empty
            //
            case 144: {
                setResult(null);
                break;
            }
            //
            // Rule 145:  END_KEY_OPT ::= END_KEY
            //
            case 145: {
                setResult(
                    new END_KEY_OPT(getRhsIToken(1))
                );
                break;
            }
            //
            // Rule 146:  action_segment_list ::= $Empty
            //
            case 146: {
                setResult(
                    new action_segmentList(getLeftIToken(), getRightIToken(), true /* left recursive */)
                );
                break;
            }
            //
            // Rule 147:  action_segment_list ::= action_segment_list action_segment
            //
            case 147: {
                ((action_segmentList)getRhsSym(1)).add((action_segment)getRhsSym(2));
                break;
            }
    
            default:
                break;
        }
        return;
    }
}

