/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class MakeEmptyRefactoring
extends Refactoring {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;

    public MakeEmptyRefactoring(UniversalEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fNode = null;
        }
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        LPGParser.ASTNode root = (LPGParser.ASTNode)parseController.getCurrentAst();
        ISourcePositionLocator locator = parseController.getSourcePositionLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)root, sel.x);
    }

    public String getName() {
        return "Make Empty";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!(this.fNode instanceof LPGParser.nonTerm)) {
            return RefactoringStatus.createFatalErrorStatus((String)"Make Empty is only valid for non-terminals");
        }
        LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
        LPGParser.ruleList rhSides = nt.getruleList();
        if (rhSides.size() != 2) {
            return RefactoringStatus.createFatalErrorStatus((String)"Make Empty is only valid for non-terminals with 2 productions");
        }
        LPGParser.rule rhs1 = (LPGParser.rule)rhSides.getElementAt(0);
        LPGParser.rule rhs2 = (LPGParser.rule)rhSides.getElementAt(1);
        LPGParser.symWithAttrsList rhs1Syms = rhs1.getsymWithAttrsList();
        LPGParser.symWithAttrsList rhs2Syms = rhs2.getsymWithAttrsList();
        if (rhs1Syms.size() == rhs2Syms.size() + 1) {
            LPGParser.rule tmp = rhs1;
            LPGParser.symWithAttrsList tmpList = rhs1Syms;
            rhs1 = rhs2;
            rhs2 = tmp;
            rhs1Syms = rhs2Syms;
            rhs2Syms = tmpList;
        }
        for (int i = 0; i < rhs1Syms.size(); ++i) {
            if (rhs1Syms.getElementAt(i).toString().equals(rhs2Syms.getElementAt(i + 1).toString())) continue;
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= b c ... | a b c ...'");
        }
        if (!rhs2Syms.getElementAt(0).toString().equals(nt.getruleNameWithAttributes().getSYMBOL().toString())) {
            return RefactoringStatus.createFatalErrorStatus((String)"Non-terminal must have the form 'a ::= b c ... | a b c ...'");
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        LPGParser.nonTerm nt = (LPGParser.nonTerm)this.fNode;
        LPGParser.ruleList rhSides = nt.getruleList();
        LPGParser.rule rhs1 = (LPGParser.rule)rhSides.getElementAt(0);
        LPGParser.rule rhs2 = (LPGParser.rule)rhSides.getElementAt(1);
        LPGParser.symWithAttrsList rhs1Syms = rhs1.getsymWithAttrsList();
        LPGParser.symWithAttrsList rhs2Syms = rhs2.getsymWithAttrsList();
        int N = rhs1Syms.size();
        if (rhs1Syms.size() == rhs2Syms.size() + 1) {
            LPGParser.rule tmp = rhs1;
            LPGParser.symWithAttrsList tmpList = rhs1Syms;
            rhs1 = rhs2;
            rhs2 = tmp;
            rhs1Syms = rhs2Syms;
            rhs2Syms = tmpList;
        }
        int startOffset = rhs1Syms.getElementAt(0).getLeftIToken().getStartOffset();
        int endOffset = rhs1Syms.getElementAt(N - 1).getLeftIToken().getEndOffset();
        TextFileChange tfc = new TextFileChange("Make Empty", this.fGrammarFile);
        tfc.setEdit((TextEdit)new MultiTextEdit());
        tfc.addEdit((TextEdit)new ReplaceEdit(startOffset, endOffset - startOffset + 1, "$empty"));
        return tfc;
    }
}

