/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.compare;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.imp.lpg.compare.ASTLabelProvider;
import org.eclipse.imp.lpg.compare.GetChildrenVisitor;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;

public class LPGStructureNode
extends DocumentRangeNode
implements ITypedElement {
    public static final int OPTION = 0;
    public static final int BODY = 1;
    public static final int ACTION = 2;
    public static final int TERMINAL = 3;
    public static final int RULE = 4;
    public static final int GLOBAL = 5;
    public static final int HEADER = 6;
    public static final int DEFINE = 7;
    public static final int IMPORT = 8;
    public static final int INCLUDE = 9;
    public static final int ALIAS = 10;
    public static final int NONTERMINAL = 11;
    private static final char OPTION_PREFIX = 'O';
    private static final char BODY_PREFIX = 'B';
    private static final char ACTION_PREFIX = 'A';
    private static final char TERMINAL_PREFIX = 'T';
    private static final char RULE_PREFIX = 'R';
    private static final char GLOBAL_PREFIX = 'G';
    private static final char HEADER_PREFIX = 'H';
    private static final char DEFINE_PREFIX = 'D';
    private static final char IMPORT_PREFIX = 'M';
    private static final char INCLUDE_PREFIX = 'I';
    private static final char ALIAS_PREFIX = 'L';
    private static final char NONTERMINAL_PREFIX = 'N';
    private LPGParser.ASTNode fASTNode;

    public LPGStructureNode(LPGParser.ASTNode root, IDocument document, int typeCode, String name) {
        super(typeCode, LPGStructureNode.buildIDFor(typeCode, name), document, LPGStructureNode.offsetOf(root), LPGStructureNode.lengthOf(root, document));
        this.fASTNode = root;
    }

    public LPGStructureNode(LPGParser.ASTNode node, LPGStructureNode parent, int typeCode, String name) {
        super(typeCode, LPGStructureNode.buildIDFor(typeCode, name), parent.getDocument(), LPGStructureNode.offsetOf(node), LPGStructureNode.lengthOf(node, parent.getDocument()));
        this.fASTNode = node;
    }

    private static int offsetOf(LPGParser.ASTNode n) {
        return n != null ? n.getLeftIToken().getStartOffset() : 0;
    }

    private static int lengthOf(LPGParser.ASTNode n, IDocument doc) {
        return n != null ? n.getRightIToken().getEndOffset() - n.getLeftIToken().getStartOffset() + 1 : doc.getLength();
    }

    private static String buildIDFor(int typeCode, String name) {
        switch (typeCode) {
            case 0: {
                return 'O' + name;
            }
            case 1: {
                return 'B' + name;
            }
            case 2: {
                return 'A' + name;
            }
            case 3: {
                return 'T' + name;
            }
            case 4: {
                return 'R' + name;
            }
            case 5: {
                return 'G' + name;
            }
            case 6: {
                return 'H' + name;
            }
            case 7: {
                return 'D' + name;
            }
            case 8: {
                return 'M' + name;
            }
            case 9: {
                return 'I' + name;
            }
            case 10: {
                return 'L' + name;
            }
            case 11: {
                return 'N' + name;
            }
        }
        return "???";
    }

    public LPGParser.ASTNode getASTNode() {
        return this.fASTNode;
    }

    public String getName() {
        return ASTLabelProvider.getLabelFor(this.fASTNode);
    }

    public Image getImage() {
        return ASTLabelProvider.getImageFor(this.fASTNode);
    }

    public String getType() {
        return "jikespg";
    }

    public Object[] getChildren() {
        if (this.fASTNode == null) {
            return new Object[0];
        }
        GetChildrenVisitor v = new GetChildrenVisitor(this);
        this.fASTNode.accept(v);
        return v.getChildren();
    }

    public String toString() {
        return this.fASTNode.toString();
    }
}

