
Predefined Macros:

    $rule_number
    $rule_text
    $rule_size
    $input_file
    $current_line
    $next_line
    $#identifier
    $symbol_declarations
    $num_rules
    $num_terminals
    $num_nonterminals
    $num_non_terminals
    $num_symbols
    $template
    $file_prefix
    $package
    $ast_package
    $ast_type
    $exp_type
    $prs_type
    $sym_type
    $action_type
    $visitor_type
    $prefix
    $suffix
    $entry_name
    $entry_marker



Defined Symbols:



    $Header
    /.
                    //
                    // Rule $rule_number:  $rule_text
                    //
                    ./


    $BeginAction
    /.$Header$case $rule_number: {
                       //#line $next_line "$input_file$"./


    $EndAction
    /.                break;
                    }./


    $BeginJava
    /.$BeginAction
                        $symbol_declarations
                        //#line $next_line "$input_file$"./


    $EndJava
    /.$EndAction./


    $NoAction
    /.$Header$case $rule_number:
                        break;./


    $BadAction
    /.$Header$case $rule_number:
                        throw new Error("No action specified for rule " + $rule_number);./


    $NullAction
    /.$Header$case $rule_number:
                        setResult(null);
                        break;./


    $BeginActions
    /.
            public void ruleAction(int ruleNumber)
            {
                switch (ruleNumber)
                {./


    $SplitActions
    /.
    	            default:
    	                ruleAction$rule_number(ruleNumber);
    	                break;
    	        }
    	        return;
    	    }
    	
    	    public void ruleAction$rule_number(int ruleNumber)
    	    {
    	        switch (ruleNumber)
    	        {
                    //#line $next_line "$input_file$"./


    $EndActions
    /.
                    default:
                        break;
                }
                return;
            }./


    $entry_declarations
    /.
            public $ast_class parse$entry_name()
            {
                return parse$entry_name(null, 0);
            }
                
            public $ast_class parse$entry_name(Monitor monitor)
            {
                return parse$entry_name(monitor, 0);
            }
                
            public $ast_class parse$entry_name(int error_repair_count)
            {
                return parse$entry_name(null, error_repair_count);
            }
                
            public $ast_class parse$entry_name(Monitor monitor, int error_repair_count)
            {
                btParser.setMonitor(monitor);
                
                try
                {
                    return ($ast_class) btParser.fuzzyParseEntry($sym_type.$entry_marker, error_repair_count);
                }
                catch (BadParseException e)
                {
                    prsStream.reset(e.error_token); // point to error token
    
                    DiagnoseParser diagnoseParser = new DiagnoseParser(prsStream, prsTable);
                    diagnoseParser.diagnoseEntry($sym_type.$entry_marker, e.error_token);
                }
    
                return null;
            }
        ./


    $additional_interfaces
    /../


    $ast_class
    /.$ast_type./


    $unimplemented_symbols_warning
    /.false./


    $setSym1
    /. // macro setSym1 is deprecated. Use function setResult
                    getParser().setSym1./


    $setResult
    /. // macro setResult is deprecated. Use function setResult
                     getParser().setSym1./


    $getSym
    /. // macro getSym is deprecated. Use function getRhsSym
                  getParser().getSym./


    $getToken
    /. // macro getToken is deprecated. Use function getRhsTokenIndex
                    getParser().getToken./


    $getIToken
    /. // macro getIToken is deprecated. Use function getRhsIToken
                     prsStream.getIToken./


    $getLeftSpan
    /. // macro getLeftSpan is deprecated. Use function getLeftSpan
                       getParser().getFirstToken./


    $getRightSpan
    /. // macro getRightSpan is deprecated. Use function getRightSpan
                        getParser().getLastToken./


Aliases:

    ,opt ::= Commaopt
    ...opt ::= Ellipsisopt
    '--' ::= MINUS_MINUS
    '|' ::= OR
    - ::= MINUS
    -= ::= MINUS_EQUAL
    ! ::= NOT
    != ::= NOT_EQUAL
    '%' ::= REMAINDER
    '%=' ::= REMAINDER_EQUAL
    & ::= AND
    && ::= AND_AND
    &= ::= AND_EQUAL
    ( ::= LPAREN
    ) ::= RPAREN
    * ::= MULTIPLY
    *= ::= MULTIPLY_EQUAL
    , ::= COMMA
    . ::= DOT
    / ::= DIVIDE
    /= ::= DIVIDE_EQUAL
    : ::= COLON
    ; ::= SEMICOLON
    ? ::= QUESTION
    @ ::= AT
    [ ::= LBRACKET
    ] ::= RBRACKET
    ^ ::= XOR
    ^= ::= XOR_EQUAL
    { ::= LBRACE
    || ::= OR_OR
    |= ::= OR_EQUAL
    } ::= RBRACE
    ~ ::= TWIDDLE
    + ::= PLUS
    ++ ::= PLUS_PLUS
    += ::= PLUS_EQUAL
    < ::= LESS
    << ::= LEFT_SHIFT
    <<= ::= LEFT_SHIFT_EQUAL
    <= ::= LESS_EQUAL
    = ::= EQUAL
    == ::= EQUAL_EQUAL
    > ::= GREATER
    >= ::= GREATER_EQUAL
    >> ::= RIGHT_SHIFT
    >>= ::= RIGHT_SHIFT_EQUAL
    >>> ::= UNSIGNED_RIGHT_SHIFT
    >>>= ::= UNSIGNED_RIGHT_SHIFT_EQUAL
    ... ::= ELLIPSIS
    '$BeginAction' ::= BeginAction
    '$EndAction' ::= EndAction
    '$BeginJava' ::= BeginJava
    '$EndJava' ::= EndJava
    '$NoAction' ::= NoAction
    '$NullAction' ::= NullAction
    '$BadAction' ::= BadAction


Start:

    CompilationUnit    ClassBodyDeclarationsopt    LPGUserAction

Identifier:

    IDENTIFIER

Eof:

    EOF_TOKEN

Error:

    ERROR_TOKEN

Terminals:

    ClassBodyDeclarationsoptMarker
    LPGUserActionMarker
    IntegerLiteral
    LongLiteral
    FloatingPointLiteral
    DoubleLiteral
    CharacterLiteral
    StringLiteral
    MINUS_MINUS
    OR
    MINUS
    MINUS_EQUAL
    NOT
    NOT_EQUAL
    REMAINDER
    REMAINDER_EQUAL
    AND
    AND_AND
    AND_EQUAL
    LPAREN
    RPAREN
    MULTIPLY
    MULTIPLY_EQUAL
    COMMA
    DOT
    DIVIDE
    DIVIDE_EQUAL
    COLON
    SEMICOLON
    QUESTION
    AT
    LBRACKET
    RBRACKET
    XOR
    XOR_EQUAL
    LBRACE
    OR_OR
    OR_EQUAL
    RBRACE
    TWIDDLE
    PLUS
    PLUS_PLUS
    PLUS_EQUAL
    LESS
    LEFT_SHIFT
    LEFT_SHIFT_EQUAL
    LESS_EQUAL
    EQUAL
    EQUAL_EQUAL
    GREATER
    GREATER_EQUAL
    RIGHT_SHIFT
    RIGHT_SHIFT_EQUAL
    UNSIGNED_RIGHT_SHIFT
    UNSIGNED_RIGHT_SHIFT_EQUAL
    ELLIPSIS
    BeginAction
    EndAction
    BeginJava
    EndJava
    NoAction
    NullAction
    BadAction
    const
    goto
    EOF_TOKEN
    IDENTIFIER
    ERROR_TOKEN


Soft Keywords:

    abstract
    assert
    boolean
    break
    byte
    case
    catch
    char
    class
    continue
    default
    do
    double
    enum
    else
    extends
    false
    final
    finally
    float
    for
    if
    implements
    import
    instanceof
    int
    interface
    long
    native
    new
    null
    package
    private
    protected
    public
    return
    short
    static
    strictfp
    super
    switch
    synchronized
    this
    throw
    throws
    transient
    true
    try
    void
    volatile
    while


Rules:

0      '$accept' ::= CompilationUnit
1      CompilationUnit ::= ClassBodyDeclarationsoptMarker ClassBodyDeclarationsopt
2                        | LPGUserActionMarker LPGUserAction

3      identifier ::= IDENTIFIER
4      LPGUserAction ::= BlockStatementsopt
5                      | '$BeginAction' BlockStatementsopt '$EndAction'
6                      | '$BeginJava' BlockStatementsopt '$EndJava'
7                      | '$NoAction'
8                      | '$NullAction'
9                      | '$BadAction'
10     Type ::= PrimitiveType
11            | ReferenceType
12     PrimitiveType ::= NumericType
13                     | boolean
14     NumericType ::= IntegralType
15                   | FloatingPointType
16     IntegralType ::= byte
17                    | short
18                    | int
19                    | long
20                    | char
21     FloatingPointType ::= float
22                         | double
23     ReferenceType ::= ClassOrInterfaceType
24                     | TypeVariable
25                     | ArrayType
26     ClassOrInterfaceType ::= ClassType
27     ClassType ::= TypeName TypeArgumentsopt
28     InterfaceType ::= TypeName TypeArgumentsopt
29     TypeName ::= identifier
30                | TypeName . identifier
31     ClassName ::= TypeName
32     TypeVariable ::= identifier
33     ArrayType ::= Type [ ]
34     TypeParameter ::= TypeVariable TypeBoundopt
35     TypeBound ::= extends ClassOrInterfaceType AdditionalBoundListopt
36     AdditionalBoundList ::= AdditionalBound
37                           | AdditionalBoundList AdditionalBound
38     AdditionalBound ::= & InterfaceType
39     TypeArguments ::= < ActualTypeArgumentList >
40     ActualTypeArgumentList ::= ActualTypeArgument
41                              | ActualTypeArgumentList , ActualTypeArgument
42     ActualTypeArgument ::= ReferenceType
43                          | Wildcard
44     Wildcard ::= ? WildcardBoundsOpt
45     WildcardBounds ::= extends ReferenceType
46                      | super ReferenceType
47     PackageName ::= identifier
48                   | PackageName . identifier
49     ExpressionName ::= identifier
50                      | AmbiguousName . identifier
51     MethodName ::= identifier
52                  | AmbiguousName . identifier
53     PackageOrTypeName ::= identifier
54                         | PackageOrTypeName . identifier
55     AmbiguousName ::= identifier
56                     | AmbiguousName . identifier
57     CompilationUnit ::= PackageDeclarationopt ImportDeclarationsopt TypeDeclarationsopt
58     ImportDeclarations ::= ImportDeclaration
59                          | ImportDeclarations ImportDeclaration
60     TypeDeclarations ::= TypeDeclaration
61                        | TypeDeclarations TypeDeclaration
62     PackageDeclaration ::= Annotationsopt package PackageName ;
63     ImportDeclaration ::= SingleTypeImportDeclaration
64                         | TypeImportOnDemandDeclaration
65                         | SingleStaticImportDeclaration
66                         | StaticImportOnDemandDeclaration
67     SingleTypeImportDeclaration ::= import TypeName ;
68     TypeImportOnDemandDeclaration ::= import PackageOrTypeName . * ;
69     SingleStaticImportDeclaration ::= import static TypeName . identifier ;
70     StaticImportOnDemandDeclaration ::= import static TypeName . * ;
71     TypeDeclaration ::= ClassDeclaration
72                       | InterfaceDeclaration
73                       | ;
74     ClassDeclaration ::= NormalClassDeclaration
75                        | EnumDeclaration
76     NormalClassDeclaration ::= ClassModifiersopt class identifier TypeParametersopt Superopt Interfacesopt ClassBody
77     ClassModifiers ::= ClassModifier
78                      | ClassModifiers ClassModifier
79     ClassModifier ::= Annotation
80                     | public
81                     | protected
82                     | private
83                     | abstract
84                     | static
85                     | final
86                     | strictfp
87     TypeParameters ::= < TypeParameterList >
88     TypeParameterList ::= TypeParameter
89                         | TypeParameterList , TypeParameter
90     Super ::= extends ClassType
91     Interfaces ::= implements InterfaceTypeList
92     InterfaceTypeList ::= InterfaceType
93                         | InterfaceTypeList , InterfaceType
94     ClassBody ::= { ClassBodyDeclarationsopt }
95     ClassBodyDeclarations ::= ClassBodyDeclaration
96                             | ClassBodyDeclarations ClassBodyDeclaration
97     ClassBodyDeclaration ::= ClassMemberDeclaration
98                            | InstanceInitializer
99                            | StaticInitializer
100                           | ConstructorDeclaration
101    ClassMemberDeclaration ::= FieldDeclaration
102                             | MethodDeclaration
103                             | ClassDeclaration
104                             | InterfaceDeclaration
105                             | ;
106    FieldDeclaration ::= FieldModifiersopt Type VariableDeclarators ;
107    VariableDeclarators ::= VariableDeclarator
108                          | VariableDeclarators , VariableDeclarator
109    VariableDeclarator ::= VariableDeclaratorId
110                         | VariableDeclaratorId = VariableInitializer
111    VariableDeclaratorId ::= identifier
112                           | VariableDeclaratorId [ ]
113    VariableInitializer ::= Expression
114                          | ArrayInitializer
115    FieldModifiers ::= FieldModifier
116                     | FieldModifiers FieldModifier
117    FieldModifier ::= Annotation
118                    | public
119                    | protected
120                    | private
121                    | static
122                    | final
123                    | transient
124                    | volatile
125    MethodDeclaration ::= MethodHeader MethodBody
126    MethodHeader ::= MethodModifiersopt TypeParametersopt ResultType MethodDeclarator Throwsopt
127    ResultType ::= Type
128                 | void
129    MethodDeclarator ::= identifier ( FormalParameterListopt )
130    MethodDeclarator ::= MethodDeclarator [ ]
131    FormalParameterList ::= LastFormalParameter
132                          | FormalParameters , LastFormalParameter
133    FormalParameters ::= FormalParameter
134                       | FormalParameters , FormalParameter
135    FormalParameter ::= VariableModifiersopt Type VariableDeclaratorId
136    VariableModifiers ::= VariableModifier
137                        | VariableModifiers VariableModifier
138    VariableModifier ::= final
139                       | Annotations
140    LastFormalParameter ::= VariableModifiersopt Type ...opt VariableDeclaratorId
141    MethodModifiers ::= MethodModifier
142                      | MethodModifiers MethodModifier
143    MethodModifier ::= Annotations
144                     | public
145                     | protected
146                     | private
147                     | abstract
148                     | static
149                     | final
150                     | synchronized
151                     | native
152                     | strictfp
153    Throws ::= throws ExceptionTypeList
154    ExceptionTypeList ::= ExceptionType
155                        | ExceptionTypeList , ExceptionType
156    ExceptionType ::= ClassType
157                    | TypeVariable
158    MethodBody ::= Block
159                 | ;
160    InstanceInitializer ::= Block
161    StaticInitializer ::= static Block
162    ConstructorDeclaration ::= ConstructorModifiersopt ConstructorDeclarator Throwsopt ConstructorBody
163    ConstructorDeclarator ::= TypeParametersopt SimpleTypeName ( FormalParameterListopt )
164    SimpleTypeName ::= identifier
165    ConstructorModifiers ::= ConstructorModifier
166                           | ConstructorModifiers ConstructorModifier
167    ConstructorModifier ::= Annotations
168                          | public
169                          | protected
170                          | private
171    ConstructorBody ::= { ExplicitConstructorInvocationopt BlockStatementsopt }
172    ExplicitConstructorInvocation ::= TypeArgumentsopt this ( ArgumentListopt ) ;
173                                    | TypeArgumentsopt super ( ArgumentListopt ) ;
174                                    | Primary . TypeArgumentsopt super ( ArgumentListopt ) ;
175    EnumDeclaration ::= ClassModifiersopt enum identifier Interfacesopt EnumBody
176    EnumBody ::= { EnumConstantsopt ,opt EnumBodyDeclarationsopt }
177    EnumConstants ::= EnumConstant
178                    | EnumConstants , EnumConstant
179    EnumConstant ::= Annotationsopt identifier Argumentsopt ClassBodyopt
180    Arguments ::= ( ArgumentListopt )
181    EnumBodyDeclarations ::= ; ClassBodyDeclarationsopt
182    InterfaceDeclaration ::= NormalInterfaceDeclaration
183                           | AnnotationTypeDeclaration
184    NormalInterfaceDeclaration ::= InterfaceModifiersopt interface identifier TypeParametersopt ExtendsInterfacesopt InterfaceBody
185    InterfaceModifiers ::= InterfaceModifier
186                         | InterfaceModifiers InterfaceModifier
187    InterfaceModifier ::= Annotation
188                        | public
189                        | protected
190                        | private
191                        | abstract
192                        | static
193                        | strictfp
194    ExtendsInterfaces ::= extends InterfaceType
195                        | ExtendsInterfaces , InterfaceType
196    InterfaceBody ::= { InterfaceMemberDeclarationsopt }
197    InterfaceMemberDeclarations ::= InterfaceMemberDeclaration
198                                  | InterfaceMemberDeclarations InterfaceMemberDeclaration
199    InterfaceMemberDeclaration ::= ConstantDeclaration
200                                 | AbstractMethodDeclaration
201                                 | ClassDeclaration
202                                 | InterfaceDeclaration
203                                 | ;
204    ConstantDeclaration ::= ConstantModifiersopt Type VariableDeclarators
205    ConstantModifiers ::= ConstantModifier
206                        | ConstantModifiers ConstantModifier
207    ConstantModifier ::= Annotation
208                       | public
209                       | static
210                       | final
211    AbstractMethodDeclaration ::= AbstractMethodModifiersopt TypeParametersopt ResultType MethodDeclarator Throwsopt ;
212    AbstractMethodModifiers ::= AbstractMethodModifier
213                              | AbstractMethodModifiers AbstractMethodModifier
214    AbstractMethodModifier ::= Annotations
215                             | public
216                             | abstract
217    AnnotationTypeDeclaration ::= InterfaceModifiersopt @ interface identifier AnnotationTypeBody
218    AnnotationTypeBody ::= { AnnotationTypeElementDeclarationsopt }
219    AnnotationTypeElementDeclarations ::= AnnotationTypeElementDeclaration
220                                        | AnnotationTypeElementDeclarations AnnotationTypeElementDeclaration
221    AnnotationTypeElementDeclaration ::= AbstractMethodModifiersopt Type identifier ( ) DefaultValueopt ;
222                                       | ConstantDeclaration
223                                       | ClassDeclaration
224                                       | InterfaceDeclaration
225                                       | EnumDeclaration
226                                       | AnnotationTypeDeclaration
227                                       | ;
228    DefaultValue ::= default ElementValue
229    Annotations ::= Annotation
230                  | Annotations Annotation
231    Annotation ::= NormalAnnotation
232                 | MarkerAnnotation
233                 | SingleElementAnnotation
234    NormalAnnotation ::= @ TypeName ( ElementValuePairsopt )
235    ElementValuePairs ::= ElementValuePair
236                        | ElementValuePairs , ElementValuePair
237    ElementValuePair ::= SimpleName = ElementValue
238    SimpleName ::= identifier
239    ElementValue ::= ConditionalExpression
240                   | Annotation
241                   | ElementValueArrayInitializer
242    ElementValueArrayInitializer ::= { ElementValuesopt ,opt }
243    ElementValues ::= ElementValue
244                    | ElementValues , ElementValue
245    MarkerAnnotation ::= @ TypeName
246    SingleElementAnnotation ::= @ TypeName ( ElementValue )
247    ArrayInitializer ::= { VariableInitializersopt ,opt }
248    VariableInitializers ::= VariableInitializer
249                           | VariableInitializers , VariableInitializer
250    Block ::= { BlockStatementsopt }
251    BlockStatements ::= BlockStatement
252                      | BlockStatements BlockStatement
253    BlockStatement ::= LocalVariableDeclarationStatement
254                     | ClassDeclaration
255                     | Statement
256    LocalVariableDeclarationStatement ::= LocalVariableDeclaration ;
257    LocalVariableDeclaration ::= VariableModifiersopt Type VariableDeclarators
258    Statement ::= StatementWithoutTrailingSubstatement
259                | LabeledStatement
260                | IfThenStatement
261                | IfThenElseStatement
262                | WhileStatement
263                | ForStatement
264    StatementWithoutTrailingSubstatement ::= Block
265                                           | EmptyStatement
266                                           | ExpressionStatement
267                                           | AssertStatement
268                                           | SwitchStatement
269                                           | DoStatement
270                                           | BreakStatement
271                                           | ContinueStatement
272                                           | ReturnStatement
273                                           | SynchronizedStatement
274                                           | ThrowStatement
275                                           | TryStatement
276    StatementNoShortIf ::= StatementWithoutTrailingSubstatement
277                         | LabeledStatementNoShortIf
278                         | IfThenElseStatementNoShortIf
279                         | WhileStatementNoShortIf
280                         | ForStatementNoShortIf
281    IfThenStatement ::= if ( Expression ) Statement
282    IfThenElseStatement ::= if ( Expression ) StatementNoShortIf else Statement
283    IfThenElseStatementNoShortIf ::= if ( Expression ) StatementNoShortIf else StatementNoShortIf
284    EmptyStatement ::= ;
285    LabeledStatement ::= identifier : Statement
286    LabeledStatementNoShortIf ::= identifier : StatementNoShortIf
287    ExpressionStatement ::= StatementExpression ;
288    StatementExpression ::= Assignment
289                          | PreIncrementExpression
290                          | PreDecrementExpression
291                          | PostIncrementExpression
292                          | PostDecrementExpression
293                          | MethodInvocation
294                          | ClassInstanceCreationExpression
295    AssertStatement ::= assert Expression ;
296                      | assert Expression : Expression ;
297    SwitchStatement ::= switch ( Expression ) SwitchBlock
298    SwitchBlock ::= { SwitchBlockStatementGroupsopt SwitchLabelsopt }
299    SwitchBlockStatementGroups ::= SwitchBlockStatementGroup
300                                 | SwitchBlockStatementGroups SwitchBlockStatementGroup
301    SwitchBlockStatementGroup ::= SwitchLabels BlockStatements
302    SwitchLabels ::= SwitchLabel
303                   | SwitchLabels SwitchLabel
304    SwitchLabel ::= case ConstantExpression :
305                  | case EnumConstant :
306                  | default :
307    EnumConstant ::= identifier
308    WhileStatement ::= while ( Expression ) Statement
309    WhileStatementNoShortIf ::= while ( Expression ) StatementNoShortIf
310    DoStatement ::= do Statement while ( Expression ) ;
311    ForStatement ::= BasicForStatement
312                   | EnhancedForStatement
313    BasicForStatement ::= for ( ForInitopt ; Expressionopt ; ForUpdateopt ) Statement
314    ForStatementNoShortIf ::= for ( ForInitopt ; Expressionopt ; ForUpdateopt ) StatementNoShortIf
315    ForInit ::= StatementExpressionList
316              | LocalVariableDeclaration
317    ForUpdate ::= StatementExpressionList
318    StatementExpressionList ::= StatementExpression
319                              | StatementExpressionList , StatementExpression
320    EnhancedForStatement ::= for ( FormalParameter : Expression ) Statement
321    BreakStatement ::= break identifieropt ;
322    ContinueStatement ::= continue identifieropt ;
323    ReturnStatement ::= return Expressionopt ;
324    ThrowStatement ::= throw Expression ;
325    SynchronizedStatement ::= synchronized ( Expression ) Block
326    TryStatement ::= try Block Catches
327                   | try Block Catchesopt Finally
328    Catches ::= CatchClause
329              | Catches CatchClause
330    CatchClause ::= catch ( FormalParameter ) Block
331    Finally ::= finally Block
332    Primary ::= PrimaryNoNewArray
333              | ArrayCreationExpression
334    PrimaryNoNewArray ::= Literal
335                        | Type . class
336                        | void . class
337                        | this
338                        | ClassName . this
339                        | ( Expression )
340                        | ClassInstanceCreationExpression
341                        | FieldAccess
342                        | MethodInvocation
343                        | ArrayAccess
344    Literal ::= IntegerLiteral
345              | LongLiteral
346              | FloatingPointLiteral
347              | DoubleLiteral
348              | BooleanLiteral
349              | CharacterLiteral
350              | StringLiteral
351              | null
352    BooleanLiteral ::= true
353                     | false
354    ClassInstanceCreationExpression ::= new TypeArgumentsopt ClassOrInterfaceType TypeArgumentsopt ( ArgumentListopt ) ClassBodyopt
355                                      | Primary . new TypeArgumentsopt identifier TypeArgumentsopt ( ArgumentListopt ) ClassBodyopt
356    ArgumentList ::= Expression
357                   | ArgumentList , Expression
358    ArrayCreationExpression ::= new PrimitiveType DimExprs Dimsopt
359                              | new ClassOrInterfaceType DimExprs Dimsopt
360                              | new PrimitiveType Dims ArrayInitializer
361                              | new ClassOrInterfaceType Dims ArrayInitializer
362    DimExprs ::= DimExpr
363               | DimExprs DimExpr
364    DimExpr ::= [ Expression ]
365    Dims ::= [ ]
366           | Dims [ ]
367    FieldAccess ::= Primary . identifier
368                  | super . identifier
369                  | ClassName . super . identifier
370    MethodInvocation ::= MethodName ( ArgumentListopt )
371                       | Primary . TypeArgumentsopt identifier ( ArgumentListopt )
372                       | super . TypeArgumentsopt identifier ( ArgumentListopt )
373                       | ClassName . super . TypeArgumentsopt identifier ( ArgumentListopt )
374                       | TypeName . TypeArguments identifier ( ArgumentListopt )
375    ArrayAccess ::= ExpressionName [ Expression ]
376                  | PrimaryNoNewArray [ Expression ]
377    PostfixExpression ::= Primary
378                        | ExpressionName
379                        | PostIncrementExpression
380                        | PostDecrementExpression
381    PostIncrementExpression ::= PostfixExpression ++
382    PostDecrementExpression ::= PostfixExpression '--'
383    UnaryExpression ::= PreIncrementExpression
384                      | PreDecrementExpression
385                      | + UnaryExpression
386                      | - UnaryExpression
387                      | UnaryExpressionNotPlusMinus
388    PreIncrementExpression ::= ++ UnaryExpression
389    PreDecrementExpression ::= '--' UnaryExpression
390    UnaryExpressionNotPlusMinus ::= PostfixExpression
391                                  | ~ UnaryExpression
392                                  | ! UnaryExpression
393                                  | CastExpression
394    CastExpression ::= ( PrimitiveType Dimsopt ) UnaryExpression
395                     | ( ReferenceType ) UnaryExpressionNotPlusMinus
396    MultiplicativeExpression ::= UnaryExpression
397                               | MultiplicativeExpression * UnaryExpression
398                               | MultiplicativeExpression / UnaryExpression
399                               | MultiplicativeExpression '%' UnaryExpression
400    AdditiveExpression ::= MultiplicativeExpression
401                         | AdditiveExpression + MultiplicativeExpression
402                         | AdditiveExpression - MultiplicativeExpression
403    ShiftExpression ::= AdditiveExpression
404                      | ShiftExpression << AdditiveExpression
405                      | ShiftExpression > > AdditiveExpression
406                      | ShiftExpression > > > AdditiveExpression
407    RelationalExpression ::= ShiftExpression
408                           | RelationalExpression < ShiftExpression
409                           | RelationalExpression > ShiftExpression
410                           | RelationalExpression <= ShiftExpression
411                           | RelationalExpression > = ShiftExpression
412                           | RelationalExpression instanceof ReferenceType
413    EqualityExpression ::= RelationalExpression
414                         | EqualityExpression == RelationalExpression
415                         | EqualityExpression != RelationalExpression
416    AndExpression ::= EqualityExpression
417                    | AndExpression & EqualityExpression
418    ExclusiveOrExpression ::= AndExpression
419                            | ExclusiveOrExpression ^ AndExpression
420    InclusiveOrExpression ::= ExclusiveOrExpression
421                            | InclusiveOrExpression '|' ExclusiveOrExpression
422    ConditionalAndExpression ::= InclusiveOrExpression
423                               | ConditionalAndExpression && InclusiveOrExpression
424    ConditionalOrExpression ::= ConditionalAndExpression
425                              | ConditionalOrExpression || ConditionalAndExpression
426    ConditionalExpression ::= ConditionalOrExpression
427                            | ConditionalOrExpression ? Expression : ConditionalExpression
428    AssignmentExpression ::= ConditionalExpression
429                           | Assignment
430    Assignment ::= LeftHandSide AssignmentOperator AssignmentExpression
431    LeftHandSide ::= ExpressionName
432                   | FieldAccess
433                   | ArrayAccess
434    AssignmentOperator ::= =
435                         | *=
436                         | /=
437                         | '%='
438                         | +=
439                         | -=
440                         | <<=
441                         | > > =
442                         | > > > =
443                         | &=
444                         | ^=
445                         | |=
446    Expression ::= AssignmentExpression
447    ConstantExpression ::= Expression
448    Dimsopt ::= $Empty
449              | Dims
450    Catchesopt ::= $Empty
451                 | Catches
452    identifieropt ::= $Empty
453                    | identifier
454    ForUpdateopt ::= $Empty
455                   | ForUpdate
456    Expressionopt ::= $Empty
457                    | Expression
458    ForInitopt ::= $Empty
459                 | ForInit
460    SwitchLabelsopt ::= $Empty
461                      | SwitchLabels
462    SwitchBlockStatementGroupsopt ::= $Empty
463                                    | SwitchBlockStatementGroups
464    VariableModifiersopt ::= $Empty
465                           | VariableModifiers
466    VariableInitializersopt ::= $Empty
467                              | VariableInitializers
468    ElementValuesopt ::= $Empty
469                       | ElementValues
470    ElementValuePairsopt ::= $Empty
471                           | ElementValuePairs
472    DefaultValueopt ::= $Empty
473                      | DefaultValue
474    AnnotationTypeElementDeclarationsopt ::= $Empty
475                                           | AnnotationTypeElementDeclarations
476    AbstractMethodModifiersopt ::= $Empty
477                                 | AbstractMethodModifiers
478    ConstantModifiersopt ::= $Empty
479                           | ConstantModifiers
480    InterfaceMemberDeclarationsopt ::= $Empty
481                                     | InterfaceMemberDeclarations
482    ExtendsInterfacesopt ::= $Empty
483                           | ExtendsInterfaces
484    InterfaceModifiersopt ::= $Empty
485                            | InterfaceModifiers
486    ClassBodyopt ::= $Empty
487                   | ClassBody
488    Argumentsopt ::= $Empty
489                   | Arguments
490    EnumBodyDeclarationsopt ::= $Empty
491                              | EnumBodyDeclarations
492    ,opt ::= $Empty
493           | ,
494    EnumConstantsopt ::= $Empty
495                       | EnumConstants
496    ArgumentListopt ::= $Empty
497                      | ArgumentList
498    BlockStatementsopt ::= $Empty
499                         | BlockStatements
500    ExplicitConstructorInvocationopt ::= $Empty
501                                       | ExplicitConstructorInvocation
502    ConstructorModifiersopt ::= $Empty
503                              | ConstructorModifiers
504    ...opt ::= $Empty
505             | ...
506    FormalParameterListopt ::= $Empty
507                             | FormalParameterList
508    Throwsopt ::= $Empty
509                | Throws
510    MethodModifiersopt ::= $Empty
511                         | MethodModifiers
512    FieldModifiersopt ::= $Empty
513                        | FieldModifiers
514    ClassBodyDeclarationsopt ::= $Empty
515                               | ClassBodyDeclarations
516    Interfacesopt ::= $Empty
517                    | Interfaces
518    Superopt ::= $Empty
519               | Super
520    TypeParametersopt ::= $Empty
521                        | TypeParameters
522    ClassModifiersopt ::= $Empty
523                        | ClassModifiers
524    Annotationsopt ::= $Empty
525                     | Annotations
526    TypeDeclarationsopt ::= $Empty
527                          | TypeDeclarations
528    ImportDeclarationsopt ::= $Empty
529                            | ImportDeclarations
530    PackageDeclarationopt ::= $Empty
531                            | PackageDeclaration
532    WildcardBoundsOpt ::= $Empty
533                        | WildcardBounds
534    AdditionalBoundListopt ::= $Empty
535                             | AdditionalBoundList
536    TypeBoundopt ::= $Empty
537                   | TypeBound
538    TypeArgumentsopt ::= $Empty
539                       | TypeArguments


Strongly-connected components in ranks:

    ArrayType
    ReferenceType
    Type

    ArrayAccess
    MethodInvocation
    ClassInstanceCreationExpression
    PrimaryNoNewArray
    Primary
    FieldAccess

    PostDecrementExpression
    PostfixExpression
    PostIncrementExpression



RANK RULE
==== ====
1    234   NormalAnnotation ::= AT TypeName LPAREN ElementValuePairsopt RPAREN
2    245   MarkerAnnotation ::= AT TypeName
3    246   SingleElementAnnotation ::= AT TypeName LPAREN ElementValue RPAREN
4    231   Annotation ::= NormalAnnotation
5    232   Annotation ::= MarkerAnnotation
6    233   Annotation ::= SingleElementAnnotation
7    229   Annotations ::= Annotation
8    230   Annotations ::= Annotations Annotation
9    525   Annotationsopt ::= Annotations
10   524   Annotationsopt ::=
11   62    PackageDeclaration ::= Annotationsopt package PackageName SEMICOLON
12   531   PackageDeclarationopt ::= PackageDeclaration
13   530   PackageDeclarationopt ::=
14   67    SingleTypeImportDeclaration ::= import TypeName SEMICOLON
15   68    TypeImportOnDemandDeclaration ::= import PackageOrTypeName DOT MULTIPLY SEMICOLON
16   69    SingleStaticImportDeclaration ::= import static TypeName DOT identifier SEMICOLON
17   70    StaticImportOnDemandDeclaration ::= import static TypeName DOT MULTIPLY SEMICOLON
18   63    ImportDeclaration ::= SingleTypeImportDeclaration
19   64    ImportDeclaration ::= TypeImportOnDemandDeclaration
20   65    ImportDeclaration ::= SingleStaticImportDeclaration
21   66    ImportDeclaration ::= StaticImportOnDemandDeclaration
22   58    ImportDeclarations ::= ImportDeclaration
23   59    ImportDeclarations ::= ImportDeclarations ImportDeclaration
24   529   ImportDeclarationsopt ::= ImportDeclarations
25   528   ImportDeclarationsopt ::=
26   79    ClassModifier ::= Annotation
27   80    ClassModifier ::= public
28   81    ClassModifier ::= protected
29   82    ClassModifier ::= private
30   83    ClassModifier ::= abstract
31   84    ClassModifier ::= static
32   85    ClassModifier ::= final
33   86    ClassModifier ::= strictfp
34   77    ClassModifiers ::= ClassModifier
35   78    ClassModifiers ::= ClassModifiers ClassModifier
36   523   ClassModifiersopt ::= ClassModifiers
37   522   ClassModifiersopt ::=
38   76    NormalClassDeclaration ::= ClassModifiersopt class identifier TypeParametersopt Superopt Interfacesopt ClassBody
39   175   EnumDeclaration ::= ClassModifiersopt enum identifier Interfacesopt EnumBody
40   74    ClassDeclaration ::= NormalClassDeclaration
41   75    ClassDeclaration ::= EnumDeclaration
42   187   InterfaceModifier ::= Annotation
43   188   InterfaceModifier ::= public
44   189   InterfaceModifier ::= protected
45   190   InterfaceModifier ::= private
46   191   InterfaceModifier ::= abstract
47   192   InterfaceModifier ::= static
48   193   InterfaceModifier ::= strictfp
49   185   InterfaceModifiers ::= InterfaceModifier
50   186   InterfaceModifiers ::= InterfaceModifiers InterfaceModifier
51   485   InterfaceModifiersopt ::= InterfaceModifiers
52   484   InterfaceModifiersopt ::=
53   184   NormalInterfaceDeclaration ::= InterfaceModifiersopt interface identifier TypeParametersopt ExtendsInterfacesopt InterfaceBody
54   217   AnnotationTypeDeclaration ::= InterfaceModifiersopt AT interface identifier AnnotationTypeBody
55   182   InterfaceDeclaration ::= NormalInterfaceDeclaration
56   183   InterfaceDeclaration ::= AnnotationTypeDeclaration
57   71    TypeDeclaration ::= ClassDeclaration
58   72    TypeDeclaration ::= InterfaceDeclaration
59   73    TypeDeclaration ::= SEMICOLON
60   60    TypeDeclarations ::= TypeDeclaration
61   61    TypeDeclarations ::= TypeDeclarations TypeDeclaration
62   527   TypeDeclarationsopt ::= TypeDeclarations
63   526   TypeDeclarationsopt ::=
64   1     CompilationUnit ::= ClassBodyDeclarationsoptMarker ClassBodyDeclarationsopt
65   2     CompilationUnit ::= LPGUserActionMarker LPGUserAction
66   57    CompilationUnit ::= PackageDeclarationopt ImportDeclarationsopt TypeDeclarationsopt
67   0     $accept ::= CompilationUnit
68   493   Commaopt ::= COMMA
69   492   Commaopt ::=
70   505   Ellipsisopt ::= ELLIPSIS
71   504   Ellipsisopt ::=
72   117   FieldModifier ::= Annotation
73   118   FieldModifier ::= public
74   119   FieldModifier ::= protected
75   120   FieldModifier ::= private
76   121   FieldModifier ::= static
77   122   FieldModifier ::= final
78   123   FieldModifier ::= transient
79   124   FieldModifier ::= volatile
80   115   FieldModifiers ::= FieldModifier
81   116   FieldModifiers ::= FieldModifiers FieldModifier
82   513   FieldModifiersopt ::= FieldModifiers
83   512   FieldModifiersopt ::=
84   16    IntegralType ::= byte
85   17    IntegralType ::= short
86   18    IntegralType ::= int
87   19    IntegralType ::= long
88   20    IntegralType ::= char
89   21    FloatingPointType ::= float
90   22    FloatingPointType ::= double
91   14    NumericType ::= IntegralType
92   15    NumericType ::= FloatingPointType
93   12    PrimitiveType ::= NumericType
94   13    PrimitiveType ::= boolean
95   3     identifier ::= IDENTIFIER
96   29    TypeName ::= identifier
97   30    TypeName ::= TypeName DOT identifier
98   27    ClassType ::= TypeName TypeArgumentsopt
99   26    ClassOrInterfaceType ::= ClassType
100  32    TypeVariable ::= identifier
101  33    ArrayType ::= Type LBRACKET RBRACKET
102  23    ReferenceType ::= ClassOrInterfaceType
103  24    ReferenceType ::= TypeVariable
104  25    ReferenceType ::= ArrayType
105  10    Type ::= PrimitiveType
106  11    Type ::= ReferenceType
107  106   FieldDeclaration ::= FieldModifiersopt Type VariableDeclarators SEMICOLON
108  143   MethodModifier ::= Annotations
109  144   MethodModifier ::= public
110  145   MethodModifier ::= protected
111  146   MethodModifier ::= private
112  147   MethodModifier ::= abstract
113  148   MethodModifier ::= static
114  149   MethodModifier ::= final
115  150   MethodModifier ::= synchronized
116  151   MethodModifier ::= native
117  152   MethodModifier ::= strictfp
118  141   MethodModifiers ::= MethodModifier
119  142   MethodModifiers ::= MethodModifiers MethodModifier
120  511   MethodModifiersopt ::= MethodModifiers
121  510   MethodModifiersopt ::=
122  87    TypeParameters ::= LESS TypeParameterList GREATER
123  521   TypeParametersopt ::= TypeParameters
124  520   TypeParametersopt ::=
125  127   ResultType ::= Type
126  128   ResultType ::= void
127  126   MethodHeader ::= MethodModifiersopt TypeParametersopt ResultType MethodDeclarator Throwsopt
128  125   MethodDeclaration ::= MethodHeader MethodBody
129  101   ClassMemberDeclaration ::= FieldDeclaration
130  102   ClassMemberDeclaration ::= MethodDeclaration
131  103   ClassMemberDeclaration ::= ClassDeclaration
132  104   ClassMemberDeclaration ::= InterfaceDeclaration
133  105   ClassMemberDeclaration ::= SEMICOLON
134  250   Block ::= LBRACE BlockStatementsopt RBRACE
135  160   InstanceInitializer ::= Block
136  161   StaticInitializer ::= static Block
137  167   ConstructorModifier ::= Annotations
138  168   ConstructorModifier ::= public
139  169   ConstructorModifier ::= protected
140  170   ConstructorModifier ::= private
141  165   ConstructorModifiers ::= ConstructorModifier
142  166   ConstructorModifiers ::= ConstructorModifiers ConstructorModifier
143  503   ConstructorModifiersopt ::= ConstructorModifiers
144  502   ConstructorModifiersopt ::=
145  164   SimpleTypeName ::= identifier
146  163   ConstructorDeclarator ::= TypeParametersopt SimpleTypeName LPAREN FormalParameterListopt RPAREN
147  162   ConstructorDeclaration ::= ConstructorModifiersopt ConstructorDeclarator Throwsopt ConstructorBody
148  97    ClassBodyDeclaration ::= ClassMemberDeclaration
149  98    ClassBodyDeclaration ::= InstanceInitializer
150  99    ClassBodyDeclaration ::= StaticInitializer
151  100   ClassBodyDeclaration ::= ConstructorDeclaration
152  95    ClassBodyDeclarations ::= ClassBodyDeclaration
153  96    ClassBodyDeclarations ::= ClassBodyDeclarations ClassBodyDeclaration
154  515   ClassBodyDeclarationsopt ::= ClassBodyDeclarations
155  514   ClassBodyDeclarationsopt ::=
156  138   VariableModifier ::= final
157  139   VariableModifier ::= Annotations
158  136   VariableModifiers ::= VariableModifier
159  137   VariableModifiers ::= VariableModifiers VariableModifier
160  465   VariableModifiersopt ::= VariableModifiers
161  464   VariableModifiersopt ::=
162  257   LocalVariableDeclaration ::= VariableModifiersopt Type VariableDeclarators
163  256   LocalVariableDeclarationStatement ::= LocalVariableDeclaration SEMICOLON
164  284   EmptyStatement ::= SEMICOLON
165  55    AmbiguousName ::= identifier
166  56    AmbiguousName ::= AmbiguousName DOT identifier
167  49    ExpressionName ::= identifier
168  50    ExpressionName ::= AmbiguousName DOT identifier
169  352   BooleanLiteral ::= true
170  353   BooleanLiteral ::= false
171  344   Literal ::= IntegerLiteral
172  345   Literal ::= LongLiteral
173  346   Literal ::= FloatingPointLiteral
174  347   Literal ::= DoubleLiteral
175  348   Literal ::= BooleanLiteral
176  349   Literal ::= CharacterLiteral
177  350   Literal ::= StringLiteral
178  351   Literal ::= null
179  31    ClassName ::= TypeName
180  51    MethodName ::= identifier
181  52    MethodName ::= AmbiguousName DOT identifier
182  358   ArrayCreationExpression ::= new PrimitiveType DimExprs Dimsopt
183  359   ArrayCreationExpression ::= new ClassOrInterfaceType DimExprs Dimsopt
184  360   ArrayCreationExpression ::= new PrimitiveType Dims ArrayInitializer
185  361   ArrayCreationExpression ::= new ClassOrInterfaceType Dims ArrayInitializer
186  375   ArrayAccess ::= ExpressionName LBRACKET Expression RBRACKET
187  376   ArrayAccess ::= PrimaryNoNewArray LBRACKET Expression RBRACKET
188  370   MethodInvocation ::= MethodName LPAREN ArgumentListopt RPAREN
189  371   MethodInvocation ::= Primary DOT TypeArgumentsopt identifier LPAREN ArgumentListopt RPAREN
190  372   MethodInvocation ::= super DOT TypeArgumentsopt identifier LPAREN ArgumentListopt RPAREN
191  373   MethodInvocation ::= ClassName DOT super DOT TypeArgumentsopt identifier LPAREN ArgumentListopt RPAREN
192  374   MethodInvocation ::= TypeName DOT TypeArguments identifier LPAREN ArgumentListopt RPAREN
193  354   ClassInstanceCreationExpression ::= new TypeArgumentsopt ClassOrInterfaceType TypeArgumentsopt LPAREN ArgumentListopt RPAREN ClassBodyopt
194  355   ClassInstanceCreationExpression ::= Primary DOT new TypeArgumentsopt identifier TypeArgumentsopt LPAREN ArgumentListopt RPAREN ClassBodyopt
195  334   PrimaryNoNewArray ::= Literal
196  335   PrimaryNoNewArray ::= Type DOT class
197  336   PrimaryNoNewArray ::= void DOT class
198  337   PrimaryNoNewArray ::= this
199  338   PrimaryNoNewArray ::= ClassName DOT this
200  339   PrimaryNoNewArray ::= LPAREN Expression RPAREN
201  340   PrimaryNoNewArray ::= ClassInstanceCreationExpression
202  341   PrimaryNoNewArray ::= FieldAccess
203  342   PrimaryNoNewArray ::= MethodInvocation
204  343   PrimaryNoNewArray ::= ArrayAccess
205  332   Primary ::= PrimaryNoNewArray
206  333   Primary ::= ArrayCreationExpression
207  367   FieldAccess ::= Primary DOT identifier
208  368   FieldAccess ::= super DOT identifier
209  369   FieldAccess ::= ClassName DOT super DOT identifier
210  431   LeftHandSide ::= ExpressionName
211  432   LeftHandSide ::= FieldAccess
212  433   LeftHandSide ::= ArrayAccess
213  430   Assignment ::= LeftHandSide AssignmentOperator AssignmentExpression
214  388   PreIncrementExpression ::= PLUS_PLUS UnaryExpression
215  389   PreDecrementExpression ::= MINUS_MINUS UnaryExpression
216  382   PostDecrementExpression ::= PostfixExpression MINUS_MINUS
217  377   PostfixExpression ::= Primary
218  378   PostfixExpression ::= ExpressionName
219  379   PostfixExpression ::= PostIncrementExpression
220  380   PostfixExpression ::= PostDecrementExpression
221  381   PostIncrementExpression ::= PostfixExpression PLUS_PLUS
222  288   StatementExpression ::= Assignment
223  289   StatementExpression ::= PreIncrementExpression
224  290   StatementExpression ::= PreDecrementExpression
225  291   StatementExpression ::= PostIncrementExpression
226  292   StatementExpression ::= PostDecrementExpression
227  293   StatementExpression ::= MethodInvocation
228  294   StatementExpression ::= ClassInstanceCreationExpression
229  287   ExpressionStatement ::= StatementExpression SEMICOLON
230  295   AssertStatement ::= assert Expression SEMICOLON
231  296   AssertStatement ::= assert Expression COLON Expression SEMICOLON
232  297   SwitchStatement ::= switch LPAREN Expression RPAREN SwitchBlock
233  310   DoStatement ::= do Statement while LPAREN Expression RPAREN SEMICOLON
234  321   BreakStatement ::= break identifieropt SEMICOLON
235  322   ContinueStatement ::= continue identifieropt SEMICOLON
236  323   ReturnStatement ::= return Expressionopt SEMICOLON
237  325   SynchronizedStatement ::= synchronized LPAREN Expression RPAREN Block
238  324   ThrowStatement ::= throw Expression SEMICOLON
239  326   TryStatement ::= try Block Catches
240  327   TryStatement ::= try Block Catchesopt Finally
241  264   StatementWithoutTrailingSubstatement ::= Block
242  265   StatementWithoutTrailingSubstatement ::= EmptyStatement
243  266   StatementWithoutTrailingSubstatement ::= ExpressionStatement
244  267   StatementWithoutTrailingSubstatement ::= AssertStatement
245  268   StatementWithoutTrailingSubstatement ::= SwitchStatement
246  269   StatementWithoutTrailingSubstatement ::= DoStatement
247  270   StatementWithoutTrailingSubstatement ::= BreakStatement
248  271   StatementWithoutTrailingSubstatement ::= ContinueStatement
249  272   StatementWithoutTrailingSubstatement ::= ReturnStatement
250  273   StatementWithoutTrailingSubstatement ::= SynchronizedStatement
251  274   StatementWithoutTrailingSubstatement ::= ThrowStatement
252  275   StatementWithoutTrailingSubstatement ::= TryStatement
253  285   LabeledStatement ::= identifier COLON Statement
254  281   IfThenStatement ::= if LPAREN Expression RPAREN Statement
255  282   IfThenElseStatement ::= if LPAREN Expression RPAREN StatementNoShortIf else Statement
256  308   WhileStatement ::= while LPAREN Expression RPAREN Statement
257  313   BasicForStatement ::= for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON ForUpdateopt RPAREN Statement
258  320   EnhancedForStatement ::= for LPAREN FormalParameter COLON Expression RPAREN Statement
259  311   ForStatement ::= BasicForStatement
260  312   ForStatement ::= EnhancedForStatement
261  258   Statement ::= StatementWithoutTrailingSubstatement
262  259   Statement ::= LabeledStatement
263  260   Statement ::= IfThenStatement
264  261   Statement ::= IfThenElseStatement
265  262   Statement ::= WhileStatement
266  263   Statement ::= ForStatement
267  253   BlockStatement ::= LocalVariableDeclarationStatement
268  254   BlockStatement ::= ClassDeclaration
269  255   BlockStatement ::= Statement
270  251   BlockStatements ::= BlockStatement
271  252   BlockStatements ::= BlockStatements BlockStatement
272  499   BlockStatementsopt ::= BlockStatements
273  498   BlockStatementsopt ::=
274  5     LPGUserAction ::= BeginAction BlockStatementsopt EndAction
275  6     LPGUserAction ::= BeginJava BlockStatementsopt EndJava
276  7     LPGUserAction ::= NoAction
277  8     LPGUserAction ::= NullAction
278  9     LPGUserAction ::= BadAction
279  4     LPGUserAction ::= BlockStatementsopt
280  39    TypeArguments ::= LESS ActualTypeArgumentList GREATER
281  539   TypeArgumentsopt ::= TypeArguments
282  538   TypeArgumentsopt ::=
283  28    InterfaceType ::= TypeName TypeArgumentsopt
284  34    TypeParameter ::= TypeVariable TypeBoundopt
285  35    TypeBound ::= extends ClassOrInterfaceType AdditionalBoundListopt
286  537   TypeBoundopt ::= TypeBound
287  536   TypeBoundopt ::=
288  38    AdditionalBound ::= AND InterfaceType
289  36    AdditionalBoundList ::= AdditionalBound
290  37    AdditionalBoundList ::= AdditionalBoundList AdditionalBound
291  535   AdditionalBoundListopt ::= AdditionalBoundList
292  534   AdditionalBoundListopt ::=
293  44    Wildcard ::= QUESTION WildcardBoundsOpt
294  42    ActualTypeArgument ::= ReferenceType
295  43    ActualTypeArgument ::= Wildcard
296  40    ActualTypeArgumentList ::= ActualTypeArgument
297  41    ActualTypeArgumentList ::= ActualTypeArgumentList COMMA ActualTypeArgument
298  45    WildcardBounds ::= extends ReferenceType
299  46    WildcardBounds ::= super ReferenceType
300  533   WildcardBoundsOpt ::= WildcardBounds
301  532   WildcardBoundsOpt ::=
302  47    PackageName ::= identifier
303  48    PackageName ::= PackageName DOT identifier
304  53    PackageOrTypeName ::= identifier
305  54    PackageOrTypeName ::= PackageOrTypeName DOT identifier
306  90    Super ::= extends ClassType
307  519   Superopt ::= Super
308  518   Superopt ::=
309  91    Interfaces ::= implements InterfaceTypeList
310  517   Interfacesopt ::= Interfaces
311  516   Interfacesopt ::=
312  94    ClassBody ::= LBRACE ClassBodyDeclarationsopt RBRACE
313  88    TypeParameterList ::= TypeParameter
314  89    TypeParameterList ::= TypeParameterList COMMA TypeParameter
315  92    InterfaceTypeList ::= InterfaceType
316  93    InterfaceTypeList ::= InterfaceTypeList COMMA InterfaceType
317  111   VariableDeclaratorId ::= identifier
318  112   VariableDeclaratorId ::= VariableDeclaratorId LBRACKET RBRACKET
319  109   VariableDeclarator ::= VariableDeclaratorId
320  110   VariableDeclarator ::= VariableDeclaratorId EQUAL VariableInitializer
321  107   VariableDeclarators ::= VariableDeclarator
322  108   VariableDeclarators ::= VariableDeclarators COMMA VariableDeclarator
323  394   CastExpression ::= LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression
324  395   CastExpression ::= LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus
325  390   UnaryExpressionNotPlusMinus ::= PostfixExpression
326  391   UnaryExpressionNotPlusMinus ::= TWIDDLE UnaryExpression
327  392   UnaryExpressionNotPlusMinus ::= NOT UnaryExpression
328  393   UnaryExpressionNotPlusMinus ::= CastExpression
329  383   UnaryExpression ::= PreIncrementExpression
330  384   UnaryExpression ::= PreDecrementExpression
331  385   UnaryExpression ::= PLUS UnaryExpression
332  386   UnaryExpression ::= MINUS UnaryExpression
333  387   UnaryExpression ::= UnaryExpressionNotPlusMinus
334  396   MultiplicativeExpression ::= UnaryExpression
335  397   MultiplicativeExpression ::= MultiplicativeExpression MULTIPLY UnaryExpression
336  398   MultiplicativeExpression ::= MultiplicativeExpression DIVIDE UnaryExpression
337  399   MultiplicativeExpression ::= MultiplicativeExpression REMAINDER UnaryExpression
338  400   AdditiveExpression ::= MultiplicativeExpression
339  401   AdditiveExpression ::= AdditiveExpression PLUS MultiplicativeExpression
340  402   AdditiveExpression ::= AdditiveExpression MINUS MultiplicativeExpression
341  403   ShiftExpression ::= AdditiveExpression
342  404   ShiftExpression ::= ShiftExpression LEFT_SHIFT AdditiveExpression
343  405   ShiftExpression ::= ShiftExpression GREATER GREATER AdditiveExpression
344  406   ShiftExpression ::= ShiftExpression GREATER GREATER GREATER AdditiveExpression
345  407   RelationalExpression ::= ShiftExpression
346  408   RelationalExpression ::= RelationalExpression LESS ShiftExpression
347  409   RelationalExpression ::= RelationalExpression GREATER ShiftExpression
348  410   RelationalExpression ::= RelationalExpression LESS_EQUAL ShiftExpression
349  411   RelationalExpression ::= RelationalExpression GREATER EQUAL ShiftExpression
350  412   RelationalExpression ::= RelationalExpression instanceof ReferenceType
351  413   EqualityExpression ::= RelationalExpression
352  414   EqualityExpression ::= EqualityExpression EQUAL_EQUAL RelationalExpression
353  415   EqualityExpression ::= EqualityExpression NOT_EQUAL RelationalExpression
354  416   AndExpression ::= EqualityExpression
355  417   AndExpression ::= AndExpression AND EqualityExpression
356  418   ExclusiveOrExpression ::= AndExpression
357  419   ExclusiveOrExpression ::= ExclusiveOrExpression XOR AndExpression
358  420   InclusiveOrExpression ::= ExclusiveOrExpression
359  421   InclusiveOrExpression ::= InclusiveOrExpression OR ExclusiveOrExpression
360  422   ConditionalAndExpression ::= InclusiveOrExpression
361  423   ConditionalAndExpression ::= ConditionalAndExpression AND_AND InclusiveOrExpression
362  424   ConditionalOrExpression ::= ConditionalAndExpression
363  425   ConditionalOrExpression ::= ConditionalOrExpression OR_OR ConditionalAndExpression
364  426   ConditionalExpression ::= ConditionalOrExpression
365  427   ConditionalExpression ::= ConditionalOrExpression QUESTION Expression COLON ConditionalExpression
366  428   AssignmentExpression ::= ConditionalExpression
367  429   AssignmentExpression ::= Assignment
368  446   Expression ::= AssignmentExpression
369  247   ArrayInitializer ::= LBRACE VariableInitializersopt Commaopt RBRACE
370  113   VariableInitializer ::= Expression
371  114   VariableInitializer ::= ArrayInitializer
372  158   MethodBody ::= Block
373  159   MethodBody ::= SEMICOLON
374  129   MethodDeclarator ::= identifier LPAREN FormalParameterListopt RPAREN
375  130   MethodDeclarator ::= MethodDeclarator LBRACKET RBRACKET
376  153   Throws ::= throws ExceptionTypeList
377  509   Throwsopt ::= Throws
378  508   Throwsopt ::=
379  140   LastFormalParameter ::= VariableModifiersopt Type Ellipsisopt VariableDeclaratorId
380  135   FormalParameter ::= VariableModifiersopt Type VariableDeclaratorId
381  133   FormalParameters ::= FormalParameter
382  134   FormalParameters ::= FormalParameters COMMA FormalParameter
383  131   FormalParameterList ::= LastFormalParameter
384  132   FormalParameterList ::= FormalParameters COMMA LastFormalParameter
385  507   FormalParameterListopt ::= FormalParameterList
386  506   FormalParameterListopt ::=
387  156   ExceptionType ::= ClassType
388  157   ExceptionType ::= TypeVariable
389  154   ExceptionTypeList ::= ExceptionType
390  155   ExceptionTypeList ::= ExceptionTypeList COMMA ExceptionType
391  171   ConstructorBody ::= LBRACE ExplicitConstructorInvocationopt BlockStatementsopt RBRACE
392  172   ExplicitConstructorInvocation ::= TypeArgumentsopt this LPAREN ArgumentListopt RPAREN SEMICOLON
393  173   ExplicitConstructorInvocation ::= TypeArgumentsopt super LPAREN ArgumentListopt RPAREN SEMICOLON
394  174   ExplicitConstructorInvocation ::= Primary DOT TypeArgumentsopt super LPAREN ArgumentListopt RPAREN SEMICOLON
395  501   ExplicitConstructorInvocationopt ::= ExplicitConstructorInvocation
396  500   ExplicitConstructorInvocationopt ::=
397  356   ArgumentList ::= Expression
398  357   ArgumentList ::= ArgumentList COMMA Expression
399  497   ArgumentListopt ::= ArgumentList
400  496   ArgumentListopt ::=
401  176   EnumBody ::= LBRACE EnumConstantsopt Commaopt EnumBodyDeclarationsopt RBRACE
402  179   EnumConstant ::= Annotationsopt identifier Argumentsopt ClassBodyopt
403  307   EnumConstant ::= identifier
404  177   EnumConstants ::= EnumConstant
405  178   EnumConstants ::= EnumConstants COMMA EnumConstant
406  495   EnumConstantsopt ::= EnumConstants
407  494   EnumConstantsopt ::=
408  181   EnumBodyDeclarations ::= SEMICOLON ClassBodyDeclarationsopt
409  491   EnumBodyDeclarationsopt ::= EnumBodyDeclarations
410  490   EnumBodyDeclarationsopt ::=
411  180   Arguments ::= LPAREN ArgumentListopt RPAREN
412  489   Argumentsopt ::= Arguments
413  488   Argumentsopt ::=
414  487   ClassBodyopt ::= ClassBody
415  486   ClassBodyopt ::=
416  194   ExtendsInterfaces ::= extends InterfaceType
417  195   ExtendsInterfaces ::= ExtendsInterfaces COMMA InterfaceType
418  483   ExtendsInterfacesopt ::= ExtendsInterfaces
419  482   ExtendsInterfacesopt ::=
420  196   InterfaceBody ::= LBRACE InterfaceMemberDeclarationsopt RBRACE
421  207   ConstantModifier ::= Annotation
422  208   ConstantModifier ::= public
423  209   ConstantModifier ::= static
424  210   ConstantModifier ::= final
425  205   ConstantModifiers ::= ConstantModifier
426  206   ConstantModifiers ::= ConstantModifiers ConstantModifier
427  479   ConstantModifiersopt ::= ConstantModifiers
428  478   ConstantModifiersopt ::=
429  204   ConstantDeclaration ::= ConstantModifiersopt Type VariableDeclarators
430  214   AbstractMethodModifier ::= Annotations
431  215   AbstractMethodModifier ::= public
432  216   AbstractMethodModifier ::= abstract
433  212   AbstractMethodModifiers ::= AbstractMethodModifier
434  213   AbstractMethodModifiers ::= AbstractMethodModifiers AbstractMethodModifier
435  477   AbstractMethodModifiersopt ::= AbstractMethodModifiers
436  476   AbstractMethodModifiersopt ::=
437  211   AbstractMethodDeclaration ::= AbstractMethodModifiersopt TypeParametersopt ResultType MethodDeclarator Throwsopt SEMICOLON
438  199   InterfaceMemberDeclaration ::= ConstantDeclaration
439  200   InterfaceMemberDeclaration ::= AbstractMethodDeclaration
440  201   InterfaceMemberDeclaration ::= ClassDeclaration
441  202   InterfaceMemberDeclaration ::= InterfaceDeclaration
442  203   InterfaceMemberDeclaration ::= SEMICOLON
443  197   InterfaceMemberDeclarations ::= InterfaceMemberDeclaration
444  198   InterfaceMemberDeclarations ::= InterfaceMemberDeclarations InterfaceMemberDeclaration
445  481   InterfaceMemberDeclarationsopt ::= InterfaceMemberDeclarations
446  480   InterfaceMemberDeclarationsopt ::=
447  218   AnnotationTypeBody ::= LBRACE AnnotationTypeElementDeclarationsopt RBRACE
448  221   AnnotationTypeElementDeclaration ::= AbstractMethodModifiersopt Type identifier LPAREN RPAREN DefaultValueopt SEMICOLON
449  222   AnnotationTypeElementDeclaration ::= ConstantDeclaration
450  223   AnnotationTypeElementDeclaration ::= ClassDeclaration
451  224   AnnotationTypeElementDeclaration ::= InterfaceDeclaration
452  225   AnnotationTypeElementDeclaration ::= EnumDeclaration
453  226   AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration
454  227   AnnotationTypeElementDeclaration ::= SEMICOLON
455  219   AnnotationTypeElementDeclarations ::= AnnotationTypeElementDeclaration
456  220   AnnotationTypeElementDeclarations ::= AnnotationTypeElementDeclarations AnnotationTypeElementDeclaration
457  475   AnnotationTypeElementDeclarationsopt ::= AnnotationTypeElementDeclarations
458  474   AnnotationTypeElementDeclarationsopt ::=
459  228   DefaultValue ::= default ElementValue
460  473   DefaultValueopt ::= DefaultValue
461  472   DefaultValueopt ::=
462  242   ElementValueArrayInitializer ::= LBRACE ElementValuesopt Commaopt RBRACE
463  239   ElementValue ::= ConditionalExpression
464  240   ElementValue ::= Annotation
465  241   ElementValue ::= ElementValueArrayInitializer
466  238   SimpleName ::= identifier
467  237   ElementValuePair ::= SimpleName EQUAL ElementValue
468  235   ElementValuePairs ::= ElementValuePair
469  236   ElementValuePairs ::= ElementValuePairs COMMA ElementValuePair
470  471   ElementValuePairsopt ::= ElementValuePairs
471  470   ElementValuePairsopt ::=
472  243   ElementValues ::= ElementValue
473  244   ElementValues ::= ElementValues COMMA ElementValue
474  469   ElementValuesopt ::= ElementValues
475  468   ElementValuesopt ::=
476  248   VariableInitializers ::= VariableInitializer
477  249   VariableInitializers ::= VariableInitializers COMMA VariableInitializer
478  467   VariableInitializersopt ::= VariableInitializers
479  466   VariableInitializersopt ::=
480  286   LabeledStatementNoShortIf ::= identifier COLON StatementNoShortIf
481  283   IfThenElseStatementNoShortIf ::= if LPAREN Expression RPAREN StatementNoShortIf else StatementNoShortIf
482  309   WhileStatementNoShortIf ::= while LPAREN Expression RPAREN StatementNoShortIf
483  314   ForStatementNoShortIf ::= for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON ForUpdateopt RPAREN StatementNoShortIf
484  276   StatementNoShortIf ::= StatementWithoutTrailingSubstatement
485  277   StatementNoShortIf ::= LabeledStatementNoShortIf
486  278   StatementNoShortIf ::= IfThenElseStatementNoShortIf
487  279   StatementNoShortIf ::= WhileStatementNoShortIf
488  280   StatementNoShortIf ::= ForStatementNoShortIf
489  298   SwitchBlock ::= LBRACE SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE
490  304   SwitchLabel ::= case ConstantExpression COLON
491  305   SwitchLabel ::= case EnumConstant COLON
492  306   SwitchLabel ::= default COLON
493  302   SwitchLabels ::= SwitchLabel
494  303   SwitchLabels ::= SwitchLabels SwitchLabel
495  301   SwitchBlockStatementGroup ::= SwitchLabels BlockStatements
496  299   SwitchBlockStatementGroups ::= SwitchBlockStatementGroup
497  300   SwitchBlockStatementGroups ::= SwitchBlockStatementGroups SwitchBlockStatementGroup
498  463   SwitchBlockStatementGroupsopt ::= SwitchBlockStatementGroups
499  462   SwitchBlockStatementGroupsopt ::=
500  461   SwitchLabelsopt ::= SwitchLabels
501  460   SwitchLabelsopt ::=
502  447   ConstantExpression ::= Expression
503  318   StatementExpressionList ::= StatementExpression
504  319   StatementExpressionList ::= StatementExpressionList COMMA StatementExpression
505  315   ForInit ::= StatementExpressionList
506  316   ForInit ::= LocalVariableDeclaration
507  459   ForInitopt ::= ForInit
508  458   ForInitopt ::=
509  457   Expressionopt ::= Expression
510  456   Expressionopt ::=
511  317   ForUpdate ::= StatementExpressionList
512  455   ForUpdateopt ::= ForUpdate
513  454   ForUpdateopt ::=
514  453   identifieropt ::= identifier
515  452   identifieropt ::=
516  330   CatchClause ::= catch LPAREN FormalParameter RPAREN Block
517  328   Catches ::= CatchClause
518  329   Catches ::= Catches CatchClause
519  451   Catchesopt ::= Catches
520  450   Catchesopt ::=
521  331   Finally ::= finally Block
522  364   DimExpr ::= LBRACKET Expression RBRACKET
523  362   DimExprs ::= DimExpr
524  363   DimExprs ::= DimExprs DimExpr
525  365   Dims ::= LBRACKET RBRACKET
526  366   Dims ::= Dims LBRACKET RBRACKET
527  449   Dimsopt ::= Dims
528  448   Dimsopt ::=
529  434   AssignmentOperator ::= EQUAL
530  435   AssignmentOperator ::= MULTIPLY_EQUAL
531  436   AssignmentOperator ::= DIVIDE_EQUAL
532  437   AssignmentOperator ::= REMAINDER_EQUAL
533  438   AssignmentOperator ::= PLUS_EQUAL
534  439   AssignmentOperator ::= MINUS_EQUAL
535  440   AssignmentOperator ::= LEFT_SHIFT_EQUAL
536  441   AssignmentOperator ::= GREATER GREATER EQUAL
537  442   AssignmentOperator ::= GREATER GREATER GREATER EQUAL
538  443   AssignmentOperator ::= AND_EQUAL
539  444   AssignmentOperator ::= XOR_EQUAL
540  445   AssignmentOperator ::= OR_EQUAL
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:146:5:146:17:3709:3721: Informative: The terminal GREATER_EQUAL is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:147:5:147:15:3747:3757: Informative: The terminal RIGHT_SHIFT is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:148:5:148:21:3785:3801: Informative: The terminal RIGHT_SHIFT_EQUAL is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:149:5:149:24:3825:3844: Informative: The terminal UNSIGNED_RIGHT_SHIFT is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:150:5:150:30:3864:3889: Informative: The terminal UNSIGNED_RIGHT_SHIFT_EQUAL is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaKWLexer.gi:22:5:22:9:286:290: Informative: The terminal const is useless.
/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaKWLexer.gi:35:5:35:8:419:422: Informative: The terminal goto is useless.


 IBM LALR Parser Generator              2.0.17 (May 18 2009)



Cross-reference table:


AND  ==>> 38 417 

AND_AND  ==>> 423 

AND_EQUAL  ==>> 443 

AT  ==>> 217 234 245 246 

AbstractMethodDeclaration  ==>> 211 

AbstractMethodModifier  ==>> 214 215 216 

AbstractMethodModifiers  ==>> 212 213 

AbstractMethodModifiersopt  ==>> 476 477 

ActualTypeArgument  ==>> 42 43 

ActualTypeArgumentList  ==>> 40 41 

AdditionalBound  ==>> 38 

AdditionalBoundList  ==>> 36 37 

AdditionalBoundListopt  ==>> 534 535 

AdditiveExpression  ==>> 400 401 402 

AmbiguousName  ==>> 55 56 

AndExpression  ==>> 416 417 

Annotation  ==>> 231 232 233 

AnnotationTypeBody  ==>> 218 

AnnotationTypeDeclaration  ==>> 217 

AnnotationTypeElementDeclaration  ==>> 221 222 223 224 225 226 227 

AnnotationTypeElementDeclarations  ==>> 219 220 

AnnotationTypeElementDeclarationsopt  ==>> 474 475 

Annotations  ==>> 229 230 

Annotationsopt  ==>> 524 525 

ArgumentList  ==>> 356 357 

ArgumentListopt  ==>> 496 497 

Arguments  ==>> 180 

Argumentsopt  ==>> 488 489 

ArrayAccess  ==>> 375 376 

ArrayCreationExpression  ==>> 358 359 360 361 

ArrayInitializer  ==>> 247 

ArrayType  ==>> 33 

AssertStatement  ==>> 295 296 

Assignment  ==>> 430 

AssignmentExpression  ==>> 428 429 

AssignmentOperator  ==>> 434 435 436 437 438 439 440 441 442 443 444 445 

BadAction  ==>> 9 

BasicForStatement  ==>> 313 

BeginAction  ==>> 5 

BeginJava  ==>> 6 

Block  ==>> 250 

BlockStatement  ==>> 253 254 255 

BlockStatements  ==>> 251 252 

BlockStatementsopt  ==>> 498 499 

BooleanLiteral  ==>> 352 353 

BreakStatement  ==>> 321 

COLON  ==>> 285 286 296 304 305 306 320 427 

COMMA  ==>> 41 89 93 108 132 134 155 178 195 236 244 249 319 357 493 

CastExpression  ==>> 394 395 

CatchClause  ==>> 330 

Catches  ==>> 328 329 

Catchesopt  ==>> 450 451 

CharacterLiteral  ==>> 349 

ClassBody  ==>> 94 

ClassBodyDeclaration  ==>> 97 98 99 100 

ClassBodyDeclarations  ==>> 95 96 

ClassBodyDeclarationsopt  ==>> 514 515 

ClassBodyDeclarationsoptMarker  ==>> 1 

ClassBodyopt  ==>> 486 487 

ClassDeclaration  ==>> 74 75 

ClassInstanceCreationExpression  ==>> 354 355 

ClassMemberDeclaration  ==>> 101 102 103 104 105 

ClassModifier  ==>> 79 80 81 82 83 84 85 86 

ClassModifiers  ==>> 77 78 

ClassModifiersopt  ==>> 522 523 

ClassName  ==>> 31 

ClassOrInterfaceType  ==>> 26 

ClassType  ==>> 27 

Commaopt  ==>> 492 493 

CompilationUnit  ==>> 1 2 57 

ConditionalAndExpression  ==>> 422 423 

ConditionalExpression  ==>> 426 427 

ConditionalOrExpression  ==>> 424 425 

ConstantDeclaration  ==>> 204 

ConstantExpression  ==>> 447 

ConstantModifier  ==>> 207 208 209 210 

ConstantModifiers  ==>> 205 206 

ConstantModifiersopt  ==>> 478 479 

ConstructorBody  ==>> 171 

ConstructorDeclaration  ==>> 162 

ConstructorDeclarator  ==>> 163 

ConstructorModifier  ==>> 167 168 169 170 

ConstructorModifiers  ==>> 165 166 

ConstructorModifiersopt  ==>> 502 503 

ContinueStatement  ==>> 322 

DIVIDE  ==>> 398 

DIVIDE_EQUAL  ==>> 436 

DOT  ==>> 30 48 50 52 54 56 68 69 70 174 335 336 338 355 367 368 369 369 371 372 u
          373 373 374 

DefaultValue  ==>> 228 

DefaultValueopt  ==>> 472 473 

DimExpr  ==>> 364 

DimExprs  ==>> 362 363 

Dims  ==>> 365 366 

Dimsopt  ==>> 448 449 

DoStatement  ==>> 310 

DoubleLiteral  ==>> 347 

ELLIPSIS  ==>> 505 

EQUAL  ==>> 110 237 411 434 441 442 

EQUAL_EQUAL  ==>> 414 

ERROR_TOKEN  ==>> 

ElementValue  ==>> 239 240 241 

ElementValueArrayInitializer  ==>> 242 

ElementValuePair  ==>> 237 

ElementValuePairs  ==>> 235 236 

ElementValuePairsopt  ==>> 470 471 

ElementValues  ==>> 243 244 

ElementValuesopt  ==>> 468 469 

Ellipsisopt  ==>> 504 505 

EmptyStatement  ==>> 284 

EndAction  ==>> 5 

EndJava  ==>> 6 

EnhancedForStatement  ==>> 320 

EnumBody  ==>> 176 

EnumBodyDeclarations  ==>> 181 

EnumBodyDeclarationsopt  ==>> 490 491 

EnumConstant  ==>> 179 307 

EnumConstants  ==>> 177 178 

EnumConstantsopt  ==>> 494 495 

EnumDeclaration  ==>> 175 

EqualityExpression  ==>> 413 414 415 

ExceptionType  ==>> 156 157 

ExceptionTypeList  ==>> 154 155 

ExclusiveOrExpression  ==>> 418 419 

ExplicitConstructorInvocation  ==>> 172 173 174 

ExplicitConstructorInvocationopt  ==>> 500 501 

Expression  ==>> 446 

ExpressionName  ==>> 49 50 

ExpressionStatement  ==>> 287 

Expressionopt  ==>> 456 457 

ExtendsInterfaces  ==>> 194 195 

ExtendsInterfacesopt  ==>> 482 483 

FieldAccess  ==>> 367 368 369 

FieldDeclaration  ==>> 106 

FieldModifier  ==>> 117 118 119 120 121 122 123 124 

FieldModifiers  ==>> 115 116 

FieldModifiersopt  ==>> 512 513 

Finally  ==>> 331 

FloatingPointLiteral  ==>> 346 

FloatingPointType  ==>> 21 22 

ForInit  ==>> 315 316 

ForInitopt  ==>> 458 459 

ForStatement  ==>> 311 312 

ForStatementNoShortIf  ==>> 314 

ForUpdate  ==>> 317 

ForUpdateopt  ==>> 454 455 

FormalParameter  ==>> 135 

FormalParameterList  ==>> 131 132 

FormalParameterListopt  ==>> 506 507 

FormalParameters  ==>> 133 134 

GREATER  ==>> 39 87 405 405 406 406 406 409 411 441 441 442 442 442 

GREATER_EQUAL  ==>> 

IDENTIFIER  ==>> 3 

IfThenElseStatement  ==>> 282 

IfThenElseStatementNoShortIf  ==>> 283 

IfThenStatement  ==>> 281 

ImportDeclaration  ==>> 63 64 65 66 

ImportDeclarations  ==>> 58 59 

ImportDeclarationsopt  ==>> 528 529 

InclusiveOrExpression  ==>> 420 421 

InstanceInitializer  ==>> 160 

IntegerLiteral  ==>> 344 

IntegralType  ==>> 16 17 18 19 20 

InterfaceBody  ==>> 196 

InterfaceDeclaration  ==>> 182 183 

InterfaceMemberDeclaration  ==>> 199 200 201 202 203 

InterfaceMemberDeclarations  ==>> 197 198 

InterfaceMemberDeclarationsopt  ==>> 480 481 

InterfaceModifier  ==>> 187 188 189 190 191 192 193 

InterfaceModifiers  ==>> 185 186 

InterfaceModifiersopt  ==>> 484 485 

InterfaceType  ==>> 28 

InterfaceTypeList  ==>> 92 93 

Interfaces  ==>> 91 

Interfacesopt  ==>> 516 517 

LBRACE  ==>> 94 171 176 196 218 242 247 250 298 

LBRACKET  ==>> 33 112 130 364 365 366 375 376 

LEFT_SHIFT  ==>> 404 

LEFT_SHIFT_EQUAL  ==>> 440 

LESS  ==>> 39 87 408 

LESS_EQUAL  ==>> 410 

LPAREN  ==>> 129 163 172 173 174 180 221 234 246 281 282 283 297 308 309 310 313 :
             314 320 325 330 339 354 355 370 371 372 373 374 394 395 

LPGUserAction  ==>> 4 5 6 7 8 9 

LPGUserActionMarker  ==>> 2 

LabeledStatement  ==>> 285 

LabeledStatementNoShortIf  ==>> 286 

LastFormalParameter  ==>> 140 

LeftHandSide  ==>> 431 432 433 

Literal  ==>> 344 345 346 347 348 349 350 351 

LocalVariableDeclaration  ==>> 257 

LocalVariableDeclarationStatement  ==>> 256 

LongLiteral  ==>> 345 

MINUS  ==>> 386 402 

MINUS_EQUAL  ==>> 439 

MINUS_MINUS  ==>> 382 389 

MULTIPLY  ==>> 68 70 397 

MULTIPLY_EQUAL  ==>> 435 

MarkerAnnotation  ==>> 245 

MethodBody  ==>> 158 159 

MethodDeclaration  ==>> 125 

MethodDeclarator  ==>> 129 130 

MethodHeader  ==>> 126 

MethodInvocation  ==>> 370 371 372 373 374 

MethodModifier  ==>> 143 144 145 146 147 148 149 150 151 152 

MethodModifiers  ==>> 141 142 

MethodModifiersopt  ==>> 510 511 

MethodName  ==>> 51 52 

MultiplicativeExpression  ==>> 396 397 398 399 

NOT  ==>> 392 

NOT_EQUAL  ==>> 415 

NoAction  ==>> 7 

NormalAnnotation  ==>> 234 

NormalClassDeclaration  ==>> 76 

NormalInterfaceDeclaration  ==>> 184 

NullAction  ==>> 8 

NumericType  ==>> 14 15 

OR  ==>> 421 

OR_EQUAL  ==>> 445 

OR_OR  ==>> 425 

PLUS  ==>> 385 401 

PLUS_EQUAL  ==>> 438 

PLUS_PLUS  ==>> 381 388 

PackageDeclaration  ==>> 62 

PackageDeclarationopt  ==>> 530 531 

PackageName  ==>> 47 48 

PackageOrTypeName  ==>> 53 54 

PostDecrementExpression  ==>> 382 

PostIncrementExpression  ==>> 381 

PostfixExpression  ==>> 377 378 379 380 

PreDecrementExpression  ==>> 389 

PreIncrementExpression  ==>> 388 

Primary  ==>> 332 333 

PrimaryNoNewArray  ==>> 334 335 336 337 338 339 340 341 342 343 

PrimitiveType  ==>> 12 13 

QUESTION  ==>> 44 427 

RBRACE  ==>> 94 171 176 196 218 242 247 250 298 

RBRACKET  ==>> 33 112 130 364 365 366 375 376 

REMAINDER  ==>> 399 

REMAINDER_EQUAL  ==>> 437 

RIGHT_SHIFT  ==>> 

RIGHT_SHIFT_EQUAL  ==>> 

RPAREN  ==>> 129 163 172 173 174 180 221 234 246 281 282 283 297 308 309 310 313 :
             314 320 325 330 339 354 355 370 371 372 373 374 394 395 

ReferenceType  ==>> 23 24 25 

RelationalExpression  ==>> 407 408 409 410 411 412 

ResultType  ==>> 127 128 

ReturnStatement  ==>> 323 

SEMICOLON  ==>> 62 67 68 69 70 73 105 106 159 172 173 174 181 203 211 221 227 
                256 284 287 295 296 310 313 313 314 314 321 322 323 324 

ShiftExpression  ==>> 403 404 405 406 

SimpleName  ==>> 238 

SimpleTypeName  ==>> 164 

SingleElementAnnotation  ==>> 246 

SingleStaticImportDeclaration  ==>> 69 

SingleTypeImportDeclaration  ==>> 67 

Statement  ==>> 258 259 260 261 262 263 

StatementExpression  ==>> 288 289 290 291 292 293 294 

StatementExpressionList  ==>> 318 319 

StatementNoShortIf  ==>> 276 277 278 279 280 

StatementWithoutTrailingSubstatement  ==>> 264 265 266 267 268 269 270 271 272 
                                           273 274 275 

StaticImportOnDemandDeclaration  ==>> 70 

StaticInitializer  ==>> 161 

StringLiteral  ==>> 350 

Super  ==>> 90 

Superopt  ==>> 518 519 

SwitchBlock  ==>> 298 

SwitchBlockStatementGroup  ==>> 301 

SwitchBlockStatementGroups  ==>> 299 300 

SwitchBlockStatementGroupsopt  ==>> 462 463 

SwitchLabel  ==>> 304 305 306 

SwitchLabels  ==>> 302 303 

SwitchLabelsopt  ==>> 460 461 

SwitchStatement  ==>> 297 

SynchronizedStatement  ==>> 325 

TWIDDLE  ==>> 391 

ThrowStatement  ==>> 324 

Throws  ==>> 153 

Throwsopt  ==>> 508 509 

TryStatement  ==>> 326 327 

Type  ==>> 10 11 

TypeArguments  ==>> 39 

TypeArgumentsopt  ==>> 538 539 

TypeBound  ==>> 35 

TypeBoundopt  ==>> 536 537 

TypeDeclaration  ==>> 71 72 73 

TypeDeclarations  ==>> 60 61 

TypeDeclarationsopt  ==>> 526 527 

TypeImportOnDemandDeclaration  ==>> 68 

TypeName  ==>> 29 30 

TypeParameter  ==>> 34 

TypeParameterList  ==>> 88 89 

TypeParameters  ==>> 87 

TypeParametersopt  ==>> 520 521 

TypeVariable  ==>> 32 

UNSIGNED_RIGHT_SHIFT  ==>> 

UNSIGNED_RIGHT_SHIFT_EQUAL  ==>> 

UnaryExpression  ==>> 383 384 385 386 387 

UnaryExpressionNotPlusMinus  ==>> 390 391 392 393 

VariableDeclarator  ==>> 109 110 

VariableDeclaratorId  ==>> 111 112 

VariableDeclarators  ==>> 107 108 

VariableInitializer  ==>> 113 114 

VariableInitializers  ==>> 248 249 

VariableInitializersopt  ==>> 466 467 

VariableModifier  ==>> 138 139 

VariableModifiers  ==>> 136 137 

VariableModifiersopt  ==>> 464 465 

WhileStatement  ==>> 308 

WhileStatementNoShortIf  ==>> 309 

Wildcard  ==>> 44 

WildcardBounds  ==>> 45 46 

WildcardBoundsOpt  ==>> 532 533 

XOR  ==>> 419 

XOR_EQUAL  ==>> 444 

abstract  ==>> 83 147 191 216 

assert  ==>> 295 296 

boolean  ==>> 13 

break  ==>> 321 

byte  ==>> 16 

case  ==>> 304 305 

catch  ==>> 330 

char  ==>> 20 

class  ==>> 76 335 336 

const  ==>> 

continue  ==>> 322 

default  ==>> 228 306 

do  ==>> 310 

double  ==>> 22 

else  ==>> 282 283 

enum  ==>> 175 

extends  ==>> 35 45 90 194 

false  ==>> 353 

final  ==>> 85 122 138 149 210 

finally  ==>> 331 

float  ==>> 21 

for  ==>> 313 314 320 

goto  ==>> 

identifier  ==>> 3 

identifieropt  ==>> 452 453 

if  ==>> 281 282 283 

implements  ==>> 91 

import  ==>> 67 68 69 70 

instanceof  ==>> 412 

int  ==>> 18 

interface  ==>> 184 217 

long  ==>> 19 

native  ==>> 151 

new  ==>> 354 355 358 359 360 361 

null  ==>> 351 

package  ==>> 62 

private  ==>> 82 120 146 170 190 

protected  ==>> 81 119 145 169 189 

public  ==>> 80 118 144 168 188 208 215 

return  ==>> 323 

short  ==>> 17 

static  ==>> 69 70 84 121 148 161 192 209 

strictfp  ==>> 86 152 193 

super  ==>> 46 173 174 368 369 372 373 

switch  ==>> 297 

synchronized  ==>> 150 325 

this  ==>> 172 337 338 

throw  ==>> 324 

throws  ==>> 153 

transient  ==>> 123 

true  ==>> 352 

try  ==>> 326 327 

void  ==>> 128 336 

volatile  ==>> 124 

while  ==>> 308 309 310 



 IBM LALR Parser Generator              2.0.17 (May 18 2009)


First map for non-terminals:


'$accept'  ==>> ClassBodyDeclarationsoptMarker LPGUserActionMarker SEMICOLON AT 
    abstract class enum final import interface package private protected public 
    static strictfp EOF_TOKEN 

Commaopt  ==>> '$empty' COMMA 

Ellipsisopt  ==>> '$empty' ELLIPSIS 

CompilationUnit  ==>> '$empty' ClassBodyDeclarationsoptMarker 
    LPGUserActionMarker SEMICOLON AT abstract class enum final import interface 
    package private protected public static strictfp 

ClassBodyDeclarationsopt  ==>> '$empty' SEMICOLON AT LBRACE LESS abstract 
    boolean byte char class double enum final float int interface long native 
    private protected public short static strictfp synchronized transient void 
    volatile IDENTIFIER 

LPGUserAction  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE PLUS_PLUS BeginAction BeginJava NoAction NullAction BadAction 
    abstract assert boolean break byte char class continue do double enum false 
    final float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    IDENTIFIER 

identifier  ==>> IDENTIFIER 

BlockStatementsopt  ==>> '$empty' IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON AT LBRACE PLUS_PLUS abstract assert boolean 
    break byte char class continue do double enum false final float for if int 
    long new null private protected public return short static strictfp super 
    switch synchronized this throw true try void while IDENTIFIER 

Type  ==>> boolean byte char double float int long short IDENTIFIER 

PrimitiveType  ==>> boolean byte char double float int long short 

ReferenceType  ==>> boolean byte char double float int long short IDENTIFIER 

NumericType  ==>> byte char double float int long short 

IntegralType  ==>> byte char int long short 

FloatingPointType  ==>> double float 

ClassOrInterfaceType  ==>> IDENTIFIER 

TypeVariable  ==>> IDENTIFIER 

ArrayType  ==>> boolean byte char double float int long short IDENTIFIER 

ClassType  ==>> IDENTIFIER 

TypeName  ==>> IDENTIFIER 

TypeArgumentsopt  ==>> '$empty' LESS 

InterfaceType  ==>> IDENTIFIER 

ClassName  ==>> IDENTIFIER 

TypeParameter  ==>> IDENTIFIER 

TypeBoundopt  ==>> '$empty' extends 

TypeBound  ==>> extends 

AdditionalBoundListopt  ==>> '$empty' AND 

AdditionalBoundList  ==>> AND 

AdditionalBound  ==>> AND 

TypeArguments  ==>> LESS 

ActualTypeArgumentList  ==>> QUESTION boolean byte char double float int long 
    short IDENTIFIER 

ActualTypeArgument  ==>> QUESTION boolean byte char double float int long short 
    IDENTIFIER 

Wildcard  ==>> QUESTION 

WildcardBoundsOpt  ==>> '$empty' extends super 

WildcardBounds  ==>> extends super 

PackageName  ==>> IDENTIFIER 

ExpressionName  ==>> IDENTIFIER 

AmbiguousName  ==>> IDENTIFIER 

MethodName  ==>> IDENTIFIER 

PackageOrTypeName  ==>> IDENTIFIER 

PackageDeclarationopt  ==>> '$empty' AT package 

ImportDeclarationsopt  ==>> '$empty' import 

TypeDeclarationsopt  ==>> '$empty' SEMICOLON AT abstract class enum final 
    interface private protected public static strictfp 

ImportDeclarations  ==>> import 

ImportDeclaration  ==>> import 

TypeDeclarations  ==>> SEMICOLON AT abstract class enum final interface private 
    protected public static strictfp 

TypeDeclaration  ==>> SEMICOLON AT abstract class enum final interface private 
    protected public static strictfp 

PackageDeclaration  ==>> AT package 

Annotationsopt  ==>> '$empty' AT 

SingleTypeImportDeclaration  ==>> import 

TypeImportOnDemandDeclaration  ==>> import 

SingleStaticImportDeclaration  ==>> import 

StaticImportOnDemandDeclaration  ==>> import 

ClassDeclaration  ==>> AT abstract class enum final private protected public 
    static strictfp 

InterfaceDeclaration  ==>> AT abstract interface private protected public 
    static strictfp 

NormalClassDeclaration  ==>> AT abstract class final private protected public 
    static strictfp 

EnumDeclaration  ==>> AT abstract enum final private protected public static 
    strictfp 

ClassModifiersopt  ==>> '$empty' AT abstract final private protected public 
    static strictfp 

TypeParametersopt  ==>> '$empty' LESS 

Superopt  ==>> '$empty' extends 

Interfacesopt  ==>> '$empty' implements 

ClassBody  ==>> LBRACE 

ClassModifiers  ==>> AT abstract final private protected public static strictfp 

ClassModifier  ==>> AT abstract final private protected public static strictfp 

Annotation  ==>> AT 

TypeParameters  ==>> LESS 

TypeParameterList  ==>> IDENTIFIER 

Super  ==>> extends 

Interfaces  ==>> implements 

InterfaceTypeList  ==>> IDENTIFIER 

ClassBodyDeclarations  ==>> SEMICOLON AT LBRACE LESS abstract boolean byte char 
    class double enum final float int interface long native private protected 
    public short static strictfp synchronized transient void volatile 
    IDENTIFIER 

ClassBodyDeclaration  ==>> SEMICOLON AT LBRACE LESS abstract boolean byte char 
    class double enum final float int interface long native private protected 
    public short static strictfp synchronized transient void volatile 
    IDENTIFIER 

ClassMemberDeclaration  ==>> SEMICOLON AT LESS abstract boolean byte char class 
    double enum final float int interface long native private protected public 
    short static strictfp synchronized transient void volatile IDENTIFIER 

InstanceInitializer  ==>> LBRACE 

StaticInitializer  ==>> static 

ConstructorDeclaration  ==>> AT LESS private protected public IDENTIFIER 

FieldDeclaration  ==>> AT boolean byte char double final float int long private 
    protected public short static transient volatile IDENTIFIER 

MethodDeclaration  ==>> AT LESS abstract boolean byte char double final float 
    int long native private protected public short static strictfp synchronized 
    void IDENTIFIER 

FieldModifiersopt  ==>> '$empty' AT final private protected public static 
    transient volatile 

VariableDeclarators  ==>> IDENTIFIER 

VariableDeclarator  ==>> IDENTIFIER 

VariableDeclaratorId  ==>> IDENTIFIER 

VariableInitializer  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long 
    new null short super this true void IDENTIFIER 

Expression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN TWIDDLE PLUS 
    PLUS_PLUS boolean byte char double false float int long new null short 
    super this true void IDENTIFIER 

ArrayInitializer  ==>> LBRACE 

FieldModifiers  ==>> AT final private protected public static transient 
    volatile 

FieldModifier  ==>> AT final private protected public static transient volatile 

MethodHeader  ==>> AT LESS abstract boolean byte char double final float int 
    long native private protected public short static strictfp synchronized 
    void IDENTIFIER 

MethodBody  ==>> SEMICOLON LBRACE 

MethodModifiersopt  ==>> '$empty' AT abstract final native private protected 
    public static strictfp synchronized 

ResultType  ==>> boolean byte char double float int long short void IDENTIFIER 

MethodDeclarator  ==>> IDENTIFIER 

Throwsopt  ==>> '$empty' throws 

FormalParameterListopt  ==>> '$empty' AT boolean byte char double final float 
    int long short IDENTIFIER 

FormalParameterList  ==>> AT boolean byte char double final float int long 
    short IDENTIFIER 

LastFormalParameter  ==>> AT boolean byte char double final float int long 
    short IDENTIFIER 

FormalParameters  ==>> AT boolean byte char double final float int long short 
    IDENTIFIER 

FormalParameter  ==>> AT boolean byte char double final float int long short 
    IDENTIFIER 

VariableModifiersopt  ==>> '$empty' AT final 

VariableModifiers  ==>> AT final 

VariableModifier  ==>> AT final 

Annotations  ==>> AT 

MethodModifiers  ==>> AT abstract final native private protected public static 
    strictfp synchronized 

MethodModifier  ==>> AT abstract final native private protected public static 
    strictfp synchronized 

Throws  ==>> throws 

ExceptionTypeList  ==>> IDENTIFIER 

ExceptionType  ==>> IDENTIFIER 

Block  ==>> LBRACE 

ConstructorModifiersopt  ==>> '$empty' AT private protected public 

ConstructorDeclarator  ==>> LESS IDENTIFIER 

ConstructorBody  ==>> LBRACE 

SimpleTypeName  ==>> IDENTIFIER 

ConstructorModifiers  ==>> AT private protected public 

ConstructorModifier  ==>> AT private protected public 

ExplicitConstructorInvocationopt  ==>> '$empty' IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral LPAREN 
    LESS boolean byte char double false float int long new null short super 
    this true void IDENTIFIER 

ExplicitConstructorInvocation  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral LPAREN 
    LESS boolean byte char double false float int long new null short super 
    this true void IDENTIFIER 

ArgumentListopt  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

Primary  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral LPAREN boolean byte char double false float 
    int long new null short super this true void IDENTIFIER 

EnumBody  ==>> LBRACE 

EnumConstantsopt  ==>> '$empty' AT IDENTIFIER 

EnumBodyDeclarationsopt  ==>> '$empty' SEMICOLON 

EnumConstants  ==>> AT IDENTIFIER 

EnumConstant  ==>> AT IDENTIFIER 

Argumentsopt  ==>> '$empty' LPAREN 

ClassBodyopt  ==>> '$empty' LBRACE 

Arguments  ==>> LPAREN 

EnumBodyDeclarations  ==>> SEMICOLON 

NormalInterfaceDeclaration  ==>> AT abstract interface private protected public 
    static strictfp 

AnnotationTypeDeclaration  ==>> AT abstract private protected public static 
    strictfp 

InterfaceModifiersopt  ==>> '$empty' AT abstract private protected public 
    static strictfp 

ExtendsInterfacesopt  ==>> '$empty' extends 

InterfaceBody  ==>> LBRACE 

InterfaceModifiers  ==>> AT abstract private protected public static strictfp 

InterfaceModifier  ==>> AT abstract private protected public static strictfp 

ExtendsInterfaces  ==>> extends 

InterfaceMemberDeclarationsopt  ==>> '$empty' SEMICOLON AT LESS abstract 
    boolean byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

InterfaceMemberDeclarations  ==>> SEMICOLON AT LESS abstract boolean byte char 
    class double enum final float int interface long private protected public 
    short static strictfp void IDENTIFIER 

InterfaceMemberDeclaration  ==>> SEMICOLON AT LESS abstract boolean byte char 
    class double enum final float int interface long private protected public 
    short static strictfp void IDENTIFIER 

ConstantDeclaration  ==>> AT boolean byte char double final float int long 
    public short static IDENTIFIER 

AbstractMethodDeclaration  ==>> AT LESS abstract boolean byte char double float 
    int long public short void IDENTIFIER 

ConstantModifiersopt  ==>> '$empty' AT final public static 

ConstantModifiers  ==>> AT final public static 

ConstantModifier  ==>> AT final public static 

AbstractMethodModifiersopt  ==>> '$empty' AT abstract public 

AbstractMethodModifiers  ==>> AT abstract public 

AbstractMethodModifier  ==>> AT abstract public 

AnnotationTypeBody  ==>> LBRACE 

AnnotationTypeElementDeclarationsopt  ==>> '$empty' SEMICOLON AT abstract 
    boolean byte char class double enum final float int interface long private 
    protected public short static strictfp IDENTIFIER 

AnnotationTypeElementDeclarations  ==>> SEMICOLON AT abstract boolean byte char 
    class double enum final float int interface long private protected public 
    short static strictfp IDENTIFIER 

AnnotationTypeElementDeclaration  ==>> SEMICOLON AT abstract boolean byte char 
    class double enum final float int interface long private protected public 
    short static strictfp IDENTIFIER 

DefaultValueopt  ==>> '$empty' default 

DefaultValue  ==>> default 

ElementValue  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    AT LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int 
    long new null short super this true void IDENTIFIER 

NormalAnnotation  ==>> AT 

MarkerAnnotation  ==>> AT 

SingleElementAnnotation  ==>> AT 

ElementValuePairsopt  ==>> '$empty' IDENTIFIER 

ElementValuePairs  ==>> IDENTIFIER 

ElementValuePair  ==>> IDENTIFIER 

SimpleName  ==>> IDENTIFIER 

ConditionalExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ElementValueArrayInitializer  ==>> LBRACE 

ElementValuesopt  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    AT LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int 
    long new null short super this true void IDENTIFIER 

ElementValues  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    AT LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int 
    long new null short super this true void IDENTIFIER 

VariableInitializersopt  ==>> '$empty' IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS MINUS NOT LPAREN LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte 
    char double false float int long new null short super this true void 
    IDENTIFIER 

VariableInitializers  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    LBRACE TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long 
    new null short super this true void IDENTIFIER 

BlockStatements  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE PLUS_PLUS abstract assert boolean break byte char class continue 
    do double enum false final float for if int long new null private protected 
    public return short static strictfp super switch synchronized this throw 
    true try void while IDENTIFIER 

BlockStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE PLUS_PLUS abstract assert boolean break byte char class continue 
    do double enum false final float for if int long new null private protected 
    public return short static strictfp super switch synchronized this throw 
    true try void while IDENTIFIER 

LocalVariableDeclarationStatement  ==>> AT boolean byte char double final float 
    int long short IDENTIFIER 

Statement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON LBRACE 
    PLUS_PLUS assert boolean break byte char continue do double false float for 
    if int long new null return short super switch synchronized this throw true 
    try void while IDENTIFIER 

LocalVariableDeclaration  ==>> AT boolean byte char double final float int long 
    short IDENTIFIER 

StatementWithoutTrailingSubstatement  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON LBRACE PLUS_PLUS assert boolean break byte 
    char continue do double false float int long new null return short super 
    switch synchronized this throw true try void IDENTIFIER 

LabeledStatement  ==>> IDENTIFIER 

IfThenStatement  ==>> if 

IfThenElseStatement  ==>> if 

WhileStatement  ==>> while 

ForStatement  ==>> for 

EmptyStatement  ==>> SEMICOLON 

ExpressionStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN PLUS_PLUS 
    boolean byte char double false float int long new null short super this 
    true void IDENTIFIER 

AssertStatement  ==>> assert 

SwitchStatement  ==>> switch 

DoStatement  ==>> do 

BreakStatement  ==>> break 

ContinueStatement  ==>> continue 

ReturnStatement  ==>> return 

SynchronizedStatement  ==>> synchronized 

ThrowStatement  ==>> throw 

TryStatement  ==>> try 

StatementNoShortIf  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    LBRACE PLUS_PLUS assert boolean break byte char continue do double false 
    float for if int long new null return short super switch synchronized this 
    throw true try void while IDENTIFIER 

LabeledStatementNoShortIf  ==>> IDENTIFIER 

IfThenElseStatementNoShortIf  ==>> if 

WhileStatementNoShortIf  ==>> while 

ForStatementNoShortIf  ==>> for 

StatementExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN PLUS_PLUS 
    boolean byte char double false float int long new null short super this 
    true void IDENTIFIER 

Assignment  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral LPAREN boolean byte char double false float 
    int long new null short super this true void IDENTIFIER 

PreIncrementExpression  ==>> PLUS_PLUS 

PreDecrementExpression  ==>> MINUS_MINUS 

PostIncrementExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

PostDecrementExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

MethodInvocation  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

ClassInstanceCreationExpression  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral LPAREN 
    boolean byte char double false float int long new null short super this 
    true void IDENTIFIER 

SwitchBlock  ==>> LBRACE 

SwitchBlockStatementGroupsopt  ==>> '$empty' case default 

SwitchLabelsopt  ==>> '$empty' case default 

SwitchBlockStatementGroups  ==>> case default 

SwitchBlockStatementGroup  ==>> case default 

SwitchLabels  ==>> case default 

SwitchLabel  ==>> case default 

ConstantExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

BasicForStatement  ==>> for 

EnhancedForStatement  ==>> for 

ForInitopt  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN AT 
    PLUS_PLUS boolean byte char double false final float int long new null 
    short super this true void IDENTIFIER 

Expressionopt  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ForUpdateopt  ==>> '$empty' IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN PLUS_PLUS 
    boolean byte char double false float int long new null short super this 
    true void IDENTIFIER 

ForInit  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN AT PLUS_PLUS boolean byte 
    char double false final float int long new null short super this true void 
    IDENTIFIER 

StatementExpressionList  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN PLUS_PLUS 
    boolean byte char double false float int long new null short super this 
    true void IDENTIFIER 

ForUpdate  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN PLUS_PLUS boolean byte 
    char double false float int long new null short super this true void 
    IDENTIFIER 

identifieropt  ==>> '$empty' IDENTIFIER 

Catches  ==>> catch 

Catchesopt  ==>> '$empty' catch 

Finally  ==>> finally 

CatchClause  ==>> catch 

PrimaryNoNewArray  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

ArrayCreationExpression  ==>> new 

Literal  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral false null true 

FieldAccess  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral LPAREN boolean byte char double false float 
    int long new null short super this true void IDENTIFIER 

ArrayAccess  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral LPAREN boolean byte char double false float 
    int long new null short super this true void IDENTIFIER 

BooleanLiteral  ==>> false true 

ArgumentList  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

DimExprs  ==>> LBRACKET 

Dimsopt  ==>> '$empty' LBRACKET 

Dims  ==>> LBRACKET 

DimExpr  ==>> LBRACKET 

PostfixExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

UnaryExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

UnaryExpressionNotPlusMinus  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral NOT 
    LPAREN TWIDDLE boolean byte char double false float int long new null short 
    super this true void IDENTIFIER 

CastExpression  ==>> LPAREN 

MultiplicativeExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

AdditiveExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ShiftExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

RelationalExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

EqualityExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

AndExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ExclusiveOrExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

InclusiveOrExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ConditionalAndExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

ConditionalOrExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

AssignmentExpression  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 

LeftHandSide  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral LPAREN boolean byte char 
    double false float int long new null short super this true void IDENTIFIER 

AssignmentOperator  ==>> MINUS_EQUAL REMAINDER_EQUAL AND_EQUAL MULTIPLY_EQUAL 
    DIVIDE_EQUAL XOR_EQUAL OR_EQUAL PLUS_EQUAL LEFT_SHIFT_EQUAL EQUAL GREATER 


 IBM LALR Parser Generator              2.0.17 (May 18 2009)


Follow Map:


'$accept'  ==>> EOF_TOKEN 

Commaopt  ==>> SEMICOLON RBRACE 

Ellipsisopt  ==>> IDENTIFIER 

CompilationUnit  ==>> EOF_TOKEN 

ClassBodyDeclarationsopt  ==>> RBRACE EOF_TOKEN 

LPGUserAction  ==>> EOF_TOKEN 

identifier  ==>> MINUS_MINUS OR MINUS MINUS_EQUAL NOT_EQUAL REMAINDER 
    REMAINDER_EQUAL AND AND_AND AND_EQUAL LPAREN RPAREN MULTIPLY 
    MULTIPLY_EQUAL COMMA DOT DIVIDE DIVIDE_EQUAL COLON SEMICOLON QUESTION AT 
    LBRACKET RBRACKET XOR XOR_EQUAL LBRACE OR_OR OR_EQUAL RBRACE PLUS 
    PLUS_PLUS PLUS_EQUAL LESS LEFT_SHIFT LEFT_SHIFT_EQUAL LESS_EQUAL EQUAL 
    EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class double enum 
    extends final float implements instanceof int interface long native 
    package private protected public short static strictfp synchronized 
    transient void volatile IDENTIFIER 

BlockStatementsopt  ==>> RBRACE EndAction EndJava EOF_TOKEN 

Type  ==>> DOT LBRACKET ELLIPSIS IDENTIFIER 

PrimitiveType  ==>> RPAREN DOT LBRACKET ELLIPSIS IDENTIFIER 

ReferenceType  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA DOT COLON SEMICOLON 
    QUESTION AT LBRACKET RBRACKET XOR OR_OR RBRACE LESS LESS_EQUAL EQUAL_EQUAL 
    GREATER ELLIPSIS abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

NumericType  ==>> RPAREN DOT LBRACKET ELLIPSIS IDENTIFIER 

IntegralType  ==>> RPAREN DOT LBRACKET ELLIPSIS IDENTIFIER 

FloatingPointType  ==>> RPAREN DOT LBRACKET ELLIPSIS IDENTIFIER 

ClassOrInterfaceType  ==>> OR NOT_EQUAL AND AND_AND LPAREN RPAREN COMMA DOT 
    COLON SEMICOLON QUESTION AT LBRACKET RBRACKET XOR OR_OR RBRACE LESS 
    LESS_EQUAL EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class 
    double enum final float instanceof int interface long private protected 
    public short static strictfp void IDENTIFIER 

TypeVariable  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA DOT COLON SEMICOLON 
    QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE LESS LESS_EQUAL 
    EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class double enum 
    extends final float instanceof int interface long private protected public 
    short static strictfp void IDENTIFIER 

ArrayType  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA DOT COLON SEMICOLON 
    QUESTION AT LBRACKET RBRACKET XOR OR_OR RBRACE LESS LESS_EQUAL EQUAL_EQUAL 
    GREATER ELLIPSIS abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

ClassType  ==>> OR NOT_EQUAL AND AND_AND LPAREN RPAREN COMMA DOT COLON 
    SEMICOLON QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE LESS 
    LESS_EQUAL EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class 
    double enum final float implements instanceof int interface long private 
    protected public short static strictfp void IDENTIFIER 

TypeName  ==>> OR NOT_EQUAL AND AND_AND LPAREN RPAREN COMMA DOT COLON 
    SEMICOLON QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE LESS 
    LESS_EQUAL EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class 
    double enum final float implements instanceof int interface long native 
    package private protected public short static strictfp synchronized 
    transient void volatile IDENTIFIER 

TypeArgumentsopt  ==>> OR NOT_EQUAL AND AND_AND LPAREN RPAREN COMMA DOT COLON 
    SEMICOLON QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE LESS 
    LESS_EQUAL EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class 
    double enum final float implements instanceof int interface long private 
    protected public short static strictfp super this void IDENTIFIER 

InterfaceType  ==>> AND COMMA LBRACE GREATER 

ClassName  ==>> DOT 

TypeParameter  ==>> COMMA GREATER 

TypeBoundopt  ==>> COMMA GREATER 

TypeBound  ==>> COMMA GREATER 

AdditionalBoundListopt  ==>> COMMA GREATER 

AdditionalBoundList  ==>> AND COMMA GREATER 

AdditionalBound  ==>> AND COMMA GREATER 

TypeArguments  ==>> OR NOT_EQUAL AND AND_AND LPAREN RPAREN COMMA DOT COLON 
    SEMICOLON QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE LESS 
    LESS_EQUAL EQUAL_EQUAL GREATER ELLIPSIS abstract boolean byte char class 
    double enum final float implements instanceof int interface long private 
    protected public short static strictfp super this void IDENTIFIER 

ActualTypeArgumentList  ==>> COMMA GREATER 

ActualTypeArgument  ==>> COMMA GREATER 

Wildcard  ==>> COMMA GREATER 

WildcardBoundsOpt  ==>> COMMA GREATER 

WildcardBounds  ==>> COMMA GREATER 

PackageName  ==>> DOT SEMICOLON 

ExpressionName  ==>> MINUS_MINUS OR MINUS MINUS_EQUAL NOT_EQUAL REMAINDER 
    REMAINDER_EQUAL AND AND_AND AND_EQUAL RPAREN MULTIPLY MULTIPLY_EQUAL COMMA 
    DIVIDE DIVIDE_EQUAL COLON SEMICOLON QUESTION AT LBRACKET RBRACKET XOR 
    XOR_EQUAL OR_OR OR_EQUAL RBRACE PLUS PLUS_PLUS PLUS_EQUAL LESS LEFT_SHIFT 
    LEFT_SHIFT_EQUAL LESS_EQUAL EQUAL EQUAL_EQUAL GREATER abstract boolean 
    byte char class double enum final float instanceof int interface long 
    private protected public short static strictfp void IDENTIFIER 

AmbiguousName  ==>> DOT 

MethodName  ==>> LPAREN 

PackageOrTypeName  ==>> DOT 

PackageDeclarationopt  ==>> SEMICOLON AT abstract class enum final import 
    interface private protected public static strictfp EOF_TOKEN 

ImportDeclarationsopt  ==>> SEMICOLON AT abstract class enum final interface 
    private protected public static strictfp EOF_TOKEN 

TypeDeclarationsopt  ==>> EOF_TOKEN 

ImportDeclarations  ==>> SEMICOLON AT abstract class enum final import 
    interface private protected public static strictfp EOF_TOKEN 

ImportDeclaration  ==>> SEMICOLON AT abstract class enum final import 
    interface private protected public static strictfp EOF_TOKEN 

TypeDeclarations  ==>> SEMICOLON AT abstract class enum final interface 
    private protected public static strictfp EOF_TOKEN 

TypeDeclaration  ==>> SEMICOLON AT abstract class enum final interface private 
    protected public static strictfp EOF_TOKEN 

PackageDeclaration  ==>> SEMICOLON AT abstract class enum final import 
    interface private protected public static strictfp EOF_TOKEN 

Annotationsopt  ==>> package IDENTIFIER 

SingleTypeImportDeclaration  ==>> SEMICOLON AT abstract class enum final 
    import interface private protected public static strictfp EOF_TOKEN 

TypeImportOnDemandDeclaration  ==>> SEMICOLON AT abstract class enum final 
    import interface private protected public static strictfp EOF_TOKEN 

SingleStaticImportDeclaration  ==>> SEMICOLON AT abstract class enum final 
    import interface private protected public static strictfp EOF_TOKEN 

StaticImportOnDemandDeclaration  ==>> SEMICOLON AT abstract class enum final 
    import interface private protected public static strictfp EOF_TOKEN 

ClassDeclaration  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS LESS EndAction EndJava abstract assert boolean 
    break byte case char class continue default do double enum false final 
    float for if int interface long native new null private protected public 
    return short static strictfp super switch synchronized this throw 
    transient true try void volatile while EOF_TOKEN IDENTIFIER 

InterfaceDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

NormalClassDeclaration  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS LESS EndAction EndJava abstract assert boolean 
    break byte case char class continue default do double enum false final 
    float for if int interface long native new null private protected public 
    return short static strictfp super switch synchronized this throw 
    transient true try void volatile while EOF_TOKEN IDENTIFIER 

EnumDeclaration  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS LESS EndAction EndJava abstract assert boolean 
    break byte case char class continue default do double enum false final 
    float for if int interface long native new null private protected public 
    return short static strictfp super switch synchronized this throw 
    transient true try void volatile while EOF_TOKEN IDENTIFIER 

ClassModifiersopt  ==>> class enum 

TypeParametersopt  ==>> LBRACE boolean byte char double extends float 
    implements int long short void IDENTIFIER 

Superopt  ==>> LBRACE implements 

Interfacesopt  ==>> LBRACE 

ClassBody  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER 
    AND AND_AND LPAREN RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON 
    QUESTION AT LBRACKET RBRACKET XOR LBRACE OR_OR RBRACE PLUS PLUS_PLUS LESS 
    LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER EndAction EndJava abstract 
    assert boolean break byte case char class continue default do double enum 
    false final float for if instanceof int interface long native new null 
    private protected public return short static strictfp super switch 
    synchronized this throw transient true try void volatile while EOF_TOKEN 
    IDENTIFIER 

ClassModifiers  ==>> AT abstract class enum final private protected public 
    static strictfp 

ClassModifier  ==>> AT abstract class enum final private protected public 
    static strictfp 

Annotation  ==>> RPAREN COMMA SEMICOLON AT RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native package 
    private protected public short static strictfp synchronized transient void 
    volatile IDENTIFIER 

TypeParameters  ==>> LBRACE boolean byte char double extends float implements 
    int long short void IDENTIFIER 

TypeParameterList  ==>> COMMA GREATER 

Super  ==>> LBRACE implements 

Interfaces  ==>> LBRACE 

InterfaceTypeList  ==>> COMMA LBRACE 

ClassBodyDeclarations  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

ClassBodyDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

ClassMemberDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

InstanceInitializer  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

StaticInitializer  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

ConstructorDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

FieldDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

MethodDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

FieldModifiersopt  ==>> boolean byte char double float int long short 
    IDENTIFIER 

VariableDeclarators  ==>> COMMA SEMICOLON AT RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long private protected 
    public short static strictfp void IDENTIFIER 

VariableDeclarator  ==>> COMMA SEMICOLON AT RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long private protected 
    public short static strictfp void IDENTIFIER 

VariableDeclaratorId  ==>> RPAREN COMMA COLON SEMICOLON AT LBRACKET RBRACE 
    LESS EQUAL abstract boolean byte char class double enum final float int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

VariableInitializer  ==>> COMMA SEMICOLON AT RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long private protected 
    public short static strictfp void IDENTIFIER 

Expression  ==>> RPAREN COMMA COLON SEMICOLON AT RBRACKET RBRACE LESS abstract 
    boolean byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

ArrayInitializer  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR 
    OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER 
    abstract boolean byte char class double enum final float instanceof int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

FieldModifiers  ==>> AT boolean byte char double final float int long private 
    protected public short static transient volatile IDENTIFIER 

FieldModifier  ==>> AT boolean byte char double final float int long private 
    protected public short static transient volatile IDENTIFIER 

MethodHeader  ==>> SEMICOLON LBRACE 

MethodBody  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte char 
    class double enum final float int interface long native private protected 
    public short static strictfp synchronized transient void volatile 
    EOF_TOKEN IDENTIFIER 

MethodModifiersopt  ==>> LESS boolean byte char double float int long short 
    void IDENTIFIER 

ResultType  ==>> IDENTIFIER 

MethodDeclarator  ==>> SEMICOLON LBRACKET LBRACE throws 

Throwsopt  ==>> SEMICOLON LBRACE 

FormalParameterListopt  ==>> RPAREN 

FormalParameterList  ==>> RPAREN 

LastFormalParameter  ==>> RPAREN 

FormalParameters  ==>> COMMA 

FormalParameter  ==>> RPAREN COMMA COLON 

VariableModifiersopt  ==>> boolean byte char double float int long short 
    IDENTIFIER 

VariableModifiers  ==>> AT boolean byte char double final float int long short 
    IDENTIFIER 

VariableModifier  ==>> AT boolean byte char double final float int long short 
    IDENTIFIER 

Annotations  ==>> AT LESS abstract boolean byte char double final float int 
    long native package private protected public short static strictfp 
    synchronized void IDENTIFIER 

MethodModifiers  ==>> AT LESS abstract boolean byte char double final float 
    int long native private protected public short static strictfp 
    synchronized void IDENTIFIER 

MethodModifier  ==>> AT LESS abstract boolean byte char double final float int 
    long native private protected public short static strictfp synchronized 
    void IDENTIFIER 

Throws  ==>> SEMICOLON LBRACE 

ExceptionTypeList  ==>> COMMA SEMICOLON LBRACE 

ExceptionType  ==>> COMMA SEMICOLON LBRACE 

Block  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON AT LBRACE 
    RBRACE PLUS_PLUS LESS EndAction EndJava abstract assert boolean break byte 
    case catch char class continue default do double enum else false final 
    finally float for if int interface long native new null private protected 
    public return short static strictfp super switch synchronized this throw 
    transient true try void volatile while EOF_TOKEN IDENTIFIER 

ConstructorModifiersopt  ==>> LESS IDENTIFIER 

ConstructorDeclarator  ==>> LBRACE throws 

ConstructorBody  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

SimpleTypeName  ==>> LPAREN 

ConstructorModifiers  ==>> AT LESS private protected public IDENTIFIER 

ConstructorModifier  ==>> AT LESS private protected public IDENTIFIER 

ExplicitConstructorInvocationopt  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON AT LBRACE RBRACE PLUS_PLUS abstract assert 
    boolean break byte char class continue do double enum false final float 
    for if int long new null private protected public return short static 
    strictfp super switch synchronized this throw true try void while 
    IDENTIFIER 

ExplicitConstructorInvocation  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON AT LBRACE RBRACE PLUS_PLUS abstract assert 
    boolean break byte char class continue do double enum false final float 
    for if int long new null private protected public return short static 
    strictfp super switch synchronized this throw true try void while 
    IDENTIFIER 

ArgumentListopt  ==>> RPAREN 

Primary  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR 
    RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER 
    abstract boolean byte char class double enum final float instanceof int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

EnumBody  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON AT LBRACE 
    RBRACE PLUS_PLUS LESS EndAction EndJava abstract assert boolean break byte 
    case char class continue default do double enum false final float for if 
    int interface long native new null private protected public return short 
    static strictfp super switch synchronized this throw transient true try 
    void volatile while EOF_TOKEN IDENTIFIER 

EnumConstantsopt  ==>> COMMA SEMICOLON RBRACE 

EnumBodyDeclarationsopt  ==>> RBRACE 

EnumConstants  ==>> COMMA SEMICOLON RBRACE 

EnumConstant  ==>> COMMA COLON SEMICOLON RBRACE 

Argumentsopt  ==>> COMMA COLON SEMICOLON LBRACE RBRACE 

ClassBodyopt  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

Arguments  ==>> COMMA COLON SEMICOLON LBRACE RBRACE 

EnumBodyDeclarations  ==>> RBRACE 

NormalInterfaceDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract 
    boolean byte char class double enum final float int interface long native 
    private protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

AnnotationTypeDeclaration  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract 
    boolean byte char class double enum final float int interface long native 
    private protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

InterfaceModifiersopt  ==>> AT interface 

ExtendsInterfacesopt  ==>> LBRACE 

InterfaceBody  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte char 
    class double enum final float int interface long native private protected 
    public short static strictfp synchronized transient void volatile 
    EOF_TOKEN IDENTIFIER 

InterfaceModifiers  ==>> AT abstract interface private protected public static 
    strictfp 

InterfaceModifier  ==>> AT abstract interface private protected public static 
    strictfp 

ExtendsInterfaces  ==>> COMMA LBRACE 

InterfaceMemberDeclarationsopt  ==>> RBRACE 

InterfaceMemberDeclarations  ==>> SEMICOLON AT RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

InterfaceMemberDeclaration  ==>> SEMICOLON AT RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

ConstantDeclaration  ==>> SEMICOLON AT RBRACE LESS abstract boolean byte char 
    class double enum final float int interface long private protected public 
    short static strictfp void IDENTIFIER 

AbstractMethodDeclaration  ==>> SEMICOLON AT RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long private protected 
    public short static strictfp void IDENTIFIER 

ConstantModifiersopt  ==>> boolean byte char double float int long short 
    IDENTIFIER 

ConstantModifiers  ==>> AT boolean byte char double final float int long 
    public short static IDENTIFIER 

ConstantModifier  ==>> AT boolean byte char double final float int long public 
    short static IDENTIFIER 

AbstractMethodModifiersopt  ==>> LESS boolean byte char double float int long 
    short void IDENTIFIER 

AbstractMethodModifiers  ==>> AT LESS abstract boolean byte char double float 
    int long public short void IDENTIFIER 

AbstractMethodModifier  ==>> AT LESS abstract boolean byte char double float 
    int long public short void IDENTIFIER 

AnnotationTypeBody  ==>> SEMICOLON AT LBRACE RBRACE LESS abstract boolean byte 
    char class double enum final float int interface long native private 
    protected public short static strictfp synchronized transient void 
    volatile EOF_TOKEN IDENTIFIER 

AnnotationTypeElementDeclarationsopt  ==>> RBRACE 

AnnotationTypeElementDeclarations  ==>> SEMICOLON AT RBRACE abstract boolean 
    byte char class double enum final float int interface long private 
    protected public short static strictfp IDENTIFIER 

AnnotationTypeElementDeclaration  ==>> SEMICOLON AT RBRACE abstract boolean 
    byte char class double enum final float int interface long private 
    protected public short static strictfp IDENTIFIER 

DefaultValueopt  ==>> SEMICOLON 

DefaultValue  ==>> SEMICOLON 

ElementValue  ==>> RPAREN COMMA SEMICOLON RBRACE 

NormalAnnotation  ==>> RPAREN COMMA SEMICOLON AT RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native package 
    private protected public short static strictfp synchronized transient void 
    volatile IDENTIFIER 

MarkerAnnotation  ==>> RPAREN COMMA SEMICOLON AT RBRACE LESS abstract boolean 
    byte char class double enum final float int interface long native package 
    private protected public short static strictfp synchronized transient void 
    volatile IDENTIFIER 

SingleElementAnnotation  ==>> RPAREN COMMA SEMICOLON AT RBRACE LESS abstract 
    boolean byte char class double enum final float int interface long native 
    package private protected public short static strictfp synchronized 
    transient void volatile IDENTIFIER 

ElementValuePairsopt  ==>> RPAREN 

ElementValuePairs  ==>> RPAREN COMMA 

ElementValuePair  ==>> RPAREN COMMA 

SimpleName  ==>> EQUAL 

ConditionalExpression  ==>> RPAREN COMMA COLON SEMICOLON AT RBRACKET RBRACE 
    LESS abstract boolean byte char class double enum final float int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

ElementValueArrayInitializer  ==>> RPAREN COMMA SEMICOLON RBRACE 

ElementValuesopt  ==>> COMMA RBRACE 

ElementValues  ==>> COMMA RBRACE 

VariableInitializersopt  ==>> COMMA RBRACE 

VariableInitializers  ==>> COMMA RBRACE 

BlockStatements  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

BlockStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

LocalVariableDeclarationStatement  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON AT LBRACE RBRACE PLUS_PLUS EndAction EndJava 
    abstract assert boolean break byte case char class continue default do 
    double enum false final float for if int long new null private protected 
    public return short static strictfp super switch synchronized this throw 
    true try void while EOF_TOKEN IDENTIFIER 

Statement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON AT LBRACE 
    RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break byte case 
    char class continue default do double enum false final float for if int 
    long new null private protected public return short static strictfp super 
    switch synchronized this throw true try void while EOF_TOKEN IDENTIFIER 

LocalVariableDeclaration  ==>> SEMICOLON 

StatementWithoutTrailingSubstatement  ==>> IntegerLiteral LongLiteral 
    FloatingPointLiteral DoubleLiteral CharacterLiteral StringLiteral 
    MINUS_MINUS LPAREN SEMICOLON AT LBRACE RBRACE PLUS_PLUS EndAction EndJava 
    abstract assert boolean break byte case char class continue default do 
    double enum else false final float for if int long new null private 
    protected public return short static strictfp super switch synchronized 
    this throw true try void while EOF_TOKEN IDENTIFIER 

LabeledStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

IfThenStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

IfThenElseStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

WhileStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

ForStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

EmptyStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

ExpressionStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

AssertStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

SwitchStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

DoStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

BreakStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

ContinueStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

ReturnStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

SynchronizedStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

ThrowStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

TryStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

StatementNoShortIf  ==>> else 

LabeledStatementNoShortIf  ==>> else 

IfThenElseStatementNoShortIf  ==>> else 

WhileStatementNoShortIf  ==>> else 

ForStatementNoShortIf  ==>> else 

StatementExpression  ==>> RPAREN COMMA SEMICOLON 

Assignment  ==>> RPAREN COMMA COLON SEMICOLON AT RBRACKET RBRACE LESS abstract 
    boolean byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

PreIncrementExpression  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR 
    RBRACE PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract 
    boolean byte char class double enum final float instanceof int interface 
    long private protected public short static strictfp void IDENTIFIER 

PreDecrementExpression  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR 
    RBRACE PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract 
    boolean byte char class double enum final float instanceof int interface 
    long private protected public short static strictfp void IDENTIFIER 

PostIncrementExpression  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND 
    AND_AND RPAREN MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

PostDecrementExpression  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND 
    AND_AND RPAREN MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

MethodInvocation  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET 
    RBRACKET XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

ClassInstanceCreationExpression  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER 
    AND AND_AND RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT 
    LBRACKET RBRACKET XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT 
    LESS_EQUAL EQUAL_EQUAL GREATER abstract boolean byte char class double 
    enum final float instanceof int interface long private protected public 
    short static strictfp void IDENTIFIER 

SwitchBlock  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum else false final 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

SwitchBlockStatementGroupsopt  ==>> RBRACE case default 

SwitchLabelsopt  ==>> RBRACE 

SwitchBlockStatementGroups  ==>> RBRACE case default 

SwitchBlockStatementGroup  ==>> RBRACE case default 

SwitchLabels  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS abstract assert boolean break byte case char 
    class continue default do double enum false final float for if int long 
    new null private protected public return short static strictfp super 
    switch synchronized this throw true try void while IDENTIFIER 

SwitchLabel  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS abstract assert boolean break byte case char 
    class continue default do double enum false final float for if int long 
    new null private protected public return short static strictfp super 
    switch synchronized this throw true try void while IDENTIFIER 

ConstantExpression  ==>> COLON 

BasicForStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

EnhancedForStatement  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case char class continue default do double enum false final float for 
    if int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

ForInitopt  ==>> SEMICOLON 

Expressionopt  ==>> SEMICOLON 

ForUpdateopt  ==>> RPAREN 

ForInit  ==>> SEMICOLON 

StatementExpressionList  ==>> RPAREN COMMA SEMICOLON 

ForUpdate  ==>> RPAREN 

identifieropt  ==>> SEMICOLON 

Catches  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON AT LBRACE 
    RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break byte case 
    catch char class continue default do double enum else false final finally 
    float for if int long new null private protected public return short 
    static strictfp super switch synchronized this throw true try void while 
    EOF_TOKEN IDENTIFIER 

Catchesopt  ==>> finally 

Finally  ==>> IntegerLiteral LongLiteral FloatingPointLiteral DoubleLiteral 
    CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON AT LBRACE 
    RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break byte case 
    char class continue default do double enum else false final float for if 
    int long new null private protected public return short static strictfp 
    super switch synchronized this throw true try void while EOF_TOKEN 
    IDENTIFIER 

CatchClause  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS LPAREN SEMICOLON 
    AT LBRACE RBRACE PLUS_PLUS EndAction EndJava abstract assert boolean break 
    byte case catch char class continue default do double enum else false 
    final finally float for if int long new null private protected public 
    return short static strictfp super switch synchronized this throw true try 
    void while EOF_TOKEN IDENTIFIER 

PrimaryNoNewArray  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET 
    RBRACKET XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

ArrayCreationExpression  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND 
    AND_AND RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT 
    RBRACKET XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

Literal  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

FieldAccess  ==>> MINUS_MINUS OR MINUS MINUS_EQUAL NOT_EQUAL REMAINDER 
    REMAINDER_EQUAL AND AND_AND AND_EQUAL RPAREN MULTIPLY MULTIPLY_EQUAL COMMA 
    DOT DIVIDE DIVIDE_EQUAL COLON SEMICOLON QUESTION AT LBRACKET RBRACKET XOR 
    XOR_EQUAL OR_OR OR_EQUAL RBRACE PLUS PLUS_PLUS PLUS_EQUAL LESS LEFT_SHIFT 
    LEFT_SHIFT_EQUAL LESS_EQUAL EQUAL EQUAL_EQUAL GREATER abstract boolean 
    byte char class double enum final float instanceof int interface long 
    private protected public short static strictfp void IDENTIFIER 

ArrayAccess  ==>> MINUS_MINUS OR MINUS MINUS_EQUAL NOT_EQUAL REMAINDER 
    REMAINDER_EQUAL AND AND_AND AND_EQUAL RPAREN MULTIPLY MULTIPLY_EQUAL COMMA 
    DOT DIVIDE DIVIDE_EQUAL COLON SEMICOLON QUESTION AT LBRACKET RBRACKET XOR 
    XOR_EQUAL OR_OR OR_EQUAL RBRACE PLUS PLUS_PLUS PLUS_EQUAL LESS LEFT_SHIFT 
    LEFT_SHIFT_EQUAL LESS_EQUAL EQUAL EQUAL_EQUAL GREATER abstract boolean 
    byte char class double enum final float instanceof int interface long 
    private protected public short static strictfp void IDENTIFIER 

BooleanLiteral  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET 
    RBRACKET XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

ArgumentList  ==>> RPAREN COMMA 

DimExprs  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

Dimsopt  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR 
    RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER 
    abstract boolean byte char class double enum final float instanceof int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

Dims  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET RBRACKET 
    XOR LBRACE OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

DimExpr  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DOT DIVIDE COLON SEMICOLON QUESTION AT LBRACKET RBRACKET 
    XOR OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL 
    GREATER abstract boolean byte char class double enum final float 
    instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

PostfixExpression  ==>> MINUS_MINUS OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR 
    OR_OR RBRACE PLUS PLUS_PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER 
    abstract boolean byte char class double enum final float instanceof int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

UnaryExpression  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN MULTIPLY 
    COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR RBRACE PLUS 
    LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract boolean byte char 
    class double enum final float instanceof int interface long private 
    protected public short static strictfp void IDENTIFIER 

UnaryExpressionNotPlusMinus  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND 
    RPAREN MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR 
    OR_OR RBRACE PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract 
    boolean byte char class double enum final float instanceof int interface 
    long private protected public short static strictfp void IDENTIFIER 

CastExpression  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN MULTIPLY 
    COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR RBRACE PLUS 
    LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract boolean byte char 
    class double enum final float instanceof int interface long private 
    protected public short static strictfp void IDENTIFIER 

MultiplicativeExpression  ==>> OR MINUS NOT_EQUAL REMAINDER AND AND_AND RPAREN 
    MULTIPLY COMMA DIVIDE COLON SEMICOLON QUESTION AT RBRACKET XOR OR_OR 
    RBRACE PLUS LESS LEFT_SHIFT LESS_EQUAL EQUAL_EQUAL GREATER abstract 
    boolean byte char class double enum final float instanceof int interface 
    long private protected public short static strictfp void IDENTIFIER 

AdditiveExpression  ==>> OR MINUS NOT_EQUAL AND AND_AND RPAREN COMMA COLON 
    SEMICOLON QUESTION AT RBRACKET XOR OR_OR RBRACE PLUS LESS LEFT_SHIFT 
    LESS_EQUAL EQUAL_EQUAL GREATER abstract boolean byte char class double 
    enum final float instanceof int interface long private protected public 
    short static strictfp void IDENTIFIER 

ShiftExpression  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA COLON SEMICOLON 
    QUESTION AT RBRACKET XOR OR_OR RBRACE LESS LEFT_SHIFT LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

RelationalExpression  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA COLON 
    SEMICOLON QUESTION AT RBRACKET XOR OR_OR RBRACE LESS LESS_EQUAL 
    EQUAL_EQUAL GREATER abstract boolean byte char class double enum final 
    float instanceof int interface long private protected public short static 
    strictfp void IDENTIFIER 

EqualityExpression  ==>> OR NOT_EQUAL AND AND_AND RPAREN COMMA COLON SEMICOLON 
    QUESTION AT RBRACKET XOR OR_OR RBRACE LESS EQUAL_EQUAL abstract boolean 
    byte char class double enum final float int interface long private 
    protected public short static strictfp void IDENTIFIER 

AndExpression  ==>> OR AND AND_AND RPAREN COMMA COLON SEMICOLON QUESTION AT 
    RBRACKET XOR OR_OR RBRACE LESS abstract boolean byte char class double 
    enum final float int interface long private protected public short static 
    strictfp void IDENTIFIER 

ExclusiveOrExpression  ==>> OR AND_AND RPAREN COMMA COLON SEMICOLON QUESTION 
    AT RBRACKET XOR OR_OR RBRACE LESS abstract boolean byte char class double 
    enum final float int interface long private protected public short static 
    strictfp void IDENTIFIER 

InclusiveOrExpression  ==>> OR AND_AND RPAREN COMMA COLON SEMICOLON QUESTION 
    AT RBRACKET OR_OR RBRACE LESS abstract boolean byte char class double enum 
    final float int interface long private protected public short static 
    strictfp void IDENTIFIER 

ConditionalAndExpression  ==>> AND_AND RPAREN COMMA COLON SEMICOLON QUESTION 
    AT RBRACKET OR_OR RBRACE LESS abstract boolean byte char class double enum 
    final float int interface long private protected public short static 
    strictfp void IDENTIFIER 

ConditionalOrExpression  ==>> RPAREN COMMA COLON SEMICOLON QUESTION AT 
    RBRACKET OR_OR RBRACE LESS abstract boolean byte char class double enum 
    final float int interface long private protected public short static 
    strictfp void IDENTIFIER 

AssignmentExpression  ==>> RPAREN COMMA COLON SEMICOLON AT RBRACKET RBRACE 
    LESS abstract boolean byte char class double enum final float int 
    interface long private protected public short static strictfp void 
    IDENTIFIER 

LeftHandSide  ==>> MINUS_EQUAL REMAINDER_EQUAL AND_EQUAL MULTIPLY_EQUAL 
    DIVIDE_EQUAL XOR_EQUAL OR_EQUAL PLUS_EQUAL LEFT_SHIFT_EQUAL EQUAL GREATER 

AssignmentOperator  ==>> IntegerLiteral LongLiteral FloatingPointLiteral 
    DoubleLiteral CharacterLiteral StringLiteral MINUS_MINUS MINUS NOT LPAREN 
    TWIDDLE PLUS PLUS_PLUS boolean byte char double false float int long new 
    null short super this true void IDENTIFIER 


 IBM LALR Parser Generator              2.0.17 (May 18 2009)


Name map:

'$empty' ::= '$empty'
ClassBodyDeclarationsoptMarker ::= ClassBodyDeclarationsoptMarker
LPGUserActionMarker ::= LPGUserActionMarker
IntegerLiteral ::= IntegerLiteral
LongLiteral ::= LongLiteral
FloatingPointLiteral ::= FloatingPointLiteral
DoubleLiteral ::= DoubleLiteral
CharacterLiteral ::= CharacterLiteral
StringLiteral ::= StringLiteral
MINUS_MINUS ::= --
OR ::= '|'
MINUS ::= -
MINUS_EQUAL ::= -=
NOT ::= !
NOT_EQUAL ::= !=
REMAINDER ::= %
REMAINDER_EQUAL ::= %=
AND ::= &
AND_AND ::= &&
AND_EQUAL ::= &=
LPAREN ::= (
RPAREN ::= )
MULTIPLY ::= *
MULTIPLY_EQUAL ::= *=
COMMA ::= ,
DOT ::= .
DIVIDE ::= /
DIVIDE_EQUAL ::= /=
COLON ::= :
SEMICOLON ::= ;
QUESTION ::= ?
AT ::= @
LBRACKET ::= [
RBRACKET ::= ]
XOR ::= ^
XOR_EQUAL ::= ^=
LBRACE ::= {
OR_OR ::= ||
OR_EQUAL ::= |=
RBRACE ::= }
TWIDDLE ::= ~
PLUS ::= +
PLUS_PLUS ::= ++
PLUS_EQUAL ::= +=
LESS ::= <
LEFT_SHIFT ::= <<
LEFT_SHIFT_EQUAL ::= <<=
LESS_EQUAL ::= <=
EQUAL ::= =
EQUAL_EQUAL ::= ==
GREATER ::= >
GREATER_EQUAL ::= >=
RIGHT_SHIFT ::= >>
RIGHT_SHIFT_EQUAL ::= >>=
UNSIGNED_RIGHT_SHIFT ::= >>>
UNSIGNED_RIGHT_SHIFT_EQUAL ::= >>>=
ELLIPSIS ::= ...
BeginAction ::= '$BeginAction'
EndAction ::= '$EndAction'
BeginJava ::= '$BeginJava'
EndJava ::= '$EndJava'
NoAction ::= '$NoAction'
NullAction ::= '$NullAction'
BadAction ::= '$BadAction'
abstract ::= abstract
assert ::= assert
boolean ::= boolean
break ::= break
byte ::= byte
case ::= case
catch ::= catch
char ::= char
class ::= class
const ::= const
continue ::= continue
default ::= default
do ::= do
double ::= double
enum ::= enum
else ::= else
extends ::= extends
false ::= false
final ::= final
finally ::= finally
float ::= float
for ::= for
goto ::= goto
if ::= if
implements ::= implements
import ::= import
instanceof ::= instanceof
int ::= int
interface ::= interface
long ::= long
native ::= native
new ::= new
null ::= null
package ::= package
private ::= private
protected ::= protected
public ::= public
return ::= return
short ::= short
static ::= static
strictfp ::= strictfp
super ::= super
switch ::= switch
synchronized ::= synchronized
this ::= this
throw ::= throw
throws ::= throws
transient ::= transient
true ::= true
try ::= try
void ::= void
volatile ::= volatile
while ::= while
EOF_TOKEN ::= EOF_TOKEN
IDENTIFIER ::= IDENTIFIER
ERROR_TOKEN ::= ERROR_TOKEN
identifier ::= identifier
Type ::= Type
PrimitiveType ::= PrimitiveType
ReferenceType ::= ReferenceType
ClassOrInterfaceType ::= ClassOrInterfaceType
TypeVariable ::= TypeVariable
ClassType ::= ClassType
TypeName ::= TypeName
InterfaceType ::= InterfaceType
ClassName ::= ClassName
TypeParameter ::= TypeParameter
AdditionalBoundList ::= AdditionalBoundList
AdditionalBound ::= AdditionalBound
TypeArguments ::= TypeArguments
ActualTypeArgumentList ::= ActualTypeArgumentList
ActualTypeArgument ::= ActualTypeArgument
PackageName ::= PackageName
ExpressionName ::= ExpressionName
AmbiguousName ::= AmbiguousName
MethodName ::= MethodName
PackageOrTypeName ::= PackageOrTypeName
ImportDeclarations ::= ImportDeclarations
ImportDeclaration ::= ImportDeclaration
TypeDeclarations ::= TypeDeclarations
TypeDeclaration ::= TypeDeclaration
EnumDeclaration ::= EnumDeclaration
ClassBody ::= ClassBody
ClassModifiers ::= ClassModifiers
ClassModifier ::= ClassModifier
Annotation ::= Annotation
TypeParameterList ::= TypeParameterList
InterfaceTypeList ::= InterfaceTypeList
ClassBodyDeclarations ::= ClassBodyDeclarations
ClassBodyDeclaration ::= ClassBodyDeclaration
VariableDeclarators ::= VariableDeclarators
VariableDeclarator ::= VariableDeclarator
VariableDeclaratorId ::= VariableDeclaratorId
VariableInitializer ::= VariableInitializer
Expression ::= Expression
ArrayInitializer ::= ArrayInitializer
FieldModifiers ::= FieldModifiers
FieldModifier ::= FieldModifier
MethodHeader ::= MethodHeader
MethodBody ::= MethodBody
ResultType ::= ResultType
MethodDeclarator ::= MethodDeclarator
LastFormalParameter ::= LastFormalParameter
FormalParameters ::= FormalParameters
FormalParameter ::= FormalParameter
VariableModifiers ::= VariableModifiers
VariableModifier ::= VariableModifier
Annotations ::= Annotations
MethodModifiers ::= MethodModifiers
MethodModifier ::= MethodModifier
ExceptionTypeList ::= ExceptionTypeList
ExceptionType ::= ExceptionType
Block ::= Block
ConstructorDeclarator ::= ConstructorDeclarator
ConstructorBody ::= ConstructorBody
SimpleTypeName ::= SimpleTypeName
ConstructorModifiers ::= ConstructorModifiers
ConstructorModifier ::= ConstructorModifier
Primary ::= Primary
EnumBody ::= EnumBody
EnumConstants ::= EnumConstants
EnumConstant ::= EnumConstant
AnnotationTypeDeclaration ::= AnnotationTypeDeclaration
InterfaceBody ::= InterfaceBody
InterfaceModifiers ::= InterfaceModifiers
InterfaceModifier ::= InterfaceModifier
ExtendsInterfaces ::= ExtendsInterfaces
InterfaceMemberDeclarations ::= InterfaceMemberDeclarations
InterfaceMemberDeclaration ::= InterfaceMemberDeclaration
ConstantModifiers ::= ConstantModifiers
ConstantModifier ::= ConstantModifier
AbstractMethodModifiers ::= AbstractMethodModifiers
AbstractMethodModifier ::= AbstractMethodModifier
AnnotationTypeBody ::= AnnotationTypeBody
AnnotationTypeElementDeclarations ::= AnnotationTypeElementDeclarations
AnnotationTypeElementDeclaration ::= AnnotationTypeElementDeclaration
ElementValue ::= ElementValue
ElementValuePairs ::= ElementValuePairs
ElementValuePair ::= ElementValuePair
SimpleName ::= SimpleName
ConditionalExpression ::= ConditionalExpression
ElementValues ::= ElementValues
VariableInitializers ::= VariableInitializers
BlockStatements ::= BlockStatements
BlockStatement ::= BlockStatement
Statement ::= Statement
LocalVariableDeclaration ::= LocalVariableDeclaration
StatementWithoutTrailingSubstatement ::= StatementWithoutTrailingSubstatement
StatementNoShortIf ::= StatementNoShortIf
StatementExpression ::= StatementExpression
PostIncrementExpression ::= PostIncrementExpression
PostDecrementExpression ::= PostDecrementExpression
MethodInvocation ::= MethodInvocation
ClassInstanceCreationExpression ::= ClassInstanceCreationExpression
SwitchBlock ::= SwitchBlock
SwitchBlockStatementGroups ::= SwitchBlockStatementGroups
SwitchBlockStatementGroup ::= SwitchBlockStatementGroup
SwitchLabels ::= SwitchLabels
SwitchLabel ::= SwitchLabel
ConstantExpression ::= ConstantExpression
StatementExpressionList ::= StatementExpressionList
Catches ::= Catches
Finally ::= Finally
CatchClause ::= CatchClause
PrimaryNoNewArray ::= PrimaryNoNewArray
FieldAccess ::= FieldAccess
ArrayAccess ::= ArrayAccess
ArgumentList ::= ArgumentList
DimExprs ::= DimExprs
Dims ::= Dims
DimExpr ::= DimExpr
PostfixExpression ::= PostfixExpression
UnaryExpression ::= UnaryExpression
UnaryExpressionNotPlusMinus ::= UnaryExpressionNotPlusMinus
MultiplicativeExpression ::= MultiplicativeExpression
AdditiveExpression ::= AdditiveExpression
ShiftExpression ::= ShiftExpression
RelationalExpression ::= RelationalExpression
EqualityExpression ::= EqualityExpression
AndExpression ::= AndExpression
ExclusiveOrExpression ::= ExclusiveOrExpression
InclusiveOrExpression ::= InclusiveOrExpression
ConditionalAndExpression ::= ConditionalAndExpression
ConditionalOrExpression ::= ConditionalOrExpression
AssignmentExpression ::= AssignmentExpression
LeftHandSide ::= LeftHandSide
AssignmentOperator ::= AssignmentOperator
Commaopt ::= 
Ellipsisopt ::= 
CompilationUnit ::= 
ClassBodyDeclarationsopt ::= 
LPGUserAction ::= 
BlockStatementsopt ::= 
NumericType ::= 
IntegralType ::= 
FloatingPointType ::= 
ArrayType ::= 
TypeArgumentsopt ::= 
TypeBoundopt ::= 
TypeBound ::= 
AdditionalBoundListopt ::= 
Wildcard ::= 
WildcardBoundsOpt ::= 
WildcardBounds ::= 
PackageDeclarationopt ::= 
ImportDeclarationsopt ::= 
TypeDeclarationsopt ::= 
PackageDeclaration ::= 
Annotationsopt ::= 
SingleTypeImportDeclaration ::= 
TypeImportOnDemandDeclaration ::= 
SingleStaticImportDeclaration ::= 
StaticImportOnDemandDeclaration ::= 
ClassDeclaration ::= 
InterfaceDeclaration ::= 
NormalClassDeclaration ::= 
ClassModifiersopt ::= 
TypeParametersopt ::= 
Superopt ::= 
Interfacesopt ::= 
TypeParameters ::= 
Super ::= 
Interfaces ::= 
ClassMemberDeclaration ::= 
InstanceInitializer ::= 
StaticInitializer ::= 
ConstructorDeclaration ::= 
FieldDeclaration ::= 
MethodDeclaration ::= 
FieldModifiersopt ::= 
MethodModifiersopt ::= 
Throwsopt ::= 
FormalParameterListopt ::= 
FormalParameterList ::= 
VariableModifiersopt ::= 
Throws ::= 
ConstructorModifiersopt ::= 
ExplicitConstructorInvocationopt ::= 
ExplicitConstructorInvocation ::= 
ArgumentListopt ::= 
EnumConstantsopt ::= 
EnumBodyDeclarationsopt ::= 
Argumentsopt ::= 
ClassBodyopt ::= 
Arguments ::= 
EnumBodyDeclarations ::= 
NormalInterfaceDeclaration ::= 
InterfaceModifiersopt ::= 
ExtendsInterfacesopt ::= 
InterfaceMemberDeclarationsopt ::= 
ConstantDeclaration ::= 
AbstractMethodDeclaration ::= 
ConstantModifiersopt ::= 
AbstractMethodModifiersopt ::= 
AnnotationTypeElementDeclarationsopt ::= 
DefaultValueopt ::= 
DefaultValue ::= 
NormalAnnotation ::= 
MarkerAnnotation ::= 
SingleElementAnnotation ::= 
ElementValuePairsopt ::= 
ElementValueArrayInitializer ::= 
ElementValuesopt ::= 
VariableInitializersopt ::= 
LocalVariableDeclarationStatement ::= 
LabeledStatement ::= 
IfThenStatement ::= 
IfThenElseStatement ::= 
WhileStatement ::= 
ForStatement ::= 
EmptyStatement ::= 
ExpressionStatement ::= 
AssertStatement ::= 
SwitchStatement ::= 
DoStatement ::= 
BreakStatement ::= 
ContinueStatement ::= 
ReturnStatement ::= 
SynchronizedStatement ::= 
ThrowStatement ::= 
TryStatement ::= 
LabeledStatementNoShortIf ::= 
IfThenElseStatementNoShortIf ::= 
WhileStatementNoShortIf ::= 
ForStatementNoShortIf ::= 
Assignment ::= 
PreIncrementExpression ::= 
PreDecrementExpression ::= 
SwitchBlockStatementGroupsopt ::= 
SwitchLabelsopt ::= 
BasicForStatement ::= 
EnhancedForStatement ::= 
ForInitopt ::= 
Expressionopt ::= 
ForUpdateopt ::= 
ForInit ::= 
ForUpdate ::= 
identifieropt ::= 
Catchesopt ::= 
ArrayCreationExpression ::= 
Literal ::= 
BooleanLiteral ::= 
Dimsopt ::= 
CastExpression ::= 

 IBM LALR Parser Generator              2.0.17 (May 18 2009)


Scopes:

MethodInvocation ::= ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt  .RPAREN 
ClassInstanceCreationExpression ::= Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt  .RPAREN ClassBodyopt 
ForStatementNoShortIf ::= for LPAREN ForInitopt SEMICOLON Expressionopt 
                          SEMICOLON ForUpdateopt  .RPAREN StatementNoShortIf 
BasicForStatement ::= for LPAREN ForInitopt SEMICOLON Expressionopt 
                      SEMICOLON ForUpdateopt  .RPAREN Statement 
MethodInvocation ::= TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt  .RPAREN 
MethodInvocation ::= super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt  .RPAREN 
MethodInvocation ::= Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt  .RPAREN 
AnnotationTypeElementDeclaration ::= AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN 
                                     DefaultValueopt  .SEMICOLON 
ClassInstanceCreationExpression ::= new TypeArgumentsopt 
                                    ClassOrInterfaceType TypeArgumentsopt 
                                    LPAREN ArgumentListopt  .RPAREN 
                                    ClassBodyopt 
ExplicitConstructorInvocation ::= Primary DOT TypeArgumentsopt super LPAREN 
                                  ArgumentListopt  .RPAREN SEMICOLON 
AbstractMethodDeclaration ::= AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt  .SEMICOLON 
EnhancedForStatement ::= for LPAREN FormalParameter COLON Expression  .RPAREN 
                         Statement 
DoStatement ::= do Statement while LPAREN Expression  .RPAREN SEMICOLON 
IfThenElseStatementNoShortIf ::= if LPAREN Expression RPAREN 
                                 StatementNoShortIf  .else StatementNoShortIf 
IfThenElseStatement ::= if LPAREN Expression RPAREN StatementNoShortIf  .else 
                        Statement 
ForStatementNoShortIf ::= for LPAREN ForInitopt SEMICOLON Expressionopt  .
                          SEMICOLON ForUpdateopt RPAREN StatementNoShortIf 
BasicForStatement ::= for LPAREN ForInitopt SEMICOLON Expressionopt  .SEMICOLON 
                      ForUpdateopt RPAREN Statement 
AssertStatement ::= assert Expression COLON Expression  .SEMICOLON 
SingleElementAnnotation ::= AT TypeName LPAREN ElementValue  .RPAREN 
NormalAnnotation ::= AT TypeName LPAREN ElementValuePairsopt  .RPAREN 
EnumBody ::= LBRACE EnumConstantsopt Commaopt EnumBodyDeclarationsopt  .RBRACE 
ConstructorDeclarator ::= TypeParametersopt SimpleTypeName LPAREN 
                          FormalParameterListopt  .RPAREN 
ExplicitConstructorInvocation ::= TypeArgumentsopt super LPAREN 
                                  ArgumentListopt  .RPAREN SEMICOLON 
ExplicitConstructorInvocation ::= TypeArgumentsopt this LPAREN 
                                  ArgumentListopt  .RPAREN SEMICOLON 
ArrayAccess ::= PrimaryNoNewArray LBRACKET Expression  .RBRACKET 
ArrayAccess ::= ExpressionName LBRACKET Expression  .RBRACKET 
MethodInvocation ::= MethodName LPAREN ArgumentListopt  .RPAREN 
TryStatement ::= try Block Catchesopt  .Finally 
SwitchBlock ::= LBRACE SwitchBlockStatementGroupsopt SwitchLabelsopt  .RBRACE 
ArrayInitializer ::= LBRACE VariableInitializersopt Commaopt  .RBRACE 
ElementValueArrayInitializer ::= LBRACE ElementValuesopt Commaopt  .RBRACE 
ConstructorBody ::= LBRACE ExplicitConstructorInvocationopt 
                    BlockStatementsopt  .RBRACE 
ConstructorDeclaration ::= ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt  .ConstructorBody 
MethodDeclarator ::= identifier LPAREN FormalParameterListopt  .RPAREN 
FieldDeclaration ::= FieldModifiersopt Type VariableDeclarators  .SEMICOLON 
ConditionalExpression ::= ConditionalOrExpression QUESTION Expression  .COLON 
                          ConditionalExpression 
CatchClause ::= catch LPAREN FormalParameter  .RPAREN Block 
SynchronizedStatement ::= synchronized LPAREN Expression  .RPAREN Block 
WhileStatementNoShortIf ::= while LPAREN Expression  .RPAREN StatementNoShortIf 
WhileStatement ::= while LPAREN Expression  .RPAREN Statement 
SwitchStatement ::= switch LPAREN Expression  .RPAREN SwitchBlock 
IfThenStatement ::= if LPAREN Expression  .RPAREN Statement 
EnhancedForStatement ::= for LPAREN FormalParameter  .COLON Expression RPAREN 
                         Statement 
IfThenElseStatementNoShortIf ::= if LPAREN Expression  .RPAREN 
                                 StatementNoShortIf else StatementNoShortIf 
IfThenElseStatement ::= if LPAREN Expression  .RPAREN StatementNoShortIf else 
                        Statement 
ForStatementNoShortIf ::= for LPAREN ForInitopt  .SEMICOLON Expressionopt 
                          SEMICOLON ForUpdateopt RPAREN StatementNoShortIf 
BasicForStatement ::= for LPAREN ForInitopt  .SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
DimExpr ::= LBRACKET Expression  .RBRACKET 
PrimaryNoNewArray ::= LPAREN Expression  .RPAREN 
TryStatement ::= try Block  .Catches 
ThrowStatement ::= throw Expression  .SEMICOLON 
ReturnStatement ::= return Expressionopt  .SEMICOLON 
SwitchLabel ::= case EnumConstant  .COLON 
SwitchLabel ::= case ConstantExpression  .COLON 
AssertStatement ::= assert Expression  .SEMICOLON 
Block ::= LBRACE BlockStatementsopt  .RBRACE 
AnnotationTypeBody ::= LBRACE AnnotationTypeElementDeclarationsopt  .RBRACE 
InterfaceBody ::= LBRACE InterfaceMemberDeclarationsopt  .RBRACE 
Arguments ::= LPAREN ArgumentListopt  .RPAREN 
ClassBody ::= LBRACE ClassBodyDeclarationsopt  .RBRACE 
TypeArguments ::= LESS ActualTypeArgumentList  .GREATER 
AssertStatement ::= assert Expression  .COLON Expression SEMICOLON 
MethodHeader ::= MethodModifiersopt TypeParametersopt  .ResultType 
                 MethodDeclarator Throwsopt 
AbstractMethodDeclaration ::= AbstractMethodModifiersopt TypeParametersopt  .
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
DoStatement ::= do Statement  .while LPAREN Expression RPAREN SEMICOLON 
SwitchBlockStatementGroup ::= SwitchLabels  .BlockStatements 
ExpressionStatement ::= StatementExpression  .SEMICOLON 
LocalVariableDeclarationStatement ::= LocalVariableDeclaration  .SEMICOLON 
MethodDeclaration ::= MethodHeader  .MethodBody 
Assignment ::= LeftHandSide  .AssignmentOperator AssignmentExpression 
LocalVariableDeclaration ::= VariableModifiersopt  .Type VariableDeclarators 
ConstantDeclaration ::= ConstantModifiersopt  .Type VariableDeclarators 
FormalParameter ::= VariableModifiersopt  .Type VariableDeclaratorId 
FormalParameterList ::= FormalParameters  .COMMA LastFormalParameter 
EnumConstant ::= Annotationsopt  .identifier Argumentsopt ClassBodyopt 
ConstructorDeclaration ::= ConstructorModifiersopt  .ConstructorDeclarator 
                           Throwsopt ConstructorBody 
LastFormalParameter ::= VariableModifiersopt  .Type Ellipsisopt 
                        VariableDeclaratorId 
FieldDeclaration ::= FieldModifiersopt  .Type VariableDeclarators SEMICOLON 
AnnotationTypeDeclaration ::= InterfaceModifiersopt  .AT interface identifier 
                              AnnotationTypeBody 
EnumDeclaration ::= ClassModifiersopt  .enum identifier Interfacesopt EnumBody 
NormalInterfaceDeclaration ::= InterfaceModifiersopt  .interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
AnnotationTypeElementDeclaration ::= AbstractMethodModifiersopt  .Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
NormalClassDeclaration ::= ClassModifiersopt  .class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ExplicitConstructorInvocation ::= Primary  .DOT TypeArgumentsopt super LPAREN 
                                  ArgumentListopt RPAREN SEMICOLON 

 IBM LALR Parser Generator              2.0.17 (May 18 2009)


---------------------------------- CONFLICTS ----------------------------------



STATE 1 ------------------------------------------------------------------------
( )

'$accept' ::= .CompilationUnit 

CompilationUnit ::= .ClassBodyDeclarationsoptMarker ClassBodyDeclarationsopt 
CompilationUnit ::= .LPGUserActionMarker LPGUserAction 
CompilationUnit ::= .PackageDeclarationopt ImportDeclarationsopt 
                    TypeDeclarationsopt 
PackageDeclaration ::= .Annotationsopt package PackageName SEMICOLON 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Annotationsopt ::= . (524)
Annotationsopt ::= .Annotations 
PackageDeclarationopt ::= . (530)
PackageDeclarationopt ::= .PackageDeclaration 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1080:27:1080:36:34181:34190: Warning: Shift/reduce conflict in state 1 on "AT" with rule 530

CompilationUnit ::= .PackageDeclarationopt ImportDeclarationsopt 
                    TypeDeclarationsopt 
PackageDeclarationopt ::= . (530)




STATE 4 ------------------------------------------------------------------------
( 1 )

CompilationUnit ::= LPGUserActionMarker  .LPGUserAction 

identifier ::= .IDENTIFIER 
LPGUserAction ::= .BlockStatementsopt 
LPGUserAction ::= .BeginAction BlockStatementsopt EndAction 
LPGUserAction ::= .BeginJava BlockStatementsopt EndJava 
LPGUserAction ::= .NoAction 
LPGUserAction ::= .NullAction 
LPGUserAction ::= .BadAction 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 4 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 5 ------------------------------------------------------------------------
( 1 )

CompilationUnit ::= ClassBodyDeclarationsoptMarker  .ClassBodyDeclarationsopt 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
ClassBodyDeclarations ::= .ClassBodyDeclaration 
ClassBodyDeclarations ::= .ClassBodyDeclarations ClassBodyDeclaration 
ClassBodyDeclaration ::= .ClassMemberDeclaration 
ClassBodyDeclaration ::= .InstanceInitializer 
ClassBodyDeclaration ::= .StaticInitializer 
ClassBodyDeclaration ::= .ConstructorDeclaration 
ClassMemberDeclaration ::= .FieldDeclaration 
ClassMemberDeclaration ::= .MethodDeclaration 
ClassMemberDeclaration ::= .ClassDeclaration 
ClassMemberDeclaration ::= .InterfaceDeclaration 
ClassMemberDeclaration ::= .SEMICOLON 
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiers ::= .FieldModifier 
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifier ::= .Annotation 
FieldModifier ::= .public 
FieldModifier ::= .protected 
FieldModifier ::= .private 
FieldModifier ::= .static 
FieldModifier ::= .final 
FieldModifier ::= .transient 
FieldModifier ::= .volatile 
MethodDeclaration ::= .MethodHeader MethodBody 
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiers ::= .MethodModifier 
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifier ::= .Annotations 
MethodModifier ::= .public 
MethodModifier ::= .protected 
MethodModifier ::= .private 
MethodModifier ::= .abstract 
MethodModifier ::= .static 
MethodModifier ::= .final 
MethodModifier ::= .synchronized 
MethodModifier ::= .native 
MethodModifier ::= .strictfp 
InstanceInitializer ::= .Block 
StaticInitializer ::= .static Block 
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifier ::= .Annotations 
ConstructorModifier ::= .public 
ConstructorModifier ::= .protected 
ConstructorModifier ::= .private 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ConstructorModifiersopt ::= . (502)
ConstructorModifiersopt ::= .ConstructorModifiers 
MethodModifiersopt ::= . (510)
MethodModifiersopt ::= .MethodModifiers 
FieldModifiersopt ::= . (512)
FieldModifiersopt ::= .FieldModifiers 
ClassBodyDeclarationsopt ::= . (514)
ClassBodyDeclarationsopt ::= .ClassBodyDeclarations 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 5 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "short" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "long" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "int" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "float" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "double" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "char" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "byte" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "boolean" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "IDENTIFIER" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "IDENTIFIER" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 5 on "LESS" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)




STATE 9 ------------------------------------------------------------------------
( 3 )

CompilationUnit ::= PackageDeclarationopt ImportDeclarationsopt  .
                    TypeDeclarationsopt 

TypeDeclarations ::= .TypeDeclaration 
TypeDeclarations ::= .TypeDeclarations TypeDeclaration 
TypeDeclaration ::= .ClassDeclaration 
TypeDeclaration ::= .InterfaceDeclaration 
TypeDeclaration ::= .SEMICOLON 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 
TypeDeclarationsopt ::= . (526)
TypeDeclarationsopt ::= .TypeDeclarations 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 9 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)




STATE 12 -----------------------------------------------------------------------
( 4 )

LPGUserAction ::= BeginJava  .BlockStatementsopt EndJava 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 12 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 13 -----------------------------------------------------------------------
( 4 )

LPGUserAction ::= BeginAction  .BlockStatementsopt EndAction 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 13 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 15 -----------------------------------------------------------------------
( 4 12 13 16 25 59 100 294 297 343 353 368 384 394 431 )

VariableModifier ::= Annotations . (139)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:426:24:426:36:12045:12057: Warning: Shift/reduce conflict in state 15 on "AT" with rule 139

VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifiers ::= .VariableModifier 
VariableModifier ::= Annotations . (139)




STATE 18 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

ClassModifier ::= final . (85)
VariableModifier ::= final . (138)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 18 on "final" between rule 85 and rule 138 starting at line 425, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifiers ::= .VariableModifier 
VariableModifier ::= final . (138)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 18 on "AT" between rule 85 and rule 138 starting at line 425, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifiers ::= .VariableModifier 
VariableModifier ::= final . (138)




STATE 19 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

ClassModifier ::= Annotation . (79)
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 19 on "final" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifiers ::= .VariableModifier 
VariableModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 19 on "AT" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifiers ::= .VariableModifier 
VariableModifier ::= .Annotations 
Annotations ::= Annotation . (229)




STATE 25 -----------------------------------------------------------------------
( 4 5 12 13 25 52 58 59 64 70 78 133 252 253 292 293 343 365 367 371 384 387 
  417 431 443 447 449 450 470 479 )

Block ::= LBRACE  .BlockStatementsopt RBRACE 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 25 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 35 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ClassType ::= TypeName  .TypeArgumentsopt 
TypeName ::= TypeName  .DOT identifier 
ClassName ::= TypeName . (31)
MethodInvocation ::= TypeName  .DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 

TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 35 on "DOT" with rule 538

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= TypeName  .TypeArgumentsopt 
TypeArgumentsopt ::= . (538)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:238:15:238:26:6409:6420: Warning: Shift/reduce conflict in state 35 on "DOT" with rule 31

PrimaryNoNewArray ::= .ClassName DOT this 
ClassName ::= TypeName . (31)




STATE 36 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 343 365 367 384 431 447 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)
LabeledStatement ::= identifier  .COLON Statement 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 36 on "LBRACKET" between rule 29 and rule 49 starting at line 279, column 20

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 36 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 36 on "DOT" between rule 29 and rule 55 starting at line 288, column 19

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExpressionName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 36 on "DOT" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)




STATE 37 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ClassInstanceCreationExpression ::= new  .TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ArrayCreationExpression ::= new  .PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= new  .ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= new  .PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= new  .ClassOrInterfaceType Dims ArrayInitializer 

identifier ::= .IDENTIFIER 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 37 on "IDENTIFIER" with rule 538

ClassInstanceCreationExpression ::= new  .TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
TypeArgumentsopt ::= . (538)




STATE 39 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

PrimaryNoNewArray ::= ArrayAccess . (343)
LeftHandSide ::= ArrayAccess . (433)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:792:25:792:37:24600:24612: Warning: Reduce/reduce conflict in state 39 on "GREATER" between rule 343 and rule 433 starting at line 935, column 20

ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .Primary 
Primary ::= .PrimaryNoNewArray 
PrimaryNoNewArray ::= ArrayAccess . (343)
------------------------------------------------------------------------------
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= ArrayAccess . (433)




STATE 40 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

PrimaryNoNewArray ::= FieldAccess . (341)
LeftHandSide ::= FieldAccess . (432)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:790:25:790:37:24519:24531: Warning: Reduce/reduce conflict in state 40 on "GREATER" between rule 341 and rule 432 starting at line 934, column 20

ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .Primary 
Primary ::= .PrimaryNoNewArray 
PrimaryNoNewArray ::= FieldAccess . (341)
------------------------------------------------------------------------------
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= FieldAccess . (432)




STATE 44 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

ArrayAccess ::= ExpressionName  .LBRACKET Expression RBRACKET 
PostfixExpression ::= ExpressionName . (378)
LeftHandSide ::= ExpressionName . (431)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:859:25:859:40:27192:27207: Warning: Reduce/reduce conflict in state 44 on "GREATER" between rule 378 and rule 431 starting at line 933, column 18

ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= ExpressionName . (378)
------------------------------------------------------------------------------
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= ExpressionName . (431)




STATE 59 -----------------------------------------------------------------------
( 4 12 13 25 343 )

BlockStatements ::= BlockStatements  .BlockStatement 
BlockStatementsopt ::= BlockStatements . (499)

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 59 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 65 -----------------------------------------------------------------------
( 5 78 417 443 )

MethodModifier ::= Annotations . (143)
ConstructorModifier ::= Annotations . (167)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Shift/reduce conflict in state 65 on "AT" with rule 143

MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:474:25:474:39:13451:13465: Warning: Shift/reduce conflict in state 65 on "AT" with rule 167

ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Reduce/reduce conflict in state 65 on "IDENTIFIER" between rule 143 and rule 167 starting at line 474, column 25

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Reduce/reduce conflict in state 65 on "public" between rule 143 and rule 167 starting at line 474, column 25

MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Reduce/reduce conflict in state 65 on "protected" between rule 143 and rule 167 starting at line 474, column 25

MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Reduce/reduce conflict in state 65 on "private" between rule 143 and rule 167 starting at line 474, column 25

MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Reduce/reduce conflict in state 65 on "LESS" between rule 143 and rule 167 starting at line 474, column 25

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= Annotations . (143)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)




STATE 68 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= final . (85)
FieldModifier ::= final . (122)
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "IDENTIFIER" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "strictfp" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "static" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "static" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "short" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "public" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "public" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "protected" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "protected" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "private" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "private" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "long" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "int" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "float" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "final" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "final" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "double" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "char" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "byte" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:399:21:399:27:11172:11178: Warning: Reduce/reduce conflict in state 68 on "boolean" between rule 122 and rule 149 starting at line 445, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "abstract" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "AT" between rule 85 and rule 149 starting at line 445, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= final . (149)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 68 on "AT" between rule 85 and rule 122 starting at line 399, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= final . (122)




STATE 69 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= strictfp . (86)
MethodModifier ::= strictfp . (152)
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "final" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "strictfp" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "strictfp" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "static" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "static" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "public" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "public" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "protected" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "protected" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "private" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "private" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "abstract" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "abstract" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "AT" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 69 on "AT" between rule 86 and rule 152 starting at line 448, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= strictfp . (152)




STATE 70 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= static . (84)
FieldModifier ::= static . (121)
MethodModifier ::= static . (148)
StaticInitializer ::= static  .Block 
InterfaceModifier ::= static . (192)

Block ::= .LBRACE BlockStatementsopt RBRACE 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "IDENTIFIER" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "short" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "long" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "int" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "float" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "final" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "final" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "double" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "char" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "byte" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:398:21:398:28:11143:11150: Warning: Reduce/reduce conflict in state 70 on "boolean" between rule 121 and rule 148 starting at line 444, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "strictfp" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "strictfp" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "static" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "static" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "static" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "public" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "public" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "public" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "protected" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "protected" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "protected" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "private" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "private" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "private" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "abstract" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "abstract" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "AT" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "AT" between rule 84 and rule 148 starting at line 444, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= static . (148)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 70 on "AT" between rule 84 and rule 121 starting at line 398, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= static . (121)




STATE 71 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= abstract . (83)
MethodModifier ::= abstract . (147)
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "final" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "strictfp" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "strictfp" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "static" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "static" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "public" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "public" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "protected" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "protected" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "private" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "private" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "abstract" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "abstract" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "AT" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 71 on "AT" between rule 83 and rule 147 starting at line 443, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= abstract . (147)




STATE 72 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= private . (82)
FieldModifier ::= private . (120)
MethodModifier ::= private . (146)
ConstructorModifier ::= private . (170)
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "short" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "long" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "int" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "float" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "final" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "final" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "double" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "char" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "byte" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "boolean" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "IDENTIFIER" between rule 120 and rule 170 starting at line 477, column 27

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:397:21:397:29:11113:11121: Warning: Reduce/reduce conflict in state 72 on "IDENTIFIER" between rule 120 and rule 146 starting at line 442, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:442:22:442:30:12509:12517: Warning: Reduce/reduce conflict in state 72 on "LESS" between rule 146 and rule 170 starting at line 477, column 27

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "strictfp" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "strictfp" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "static" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "static" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "static" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "public" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "public" between rule 82 and rule 170 starting at line 477, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "public" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "public" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "protected" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "protected" between rule 82 and rule 170 starting at line 477, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "protected" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "protected" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "private" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "private" between rule 82 and rule 170 starting at line 477, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "private" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "private" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "abstract" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "abstract" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "AT" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "AT" between rule 82 and rule 170 starting at line 477, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= private . (170)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "AT" between rule 82 and rule 146 starting at line 442, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= private . (146)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 72 on "AT" between rule 82 and rule 120 starting at line 397, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= private . (120)




STATE 73 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= protected . (81)
FieldModifier ::= protected . (119)
MethodModifier ::= protected . (145)
ConstructorModifier ::= protected . (169)
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "short" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "long" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "int" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "float" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "final" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "final" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "double" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "char" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "byte" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "boolean" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "IDENTIFIER" between rule 119 and rule 169 starting at line 476, column 27

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:396:21:396:31:11081:11091: Warning: Reduce/reduce conflict in state 73 on "IDENTIFIER" between rule 119 and rule 145 starting at line 441, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:441:22:441:32:12476:12486: Warning: Reduce/reduce conflict in state 73 on "LESS" between rule 145 and rule 169 starting at line 476, column 27

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "strictfp" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "strictfp" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "static" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "static" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "static" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "public" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "public" between rule 81 and rule 169 starting at line 476, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "public" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "public" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "protected" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "protected" between rule 81 and rule 169 starting at line 476, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "protected" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "protected" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "private" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "private" between rule 81 and rule 169 starting at line 476, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "private" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "private" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "abstract" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "abstract" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "AT" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "AT" between rule 81 and rule 169 starting at line 476, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= protected . (169)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "AT" between rule 81 and rule 145 starting at line 441, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= protected . (145)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 73 on "AT" between rule 81 and rule 119 starting at line 396, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= protected . (119)




STATE 74 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= public . (80)
FieldModifier ::= public . (118)
MethodModifier ::= public . (144)
ConstructorModifier ::= public . (168)
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "short" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "long" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "int" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "float" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "final" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "final" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "double" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "char" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "byte" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "boolean" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "IDENTIFIER" between rule 118 and rule 168 starting at line 475, column 27

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:395:21:395:28:11052:11059: Warning: Reduce/reduce conflict in state 74 on "IDENTIFIER" between rule 118 and rule 144 starting at line 440, column 22

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:440:22:440:29:12446:12453: Warning: Reduce/reduce conflict in state 74 on "LESS" between rule 144 and rule 168 starting at line 475, column 27

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= .ConstructorModifiers 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "strictfp" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "strictfp" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "static" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "static" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "static" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "public" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "public" between rule 80 and rule 168 starting at line 475, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "public" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "public" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "protected" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "protected" between rule 80 and rule 168 starting at line 475, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "protected" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "protected" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "private" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "private" between rule 80 and rule 168 starting at line 475, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "private" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "private" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "abstract" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "abstract" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "AT" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "AT" between rule 80 and rule 168 starting at line 475, column 27

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifier ::= public . (168)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "AT" between rule 80 and rule 144 starting at line 440, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= public . (144)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 74 on "AT" between rule 80 and rule 118 starting at line 395, column 21

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= public . (118)




STATE 75 -----------------------------------------------------------------------
( 5 78 417 443 )

ClassModifier ::= Annotation . (79)
FieldModifier ::= Annotation . (117)
InterfaceModifier ::= Annotation . (187)
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "IDENTIFIER" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "strictfp" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "strictfp" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "static" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "static" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "static" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "short" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "public" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "public" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "public" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "protected" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "protected" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "protected" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "private" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "private" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "private" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "long" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "int" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "float" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "final" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "final" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "double" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "char" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "byte" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:394:19:394:32:11017:11030: Warning: Reduce/reduce conflict in state 75 on "boolean" between rule 117 and rule 229 starting at line 571, column 17

FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= .FieldModifiers 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)
------------------------------------------------------------------------------
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= .MethodModifiers 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "abstract" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "abstract" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "AT" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= .MethodModifier 
MethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "AT" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 75 on "AT" between rule 79 and rule 117 starting at line 394, column 19

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifiers ::= .FieldModifier 
FieldModifier ::= Annotation . (117)




STATE 76 -----------------------------------------------------------------------
( 5 9 78 88 354 411 412 417 441 443 )

InterfaceModifiers ::= InterfaceModifiers  .InterfaceModifier 
InterfaceModifiersopt ::= InterfaceModifiers . (485)

InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1012:29:1012:48:32525:32544: Warning: Shift/reduce conflict in state 76 on "AT" with rule 485

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= InterfaceModifiers . (485)




STATE 78 -----------------------------------------------------------------------
( 5 417 443 )

ClassBodyDeclarations ::= ClassBodyDeclarations  .ClassBodyDeclaration 
ClassBodyDeclarationsopt ::= ClassBodyDeclarations . (515)

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
ClassBodyDeclaration ::= .ClassMemberDeclaration 
ClassBodyDeclaration ::= .InstanceInitializer 
ClassBodyDeclaration ::= .StaticInitializer 
ClassBodyDeclaration ::= .ConstructorDeclaration 
ClassMemberDeclaration ::= .FieldDeclaration 
ClassMemberDeclaration ::= .MethodDeclaration 
ClassMemberDeclaration ::= .ClassDeclaration 
ClassMemberDeclaration ::= .InterfaceDeclaration 
ClassMemberDeclaration ::= .SEMICOLON 
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiers ::= .FieldModifier 
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifier ::= .Annotation 
FieldModifier ::= .public 
FieldModifier ::= .protected 
FieldModifier ::= .private 
FieldModifier ::= .static 
FieldModifier ::= .final 
FieldModifier ::= .transient 
FieldModifier ::= .volatile 
MethodDeclaration ::= .MethodHeader MethodBody 
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiers ::= .MethodModifier 
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifier ::= .Annotations 
MethodModifier ::= .public 
MethodModifier ::= .protected 
MethodModifier ::= .private 
MethodModifier ::= .abstract 
MethodModifier ::= .static 
MethodModifier ::= .final 
MethodModifier ::= .synchronized 
MethodModifier ::= .native 
MethodModifier ::= .strictfp 
InstanceInitializer ::= .Block 
StaticInitializer ::= .static Block 
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifier ::= .Annotations 
ConstructorModifier ::= .public 
ConstructorModifier ::= .protected 
ConstructorModifier ::= .private 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ConstructorModifiersopt ::= . (502)
ConstructorModifiersopt ::= .ConstructorModifiers 
MethodModifiersopt ::= . (510)
MethodModifiersopt ::= .MethodModifiers 
FieldModifiersopt ::= . (512)
FieldModifiersopt ::= .FieldModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 78 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "short" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "long" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "int" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "float" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "double" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "char" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "byte" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "boolean" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "IDENTIFIER" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "IDENTIFIER" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 78 on "LESS" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)




STATE 81 -----------------------------------------------------------------------
( 9 88 354 411 412 441 )

ClassModifier ::= strictfp . (86)
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "strictfp" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "static" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "public" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "protected" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "private" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "abstract" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:337:21:337:30:9259:9268: Warning: Reduce/reduce conflict in state 81 on "AT" between rule 86 and rule 193 starting at line 514, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= strictfp . (86)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= strictfp . (193)




STATE 82 -----------------------------------------------------------------------
( 9 88 )

ClassModifier ::= static . (84)
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "strictfp" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "static" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "public" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "protected" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "private" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "abstract" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 82 on "AT" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)




STATE 83 -----------------------------------------------------------------------
( 9 88 )

ClassModifier ::= abstract . (83)
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "strictfp" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "static" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "public" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "protected" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "private" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "abstract" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 83 on "AT" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)




STATE 84 -----------------------------------------------------------------------
( 9 88 354 411 412 441 )

ClassModifier ::= private . (82)
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "strictfp" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "static" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "public" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "protected" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "private" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "abstract" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:333:21:333:29:9141:9149: Warning: Reduce/reduce conflict in state 84 on "AT" between rule 82 and rule 190 starting at line 511, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= private . (82)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= private . (190)




STATE 85 -----------------------------------------------------------------------
( 9 88 354 411 412 441 )

ClassModifier ::= protected . (81)
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "strictfp" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "static" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "public" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "protected" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "private" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "abstract" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:332:21:332:31:9109:9119: Warning: Reduce/reduce conflict in state 85 on "AT" between rule 81 and rule 189 starting at line 510, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= protected . (81)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= protected . (189)




STATE 86 -----------------------------------------------------------------------
( 9 88 )

ClassModifier ::= public . (80)
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "strictfp" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "static" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "public" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "protected" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "private" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "abstract" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 86 on "AT" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)




STATE 87 -----------------------------------------------------------------------
( 9 88 )

ClassModifier ::= Annotation . (79)
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "strictfp" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "static" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "public" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "protected" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "private" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "abstract" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 87 on "AT" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)




STATE 88 -----------------------------------------------------------------------
( 9 )

TypeDeclarations ::= TypeDeclarations  .TypeDeclaration 
TypeDeclarationsopt ::= TypeDeclarations . (527)

TypeDeclaration ::= .ClassDeclaration 
TypeDeclaration ::= .InterfaceDeclaration 
TypeDeclaration ::= .SEMICOLON 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 88 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)




STATE 92 -----------------------------------------------------------------------
( 10 )

TypeName ::= identifier . (29)
PackageOrTypeName ::= identifier . (53)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 92 on "DOT" between rule 29 and rule 53 starting at line 285, column 23

TypeName ::= .TypeName DOT identifier 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PackageOrTypeName ::= .PackageOrTypeName DOT identifier 
PackageOrTypeName ::= identifier . (53)




STATE 95 -----------------------------------------------------------------------
( 17 37 62 132 136 156 171 182 224 280 281 282 299 314 342 347 349 399 405 459 )

ClassType ::= TypeName  .TypeArgumentsopt 
TypeName ::= TypeName  .DOT identifier 

TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 95 on "LESS" with rule 538

ClassInstanceCreationExpression ::= new TypeArgumentsopt  .ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= TypeName  .TypeArgumentsopt 
TypeArgumentsopt ::= . (538)




STATE 96 -----------------------------------------------------------------------
( 17 62 132 156 171 182 224 280 281 282 342 347 349 399 405 459 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "IDENTIFIER" between rule 29 and rule 32 starting at line 240, column 18

LocalVariableDeclaration ::= VariableModifiersopt  .Type VariableDeclarators 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
LocalVariableDeclaration ::= VariableModifiersopt  .Type VariableDeclarators 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "void" between rule 29 and rule 32 starting at line 240, column 18

InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "strictfp" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "static" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "short" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "public" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "protected" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "private" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "long" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "interface" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "int" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "instanceof" between rule 29 and rule 32 starting at line 240, column 18

RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "float" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "final" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "enum" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "double" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "class" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "char" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "byte" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "boolean" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "abstract" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "ELLIPSIS" between rule 29 and rule 32 starting at line 240, column 18

LastFormalParameter ::= VariableModifiersopt  .Type Ellipsisopt 
                        VariableDeclaratorId 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
LastFormalParameter ::= VariableModifiersopt  .Type Ellipsisopt 
                        VariableDeclaratorId 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "GREATER" between rule 29 and rule 32 starting at line 240, column 18

TypeArguments ::= LESS  .ActualTypeArgumentList GREATER 
ActualTypeArgumentList ::= .ActualTypeArgument 
ActualTypeArgument ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
TypeArguments ::= LESS  .ActualTypeArgumentList GREATER 
ActualTypeArgumentList ::= .ActualTypeArgument 
ActualTypeArgument ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "EQUAL_EQUAL" between rule 29 and rule 32 starting at line 240, column 18

EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "LESS_EQUAL" between rule 29 and rule 32 starting at line 240, column 18

RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "LESS" between rule 29 and rule 32 starting at line 240, column 18

ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "RBRACE" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "OR_OR" between rule 29 and rule 32 starting at line 240, column 18

ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "LBRACE" between rule 29 and rule 32 starting at line 240, column 18

ConstructorDeclaration ::= ConstructorModifiersopt ConstructorDeclarator  .
                           Throwsopt ConstructorBody 
Throwsopt ::= .Throws 
Throws ::= throws  .ExceptionTypeList 
ExceptionTypeList ::= .ExceptionType 
ExceptionType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ConstructorDeclaration ::= ConstructorModifiersopt ConstructorDeclarator  .
                           Throwsopt ConstructorBody 
Throwsopt ::= .Throws 
Throws ::= throws  .ExceptionTypeList 
ExceptionTypeList ::= .ExceptionType 
ExceptionType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "XOR" between rule 29 and rule 32 starting at line 240, column 18

ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "RBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayAccess ::= PrimaryNoNewArray LBRACKET  .Expression RBRACKET 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= PrimaryNoNewArray LBRACKET  .Expression RBRACKET 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "AT" between rule 29 and rule 32 starting at line 240, column 18

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "QUESTION" between rule 29 and rule 32 starting at line 240, column 18

ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "SEMICOLON" between rule 29 and rule 32 starting at line 240, column 18

AssertStatement ::= assert  .Expression SEMICOLON 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AssertStatement ::= assert  .Expression SEMICOLON 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "COLON" between rule 29 and rule 32 starting at line 240, column 18

AssertStatement ::= assert  .Expression COLON Expression SEMICOLON 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AssertStatement ::= assert  .Expression COLON Expression SEMICOLON 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "COMMA" between rule 29 and rule 32 starting at line 240, column 18

ActualTypeArgumentList ::= .ActualTypeArgumentList COMMA ActualTypeArgument 
ActualTypeArgumentList ::= .ActualTypeArgument 
ActualTypeArgument ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ActualTypeArgumentList ::= .ActualTypeArgumentList COMMA ActualTypeArgument 
ActualTypeArgumentList ::= .ActualTypeArgument 
ActualTypeArgument ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "RPAREN" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= LPAREN  .Expression RPAREN 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= LPAREN  .Expression RPAREN 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "AND_AND" between rule 29 and rule 32 starting at line 240, column 18

ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "AND" between rule 29 and rule 32 starting at line 240, column 18

AndExpression ::= .AndExpression AND EqualityExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
AndExpression ::= .AndExpression AND EqualityExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "NOT_EQUAL" between rule 29 and rule 32 starting at line 240, column 18

EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 96 on "OR" between rule 29 and rule 32 starting at line 240, column 18

InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= RelationalExpression instanceof  .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)




STATE 100 ----------------------------------------------------------------------
( 22 )

BasicForStatement ::= for LPAREN  .ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= for LPAREN  .FormalParameter COLON Expression RPAREN 
                         Statement 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
ForInit ::= .StatementExpressionList 
ForInit ::= .LocalVariableDeclaration 
StatementExpressionList ::= .StatementExpression 
StatementExpressionList ::= .StatementExpressionList COMMA StatementExpression 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
ForInitopt ::= . (458)
ForInitopt ::= .ForInit 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "IDENTIFIER" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "boolean" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "char" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "long" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "int" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "short" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "byte" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "double" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 100 on "float" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)




STATE 109 ----------------------------------------------------------------------
( 28 41 42 50 55 57 100 101 102 104 107 108 110 112 113 128 137 139 142 147 
  177 178 179 180 181 183 184 185 187 188 189 190 191 192 193 194 195 208 216 
  238 244 248 249 250 255 263 266 278 284 291 295 304 324 326 328 330 331 336 
  337 359 366 368 369 370 377 423 425 434 435 445 448 464 469 477 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "LESS" between rule 29 and rule 49 starting at line 279, column 20

ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .ShiftExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .ExpressionName 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "LBRACKET" between rule 29 and rule 49 starting at line 279, column 20

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "RPAREN" between rule 29 and rule 49 starting at line 279, column 20

CastExpression ::= LPAREN  .ReferenceType RPAREN UnaryExpressionNotPlusMinus 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= LPAREN  .Expression RPAREN 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= .ShiftExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .ExpressionName 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "RPAREN" between rule 29 and rule 32 starting at line 240, column 18

CastExpression ::= LPAREN  .ReferenceType RPAREN UnaryExpressionNotPlusMinus 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
CastExpression ::= LPAREN  .ReferenceType RPAREN UnaryExpressionNotPlusMinus 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "DOT" between rule 29 and rule 55 starting at line 288, column 19

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExpressionName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 109 on "DOT" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)




STATE 116 ----------------------------------------------------------------------
( 28 50 55 57 101 102 104 110 128 137 139 142 147 160 188 191 192 193 194 195 
  208 216 238 244 248 249 278 284 291 304 328 330 331 336 337 359 369 370 377 
  383 423 425 434 435 445 448 464 477 )

RelationalExpression ::= RelationalExpression  .LESS ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression  .LESS_EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .instanceof ReferenceType 
EqualityExpression ::= RelationalExpression . (413)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:906:24:906:47:29284:29307: Warning: Shift/reduce conflict in state 116 on "LESS" with rule 413

InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= RelationalExpression . (413)




STATE 117 ----------------------------------------------------------------------
( 28 50 55 57 101 102 104 110 128 137 139 142 147 160 188 189 190 191 192 193 
  194 195 208 216 238 244 248 249 278 284 291 304 328 330 331 336 337 359 369 
  370 377 383 423 425 434 435 445 448 464 477 )

ShiftExpression ::= ShiftExpression  .LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER GREATER 
                    AdditiveExpression 
RelationalExpression ::= ShiftExpression . (407)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:899:26:899:44:28886:28904: Warning: Shift/reduce conflict in state 117 on "GREATER" with rule 407

RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= ShiftExpression . (407)




STATE 127 ----------------------------------------------------------------------
( 32 )

FieldAccess ::= super DOT  .identifier 
MethodInvocation ::= super DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 

identifier ::= .IDENTIFIER 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 127 on "IDENTIFIER" with rule 538

MethodInvocation ::= super DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
TypeArgumentsopt ::= . (538)




STATE 140 ----------------------------------------------------------------------
( 45 )

ClassInstanceCreationExpression ::= Primary DOT  .new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
FieldAccess ::= Primary DOT  .identifier 
MethodInvocation ::= Primary DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 

identifier ::= .IDENTIFIER 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 140 on "IDENTIFIER" with rule 538

MethodInvocation ::= Primary DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
TypeArgumentsopt ::= . (538)




STATE 150 ----------------------------------------------------------------------
( 60 )

ConstructorModifier ::= Annotations . (167)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:474:25:474:39:13451:13465: Warning: Shift/reduce conflict in state 150 on "AT" with rule 167

ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifiers ::= ConstructorModifiers  .ConstructorModifier 
ConstructorModifier ::= Annotations . (167)




STATE 155 ----------------------------------------------------------------------
( 66 )

MethodModifier ::= Annotations . (143)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:439:20:439:34:12409:12423: Warning: Shift/reduce conflict in state 155 on "AT" with rule 143

MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifiers ::= MethodModifiers  .MethodModifier 
MethodModifier ::= Annotations . (143)




STATE 176 ----------------------------------------------------------------------
( 110 )

Type ::= PrimitiveType . (10)
CastExpression ::= LPAREN PrimitiveType  .Dimsopt RPAREN UnaryExpression 

Dims ::= .LBRACKET RBRACKET 
Dims ::= .Dims LBRACKET RBRACKET 
Dimsopt ::= . (448)
Dimsopt ::= .Dims 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:203:10:203:26:5608:5624: Warning: Shift/reduce conflict in state 176 on "LBRACKET" with rule 10

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= PrimitiveType . (10)




STATE 239 ----------------------------------------------------------------------
( 160 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)
SimpleName ::= identifier . (238)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 239 on "LESS" between rule 29 and rule 49 starting at line 279, column 20

ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .ShiftExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .ExpressionName 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 239 on "LBRACKET" between rule 29 and rule 49 starting at line 279, column 20

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 239 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 239 on "DOT" between rule 29 and rule 55 starting at line 288, column 19

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExpressionName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 239 on "DOT" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)




STATE 262 ----------------------------------------------------------------------
( 183 )

ShiftExpression ::= ShiftExpression  .LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER GREATER 
                    AdditiveExpression 
RelationalExpression ::= RelationalExpression LESS_EQUAL ShiftExpression .
                          (410)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:902:28:902:68:29069:29109: Warning: Shift/reduce conflict in state 262 on "GREATER" with rule 410

RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression LESS_EQUAL ShiftExpression .
                          (410)




STATE 264 ----------------------------------------------------------------------
( 184 )

ShiftExpression ::= ShiftExpression  .LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER GREATER 
                    AdditiveExpression 
RelationalExpression ::= RelationalExpression GREATER ShiftExpression . (409)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:901:28:901:67:29001:29040: Warning: Shift/reduce conflict in state 264 on "GREATER" with rule 409

RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression GREATER ShiftExpression . (409)




STATE 265 ----------------------------------------------------------------------
( 185 )

ShiftExpression ::= ShiftExpression  .LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER GREATER 
                    AdditiveExpression 
RelationalExpression ::= RelationalExpression LESS ShiftExpression . (408)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:900:28:900:67:28933:28972: Warning: Shift/reduce conflict in state 265 on "GREATER" with rule 408

RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression LESS ShiftExpression . (408)




STATE 269 ----------------------------------------------------------------------
( 189 )

RelationalExpression ::= RelationalExpression  .LESS ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression  .LESS_EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .instanceof ReferenceType 
EqualityExpression ::= EqualityExpression NOT_EQUAL RelationalExpression .
                        (415)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:908:26:908:69:29404:29447: Warning: Shift/reduce conflict in state 269 on "LESS" with rule 415

InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= EqualityExpression NOT_EQUAL RelationalExpression .
                        (415)




STATE 270 ----------------------------------------------------------------------
( 190 )

RelationalExpression ::= RelationalExpression  .LESS ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression  .LESS_EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .GREATER EQUAL ShiftExpression 
RelationalExpression ::= RelationalExpression  .instanceof ReferenceType 
EqualityExpression ::= EqualityExpression EQUAL_EQUAL RelationalExpression .
                        (414)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:907:26:907:69:29334:29377: Warning: Shift/reduce conflict in state 270 on "LESS" with rule 414

InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
ConstantDeclaration ::= ConstantModifiersopt Type  .VariableDeclarators 
VariableDeclarators ::= VariableDeclarators COMMA  .VariableDeclarator 
VariableDeclarator ::= VariableDeclaratorId EQUAL  .VariableInitializer 
VariableInitializer ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= LeftHandSide AssignmentOperator  .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= EqualityExpression EQUAL_EQUAL RelationalExpression .
                        (414)




STATE 276 ----------------------------------------------------------------------
( 197 )

FieldAccess ::= ClassName DOT super DOT  .identifier 
MethodInvocation ::= ClassName DOT super DOT  .TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 

identifier ::= .IDENTIFIER 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 276 on "IDENTIFIER" with rule 538

MethodInvocation ::= ClassName DOT super DOT  .TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
TypeArgumentsopt ::= . (538)




STATE 295 ----------------------------------------------------------------------
( 223 )

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ExplicitConstructorInvocation ::= .TypeArgumentsopt this LPAREN ArgumentListopt 
                                  RPAREN SEMICOLON 
ExplicitConstructorInvocation ::= .TypeArgumentsopt super LPAREN 
                                  ArgumentListopt RPAREN SEMICOLON 
ExplicitConstructorInvocation ::= .Primary DOT TypeArgumentsopt super LPAREN 
                                  ArgumentListopt RPAREN SEMICOLON 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
ExplicitConstructorInvocationopt ::= . (500)
ExplicitConstructorInvocationopt ::= .ExplicitConstructorInvocation 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "null" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "StringLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "CharacterLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "DoubleLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "FloatingPointLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "LongLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "IntegerLiteral" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "false" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "true" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "IDENTIFIER" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "double" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "float" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "char" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "long" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "int" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "short" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "byte" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "boolean" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "new" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 295 on "super" with rule 538

ExplicitConstructorInvocation ::= .TypeArgumentsopt super LPAREN 
                                  ArgumentListopt RPAREN SEMICOLON 
TypeArgumentsopt ::= . (538)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "super" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "LPAREN" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 295 on "this" with rule 538

ExplicitConstructorInvocation ::= .TypeArgumentsopt this LPAREN ArgumentListopt 
                                  RPAREN SEMICOLON 
TypeArgumentsopt ::= . (538)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "this" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1035:38:1035:47:33052:33061: Warning: Shift/reduce conflict in state 295 on "void" with rule 500

ConstructorBody ::= LBRACE  .ExplicitConstructorInvocationopt 
                    BlockStatementsopt RBRACE 
ExplicitConstructorInvocationopt ::= . (500)




STATE 307 ----------------------------------------------------------------------
( 238 )

ElementValues ::= ElementValues  .COMMA ElementValue 
ElementValuesopt ::= ElementValues . (469)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:988:24:988:38:31774:31788: Warning: Shift/reduce conflict in state 307 on "COMMA" with rule 469

ElementValueArrayInitializer ::= LBRACE  .ElementValuesopt Commaopt RBRACE 
ElementValuesopt ::= ElementValues . (469)




STATE 310 ----------------------------------------------------------------------
( 245 )

EnumBody ::= LBRACE  .EnumConstantsopt Commaopt EnumBodyDeclarationsopt RBRACE 

identifier ::= .IDENTIFIER 
EnumConstants ::= .EnumConstant 
EnumConstants ::= .EnumConstants COMMA EnumConstant 
EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
EnumConstant ::= .identifier 
EnumConstantsopt ::= . (494)
EnumConstantsopt ::= .EnumConstants 
Annotationsopt ::= . (524)
Annotationsopt ::= .Annotations 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1071:20:1071:29:33940:33949: Warning: Shift/reduce conflict in state 310 on "IDENTIFIER" with rule 524

EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotationsopt ::= . (524)




STATE 323 ----------------------------------------------------------------------
( 253 371 449 450 470 479 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)
LabeledStatement ::= identifier  .COLON Statement 
LabeledStatementNoShortIf ::= identifier  .COLON StatementNoShortIf 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 323 on "LBRACKET" between rule 29 and rule 49 starting at line 279, column 20

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 323 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 323 on "DOT" between rule 29 and rule 55 starting at line 288, column 19

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExpressionName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 323 on "DOT" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)




STATE 325 ----------------------------------------------------------------------
( 263 )

ShiftExpression ::= ShiftExpression  .LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER AdditiveExpression 
ShiftExpression ::= ShiftExpression  .GREATER GREATER GREATER 
                    AdditiveExpression 
RelationalExpression ::= RelationalExpression GREATER EQUAL ShiftExpression .
                          (411)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:903:28:903:69:29138:29179: Warning: Shift/reduce conflict in state 325 on "GREATER" with rule 411

RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= RelationalExpression GREATER EQUAL ShiftExpression .
                          (411)




STATE 335 ----------------------------------------------------------------------
( 284 )

VariableInitializers ::= VariableInitializers  .COMMA VariableInitializer 
VariableInitializersopt ::= VariableInitializers . (467)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:985:31:985:52:31695:31716: Warning: Shift/reduce conflict in state 335 on "COMMA" with rule 467

ArrayInitializer ::= LBRACE  .VariableInitializersopt Commaopt RBRACE 
VariableInitializersopt ::= VariableInitializers . (467)




STATE 339 ----------------------------------------------------------------------
( 290 )

SwitchBlock ::= LBRACE  .SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE 

SwitchBlockStatementGroups ::= .SwitchBlockStatementGroup 
SwitchBlockStatementGroups ::= .SwitchBlockStatementGroups 
                               SwitchBlockStatementGroup 
SwitchBlockStatementGroup ::= .SwitchLabels BlockStatements 
SwitchLabels ::= .SwitchLabel 
SwitchLabels ::= .SwitchLabels SwitchLabel 
SwitchLabel ::= .case ConstantExpression COLON 
SwitchLabel ::= .case EnumConstant COLON 
SwitchLabel ::= .default COLON 
SwitchBlockStatementGroupsopt ::= . (462)
SwitchBlockStatementGroupsopt ::= .SwitchBlockStatementGroups 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:978:35:978:44:31465:31474: Warning: Shift/reduce conflict in state 339 on "default" with rule 462

SwitchBlock ::= LBRACE  .SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE 
SwitchBlockStatementGroupsopt ::= . (462)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:978:35:978:44:31465:31474: Warning: Shift/reduce conflict in state 339 on "case" with rule 462

SwitchBlock ::= LBRACE  .SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE 
SwitchBlockStatementGroupsopt ::= . (462)




STATE 343 ----------------------------------------------------------------------
( 295 )

ConstructorBody ::= LBRACE ExplicitConstructorInvocationopt  .
                    BlockStatementsopt RBRACE 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 343 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 354 ----------------------------------------------------------------------
( 302 )

AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiers ::= .ConstantModifier 
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifier ::= .Annotation 
ConstantModifier ::= .public 
ConstantModifier ::= .static 
ConstantModifier ::= .final 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
AbstractMethodModifier ::= .public 
AbstractMethodModifier ::= .abstract 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
AnnotationTypeElementDeclaration ::= .EnumDeclaration 
AnnotationTypeElementDeclaration ::= .AnnotationTypeDeclaration 
AnnotationTypeElementDeclaration ::= .SEMICOLON 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
AnnotationTypeElementDeclarationsopt ::= . (474)
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AbstractMethodModifiersopt ::= . (476)
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
ConstantModifiersopt ::= . (478)
ConstantModifiersopt ::= .ConstantModifiers 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 354 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "IDENTIFIER" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "short" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "long" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "int" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "float" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "double" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "char" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "byte" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 354 on "boolean" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)




STATE 362 ----------------------------------------------------------------------
( 310 )

EnumConstants ::= EnumConstants  .COMMA EnumConstant 
EnumConstantsopt ::= EnumConstants . (495)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1027:24:1027:38:32851:32865: Warning: Shift/reduce conflict in state 362 on "COMMA" with rule 495

EnumBody ::= LBRACE  .EnumConstantsopt Commaopt EnumBodyDeclarationsopt RBRACE 
EnumConstantsopt ::= EnumConstants . (495)




STATE 368 ----------------------------------------------------------------------
( 320 )

BasicForStatement ::= for LPAREN  .ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
ForStatementNoShortIf ::= for LPAREN  .ForInitopt SEMICOLON Expressionopt 
                          SEMICOLON ForUpdateopt RPAREN StatementNoShortIf 
EnhancedForStatement ::= for LPAREN  .FormalParameter COLON Expression RPAREN 
                         Statement 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
ForInit ::= .StatementExpressionList 
ForInit ::= .LocalVariableDeclaration 
StatementExpressionList ::= .StatementExpression 
StatementExpressionList ::= .StatementExpressionList COMMA StatementExpression 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
ForInitopt ::= . (458)
ForInitopt ::= .ForInit 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "IDENTIFIER" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "boolean" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "char" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "long" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "int" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "short" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "byte" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "double" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 368 on "float" with rule 464

FormalParameter ::= .VariableModifiersopt Type VariableDeclaratorId 
VariableModifiersopt ::= . (464)




STATE 383 ----------------------------------------------------------------------
( 339 381 384 385 427 )

SwitchLabel ::= case  .ConstantExpression COLON 
SwitchLabel ::= case  .EnumConstant COLON 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
EnumConstant ::= .identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 
MultiplicativeExpression ::= .UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression MULTIPLY UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression DIVIDE UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression REMAINDER 
                             UnaryExpression 
AdditiveExpression ::= .MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression PLUS MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression MINUS MultiplicativeExpression 
ShiftExpression ::= .AdditiveExpression 
ShiftExpression ::= .ShiftExpression LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER GREATER AdditiveExpression 
RelationalExpression ::= .ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
EqualityExpression ::= .RelationalExpression 
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
AndExpression ::= .EqualityExpression 
AndExpression ::= .AndExpression AND EqualityExpression 
ExclusiveOrExpression ::= .AndExpression 
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
AssignmentExpression ::= .ConditionalExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
Expression ::= .AssignmentExpression 
ConstantExpression ::= .Expression 
Annotationsopt ::= . (524)
Annotationsopt ::= .Annotations 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1071:20:1071:29:33940:33949: Warning: Shift/reduce conflict in state 383 on "IDENTIFIER" with rule 524

EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotationsopt ::= . (524)




STATE 384 ----------------------------------------------------------------------
( 339 385 )

SwitchBlockStatementGroup ::= SwitchLabels  .BlockStatements 
SwitchLabels ::= SwitchLabels  .SwitchLabel 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
SwitchLabel ::= .case ConstantExpression COLON 
SwitchLabel ::= .case EnumConstant COLON 
SwitchLabel ::= .default COLON 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 384 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 385 ----------------------------------------------------------------------
( 339 )

SwitchBlockStatementGroups ::= SwitchBlockStatementGroups  .
                               SwitchBlockStatementGroup 
SwitchBlockStatementGroupsopt ::= SwitchBlockStatementGroups . (463)

SwitchBlockStatementGroup ::= .SwitchLabels BlockStatements 
SwitchLabels ::= .SwitchLabel 
SwitchLabels ::= .SwitchLabels SwitchLabel 
SwitchLabel ::= .case ConstantExpression COLON 
SwitchLabel ::= .case EnumConstant COLON 
SwitchLabel ::= .default COLON 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:979:37:979:64:31512:31539: Warning: Shift/reduce conflict in state 385 on "default" with rule 463

SwitchBlock ::= LBRACE  .SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE 
SwitchBlockStatementGroupsopt ::= SwitchBlockStatementGroups . (463)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:979:37:979:64:31512:31539: Warning: Shift/reduce conflict in state 385 on "case" with rule 463

SwitchBlock ::= LBRACE  .SwitchBlockStatementGroupsopt SwitchLabelsopt RBRACE 
SwitchBlockStatementGroupsopt ::= SwitchBlockStatementGroups . (463)




STATE 390 ----------------------------------------------------------------------
( 345 )

ExplicitConstructorInvocation ::= Primary DOT  .TypeArgumentsopt super LPAREN 
                                  ArgumentListopt RPAREN SEMICOLON 
ClassInstanceCreationExpression ::= Primary DOT  .new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
FieldAccess ::= Primary DOT  .identifier 
MethodInvocation ::= Primary DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 

identifier ::= .IDENTIFIER 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1092:22:1092:31:34488:34497: Warning: Shift/reduce conflict in state 390 on "IDENTIFIER" with rule 538

MethodInvocation ::= Primary DOT  .TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
TypeArgumentsopt ::= . (538)




STATE 393 ----------------------------------------------------------------------
( 349 )

ArrayType ::= Type  .LBRACKET RBRACKET 
FormalParameter ::= VariableModifiersopt Type  .VariableDeclaratorId 
LastFormalParameter ::= VariableModifiersopt Type  .Ellipsisopt 
                        VariableDeclaratorId 

identifier ::= .IDENTIFIER 
VariableDeclaratorId ::= .identifier 
VariableDeclaratorId ::= .VariableDeclaratorId LBRACKET RBRACKET 
Ellipsisopt ::= . (504)
Ellipsisopt ::= .ELLIPSIS 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1041:12:1041:21:33239:33248: Warning: Shift/reduce conflict in state 393 on "IDENTIFIER" with rule 504

LastFormalParameter ::= VariableModifiersopt Type  .Ellipsisopt 
                        VariableDeclaratorId 
Ellipsisopt ::= . (504)




STATE 400 ----------------------------------------------------------------------
( 354 411 )

InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "IDENTIFIER" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "strictfp" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "static" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "short" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "public" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "protected" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "private" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "long" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "interface" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "int" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "float" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "final" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "enum" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "double" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "class" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "char" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "byte" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "boolean" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "abstract" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "RBRACE" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "AT" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:501:28:501:54:14465:14491: Warning: Reduce/reduce conflict in state 400 on "SEMICOLON" between rule 183 and rule 226 starting at line 566, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
InterfaceDeclaration ::= AnnotationTypeDeclaration . (183)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= AnnotationTypeDeclaration . (226)




STATE 401 ----------------------------------------------------------------------
( 354 411 )

ClassDeclaration ::= EnumDeclaration . (75)
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "IDENTIFIER" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "strictfp" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "static" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "short" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "public" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "protected" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "private" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "long" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "interface" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "int" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "float" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "final" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "enum" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "double" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "class" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "char" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "byte" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "boolean" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "abstract" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "RBRACE" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeBody ::= LBRACE  .AnnotationTypeElementDeclarationsopt RBRACE 
AnnotationTypeElementDeclarationsopt ::= .AnnotationTypeElementDeclarations 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "AT" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:323:24:323:40:8800:8816: Warning: Reduce/reduce conflict in state 401 on "SEMICOLON" between rule 75 and rule 225 starting at line 565, column 40

AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
ClassDeclaration ::= EnumDeclaration . (75)
------------------------------------------------------------------------------
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclarations 
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarations ::= .AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclaration ::= EnumDeclaration . (225)




STATE 402 ----------------------------------------------------------------------
( 354 411 412 441 )

ClassModifier ::= final . (85)
ConstantModifier ::= final . (210)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 402 on "static" between rule 85 and rule 210 starting at line 543, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= final . (210)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 402 on "public" between rule 85 and rule 210 starting at line 543, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= final . (210)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 402 on "final" between rule 85 and rule 210 starting at line 543, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= final . (210)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:336:21:336:27:9231:9237: Warning: Reduce/reduce conflict in state 402 on "AT" between rule 85 and rule 210 starting at line 543, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= final . (85)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= final . (210)




STATE 403 ----------------------------------------------------------------------
( 354 411 412 441 )

ClassModifier ::= static . (84)
InterfaceModifier ::= static . (192)
ConstantModifier ::= static . (209)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "strictfp" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "protected" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "private" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "abstract" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "static" between rule 84 and rule 209 starting at line 542, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= static . (209)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "static" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "public" between rule 84 and rule 209 starting at line 542, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= static . (209)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "public" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "final" between rule 84 and rule 209 starting at line 542, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= static . (209)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "AT" between rule 84 and rule 209 starting at line 542, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= static . (209)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:335:21:335:28:9202:9209: Warning: Reduce/reduce conflict in state 403 on "AT" between rule 84 and rule 192 starting at line 513, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= static . (84)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= static . (192)




STATE 406 ----------------------------------------------------------------------
( 354 411 412 441 )

ClassModifier ::= Annotation . (79)
InterfaceModifier ::= Annotation . (187)
ConstantModifier ::= Annotation . (207)
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "strictfp" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "protected" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "private" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "static" between rule 79 and rule 207 starting at line 540, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "static" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "final" between rule 79 and rule 207 starting at line 540, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "IDENTIFIER" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "short" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "public" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "public" between rule 79 and rule 207 starting at line 540, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "public" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "long" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "int" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "float" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "double" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "char" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "byte" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:540:22:540:35:15895:15908: Warning: Reduce/reduce conflict in state 406 on "boolean" between rule 207 and rule 229 starting at line 571, column 17

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "abstract" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "abstract" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "AT" between rule 79 and rule 229 starting at line 571, column 17

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
Annotations ::= Annotation . (229)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "AT" between rule 79 and rule 207 starting at line 540, column 22

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= Annotation . (207)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:330:19:330:32:9045:9058: Warning: Reduce/reduce conflict in state 406 on "AT" between rule 79 and rule 187 starting at line 508, column 23

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= Annotation . (79)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= Annotation . (187)




STATE 407 ----------------------------------------------------------------------
( 354 411 412 441 )

ClassModifier ::= abstract . (83)
InterfaceModifier ::= abstract . (191)
AbstractMethodModifier ::= abstract . (216)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "strictfp" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "static" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "protected" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "private" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "public" between rule 83 and rule 216 starting at line 552, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= abstract . (216)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "public" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "abstract" between rule 83 and rule 216 starting at line 552, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= abstract . (216)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "abstract" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "AT" between rule 83 and rule 216 starting at line 552, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= abstract . (216)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:334:21:334:30:9171:9180: Warning: Reduce/reduce conflict in state 407 on "AT" between rule 83 and rule 191 starting at line 512, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= abstract . (83)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= abstract . (191)




STATE 408 ----------------------------------------------------------------------
( 354 411 412 441 )

ClassModifier ::= public . (80)
InterfaceModifier ::= public . (188)
ConstantModifier ::= public . (208)
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "strictfp" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "protected" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "private" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "static" between rule 80 and rule 208 starting at line 541, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "static" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "final" between rule 80 and rule 208 starting at line 541, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "IDENTIFIER" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "short" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "public" between rule 80 and rule 215 starting at line 551, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "public" between rule 80 and rule 208 starting at line 541, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "public" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "long" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "int" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "float" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "double" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "char" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "byte" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:541:24:541:31:15933:15940: Warning: Reduce/reduce conflict in state 408 on "boolean" between rule 208 and rule 215 starting at line 551, column 30

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= .ConstantModifiers 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)
------------------------------------------------------------------------------
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "abstract" between rule 80 and rule 215 starting at line 551, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "abstract" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "AT" between rule 80 and rule 215 starting at line 551, column 30

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= public . (215)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "AT" between rule 80 and rule 208 starting at line 541, column 24

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifiers ::= .ConstantModifier 
ConstantModifier ::= public . (208)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:331:21:331:28:9080:9087: Warning: Reduce/reduce conflict in state 408 on "AT" between rule 80 and rule 188 starting at line 509, column 25

ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifiers ::= .ClassModifier 
ClassModifier ::= public . (80)
------------------------------------------------------------------------------
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifier ::= public . (188)




STATE 409 ----------------------------------------------------------------------
( 354 410 411 412 441 )

AbstractMethodModifier ::= Annotations . (214)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:550:28:550:42:16300:16314: Warning: Shift/reduce conflict in state 409 on "AT" with rule 214

AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifier ::= Annotations . (214)




STATE 411 ----------------------------------------------------------------------
( 354 )

AnnotationTypeElementDeclarations ::= AnnotationTypeElementDeclarations  .
                                      AnnotationTypeElementDeclaration 
AnnotationTypeElementDeclarationsopt ::= AnnotationTypeElementDeclarations .
                                         (475)

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiers ::= .ConstantModifier 
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifier ::= .Annotation 
ConstantModifier ::= .public 
ConstantModifier ::= .static 
ConstantModifier ::= .final 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
AbstractMethodModifier ::= .public 
AbstractMethodModifier ::= .abstract 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AnnotationTypeElementDeclaration ::= .ConstantDeclaration 
AnnotationTypeElementDeclaration ::= .ClassDeclaration 
AnnotationTypeElementDeclaration ::= .InterfaceDeclaration 
AnnotationTypeElementDeclaration ::= .EnumDeclaration 
AnnotationTypeElementDeclaration ::= .AnnotationTypeDeclaration 
AnnotationTypeElementDeclaration ::= .SEMICOLON 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
AbstractMethodModifiersopt ::= . (476)
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
ConstantModifiersopt ::= . (478)
ConstantModifiersopt ::= .ConstantModifiers 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 411 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "IDENTIFIER" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "short" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "long" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "int" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "float" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "double" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "char" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "byte" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:999:32:999:41:32107:32116: Warning: Reduce/reduce conflict in state 411 on "boolean" between rule 476 and rule 478 starting at line 1002, column 26

AnnotationTypeElementDeclaration ::= .AbstractMethodModifiersopt Type 
                                     identifier LPAREN RPAREN DefaultValueopt 
                                     SEMICOLON 
AbstractMethodModifiersopt ::= . (476)
------------------------------------------------------------------------------
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)




STATE 412 ----------------------------------------------------------------------
( 355 )

InterfaceBody ::= LBRACE  .InterfaceMemberDeclarationsopt RBRACE 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclaration 
InterfaceMemberDeclarations ::= .InterfaceMemberDeclarations 
                                InterfaceMemberDeclaration 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
InterfaceMemberDeclaration ::= .AbstractMethodDeclaration 
InterfaceMemberDeclaration ::= .ClassDeclaration 
InterfaceMemberDeclaration ::= .InterfaceDeclaration 
InterfaceMemberDeclaration ::= .SEMICOLON 
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiers ::= .ConstantModifier 
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifier ::= .Annotation 
ConstantModifier ::= .public 
ConstantModifier ::= .static 
ConstantModifier ::= .final 
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
AbstractMethodModifier ::= .public 
AbstractMethodModifier ::= .abstract 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
AbstractMethodModifiersopt ::= . (476)
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
ConstantModifiersopt ::= . (478)
ConstantModifiersopt ::= .ConstantModifiers 
InterfaceMemberDeclarationsopt ::= . (480)
InterfaceMemberDeclarationsopt ::= .InterfaceMemberDeclarations 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 412 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "IDENTIFIER" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "short" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "long" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "int" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "float" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "double" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "char" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "byte" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 412 on "boolean" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)




STATE 416 ----------------------------------------------------------------------
( 362 )

EnumConstants ::= EnumConstants COMMA  .EnumConstant 

identifier ::= .IDENTIFIER 
EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
EnumConstant ::= .identifier 
Annotationsopt ::= . (524)
Annotationsopt ::= .Annotations 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1071:20:1071:29:33940:33949: Warning: Shift/reduce conflict in state 416 on "IDENTIFIER" with rule 524

EnumConstant ::= .Annotationsopt identifier Argumentsopt ClassBodyopt 
Annotationsopt ::= . (524)




STATE 417 ----------------------------------------------------------------------
( 364 424 444 463 )

ClassBody ::= LBRACE  .ClassBodyDeclarationsopt RBRACE 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
ClassBodyDeclarations ::= .ClassBodyDeclaration 
ClassBodyDeclarations ::= .ClassBodyDeclarations ClassBodyDeclaration 
ClassBodyDeclaration ::= .ClassMemberDeclaration 
ClassBodyDeclaration ::= .InstanceInitializer 
ClassBodyDeclaration ::= .StaticInitializer 
ClassBodyDeclaration ::= .ConstructorDeclaration 
ClassMemberDeclaration ::= .FieldDeclaration 
ClassMemberDeclaration ::= .MethodDeclaration 
ClassMemberDeclaration ::= .ClassDeclaration 
ClassMemberDeclaration ::= .InterfaceDeclaration 
ClassMemberDeclaration ::= .SEMICOLON 
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiers ::= .FieldModifier 
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifier ::= .Annotation 
FieldModifier ::= .public 
FieldModifier ::= .protected 
FieldModifier ::= .private 
FieldModifier ::= .static 
FieldModifier ::= .final 
FieldModifier ::= .transient 
FieldModifier ::= .volatile 
MethodDeclaration ::= .MethodHeader MethodBody 
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiers ::= .MethodModifier 
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifier ::= .Annotations 
MethodModifier ::= .public 
MethodModifier ::= .protected 
MethodModifier ::= .private 
MethodModifier ::= .abstract 
MethodModifier ::= .static 
MethodModifier ::= .final 
MethodModifier ::= .synchronized 
MethodModifier ::= .native 
MethodModifier ::= .strictfp 
InstanceInitializer ::= .Block 
StaticInitializer ::= .static Block 
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifier ::= .Annotations 
ConstructorModifier ::= .public 
ConstructorModifier ::= .protected 
ConstructorModifier ::= .private 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ConstructorModifiersopt ::= . (502)
ConstructorModifiersopt ::= .ConstructorModifiers 
MethodModifiersopt ::= . (510)
MethodModifiersopt ::= .MethodModifiers 
FieldModifiersopt ::= . (512)
FieldModifiersopt ::= .FieldModifiers 
ClassBodyDeclarationsopt ::= . (514)
ClassBodyDeclarationsopt ::= .ClassBodyDeclarations 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 417 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "short" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "long" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "int" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "float" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "double" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "char" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "byte" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "boolean" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "IDENTIFIER" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "IDENTIFIER" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 417 on "LESS" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)




STATE 430 ----------------------------------------------------------------------
( 383 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)
EnumConstant ::= identifier . (307)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 430 on "LESS" between rule 29 and rule 49 starting at line 279, column 20

ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .ShiftExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .ExpressionName 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 430 on "LBRACKET" between rule 29 and rule 49 starting at line 279, column 20

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ExpressionName ::= identifier . (49)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 430 on "LBRACKET" between rule 29 and rule 32 starting at line 240, column 18

ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ArrayType ::= .Type LBRACKET RBRACKET 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 430 on "DOT" between rule 29 and rule 55 starting at line 288, column 19

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
ExpressionName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= identifier . (55)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:235:14:235:27:6340:6353: Warning: Reduce/reduce conflict in state 430 on "DOT" between rule 29 and rule 32 starting at line 240, column 18

PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .ClassOrInterfaceType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= identifier . (29)
------------------------------------------------------------------------------
PrimaryNoNewArray ::= .Type DOT class 
Type ::= .ReferenceType 
ReferenceType ::= .TypeVariable 
TypeVariable ::= identifier . (32)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:279:20:279:33:7394:7407: Warning: Reduce/reduce conflict in state 430 on "COLON" between rule 49 and rule 307 starting at line 725, column 18

SwitchLabel ::= case  .ConstantExpression COLON 
ConstantExpression ::= .Expression 
Expression ::= .AssignmentExpression 
AssignmentExpression ::= .ConditionalExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
ExclusiveOrExpression ::= .AndExpression 
AndExpression ::= .EqualityExpression 
EqualityExpression ::= .RelationalExpression 
RelationalExpression ::= .ShiftExpression 
ShiftExpression ::= .AdditiveExpression 
AdditiveExpression ::= .MultiplicativeExpression 
MultiplicativeExpression ::= .UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
PostfixExpression ::= .ExpressionName 
ExpressionName ::= identifier . (49)
------------------------------------------------------------------------------
SwitchLabel ::= case  .EnumConstant COLON 
EnumConstant ::= identifier . (307)




STATE 431 ----------------------------------------------------------------------
( 384 )

BlockStatements ::= BlockStatements  .BlockStatement 
SwitchBlockStatementGroup ::= SwitchLabels BlockStatements . (301)

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "double" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "float" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "char" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "long" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "int" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "short" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "byte" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "boolean" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:981:26:981:35:31567:31576: Warning: Shift/reduce conflict in state 431 on "IDENTIFIER" with rule 464

LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
VariableModifiersopt ::= . (464)




STATE 441 ----------------------------------------------------------------------
( 412 )

InterfaceMemberDeclarations ::= InterfaceMemberDeclarations  .
                                InterfaceMemberDeclaration 
InterfaceMemberDeclarationsopt ::= InterfaceMemberDeclarations . (481)

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
InterfaceMemberDeclaration ::= .ConstantDeclaration 
InterfaceMemberDeclaration ::= .AbstractMethodDeclaration 
InterfaceMemberDeclaration ::= .ClassDeclaration 
InterfaceMemberDeclaration ::= .InterfaceDeclaration 
InterfaceMemberDeclaration ::= .SEMICOLON 
ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiers ::= .ConstantModifier 
ConstantModifiers ::= .ConstantModifiers ConstantModifier 
ConstantModifier ::= .Annotation 
ConstantModifier ::= .public 
ConstantModifier ::= .static 
ConstantModifier ::= .final 
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiers ::= .AbstractMethodModifier 
AbstractMethodModifiers ::= .AbstractMethodModifiers AbstractMethodModifier 
AbstractMethodModifier ::= .Annotations 
AbstractMethodModifier ::= .public 
AbstractMethodModifier ::= .abstract 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
AbstractMethodModifiersopt ::= . (476)
AbstractMethodModifiersopt ::= .AbstractMethodModifiers 
ConstantModifiersopt ::= . (478)
ConstantModifiersopt ::= .ConstantModifiers 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 441 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "IDENTIFIER" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "short" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "long" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "int" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "float" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "double" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "char" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "byte" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1002:26:1002:35:32203:32212: Warning: Reduce/reduce conflict in state 441 on "boolean" between rule 478 and rule 476 starting at line 999, column 32

ConstantDeclaration ::= .ConstantModifiersopt Type VariableDeclarators 
ConstantModifiersopt ::= . (478)
------------------------------------------------------------------------------
AbstractMethodDeclaration ::= .AbstractMethodModifiersopt TypeParametersopt 
                              ResultType MethodDeclarator Throwsopt SEMICOLON 
AbstractMethodModifiersopt ::= . (476)




STATE 443 ----------------------------------------------------------------------
( 414 )

EnumBodyDeclarations ::= SEMICOLON  .ClassBodyDeclarationsopt 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
ClassBodyDeclarations ::= .ClassBodyDeclaration 
ClassBodyDeclarations ::= .ClassBodyDeclarations ClassBodyDeclaration 
ClassBodyDeclaration ::= .ClassMemberDeclaration 
ClassBodyDeclaration ::= .InstanceInitializer 
ClassBodyDeclaration ::= .StaticInitializer 
ClassBodyDeclaration ::= .ConstructorDeclaration 
ClassMemberDeclaration ::= .FieldDeclaration 
ClassMemberDeclaration ::= .MethodDeclaration 
ClassMemberDeclaration ::= .ClassDeclaration 
ClassMemberDeclaration ::= .InterfaceDeclaration 
ClassMemberDeclaration ::= .SEMICOLON 
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiers ::= .FieldModifier 
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifier ::= .Annotation 
FieldModifier ::= .public 
FieldModifier ::= .protected 
FieldModifier ::= .private 
FieldModifier ::= .static 
FieldModifier ::= .final 
FieldModifier ::= .transient 
FieldModifier ::= .volatile 
MethodDeclaration ::= .MethodHeader MethodBody 
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiers ::= .MethodModifier 
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifier ::= .Annotations 
MethodModifier ::= .public 
MethodModifier ::= .protected 
MethodModifier ::= .private 
MethodModifier ::= .abstract 
MethodModifier ::= .static 
MethodModifier ::= .final 
MethodModifier ::= .synchronized 
MethodModifier ::= .native 
MethodModifier ::= .strictfp 
InstanceInitializer ::= .Block 
StaticInitializer ::= .static Block 
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifier ::= .Annotations 
ConstructorModifier ::= .public 
ConstructorModifier ::= .protected 
ConstructorModifier ::= .private 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ConstructorModifiersopt ::= . (502)
ConstructorModifiersopt ::= .ConstructorModifiers 
MethodModifiersopt ::= . (510)
MethodModifiersopt ::= .MethodModifiers 
FieldModifiersopt ::= . (512)
FieldModifiersopt ::= .FieldModifiers 
ClassBodyDeclarationsopt ::= . (514)
ClassBodyDeclarationsopt ::= .ClassBodyDeclarations 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1011:27:1011:36:32486:32495: Warning: Shift/reduce conflict in state 443 on "AT" with rule 484

AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
InterfaceModifiersopt ::= . (484)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "short" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "long" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "int" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "float" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "double" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "char" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "byte" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "boolean" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "IDENTIFIER" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "IDENTIFIER" between rule 510 and rule 512 starting at line 1053, column 23

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiersopt ::= . (512)

/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:1050:24:1050:33:33434:33443: Warning: Reduce/reduce conflict in state 443 on "LESS" between rule 510 and rule 502 starting at line 1038, column 29

MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiersopt ::= . (510)
------------------------------------------------------------------------------
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiersopt ::= . (502)



/Users/rmfuhrer/eclipse/workspaces/imp-3.5-release/org.eclipse.imp.lpg.ide/src/org/eclipse/imp/lpg/parser/GJavaParser.g:163:5:163:19:4297:4311: Warning: Grammar is not LALR(1) - it contains 546 reduce/reduce conflicts and 161 shift/reduce conflicts.


 IBM LALR Parser Generator              2.0.17 (May 18 2009)

Shift STATES: 


STATE 1 ------------------------------------------------------------------------
( )

'$accept' ::= .CompilationUnit 

CompilationUnit ::= .ClassBodyDeclarationsoptMarker ClassBodyDeclarationsopt 
CompilationUnit ::= .LPGUserActionMarker LPGUserAction 
CompilationUnit ::= .PackageDeclarationopt ImportDeclarationsopt 
                    TypeDeclarationsopt 
PackageDeclaration ::= .Annotationsopt package PackageName SEMICOLON 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Annotationsopt ::= . (524)
Annotationsopt ::= .Annotations 
PackageDeclarationopt ::= . (530)
PackageDeclarationopt ::= .PackageDeclaration 

AT                                Shift  7
                                  Reduce 530
LPGUserActionMarker               Shift  4
ClassBodyDeclarationsoptMarker    Shift  5

CompilationUnit                   Goto   2
PackageDeclarationopt             Goto   3
Annotationsopt                    Goto   6
Annotation                        Gt/Rd  229
SingleElementAnnotation           Gt/Rd  233
MarkerAnnotation                  Gt/Rd  232
NormalAnnotation                  Gt/Rd  231
Annotations                       Goto   8
PackageDeclaration                Gt/Rd  531

EOF_TOKEN                         Reduce 530
strictfp                          Reduce 530
static                            Reduce 530
public                            Reduce 530
protected                         Reduce 530
private                           Reduce 530
interface                         Reduce 530
import                            Reduce 530
final                             Reduce 530
enum                              Reduce 530
class                             Reduce 530
abstract                          Reduce 530
SEMICOLON                         Reduce 530
package                           Reduce 524

Default reduction to rule  530


STATE 2 ------------------------------------------------------------------------
( 1 )

'$accept' ::= CompilationUnit . (0)

EOF_TOKEN    Accept


STATE 3 ------------------------------------------------------------------------
( 1 )

CompilationUnit ::= PackageDeclarationopt  .ImportDeclarationsopt 
                    TypeDeclarationsopt 

ImportDeclarations ::= .ImportDeclaration 
ImportDeclarations ::= .ImportDeclarations ImportDeclaration 
ImportDeclaration ::= .SingleTypeImportDeclaration 
ImportDeclaration ::= .TypeImportOnDemandDeclaration 
ImportDeclaration ::= .SingleStaticImportDeclaration 
ImportDeclaration ::= .StaticImportOnDemandDeclaration 
SingleTypeImportDeclaration ::= .import TypeName SEMICOLON 
TypeImportOnDemandDeclaration ::= .import PackageOrTypeName DOT MULTIPLY 
                                  SEMICOLON 
SingleStaticImportDeclaration ::= .import static TypeName DOT identifier 
                                  SEMICOLON 
StaticImportOnDemandDeclaration ::= .import static TypeName DOT MULTIPLY 
                                    SEMICOLON 
ImportDeclarationsopt ::= . (528)
ImportDeclarationsopt ::= .ImportDeclarations 

import                             Shift  10

ImportDeclarationsopt              Goto   9
StaticImportOnDemandDeclaration    Gt/Rd  66
SingleStaticImportDeclaration      Gt/Rd  65
TypeImportOnDemandDeclaration      Gt/Rd  64
SingleTypeImportDeclaration        Gt/Rd  63
ImportDeclarations                 Goto   11
ImportDeclaration                  Gt/Rd  58

EOF_TOKEN                          Reduce 528
strictfp                           Reduce 528
static                             Reduce 528
public                             Reduce 528
protected                          Reduce 528
private                            Reduce 528
interface                          Reduce 528
final                              Reduce 528
enum                               Reduce 528
class                              Reduce 528
abstract                           Reduce 528
AT                                 Reduce 528
SEMICOLON                          Reduce 528

Default reduction to rule  528


STATE 4 ------------------------------------------------------------------------
( 1 )

CompilationUnit ::= LPGUserActionMarker  .LPGUserAction 

identifier ::= .IDENTIFIER 
LPGUserAction ::= .BlockStatementsopt 
LPGUserAction ::= .BeginAction BlockStatementsopt EndAction 
LPGUserAction ::= .BeginJava BlockStatementsopt EndJava 
LPGUserAction ::= .NoAction 
LPGUserAction ::= .NullAction 
LPGUserAction ::= .BadAction 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

IDENTIFIER                              Sh/Rd  3
                                        Reduce 464
boolean                                 Sh/Rd  13
                                        Reduce 464
char                                    Sh/Rd  20
                                        Reduce 464
long                                    Sh/Rd  19
                                        Reduce 464
int                                     Sh/Rd  18
                                        Reduce 464
short                                   Sh/Rd  17
                                        Reduce 464
byte                                    Sh/Rd  16
                                        Reduce 464
double                                  Sh/Rd  22
                                        Reduce 464
float                                   Sh/Rd  21
                                        Reduce 464
BadAction                               Sh/Rd  9
NullAction                              Sh/Rd  8
NoAction                                Sh/Rd  7
BeginJava                               Shift  12
BeginAction                             Shift  13
AT                                      Shift  7
strictfp                                Sh/Rd  86
final                                   Shift  18
static                                  Sh/Rd  84
abstract                                Sh/Rd  83
private                                 Sh/Rd  82
protected                               Sh/Rd  81
public                                  Sh/Rd  80
for                                     Shift  22
while                                   Shift  23
if                                      Shift  24
LBRACE                                  Shift  25
SEMICOLON                               Sh/Rd  284
LPAREN                                  Shift  28
this                                    Sh/Rd  337
void                                    Shift  29
super                                   Shift  32
false                                   Sh/Rd  353
true                                    Sh/Rd  352
null                                    Sh/Rd  351
StringLiteral                           Sh/Rd  350
CharacterLiteral                        Sh/Rd  349
DoubleLiteral                           Sh/Rd  347
FloatingPointLiteral                    Sh/Rd  346
LongLiteral                             Sh/Rd  345
IntegerLiteral                          Sh/Rd  344
new                                     Shift  37
PLUS_PLUS                               Shift  41
MINUS_MINUS                             Shift  42
assert                                  Shift  50
switch                                  Shift  51
do                                      Shift  52
break                                   Shift  53
continue                                Shift  54
return                                  Shift  55
synchronized                            Shift  56
throw                                   Shift  57
try                                     Shift  58

LPGUserAction                           Gt/Rd  2
BlockStatementsopt                      Gt/Rd  4
BlockStatement                          Gt/Rd  251
LocalVariableDeclaration                Goto   14
SingleElementAnnotation                 Gt/Rd  233
MarkerAnnotation                        Gt/Rd  232
NormalAnnotation                        Gt/Rd  231
Annotations                             Goto   15
VariableModifiers                       Goto   16
VariableModifier                        Gt/Rd  136
VariableModifiersopt                    Goto   17
EnumDeclaration                         Gt/Rd  75
NormalClassDeclaration                  Gt/Rd  74
Annotation                              Goto   19
ClassModifiers                          Goto   20
ClassModifier                           Gt/Rd  77
ClassModifiersopt                       Goto   21
ForStatement                            Gt/Rd  263
WhileStatement                          Gt/Rd  262
IfThenElseStatement                     Gt/Rd  261
IfThenStatement                         Gt/Rd  260
LabeledStatement                        Gt/Rd  259
StatementWithoutTrailingSubstatement    Gt/Rd  258
EnhancedForStatement                    Gt/Rd  312
BasicForStatement                       Gt/Rd  311
StatementExpression                     Goto   26
LeftHandSide                            Goto   27
Literal                                 Gt/Rd  334
AmbiguousName                           Goto   30
ClassName                               Goto   31
MethodName                              Goto   33
NumericType                             Gt/Rd  12
FloatingPointType                       Gt/Rd  15
IntegralType                            Gt/Rd  14
ArrayType                               Gt/Rd  25
TypeVariable                            Gt/Rd  24
ClassOrInterfaceType                    Gt/Rd  23
Type                                    Goto   34
TypeName                                Goto   35
identifier                              Goto   36
ClassType                               Gt/Rd  26
ReferenceType                           Gt/Rd  11
PrimitiveType                           Gt/Rd  10
BooleanLiteral                          Gt/Rd  348
ArrayCreationExpression                 Gt/Rd  333
PrimaryNoNewArray                       Goto   38
ArrayAccess                             Goto   39
FieldAccess                             Goto   40
PostfixExpression                       Goto   43
ExpressionName                          Goto   44
Primary                                 Goto   45
ClassInstanceCreationExpression         Goto   46
MethodInvocation                        Goto   47
PostDecrementExpression                 Goto   48
PostIncrementExpression                 Goto   49
PreDecrementExpression                  Gt/Rd  290
PreIncrementExpression                  Gt/Rd  289
Assignment                              Gt/Rd  288
TryStatement                            Gt/Rd  275
ThrowStatement                          Gt/Rd  274
SynchronizedStatement                   Gt/Rd  273
ReturnStatement                         Gt/Rd  272
ContinueStatement                       Gt/Rd  271
BreakStatement                          Gt/Rd  270
DoStatement                             Gt/Rd  269
SwitchStatement                         Gt/Rd  268
AssertStatement                         Gt/Rd  267
ExpressionStatement                     Gt/Rd  266
EmptyStatement                          Gt/Rd  265
Block                                   Gt/Rd  264
Statement                               Gt/Rd  255
ClassDeclaration                        Gt/Rd  254
LocalVariableDeclarationStatement       Gt/Rd  253
BlockStatements                         Goto   59

EOF_TOKEN                               Reduce 498
enum                                    Reduce 522
class                                   Reduce 522

Default reduction to rule  522


STATE 5 ------------------------------------------------------------------------
( 1 )

CompilationUnit ::= ClassBodyDeclarationsoptMarker  .ClassBodyDeclarationsopt 

ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
ClassBodyDeclarations ::= .ClassBodyDeclaration 
ClassBodyDeclarations ::= .ClassBodyDeclarations ClassBodyDeclaration 
ClassBodyDeclaration ::= .ClassMemberDeclaration 
ClassBodyDeclaration ::= .InstanceInitializer 
ClassBodyDeclaration ::= .StaticInitializer 
ClassBodyDeclaration ::= .ConstructorDeclaration 
ClassMemberDeclaration ::= .FieldDeclaration 
ClassMemberDeclaration ::= .MethodDeclaration 
ClassMemberDeclaration ::= .ClassDeclaration 
ClassMemberDeclaration ::= .InterfaceDeclaration 
ClassMemberDeclaration ::= .SEMICOLON 
FieldDeclaration ::= .FieldModifiersopt Type VariableDeclarators SEMICOLON 
FieldModifiers ::= .FieldModifier 
FieldModifiers ::= .FieldModifiers FieldModifier 
FieldModifier ::= .Annotation 
FieldModifier ::= .public 
FieldModifier ::= .protected 
FieldModifier ::= .private 
FieldModifier ::= .static 
FieldModifier ::= .final 
FieldModifier ::= .transient 
FieldModifier ::= .volatile 
MethodDeclaration ::= .MethodHeader MethodBody 
MethodHeader ::= .MethodModifiersopt TypeParametersopt ResultType 
                 MethodDeclarator Throwsopt 
MethodModifiers ::= .MethodModifier 
MethodModifiers ::= .MethodModifiers MethodModifier 
MethodModifier ::= .Annotations 
MethodModifier ::= .public 
MethodModifier ::= .protected 
MethodModifier ::= .private 
MethodModifier ::= .abstract 
MethodModifier ::= .static 
MethodModifier ::= .final 
MethodModifier ::= .synchronized 
MethodModifier ::= .native 
MethodModifier ::= .strictfp 
InstanceInitializer ::= .Block 
StaticInitializer ::= .static Block 
ConstructorDeclaration ::= .ConstructorModifiersopt ConstructorDeclarator 
                           Throwsopt ConstructorBody 
ConstructorModifiers ::= .ConstructorModifier 
ConstructorModifiers ::= .ConstructorModifiers ConstructorModifier 
ConstructorModifier ::= .Annotations 
ConstructorModifier ::= .public 
ConstructorModifier ::= .protected 
ConstructorModifier ::= .private 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ConstructorModifiersopt ::= . (502)
ConstructorModifiersopt ::= .ConstructorModifiers 
MethodModifiersopt ::= . (510)
MethodModifiersopt ::= .MethodModifiers 
FieldModifiersopt ::= . (512)
FieldModifiersopt ::= .FieldModifiers 
ClassBodyDeclarationsopt ::= . (514)
ClassBodyDeclarationsopt ::= .ClassBodyDeclarations 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

AT                            Shift  7
                              Reduce 484
short                         Reduce 512
                              Reduce 510
long                          Reduce 512
                              Reduce 510
int                           Reduce 512
                              Reduce 510
float                         Reduce 512
                              Reduce 510
double                        Reduce 512
                              Reduce 510
char                          Reduce 512
                              Reduce 510
byte                          Reduce 512
                              Reduce 510
boolean                       Reduce 512
                              Reduce 510
IDENTIFIER                    Reduce 512
                              Reduce 510
                              Reduce 502
LESS                          Reduce 510
                              Reduce 502
LBRACE                        Shift  25
volatile                      Sh/Rd  124
transient                     Sh/Rd  123
native                        Sh/Rd  151
synchronized                  Sh/Rd  150
final                         Shift  68
strictfp                      Shift  69
static                        Shift  70
abstract                      Shift  71
private                       Shift  72
protected                     Shift  73
public                        Shift  74
SEMICOLON                     Sh/Rd  105

ClassBodyDeclarationsopt      Gt/Rd  1
ConstructorDeclaration        Gt/Rd  100
StaticInitializer             Gt/Rd  99
InstanceInitializer           Gt/Rd  98
ClassMemberDeclaration        Gt/Rd  97
ConstructorModifiers          Goto   60
ConstructorModifier           Gt/Rd  165
ConstructorModifiersopt       Goto   61
Block                         Gt/Rd  160
FieldModifiersopt             Goto   62
FieldModifier                 Gt/Rd  115
SingleElementAnnotation       Gt/Rd  233
MarkerAnnotation              Gt/Rd  232
NormalAnnotation              Gt/Rd  231
FieldModifiers                Goto   63
MethodHeader                  Goto   64
Annotations                   Goto   65
MethodModifiers               Goto   66
MethodModifier                Gt/Rd  141
MethodModifiersopt            Goto   67
EnumDeclaration               Gt/Rd  75
NormalClassDeclaration        Gt/Rd  74
ClassModifiers                Goto   20
ClassModifier                 Gt/Rd  77
ClassModifiersopt             Goto   21
AnnotationTypeDeclaration     Gt/Rd  183
NormalInterfaceDeclaration    Gt/Rd  182
Annotation                    Goto   75
InterfaceModifiers            Goto   76
InterfaceModifier             Gt/Rd  185
InterfaceModifiersopt         Goto   77
InterfaceDeclaration          Gt/Rd  104
ClassDeclaration              Gt/Rd  103
MethodDeclaration             Gt/Rd  102
FieldDeclaration              Gt/Rd  101
ClassBodyDeclarations         Goto   78
ClassBodyDeclaration          Gt/Rd  95

interface                     Reduce 484
enum                          Reduce 522
class                         Reduce 522
void                          Reduce 510
EOF_TOKEN                     Reduce 514

Default reduction to rule  510


STATE 6 ------------------------------------------------------------------------
( 1 )

PackageDeclaration ::= Annotationsopt  .package PackageName SEMICOLON 

package    Shift  79



STATE 7 ------------------------------------------------------------------------
( 1 4 5 8 9 12 13 15 16 20 25 59 60 63 65 66 76 78 88 100 150 155 160 238 294 
  297 304 310 343 353 354 359 368 383 384 394 404 409 410 411 412 416 417 431 
  441 443 477 )

NormalAnnotation ::= AT  .TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= AT  .TypeName 
SingleElementAnnotation ::= AT  .TypeName LPAREN ElementValue RPAREN 

identifier ::= .IDENTIFIER 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 

IDENTIFIER    Sh/Rd  3

TypeName      Goto   80
identifier    Gt/Rd  29



STATE 8 ------------------------------------------------------------------------
( 1 310 383 416 )

Annotations ::= Annotations  .Annotation 
Annotationsopt ::= Annotations . (525)

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

AT                         Shift  7

Annotation                 Gt/Rd  230
SingleElementAnnotation    Gt/Rd  233
MarkerAnnotation           Gt/Rd  232
NormalAnnotation           Gt/Rd  231

IDENTIFIER                 Reduce 525
package                    Reduce 525

Default reduction to rule  525


STATE 9 ------------------------------------------------------------------------
( 3 )

CompilationUnit ::= PackageDeclarationopt ImportDeclarationsopt  .
                    TypeDeclarationsopt 

TypeDeclarations ::= .TypeDeclaration 
TypeDeclarations ::= .TypeDeclarations TypeDeclaration 
TypeDeclaration ::= .ClassDeclaration 
TypeDeclaration ::= .InterfaceDeclaration 
TypeDeclaration ::= .SEMICOLON 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
InterfaceDeclaration ::= .NormalInterfaceDeclaration 
InterfaceDeclaration ::= .AnnotationTypeDeclaration 
NormalInterfaceDeclaration ::= .InterfaceModifiersopt interface identifier 
                               TypeParametersopt ExtendsInterfacesopt 
                               InterfaceBody 
InterfaceModifiers ::= .InterfaceModifier 
InterfaceModifiers ::= .InterfaceModifiers InterfaceModifier 
InterfaceModifier ::= .Annotation 
InterfaceModifier ::= .public 
InterfaceModifier ::= .protected 
InterfaceModifier ::= .private 
InterfaceModifier ::= .abstract 
InterfaceModifier ::= .static 
InterfaceModifier ::= .strictfp 
AnnotationTypeDeclaration ::= .InterfaceModifiersopt AT interface identifier 
                              AnnotationTypeBody 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
InterfaceModifiersopt ::= . (484)
InterfaceModifiersopt ::= .InterfaceModifiers 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 
TypeDeclarationsopt ::= . (526)
TypeDeclarationsopt ::= .TypeDeclarations 

AT                            Shift  7
                              Reduce 484
SEMICOLON                     Sh/Rd  73
strictfp                      Shift  81
final                         Sh/Rd  85
static                        Shift  82
abstract                      Shift  83
private                       Shift  84
protected                     Shift  85
public                        Shift  86

TypeDeclarationsopt           Gt/Rd  57
InterfaceDeclaration          Gt/Rd  72
ClassDeclaration              Gt/Rd  71
InterfaceModifier             Gt/Rd  185
InterfaceModifiers            Goto   76
InterfaceModifiersopt         Goto   77
AnnotationTypeDeclaration     Gt/Rd  183
NormalInterfaceDeclaration    Gt/Rd  182
ClassModifier                 Gt/Rd  77
SingleElementAnnotation       Gt/Rd  233
MarkerAnnotation              Gt/Rd  232
NormalAnnotation              Gt/Rd  231
Annotation                    Goto   87
ClassModifiers                Goto   20
ClassModifiersopt             Goto   21
EnumDeclaration               Gt/Rd  75
NormalClassDeclaration        Gt/Rd  74
TypeDeclarations              Goto   88
TypeDeclaration               Gt/Rd  60

enum                          Reduce 522
class                         Reduce 522
interface                     Reduce 484
EOF_TOKEN                     Reduce 526

Default reduction to rule  522


STATE 10 -----------------------------------------------------------------------
( 3 11 )

SingleTypeImportDeclaration ::= import  .TypeName SEMICOLON 
TypeImportOnDemandDeclaration ::= import  .PackageOrTypeName DOT MULTIPLY 
                                  SEMICOLON 
SingleStaticImportDeclaration ::= import  .static TypeName DOT identifier 
                                  SEMICOLON 
StaticImportOnDemandDeclaration ::= import  .static TypeName DOT MULTIPLY 
                                    SEMICOLON 

identifier ::= .IDENTIFIER 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
PackageOrTypeName ::= .identifier 
PackageOrTypeName ::= .PackageOrTypeName DOT identifier 

static               Shift  89
IDENTIFIER           Sh/Rd  3

TypeName             Goto   90
PackageOrTypeName    Goto   91
identifier           Goto   92



STATE 11 -----------------------------------------------------------------------
( 3 )

ImportDeclarations ::= ImportDeclarations  .ImportDeclaration 
ImportDeclarationsopt ::= ImportDeclarations . (529)

ImportDeclaration ::= .SingleTypeImportDeclaration 
ImportDeclaration ::= .TypeImportOnDemandDeclaration 
ImportDeclaration ::= .SingleStaticImportDeclaration 
ImportDeclaration ::= .StaticImportOnDemandDeclaration 
SingleTypeImportDeclaration ::= .import TypeName SEMICOLON 
TypeImportOnDemandDeclaration ::= .import PackageOrTypeName DOT MULTIPLY 
                                  SEMICOLON 
SingleStaticImportDeclaration ::= .import static TypeName DOT identifier 
                                  SEMICOLON 
StaticImportOnDemandDeclaration ::= .import static TypeName DOT MULTIPLY 
                                    SEMICOLON 

import                             Shift  10

ImportDeclaration                  Gt/Rd  59
StaticImportOnDemandDeclaration    Gt/Rd  66
SingleStaticImportDeclaration      Gt/Rd  65
TypeImportOnDemandDeclaration      Gt/Rd  64
SingleTypeImportDeclaration        Gt/Rd  63

EOF_TOKEN                          Reduce 529
strictfp                           Reduce 529
static                             Reduce 529
public                             Reduce 529
protected                          Reduce 529
private                            Reduce 529
interface                          Reduce 529
final                              Reduce 529
enum                               Reduce 529
class                              Reduce 529
abstract                           Reduce 529
AT                                 Reduce 529
SEMICOLON                          Reduce 529

Default reduction to rule  529


STATE 12 -----------------------------------------------------------------------
( 4 )

LPGUserAction ::= BeginJava  .BlockStatementsopt EndJava 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

double                                  Sh/Rd  22
                                        Reduce 464
float                                   Sh/Rd  21
                                        Reduce 464
char                                    Sh/Rd  20
                                        Reduce 464
long                                    Sh/Rd  19
                                        Reduce 464
int                                     Sh/Rd  18
                                        Reduce 464
short                                   Sh/Rd  17
                                        Reduce 464
byte                                    Sh/Rd  16
                                        Reduce 464
boolean                                 Sh/Rd  13
                                        Reduce 464
IDENTIFIER                              Sh/Rd  3
                                        Reduce 464
try                                     Shift  58
throw                                   Shift  57
synchronized                            Shift  56
return                                  Shift  55
continue                                Shift  54
break                                   Shift  53
do                                      Shift  52
switch                                  Shift  51
assert                                  Shift  50
MINUS_MINUS                             Shift  42
PLUS_PLUS                               Shift  41
null                                    Sh/Rd  351
StringLiteral                           Sh/Rd  350
CharacterLiteral                        Sh/Rd  349
DoubleLiteral                           Sh/Rd  347
FloatingPointLiteral                    Sh/Rd  346
LongLiteral                             Sh/Rd  345
IntegerLiteral                          Sh/Rd  344
false                                   Sh/Rd  353
true                                    Sh/Rd  352
new                                     Shift  37
LPAREN                                  Shift  28
this                                    Sh/Rd  337
void                                    Shift  29
super                                   Shift  32
SEMICOLON                               Sh/Rd  284
LBRACE                                  Shift  25
if                                      Shift  24
while                                   Shift  23
for                                     Shift  22
strictfp                                Sh/Rd  86
static                                  Sh/Rd  84
abstract                                Sh/Rd  83
private                                 Sh/Rd  82
protected                               Sh/Rd  81
public                                  Sh/Rd  80
AT                                      Shift  7
final                                   Shift  18

BlockStatementsopt                      Goto   93
Statement                               Gt/Rd  255
ClassDeclaration                        Gt/Rd  254
LocalVariableDeclarationStatement       Gt/Rd  253
TryStatement                            Gt/Rd  275
ThrowStatement                          Gt/Rd  274
SynchronizedStatement                   Gt/Rd  273
ReturnStatement                         Gt/Rd  272
ContinueStatement                       Gt/Rd  271
BreakStatement                          Gt/Rd  270
DoStatement                             Gt/Rd  269
SwitchStatement                         Gt/Rd  268
AssertStatement                         Gt/Rd  267
ExpressionStatement                     Gt/Rd  266
EmptyStatement                          Gt/Rd  265
Block                                   Gt/Rd  264
PreDecrementExpression                  Gt/Rd  290
PreIncrementExpression                  Gt/Rd  289
Assignment                              Gt/Rd  288
PostDecrementExpression                 Goto   48
PostIncrementExpression                 Goto   49
PostfixExpression                       Goto   43
ArrayCreationExpression                 Gt/Rd  333
BooleanLiteral                          Gt/Rd  348
ReferenceType                           Gt/Rd  11
PrimitiveType                           Gt/Rd  10
ClassType                               Gt/Rd  26
ArrayType                               Gt/Rd  25
TypeVariable                            Gt/Rd  24
ClassOrInterfaceType                    Gt/Rd  23
FloatingPointType                       Gt/Rd  15
IntegralType                            Gt/Rd  14
NumericType                             Gt/Rd  12
TypeName                                Goto   35
MethodName                              Goto   33
PrimaryNoNewArray                       Goto   38
ExpressionName                          Goto   44
ArrayAccess                             Goto   39
MethodInvocation                        Goto   47
FieldAccess                             Goto   40
ClassInstanceCreationExpression         Goto   46
Type                                    Goto   34
Literal                                 Gt/Rd  334
ClassName                               Goto   31
Primary                                 Goto   45
AmbiguousName                           Goto   30
LeftHandSide                            Goto   27
StatementExpression                     Goto   26
identifier                              Goto   36
EnhancedForStatement                    Gt/Rd  312
BasicForStatement                       Gt/Rd  311
ForStatement                            Gt/Rd  263
WhileStatement                          Gt/Rd  262
IfThenElseStatement                     Gt/Rd  261
IfThenStatement                         Gt/Rd  260
LabeledStatement                        Gt/Rd  259
StatementWithoutTrailingSubstatement    Gt/Rd  258
ClassModifier                           Gt/Rd  77
ClassModifiers                          Goto   20
ClassModifiersopt                       Goto   21
EnumDeclaration                         Gt/Rd  75
NormalClassDeclaration                  Gt/Rd  74
VariableModifiersopt                    Goto   17
VariableModifier                        Gt/Rd  136
Annotation                              Goto   19
SingleElementAnnotation                 Gt/Rd  233
MarkerAnnotation                        Gt/Rd  232
NormalAnnotation                        Gt/Rd  231
Annotations                             Goto   15
VariableModifiers                       Goto   16
LocalVariableDeclaration                Goto   14
BlockStatements                         Goto   59
BlockStatement                          Gt/Rd  251

enum                                    Reduce 522
class                                   Reduce 522
EndJava                                 Reduce 498

Default reduction to rule  522


STATE 13 -----------------------------------------------------------------------
( 4 )

LPGUserAction ::= BeginAction  .BlockStatementsopt EndAction 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

double                                  Sh/Rd  22
                                        Reduce 464
float                                   Sh/Rd  21
                                        Reduce 464
char                                    Sh/Rd  20
                                        Reduce 464
long                                    Sh/Rd  19
                                        Reduce 464
int                                     Sh/Rd  18
                                        Reduce 464
short                                   Sh/Rd  17
                                        Reduce 464
byte                                    Sh/Rd  16
                                        Reduce 464
boolean                                 Sh/Rd  13
                                        Reduce 464
IDENTIFIER                              Sh/Rd  3
                                        Reduce 464
try                                     Shift  58
throw                                   Shift  57
synchronized                            Shift  56
return                                  Shift  55
continue                                Shift  54
break                                   Shift  53
do                                      Shift  52
switch                                  Shift  51
assert                                  Shift  50
MINUS_MINUS                             Shift  42
PLUS_PLUS                               Shift  41
null                                    Sh/Rd  351
StringLiteral                           Sh/Rd  350
CharacterLiteral                        Sh/Rd  349
DoubleLiteral                           Sh/Rd  347
FloatingPointLiteral                    Sh/Rd  346
LongLiteral                             Sh/Rd  345
IntegerLiteral                          Sh/Rd  344
false                                   Sh/Rd  353
true                                    Sh/Rd  352
new                                     Shift  37
LPAREN                                  Shift  28
this                                    Sh/Rd  337
void                                    Shift  29
super                                   Shift  32
SEMICOLON                               Sh/Rd  284
LBRACE                                  Shift  25
if                                      Shift  24
while                                   Shift  23
for                                     Shift  22
strictfp                                Sh/Rd  86
static                                  Sh/Rd  84
abstract                                Sh/Rd  83
private                                 Sh/Rd  82
protected                               Sh/Rd  81
public                                  Sh/Rd  80
AT                                      Shift  7
final                                   Shift  18

BlockStatementsopt                      Goto   94
Statement                               Gt/Rd  255
ClassDeclaration                        Gt/Rd  254
LocalVariableDeclarationStatement       Gt/Rd  253
TryStatement                            Gt/Rd  275
ThrowStatement                          Gt/Rd  274
SynchronizedStatement                   Gt/Rd  273
ReturnStatement                         Gt/Rd  272
ContinueStatement                       Gt/Rd  271
BreakStatement                          Gt/Rd  270
DoStatement                             Gt/Rd  269
SwitchStatement                         Gt/Rd  268
AssertStatement                         Gt/Rd  267
ExpressionStatement                     Gt/Rd  266
EmptyStatement                          Gt/Rd  265
Block                                   Gt/Rd  264
PreDecrementExpression                  Gt/Rd  290
PreIncrementExpression                  Gt/Rd  289
Assignment                              Gt/Rd  288
PostDecrementExpression                 Goto   48
PostIncrementExpression                 Goto   49
PostfixExpression                       Goto   43
ArrayCreationExpression                 Gt/Rd  333
BooleanLiteral                          Gt/Rd  348
ReferenceType                           Gt/Rd  11
PrimitiveType                           Gt/Rd  10
ClassType                               Gt/Rd  26
ArrayType                               Gt/Rd  25
TypeVariable                            Gt/Rd  24
ClassOrInterfaceType                    Gt/Rd  23
FloatingPointType                       Gt/Rd  15
IntegralType                            Gt/Rd  14
NumericType                             Gt/Rd  12
TypeName                                Goto   35
MethodName                              Goto   33
PrimaryNoNewArray                       Goto   38
ExpressionName                          Goto   44
ArrayAccess                             Goto   39
MethodInvocation                        Goto   47
FieldAccess                             Goto   40
ClassInstanceCreationExpression         Goto   46
Type                                    Goto   34
Literal                                 Gt/Rd  334
ClassName                               Goto   31
Primary                                 Goto   45
AmbiguousName                           Goto   30
LeftHandSide                            Goto   27
StatementExpression                     Goto   26
identifier                              Goto   36
EnhancedForStatement                    Gt/Rd  312
BasicForStatement                       Gt/Rd  311
ForStatement                            Gt/Rd  263
WhileStatement                          Gt/Rd  262
IfThenElseStatement                     Gt/Rd  261
IfThenStatement                         Gt/Rd  260
LabeledStatement                        Gt/Rd  259
StatementWithoutTrailingSubstatement    Gt/Rd  258
ClassModifier                           Gt/Rd  77
ClassModifiers                          Goto   20
ClassModifiersopt                       Goto   21
EnumDeclaration                         Gt/Rd  75
NormalClassDeclaration                  Gt/Rd  74
VariableModifiersopt                    Goto   17
VariableModifier                        Gt/Rd  136
Annotation                              Goto   19
SingleElementAnnotation                 Gt/Rd  233
MarkerAnnotation                        Gt/Rd  232
NormalAnnotation                        Gt/Rd  231
Annotations                             Goto   15
VariableModifiers                       Goto   16
LocalVariableDeclaration                Goto   14
BlockStatements                         Goto   59
BlockStatement                          Gt/Rd  251

enum                                    Reduce 522
class                                   Reduce 522
EndAction                               Reduce 498

Default reduction to rule  522


STATE 14 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

LocalVariableDeclarationStatement ::= LocalVariableDeclaration  .SEMICOLON 

SEMICOLON    Sh/Rd  256



STATE 15 -----------------------------------------------------------------------
( 4 12 13 16 25 59 100 294 297 343 353 368 384 394 431 )

VariableModifier ::= Annotations . (139)
Annotations ::= Annotations  .Annotation 

Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

AT                         Shift  7
                           Reduce 139

Annotation                 Gt/Rd  230
SingleElementAnnotation    Gt/Rd  233
MarkerAnnotation           Gt/Rd  232
NormalAnnotation           Gt/Rd  231

IDENTIFIER                 Reduce 139
short                      Reduce 139
long                       Reduce 139
int                        Reduce 139
float                      Reduce 139
final                      Reduce 139
double                     Reduce 139
char                       Reduce 139
byte                       Reduce 139
boolean                    Reduce 139

Default reduction to rule  139


STATE 16 -----------------------------------------------------------------------
( 4 12 13 25 59 100 294 297 343 353 368 384 394 431 )

VariableModifiers ::= VariableModifiers  .VariableModifier 
VariableModifiersopt ::= VariableModifiers . (465)

VariableModifier ::= .final 
VariableModifier ::= .Annotations 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

final                      Sh/Rd  138
AT                         Shift  7

VariableModifier           Gt/Rd  137
SingleElementAnnotation    Gt/Rd  233
MarkerAnnotation           Gt/Rd  232
NormalAnnotation           Gt/Rd  231
Annotations                Goto   15
Annotation                 Gt/Rd  229

IDENTIFIER                 Reduce 465
short                      Reduce 465
long                       Reduce 465
int                        Reduce 465
float                      Reduce 465
double                     Reduce 465
char                       Reduce 465
byte                       Reduce 465
boolean                    Reduce 465

Default reduction to rule  465


STATE 17 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

LocalVariableDeclaration ::= VariableModifiersopt  .Type VariableDeclarators 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 

IDENTIFIER              Sh/Rd  3
double                  Sh/Rd  22
float                   Sh/Rd  21
char                    Sh/Rd  20
long                    Sh/Rd  19
int                     Sh/Rd  18
short                   Sh/Rd  17
byte                    Sh/Rd  16
boolean                 Sh/Rd  13

ReferenceType           Gt/Rd  11
PrimitiveType           Gt/Rd  10
ClassType               Gt/Rd  26
TypeName                Goto   95
identifier              Goto   96
Type                    Goto   97
ArrayType               Gt/Rd  25
TypeVariable            Gt/Rd  24
ClassOrInterfaceType    Gt/Rd  23
FloatingPointType       Gt/Rd  15
IntegralType            Gt/Rd  14
NumericType             Gt/Rd  12



STATE 18 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

ClassModifier ::= final . (85)
VariableModifier ::= final . (138)

final         Reduce 85
              Reduce 138
AT            Reduce 85
              Reduce 138

strictfp      Reduce 85
static        Reduce 85
public        Reduce 85
protected     Reduce 85
private       Reduce 85
enum          Reduce 85
class         Reduce 85
abstract      Reduce 85
IDENTIFIER    Reduce 138
short         Reduce 138
long          Reduce 138
int           Reduce 138
float         Reduce 138
boolean       Reduce 138
double        Reduce 138
char          Reduce 138
byte          Reduce 138

Default reduction to rule  85


STATE 19 -----------------------------------------------------------------------
( 4 12 13 25 59 343 384 431 )

ClassModifier ::= Annotation . (79)
Annotations ::= Annotation . (229)

final         Reduce 229
              Reduce 79
AT            Reduce 229
              Reduce 79

strictfp      Reduce 79
static        Reduce 79
public        Reduce 79
protected     Reduce 79
private       Reduce 79
enum          Reduce 79
class         Reduce 79
abstract      Reduce 79
IDENTIFIER    Reduce 229
short         Reduce 229
long          Reduce 229
int           Reduce 229
float         Reduce 229
boolean       Reduce 229
double        Reduce 229
char          Reduce 229
byte          Reduce 229

Default reduction to rule  79


STATE 20 -----------------------------------------------------------------------
( 4 5 9 12 13 25 59 78 88 343 354 384 411 412 417 431 441 443 )

ClassModifiers ::= ClassModifiers  .ClassModifier 
ClassModifiersopt ::= ClassModifiers . (523)

ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 

strictfp                   Sh/Rd  86
final                      Sh/Rd  85
static                     Sh/Rd  84
abstract                   Sh/Rd  83
private                    Sh/Rd  82
protected                  Sh/Rd  81
public                     Sh/Rd  80
AT                         Shift  7

ClassModifier              Gt/Rd  78
Annotation                 Gt/Rd  79
SingleElementAnnotation    Gt/Rd  233
MarkerAnnotation           Gt/Rd  232
NormalAnnotation           Gt/Rd  231

enum                       Reduce 523
class                      Reduce 523

Default reduction to rule  523


STATE 21 -----------------------------------------------------------------------
( 4 5 9 12 13 25 59 78 88 343 354 384 411 412 417 431 441 443 )

NormalClassDeclaration ::= ClassModifiersopt  .class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
EnumDeclaration ::= ClassModifiersopt  .enum identifier Interfacesopt EnumBody 

enum     Shift  98
class    Shift  99



STATE 22 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 343 365 367 384 431 447 )

BasicForStatement ::= for  .LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= for  .LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 

LPAREN    Shift  100



STATE 23 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 343 365 367 384 431 447 )

WhileStatement ::= while  .LPAREN Expression RPAREN Statement 

LPAREN    Shift  101



STATE 24 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 343 365 367 384 431 447 )

IfThenStatement ::= if  .LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= if  .LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 

LPAREN    Shift  102



STATE 25 -----------------------------------------------------------------------
( 4 5 12 13 25 52 58 59 64 70 78 133 252 253 292 293 343 365 367 371 384 387 
  417 431 443 447 449 450 470 479 )

Block ::= LBRACE  .BlockStatementsopt RBRACE 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatements ::= .BlockStatement 
BlockStatements ::= .BlockStatements BlockStatement 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
VariableModifiersopt ::= . (464)
VariableModifiersopt ::= .VariableModifiers 
BlockStatementsopt ::= . (498)
BlockStatementsopt ::= .BlockStatements 
ClassModifiersopt ::= . (522)
ClassModifiersopt ::= .ClassModifiers 

double                                  Sh/Rd  22
                                        Reduce 464
float                                   Sh/Rd  21
                                        Reduce 464
char                                    Sh/Rd  20
                                        Reduce 464
long                                    Sh/Rd  19
                                        Reduce 464
int                                     Sh/Rd  18
                                        Reduce 464
short                                   Sh/Rd  17
                                        Reduce 464
byte                                    Sh/Rd  16
                                        Reduce 464
boolean                                 Sh/Rd  13
                                        Reduce 464
IDENTIFIER                              Sh/Rd  3
                                        Reduce 464
try                                     Shift  58
throw                                   Shift  57
synchronized                            Shift  56
return                                  Shift  55
continue                                Shift  54
break                                   Shift  53
do                                      Shift  52
switch                                  Shift  51
assert                                  Shift  50
MINUS_MINUS                             Shift  42
PLUS_PLUS                               Shift  41
null                                    Sh/Rd  351
StringLiteral                           Sh/Rd  350
CharacterLiteral                        Sh/Rd  349
DoubleLiteral                           Sh/Rd  347
FloatingPointLiteral                    Sh/Rd  346
LongLiteral                             Sh/Rd  345
IntegerLiteral                          Sh/Rd  344
false                                   Sh/Rd  353
true                                    Sh/Rd  352
new                                     Shift  37
LPAREN                                  Shift  28
this                                    Sh/Rd  337
void                                    Shift  29
super                                   Shift  32
SEMICOLON                               Sh/Rd  284
LBRACE                                  Shift  25
if                                      Shift  24
while                                   Shift  23
for                                     Shift  22
strictfp                                Sh/Rd  86
static                                  Sh/Rd  84
abstract                                Sh/Rd  83
private                                 Sh/Rd  82
protected                               Sh/Rd  81
public                                  Sh/Rd  80
AT                                      Shift  7
final                                   Shift  18

BlockStatementsopt                      Goto   103
Statement                               Gt/Rd  255
ClassDeclaration                        Gt/Rd  254
LocalVariableDeclarationStatement       Gt/Rd  253
TryStatement                            Gt/Rd  275
ThrowStatement                          Gt/Rd  274
SynchronizedStatement                   Gt/Rd  273
ReturnStatement                         Gt/Rd  272
ContinueStatement                       Gt/Rd  271
BreakStatement                          Gt/Rd  270
DoStatement                             Gt/Rd  269
SwitchStatement                         Gt/Rd  268
AssertStatement                         Gt/Rd  267
ExpressionStatement                     Gt/Rd  266
EmptyStatement                          Gt/Rd  265
Block                                   Gt/Rd  264
PreDecrementExpression                  Gt/Rd  290
PreIncrementExpression                  Gt/Rd  289
Assignment                              Gt/Rd  288
PostDecrementExpression                 Goto   48
PostIncrementExpression                 Goto   49
PostfixExpression                       Goto   43
ArrayCreationExpression                 Gt/Rd  333
BooleanLiteral                          Gt/Rd  348
ReferenceType                           Gt/Rd  11
PrimitiveType                           Gt/Rd  10
ClassType                               Gt/Rd  26
ArrayType                               Gt/Rd  25
TypeVariable                            Gt/Rd  24
ClassOrInterfaceType                    Gt/Rd  23
FloatingPointType                       Gt/Rd  15
IntegralType                            Gt/Rd  14
NumericType                             Gt/Rd  12
TypeName                                Goto   35
MethodName                              Goto   33
PrimaryNoNewArray                       Goto   38
ExpressionName                          Goto   44
ArrayAccess                             Goto   39
MethodInvocation                        Goto   47
FieldAccess                             Goto   40
ClassInstanceCreationExpression         Goto   46
Type                                    Goto   34
Literal                                 Gt/Rd  334
ClassName                               Goto   31
Primary                                 Goto   45
AmbiguousName                           Goto   30
LeftHandSide                            Goto   27
StatementExpression                     Goto   26
identifier                              Goto   36
EnhancedForStatement                    Gt/Rd  312
BasicForStatement                       Gt/Rd  311
ForStatement                            Gt/Rd  263
WhileStatement                          Gt/Rd  262
IfThenElseStatement                     Gt/Rd  261
IfThenStatement                         Gt/Rd  260
LabeledStatement                        Gt/Rd  259
StatementWithoutTrailingSubstatement    Gt/Rd  258
ClassModifier                           Gt/Rd  77
ClassModifiers                          Goto   20
ClassModifiersopt                       Goto   21
EnumDeclaration                         Gt/Rd  75
NormalClassDeclaration                  Gt/Rd  74
VariableModifiersopt                    Goto   17
VariableModifier                        Gt/Rd  136
Annotation                              Goto   19
SingleElementAnnotation                 Gt/Rd  233
MarkerAnnotation                        Gt/Rd  232
NormalAnnotation                        Gt/Rd  231
Annotations                             Goto   15
VariableModifiers                       Goto   16
LocalVariableDeclaration                Goto   14
BlockStatements                         Goto   59
BlockStatement                          Gt/Rd  251

enum                                    Reduce 522
class                                   Reduce 522
RBRACE                                  Reduce 498

Default reduction to rule  522


STATE 26 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

ExpressionStatement ::= StatementExpression  .SEMICOLON 

SEMICOLON    Sh/Rd  287



STATE 27 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

Assignment ::= LeftHandSide  .AssignmentOperator AssignmentExpression 

AssignmentOperator ::= .EQUAL 
AssignmentOperator ::= .MULTIPLY_EQUAL 
AssignmentOperator ::= .DIVIDE_EQUAL 
AssignmentOperator ::= .REMAINDER_EQUAL 
AssignmentOperator ::= .PLUS_EQUAL 
AssignmentOperator ::= .MINUS_EQUAL 
AssignmentOperator ::= .LEFT_SHIFT_EQUAL 
AssignmentOperator ::= .GREATER GREATER EQUAL 
AssignmentOperator ::= .GREATER GREATER GREATER EQUAL 
AssignmentOperator ::= .AND_EQUAL 
AssignmentOperator ::= .XOR_EQUAL 
AssignmentOperator ::= .OR_EQUAL 

OR_EQUAL              Sh/Rd  445
XOR_EQUAL             Sh/Rd  444
AND_EQUAL             Sh/Rd  443
GREATER               Shift  105
LEFT_SHIFT_EQUAL      Sh/Rd  440
MINUS_EQUAL           Sh/Rd  439
PLUS_EQUAL            Sh/Rd  438
REMAINDER_EQUAL       Sh/Rd  437
DIVIDE_EQUAL          Sh/Rd  436
MULTIPLY_EQUAL        Sh/Rd  435
EQUAL                 Sh/Rd  434

AssignmentOperator    Goto   104



STATE 28 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 295 343 365 366 367 368 371 384 431 447 
  449 450 469 470 479 )

PrimaryNoNewArray ::= LPAREN  .Expression RPAREN 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 
MultiplicativeExpression ::= .UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression MULTIPLY UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression DIVIDE UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression REMAINDER 
                             UnaryExpression 
AdditiveExpression ::= .MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression PLUS MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression MINUS MultiplicativeExpression 
ShiftExpression ::= .AdditiveExpression 
ShiftExpression ::= .ShiftExpression LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER GREATER AdditiveExpression 
RelationalExpression ::= .ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
EqualityExpression ::= .RelationalExpression 
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
AndExpression ::= .EqualityExpression 
AndExpression ::= .AndExpression AND EqualityExpression 
ExclusiveOrExpression ::= .AndExpression 
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
AssignmentExpression ::= .ConditionalExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
Expression ::= .AssignmentExpression 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

Expression                         Goto   106
AssignmentExpression               Gt/Rd  446
UnaryExpression                    Gt/Rd  396
CastExpression                     Gt/Rd  393
ArrayCreationExpression            Gt/Rd  333
BooleanLiteral                     Gt/Rd  348
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
ClassType                          Gt/Rd  26
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
NumericType                        Gt/Rd  12
TypeName                           Goto   35
MethodName                         Goto   33
PrimaryNoNewArray                  Goto   38
AmbiguousName                      Goto   30
identifier                         Goto   109
MethodInvocation                   Gt/Rd  342
ClassInstanceCreationExpression    Gt/Rd  340
ClassName                          Goto   31
Type                               Goto   34
Literal                            Gt/Rd  334
PostfixExpression                  Goto   111
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
Primary                            Goto   45
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
AdditiveExpression                 Goto   114
MultiplicativeExpression           Goto   115
RelationalExpression               Goto   116
ShiftExpression                    Goto   117
AndExpression                      Goto   118
EqualityExpression                 Goto   119
InclusiveOrExpression              Goto   120
ExclusiveOrExpression              Goto   121
ConditionalOrExpression            Goto   122
ConditionalAndExpression           Goto   123
LeftHandSide                       Goto   27
ArrayAccess                        Goto   39
FieldAccess                        Goto   40
ExpressionName                     Goto   44
Assignment                         Gt/Rd  429
ConditionalExpression              Gt/Rd  428



STATE 29 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

PrimaryNoNewArray ::= void  .DOT class 

DOT    Shift  124



STATE 30 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ExpressionName ::= AmbiguousName  .DOT identifier 
MethodName ::= AmbiguousName  .DOT identifier 
AmbiguousName ::= AmbiguousName  .DOT identifier 

DOT    Shift  125



STATE 31 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

PrimaryNoNewArray ::= ClassName  .DOT this 
FieldAccess ::= ClassName  .DOT super DOT identifier 
MethodInvocation ::= ClassName  .DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 

DOT    Shift  126



STATE 32 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

FieldAccess ::= super  .DOT identifier 
MethodInvocation ::= super  .DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 

DOT    Shift  127



STATE 33 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

MethodInvocation ::= MethodName  .LPAREN ArgumentListopt RPAREN 

LPAREN    Shift  128



STATE 34 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ArrayType ::= Type  .LBRACKET RBRACKET 
PrimaryNoNewArray ::= Type  .DOT class 

DOT         Shift  129
LBRACKET    Shift  130



STATE 35 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ClassType ::= TypeName  .TypeArgumentsopt 
TypeName ::= TypeName  .DOT identifier 
ClassName ::= TypeName . (31)
MethodInvocation ::= TypeName  .DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 

TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

DOT                 Shift  131
                    Reduce 31
                    Reduce 538
LESS                Shift  132

TypeArgumentsopt    Gt/Rd  27
TypeArguments       Gt/Rd  539

LBRACKET            Reduce 538
RPAREN              Reduce 538

Default reduction to rule  538


STATE 36 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 343 365 367 384 431 447 )

TypeName ::= identifier . (29)
TypeVariable ::= identifier . (32)
ExpressionName ::= identifier . (49)
MethodName ::= identifier . (51)
AmbiguousName ::= identifier . (55)
LabeledStatement ::= identifier  .COLON Statement 

LBRACKET            Reduce 29
                    Reduce 32
                    Reduce 49
DOT                 Reduce 29
                    Reduce 32
                    Reduce 55
COLON               Shift  133

LESS                Reduce 29
GREATER             Reduce 49
EQUAL               Reduce 49
LEFT_SHIFT_EQUAL    Reduce 49
PLUS_EQUAL          Reduce 49
PLUS_PLUS           Reduce 49
OR_EQUAL            Reduce 49
XOR_EQUAL           Reduce 49
LPAREN              Reduce 51
DIVIDE_EQUAL        Reduce 49
MULTIPLY_EQUAL      Reduce 49
AND_EQUAL           Reduce 49
REMAINDER_EQUAL     Reduce 49
MINUS_EQUAL         Reduce 49
MINUS_MINUS         Reduce 49

Default reduction to rule  49


STATE 37 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ClassInstanceCreationExpression ::= new  .TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ArrayCreationExpression ::= new  .PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= new  .ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= new  .PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= new  .ClassOrInterfaceType Dims ArrayInitializer 

identifier ::= .IDENTIFIER 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
TypeArguments ::= .LESS ActualTypeArgumentList GREATER 
TypeArgumentsopt ::= . (538)
TypeArgumentsopt ::= .TypeArguments 

IDENTIFIER              Sh/Rd  3
                        Reduce 538
LESS                    Shift  132
boolean                 Sh/Rd  13
char                    Sh/Rd  20
long                    Sh/Rd  19
int                     Sh/Rd  18
short                   Sh/Rd  17
byte                    Sh/Rd  16
double                  Sh/Rd  22
float                   Sh/Rd  21

ClassOrInterfaceType    Goto   134
PrimitiveType           Goto   135
TypeArgumentsopt        Goto   136
TypeArguments           Gt/Rd  539
NumericType             Gt/Rd  12
FloatingPointType       Gt/Rd  15
IntegralType            Gt/Rd  14
ClassType               Gt/Rd  26
identifier              Gt/Rd  29
TypeName                Goto   95



STATE 38 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  295 304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 
  383 384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

Primary ::= PrimaryNoNewArray . (332)
ArrayAccess ::= PrimaryNoNewArray  .LBRACKET Expression RBRACKET 

LBRACKET       Shift  137

IDENTIFIER     Reduce 332
void           Reduce 332
strictfp       Reduce 332
static         Reduce 332
short          Reduce 332
public         Reduce 332
protected      Reduce 332
private        Reduce 332
long           Reduce 332
interface      Reduce 332
int            Reduce 332
instanceof     Reduce 332
float          Reduce 332
final          Reduce 332
enum           Reduce 332
double         Reduce 332
class          Reduce 332
char           Reduce 332
byte           Reduce 332
boolean        Reduce 332
abstract       Reduce 332
GREATER        Reduce 332
EQUAL_EQUAL    Reduce 332
LESS_EQUAL     Reduce 332
LEFT_SHIFT     Reduce 332
LESS           Reduce 332
PLUS_PLUS      Reduce 332
PLUS           Reduce 332
RBRACE         Reduce 332
OR_OR          Reduce 332
XOR            Reduce 332
RBRACKET       Reduce 332
AT             Reduce 332
QUESTION       Reduce 332
SEMICOLON      Reduce 332
COLON          Reduce 332
DIVIDE         Reduce 332
DOT            Reduce 332
COMMA          Reduce 332
MULTIPLY       Reduce 332
RPAREN         Reduce 332
AND_AND        Reduce 332
AND            Reduce 332
REMAINDER      Reduce 332
NOT_EQUAL      Reduce 332
MINUS          Reduce 332
OR             Reduce 332
MINUS_MINUS    Reduce 332

Default reduction to rule  332


STATE 39 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

PrimaryNoNewArray ::= ArrayAccess . (343)
LeftHandSide ::= ArrayAccess . (433)

GREATER             Reduce 343
                    Reduce 433

IDENTIFIER          Reduce 343
void                Reduce 343
strictfp            Reduce 343
static              Reduce 343
short               Reduce 343
public              Reduce 343
protected           Reduce 343
private             Reduce 343
long                Reduce 343
interface           Reduce 343
int                 Reduce 343
instanceof          Reduce 343
float               Reduce 343
final               Reduce 343
enum                Reduce 343
double              Reduce 343
class               Reduce 343
char                Reduce 343
byte                Reduce 343
boolean             Reduce 343
abstract            Reduce 343
EQUAL_EQUAL         Reduce 343
LESS_EQUAL          Reduce 343
LEFT_SHIFT          Reduce 343
LESS                Reduce 343
PLUS_PLUS           Reduce 343
PLUS                Reduce 343
RBRACE              Reduce 343
OR_OR               Reduce 343
XOR                 Reduce 343
RBRACKET            Reduce 343
LBRACKET            Reduce 343
AT                  Reduce 343
QUESTION            Reduce 343
SEMICOLON           Reduce 343
COLON               Reduce 343
DIVIDE              Reduce 343
DOT                 Reduce 343
COMMA               Reduce 343
MULTIPLY            Reduce 343
RPAREN              Reduce 343
AND_AND             Reduce 343
AND                 Reduce 343
REMAINDER           Reduce 343
NOT_EQUAL           Reduce 343
MINUS               Reduce 343
OR                  Reduce 343
MINUS_MINUS         Reduce 343
MINUS_EQUAL         Reduce 433
EQUAL               Reduce 433
LEFT_SHIFT_EQUAL    Reduce 433
PLUS_EQUAL          Reduce 433
OR_EQUAL            Reduce 433
XOR_EQUAL           Reduce 433
DIVIDE_EQUAL        Reduce 433
MULTIPLY_EQUAL      Reduce 433
AND_EQUAL           Reduce 433
REMAINDER_EQUAL     Reduce 433

Default reduction to rule  343


STATE 40 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

PrimaryNoNewArray ::= FieldAccess . (341)
LeftHandSide ::= FieldAccess . (432)

GREATER             Reduce 341
                    Reduce 432

IDENTIFIER          Reduce 341
void                Reduce 341
strictfp            Reduce 341
static              Reduce 341
short               Reduce 341
public              Reduce 341
protected           Reduce 341
private             Reduce 341
long                Reduce 341
interface           Reduce 341
int                 Reduce 341
instanceof          Reduce 341
float               Reduce 341
final               Reduce 341
enum                Reduce 341
double              Reduce 341
class               Reduce 341
char                Reduce 341
byte                Reduce 341
boolean             Reduce 341
abstract            Reduce 341
EQUAL_EQUAL         Reduce 341
LESS_EQUAL          Reduce 341
LEFT_SHIFT          Reduce 341
LESS                Reduce 341
PLUS_PLUS           Reduce 341
PLUS                Reduce 341
RBRACE              Reduce 341
OR_OR               Reduce 341
XOR                 Reduce 341
RBRACKET            Reduce 341
LBRACKET            Reduce 341
AT                  Reduce 341
QUESTION            Reduce 341
SEMICOLON           Reduce 341
COLON               Reduce 341
DIVIDE              Reduce 341
DOT                 Reduce 341
COMMA               Reduce 341
MULTIPLY            Reduce 341
RPAREN              Reduce 341
AND_AND             Reduce 341
AND                 Reduce 341
REMAINDER           Reduce 341
NOT_EQUAL           Reduce 341
MINUS               Reduce 341
OR                  Reduce 341
MINUS_MINUS         Reduce 341
MINUS_EQUAL         Reduce 432
EQUAL               Reduce 432
LEFT_SHIFT_EQUAL    Reduce 432
PLUS_EQUAL          Reduce 432
OR_EQUAL            Reduce 432
XOR_EQUAL           Reduce 432
DIVIDE_EQUAL        Reduce 432
MULTIPLY_EQUAL      Reduce 432
AND_EQUAL           Reduce 432
REMAINDER_EQUAL     Reduce 432

Default reduction to rule  341


STATE 41 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 263 266 278 284 291 304 
  324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 383 384 
  423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

PreIncrementExpression ::= PLUS_PLUS  .UnaryExpression 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

UnaryExpression                    Gt/Rd  388
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
ArrayAccess                        Gt/Rd  343
MethodInvocation                   Gt/Rd  342
FieldAccess                        Gt/Rd  341
ClassInstanceCreationExpression    Gt/Rd  340
Literal                            Gt/Rd  334
ExpressionName                     Goto   138
AmbiguousName                      Goto   30
MethodName                         Goto   33
ClassName                          Goto   31
Primary                            Goto   45
NumericType                        Gt/Rd  12
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
Type                               Goto   34
TypeName                           Goto   35
identifier                         Goto   109
ClassType                          Gt/Rd  26
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
BooleanLiteral                     Gt/Rd  348
ArrayCreationExpression            Gt/Rd  333
PrimaryNoNewArray                  Goto   38
CastExpression                     Gt/Rd  393
PostfixExpression                  Goto   111



STATE 42 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 263 266 278 284 291 304 
  324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 383 384 
  423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

PreDecrementExpression ::= MINUS_MINUS  .UnaryExpression 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

UnaryExpression                    Gt/Rd  389
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
ArrayAccess                        Gt/Rd  343
MethodInvocation                   Gt/Rd  342
FieldAccess                        Gt/Rd  341
ClassInstanceCreationExpression    Gt/Rd  340
Literal                            Gt/Rd  334
ExpressionName                     Goto   138
AmbiguousName                      Goto   30
MethodName                         Goto   33
ClassName                          Goto   31
Primary                            Goto   45
NumericType                        Gt/Rd  12
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
Type                               Goto   34
TypeName                           Goto   35
identifier                         Goto   109
ClassType                          Gt/Rd  26
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
BooleanLiteral                     Gt/Rd  348
ArrayCreationExpression            Gt/Rd  333
PrimaryNoNewArray                  Goto   38
CastExpression                     Gt/Rd  393
PostfixExpression                  Goto   111



STATE 43 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 343 365 366 367 368 371 384 431 447 449 
  450 469 470 479 )

PostIncrementExpression ::= PostfixExpression  .PLUS_PLUS 
PostDecrementExpression ::= PostfixExpression  .MINUS_MINUS 

MINUS_MINUS    Sh/Rd  382
PLUS_PLUS      Sh/Rd  381



STATE 44 -----------------------------------------------------------------------
( 4 12 13 25 28 50 52 55 57 59 100 101 102 104 110 128 133 137 139 142 147 193 
  208 216 244 248 249 250 252 253 278 284 291 330 331 336 337 343 365 366 367 
  368 369 370 371 377 383 384 423 425 431 434 435 445 447 448 449 450 464 469 
  470 479 )

ArrayAccess ::= ExpressionName  .LBRACKET Expression RBRACKET 
PostfixExpression ::= ExpressionName . (378)
LeftHandSide ::= ExpressionName . (431)

GREATER             Reduce 431
                    Reduce 378
LBRACKET            Shift  139

IDENTIFIER          Reduce 378
void                Reduce 378
strictfp            Reduce 378
static              Reduce 378
short               Reduce 378
public              Reduce 378
protected           Reduce 378
private             Reduce 378
long                Reduce 378
interface           Reduce 378
int                 Reduce 378
instanceof          Reduce 378
float               Reduce 378
final               Reduce 378
enum                Reduce 378
double              Reduce 378
class               Reduce 378
char                Reduce 378
byte                Reduce 378
boolean             Reduce 378
abstract            Reduce 378
EQUAL_EQUAL         Reduce 378
LESS_EQUAL          Reduce 378
LEFT_SHIFT          Reduce 378
LESS                Reduce 378
PLUS_PLUS           Reduce 378
PLUS                Reduce 378
RBRACE              Reduce 378
OR_OR               Reduce 378
XOR                 Reduce 378
RBRACKET            Reduce 378
AT                  Reduce 378
QUESTION            Reduce 378
SEMICOLON           Reduce 378
COLON               Reduce 378
DIVIDE              Reduce 378
COMMA               Reduce 378
MULTIPLY            Reduce 378
RPAREN              Reduce 378
AND_AND             Reduce 378
AND                 Reduce 378
REMAINDER           Reduce 378
NOT_EQUAL           Reduce 378
MINUS               Reduce 378
OR                  Reduce 378
MINUS_MINUS         Reduce 378
MINUS_EQUAL         Reduce 431
EQUAL               Reduce 431
LEFT_SHIFT_EQUAL    Reduce 431
PLUS_EQUAL          Reduce 431
OR_EQUAL            Reduce 431
XOR_EQUAL           Reduce 431
DIVIDE_EQUAL        Reduce 431
MULTIPLY_EQUAL      Reduce 431
AND_EQUAL           Reduce 431
REMAINDER_EQUAL     Reduce 431

Default reduction to rule  378


STATE 45 -----------------------------------------------------------------------
( 4 12 13 25 28 41 42 50 52 55 57 59 100 101 102 104 107 108 110 112 113 128 
  133 137 139 142 147 160 177 178 179 180 181 183 184 185 187 188 189 190 191 
  192 193 194 195 208 216 238 244 248 249 250 252 253 255 263 266 278 284 291 
  304 324 326 328 330 331 336 337 343 359 365 366 367 368 369 370 371 377 383 
  384 423 425 431 434 435 445 447 448 449 450 464 469 470 477 479 )

ClassInstanceCreationExpression ::= Primary  .DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
FieldAccess ::= Primary  .DOT identifier 
MethodInvocation ::= Primary  .DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
PostfixExpression ::= Primary . (377)

DOT            Shift  140

IDENTIFIER     Reduce 377
void           Reduce 377
strictfp       Reduce 377
static         Reduce 377
short          Reduce 377
public         Reduce 377
protected      Reduce 377
private        Reduce 377
long           Reduce 377
interface      Reduce 377
int            Reduce 377
instanceof     Reduce 377
float          Reduce 377
final          Reduce 377
enum           Reduce 377
double         Reduce 377
class          Reduce 377
char           Reduce 377
byte           Reduce 377
boolean        Reduce 377
abstract       Reduce 377
GREATER        Reduce 377
EQUAL_EQUAL    Reduce 377
LESS_EQUAL     Reduce 377
LEFT_SHIFT     Reduce 377
LESS           Reduce 377
PLUS_PLUS      Reduce 377
PLUS           Reduce 377
RBRACE         Reduce 377
OR_OR          Reduce 377
XOR            Reduce 377
RBRACKET       Reduce 377
AT             Reduce 377
QUESTION       Reduce 377
SEMICOLON      Reduce 377
COLON          Reduce 377
DIVIDE         Reduce 377
COMMA          Reduce 377
MULTIPLY       Reduce 377
RPAREN         Reduce 377
AND_AND        Reduce 377
AND            Reduce 377
REMAINDER      Reduce 377
NOT_EQUAL      Reduce 377
MINUS          Reduce 377
OR             Reduce 377
MINUS_MINUS    Reduce 377

Default reduction to rule  377


STATE 46 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 343 365 366 367 368 371 384 431 447 449 
  450 469 470 479 )

StatementExpression ::= ClassInstanceCreationExpression . (294)
PrimaryNoNewArray ::= ClassInstanceCreationExpression . (340)

SEMICOLON      Reduce 294
COMMA          Reduce 294
RPAREN         Reduce 294
PLUS_PLUS      Reduce 340
LBRACKET       Reduce 340
DOT            Reduce 340
MINUS_MINUS    Reduce 340

Default reduction to rule  340


STATE 47 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 343 365 366 367 368 371 384 431 447 449 
  450 469 470 479 )

StatementExpression ::= MethodInvocation . (293)
PrimaryNoNewArray ::= MethodInvocation . (342)

SEMICOLON      Reduce 293
COMMA          Reduce 293
RPAREN         Reduce 293
PLUS_PLUS      Reduce 342
LBRACKET       Reduce 342
DOT            Reduce 342
MINUS_MINUS    Reduce 342

Default reduction to rule  342


STATE 48 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 343 365 366 367 368 371 384 431 447 449 
  450 469 470 479 )

StatementExpression ::= PostDecrementExpression . (292)
PostfixExpression ::= PostDecrementExpression . (380)

SEMICOLON      Reduce 292
COMMA          Reduce 292
RPAREN         Reduce 292
PLUS_PLUS      Reduce 380
MINUS_MINUS    Reduce 380

Default reduction to rule  292


STATE 49 -----------------------------------------------------------------------
( 4 12 13 25 52 59 100 133 250 252 253 343 365 366 367 368 371 384 431 447 449 
  450 469 470 479 )

StatementExpression ::= PostIncrementExpression . (291)
PostfixExpression ::= PostIncrementExpression . (379)

SEMICOLON      Reduce 291
COMMA          Reduce 291
RPAREN         Reduce 291
PLUS_PLUS      Reduce 379
MINUS_MINUS    Reduce 379

Default reduction to rule  291


STATE 50 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

AssertStatement ::= assert  .Expression SEMICOLON 
AssertStatement ::= assert  .Expression COLON Expression SEMICOLON 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 
MultiplicativeExpression ::= .UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression MULTIPLY UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression DIVIDE UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression REMAINDER 
                             UnaryExpression 
AdditiveExpression ::= .MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression PLUS MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression MINUS MultiplicativeExpression 
ShiftExpression ::= .AdditiveExpression 
ShiftExpression ::= .ShiftExpression LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER GREATER AdditiveExpression 
RelationalExpression ::= .ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
EqualityExpression ::= .RelationalExpression 
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
AndExpression ::= .EqualityExpression 
AndExpression ::= .AndExpression AND EqualityExpression 
ExclusiveOrExpression ::= .AndExpression 
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
AssignmentExpression ::= .ConditionalExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
Expression ::= .AssignmentExpression 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

Expression                         Goto   141
AssignmentExpression               Gt/Rd  446
UnaryExpression                    Gt/Rd  396
CastExpression                     Gt/Rd  393
ArrayCreationExpression            Gt/Rd  333
BooleanLiteral                     Gt/Rd  348
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
ClassType                          Gt/Rd  26
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
NumericType                        Gt/Rd  12
TypeName                           Goto   35
MethodName                         Goto   33
PrimaryNoNewArray                  Goto   38
AmbiguousName                      Goto   30
identifier                         Goto   109
MethodInvocation                   Gt/Rd  342
ClassInstanceCreationExpression    Gt/Rd  340
ClassName                          Goto   31
Type                               Goto   34
Literal                            Gt/Rd  334
PostfixExpression                  Goto   111
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
Primary                            Goto   45
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
AdditiveExpression                 Goto   114
MultiplicativeExpression           Goto   115
RelationalExpression               Goto   116
ShiftExpression                    Goto   117
AndExpression                      Goto   118
EqualityExpression                 Goto   119
InclusiveOrExpression              Goto   120
ExclusiveOrExpression              Goto   121
ConditionalOrExpression            Goto   122
ConditionalAndExpression           Goto   123
LeftHandSide                       Goto   27
ArrayAccess                        Goto   39
FieldAccess                        Goto   40
ExpressionName                     Goto   44
Assignment                         Gt/Rd  429
ConditionalExpression              Gt/Rd  428



STATE 51 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

SwitchStatement ::= switch  .LPAREN Expression RPAREN SwitchBlock 

LPAREN    Shift  142



STATE 52 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

DoStatement ::= do  .Statement while LPAREN Expression RPAREN SEMICOLON 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Block ::= .LBRACE BlockStatementsopt RBRACE 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 

for                                     Shift  22
while                                   Shift  23
if                                      Shift  24
LBRACE                                  Shift  25
SEMICOLON                               Sh/Rd  284
IDENTIFIER                              Sh/Rd  3
LPAREN                                  Shift  28
this                                    Sh/Rd  337
void                                    Shift  29
super                                   Shift  32
boolean                                 Sh/Rd  13
char                                    Sh/Rd  20
long                                    Sh/Rd  19
int                                     Sh/Rd  18
short                                   Sh/Rd  17
byte                                    Sh/Rd  16
double                                  Sh/Rd  22
float                                   Sh/Rd  21
false                                   Sh/Rd  353
true                                    Sh/Rd  352
null                                    Sh/Rd  351
StringLiteral                           Sh/Rd  350
CharacterLiteral                        Sh/Rd  349
DoubleLiteral                           Sh/Rd  347
FloatingPointLiteral                    Sh/Rd  346
LongLiteral                             Sh/Rd  345
IntegerLiteral                          Sh/Rd  344
new                                     Shift  37
PLUS_PLUS                               Shift  41
MINUS_MINUS                             Shift  42
assert                                  Shift  50
switch                                  Shift  51
do                                      Shift  52
break                                   Shift  53
continue                                Shift  54
return                                  Shift  55
synchronized                            Shift  56
throw                                   Shift  57
try                                     Shift  58

Statement                               Goto   143
ForStatement                            Gt/Rd  263
WhileStatement                          Gt/Rd  262
IfThenElseStatement                     Gt/Rd  261
IfThenStatement                         Gt/Rd  260
LabeledStatement                        Gt/Rd  259
StatementWithoutTrailingSubstatement    Gt/Rd  258
EnhancedForStatement                    Gt/Rd  312
BasicForStatement                       Gt/Rd  311
StatementExpression                     Goto   26
LeftHandSide                            Goto   27
Literal                                 Gt/Rd  334
AmbiguousName                           Goto   30
ClassName                               Goto   31
MethodName                              Goto   33
NumericType                             Gt/Rd  12
FloatingPointType                       Gt/Rd  15
IntegralType                            Gt/Rd  14
ArrayType                               Gt/Rd  25
TypeVariable                            Gt/Rd  24
ClassOrInterfaceType                    Gt/Rd  23
Type                                    Goto   34
TypeName                                Goto   35
identifier                              Goto   36
ClassType                               Gt/Rd  26
ReferenceType                           Gt/Rd  11
PrimitiveType                           Gt/Rd  10
BooleanLiteral                          Gt/Rd  348
ArrayCreationExpression                 Gt/Rd  333
PrimaryNoNewArray                       Goto   38
ArrayAccess                             Goto   39
FieldAccess                             Goto   40
PostfixExpression                       Goto   43
ExpressionName                          Goto   44
Primary                                 Goto   45
ClassInstanceCreationExpression         Goto   46
MethodInvocation                        Goto   47
PostDecrementExpression                 Goto   48
PostIncrementExpression                 Goto   49
PreDecrementExpression                  Gt/Rd  290
PreIncrementExpression                  Gt/Rd  289
Assignment                              Gt/Rd  288
TryStatement                            Gt/Rd  275
ThrowStatement                          Gt/Rd  274
SynchronizedStatement                   Gt/Rd  273
ReturnStatement                         Gt/Rd  272
ContinueStatement                       Gt/Rd  271
BreakStatement                          Gt/Rd  270
DoStatement                             Gt/Rd  269
SwitchStatement                         Gt/Rd  268
AssertStatement                         Gt/Rd  267
ExpressionStatement                     Gt/Rd  266
EmptyStatement                          Gt/Rd  265
Block                                   Gt/Rd  264



STATE 53 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

BreakStatement ::= break  .identifieropt SEMICOLON 

identifier ::= .IDENTIFIER 
identifieropt ::= . (452)
identifieropt ::= .identifier 

IDENTIFIER       Sh/Rd  3

identifieropt    Goto   144
identifier       Gt/Rd  453

SEMICOLON        Reduce 452

Default reduction to rule  452


STATE 54 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

ContinueStatement ::= continue  .identifieropt SEMICOLON 

identifier ::= .IDENTIFIER 
identifieropt ::= . (452)
identifieropt ::= .identifier 

IDENTIFIER       Sh/Rd  3

identifieropt    Goto   145
identifier       Gt/Rd  453

SEMICOLON        Reduce 452

Default reduction to rule  452


STATE 55 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

ReturnStatement ::= return  .Expressionopt SEMICOLON 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 
MultiplicativeExpression ::= .UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression MULTIPLY UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression DIVIDE UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression REMAINDER 
                             UnaryExpression 
AdditiveExpression ::= .MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression PLUS MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression MINUS MultiplicativeExpression 
ShiftExpression ::= .AdditiveExpression 
ShiftExpression ::= .ShiftExpression LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER GREATER AdditiveExpression 
RelationalExpression ::= .ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
EqualityExpression ::= .RelationalExpression 
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
AndExpression ::= .EqualityExpression 
AndExpression ::= .AndExpression AND EqualityExpression 
ExclusiveOrExpression ::= .AndExpression 
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
AssignmentExpression ::= .ConditionalExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
Expression ::= .AssignmentExpression 
Expressionopt ::= . (456)
Expressionopt ::= .Expression 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

Expressionopt                      Goto   146
Expression                         Gt/Rd  457
Assignment                         Gt/Rd  429
ConditionalExpression              Gt/Rd  428
LeftHandSide                       Goto   27
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
ArrayAccess                        Goto   39
MethodInvocation                   Gt/Rd  342
FieldAccess                        Goto   40
ClassInstanceCreationExpression    Gt/Rd  340
Literal                            Gt/Rd  334
ExpressionName                     Goto   44
AmbiguousName                      Goto   30
MethodName                         Goto   33
ClassName                          Goto   31
Primary                            Goto   45
NumericType                        Gt/Rd  12
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
Type                               Goto   34
TypeName                           Goto   35
identifier                         Goto   109
ClassType                          Gt/Rd  26
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
BooleanLiteral                     Gt/Rd  348
ArrayCreationExpression            Gt/Rd  333
PrimaryNoNewArray                  Goto   38
CastExpression                     Gt/Rd  393
PostfixExpression                  Goto   111
MultiplicativeExpression           Goto   115
UnaryExpression                    Gt/Rd  396
ShiftExpression                    Goto   117
AdditiveExpression                 Goto   114
EqualityExpression                 Goto   119
RelationalExpression               Goto   116
ExclusiveOrExpression              Goto   121
AndExpression                      Goto   118
ConditionalAndExpression           Goto   123
InclusiveOrExpression              Goto   120
ConditionalOrExpression            Goto   122
AssignmentExpression               Gt/Rd  446

SEMICOLON                          Reduce 456

Default reduction to rule  456


STATE 56 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

SynchronizedStatement ::= synchronized  .LPAREN Expression RPAREN Block 

LPAREN    Shift  147



STATE 57 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

ThrowStatement ::= throw  .Expression SEMICOLON 

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
                     ArgumentListopt RPAREN 
ArrayAccess ::= .ExpressionName LBRACKET Expression RBRACKET 
ArrayAccess ::= .PrimaryNoNewArray LBRACKET Expression RBRACKET 
PostfixExpression ::= .Primary 
PostfixExpression ::= .ExpressionName 
PostfixExpression ::= .PostIncrementExpression 
PostfixExpression ::= .PostDecrementExpression 
PostIncrementExpression ::= .PostfixExpression PLUS_PLUS 
PostDecrementExpression ::= .PostfixExpression MINUS_MINUS 
UnaryExpression ::= .PreIncrementExpression 
UnaryExpression ::= .PreDecrementExpression 
UnaryExpression ::= .PLUS UnaryExpression 
UnaryExpression ::= .MINUS UnaryExpression 
UnaryExpression ::= .UnaryExpressionNotPlusMinus 
PreIncrementExpression ::= .PLUS_PLUS UnaryExpression 
PreDecrementExpression ::= .MINUS_MINUS UnaryExpression 
UnaryExpressionNotPlusMinus ::= .PostfixExpression 
UnaryExpressionNotPlusMinus ::= .TWIDDLE UnaryExpression 
UnaryExpressionNotPlusMinus ::= .NOT UnaryExpression 
UnaryExpressionNotPlusMinus ::= .CastExpression 
CastExpression ::= .LPAREN PrimitiveType Dimsopt RPAREN UnaryExpression 
CastExpression ::= .LPAREN ReferenceType RPAREN UnaryExpressionNotPlusMinus 
MultiplicativeExpression ::= .UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression MULTIPLY UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression DIVIDE UnaryExpression 
MultiplicativeExpression ::= .MultiplicativeExpression REMAINDER 
                             UnaryExpression 
AdditiveExpression ::= .MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression PLUS MultiplicativeExpression 
AdditiveExpression ::= .AdditiveExpression MINUS MultiplicativeExpression 
ShiftExpression ::= .AdditiveExpression 
ShiftExpression ::= .ShiftExpression LEFT_SHIFT AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER AdditiveExpression 
ShiftExpression ::= .ShiftExpression GREATER GREATER GREATER AdditiveExpression 
RelationalExpression ::= .ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER ShiftExpression 
RelationalExpression ::= .RelationalExpression LESS_EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression GREATER EQUAL ShiftExpression 
RelationalExpression ::= .RelationalExpression instanceof ReferenceType 
EqualityExpression ::= .RelationalExpression 
EqualityExpression ::= .EqualityExpression EQUAL_EQUAL RelationalExpression 
EqualityExpression ::= .EqualityExpression NOT_EQUAL RelationalExpression 
AndExpression ::= .EqualityExpression 
AndExpression ::= .AndExpression AND EqualityExpression 
ExclusiveOrExpression ::= .AndExpression 
ExclusiveOrExpression ::= .ExclusiveOrExpression XOR AndExpression 
InclusiveOrExpression ::= .ExclusiveOrExpression 
InclusiveOrExpression ::= .InclusiveOrExpression OR ExclusiveOrExpression 
ConditionalAndExpression ::= .InclusiveOrExpression 
ConditionalAndExpression ::= .ConditionalAndExpression AND_AND 
                             InclusiveOrExpression 
ConditionalOrExpression ::= .ConditionalAndExpression 
ConditionalOrExpression ::= .ConditionalOrExpression OR_OR 
                            ConditionalAndExpression 
ConditionalExpression ::= .ConditionalOrExpression 
ConditionalExpression ::= .ConditionalOrExpression QUESTION Expression COLON 
                          ConditionalExpression 
AssignmentExpression ::= .ConditionalExpression 
AssignmentExpression ::= .Assignment 
Assignment ::= .LeftHandSide AssignmentOperator AssignmentExpression 
LeftHandSide ::= .ExpressionName 
LeftHandSide ::= .FieldAccess 
LeftHandSide ::= .ArrayAccess 
Expression ::= .AssignmentExpression 

PLUS_PLUS                          Shift  41
MINUS_MINUS                        Shift  42
NOT                                Shift  107
TWIDDLE                            Shift  108
null                               Sh/Rd  351
StringLiteral                      Sh/Rd  350
CharacterLiteral                   Sh/Rd  349
DoubleLiteral                      Sh/Rd  347
FloatingPointLiteral               Sh/Rd  346
LongLiteral                        Sh/Rd  345
IntegerLiteral                     Sh/Rd  344
false                              Sh/Rd  353
true                               Sh/Rd  352
IDENTIFIER                         Sh/Rd  3
double                             Sh/Rd  22
float                              Sh/Rd  21
char                               Sh/Rd  20
long                               Sh/Rd  19
int                                Sh/Rd  18
short                              Sh/Rd  17
byte                               Sh/Rd  16
boolean                            Sh/Rd  13
new                                Shift  37
super                              Shift  32
LPAREN                             Shift  110
this                               Sh/Rd  337
void                               Shift  29
MINUS                              Shift  112
PLUS                               Shift  113

Expression                         Goto   148
AssignmentExpression               Gt/Rd  446
UnaryExpression                    Gt/Rd  396
CastExpression                     Gt/Rd  393
ArrayCreationExpression            Gt/Rd  333
BooleanLiteral                     Gt/Rd  348
ReferenceType                      Gt/Rd  11
PrimitiveType                      Gt/Rd  10
ClassType                          Gt/Rd  26
ArrayType                          Gt/Rd  25
TypeVariable                       Gt/Rd  24
ClassOrInterfaceType               Gt/Rd  23
FloatingPointType                  Gt/Rd  15
IntegralType                       Gt/Rd  14
NumericType                        Gt/Rd  12
TypeName                           Goto   35
MethodName                         Goto   33
PrimaryNoNewArray                  Goto   38
AmbiguousName                      Goto   30
identifier                         Goto   109
MethodInvocation                   Gt/Rd  342
ClassInstanceCreationExpression    Gt/Rd  340
ClassName                          Goto   31
Type                               Goto   34
Literal                            Gt/Rd  334
PostfixExpression                  Goto   111
PostDecrementExpression            Gt/Rd  380
PostIncrementExpression            Gt/Rd  379
Primary                            Goto   45
UnaryExpressionNotPlusMinus        Gt/Rd  387
PreDecrementExpression             Gt/Rd  384
PreIncrementExpression             Gt/Rd  383
AdditiveExpression                 Goto   114
MultiplicativeExpression           Goto   115
RelationalExpression               Goto   116
ShiftExpression                    Goto   117
AndExpression                      Goto   118
EqualityExpression                 Goto   119
InclusiveOrExpression              Goto   120
ExclusiveOrExpression              Goto   121
ConditionalOrExpression            Goto   122
ConditionalAndExpression           Goto   123
LeftHandSide                       Goto   27
ArrayAccess                        Goto   39
FieldAccess                        Goto   40
ExpressionName                     Goto   44
Assignment                         Gt/Rd  429
ConditionalExpression              Gt/Rd  428



STATE 58 -----------------------------------------------------------------------
( 4 12 13 25 52 59 133 252 253 343 365 367 371 384 431 447 449 450 470 479 )

TryStatement ::= try  .Block Catches 
TryStatement ::= try  .Block Catchesopt Finally 

Block ::= .LBRACE BlockStatementsopt RBRACE 

LBRACE    Shift  25

Block     Goto   149



STATE 59 -----------------------------------------------------------------------
( 4 12 13 25 343 )

BlockStatements ::= BlockStatements  .BlockStatement 
BlockStatementsopt ::= BlockStatements . (499)

identifier ::= .IDENTIFIER 
Type ::= .PrimitiveType 
Type ::= .ReferenceType 
PrimitiveType ::= .NumericType 
PrimitiveType ::= .boolean 
NumericType ::= .IntegralType 
NumericType ::= .FloatingPointType 
IntegralType ::= .byte 
IntegralType ::= .short 
IntegralType ::= .int 
IntegralType ::= .long 
IntegralType ::= .char 
FloatingPointType ::= .float 
FloatingPointType ::= .double 
ReferenceType ::= .ClassOrInterfaceType 
ReferenceType ::= .TypeVariable 
ReferenceType ::= .ArrayType 
ClassOrInterfaceType ::= .ClassType 
ClassType ::= .TypeName TypeArgumentsopt 
TypeName ::= .identifier 
TypeName ::= .TypeName DOT identifier 
ClassName ::= .TypeName 
TypeVariable ::= .identifier 
ArrayType ::= .Type LBRACKET RBRACKET 
ExpressionName ::= .identifier 
ExpressionName ::= .AmbiguousName DOT identifier 
MethodName ::= .identifier 
MethodName ::= .AmbiguousName DOT identifier 
AmbiguousName ::= .identifier 
AmbiguousName ::= .AmbiguousName DOT identifier 
ClassDeclaration ::= .NormalClassDeclaration 
ClassDeclaration ::= .EnumDeclaration 
NormalClassDeclaration ::= .ClassModifiersopt class identifier 
                           TypeParametersopt Superopt Interfacesopt ClassBody 
ClassModifiers ::= .ClassModifier 
ClassModifiers ::= .ClassModifiers ClassModifier 
ClassModifier ::= .Annotation 
ClassModifier ::= .public 
ClassModifier ::= .protected 
ClassModifier ::= .private 
ClassModifier ::= .abstract 
ClassModifier ::= .static 
ClassModifier ::= .final 
ClassModifier ::= .strictfp 
VariableModifiers ::= .VariableModifier 
VariableModifiers ::= .VariableModifiers VariableModifier 
VariableModifier ::= .final 
VariableModifier ::= .Annotations 
EnumDeclaration ::= .ClassModifiersopt enum identifier Interfacesopt EnumBody 
Annotations ::= .Annotation 
Annotations ::= .Annotations Annotation 
Annotation ::= .NormalAnnotation 
Annotation ::= .MarkerAnnotation 
Annotation ::= .SingleElementAnnotation 
NormalAnnotation ::= .AT TypeName LPAREN ElementValuePairsopt RPAREN 
MarkerAnnotation ::= .AT TypeName 
SingleElementAnnotation ::= .AT TypeName LPAREN ElementValue RPAREN 
Block ::= .LBRACE BlockStatementsopt RBRACE 
BlockStatement ::= .LocalVariableDeclarationStatement 
BlockStatement ::= .ClassDeclaration 
BlockStatement ::= .Statement 
LocalVariableDeclarationStatement ::= .LocalVariableDeclaration SEMICOLON 
LocalVariableDeclaration ::= .VariableModifiersopt Type VariableDeclarators 
Statement ::= .StatementWithoutTrailingSubstatement 
Statement ::= .LabeledStatement 
Statement ::= .IfThenStatement 
Statement ::= .IfThenElseStatement 
Statement ::= .WhileStatement 
Statement ::= .ForStatement 
StatementWithoutTrailingSubstatement ::= .Block 
StatementWithoutTrailingSubstatement ::= .EmptyStatement 
StatementWithoutTrailingSubstatement ::= .ExpressionStatement 
StatementWithoutTrailingSubstatement ::= .AssertStatement 
StatementWithoutTrailingSubstatement ::= .SwitchStatement 
StatementWithoutTrailingSubstatement ::= .DoStatement 
StatementWithoutTrailingSubstatement ::= .BreakStatement 
StatementWithoutTrailingSubstatement ::= .ContinueStatement 
StatementWithoutTrailingSubstatement ::= .ReturnStatement 
StatementWithoutTrailingSubstatement ::= .SynchronizedStatement 
StatementWithoutTrailingSubstatement ::= .ThrowStatement 
StatementWithoutTrailingSubstatement ::= .TryStatement 
IfThenStatement ::= .if LPAREN Expression RPAREN Statement 
IfThenElseStatement ::= .if LPAREN Expression RPAREN StatementNoShortIf else 
                        Statement 
EmptyStatement ::= .SEMICOLON 
LabeledStatement ::= .identifier COLON Statement 
ExpressionStatement ::= .StatementExpression SEMICOLON 
StatementExpression ::= .Assignment 
StatementExpression ::= .PreIncrementExpression 
StatementExpression ::= .PreDecrementExpression 
StatementExpression ::= .PostIncrementExpression 
StatementExpression ::= .PostDecrementExpression 
StatementExpression ::= .MethodInvocation 
StatementExpression ::= .ClassInstanceCreationExpression 
AssertStatement ::= .assert Expression SEMICOLON 
AssertStatement ::= .assert Expression COLON Expression SEMICOLON 
SwitchStatement ::= .switch LPAREN Expression RPAREN SwitchBlock 
WhileStatement ::= .while LPAREN Expression RPAREN Statement 
DoStatement ::= .do Statement while LPAREN Expression RPAREN SEMICOLON 
ForStatement ::= .BasicForStatement 
ForStatement ::= .EnhancedForStatement 
BasicForStatement ::= .for LPAREN ForInitopt SEMICOLON Expressionopt SEMICOLON 
                      ForUpdateopt RPAREN Statement 
EnhancedForStatement ::= .for LPAREN FormalParameter COLON Expression RPAREN 
                         Statement 
BreakStatement ::= .break identifieropt SEMICOLON 
ContinueStatement ::= .continue identifieropt SEMICOLON 
ReturnStatement ::= .return Expressionopt SEMICOLON 
ThrowStatement ::= .throw Expression SEMICOLON 
SynchronizedStatement ::= .synchronized LPAREN Expression RPAREN Block 
TryStatement ::= .try Block Catches 
TryStatement ::= .try Block Catchesopt Finally 
Primary ::= .PrimaryNoNewArray 
Primary ::= .ArrayCreationExpression 
PrimaryNoNewArray ::= .Literal 
PrimaryNoNewArray ::= .Type DOT class 
PrimaryNoNewArray ::= .void DOT class 
PrimaryNoNewArray ::= .this 
PrimaryNoNewArray ::= .ClassName DOT this 
PrimaryNoNewArray ::= .LPAREN Expression RPAREN 
PrimaryNoNewArray ::= .ClassInstanceCreationExpression 
PrimaryNoNewArray ::= .FieldAccess 
PrimaryNoNewArray ::= .MethodInvocation 
PrimaryNoNewArray ::= .ArrayAccess 
Literal ::= .IntegerLiteral 
Literal ::= .LongLiteral 
Literal ::= .FloatingPointLiteral 
Literal ::= .DoubleLiteral 
Literal ::= .BooleanLiteral 
Literal ::= .CharacterLiteral 
Literal ::= .StringLiteral 
Literal ::= .null 
BooleanLiteral ::= .true 
BooleanLiteral ::= .false 
ClassInstanceCreationExpression ::= .new TypeArgumentsopt ClassOrInterfaceType 
                                    TypeArgumentsopt LPAREN ArgumentListopt 
                                    RPAREN ClassBodyopt 
ClassInstanceCreationExpression ::= .Primary DOT new TypeArgumentsopt 
                                    identifier TypeArgumentsopt LPAREN 
                                    ArgumentListopt RPAREN ClassBodyopt 
ArrayCreationExpression ::= .new PrimitiveType DimExprs Dimsopt 
ArrayCreationExpression ::= .new ClassOrInterfaceType DimExprs Dimsopt 
ArrayCreationExpression ::= .new PrimitiveType Dims ArrayInitializer 
ArrayCreationExpression ::= .new ClassOrInterfaceType Dims ArrayInitializer 
FieldAccess ::= .Primary DOT identifier 
FieldAccess ::= .super DOT identifier 
FieldAccess ::= .ClassName DOT super DOT identifier 
MethodInvocation ::= .MethodName LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .Primary DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .super DOT TypeArgumentsopt identifier LPAREN 
                     ArgumentListopt RPAREN 
MethodInvocation ::= .ClassName DOT super DOT TypeArgumentsopt identifier 
                     LPAREN ArgumentListopt RPAREN 
MethodInvocation ::= .TypeName DOT TypeArguments identifier LPAREN 
   