/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.lpg.parser.ParseController;
import org.eclipse.imp.model.ICompilationUnit;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.utils.HTMLPrinter;

public class DocumentationProvider
implements IDocumentationProvider,
ILanguageService {
    public String getDocumentation(Object target, IParseController parseController) {
        LPGParser.ASTNode def;
        StringBuffer buff = new StringBuffer();
        LPGParser.ASTNode ast = (LPGParser.ASTNode)parseController.getCurrentAst();
        if (ast == null) {
            return null;
        }
        if (target instanceof LPGParser.IASTNodeToken && (def = (LPGParser.ASTNode)ASTUtils.findDefOf((LPGParser.IASTNodeToken)target, (LPGParser.LPG)ast, parseController)) != null) {
            return DocumentationProvider.getSubstring(parseController, def.getLeftIToken().getStartOffset(), def.getRightIToken().getEndOffset());
        }
        if (target instanceof LPGParser.nonTerm) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)target;
            HTMLPrinter.addSmallHeader((StringBuffer)buff, (String)("non-terminal " + nt.getruleNameWithAttributes().getSYMBOL()));
        } else if (target instanceof LPGParser.terminal) {
            LPGParser.terminal term = (LPGParser.terminal)target;
            HTMLPrinter.addSmallHeader((StringBuffer)buff, (String)("terminal " + term.getterminal_symbol()));
        } else if (target instanceof ICompilationUnit) {
            ICompilationUnit icu = (ICompilationUnit)target;
            HTMLPrinter.addSmallHeader((StringBuffer)buff, (String)("source file " + HTMLPrinter.convertToHTMLContent((String)icu.getName())));
        }
        HTMLPrinter.addParagraph((StringBuffer)buff, (String)target.toString());
        return buff.toString();
    }

    public static String getSubstring(IParseController parseController, int start, int end) {
        return new String(((ParseController)parseController).getParser().getIPrsStream().getInputChars(), start, end - start + 1);
    }
}

