/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.actions;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.lpg.actions.LanguageActionContributor;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.SymbolTable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowFirstSetAction
extends TextEditorAction {
    private final IFile fGrammarFile;
    private final LPGParser.ASTNode fNode;
    private final LPGParser.LPG fRoot;
    private LPGParser.nonTerm fNonTerm;
    private Set<LPGParser.IASTNodeToken> fFirstSet;

    public ShowFirstSetAction(UniversalEditor editor) {
        super(LanguageActionContributor.ResBundle, "showFirstSet.", (ITextEditor)editor);
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.fGrammarFile = fileInput.getFile();
            this.fRoot = this.getAST(editor);
            this.fNode = this.findNode(editor);
        } else {
            this.fGrammarFile = null;
            this.fRoot = null;
            this.fNode = null;
        }
    }

    public void run() {
        Object nt;
        UniversalEditor editor = (UniversalEditor)this.getTextEditor();
        IParseController parseController = editor.getParseController();
        if (this.fNode instanceof LPGParser.symWithAttrs__SYMBOL_optAttrList) {
            LPGParser.symWithAttrs__SYMBOL_optAttrList sym = (LPGParser.symWithAttrs__SYMBOL_optAttrList)this.fNode;
            nt = ASTUtils.findDefOf(sym, this.fRoot, parseController);
        } else if (this.fNode instanceof LPGParser.IASTNodeToken) {
            LPGParser.IASTNodeToken tok = (LPGParser.IASTNodeToken)((Object)this.fNode);
            nt = ASTUtils.findDefOf(tok, this.fRoot, parseController);
        } else {
            nt = this.fNode;
        }
        if (!(nt instanceof LPGParser.nonTerm)) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Can only show first-set of a non-terminal.");
            return;
        }
        this.fNonTerm = (LPGParser.nonTerm)nt;
        this.collectFirstSet();
        StringBuffer buff = new StringBuffer();
        for (LPGParser.IASTNodeToken tok : this.fFirstSet) {
            buff.append(tok.toString()).append('\n');
        }
        MessageDialog.openInformation((Shell)editor.getSite().getShell(), (String)("First set of " + this.fNonTerm.getruleNameWithAttributes().getSYMBOL()), (String)buff.toString());
    }

    private void collectFirstSet() {
        SymbolTable<LPGParser.ASTNode> symbolTable = this.fRoot.symbolTable;
        Stack<LPGParser.nonTerm> workList = new Stack<LPGParser.nonTerm>();
        HashSet<LPGParser.nonTerm> processed = new HashSet<LPGParser.nonTerm>();
        this.fFirstSet = new HashSet<LPGParser.IASTNodeToken>();
        HashSet<LPGParser.nonTerm> epsilonSet = new HashSet<LPGParser.nonTerm>();
        workList.push(this.fNonTerm);
        while (!workList.empty()) {
            LPGParser.nonTerm nt = (LPGParser.nonTerm)workList.pop();
            processed.add(nt);
            LPGParser.ruleList rules = nt.getruleList();
            for (int i = 0; i < rules.size(); ++i) {
                LPGParser.ASTNode node;
                LPGParser.rule r = rules.getruleAt(i);
                LPGParser.symWithAttrsList syms = r.getsymWithAttrsList();
                LPGParser.IsymWithAttrs firstSym = null;
                int symIdx = 0;
                do {
                    firstSym = syms.getsymWithAttrsAt(symIdx++);
                    node = (LPGParser.ASTNode)symbolTable.get((Object)firstSym.toString());
                    if (!firstSym.toString().equals("$empty")) continue;
                    epsilonSet.add(nt);
                } while (symIdx < syms.size() && firstSym.toString().equals("$empty") || epsilonSet.contains(node));
                if (node == null) {
                    if (firstSym.toString().equals("$empty")) continue;
                    this.fFirstSet.add(firstSym);
                    continue;
                }
                if (node instanceof LPGParser.terminal) {
                    if (this.fFirstSet.contains(node)) continue;
                    LPGParser.terminal thisTerm = (LPGParser.terminal)node;
                    this.fFirstSet.add(thisTerm.getterminal_symbol());
                    continue;
                }
                if (!(node instanceof LPGParser.nonTerm) || processed.contains(node)) continue;
                workList.add((LPGParser.nonTerm)node);
            }
        }
        this.dumpTerms(this.fFirstSet, "First Set:");
    }

    private void dumpTerms(Set<LPGParser.IASTNodeToken> tokSet, String headerMsg) {
        System.out.println(headerMsg);
        for (LPGParser.IASTNodeToken tok : tokSet) {
            System.out.println(tok);
        }
    }

    private LPGParser.LPG getAST(UniversalEditor editor) {
        IParseController parseController = editor.getParseController();
        return (LPGParser.LPG)parseController.getCurrentAst();
    }

    private LPGParser.ASTNode findNode(UniversalEditor editor) {
        Point sel = editor.getSelection();
        IParseController parseController = editor.getParseController();
        ISourcePositionLocator locator = parseController.getSourcePositionLocator();
        return (LPGParser.ASTNode)locator.findNode((Object)this.fRoot, sel.x);
    }
}

