/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.search;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.imp.lpg.search.LPGSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

class LPGSearchResult
extends AbstractTextSearchResult
implements IFileMatchAdapter,
IEditorMatchAdapter {
    LPGSearchQuery fQuery;

    public LPGSearchResult(LPGSearchQuery q) {
        this.fQuery = q;
    }

    private void addBogusMatches() {
        Set projects = this.fQuery.getScope().getProjects();
        IProject jikesPGTestProject = null;
        for (IProject project : projects) {
            if (!project.getName().equals("JikesPGTest")) continue;
            jikesPGTestProject = project;
        }
        if (jikesPGTestProject == null) {
            System.err.println("Couldn't find test project");
        } else {
            IFile file = jikesPGTestProject.getFile("grammar.g");
            this.addMatch(new Match((Object)file, 0, 10));
            this.addMatch(new Match((Object)file, 100, 10));
        }
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public String getLabel() {
        return this.fQuery.getLabel();
    }

    public String getTooltip() {
        return "heh?";
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        return (IFile)element;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            IFile matchFile = (IFile)match.getElement();
            return file.equals(matchFile);
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        return new Match[0];
    }
}

