/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lpg.runtime.IToken;
import org.eclipse.imp.editor.SourceProposal;
import org.eclipse.imp.lpg.parser.ASTUtils;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.services.IContentProposer;
import org.eclipse.imp.utils.HTMLPrinter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentProposer
implements IContentProposer {
    private static final String[] SEGMENT_KEYS = new String[]{"Define", "Export", "Globals", "Headers", "Identifiers", "Include", "Import", "Keywords", "Notice", "Recover", "Rules", "Start", "Terminals", "Types"};
    private static final String[] OPTION_KEYS = new String[]{"action", "ast_directory", "ast_type", "attributes", "automatic_ast", "backtrack", "byte", "conflicts", "dat-directory", "dat-file", "dcl-file", "debug", "def-file", "edit", "error-maps", "escape", "extends-parsetable", "export-terminals", "factory", "file-prefix", "filter", "first", "follow", "goto-default", "grm-file", "headers", "imp-file", "import-terminals", "include-directory", "lalr-level", "list", "margin", "max_cases", "names", "nt-check", "or-marker", "out_directory", "package", "parent_saved", "parsetable-interfaces", "prefix", "priority", "programming_language", "prs-file", "quiet", "read-reduce", "remap-terminals", "scopes", "serialize", "shift-default", "single-productions", "slr", "soft-keywords", "states", "suffix", "sym-file", "tab-file", "table", "template", "trace", "trailers", "variables", "verbose", "visitor", "visitor-type", "warnings", "xref"};
    private static final String[] OPTION_ARGS = new String[]{"action=(<string>,<string>,<string>)", "ast_directory=<directory_name>", "ast_type=MyASTNode", "attributes", "automatic_ast={none,nested,toplevel}", "backtrack", "byte", "conflicts", "dat-directory=<directory_name>", "dat-file=<file_name>", "dcl-file=<file_name>", "debug", "def-file=<file_name>", "edit", "error-maps", "escape=<character>", "extends-parsetable=<string>", "export-terminals=<string>", "factory=<string>", "file-prefix=<string>", "filter=<filter_spec_file_name>", "first", "follow", "goto-default", "grm-file", "headers=(<string>,<string>,<string>)", "imp-file=<string>", "import-terminals=<file_name>", "include-directory=<directory_name>", "lalr-level=<integer>", "list", "margin=<integer>", "max_cases=<integer>", "names={optimized,maximum,minimum}", "nt-check", "or-marker=<character>", "out_directory=<directory_name>", "package=org.my.package", "parent_saved", "parsetable-interfaces=<string>", "prefix=<string>", "priority", "programming_language={xml,c,cpp,java,plx,plxasm,ml}", "prs-file=<file_name>", "quiet", "read-reduce", "remap-terminals", "scopes", "serialize", "shift-default", "single-productions", "slr", "soft-keywords", "states", "suffix=<string>", "sym-file=<file_name>", "tab-file=<file_name>", "table", "template=<file_name>", "trace={conflicts,full}", "trailers=(<string>,<string>,<string>)", "variables={none,both,terminals,nt,nonterminals}", "verbose", "visitor={none,default,preorder}", "visitor-type=<string>", "warnings", "xref"};

    public ICompletionProposal[] getContentProposals(IParseController controller, int offset, ITextViewer textViewer) {
        LPGParser.LPG root = (LPGParser.LPG)controller.getCurrentAst();
        if (root == null) {
            return new ICompletionProposal[0];
        }
        ISourcePositionLocator locator = controller.getSourcePositionLocator();
        LPGParser.ASTNode thisNode = (LPGParser.ASTNode)locator.findNode((Object)root, offset);
        IToken thisLeftToken = thisNode.getLeftIToken();
        String prefixToken = offset >= thisLeftToken.getStartOffset() && offset < thisLeftToken.getEndOffset() ? thisLeftToken.toString() : null;
        String prefix = prefixToken != null ? prefixToken.substring(0, offset - thisLeftToken.getStartOffset()) : "";
        ArrayList<Object> proposals = new ArrayList<Object>();
        if (thisNode.getParent() instanceof LPGParser.option) {
            LPGParser.option opt = (LPGParser.option)thisNode.getParent();
            if (thisNode == opt.getSYMBOL()) {
                proposals.addAll(this.computeOptionKeyProposals(prefix, offset));
            }
        } else if (thisNode.getParent() instanceof LPGParser.LPG || prefix.startsWith("%")) {
            proposals.addAll(this.computeSegmentCompletions(prefix, offset, root));
        } else if (prefix.startsWith("$")) {
            proposals.addAll(this.computeMacroCompletions(prefix, offset, root));
        } else {
            proposals.addAll(this.computeNonTerminalCompletions(prefix, offset, root));
            proposals.addAll(this.computeTerminalCompletions(prefix, offset, root));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private Collection<? extends ICompletionProposal> computeSegmentCompletions(String prefix, int offset, LPGParser.LPG root) {
        ArrayList<SourceProposal> result = new ArrayList<SourceProposal>();
        for (int i = 0; i < SEGMENT_KEYS.length; ++i) {
            String key = SEGMENT_KEYS[i];
            if (prefix.length() > 1 && !key.toLowerCase().startsWith(prefix.substring(1).toLowerCase())) continue;
            String newText = "%" + key + "\n" + "  " + "\n" + "%End";
            StringBuffer addlInfo = new StringBuffer();
            HTMLPrinter.addSmallHeader((StringBuffer)addlInfo, (String)key);
            HTMLPrinter.addParagraph((StringBuffer)addlInfo, (String)("%" + key));
            HTMLPrinter.addParagraph((StringBuffer)addlInfo, (String)"  ...");
            HTMLPrinter.addParagraph((StringBuffer)addlInfo, (String)"%End");
            int cursorLoc = offset + key.length() + 4;
            result.add(new SourceProposal(key, newText, prefix, new Region(offset, 0), cursorLoc, addlInfo.toString()));
        }
        return result;
    }

    private Collection<SourceProposal> computeOptionKeyProposals(String prefix, int offset) {
        ArrayList<SourceProposal> result = new ArrayList<SourceProposal>();
        for (int i = 0; i < OPTION_KEYS.length; ++i) {
            String key = OPTION_KEYS[i];
            if (!key.startsWith(prefix)) continue;
            StringBuffer addlInfo = new StringBuffer();
            HTMLPrinter.addSmallHeader((StringBuffer)addlInfo, (String)key);
            HTMLPrinter.addParagraph((StringBuffer)addlInfo, (String)HTMLPrinter.convertToHTMLContent((String)OPTION_ARGS[i]));
            result.add(new SourceProposal(key, key, prefix, new Region(offset, 0), addlInfo.toString()));
        }
        return result;
    }

    private List<ICompletionProposal> computeMacroCompletions(String prefix, int offset, LPGParser.LPG root) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<LPGParser.Imacro_name_symbol> macros = ASTUtils.getMacros(root);
        for (LPGParser.Imacro_name_symbol macro : macros) {
            String macroName = macro.toString();
            if (!macroName.startsWith(prefix)) continue;
            result.add((ICompletionProposal)new SourceProposal(macroName, prefix, offset));
        }
        return result;
    }

    private List<ICompletionProposal> computeNonTerminalCompletions(String prefix, int offset, LPGParser.LPG root) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<LPGParser.nonTerm> nonTerms = ASTUtils.getNonTerminals(root);
        for (LPGParser.nonTerm nt : nonTerms) {
            String ntRawName = nt.getruleNameWithAttributes().getSYMBOL().toString();
            int idx = ntRawName.indexOf(36);
            String ntName = idx >= 0 ? ntRawName.substring(0, idx) : ntRawName;
            if (!ntName.startsWith(prefix)) continue;
            StringBuffer addlInfo = new StringBuffer();
            HTMLPrinter.addSmallHeader((StringBuffer)addlInfo, (String)ntName);
            HTMLPrinter.addParagraph((StringBuffer)addlInfo, (String)nt.toString());
            result.add((ICompletionProposal)new SourceProposal(ntName, ntName, prefix, new Region(offset, 0), addlInfo.toString()));
        }
        return result;
    }

    private List<ICompletionProposal> computeTerminalCompletions(String prefix, int offset, LPGParser.LPG root) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<LPGParser.terminal> terms = ASTUtils.getTerminals(root);
        for (LPGParser.terminal t : terms) {
            String termRawName = t.getterminal_symbol().toString();
            int idx = termRawName.indexOf(36);
            String termName = idx >= 0 ? termRawName.substring(0, idx) : termRawName;
            if (!termName.startsWith(prefix)) continue;
            result.add((ICompletionProposal)new SourceProposal(termName, prefix, offset));
        }
        return result;
    }
}

