/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.imp.lpg.search.LPGSearchQuery;
import org.eclipse.imp.lpg.search.LPGSearchScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LPGSearchPage
extends DialogPage
implements ISearchPage {
    private ISearchPageContainer fContainer;
    private Text fEntityName;
    private boolean fNonTerm;
    private Button fNonTermTypeButton;
    private Button fTermTypeButton;

    public LPGSearchPage() {
        super("JikesPG Search", null);
    }

    public LPGSearchPage(String title) {
        this(title, null);
    }

    public LPGSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("JikesPGTest");
        boolean isWorkspaceScope = this.fContainer.getSelectedScope() == 0;
        LPGSearchScope scope = isWorkspaceScope ? LPGSearchScope.createWorkspaceScope() : LPGSearchScope.createProjectScope(project);
        LPGSearchQuery query = new LPGSearchQuery(this.fEntityName.getText(), this.fNonTerm, scope);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText("Grammar entity:");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Group typeGroup = new Group(parent, 0);
        typeGroup.setText("Entity type");
        typeGroup.setLayout((Layout)new GridLayout(2, true));
        Label nameLabel = new Label((Composite)typeGroup, 16384);
        nameLabel.setText("Name regexp:");
        this.fEntityName = new Text((Composite)typeGroup, 18432);
        this.fEntityName.setText("");
        this.fNonTermTypeButton = new Button((Composite)typeGroup, 16);
        this.fNonTermTypeButton.setText("Non-terminal");
        this.fNonTermTypeButton.setSelection(true);
        this.fNonTermTypeButton.addSelectionListener((SelectionListener)new TypeSelectionListener());
        this.fTermTypeButton = new Button((Composite)typeGroup, 16);
        this.fTermTypeButton.setText("Terminal");
        this.fTermTypeButton.addSelectionListener((SelectionListener)new TypeSelectionListener());
        this.setControl((Control)result);
    }

    private class TypeSelectionListener
    implements SelectionListener {
        private TypeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Widget w = (Widget)e.getSource();
            if (w == LPGSearchPage.this.fNonTermTypeButton) {
                LPGSearchPage.this.fNonTerm = true;
            } else {
                LPGSearchPage.this.fNonTerm = false;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

