/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.builder.BuilderBase;
import org.eclipse.imp.lpg.LPGRuntimePlugin;
import org.eclipse.imp.lpg.parser.LPGLexer;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

public class LPGBuilder
extends BuilderBase {
    private static final String LPG_BUILDER_CONSOLE = "LPG Build";
    public static final String BUILDER_ID = "org.eclipse.imp.lpg.ide.LPGBuilder";
    public static final String PROBLEM_MARKER_ID = "org.eclipse.imp.lpg.ide.problem";
    public static final String LPG_RUNTIME_PLUGIN_ID = "lpg.runtime.java";
    public static final String LPG_GENERATOR_PLUGIN_ID = "lpg.generator";
    private static final String SYNTAX_MSG_REGEXP = "(.*):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+): (Informative|Warning|Error): (.*)";
    private static final Pattern SYNTAX_MSG_PATTERN = Pattern.compile("(.*):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+): (Informative|Warning|Error): (.*)");
    private static final String SYNTAX_MSG_NOSEV_REGEXP = "(.*):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+): (.*)";
    private static final Pattern SYNTAX_MSG_NOSEV_PATTERN = Pattern.compile("(.*):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+):([0-9]+): (.*)");
    private static final String MISSING_MSG_REGEXP = " file \"([^\"]+)\" could not be read";
    private static final Pattern MISSING_MSG_PATTERN = Pattern.compile(" file \"([^\"]+)\" could not be read");
    private boolean fEmitDiagnostics;
    final String lineSep = System.getProperty("line.separator");
    final int lineSepBias = this.lineSep.length() - 1;
    private static boolean fIsWin32 = Platform.getOS().equals("win32");

    protected PluginBase getPlugin() {
        return LPGRuntimePlugin.getInstance();
    }

    protected String getErrorMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getWarningMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected String getInfoMarkerID() {
        return PROBLEM_MARKER_ID;
    }

    protected boolean isSourceFile(IFile file) {
        String extensListed = this.getPreferencesService().getStringPreference("SourceFileExtensions");
        String[] extens = extensListed.split(",");
        HashSet<String> rootExtensionsSet = new HashSet<String>();
        for (int i = 0; i < extens.length; ++i) {
            rootExtensionsSet.add(extens[i]);
        }
        return !file.isDerived() && rootExtensionsSet.contains(file.getFileExtension());
    }

    protected boolean isNonRootSourceFile(IFile file) {
        String extensListed = this.getPreferencesService().getStringPreference("IncludeFileExtensions");
        String[] extens = extensListed.split(",");
        HashSet<String> nonrootExtensionsSet = new HashSet<String>();
        for (int i = 0; i < extens.length; ++i) {
            nonrootExtensionsSet.add(extens[i]);
        }
        return !file.isDerived() && nonrootExtensionsSet.contains(file.getFileExtension());
    }

    protected boolean isOutputFolder(IResource resource) {
        return resource.getFullPath().lastSegment().equals("bin");
    }

    protected String getConsoleName() {
        return LPG_BUILDER_CONSOLE;
    }

    protected void compile(IFile file, IProgressMonitor monitor) {
        this.fEmitDiagnostics = this.getPreferencesService().getBooleanPreference("EmitDiagnostics");
        String fileName = file.getLocation().toOSString();
        try {
            String executablePath = this.getLPGExecutable();
            if (executablePath.length() == 0) {
                return;
            }
            File parentDir = new File(fileName).getParentFile();
            String includePath = this.getIncludePath();
            String[] cmd = this.buildCmdlineArgs(fileName, executablePath, includePath);
            MessageConsoleStream diag = this.getConsoleStream();
            if (this.fEmitDiagnostics) {
                diag.println("Running generator on grammar file '" + fileName + "'.");
                diag.println("Using executable at '" + executablePath + "'.");
                diag.println("Using template path '" + includePath + "'.");
            }
            Process process = Runtime.getRuntime().exec(cmd, new String[0], parentDir);
            this.processLPGOutput((IResource)file, process, diag);
            this.processLPGErrors((IResource)file, process, diag);
            this.doRefresh((IResource)file);
            this.collectDependencies(file);
            diag.println("Generator exit code == " + process.waitFor());
        }
        catch (Exception e) {
            LPGRuntimePlugin.getInstance().logException(e.getMessage() == null ? "<no information>" : e.getMessage(), e);
        }
    }

    private String[] buildCmdlineArgs(String fileName, String executablePath, String includePath) {
        String includeSearchPath = "-include-directory='" + includePath + "'";
        String[] cmd = new String[]{executablePath, "-quiet", this.getPreferencesService().getBooleanPreference("GenerateListings") ? "-list" : "-nolist", fIsWin32 ? "\"" + includeSearchPath + "\"" : includeSearchPath, fileName};
        return cmd;
    }

    protected void collectDependencies(IFile file) {
        if (this.fEmitDiagnostics) {
            this.getConsoleStream().println("Collecting dependencies from file '" + file.getLocation().toOSString() + "'.");
        }
        LPGLexer lexer = new LPGLexer();
        try {
            lexer.reset(file.getLocation().toString(), 8);
        }
        catch (IOException e) {
            // empty catch block
        }
        LPGParser parser = new LPGParser(lexer.getILexStream());
        lexer.lexer(null, parser.getIPrsStream());
        LPGParser.ASTNode ast = (LPGParser.ASTNode)parser.parser();
        if (ast != null) {
            this.findDependencies(ast, file.getFullPath().toString());
        }
    }

    private void findDependencies(LPGParser.ASTNode root, final String filePath) {
        root.accept(new LPGParser.AbstractVisitor(){

            public void unimplementedVisitor(String s) {
            }

            public boolean visit(LPGParser.option n) {
                if (n.getSYMBOL().toString().equals("import_terminals")) {
                    String referent = ((LPGParser.option_value__EQUAL_SYMBOL)n.getoption_value()).getSYMBOL().toString();
                    String referentPath = filePath.substring(0, filePath.lastIndexOf("/") + 1) + referent;
                    LPGBuilder.this.fDependencyInfo.addDependency(filePath, referentPath);
                } else if (n.getSYMBOL().toString().equals("filter")) {
                    String referent = ((LPGParser.option_value__EQUAL_SYMBOL)n.getoption_value()).getSYMBOL().toString();
                    String referentPath = filePath.substring(0, filePath.lastIndexOf("/") + 1) + referent;
                    LPGBuilder.this.fDependencyInfo.addDependency(filePath, referentPath);
                }
                return false;
            }

            public boolean visit(LPGParser.import_segment n) {
                LPGBuilder.this.fDependencyInfo.addDependency(filePath, n.getSYMBOL().toString());
                return false;
            }

            public boolean visit(LPGParser.include_segment n) {
                LPGBuilder.this.fDependencyInfo.addDependency(filePath, n.getSYMBOL().toString());
                return false;
            }
        });
    }

    private void processLPGErrors(IResource resource, Process process, MessageConsoleStream stream) throws IOException {
        String line;
        InputStream is = process.getErrorStream();
        BufferedReader in2 = new BufferedReader(new InputStreamReader(is));
        while ((line = in2.readLine()) != null) {
            if (this.fEmitDiagnostics) {
                stream.println(line);
            }
            if (!this.parseSyntaxMessageCreateMarker(line)) {
                if (line.indexOf("could not be read.") >= 0) {
                    this.parseMissingFileMessage(line, resource);
                } else {
                    this.handleMiscMessage(line, resource);
                }
            }
            LPGRuntimePlugin.getInstance().writeErrorMsg(line);
        }
        is.close();
    }

    private void processLPGOutput(IResource resource, Process process, MessageConsoleStream stream) throws IOException {
        InputStream is = process.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = in.readLine()) != null) {
            if (this.fEmitDiagnostics) {
                stream.println(line);
            }
            if (line.length() == 0 || this.parseSyntaxMessageCreateMarker(line)) continue;
            if (line.indexOf("could not be read.") >= 0) {
                this.parseMissingFileMessage(line, resource);
                continue;
            }
            this.handleMiscMessage(line, resource);
        }
    }

    private void handleMiscMessage(String msg, IResource file) {
        if (msg.length() == 0) {
            return;
        }
        if (msg.startsWith("Unable to open")) {
            this.createMarker(file, 1, -1, -1, msg, 2);
            return;
        }
        if (msg.startsWith("***ERROR: ")) {
            this.createMarker(file, 1, 0, 1, msg.substring(10), 2);
            return;
        }
        if (msg.indexOf("Number of ") >= 0 || msg.startsWith("(C) Copyright") || msg.startsWith("IBM LALR Parser")) {
            return;
        }
        Matcher matcher = SYNTAX_MSG_NOSEV_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String projectLoc;
            String errorFile = matcher.group(1);
            if (errorFile.startsWith(projectLoc = this.getProject().getLocation().toString())) {
                errorFile = errorFile.substring(projectLoc.length());
            }
            IFile errorResource = this.getProject().getFile(errorFile);
            int startLine = Integer.parseInt(matcher.group(2));
            int startChar = Integer.parseInt(matcher.group(6)) - 1;
            int endChar = Integer.parseInt(matcher.group(7));
            String descrip = matcher.group(8);
            if (startLine == 0) {
                startLine = 1;
            }
            this.createMarker((IResource)errorResource, startLine, startChar, endChar, descrip, 1);
        } else {
            this.createMarker(file, 1, 0, 1, msg, 0);
        }
    }

    private void parseMissingFileMessage(String msg, IResource file) {
        Matcher matcher = MISSING_MSG_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String missingFile = matcher.group(1);
            int refLine = 1;
            this.createMarker(file, refLine, -1, -1, "Non-existent file referenced: " + missingFile, 2);
        }
    }

    private boolean parseSyntaxMessageCreateMarker(String msg) {
        Matcher matcher = SYNTAX_MSG_PATTERN.matcher(msg);
        if (matcher.matches()) {
            IFile errorResource;
            String projectLoc;
            String errorFile = matcher.group(1);
            if (errorFile.startsWith(projectLoc = this.getProject().getLocation().toString())) {
                errorFile = errorFile.substring(projectLoc.length());
            }
            if (!(errorResource = this.getProject().getFile(errorFile)).exists()) {
                return true;
            }
            int startLine = Integer.parseInt(matcher.group(2));
            int startChar = Integer.parseInt(matcher.group(6)) - 1;
            int endChar = Integer.parseInt(matcher.group(7));
            String severity = matcher.group(8);
            String descrip = matcher.group(9);
            if (startLine == 0) {
                startLine = 1;
            }
            if (startChar < 0) {
                startChar = 0;
                endChar = 1;
            }
            this.createMarker((IResource)errorResource, startLine, startChar, endChar, descrip, this.mapSeverity(severity));
            return true;
        }
        return false;
    }

    private int mapSeverity(String severity) {
        return severity.equals("Informative") ? 0 : (severity.equals("Warning") ? 1 : 2);
    }

    public String getIncludePath() {
        if (this.getPreferencesService().getBooleanPreference("UseDefaultIncludePath")) {
            return this.getPreferencesService().getStringPreference("default", "IncludePathToUse");
        }
        String projSpecIncPath = this.getPreferencesService().getStringPreference("IncludePathToUse");
        return projSpecIncPath;
    }

    public static String getDefaultIncludePath() {
        Bundle bundle = Platform.getBundle((String)LPG_GENERATOR_PLUGIN_ID);
        try {
            String tmplPath = FileLocator.toFileURL((URL)bundle.getEntry("templates")).getFile();
            if (fIsWin32) {
                tmplPath = tmplPath.substring(1);
            }
            return tmplPath;
        }
        catch (IOException e) {
            LPGRuntimePlugin.getInstance().logException(e.getMessage() == null ? "Returning null:  <no information>" : "Returning null:  " + e.getMessage(), e);
            return null;
        }
    }

    private String getLPGExecutable() throws IOException {
        String result = this.getPreferencesService().getBooleanPreference("UseDefaultExecutable") ? this.getPreferencesService().getStringPreference("default", "ExecutableToUse") : this.getPreferencesService().getStringPreference("ExecutableToUse");
        if (!new File(result).exists()) {
            this.postMsgDialog("No LPG Executable", "The LPG executable cannot be found at the location you specified. Please change the setting in the LPG preferences page.");
            return "";
        }
        return result;
    }
}

