/*******************************************************************************
* Copyright (c) 2007 IBM Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*    Robert Fuhrer (rfuhrer@watson.ibm.com) - initial API and implementation

*******************************************************************************/

/**
 * 
 */
package org.eclipse.imp.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class NewEditorService extends CodeServiceWizard {

    protected String fServiceFileName = null;
    protected String fServiceClassName = null;
    protected String fServiceExtensionId = null;
    protected String fServiceExtensionName = null;
    protected IModelListener.AnalysisRequired fAnalysisRequired = null;
    
    protected NewEditorServiceWizardPage fPage = null;
	
    public void addPages() {
        //addPages(new ExtensionPointWizardPage[] { new ExtensionPointWizardPage(this, RuntimePlugin.IMP_RUNTIME, "hoverHelper"), });
    	addPages(new ExtensionPointWizardPage[] { new NewEditorServiceWizardPage(this) } );
    	fPage = (NewEditorServiceWizardPage) pages[0];
    }

    // TODO:  Rethink dependencies
    protected List<String> getPluginDependencies() {
        return Arrays.asList(new String[] { "org.eclipse.core.runtime", "org.eclipse.core.resources",
    	    "org.eclipse.imp.runtime" });
    }

    
    protected void collectCodeParms() {
    	super.collectCodeParms();
    	NewEditorServiceWizardPage page= (NewEditorServiceWizardPage) pages[0];
    	
    	fServiceExtensionName = page.getField("name").getText();
    	fServiceExtensionId = page.getField("id").getText();
    	fAnalysisRequired = page.getAnalysisLevel();
    }

    
    public void generateCodeStubs(IProgressMonitor monitor) throws CoreException
    {	
    	// (needed for update in hover-helper template)
    	Map<String, String> subs= getStandardSubstitutions(fProject);

		subs.remove("$PACKAGE_NAME$");
		subs.put("$PACKAGE_NAME$", fPackageName);

		subs.remove("$ANALYSIS_LEVEL$");
		subs.put("$ANALYSIS_LEVEL$", fAnalysisRequired.name());
		
		subs.remove("$SERVICE_CLASS_NAME$");
		subs.put("$SERVICE_CLASS_NAME$", fFullClassName);
		
		
		String editorServiceTemplateName = "editorService.java";
		IFile editorServiceFile = createFileFromTemplate(
			fFullClassName + ".java", editorServiceTemplateName, fPackageFolder, subs, fProject, monitor);
		ExtensionPointEnabler.enable(
			fProject, "org.eclipse.imp.runtime", "editorService",
			new String[][] {
					{ "extension:id", fServiceExtensionId },
		            { "extension:name", fServiceExtensionName },
		            { "editorService:class", fPackageName + "." + fFullClassName },
		            { "editorService:language", fLanguageName} },
		    false, getPluginDependencies(), new NullProgressMonitor());

		editFile(monitor, editorServiceFile);
    }
    
    
    /**
     * Overrides method in ExtensionPointWizard.
     *
     * Provides a basic implementation that returns the name of the
     * one class that will definitely be generated by a specific wizard.	
     * 
     * Subclasses should override if the wizard will generate more than
     * one implementation class.
     * 
     * @return	An array of names of existing files that would be clobbered by
     * 			the new files to be generated
     */
    /**
     * Return the names of any existing files that would be clobbered by the
     * new files to be generated.
     * 
     * @return	An array of names of existing files that would be clobbered by
     * 			the new files to be generated
     */
    protected String[] getFilesThatCouldBeClobbered() {
    	String prefix = fProject.getLocation().toString() + '/' + getProjectSourceLocation(fProject) + fPackageName.replace('.', '/') + '/';
		return new String[] {prefix + fFullClassName + ".java" };
    }
    
    
    
    // SMS 9 Aug 2008:  Need to override?  Yes--Because performFinish in ExtensionPointWizard
    // calls both ExtensionPointEnabler.enable(..) and generateCodeStubs(..), but we want to
    // call the other version of ExtensionPointEnabler.enable(..) ourselves, which we do in
    // generate code stubs.  So we need a customized version of performFinish() that won't
    // call the wrong version of enable(..).
    public boolean performFinish() {
    	collectCodeParms(); // Do this in the UI thread while the wizard fields are still accessible
    	
    	IRunnableWithProgress op= new IRunnableWithProgress() {
    	    public void run(IProgressMonitor monitor) throws InvocationTargetException {
    		IWorkspaceRunnable wsop= new IWorkspaceRunnable() {
    		    public void run(IProgressMonitor monitor) throws CoreException {
    			try {
    			    generateCodeStubs(monitor);
    			} catch (Exception e) {
    			    ErrorHandler.reportError("Could not add extension points", e);
    			} finally {
    			    monitor.done();
    			}
    		    }
    		};
    		try {
    		    ResourcesPlugin.getWorkspace().run(wsop, monitor);
    		} catch (Exception e) {
    		    ErrorHandler.reportError("Could not add extension points", e);
    		}
    	    }
    	};
    	try {
    	    getContainer().run(true, false, op);
    	} catch (InvocationTargetException e) {
    	    Throwable realException= e.getTargetException();
    	    ErrorHandler.reportError("Error", realException);
    	    return false;
    	} catch (InterruptedException e) {
    	    return false;
    	}
    	return true;
        }
    
    
    
}