/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.browser.SelectContextMenuAction;
import org.eclipse.imp.pdb.browser.TriggerAnalysisMenuAction;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.IFactBaseListener;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactBrowserView
extends ViewPart
implements IFactBaseListener {
    public static final String ID = "org.eclipse.imp.pdb.factBrowser";
    private static final String TYPE_PROPERTY = "type";
    private static final String BASE_TYPE_PROPERTY = "basetype";
    private static final String CONTEXT_PROPERTY = "context";
    private static final String DETAILS_CONSOLE = "Fact Details";
    private FactBase factBase = FactBase.getInstance();
    private TableViewer tableViewer;
    private Table table;
    private MessageConsoleStream fMsgStream;

    public FactBrowserView() {
        this.factBase.addListener((IFactBaseListener)this);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.table = new Table(parent, 65536);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn type = new TableColumn(this.table, 0);
        type.setText("Type");
        type.setResizable(true);
        TableColumn baseType = new TableColumn(this.table, 0);
        baseType.setText("Base Type");
        baseType.setResizable(true);
        TableColumn context = new TableColumn(this.table, 0);
        context.setText("Context");
        context.setResizable(true);
        TableColumn count = new TableColumn(this.table, 0);
        count.setText("#Elements");
        count.setResizable(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setColumnProperties(new String[]{TYPE_PROPERTY, BASE_TYPE_PROPERTY, CONTEXT_PROPERTY});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection sel = FactBrowserView.this.tableViewer.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IFactKey row = (IFactKey)((IStructuredSelection)sel).getFirstElement();
                    FactBrowserView.this.echoKeyValueToConsole(row);
                }
            }
        });
        this.fillTable();
        this.addAnalyzePulldownMenu();
        this.addProjectSelectionBox();
    }

    private void addAnalyzePulldownMenu() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        TriggerAnalysisMenuAction menuAction = new TriggerAnalysisMenuAction();
        toolbar.add((IAction)menuAction);
    }

    private void addProjectSelectionBox() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        SelectContextMenuAction menuAction = SelectContextMenuAction.getInstance();
        toolbar.add((IAction)menuAction);
    }

    private void fillTable() {
        for (IFactKey key : this.factBase.getAllKeys()) {
            this.addFactRow(key);
        }
    }

    protected MessageConsole findConsole(String consoleName) {
        MessageConsole myConsole = null;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = consoleManager.getConsoles();
        for (int i = 0; i < consoles.length; ++i) {
            IConsole console = consoles[i];
            if (!console.getName().equals(consoleName)) continue;
            myConsole = (MessageConsole)console;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(consoleName, null);
            consoleManager.addConsoles(new IConsole[]{myConsole});
        }
        consoleManager.showConsoleView(myConsole);
        return myConsole;
    }

    public MessageConsoleStream getConsoleStream() {
        if (this.fMsgStream == null) {
            this.fMsgStream = this.findConsole(DETAILS_CONSOLE).newMessageStream();
        }
        return this.fMsgStream;
    }

    private void addFactRow(IFactKey key) {
        this.tableViewer.add((Object)key);
        this.repackTable();
    }

    private void repackTable() {
        for (TableColumn column : this.table.getColumns()) {
            column.pack();
        }
    }

    private void removeFact(IFactKey key) {
        this.tableViewer.remove((Object)key);
    }

    private void updateFact(IFactKey key) {
    }

    public void setFocus() {
    }

    public void factChanged(final IFactKey key, IValue newValue, final IFactBaseListener.Reason reason) {
        this.run(new Runnable(){

            public void run() {
                switch (reason) {
                    case FACT_DEFINED: {
                        FactBrowserView.this.addFactRow(key);
                        break;
                    }
                    case FACT_REMOVED: {
                        FactBrowserView.this.removeFact(key);
                    }
                    case FACT_UPDATED: {
                        FactBrowserView.this.updateFact(key);
                    }
                }
            }
        });
    }

    private void run(Runnable r) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(r);
    }

    public String countValue(IValue fact) {
        if (fact instanceof ISet) {
            return Integer.toString(((ISet)fact).size());
        }
        if (fact instanceof IRelation) {
            return Integer.toString(((IRelation)fact).size());
        }
        return "1";
    }

    public void factBaseCleared() {
        this.run(new Runnable(){

            public void run() {
                FactBrowserView.this.tableViewer.refresh();
            }
        });
    }

    public void removeCurrentSelection() {
        ISelection s = this.tableViewer.getSelection();
        if (s instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)s;
            for (IFactKey key : selection) {
                this.factBase.removeFact(key);
            }
        }
    }

    public List<IFactKey> getCurrentSelection() {
        ISelection s = this.tableViewer.getSelection();
        ArrayList<IFactKey> result = new ArrayList<IFactKey>();
        if (s instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)s;
            for (IFactKey key : selection) {
                result.add(key);
            }
        }
        return result;
    }

    private void echoKeyValueToConsole(IFactKey row) {
        MessageConsoleStream ms = this.getConsoleStream();
        try {
            ms.println(row.toString() + " = ");
            ms.println(this.factBase.getFact(row).toString());
        }
        catch (AnalysisException e) {
            ms.println("Error retrieving fact value from factbase: " + e.getMessage());
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private static final int TYPE_COLUMN = 0;
        private static final int BASE_TYPE_COLUMN = 1;
        private static final int CONTEXT_COLUMN = 2;
        private static final int COUNT_COLUMN = 3;

        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFactKey row = (IFactKey)element;
            switch (columnIndex) {
                case 0: {
                    return row.getType().toString();
                }
                case 1: {
                    return row.getType().toString();
                }
                case 2: {
                    return row.getContext().toString();
                }
                case 3: {
                    try {
                        return FactBrowserView.this.countValue(FactBase.getInstance().getFact(row));
                    }
                    catch (AnalysisException e) {
                        return "<unavailable>";
                    }
                }
            }
            return "<invalid>";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

