/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.ui.graph;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphBuilder {
    private HashMap<IValue, GraphNode> fNodeCache = new HashMap();
    private final Graph graph;

    public GraphBuilder(Graph graph) {
        this.graph = graph;
    }

    public void computeGraph(IValue fact) {
        this.fNodeCache.clear();
        this.convert(fact);
    }

    private GraphNode convert(IValue fact) {
        Type type = fact.getType();
        if (type.isRelationType()) {
            return this.convertRelation(fact);
        }
        if (type.isSetType()) {
            return this.convertIterator(((ISet)fact).iterator(), fact, "{...}");
        }
        if (type.isListType()) {
            return this.convertIterator(((IList)fact).iterator(), fact, "[...]");
        }
        if (type.isNodeType() || type.isAbstractDataType() || type.isConstructorType()) {
            return this.convertTree((INode)fact);
        }
        if (type.isTupleType()) {
            return this.convertTuple((ITuple)fact);
        }
        if (type.isMapType()) {
            return this.convertMap((IMap)fact);
        }
        return this.getOrCreateNode(fact, fact.toString());
    }

    private GraphNode convertMap(IMap fact) {
        GraphNode root = this.getOrCreateNode((IValue)fact, "(...)");
        for (IValue key : fact) {
            GraphNode from = this.convert(key);
            GraphNode to = this.convert(fact.get(key));
            if (from == null || to == null) continue;
            new GraphConnection(this.graph, 0, root, from);
            new GraphConnection(this.graph, 0, from, to);
        }
        return root;
    }

    private GraphNode convertTuple(ITuple fact) {
        GraphNode node = this.getOrCreateNode((IValue)fact, "<...>");
        for (int i = 0; i < fact.arity(); ++i) {
            new GraphConnection(this.graph, 0, node, this.convert(fact.get(i)));
        }
        return node;
    }

    private GraphNode convertTree(INode fact) {
        GraphNode node = this.getOrCreateNode((IValue)fact, fact.getName());
        for (IValue child : fact) {
            new GraphConnection(this.graph, 0, node, this.convert(child));
        }
        return node;
    }

    private GraphNode convertRelation(IValue fact) {
        Type type = fact.getType();
        IRelation rel = (IRelation)fact;
        if (type.getArity() == 2) {
            GraphNode to;
            for (IValue value : rel) {
                ITuple tuple = (ITuple)value;
                GraphNode from = this.convert(tuple.get(0));
                to = this.convert(tuple.get(1));
                if (from == null || to == null) continue;
                new GraphConnection(this.graph, 0, from, to);
            }
            GraphNode root = this.getOrCreateNode(fact, "{...}");
            ISet top = rel.domain().subtract(rel.range());
            for (IValue elem : top) {
                to = this.convert(elem);
                new GraphConnection(this.graph, 0, root, to);
            }
            return root;
        }
        if (rel.arity() == 3) {
            return this.convertRelation((IValue)rel.select(new int[]{0, 2}));
        }
        return this.convertSet(fact);
    }

    private GraphNode convertSet(IValue fact) {
        return this.convertIterator(((ISet)fact).iterator(), fact, "{...}");
    }

    private GraphNode convertIterator(Iterator<IValue> iterator, IValue value, String label) {
        GraphNode root = this.getOrCreateNode(value, label);
        while (iterator.hasNext()) {
            IValue e = iterator.next();
            new GraphConnection(this.graph, 0, root, this.convert(e));
        }
        return root;
    }

    public static boolean canShow(Type type) {
        return true;
    }

    private GraphNode getOrCreateNode(IValue value, String label) {
        GraphNode node;
        if (this.fNodeCache.containsKey(value)) {
            node = this.fNodeCache.get(value);
        } else {
            node = new GraphNode((IContainer)this.graph, 0, label);
            this.fNodeCache.put(value, node);
        }
        return node;
    }
}

