/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.ui.graph;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.ui.ValueEditorInput;
import org.eclipse.imp.pdb.ui.graph.GraphBuilder;
import org.eclipse.imp.pdb.ui.graph.MyDirectedGraphLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class Editor
extends EditorPart {
    public static final String EditorId = "org.eclipse.imp.pdb.ui.graph.editor";
    private Canvas canvas;
    private Graph graph;

    public String getTitle() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput != null) {
            return editorInput.getName();
        }
        return "Value";
    }

    public static void open(final IValue value) {
        IWorkbenchPage page;
        if (value == null) {
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null && wb.getWorkbenchWindowCount() != 0) {
            win = wb.getWorkbenchWindows()[0];
        }
        if (win != null && (page = win.getActivePage()) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        page.openEditor((IEditorInput)new ValueEditorInput(value), Editor.EditorId);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    private void initGraph(ValueEditorInput input) {
        GraphBuilder builder = new GraphBuilder(this.graph);
        builder.computeGraph(input.getValue());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas(parent, 0);
        this.canvas.setLayout((Layout)new FillLayout());
        this.graph = new Graph((Composite)this.canvas, 0);
        this.graph.setLayoutAlgorithm((LayoutAlgorithm)new MyDirectedGraphLayout(1), false);
        this.graph.applyLayout();
        this.canvas.setVisible(true);
        this.canvas.pack();
        IEditorInput input = this.getEditorInput();
        if (input instanceof ValueEditorInput) {
            this.initGraph((ValueEditorInput)input);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }
}

