/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredAnnotationException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredConstructorException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AbstractDataType
extends Type {
    final String fName;
    final Type fParameters;

    AbstractDataType(String name, Type parameters) {
        this.fName = name;
        this.fParameters = parameters;
    }

    @Override
    public boolean isAbstractDataType() {
        return true;
    }

    @Override
    public boolean isNodeType() {
        return true;
    }

    @Override
    public boolean isParameterized() {
        return !this.fParameters.isVoidType();
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other == this || other.isValueType()) {
            return true;
        }
        if (other.isAbstractDataType() && other.getName().equals(this.getName())) {
            return this.fParameters.isSubtypeOf(other.getTypeParameters());
        }
        if (other.isAliasType()) {
            return this.isSubtypeOf(other.getAliased());
        }
        return TypeFactory.getInstance().nodeType().isSubtypeOf(other);
    }

    @Override
    public Type lub(Type other) {
        if (other == this || other.isVoidType()) {
            return this;
        }
        if (other.isAbstractDataType() && other.getName().equals(this.getName())) {
            return TypeFactory.getInstance().abstractDataTypeFromTuple(new TypeStore(new TypeStore[0]), this.getName(), this.fParameters.lub(other.getTypeParameters()));
        }
        if (other.isConstructorType() && other.getAbstractDataType().getName().equals(this.getName())) {
            return TypeFactory.getInstance().abstractDataTypeFromTuple(new TypeStore(new TypeStore[0]), this.getName(), this.fParameters.lub(other.getAbstractDataType().getTypeParameters()));
        }
        return TypeFactory.getInstance().nodeType().lub(other);
    }

    @Override
    public boolean hasField(String fieldName, TypeStore store) {
        Type parameterizedADT = store.lookupAbstractDataType(this.getName());
        for (Type alt : store.lookupAlternatives(parameterizedADT)) {
            if (!alt.isConstructorType() || !alt.hasField(fieldName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fName);
        if (!this.fParameters.isVoidType()) {
            sb.append("[");
            int idx = 0;
            for (Type elemType : this.fParameters) {
                if (idx++ > 0) {
                    sb.append(",");
                }
                sb.append(elemType.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 49991 + this.fParameters.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractDataType) {
            AbstractDataType other = (AbstractDataType)o;
            return this.fName.equals(other.fName) && this.fParameters == other.fParameters;
        }
        return false;
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        Type[] params = new Type[]{};
        if (this.isParameterized()) {
            params = new Type[this.fParameters.getArity()];
            int i = 0;
            for (Type p : this.fParameters) {
                params[i] = p.instantiate(store, bindings);
            }
        }
        return TypeFactory.getInstance().abstractDataType(store, this.fName, params);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Type getTypeParameters() {
        return this.fParameters;
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitAbstractData(this);
    }

    private IValue wrap(IValueFactory vf, TypeStore store, Type wrapped, IValue value) {
        for (Type alt : store.lookupAlternatives(this)) {
            if (alt.getArity() != 1 || !alt.getFieldType(0).isSubtypeOf(wrapped)) continue;
            return alt.make(vf, value);
        }
        throw new UndeclaredConstructorException(this, TypeFactory.getInstance().tupleType(wrapped));
    }

    @Override
    public IValue make(IValueFactory vf, TypeStore store, boolean arg) {
        Type wrapped = TypeFactory.getInstance().boolType();
        IValue value = wrapped.make(vf, arg);
        return this.wrap(vf, store, wrapped, value);
    }

    @Override
    public IValue make(IValueFactory vf, TypeStore store, int arg) {
        Type wrapped = TypeFactory.getInstance().integerType();
        IValue value = wrapped.make(vf, arg);
        return this.wrap(vf, store, wrapped, value);
    }

    @Override
    public IValue make(IValueFactory vf, TypeStore store, double arg) {
        Type wrapped = TypeFactory.getInstance().realType();
        IValue value = wrapped.make(vf, arg);
        return this.wrap(vf, store, wrapped, value);
    }

    @Override
    public IValue make(IValueFactory vf, TypeStore store, String arg) {
        Type wrapped = TypeFactory.getInstance().stringType();
        IValue value = wrapped.make(vf, arg);
        return this.wrap(vf, store, wrapped, value);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, IValue ... children) {
        Set<Type> possible = store.lookupAlternatives(this);
        Type childrenTypes = store.getFactory().tupleType(children);
        for (Type node : possible) {
            if (!childrenTypes.isSubtypeOf(node.getFieldTypes())) continue;
            return node.make(f, children);
        }
        throw new UndeclaredConstructorException(this, childrenTypes);
    }

    @Override
    public IValue make(IValueFactory f, TypeStore store, String name, IValue ... children) {
        Set<Type> possible = store.lookupConstructor(this, name);
        Type childrenTypes = store.getFactory().tupleType(children);
        for (Type node : possible) {
            if (!childrenTypes.isSubtypeOf(node.getFieldTypes())) continue;
            return node.make(f, children);
        }
        throw new UndeclaredConstructorException(this, childrenTypes);
    }

    @Override
    public boolean declaresAnnotation(TypeStore store, String label) {
        return store.getAnnotationType(this, label) != null;
    }

    @Override
    public Type getAnnotationType(TypeStore store, String label) throws FactTypeUseException {
        Type type = store.getAnnotationType(this, label);
        if (type == null) {
            throw new UndeclaredAnnotationException(this, label);
        }
        return type;
    }
}

