/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoolValue
implements IBool {
    private static final Type BOOL_TYPE = TypeFactory.getInstance().boolType();
    public static final BoolValue TRUE = new BoolValue(true);
    public static final BoolValue FALSE = new BoolValue(false);
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    protected final boolean value;

    protected BoolValue(boolean value) {
        this.value = value;
    }

    @Override
    public Type getType() {
        return BOOL_TYPE;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public IBool not() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public IBool equivalent(IBool other) {
        return this.value == other.getValue() ? TRUE : FALSE;
    }

    @Override
    public IBool and(IBool other) {
        return this.value ? other : FALSE;
    }

    @Override
    public IBool or(IBool other) {
        return this.value ? TRUE : other;
    }

    @Override
    public IBool xor(IBool other) {
        return this.value ^ other.getValue() ? TRUE : FALSE;
    }

    @Override
    public IBool implies(IBool other) {
        return this.value ? other : TRUE;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitBoolean(this);
    }

    public static BoolValue getBoolValue(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public boolean isEqual(IValue value) {
        return this == value;
    }

    @Override
    public String toString() {
        return this.value ? TRUE_STRING : FALSE_STRING;
    }

    @Override
    public String getStringRepresentation() {
        return this.toString();
    }
}

