/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple
implements ITuple {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    protected final Type tupleType;
    protected final IValue[] elements;

    protected Tuple(Type tupleType, IValue[] elements) {
        this.tupleType = tupleType;
        this.elements = elements;
    }

    @Override
    public Type getType() {
        return this.tupleType;
    }

    @Override
    public int arity() {
        return this.elements.length;
    }

    @Override
    public IValue get(int i) {
        return this.elements[i];
    }

    @Override
    public IValue get(String label) {
        return this.elements[this.tupleType.getFieldIndex(label)];
    }

    @Override
    public Iterator<IValue> iterator() {
        return new TupleIterator(this);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitTuple(this);
    }

    @Override
    public ITuple set(int index, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[index] = arg;
        elementTypes[index] = arg.getType();
        return new Tuple(typeFactory.tupleType(elementTypes), newElements);
    }

    @Override
    public ITuple set(String label, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[this.tupleType.getFieldIndex((String)label)] = arg;
        elementTypes[this.tupleType.getFieldIndex((String)label)] = arg.getType();
        return new Tuple(typeFactory.tupleType(elementTypes), newElements);
    }

    @Override
    public IValue select(int ... indexes) {
        if (indexes.length == 1) {
            return this.get(indexes[0]);
        }
        int nrOfElements = indexes.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(indexes[i]);
            elementTypes[i] = element.getType();
        }
        return new Tuple(typeFactory.tupleType(elementTypes), elements);
    }

    @Override
    public IValue select(String ... fields) {
        if (fields.length == 1) {
            return this.get(fields[0]);
        }
        int nrOfElements = fields.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(fields[i]);
            elementTypes[i] = element.getType();
        }
        return new Tuple(typeFactory.tupleType(elementTypes), elements);
    }

    public int hashCode() {
        int hash = this.tupleType.hashCode();
        for (int i = this.elements.length - 1; i >= 0; --i) {
            hash -= (hash << 19) + (hash >>> 8);
            hash ^= this.elements[i].hashCode();
        }
        return hash - (hash << 7);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Tuple otherTuple = (Tuple)o;
            if (this.tupleType != otherTuple.tupleType) {
                return false;
            }
            IValue[] otherElements = otherTuple.elements;
            int nrOfElements = this.elements.length;
            if (otherElements.length == nrOfElements) {
                for (int i = nrOfElements - 1; i >= 0; --i) {
                    if (((Object)otherElements[i]).equals(this.elements[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Tuple) {
            Tuple otherTuple = (Tuple)value;
            if (!this.tupleType.comparable(otherTuple.tupleType)) {
                return false;
            }
            IValue[] otherElements = otherTuple.elements;
            int nrOfElements = this.elements.length;
            if (otherElements.length == nrOfElements) {
                for (int i = nrOfElements - 1; i >= 0; --i) {
                    if (otherElements[i].isEqual(this.elements[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        int size = this.elements.length;
        if (size > 0) {
            int i = 0;
            sb.append(this.elements[i]);
            for (i = 1; i < size; ++i) {
                sb.append(",");
                sb.append(this.elements[i]);
            }
        }
        sb.append(">");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TupleIterator
    implements Iterator<IValue> {
        private final IValue[] elements;
        private int index = 0;

        public TupleIterator(Tuple tuple) {
            this.elements = tuple.elements;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public IValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in this iteration.");
            }
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

