/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io.binary;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.util.ResizingArray;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

public class BinaryReader {
    private static final int DEFAULT_SHARED_VALUES_STORE_SIZE = 1024;
    private static final int DEFAULT_SHARED_TYPES_STORE_SIZE = 128;
    private static final int DEFAULT_SHARED_PATHS_STORE_SIZE = 128;
    private static final int DEFAULT_SHARED_NAMES_STORE_SIZE = 128;
    private static final int BOOL_HEADER = 1;
    private static final int INTEGER_HEADER = 2;
    private static final int BIG_INTEGER_HEADER = 3;
    private static final int DOUBLE_HEADER = 4;
    private static final int STRING_HEADER = 5;
    private static final int SOURCE_LOCATION_HEADER = 6;
    private static final int TUPLE_HEADER = 7;
    private static final int NODE_HEADER = 8;
    private static final int ANNOTATED_NODE_HEADER = 9;
    private static final int CONSTRUCTOR_HEADER = 10;
    private static final int ANNOTATED_CONSTRUCTOR_HEADER = 11;
    private static final int LIST_HEADER = 12;
    private static final int SET_HEADER = 13;
    private static final int RELATION_HEADER = 14;
    private static final int MAP_HEADER = 15;
    private static final int VALUE_TYPE_HEADER = 1;
    private static final int VOID_TYPE_HEADER = 2;
    private static final int BOOL_TYPE_HEADER = 3;
    private static final int INTEGER_TYPE_HEADER = 4;
    private static final int DOUBLE_TYPE_HEADER = 5;
    private static final int STRING_TYPE_HEADER = 6;
    private static final int SOURCE_LOCATION_TYPE_HEADER = 7;
    private static final int NODE_TYPE_HEADER = 8;
    private static final int TUPLE_TYPE_HEADER = 9;
    private static final int LIST_TYPE_HEADER = 10;
    private static final int SET_TYPE_HEADER = 11;
    private static final int RELATION_TYPE_HEADER = 12;
    private static final int MAP_TYPE_HEADER = 13;
    private static final int PARAMETER_TYPE_HEADER = 14;
    private static final int ADT_TYPE_HEADER = 15;
    private static final int CONSTRUCTOR_TYPE_HEADER = 16;
    private static final int ALIAS_TYPE_HEADER = 17;
    private static final int ANNOTATED_NODE_TYPE_HEADER = 18;
    private static final int ANNOTATED_CONSTRUCTOR_TYPE_HEADER = 19;
    private static final int TYPE_MASK = 31;
    private static final int SHARED_FLAG = 128;
    private static final int TYPE_SHARED_FLAG = 64;
    private static final int URL_SHARED_FLAG = 32;
    private static final int NAME_SHARED_FLAG = 32;
    private static final int HAS_FIELD_NAMES = 32;
    private static final TypeFactory tf = TypeFactory.getInstance();
    private final ResizingArray<IValue> sharedValues;
    private int currentSharedValueId;
    private final ResizingArray<Type> sharedTypes;
    private int currentSharedTypeId;
    private final ResizingArray<String> sharedPaths;
    private int currentSharedPathId;
    private final ResizingArray<String> sharedNames;
    private int currentSharedNamesId;
    private final IValueFactory valueFactory;
    private final TypeStore typeStore;
    private final InputStream in;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;

    public BinaryReader(IValueFactory valueFactory, TypeStore typeStore, InputStream inputStream) {
        this.valueFactory = valueFactory;
        this.typeStore = typeStore;
        this.in = new InputStreamCheckerWrapper(inputStream);
        this.sharedValues = new ResizingArray(1024);
        this.currentSharedValueId = 0;
        this.sharedTypes = new ResizingArray(128);
        this.currentSharedTypeId = 0;
        this.sharedPaths = new ResizingArray(128);
        this.currentSharedPathId = 0;
        this.sharedNames = new ResizingArray(128);
        this.currentSharedNamesId = 0;
    }

    public IValue deserialize() throws IOException {
        IValue value;
        int header = this.in.read();
        if ((header & 0x80) == 128) {
            return this.sharedValues.get(this.parseInteger());
        }
        int valueType = header & 0x1F;
        switch (valueType) {
            case 1: {
                value = this.readBool();
                break;
            }
            case 2: {
                value = this.readInteger();
                break;
            }
            case 3: {
                value = this.readBigInteger();
                break;
            }
            case 4: {
                value = this.readDouble();
                break;
            }
            case 5: {
                value = this.readString();
                break;
            }
            case 6: {
                value = this.readSourceLocation(header);
                break;
            }
            case 7: {
                value = this.readTuple();
                break;
            }
            case 8: {
                value = this.readNode(header);
                break;
            }
            case 9: {
                value = this.readAnnotatedNode(header);
                break;
            }
            case 10: {
                value = this.readConstructor(header);
                break;
            }
            case 11: {
                value = this.readAnnotatedConstructor(header);
                break;
            }
            case 12: {
                value = this.readList(header);
                break;
            }
            case 13: {
                value = this.readSet(header);
                break;
            }
            case 14: {
                value = this.readRelation(header);
                break;
            }
            case 15: {
                value = this.readMap(header);
                break;
            }
            default: {
                throw new RuntimeException("Unknow value type: " + valueType);
            }
        }
        this.sharedValues.set(value, this.currentSharedValueId++);
        return value;
    }

    private Type readType(int header) throws IOException {
        if ((header & 0x40) == 64) {
            return this.sharedTypes.get(this.parseInteger());
        }
        return this.doReadType(this.in.read());
    }

    private Type doReadType() throws IOException {
        return this.doReadType(this.in.read());
    }

    private Type doReadType(int typeHeader) throws IOException {
        Type type;
        if ((typeHeader & 0x80) == 128) {
            return this.sharedTypes.get(this.parseInteger());
        }
        int typeType = typeHeader & 0x1F;
        switch (typeType) {
            case 1: {
                type = this.readValueType();
                break;
            }
            case 2: {
                type = this.readVoidType();
                break;
            }
            case 3: {
                type = this.readBoolType();
                break;
            }
            case 4: {
                type = this.readIntegerType();
                break;
            }
            case 5: {
                type = this.readDoubleType();
                break;
            }
            case 6: {
                type = this.readStringType();
                break;
            }
            case 7: {
                type = this.readSourceLocationType();
                break;
            }
            case 8: {
                type = this.readNodeType();
                break;
            }
            case 9: {
                type = this.readTupleType(typeHeader);
                break;
            }
            case 10: {
                type = this.readListType();
                break;
            }
            case 11: {
                type = this.readSetType();
                break;
            }
            case 12: {
                type = this.readRelationType();
                break;
            }
            case 13: {
                type = this.readMapType();
                break;
            }
            case 14: {
                type = this.readParameterType();
                break;
            }
            case 15: {
                type = this.readADTType();
                break;
            }
            case 16: {
                type = this.readConstructorType();
                break;
            }
            case 17: {
                type = this.readAliasType();
                break;
            }
            case 18: {
                type = this.readAnnotatedNodeType();
                break;
            }
            case 19: {
                type = this.readAnnotatedConstructorType();
                break;
            }
            default: {
                throw new RuntimeException("Unkown type type: " + typeType);
            }
        }
        this.sharedTypes.set(type, this.currentSharedTypeId++);
        return type;
    }

    private IBool readBool() throws IOException {
        int bool = this.in.read();
        return this.valueFactory.bool(bool != 0);
    }

    private IInteger readInteger() throws IOException {
        int integerValue = this.parseInteger();
        return this.valueFactory.integer(integerValue);
    }

    private IInteger readBigInteger() throws IOException {
        int length = this.parseInteger();
        byte[] integerData = new byte[length];
        this.in.read(integerData, 0, length);
        return this.valueFactory.integer(integerData);
    }

    private IReal readDouble() throws IOException {
        int length = this.parseInteger();
        byte[] unscaledValueData = new byte[length];
        this.in.read(unscaledValueData, 0, length);
        int scale = this.parseInteger();
        return this.valueFactory.real(new BigDecimal(new BigInteger(unscaledValueData), scale).toString());
    }

    private IString readString() throws IOException {
        int size = this.parseInteger();
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)this.in.read();
        }
        return this.valueFactory.string(new String(data));
    }

    private ISourceLocation readSourceLocation(int header) throws IOException {
        String path;
        if ((header & 0x20) == 32) {
            int path_id = this.parseInteger();
            path = this.sharedPaths.get(path_id);
        } else {
            int pathSize = this.parseInteger();
            byte[] data = new byte[pathSize];
            for (int i = 0; i < pathSize; ++i) {
                data[i] = (byte)this.in.read();
            }
            path = new String(data);
            this.sharedPaths.set(path, this.currentSharedPathId++);
        }
        URL url = new URL(path);
        int offset = this.parseInteger();
        int length = this.parseInteger();
        int beginLine = this.parseInteger();
        int endLine = this.parseInteger();
        int beginCol = this.parseInteger();
        int endCol = this.parseInteger();
        return this.valueFactory.sourceLocation(url, offset, length, beginLine, endLine, beginCol, endCol);
    }

    private ITuple readTuple() throws IOException {
        int arity = this.parseInteger();
        IValue[] content = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            content[i] = this.deserialize();
        }
        return this.valueFactory.tuple(content);
    }

    private INode readNode(int header) throws IOException {
        int i;
        String nodeName;
        if ((header & 0x20) == 32) {
            nodeName = this.sharedNames.get(this.parseInteger());
        } else {
            int nodeNameLength = this.parseInteger();
            byte[] data = new byte[nodeNameLength];
            for (i = 0; i < nodeNameLength; ++i) {
                data[i] = (byte)this.in.read();
            }
            nodeName = new String(data);
            this.sharedNames.set(nodeName, this.currentSharedNamesId++);
        }
        int arity = this.parseInteger();
        IValue[] content = new IValue[arity];
        for (i = 0; i < arity; ++i) {
            content[i] = this.deserialize();
        }
        return this.valueFactory.node(nodeName, content);
    }

    private INode readAnnotatedNode(int header) throws IOException {
        int i;
        String nodeName;
        if ((header & 0x20) == 32) {
            nodeName = this.sharedNames.get(this.parseInteger());
        } else {
            int nodeNameLength = this.parseInteger();
            byte[] data = new byte[nodeNameLength];
            for (i = 0; i < nodeNameLength; ++i) {
                data[i] = (byte)this.in.read();
            }
            nodeName = new String(data);
            this.sharedNames.set(nodeName, this.currentSharedNamesId++);
        }
        int arity = this.parseInteger();
        IValue[] content = new IValue[arity];
        for (i = 0; i < arity; ++i) {
            content[i] = this.deserialize();
        }
        int numberOfAnnotations = this.parseInteger();
        ShareableHashMap<String, IValue> annotations = new ShareableHashMap<String, IValue>();
        for (int i2 = numberOfAnnotations - 1; i2 >= 0; --i2) {
            int labelLength = this.parseInteger();
            byte[] labelData = new byte[labelLength];
            this.in.read(labelData);
            String label = new String(labelData);
            IValue value = this.deserialize();
            annotations.put(label, value);
        }
        INode node = this.valueFactory.node(nodeName, content);
        return node.setAnnotations(annotations);
    }

    private IConstructor readConstructor(int header) throws IOException {
        Type constructorType = this.readType(header);
        int arity = this.parseInteger();
        IValue[] content = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            content[i] = this.deserialize();
        }
        return this.valueFactory.constructor(constructorType, content);
    }

    private IConstructor readAnnotatedConstructor(int header) throws IOException {
        Type constructorType = this.readType(header);
        int arity = this.parseInteger();
        IValue[] content = new IValue[arity];
        for (int i = 0; i < arity; ++i) {
            content[i] = this.deserialize();
        }
        int numberOfAnnotations = this.parseInteger();
        ShareableHashMap<String, IValue> annotations = new ShareableHashMap<String, IValue>();
        for (int i = numberOfAnnotations - 1; i >= 0; --i) {
            int labelLength = this.parseInteger();
            byte[] labelData = new byte[labelLength];
            this.in.read(labelData);
            String label = new String(labelData);
            IValue value = this.deserialize();
            annotations.put(label, value);
        }
        IConstructor constructor = this.valueFactory.constructor(constructorType, content);
        return constructor.setAnnotations(annotations);
    }

    private IList readList(int header) throws IOException {
        Type elementType = this.readType(header);
        int length = this.parseInteger();
        IListWriter listWriter = this.valueFactory.listWriter(elementType);
        for (int i = 0; i < length; ++i) {
            listWriter.append(this.deserialize());
        }
        return listWriter.done();
    }

    private ISet readSet(int header) throws IOException {
        Type elementType = this.readType(header);
        int length = this.parseInteger();
        ISetWriter setWriter = this.valueFactory.setWriter(elementType);
        for (int i = 0; i < length; ++i) {
            setWriter.insert(this.deserialize());
        }
        return setWriter.done();
    }

    private IRelation readRelation(int header) throws IOException {
        Type elementType = this.readType(header);
        int length = this.parseInteger();
        IRelationWriter relationWriter = this.valueFactory.relationWriter(elementType);
        for (int i = 0; i < length; ++i) {
            relationWriter.insert(this.deserialize());
        }
        return relationWriter.done();
    }

    private IMap readMap(int header) throws IOException {
        Type mapType = this.readType(header);
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        int length = this.parseInteger();
        IMapWriter mapWriter = this.valueFactory.mapWriter(keyType, valueType);
        for (int i = 0; i < length; ++i) {
            IValue key = this.deserialize();
            IValue value = this.deserialize();
            mapWriter.put(key, value);
        }
        return mapWriter.done();
    }

    private Type readValueType() {
        return tf.valueType();
    }

    private Type readVoidType() {
        return tf.voidType();
    }

    private Type readBoolType() {
        return tf.boolType();
    }

    private Type readIntegerType() {
        return tf.integerType();
    }

    private Type readDoubleType() {
        return tf.realType();
    }

    private Type readStringType() {
        return tf.stringType();
    }

    private Type readSourceLocationType() {
        return tf.sourceLocationType();
    }

    private Type readNodeType() {
        return tf.nodeType();
    }

    private Type readAnnotatedNodeType() throws IOException {
        Type nodeType = tf.nodeType();
        int nrOfAnnotations = this.parseInteger();
        --nrOfAnnotations;
        while (nrOfAnnotations >= 0) {
            int nrOfLabelBytes = this.parseInteger();
            byte[] labelBytes = new byte[nrOfLabelBytes];
            this.in.read(labelBytes);
            String label = new String(labelBytes);
            Type valueType = this.doReadType();
            this.typeStore.declareAnnotation(nodeType, label, valueType);
            --nrOfAnnotations;
        }
        return nodeType;
    }

    private Type readTupleType(int header) throws IOException {
        boolean hasFieldNames;
        boolean bl = hasFieldNames = (header & 0x20) == 32;
        if (hasFieldNames) {
            int arity = this.parseInteger();
            Type[] fields = new Type[arity];
            String[] fieldNames = new String[arity];
            for (int i = 0; i < arity; ++i) {
                fields[i] = this.doReadType();
                int fieldNameLength = this.parseInteger();
                byte[] fieldNameData = new byte[fieldNameLength];
                this.in.read(fieldNameData);
                fieldNames[i] = new String(fieldNameData);
            }
            return tf.tupleType(fields, fieldNames);
        }
        int arity = this.parseInteger();
        Type[] fields = new Type[arity];
        for (int i = 0; i < arity; ++i) {
            fields[i] = this.doReadType();
        }
        return tf.tupleType(fields);
    }

    private Type readListType() throws IOException {
        Type elementType = this.doReadType();
        return tf.listType(elementType);
    }

    private Type readSetType() throws IOException {
        Type elementType = this.doReadType();
        return tf.setType(elementType);
    }

    private Type readRelationType() throws IOException {
        Type elementType = this.doReadType();
        return tf.relTypeFromTuple(elementType);
    }

    private Type readMapType() throws IOException {
        Type keyType = this.doReadType();
        Type valueType = this.doReadType();
        return tf.mapType(keyType, valueType);
    }

    private Type readParameterType() throws IOException {
        int nameLength = this.parseInteger();
        byte[] nameData = new byte[nameLength];
        this.in.read(nameData);
        String name = new String(nameData);
        Type bound = this.doReadType();
        return tf.parameterType(name, bound);
    }

    private Type readADTType() throws IOException {
        int nameLength = this.parseInteger();
        byte[] nameData = new byte[nameLength];
        this.in.read(nameData);
        String name = new String(nameData);
        Type parameters = this.doReadType();
        return tf.abstractDataTypeFromTuple(this.typeStore, name, parameters);
    }

    private Type readConstructorType() throws IOException {
        int nameLength = this.parseInteger();
        byte[] nameData = new byte[nameLength];
        this.in.read(nameData);
        String name = new String(nameData);
        Type fieldTypes = this.doReadType();
        Type adtType = this.doReadType();
        return tf.constructorFromTuple(this.typeStore, adtType, name, fieldTypes);
    }

    private Type readAnnotatedConstructorType() throws IOException {
        int nameLength = this.parseInteger();
        byte[] nameData = new byte[nameLength];
        this.in.read(nameData);
        String name = new String(nameData);
        Type fieldTypes = this.doReadType();
        Type adtType = this.doReadType();
        Type constructorType = tf.constructorFromTuple(this.typeStore, adtType, name, fieldTypes);
        int nrOfAnnotations = this.parseInteger();
        --nrOfAnnotations;
        while (nrOfAnnotations >= 0) {
            int nrOfLabelBytes = this.parseInteger();
            byte[] labelBytes = new byte[nrOfLabelBytes];
            this.in.read(labelBytes);
            String label = new String(labelBytes);
            Type valueType = this.doReadType();
            this.typeStore.declareAnnotation(constructorType, label, valueType);
            --nrOfAnnotations;
        }
        return constructorType;
    }

    private Type readAliasType() throws IOException {
        int nameLength = this.parseInteger();
        byte[] nameData = new byte[nameLength];
        this.in.read(nameData);
        String name = new String(nameData);
        Type aliasedType = this.doReadType();
        Type parameters = this.doReadType();
        return tf.aliasType(this.typeStore, name, aliasedType, parameters);
    }

    private int parseInteger() throws IOException {
        int part = this.in.read();
        int result = part & 0x7F;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.in.read();
        result |= (part & 0x7F) << 7;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.in.read();
        result |= (part & 0x7F) << 14;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.in.read();
        result |= (part & 0x7F) << 21;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.in.read();
        return result |= (part & 0x7F) << 28;
    }

    private static class InputStreamCheckerWrapper
    extends InputStream {
        private final InputStream backingStream;

        public InputStreamCheckerWrapper(InputStream backingStream) {
            this.backingStream = backingStream;
        }

        public int read() throws IOException {
            int b = this.backingStream.read();
            if (b == -1) {
                throw new IOException("Encountered premature EOF.");
            }
            return b;
        }
    }
}

