/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Map;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Node;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedNode
extends Node {
    protected final ShareableHashMap<String, IValue> annotations;

    protected AnnotatedNode(String name, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        super(name, children);
        this.annotations = annotations;
    }

    @Override
    public INode set(int i, IValue arg) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = arg;
        return new AnnotatedNode(this.name, newChildren, this.annotations);
    }

    @Override
    public boolean hasAnnotation(String label) {
        return this.annotations.containsKey(label);
    }

    @Override
    public boolean hasAnnotations() {
        return true;
    }

    @Override
    public IValue getAnnotation(String label) {
        return this.annotations.get(label);
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return new ShareableHashMap<String, IValue>(this.annotations);
    }

    @Override
    public INode removeAnnotations() {
        return new Node(this.name, this.children);
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.put(label, value);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.remove(label);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            AnnotatedNode other = (AnnotatedNode)o;
            if (this.name != other.name) {
                return false;
            }
            IValue[] otherChildren = other.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (((Object)otherChildren[i]).equals(this.children[i])) continue;
                    return false;
                }
                return this.annotations.equals(other.annotations);
            }
        }
        return false;
    }
}

