/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.UndeclaredFieldException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapType
extends Type {
    private final Type fKeyType;
    private final Type fValueType;
    private final String fKeyLabel;
    private final String fValueLabel;

    MapType(Type keyType, Type valueType) {
        this.fKeyType = keyType;
        this.fValueType = valueType;
        this.fKeyLabel = null;
        this.fValueLabel = null;
    }

    MapType(Type keyType, String keyLabel, Type valueType, String valueLabel) {
        this.fKeyType = keyType;
        this.fValueType = valueType;
        this.fKeyLabel = keyLabel;
        this.fValueLabel = valueLabel;
    }

    @Override
    public Type getKeyType() {
        return this.fKeyType;
    }

    @Override
    public String getKeyLabel() {
        return this.fKeyLabel;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public String getValueLabel() {
        return this.fValueLabel;
    }

    @Override
    public Type getValueType() {
        return this.fValueType;
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fKeyLabel != null && this.fValueLabel != null;
    }

    @Override
    public Type getFieldType(String fieldName) throws FactTypeUseException {
        if (this.fKeyLabel.equals(fieldName)) {
            return this.fKeyType;
        }
        if (this.fValueLabel.equals(fieldName)) {
            return this.fValueType;
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        if (fieldName.equals(this.fKeyLabel)) {
            return true;
        }
        return fieldName.equals(this.fValueLabel);
    }

    @Override
    public Type getFieldType(int i) {
        switch (i) {
            case 0: {
                return this.fKeyType;
            }
            case 1: {
                return this.fValueType;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String getFieldName(int i) {
        switch (i) {
            case 0: {
                return this.fKeyLabel;
            }
            case 1: {
                return this.fValueLabel;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Type select(int ... fields) {
        return TypeFactory.getInstance().setType(this.getFieldTypes().select(fields));
    }

    @Override
    public Type select(String ... names) {
        return TypeFactory.getInstance().setType(this.getFieldTypes().select(names));
    }

    @Override
    public int getFieldIndex(String fieldName) {
        if (this.fKeyLabel.equals(fieldName)) {
            return 0;
        }
        if (this.fValueLabel.equals(fieldName)) {
            return 1;
        }
        throw new UndeclaredFieldException(this, fieldName);
    }

    @Override
    public Type getFieldTypes() {
        if (this.hasFieldNames()) {
            return TypeFactory.getInstance().tupleType(this.fKeyType, this.fKeyLabel, this.fValueType, this.fValueLabel);
        }
        return TypeFactory.getInstance().tupleType(this.fKeyType, this.fValueType);
    }

    @Override
    public boolean isSubtypeOf(Type o) {
        if (o.isMapType()) {
            return this.fKeyType.isSubtypeOf(o.getKeyType()) && this.fValueType.isSubtypeOf(o.getValueType());
        }
        return super.isSubtypeOf(o);
    }

    @Override
    public Type lub(Type o) {
        if (o.isMapType()) {
            return TypeFactory.getInstance().mapTypeFromTuple(this.getFieldTypes().lub(o.getFieldTypes()));
        }
        return super.lub(o);
    }

    @Override
    public Type carrier() {
        TypeFactory tf = TypeFactory.getInstance();
        return tf.setType(this.fKeyType.lub(this.fValueType));
    }

    public int hashCode() {
        return 56509 + 3511 * this.fKeyType.hashCode() + 1171 * this.fValueType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MapType)) {
            return false;
        }
        MapType other = (MapType)obj;
        if (this.fKeyLabel != null && !this.fKeyLabel.equals(other.fKeyLabel)) {
            return false;
        }
        if (this.fValueLabel != null && !this.fValueLabel.equals(other.fValueLabel)) {
            return false;
        }
        return this.fKeyType == other.fKeyType && this.fValueType == other.fValueType;
    }

    public String toString() {
        return "map[" + this.fKeyType + (this.fKeyLabel != null ? " " + this.fKeyLabel : "") + ", " + this.fValueType + (this.fValueLabel != null ? " " + this.fValueLabel : "") + "]";
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitMap(this);
    }

    @Override
    public IMap make(IValueFactory f) {
        return f.map(this.fKeyType, this.fValueType);
    }

    public IMapWriter writer(IValueFactory f) {
        return f.mapWriter(this.fKeyType, this.fValueType);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.getKeyType().match(matched.getKeyType(), bindings);
        this.getValueType().match(matched.getValueType(), bindings);
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        return TypeFactory.getInstance().mapType(this.getKeyType().instantiate(store, bindings), this.getValueType().instantiate(store, bindings));
    }
}

