/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.ICanBecomeABigInteger;
import org.eclipse.imp.pdb.facts.impl.fast.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.impl.fast.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigIntegerValue
extends Value
implements IInteger,
ICanBecomeABigInteger {
    private static final Type INTEGER_TYPE = TypeFactory.getInstance().integerType();
    protected final BigInteger value;

    public BigIntegerValue(BigInteger value) {
        this.value = value;
    }

    @Override
    public Type getType() {
        return INTEGER_TYPE;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public IReal toReal() {
        return ValueFactory.getInstance().real(new BigDecimal(this.value));
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        return this.value.toByteArray();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.value;
    }

    @Override
    public IInteger add(IInteger other) {
        BigInteger result = this.value.add(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 32 && (length < 32 || result.compareTo(BigInteger.ZERO) != -1)) {
            return ValueFactory.getInstance().integer(result.intValue());
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger subtract(IInteger other) {
        BigInteger result = this.value.subtract(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 32 && (length < 32 || result.compareTo(BigInteger.ZERO) != -1)) {
            return ValueFactory.getInstance().integer(result.intValue());
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger multiply(IInteger other) {
        BigInteger result = this.value.multiply(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger divide(IInteger other) {
        BigInteger result = this.value.divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 32 && (length < 32 || result.compareTo(BigInteger.ZERO) != -1)) {
            return ValueFactory.getInstance().integer(result.intValue());
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger mod(IInteger other) {
        BigInteger result = this.value.mod(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return ValueFactory.getInstance().integer(integerResult);
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger remainder(IInteger other) {
        BigInteger result = this.value.remainder(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return ValueFactory.getInstance().integer(integerResult);
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger negate() {
        return ValueFactory.getInstance().integer(this.value.negate());
    }

    @Override
    public IBool greater(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    @Override
    public IBool less(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    @Override
    public int compare(IInteger other) {
        return this.value.compareTo(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitInteger(this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            BigIntegerValue otherInteger = (BigIntegerValue)o;
            return this.value.equals(otherInteger.value);
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue other) {
        return this.equals(other);
    }

    @Override
    public String getStringRepresentation() {
        return this.value.toString();
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public IInteger abs() {
        return new BigIntegerValue(this.value.abs());
    }
}

