/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.impl.shared.SharedRelationWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedSet;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesList;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.util.RotatingQueue;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

public class SharedRelation
extends SharedSet
implements IShareable,
IRelation {
    protected SharedRelation(Type tupleType, ShareableValuesHashSet data) {
        super(typeFactory.relTypeFromTuple(tupleType), tupleType, data);
    }

    public Type getFieldTypes() {
        return this.elementType;
    }

    public int arity() {
        return this.elementType.getArity();
    }

    public ISet insert(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.add(value);
        Type type = this.elementType.lub(value.getType());
        return SharedRelation.createSetWriter(type, newData).done();
    }

    public IRelation delete(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.remove(value);
        return new SharedRelationWriter(this.elementType, newData).done();
    }

    public IRelation subtract(ISet set) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Iterator setIterator = set.iterator();
        while (setIterator.hasNext()) {
            newData.remove(setIterator.next());
        }
        return new SharedRelationWriter(this.elementType, newData).done();
    }

    public ISet union(ISet set) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Iterator setIterator = set.iterator();
        while (setIterator.hasNext()) {
            newData.add((IValue)setIterator.next());
        }
        Type type = this.elementType.lub(set.getElementType());
        return SharedRelation.createSetWriter(type, newData).done();
    }

    private ShareableValuesHashSet computeCarrier() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            Iterator tupleIterator = tuple.iterator();
            while (tupleIterator.hasNext()) {
                newData.add((IValue)tupleIterator.next());
            }
        }
        return newData;
    }

    public ISet carrier() {
        ShareableValuesHashSet newData = this.computeCarrier();
        Type type = this.determainMostGenericTypeInTuple();
        return SharedRelation.createSetWriter(type, newData).done();
    }

    public ISet domain() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.get(0));
        }
        Type type = this.elementType.getFieldType(0);
        return SharedRelation.createSetWriter(type, newData).done();
    }

    public ISet range() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        int last = this.elementType.getArity() - 1;
        for (ITuple tuple : this.data) {
            newData.add(tuple.get(last));
        }
        Type type = this.elementType.getFieldType(last);
        return SharedRelation.createSetWriter(type, newData).done();
    }

    public IRelation compose(IRelation other) {
        SharedValueFactory valueFactory = SharedValueFactory.getInstance();
        Type otherTupleType = other.getFieldTypes();
        if (this.elementType == voidType) {
            return this;
        }
        if (otherTupleType == voidType) {
            return other;
        }
        if (this.elementType.getArity() != 2 || otherTupleType.getArity() != 2) {
            throw new IllegalOperationException("compose", this.elementType, otherTupleType);
        }
        if (!this.elementType.getFieldType(1).comparable(otherTupleType.getFieldType(0))) {
            throw new IllegalOperationException("compose", this.elementType, otherTupleType);
        }
        ShareableHashMap<IValue, ShareableValuesList> rightSides = new ShareableHashMap<IValue, ShareableValuesList>();
        for (ITuple tuple : other) {
            IValue key = tuple.get(0);
            ShareableValuesList values = (ShareableValuesList)rightSides.get(key);
            if (values == null) {
                values = new ShareableValuesList();
                rightSides.put(key, values);
            }
            values.append(tuple.get(1));
        }
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        Type[] newTupleFieldTypes = new Type[]{this.elementType.getFieldType(0), otherTupleType.getFieldType(1)};
        Type tupleType = typeFactory.tupleType(newTupleFieldTypes);
        for (ITuple thisTuple : this.data) {
            IValue key = thisTuple.get(1);
            ShareableValuesList values = (ShareableValuesList)rightSides.get(key);
            if (values == null) continue;
            Iterator valuesIterator = values.iterator();
            do {
                IValue value = (IValue)valuesIterator.next();
                IValue[] newTupleData = new IValue[]{thisTuple.get(0), value};
                newData.add(valueFactory.createTupleUnsafe(tupleType, newTupleData));
            } while (valuesIterator.hasNext());
        }
        return new SharedRelationWriter(tupleType, newData).done();
    }

    private ShareableValuesHashSet computeClosure(Type tupleType, SharedValueFactory sharedValueFactory) {
        ShareableValuesHashSet allData = new ShareableValuesHashSet(this.data);
        RotatingQueue<IValue> iLeftKeys = new RotatingQueue<IValue>();
        RotatingQueue iLefts = new RotatingQueue();
        ShareableHashMap interestingLeftSides = new ShareableHashMap();
        ShareableHashMap<IValue, ShareableValuesHashSet> potentialRightSides = new ShareableHashMap<IValue, ShareableValuesHashSet>();
        for (ITuple tuple : allData) {
            ShareableValuesHashSet rightValues;
            IValue key = tuple.get(0);
            IValue value = tuple.get(1);
            RotatingQueue<IValue> leftValues = (RotatingQueue<IValue>)interestingLeftSides.get(key);
            if (leftValues != null) {
                rightValues = (ShareableValuesHashSet)potentialRightSides.get(key);
            } else {
                leftValues = new RotatingQueue<IValue>();
                iLeftKeys.put(key);
                iLefts.put(leftValues);
                interestingLeftSides.put(key, leftValues);
                rightValues = new ShareableValuesHashSet();
                potentialRightSides.put(key, rightValues);
            }
            leftValues.put(value);
            rightValues.add(value);
        }
        interestingLeftSides = null;
        int size = potentialRightSides.size();
        int nextSize = 0;
        do {
            ShareableHashMap<IValue, ShareableValuesHashSet> rightSides = potentialRightSides;
            potentialRightSides = new ShareableHashMap();
            while (size > 0) {
                IValue rightKey;
                IValue leftKey = (IValue)iLeftKeys.get();
                RotatingQueue leftValues = (RotatingQueue)iLefts.get();
                RotatingQueue<IValue> interestingLeftValues = null;
                while ((rightKey = (IValue)leftValues.get()) != null) {
                    ShareableValuesHashSet rightValues = (ShareableValuesHashSet)rightSides.get(rightKey);
                    if (rightValues == null) continue;
                    for (IValue rightValue : rightValues) {
                        if (!allData.add(sharedValueFactory.createTupleUnsafe(tupleType, new IValue[]{leftKey, rightValue}))) continue;
                        if (interestingLeftValues == null) {
                            ++nextSize;
                            iLeftKeys.put(leftKey);
                            interestingLeftValues = new RotatingQueue<IValue>();
                            iLefts.put(interestingLeftValues);
                        }
                        interestingLeftValues.put(rightValue);
                        ShareableValuesHashSet potentialRightValues = (ShareableValuesHashSet)potentialRightSides.get(rightKey);
                        if (potentialRightValues == null) {
                            potentialRightValues = new ShareableValuesHashSet();
                            potentialRightSides.put(rightKey, potentialRightValues);
                        }
                        potentialRightValues.add(rightValue);
                    }
                }
                --size;
            }
            size = nextSize;
            nextSize = 0;
        } while (size > 0);
        return allData;
    }

    public IRelation closure() {
        SharedValueFactory sharedValueFactory = SharedValueFactory.getInstance();
        if (this.elementType == voidType) {
            return this;
        }
        if (!this.isReflexive()) {
            throw new IllegalOperationException("closure", this.setType);
        }
        Type tupleElementType = this.elementType.getFieldType(0).lub(this.elementType.getFieldType(1));
        Type tupleType = typeFactory.tupleType(tupleElementType, tupleElementType);
        return new SharedRelationWriter(this.elementType, this.computeClosure(tupleType, sharedValueFactory)).done();
    }

    public IRelation closureStar() {
        SharedValueFactory sharedValueFactory = SharedValueFactory.getInstance();
        if (this.elementType == voidType) {
            return this;
        }
        if (!this.isReflexive()) {
            throw new IllegalOperationException("closureStar", this.setType);
        }
        Type tupleElementType = this.elementType.getFieldType(0).lub(this.elementType.getFieldType(1));
        Type tupleType = typeFactory.tupleType(tupleElementType, tupleElementType);
        ShareableValuesHashSet closure = this.computeClosure(tupleType, sharedValueFactory);
        ShareableValuesHashSet carrier = this.computeCarrier();
        for (IValue element : carrier) {
            closure.add(sharedValueFactory.createTupleUnsafe(tupleType, new IValue[]{element, element}));
        }
        return new SharedRelationWriter(this.elementType, closure).done();
    }

    public ISet select(int ... indexes) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.select(indexes));
        }
        return SharedRelation.createSetWriter(this.getFieldTypes().select(indexes), newData).done();
    }

    public ISet select(String ... fields) {
        if (!this.elementType.hasFieldNames()) {
            throw new IllegalOperationException("select with field names", this.setType);
        }
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.select(fields));
        }
        return SharedRelation.createSetWriter(this.getFieldTypes().select(fields), newData).done();
    }

    private Type determainMostGenericTypeInTuple() {
        Type result = this.elementType.getFieldType(0);
        for (int i = this.elementType.getArity() - 1; i > 0; --i) {
            result = result.lub(this.elementType.getFieldType(i));
        }
        return result;
    }

    private boolean isReflexive() {
        if (this.elementType.getArity() != 2) {
            throw new RuntimeException("Tuple is not binary");
        }
        Type left = this.elementType.getFieldType(0);
        Type right = this.elementType.getFieldType(1);
        return right.comparable(left);
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

