/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Tuple;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.type.Type;

public class SharedTuple
extends Tuple
implements IShareable {
    protected SharedTuple(Type tupleType, IValue[] elements) {
        super(tupleType, elements);
    }

    public ITuple set(int index, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[index] = arg;
        elementTypes[index] = arg.getType();
        return SharedValueFactory.getInstance().createTupleUnsafe(typeFactory.tupleType(elementTypes), newElements);
    }

    public ITuple set(String label, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[this.tupleType.getFieldIndex((String)label)] = arg;
        elementTypes[this.tupleType.getFieldIndex((String)label)] = arg.getType();
        return SharedValueFactory.getInstance().createTupleUnsafe(typeFactory.tupleType(elementTypes), newElements);
    }

    public IValue select(int ... indexes) {
        if (indexes.length == 1) {
            return this.get(indexes[0]);
        }
        int nrOfElements = indexes.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(indexes[i]);
            elementTypes[i] = element.getType();
        }
        return SharedValueFactory.getInstance().createTupleUnsafe(typeFactory.tupleType(elementTypes), elements);
    }

    public IValue select(String ... fields) {
        if (fields.length == 1) {
            return this.get(fields[0]);
        }
        int nrOfElements = fields.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(fields[i]);
            elementTypes[i] = element.getType();
        }
        return SharedValueFactory.getInstance().createTupleUnsafe(typeFactory.tupleType(elementTypes), elements);
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

