/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.fast.BoolValue;
import org.eclipse.imp.pdb.facts.impl.fast.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedAnnotatedConstructor;
import org.eclipse.imp.pdb.facts.impl.shared.SharedAnnotatedNode;
import org.eclipse.imp.pdb.facts.impl.shared.SharedBigDecimalValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedBigIntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedConstructor;
import org.eclipse.imp.pdb.facts.impl.shared.SharedIntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedList;
import org.eclipse.imp.pdb.facts.impl.shared.SharedListWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedMap;
import org.eclipse.imp.pdb.facts.impl.shared.SharedMapWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedNode;
import org.eclipse.imp.pdb.facts.impl.shared.SharedRelation;
import org.eclipse.imp.pdb.facts.impl.shared.SharedRelationWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedSet;
import org.eclipse.imp.pdb.facts.impl.shared.SharedSetWriter;
import org.eclipse.imp.pdb.facts.impl.shared.SharedSourceLocationValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedStringValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedTuple;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IndexedCache;
import org.eclipse.imp.pdb.facts.impl.util.sharing.ShareableValuesFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharedValueFactory
implements IValueFactory {
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final Type EMPTY_TUPLE_TYPE = TypeFactory.getInstance().tupleEmpty();
    private static final String INTEGER_MAX_STRING = "2147483647";
    private static final String NEGATIVE_INTEGER_MAX_STRING = "-2147483648";
    private static final int CACHED_POSITIVE_INTEGERS_RANGE = 256;
    private static final int CACHED_NEGATIVE_INTEGERS_RANGE = -256;
    private final IndexedCache<IntegerValue> positiveIntegersCache = new IndexedCache(256);
    private final IndexedCache<IntegerValue> negativeIntegersCache = new IndexedCache(256);
    private final ShareableValuesFactory<IShareable> sharedValuesFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedList> sharedListsFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedMap> sharedMapsFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedSet> sharedSetsFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedRelation> sharedRelationsFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedTuple> sharedTuplesFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedNode> sharedNodesFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedAnnotatedNode> sharedAnnotatedNodesFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedConstructor> sharedConstructorsFactory = new ShareableValuesFactory();
    private final ShareableValuesFactory<SharedAnnotatedConstructor> sharedAnnotatedConstrutorsFactory = new ShareableValuesFactory();

    private SharedValueFactory() {
    }

    public static SharedValueFactory getInstance() {
        return InstanceKeeper.instance;
    }

    protected IShareable buildValue(IShareable shareable) {
        return this.sharedValuesFactory.build(shareable);
    }

    protected SharedList buildList(SharedList sharedList) {
        return this.sharedListsFactory.build(sharedList);
    }

    protected SharedMap buildMap(SharedMap sharedMap) {
        return this.sharedMapsFactory.build(sharedMap);
    }

    protected SharedSet buildSet(SharedSet sharedSet) {
        return this.sharedSetsFactory.build(sharedSet);
    }

    protected SharedRelation buildRelation(SharedRelation sharedRelation) {
        return this.sharedRelationsFactory.build(sharedRelation);
    }

    protected SharedTuple buildTuple(SharedTuple sharedTuple) {
        return this.sharedTuplesFactory.build(sharedTuple);
    }

    protected SharedNode buildNode(SharedNode sharedNode) {
        return this.sharedNodesFactory.build(sharedNode);
    }

    protected SharedAnnotatedNode buildAnnotatedNode(SharedAnnotatedNode sharedAnnotatedNode) {
        return this.sharedAnnotatedNodesFactory.build(sharedAnnotatedNode);
    }

    protected SharedConstructor buildConstructor(SharedConstructor sharedConstructor) {
        return this.sharedConstructorsFactory.build(sharedConstructor);
    }

    protected SharedAnnotatedConstructor buildAnnotatedConstructor(SharedAnnotatedConstructor sharedAnnotatedConstructor) {
        return this.sharedAnnotatedConstrutorsFactory.build(sharedAnnotatedConstructor);
    }

    @Override
    public IBool bool(boolean value) {
        return BoolValue.getBoolValue(value);
    }

    @Override
    public IInteger integer(int value) {
        if (value >= 0) {
            if (value < 256) {
                IInteger cachedValue = this.positiveIntegersCache.get(value);
                if (cachedValue != null) {
                    return cachedValue;
                }
                return this.positiveIntegersCache.getOrDefine(value, new SharedIntegerValue(value));
            }
        } else if (value >= -256) {
            int location = value - -256;
            IInteger cachedValue = this.negativeIntegersCache.get(location);
            if (cachedValue != null) {
                return cachedValue;
            }
            return this.negativeIntegersCache.getOrDefine(location, new SharedIntegerValue(value));
        }
        return (IInteger)((Object)this.buildValue(new SharedIntegerValue(value)));
    }

    @Override
    public IInteger integer(String integerValue) {
        if (integerValue.startsWith("-")) {
            if (integerValue.length() < 11 || integerValue.length() == 11 && integerValue.compareTo(NEGATIVE_INTEGER_MAX_STRING) <= 0) {
                return this.integer(Integer.parseInt(integerValue));
            }
            return this.integer(new BigInteger(integerValue));
        }
        if (integerValue.length() < 10 || integerValue.length() == 10 && integerValue.compareTo(INTEGER_MAX_STRING) <= 0) {
            return this.integer(Integer.parseInt(integerValue));
        }
        return this.integer(new BigInteger(integerValue));
    }

    @Override
    public IInteger integer(byte[] integerData) {
        if (integerData.length <= 4) {
            int value = 0;
            int i = integerData.length - 1;
            int j = 0;
            while (i >= 0) {
                value |= (integerData[i] & 0xFF) << j * 8;
                --i;
                ++j;
            }
            return this.integer(value);
        }
        return this.integer(new BigInteger(integerData));
    }

    public IInteger integer(BigInteger bigInteger) {
        return (IInteger)((Object)this.buildValue(new SharedBigIntegerValue(bigInteger)));
    }

    @Override
    public IReal real(double value) {
        return (IReal)((Object)this.buildValue(new SharedBigDecimalValue(BigDecimal.valueOf(value))));
    }

    @Override
    public IReal real(String doubleValue) {
        return (IReal)((Object)this.buildValue(new SharedBigDecimalValue(new BigDecimal(doubleValue))));
    }

    public IReal real(BigDecimal value) {
        return (IReal)((Object)this.buildValue(new SharedBigDecimalValue(value)));
    }

    @Override
    public IString string(String value) {
        return (IString)((Object)this.buildValue(new SharedStringValue(value)));
    }

    @Override
    public ISourceLocation sourceLocation(URI uri, int startOffset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        return (ISourceLocation)((Object)this.buildValue(new SharedSourceLocationValue(uri, startOffset, length, beginLine, endLine, beginCol, endCol)));
    }

    @Override
    public ISourceLocation sourceLocation(String path, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        try {
            return this.sourceLocation(new URI("file://" + path), offset, length, beginLine, endLine, beginCol, endCol);
        }
        catch (URISyntaxException e) {
            throw new FactParseError("Illegal path syntax.", e);
        }
    }

    @Override
    public ISourceLocation sourceLocation(URI uri) {
        return this.sourceLocation(uri, -1, -1, -1, -1, -1, -1);
    }

    @Override
    public ISourceLocation sourceLocation(String path) {
        return this.sourceLocation(path, -1, -1, -1, -1, -1, -1);
    }

    @Override
    public IListWriter listWriter(Type elementType) {
        return new SharedListWriter(elementType);
    }

    @Override
    public IMapWriter mapWriter(Type keyType, Type valueType) {
        return new SharedMapWriter(keyType, valueType);
    }

    @Override
    public ISetWriter setWriter(Type elementType) {
        if (elementType.isTupleType()) {
            return this.relationWriter(elementType);
        }
        return new SharedSetWriter(elementType);
    }

    @Override
    public IRelationWriter relationWriter(Type tupleType) {
        return new SharedRelationWriter(tupleType);
    }

    @Override
    public IList list(Type elementType) {
        return this.listWriter(elementType).done();
    }

    @Override
    public IList list(IValue ... elements) {
        IListWriter listWriter = this.listWriter(SharedValueFactory.lub(elements));
        listWriter.append(elements);
        return listWriter.done();
    }

    @Override
    public IMap map(Type keyType, Type valueType) {
        return this.mapWriter(keyType, valueType).done();
    }

    @Override
    public ISet set(Type elementType) {
        return this.setWriter(elementType).done();
    }

    @Override
    public ISet set(IValue ... elements) {
        Type elementType = SharedValueFactory.lub(elements);
        ISetWriter setWriter = this.setWriter(elementType);
        setWriter.insert(elements);
        return setWriter.done();
    }

    @Override
    public IRelation relation(Type tupleType) {
        return this.relationWriter(tupleType).done();
    }

    @Override
    public IRelation relation(IValue ... elements) {
        Type elementType = SharedValueFactory.lub(elements);
        if (!elementType.isTupleType()) {
            throw new UnexpectedElementTypeException(tf.tupleType(tf.voidType()), elementType);
        }
        IRelationWriter relationWriter = this.relationWriter(elementType);
        relationWriter.insert(elements);
        return relationWriter.done();
    }

    @Override
    public INode node(String name) {
        return this.buildNode(new SharedNode(name, new IValue[0]));
    }

    @Override
    public INode node(String name, IValue ... children) {
        return this.buildNode(new SharedNode(name, (IValue[])children.clone()));
    }

    protected INode createNodeUnsafe(String name, IValue[] children) {
        return this.buildNode(new SharedNode(name, children));
    }

    protected INode createAnnotatedNodeUnsafe(String name, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        return this.buildAnnotatedNode(new SharedAnnotatedNode(name, children, annotations));
    }

    @Override
    public IConstructor constructor(Type constructorType) {
        return this.buildConstructor(new SharedConstructor(constructorType, new IValue[0]));
    }

    @Override
    public IConstructor constructor(Type constructorType, IValue ... children) {
        Type instantiatedType;
        if (!constructorType.getAbstractDataType().isParameterized()) {
            instantiatedType = constructorType;
        } else {
            ShareableHashMap<Type, Type> bindings = new ShareableHashMap<Type, Type>();
            TypeFactory tf = TypeFactory.getInstance();
            constructorType.getFieldTypes().match(tf.tupleType(children), bindings);
            instantiatedType = constructorType.instantiate(new TypeStore(new TypeStore[0]), bindings);
        }
        return this.buildConstructor(new SharedConstructor(instantiatedType, (IValue[])children.clone()));
    }

    protected IConstructor createConstructorUnsafe(Type constructorType, IValue[] children) {
        return this.buildConstructor(new SharedConstructor(constructorType, children));
    }

    protected IConstructor createAnnotatedConstructorUnsafe(Type constructorType, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        return this.buildAnnotatedConstructor(new SharedAnnotatedConstructor(constructorType, children, annotations));
    }

    @Override
    public ITuple tuple() {
        return this.buildTuple(new SharedTuple(EMPTY_TUPLE_TYPE, new IValue[0]));
    }

    @Override
    public ITuple tuple(IValue ... args) {
        int nrOfArgs = args.length;
        Type[] elementTypes = new Type[nrOfArgs];
        for (int i = nrOfArgs - 1; i >= 0; --i) {
            elementTypes[i] = args[i].getType();
        }
        return this.buildTuple(new SharedTuple(tf.tupleType(elementTypes), (IValue[])args.clone()));
    }

    protected ITuple createTupleUnsafe(Type tupleType, IValue[] args) {
        return this.buildTuple(new SharedTuple(tupleType, args));
    }

    private static Type lub(IValue ... elements) {
        Type elementType = TypeFactory.getInstance().voidType();
        for (int i = elements.length - 1; i >= 0; --i) {
            elementType = elementType.lub(elements[i].getType());
        }
        return elementType;
    }

    private static class InstanceKeeper {
        public static final SharedValueFactory instance = new SharedValueFactory();

        private InstanceKeeper() {
        }
    }
}

