/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.BoolValue;
import org.eclipse.imp.pdb.facts.impl.RealValue;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerValue
extends Value
implements IInteger {
    private final BigInteger fValue;

    IntegerValue(int i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = BigInteger.valueOf(i);
    }

    IntegerValue(long i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = BigInteger.valueOf(i);
    }

    IntegerValue(BigInteger i) {
        super(TypeFactory.getInstance().integerType());
        this.fValue = i;
    }

    IntegerValue(byte[] a) {
        this(new BigInteger(a));
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() == o.getClass()) {
            return this.fValue.equals(((IntegerValue)o).fValue);
        }
        return false;
    }

    @Override
    public IInteger add(IInteger other) {
        return new IntegerValue(this.fValue.add(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger negate() {
        return new IntegerValue(this.fValue.negate());
    }

    @Override
    public IInteger subtract(IInteger other) {
        return new IntegerValue(this.fValue.subtract(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger multiply(IInteger other) {
        return new IntegerValue(this.fValue.multiply(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger divide(IInteger other) {
        return new IntegerValue(this.fValue.divide(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger remainder(IInteger other) {
        return new IntegerValue(this.fValue.remainder(((IntegerValue)other).fValue));
    }

    @Override
    public IInteger mod(IInteger other) {
        return new IntegerValue(this.fValue.mod(((IntegerValue)other).fValue));
    }

    @Override
    public IBool less(IInteger other) {
        return new BoolValue(this.compare(other) < 0);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return new BoolValue(this.compare(other) <= 0);
    }

    @Override
    public IBool greater(IInteger other) {
        return new BoolValue(this.compare(other) > 0);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return new BoolValue(this.compare(other) >= 0);
    }

    @Override
    public IReal toReal() {
        return new RealValue(new BigDecimal(this.fValue));
    }

    @Override
    public int compare(IInteger other) {
        return this.fValue.compareTo(((IntegerValue)other).fValue);
    }

    public int hashCode() {
        return this.fValue.hashCode();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitInteger(this);
    }

    @Override
    public String getStringRepresentation() {
        return this.fValue.toString();
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        return this.fValue.toByteArray();
    }

    @Override
    public int intValue() {
        return this.fValue.intValue();
    }

    @Override
    public long longValue() {
        return this.fValue.longValue();
    }

    @Override
    public int signum() {
        return this.fValue.signum();
    }

    @Override
    public IInteger abs() {
        return new IntegerValue(this.fValue.abs());
    }
}

