/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.impl.fast.RelationWriter;
import org.eclipse.imp.pdb.facts.impl.fast.Set;
import org.eclipse.imp.pdb.facts.impl.fast.Tuple;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashSet;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesList;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.util.RotatingQueue;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relation
extends Set
implements IRelation {
    protected Relation(Type tupleType, ShareableValuesHashSet data) {
        super(typeFactory.relTypeFromTuple(tupleType), tupleType, data);
    }

    @Override
    public Type getFieldTypes() {
        return this.elementType;
    }

    @Override
    public int arity() {
        return this.elementType.getArity();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitRelation(this);
    }

    @Override
    public ISet insert(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.add(value);
        Type type = this.getElementType().lub(value.getType());
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public IRelation delete(IValue value) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        newData.remove(value);
        return new RelationWriter(this.elementType, newData).done();
    }

    @Override
    public IRelation subtract(ISet set) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet(this.data);
        Iterator setIterator = set.iterator();
        while (setIterator.hasNext()) {
            newData.remove(setIterator.next());
        }
        return new RelationWriter(this.elementType, newData).done();
    }

    private ShareableValuesHashSet computeCarrier() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            Iterator tupleIterator = tuple.iterator();
            while (tupleIterator.hasNext()) {
                newData.add((IValue)tupleIterator.next());
            }
        }
        return newData;
    }

    @Override
    public ISet carrier() {
        ShareableValuesHashSet newData = this.computeCarrier();
        Type type = this.determainMostGenericTypeInTuple();
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public ISet domain() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.get(0));
        }
        Type type = this.elementType.getFieldType(0);
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public ISet range() {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        int last = this.elementType.getArity() - 1;
        for (ITuple tuple : this.data) {
            newData.add(tuple.get(last));
        }
        Type type = this.elementType.getFieldType(last);
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public IRelation compose(IRelation other) {
        Type otherTupleType = other.getFieldTypes();
        if (this.elementType == voidType) {
            return this;
        }
        if (otherTupleType == voidType) {
            return other;
        }
        if (this.elementType.getArity() != 2 || otherTupleType.getArity() != 2) {
            throw new IllegalOperationException("compose", this.elementType, otherTupleType);
        }
        if (!this.elementType.getFieldType(1).comparable(otherTupleType.getFieldType(0))) {
            throw new IllegalOperationException("compose", this.elementType, otherTupleType);
        }
        ShareableHashMap<IValue, ShareableValuesList> rightSides = new ShareableHashMap<IValue, ShareableValuesList>();
        for (ITuple tuple : other) {
            IValue key = tuple.get(0);
            ShareableValuesList values = (ShareableValuesList)rightSides.get(key);
            if (values == null) {
                values = new ShareableValuesList();
                rightSides.put(key, values);
            }
            values.append(tuple.get(1));
        }
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        Type[] newTupleFieldTypes = new Type[]{this.elementType.getFieldType(0), otherTupleType.getFieldType(1)};
        Type tupleType = typeFactory.tupleType(newTupleFieldTypes);
        for (ITuple thisTuple : this.data) {
            IValue key = thisTuple.get(1);
            ShareableValuesList values = (ShareableValuesList)rightSides.get(key);
            if (values == null) continue;
            Iterator valuesIterator = values.iterator();
            do {
                IValue value = (IValue)valuesIterator.next();
                IValue[] newTupleData = new IValue[]{thisTuple.get(0), value};
                newData.add(new Tuple(tupleType, newTupleData));
            } while (valuesIterator.hasNext());
        }
        return new RelationWriter(tupleType, newData).done();
    }

    private ShareableValuesHashSet computeClosure(Type tupleType) {
        ShareableValuesHashSet allData = new ShareableValuesHashSet(this.data);
        RotatingQueue<IValue> iLeftKeys = new RotatingQueue<IValue>();
        RotatingQueue iLefts = new RotatingQueue();
        ShareableHashMap interestingLeftSides = new ShareableHashMap();
        ShareableHashMap<IValue, ShareableValuesHashSet> potentialRightSides = new ShareableHashMap<IValue, ShareableValuesHashSet>();
        for (ITuple tuple : allData) {
            ShareableValuesHashSet rightValues;
            IValue key = tuple.get(0);
            IValue value = tuple.get(1);
            RotatingQueue<IValue> leftValues = (RotatingQueue<IValue>)interestingLeftSides.get(key);
            if (leftValues != null) {
                rightValues = (ShareableValuesHashSet)potentialRightSides.get(key);
            } else {
                leftValues = new RotatingQueue<IValue>();
                iLeftKeys.put(key);
                iLefts.put(leftValues);
                interestingLeftSides.put(key, leftValues);
                rightValues = new ShareableValuesHashSet();
                potentialRightSides.put(key, rightValues);
            }
            leftValues.put(value);
            rightValues.add(value);
        }
        interestingLeftSides = null;
        int size = potentialRightSides.size();
        int nextSize = 0;
        do {
            ShareableHashMap<IValue, ShareableValuesHashSet> rightSides = potentialRightSides;
            potentialRightSides = new ShareableHashMap();
            while (size > 0) {
                IValue rightKey;
                IValue leftKey = (IValue)iLeftKeys.get();
                RotatingQueue leftValues = (RotatingQueue)iLefts.get();
                RotatingQueue<IValue> interestingLeftValues = null;
                while ((rightKey = (IValue)leftValues.get()) != null) {
                    ShareableValuesHashSet rightValues = (ShareableValuesHashSet)rightSides.get(rightKey);
                    if (rightValues == null) continue;
                    for (IValue rightValue : rightValues) {
                        if (!allData.add(new Tuple(tupleType, new IValue[]{leftKey, rightValue}))) continue;
                        if (interestingLeftValues == null) {
                            ++nextSize;
                            iLeftKeys.put(leftKey);
                            interestingLeftValues = new RotatingQueue<IValue>();
                            iLefts.put(interestingLeftValues);
                        }
                        interestingLeftValues.put(rightValue);
                        ShareableValuesHashSet potentialRightValues = (ShareableValuesHashSet)potentialRightSides.get(rightKey);
                        if (potentialRightValues == null) {
                            potentialRightValues = new ShareableValuesHashSet();
                            potentialRightSides.put(rightKey, potentialRightValues);
                        }
                        potentialRightValues.add(rightValue);
                    }
                }
                --size;
            }
            size = nextSize;
            nextSize = 0;
        } while (size > 0);
        return allData;
    }

    @Override
    public IRelation closure() {
        if (this.elementType == voidType) {
            return this;
        }
        if (!this.isReflexive()) {
            throw new IllegalOperationException("closure", this.setType);
        }
        Type tupleElementType = this.elementType.getFieldType(0).lub(this.elementType.getFieldType(1));
        Type tupleType = typeFactory.tupleType(tupleElementType, tupleElementType);
        return new RelationWriter(this.elementType, this.computeClosure(tupleType)).done();
    }

    @Override
    public IRelation closureStar() {
        if (this.elementType == voidType) {
            return this;
        }
        if (!this.isReflexive()) {
            throw new IllegalOperationException("closureStar", this.setType);
        }
        Type tupleElementType = this.elementType.getFieldType(0).lub(this.elementType.getFieldType(1));
        Type tupleType = typeFactory.tupleType(tupleElementType, tupleElementType);
        ShareableValuesHashSet closure = this.computeClosure(tupleType);
        ShareableValuesHashSet carrier = this.computeCarrier();
        for (IValue element : carrier) {
            closure.add(new Tuple(tupleType, new IValue[]{element, element}));
        }
        return new RelationWriter(this.elementType, closure).done();
    }

    @Override
    public ISet select(int ... indexes) {
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.select(indexes));
        }
        Type type = this.getFieldTypes().select(indexes);
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public ISet select(String ... fields) {
        if (!this.elementType.hasFieldNames()) {
            throw new IllegalOperationException("select with field names", this.setType);
        }
        ShareableValuesHashSet newData = new ShareableValuesHashSet();
        for (ITuple tuple : this.data) {
            newData.add(tuple.select(fields));
        }
        Type type = this.getFieldTypes().select(fields);
        return Relation.createSetWriter(type, newData).done();
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Relation otherRelation = (Relation)o;
            if (this.setType != otherRelation.setType) {
                return false;
            }
            return this.data.equals(otherRelation.data);
        }
        return false;
    }

    private Type determainMostGenericTypeInTuple() {
        Type result = this.elementType.getFieldType(0);
        for (int i = this.elementType.getArity() - 1; i > 0; --i) {
            result = result.lub(this.elementType.getFieldType(i));
        }
        return result;
    }

    private boolean isReflexive() {
        if (this.elementType.getArity() != 2) {
            throw new RuntimeException("Tuple is not binary");
        }
        Type left = this.elementType.getFieldType(0);
        Type right = this.elementType.getFieldType(1);
        return right.comparable(left);
    }
}

