/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeDeclarationException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalFieldNameException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalFieldTypeException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalIdentifierException;
import org.eclipse.imp.pdb.facts.exceptions.NullTypeException;
import org.eclipse.imp.pdb.facts.type.AbstractDataType;
import org.eclipse.imp.pdb.facts.type.AliasType;
import org.eclipse.imp.pdb.facts.type.BoolType;
import org.eclipse.imp.pdb.facts.type.ConstructorType;
import org.eclipse.imp.pdb.facts.type.IntegerType;
import org.eclipse.imp.pdb.facts.type.ListType;
import org.eclipse.imp.pdb.facts.type.MapType;
import org.eclipse.imp.pdb.facts.type.NodeType;
import org.eclipse.imp.pdb.facts.type.ParameterType;
import org.eclipse.imp.pdb.facts.type.RealType;
import org.eclipse.imp.pdb.facts.type.RelationType;
import org.eclipse.imp.pdb.facts.type.SetType;
import org.eclipse.imp.pdb.facts.type.SourceLocationType;
import org.eclipse.imp.pdb.facts.type.StringType;
import org.eclipse.imp.pdb.facts.type.TupleType;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.type.ValueType;
import org.eclipse.imp.pdb.facts.type.VoidType;

public class TypeFactory {
    private final Map<Type, Type> fCache = new HashMap<Type, Type>();

    public static TypeFactory getInstance() {
        return InstanceHolder.sInstance;
    }

    private TypeFactory() {
    }

    private void checkNull(Object ... os) {
        for (int i = os.length - 1; i >= 0; --i) {
            if (os[i] != null) continue;
            throw new NullTypeException();
        }
    }

    public Type valueType() {
        return ValueType.getInstance();
    }

    public Type voidType() {
        return VoidType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getFromCache(Type t) {
        Map<Type, Type> map = this.fCache;
        synchronized (map) {
            Type result = this.fCache.get(t);
            if (result == null) {
                this.fCache.put(t, t);
                return t;
            }
            return result;
        }
    }

    public Type integerType() {
        return IntegerType.getInstance();
    }

    public Type realType() {
        return RealType.getInstance();
    }

    public Type boolType() {
        return BoolType.getInstance();
    }

    public Type externalType(Type externalType) {
        this.checkNull(externalType);
        return this.getFromCache(externalType);
    }

    public Type stringType() {
        return StringType.getInstance();
    }

    public Type sourceLocationType() {
        return SourceLocationType.getInstance();
    }

    private TupleType getOrCreateTuple(Type[] fieldTypes) {
        return (TupleType)this.getFromCache(new TupleType(fieldTypes));
    }

    public Type tupleEmpty() {
        return this.getFromCache(new TupleType(new Type[0]));
    }

    public Type tupleType(Type ... fieldTypes) {
        this.checkNull(fieldTypes);
        return this.getFromCache(new TupleType(fieldTypes));
    }

    public Type tupleType(Object ... fieldTypesAndLabels) throws FactTypeDeclarationException {
        int N = fieldTypesAndLabels.length;
        int arity = N / 2;
        Type[] protoFieldTypes = new Type[arity];
        String[] protoFieldNames = new String[arity];
        for (int i = 0; i < N; i += 2) {
            int pos = i / 2;
            if (fieldTypesAndLabels[i] == null || fieldTypesAndLabels[i + 1] == null) {
                throw new NullPointerException();
            }
            try {
                protoFieldTypes[pos] = (Type)fieldTypesAndLabels[i];
            }
            catch (ClassCastException e) {
                throw new IllegalFieldTypeException(pos, fieldTypesAndLabels[i], e);
            }
            try {
                String name = (String)fieldTypesAndLabels[i + 1];
                if (!this.isIdentifier(name)) {
                    throw new IllegalIdentifierException(name);
                }
                protoFieldNames[pos] = name;
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalFieldNameException(pos, fieldTypesAndLabels[i + 1], e);
            }
        }
        return this.getFromCache(new TupleType(protoFieldTypes, protoFieldNames));
    }

    public Type tupleType(Type[] types, String[] labels) {
        this.checkNull(types);
        this.checkNull(labels);
        return this.getFromCache(new TupleType(types, labels));
    }

    public Type tupleType(IValue ... elements) {
        this.checkNull(elements);
        int N = elements.length;
        Type[] fieldTypes = new Type[N];
        for (int i = N - 1; i >= 0; --i) {
            fieldTypes[i] = elements[i].getType();
        }
        return this.getOrCreateTuple(fieldTypes);
    }

    public Type setType(Type eltType) {
        this.checkNull(eltType);
        if (eltType.isTupleType()) {
            return this.relTypeFromTuple(eltType);
        }
        return this.getFromCache(new SetType(eltType));
    }

    public Type relTypeFromTuple(Type tupleType) {
        this.checkNull(tupleType);
        return this.getFromCache(new RelationType(tupleType));
    }

    public Type relType(Type ... fieldTypes) {
        this.checkNull(fieldTypes);
        return this.getFromCache(new RelationType(this.tupleType(fieldTypes)));
    }

    public Type relType(Object ... fieldTypesAndLabels) {
        return this.relTypeFromTuple(this.tupleType(fieldTypesAndLabels));
    }

    public Type aliasType(TypeStore store, String name, Type aliased, Type ... parameters) throws FactTypeDeclarationException {
        this.checkNull(store, name, aliased);
        this.checkNull(parameters);
        Type paramType = parameters.length == 0 ? this.voidType() : this.tupleType(parameters);
        return this.aliasTypeFromTuple(store, name, aliased, paramType);
    }

    public Type aliasTypeFromTuple(TypeStore store, String name, Type aliased, Type params) throws FactTypeDeclarationException {
        this.checkNull(store);
        this.checkNull(name);
        this.checkNull(aliased);
        this.checkNull(params);
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        if (aliased == null) {
            throw new NullTypeException();
        }
        Type result = this.getFromCache(new AliasType(name, aliased, params));
        store.declareAlias(result);
        return result;
    }

    public Type nodeType() {
        return NodeType.getInstance();
    }

    public Type abstractDataType(TypeStore store, String name, Type ... parameters) throws FactTypeDeclarationException {
        this.checkNull(store, name);
        this.checkNull(parameters);
        Type paramType = this.voidType();
        if (parameters.length != 0) {
            paramType = this.tupleType(parameters);
        }
        return this.abstractDataTypeFromTuple(store, name, paramType);
    }

    public Type abstractDataTypeFromTuple(TypeStore store, String name, Type params) throws FactTypeDeclarationException {
        this.checkNull(store, name, params);
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        Type result = this.getFromCache(new AbstractDataType(name, params));
        store.declareAbstractDataType(result);
        return result;
    }

    public Type constructorFromTuple(TypeStore store, Type adt, String name, Type tupleType) throws FactTypeDeclarationException {
        this.checkNull(store, adt, name, tupleType);
        if (!this.isIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        Type result = this.getFromCache(new ConstructorType(name, tupleType, adt));
        store.declareConstructor(result);
        return result;
    }

    public Type constructor(TypeStore store, Type adt, String name, Type ... children) throws FactTypeDeclarationException {
        return this.constructorFromTuple(store, adt, name, this.tupleType(children));
    }

    public Type constructor(TypeStore store, Type nodeType, String name, Object ... childrenAndLabels) throws FactTypeDeclarationException {
        return this.constructorFromTuple(store, nodeType, name, this.tupleType(childrenAndLabels));
    }

    public Type listType(Type elementType) {
        this.checkNull(elementType);
        return this.getFromCache(new ListType(elementType));
    }

    public Type mapType(Type key, Type value) {
        this.checkNull(key, value);
        return this.getFromCache(new MapType(key, value));
    }

    public Type mapTypeFromTuple(Type fields) {
        this.checkNull(fields);
        if (!fields.isTupleType()) {
            throw new UnsupportedOperationException("fields argument should be a tuple. not " + fields);
        }
        if (fields.getArity() < 2) {
            throw new IndexOutOfBoundsException();
        }
        if (fields.hasFieldNames()) {
            return this.mapType(fields.getFieldType(0), fields.getFieldName(0), fields.getFieldType(1), fields.getFieldName(1));
        }
        return this.mapType(fields.getFieldType(0), fields.getFieldType(1));
    }

    public Type mapType(Type key, String keyLabel, Type value, String valueLabel) {
        this.checkNull(key, keyLabel, value, valueLabel);
        return this.getFromCache(new MapType(key, keyLabel, value, valueLabel));
    }

    public Type parameterType(String name, Type bound) {
        this.checkNull(name, bound);
        return this.getFromCache(new ParameterType(name, bound));
    }

    public Type parameterType(String name) {
        this.checkNull(name);
        return this.getFromCache(new ParameterType(name));
    }

    public boolean isIdentifier(String str) {
        this.checkNull(str);
        int len = str.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = len - 1; i > 0; --i) {
            char c = str.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static class InstanceHolder {
        public static final TypeFactory sInstance = new TypeFactory();

        private InstanceHolder() {
        }
    }
}

