/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.facts.util.ShareableHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareableHashMap<K, V>
implements Map<K, V> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize;
    private int hashMask;
    private Entry<K, V>[] data;
    private int threshold;
    private int load;
    private int currentHashCode;

    public ShareableHashMap() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    public ShareableHashMap(ShareableHashMap<K, V> sharedHashMap) {
        this.modSize = sharedHashMap.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = (Entry[])sharedHashMap.data.clone();
        this.threshold = tableSize;
        this.load = sharedHashMap.load;
        this.currentHashCode = sharedHashMap.currentHashCode;
    }

    @Override
    public void clear() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<K, V>[] oldData = this.data;
        for (int i = oldData.length - 1; i >= 0; --i) {
            Entry<K, V> entry = oldData[i];
            if (entry == null) continue;
            Entry<K, V> lastUnchangedEntryChain = entry;
            int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
            Entry e = entry.next;
            while (e != null) {
                int newIndex = e.hash & this.hashMask;
                if (newIndex != newLastUnchangedEntryChainIndex) {
                    lastUnchangedEntryChain = e;
                    newLastUnchangedEntryChainIndex = newIndex;
                }
                e = e.next;
            }
            newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
            while (entry != lastUnchangedEntryChain) {
                int hash = entry.hash;
                int position = hash & this.hashMask;
                newData[position] = new Entry(hash, entry.key, entry.value, newData[position]);
                entry = entry.next;
            }
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    private void replaceValue(int position, Entry<K, V> entry, V newValue) {
        Entry<K, V> e = this.data[position];
        this.data[position] = new Entry(entry.hash, entry.key, newValue, entry.next);
        while (e != entry) {
            this.data[position] = new Entry(e.hash, e.key, e.value, this.data[position]);
            e = e.next;
        }
    }

    @Override
    public V put(K key, V value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<K, V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.equals(key)) continue;
                this.replaceValue(position, entry, value);
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        this.data[position] = new Entry<K, V>(hash, key, value, currentStartEntry);
        ++this.load;
        this.currentHashCode ^= hash;
        return null;
    }

    @Override
    public V remove(Object key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<K, V> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.equals(key)) continue;
                Entry<K, V> e = this.data[position];
                this.data[position] = entry.next;
                while (e != entry) {
                    this.data[position] = new Entry(e.hash, e.key, e.value, this.data[position]);
                    e = e.next;
                }
                --this.load;
                this.currentHashCode ^= hash;
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    @Override
    public V get(Object key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public int size() {
        return this.load;
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator(this);
    }

    public Iterator<K> keysIterator() {
        return new KeysIterator(this);
    }

    public Iterator<V> valuesIterator() {
        return new ValuesIterator(this);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        Set<Map.Entry<K, V>> entrySet = otherMap.entrySet();
        for (Map.Entry<K, V> next : entrySet) {
            this.put(next.getKey(), next.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<V> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            V nextValue = valuesIterator.next();
            if (nextValue != value && (nextValue == null || !nextValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ShareableHashSet<Map.Entry<K, Map.Entry<K, V>>> entrySet = new ShareableHashSet<Map.Entry<K, Map.Entry<K, V>>>();
        Iterator<Map.Entry<K, V>> entriesIterator = this.entryIterator();
        while (entriesIterator.hasNext()) {
            entrySet.add(entriesIterator.next());
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet() {
        ShareableHashSet<K> keysSet = new ShareableHashSet<K>();
        Iterator<K> keysIterator = this.keysIterator();
        while (keysIterator.hasNext()) {
            keysSet.add(keysIterator.next());
        }
        return keysSet;
    }

    @Override
    public Collection<V> values() {
        ShareableHashSet<V> valuesSet = new ShareableHashSet<V>();
        Iterator<V> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            valuesSet.add(valuesIterator.next());
        }
        return valuesSet;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append('[');
            Entry<K, V> e = this.data[i];
            if (e != null) {
                buffer.append(e);
                e = e.next;
                while (e != null) {
                    buffer.append(',');
                    buffer.append(e);
                    e = e.next;
                }
            }
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.currentHashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ShareableHashMap other = (ShareableHashMap)o;
            if (other.currentHashCode != this.currentHashCode) {
                return false;
            }
            if (other.size() != this.size()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            Iterator<Map.Entry<K, V>> otherIterator = other.entryIterator();
            while (otherIterator.hasNext()) {
                V thisValue;
                Map.Entry<K, V> entry = otherIterator.next();
                V otherValue = entry.getValue();
                if (otherValue == (thisValue = this.get(entry.getKey())) || thisValue == null || thisValue.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuesIterator<K, V>
    implements Iterator<V> {
        private final EntryIterator<K, V> entryIterator;

        public ValuesIterator(ShareableHashMap<K, V> sharedHashMap) {
            this.entryIterator = new EntryIterator<K, V>(sharedHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            return ((Entry)this.entryIterator.next()).value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeysIterator<K, V>
    implements Iterator<K> {
        private final EntryIterator<K, V> entryIterator;

        public KeysIterator(ShareableHashMap<K, V> sharedHashMap) {
            this.entryIterator = new EntryIterator<K, V>(sharedHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public K next() {
            return ((Entry)this.entryIterator.next()).key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Entry<K, V>[] data;
        private Entry<K, V> current;
        private int index;

        public EntryIterator(ShareableHashMap<K, V> sharedHashMap) {
            this.data = ((ShareableHashMap)sharedHashMap).data;
            this.index = this.data.length - 1;
            this.current = new Entry<Object, Object>(0, null, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<K, V> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<K, V> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        public final int hash;
        public final K key;
        public final V value;
        public final Entry<K, V> next;

        public Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("The setting of values is not supported by this map implementation.");
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.key);
            buffer.append(':');
            buffer.append(this.value);
            buffer.append('>');
            return buffer.toString();
        }
    }
}

