/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.util.ShareableHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShareableValuesHashMap
implements Map<IValue, IValue> {
    private static final int INITIAL_LOG_SIZE = 4;
    private int modSize;
    private int hashMask;
    private Entry<IValue, IValue>[] data;
    private int threshold;
    private int load;
    private int currentHashCode;

    public ShareableValuesHashMap() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    public ShareableValuesHashMap(ShareableValuesHashMap shareableValuesHashMap) {
        this.modSize = shareableValuesHashMap.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = (Entry[])shareableValuesHashMap.data.clone();
        this.threshold = tableSize;
        this.load = shareableValuesHashMap.load;
        this.currentHashCode = shareableValuesHashMap.currentHashCode;
    }

    @Override
    public void clear() {
        this.modSize = 4;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
        this.currentHashCode = 0;
    }

    private void rehash() {
        ++this.modSize;
        int tableSize = 1 << this.modSize;
        this.hashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        this.threshold = tableSize;
        Entry<IValue, IValue>[] oldData = this.data;
        for (int i = oldData.length - 1; i >= 0; --i) {
            Entry<IValue, IValue> entry = oldData[i];
            if (entry == null) continue;
            Entry<IValue, IValue> lastUnchangedEntryChain = entry;
            int newLastUnchangedEntryChainIndex = entry.hash & this.hashMask;
            Entry e = entry.next;
            while (e != null) {
                int newIndex = e.hash & this.hashMask;
                if (newIndex != newLastUnchangedEntryChainIndex) {
                    lastUnchangedEntryChain = e;
                    newLastUnchangedEntryChainIndex = newIndex;
                }
                e = e.next;
            }
            newData[newLastUnchangedEntryChainIndex] = lastUnchangedEntryChain;
            while (entry != lastUnchangedEntryChain) {
                int hash = entry.hash;
                int position = hash & this.hashMask;
                newData[position] = new Entry(hash, entry.key, entry.value, newData[position]);
                entry = entry.next;
            }
        }
        this.data = newData;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    private void replaceValue(int position, Entry<IValue, IValue> entry, IValue newValue) {
        Entry<IValue, IValue> e = this.data[position];
        this.data[position] = new Entry(entry.hash, entry.key, newValue, entry.next);
        while (e != entry) {
            this.data[position] = new Entry<IValue, IValue>(e.hash, (IValue)e.key, (IValue)e.value, this.data[position]);
            e = e.next;
        }
    }

    @Override
    public IValue put(IValue key, IValue value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue, IValue> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<IValue, IValue> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !((IValue)entry.key).isEqual(key)) continue;
                this.replaceValue(position, entry, value);
                return (IValue)entry.value;
            } while ((entry = entry.next) != null);
        }
        this.data[position] = new Entry<IValue, IValue>(hash, key, value, currentStartEntry);
        ++this.load;
        this.currentHashCode ^= hash;
        return null;
    }

    @Override
    public IValue remove(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue, IValue> currentStartEntry = this.data[position];
        if (currentStartEntry != null) {
            Entry<IValue, IValue> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !((IValue)entry.key).isEqual(key)) continue;
                Entry<IValue, IValue> e = this.data[position];
                this.data[position] = entry.next;
                while (e != entry) {
                    this.data[position] = new Entry<IValue, IValue>(e.hash, (IValue)e.key, (IValue)e.value, this.data[position]);
                    e = e.next;
                }
                --this.load;
                this.currentHashCode ^= hash;
                return (IValue)entry.value;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    @Override
    public IValue get(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue, IValue> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.isEqual((IValue)entry.key)) {
                return (IValue)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean contains(IValue key) {
        return this.get(key) != null;
    }

    @Override
    public int size() {
        return this.load;
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    public Iterator<Map.Entry<IValue, IValue>> entryIterator() {
        return new EntryIterator(this);
    }

    public Iterator<IValue> keysIterator() {
        return new KeysIterator(this);
    }

    public Iterator<IValue> valuesIterator() {
        return new ValuesIterator(this);
    }

    @Override
    public void putAll(Map<? extends IValue, ? extends IValue> otherMap) {
        Set<Map.Entry<? extends IValue, ? extends IValue>> entrySet = otherMap.entrySet();
        for (Map.Entry<? extends IValue, ? extends IValue> next : entrySet) {
            this.put(next.getKey(), next.getValue());
        }
    }

    @Override
    public boolean containsKey(Object object) {
        IValue key = (IValue)object;
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue, IValue> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && key.isEqual((IValue)entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        IValue value = (IValue)object;
        Iterator<IValue> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            IValue nextValue = valuesIterator.next();
            if (nextValue != value && (nextValue == null || !nextValue.isEqual(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<IValue, IValue>> entrySet() {
        ShareableHashSet<Map.Entry<IValue, IValue>> entrySet = new ShareableHashSet<Map.Entry<IValue, IValue>>();
        Iterator<Map.Entry<IValue, IValue>> entriesIterator = this.entryIterator();
        while (entriesIterator.hasNext()) {
            entrySet.add(entriesIterator.next());
        }
        return entrySet;
    }

    @Override
    public Set<IValue> keySet() {
        ShareableHashSet<IValue> keysSet = new ShareableHashSet<IValue>();
        Iterator<IValue> keysIterator = this.keysIterator();
        while (keysIterator.hasNext()) {
            keysSet.add(keysIterator.next());
        }
        return keysSet;
    }

    @Override
    public Collection<IValue> values() {
        ShareableHashSet<IValue> valuesSet = new ShareableHashSet<IValue>();
        Iterator<IValue> valuesIterator = this.valuesIterator();
        while (valuesIterator.hasNext()) {
            valuesSet.add(valuesIterator.next());
        }
        return valuesSet;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < this.data.length; ++i) {
            buffer.append('[');
            Entry<IValue, IValue> e = this.data[i];
            if (e != null) {
                buffer.append(e);
                e = e.next;
                while (e != null) {
                    buffer.append(',');
                    buffer.append(e);
                    e = e.next;
                }
            }
            buffer.append(']');
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        return this.currentHashCode;
    }

    public boolean isEqual(ShareableValuesHashMap other) {
        if (other == null) {
            return false;
        }
        if (other.currentHashCode != this.currentHashCode) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<IValue, IValue>> otherIterator = other.entryIterator();
        while (otherIterator.hasNext()) {
            IValue thisValue;
            Map.Entry<IValue, IValue> entry = otherIterator.next();
            IValue otherValue = entry.getValue();
            if (otherValue == (thisValue = this.get(entry.getKey())) || thisValue == null || thisValue.isEqual(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private IValue getTruelyEqual(IValue key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<IValue, IValue> entry = this.data[position];
        while (entry != null) {
            if (hash == entry.hash && ((Object)key).equals(entry.key)) {
                return (IValue)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            ShareableValuesHashMap other = (ShareableValuesHashMap)o;
            if (other.currentHashCode != this.currentHashCode) {
                return false;
            }
            if (other.size() != this.size()) {
                return false;
            }
            if (this.isEmpty()) {
                return true;
            }
            Iterator<Map.Entry<IValue, IValue>> otherIterator = other.entryIterator();
            while (otherIterator.hasNext()) {
                IValue thisValue;
                Map.Entry<IValue, IValue> entry = otherIterator.next();
                IValue otherValue = entry.getValue();
                if (otherValue == (thisValue = this.getTruelyEqual(entry.getKey())) || thisValue != null && ((Object)thisValue).equals(otherValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuesIterator
    implements Iterator<IValue> {
        private final EntryIterator entryIterator;

        public ValuesIterator(ShareableValuesHashMap shareableValuesHashMap) {
            this.entryIterator = new EntryIterator(shareableValuesHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public IValue next() {
            return (IValue)((Entry)this.entryIterator.next()).value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeysIterator
    implements Iterator<IValue> {
        private final EntryIterator entryIterator;

        public KeysIterator(ShareableValuesHashMap shareableValuesHashMap) {
            this.entryIterator = new EntryIterator(shareableValuesHashMap);
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public IValue next() {
            return (IValue)((Entry)this.entryIterator.next()).key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator
    implements Iterator<Map.Entry<IValue, IValue>> {
        private final Entry<IValue, IValue>[] data;
        private Entry<IValue, IValue> current;
        private int index;

        public EntryIterator(ShareableValuesHashMap shareableValuesHashMap) {
            this.data = shareableValuesHashMap.data;
            this.index = this.data.length - 1;
            this.current = new Entry<IValue, IValue>(0, null, null, this.data[this.index]);
            this.locateNext();
        }

        private void locateNext() {
            Entry next = this.current.next;
            if (next != null) {
                this.current = next;
                return;
            }
            for (int i = this.index - 1; i >= 0; --i) {
                Entry<IValue, IValue> entry = this.data[i];
                if (entry == null) continue;
                this.current = entry;
                this.index = i;
                return;
            }
            this.current = null;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Entry<IValue, IValue> next() {
            if (!this.hasNext()) {
                throw new UnsupportedOperationException("There are no more elements in this iterator.");
            }
            Entry<IValue, IValue> entry = this.current;
            this.locateNext();
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        public final int hash;
        public final K key;
        public final V value;
        public final Entry<K, V> next;

        public Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("The setting of values is not supported by this map implementation.");
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.key);
            buffer.append(':');
            buffer.append(this.value);
            buffer.append('>');
            return buffer.toString();
        }
    }
}

