/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.util.sharing;

import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedCache<T> {
    private final AtomicReferenceArray<T> atomicCacheArray;
    private final int size;

    public IndexedCache(int size) {
        this.atomicCacheArray = new AtomicReferenceArray(size);
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public T getOrDefine(int index, T prototype) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index may not be larger then size.");
        }
        if (this.atomicCacheArray.compareAndSet(index, null, prototype)) {
            return prototype;
        }
        return this.atomicCacheArray.get(index);
    }

    public T get(int index) {
        return this.atomicCacheArray.get(index);
    }
}

