/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Constructor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedConstructor
extends Constructor {
    protected final ShareableHashMap<String, IValue> annotations;

    protected AnnotatedConstructor(Type constructorType, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        super(constructorType, children);
        this.annotations = annotations;
    }

    @Override
    public IConstructor set(int i, IValue arg) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = arg;
        return new AnnotatedConstructor(this.constructorType, newChildren, this.annotations);
    }

    @Override
    public boolean hasAnnotation(String label) {
        return this.annotations.containsKey(label);
    }

    @Override
    public boolean hasAnnotations() {
        return true;
    }

    @Override
    public IValue getAnnotation(String label) {
        return this.annotations.get(label);
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return new ShareableHashMap<String, IValue>(this.annotations);
    }

    @Override
    public IConstructor removeAnnotations() {
        return new Constructor(this.constructorType, this.children);
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.put(label, value);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.remove(label);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            AnnotatedConstructor other = (AnnotatedConstructor)o;
            if (this.constructorType != other.constructorType) {
                return false;
            }
            IValue[] otherChildren = other.children;
            int nrOfChildren = this.children.length;
            if (otherChildren.length == nrOfChildren) {
                for (int i = nrOfChildren - 1; i >= 0; --i) {
                    if (((Object)otherChildren[i]).equals(this.children[i])) continue;
                    return false;
                }
                return this.annotations.equals(other.annotations);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        int size = this.children.length;
        if (size > 0) {
            int i = 0;
            sb.append(this.children[i]);
            for (i = 1; i < size; ++i) {
                sb.append(",");
                sb.append(this.children[i]);
            }
        }
        sb.append(")");
        sb.append('[');
        Map<String, IValue> annotations = this.getAnnotations();
        Iterator<Map.Entry<String, IValue>> annotationsIterator = annotations.entrySet().iterator();
        Map.Entry<String, IValue> entry = annotationsIterator.next();
        sb.append("@" + entry.getKey() + "=");
        sb.append(((Object)entry.getValue()).toString());
        while (annotationsIterator.hasNext()) {
            sb.append(",");
            entry = annotationsIterator.next();
            sb.append("@" + entry.getKey() + "=");
            sb.append(((Object)entry.getValue()).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

