/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.io.StandardTextWriter;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceLocationValue
implements ISourceLocation {
    private static final Type SOURCE_LOCATION_TYPE = TypeFactory.getInstance().sourceLocationType();
    protected final URI uri;
    protected final int offset;
    protected final int length;
    protected final int beginLine;
    protected final int endLine;
    protected final int beginCol;
    protected final int endCol;

    protected SourceLocationValue(URI uri, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        this.uri = uri;
        this.offset = offset;
        this.length = length;
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginCol = beginCol;
        this.endCol = endCol;
    }

    @Override
    public Type getType() {
        return SOURCE_LOCATION_TYPE;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginCol;
    }

    @Override
    public int getEndColumn() {
        return this.endCol;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitSourceLocation(this);
    }

    public int hashCode() {
        int hash = this.uri.hashCode();
        hash ^= this.beginLine << 3;
        hash ^= this.endLine << 23;
        hash ^= this.beginCol << 13;
        hash ^= this.endCol << 18;
        hash ^= this.offset << 8;
        return hash ^= this.length << 29;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            SourceLocationValue otherSourceLocation = (SourceLocationValue)o;
            return this.uri.equals(otherSourceLocation.uri) && this.beginLine == otherSourceLocation.beginLine && this.endLine == otherSourceLocation.endLine && this.beginCol == otherSourceLocation.beginCol && this.endCol == otherSourceLocation.endCol && this.offset == otherSourceLocation.offset && this.length == otherSourceLocation.length;
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        return this.equals(value);
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            new StandardTextWriter().write(this, stream);
            return stream.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

