/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListType
extends Type {
    private final Type fEltType;

    ListType(Type eltType) {
        this.fEltType = eltType;
    }

    @Override
    public Type getElementType() {
        return this.fEltType;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other.isListType()) {
            return this.fEltType.isSubtypeOf(other.getElementType());
        }
        return super.isSubtypeOf(other);
    }

    @Override
    public Type lub(Type o) {
        if (o.isListType()) {
            return TypeFactory.getInstance().listType(this.fEltType.lub(o.getElementType()));
        }
        return super.lub(o);
    }

    @Override
    public Type carrier() {
        return TypeFactory.getInstance().setType(this.fEltType);
    }

    public String toString() {
        return "list[" + this.fEltType + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof ListType) {
            ListType other = (ListType)o;
            return this.fEltType == other.fEltType;
        }
        return false;
    }

    public int hashCode() {
        return 75703 + 104543 * this.fEltType.hashCode();
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitList(this);
    }

    @Override
    public IValue make(IValueFactory f) {
        return f.list(this.fEltType);
    }

    @Override
    public IValue make(IValueFactory f, IValue ... elems) {
        return f.list(elems);
    }

    public IListWriter writer(IValueFactory f) {
        return f.listWriter(this.fEltType);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        this.getElementType().match(matched.getElementType(), bindings);
    }

    @Override
    public Type instantiate(TypeStore store, Map<Type, Type> bindings) {
        return TypeFactory.getInstance().listType(this.getElementType().instantiate(store, bindings));
    }
}

