/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.impl.BoolValue;
import org.eclipse.imp.pdb.facts.impl.DateTimeValue;
import org.eclipse.imp.pdb.facts.impl.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.RealValue;
import org.eclipse.imp.pdb.facts.impl.SourceLocationValue;
import org.eclipse.imp.pdb.facts.impl.StringValue;

public abstract class BaseValueFactory
implements IValueFactory {
    public IInteger integer(int i) {
        return new IntegerValue(i);
    }

    public IInteger integer(long l) {
        return new IntegerValue(l);
    }

    public IInteger integer(byte[] a) {
        return new IntegerValue(a);
    }

    public IInteger integer(String s) {
        return new IntegerValue(new BigInteger(s));
    }

    public IReal real(double d) {
        return new RealValue(d);
    }

    public IReal real(float f) {
        return new RealValue(f);
    }

    public IReal real(String s) {
        return new RealValue(new BigDecimal(s));
    }

    public IString string(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return new StringValue(s);
    }

    public ISourceLocation sourceLocation(URI path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (startOffset < 0 || length < 0 || startLine < 0 || endLine < startLine || endCol < 0 || startLine == endLine && endCol < startCol) {
            throw new IllegalArgumentException();
        }
        return new SourceLocationValue(path, startOffset, length, startLine, endLine, startCol, endCol);
    }

    public ISourceLocation sourceLocation(String path, int startOffset, int length, int startLine, int endLine, int startCol, int endCol) {
        try {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return this.sourceLocation(new URI("file://" + path), startOffset, length, startLine, endLine, startCol, endCol);
        }
        catch (URISyntaxException e) {
            throw new FactParseError("illegal path syntax", e);
        }
    }

    public ISourceLocation sourceLocation(URI url) {
        return this.sourceLocation(url, -1, -1, -1, -1, -1, -1);
    }

    public ISourceLocation sourceLocation(String path) {
        return this.sourceLocation(path, -1, -1, -1, -1, -1, -1);
    }

    public IBool bool(boolean value) {
        return new BoolValue(value);
    }

    public IDateTime date(int year, int month, int day) {
        return new DateTimeValue(year, month, day);
    }

    public IDateTime time(int hour, int minute, int second, int millisecond) {
        return new DateTimeValue(hour, minute, second, millisecond);
    }

    public IDateTime time(int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return new DateTimeValue(hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    public IDateTime datetime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond);
    }

    public IDateTime datetime(int year, int month, int day, int hour, int minute, int second, int millisecond, int hourOffset, int minuteOffset) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond, hourOffset, minuteOffset);
    }

    public IDateTime datetime(long instant) {
        return new DateTimeValue(instant);
    }
}

