/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.MapWriter;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashMap;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map
extends Value
implements IMap {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    protected final Type mapType;
    protected final Type keyType;
    protected final Type valueType;
    protected final ShareableValuesHashMap data;

    protected Map(Type keyType, Type valueType, ShareableValuesHashMap data) {
        this.mapType = typeFactory.mapType(keyType, valueType);
        this.keyType = keyType;
        this.valueType = valueType;
        this.data = data;
    }

    @Override
    public Type getType() {
        return this.mapType;
    }

    @Override
    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public int arity() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public IValue get(IValue key) {
        return this.data.get(key);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.data.keysIterator();
    }

    @Override
    public Iterator<Map.Entry<IValue, IValue>> entryIterator() {
        return this.data.entryIterator();
    }

    @Override
    public Iterator<IValue> valueIterator() {
        return this.data.valuesIterator();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitMap(this);
    }

    @Override
    public boolean containsKey(IValue key) {
        return this.data.contains(key);
    }

    @Override
    public boolean containsValue(IValue value) {
        Iterator<IValue> valuesIterator = this.data.valuesIterator();
        while (valuesIterator.hasNext()) {
            if (!valuesIterator.next().isEqual(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubMap(IMap other) {
        Map otherMap = (Map)other;
        Iterator<IValue> keysIterator = this.iterator();
        while (keysIterator.hasNext()) {
            if (otherMap.data.contains(keysIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public IMap put(IValue key, IValue value) {
        ShareableValuesHashMap newData = new ShareableValuesHashMap(this.data);
        newData.put(key, value);
        Type newKeyType = this.keyType.lub(key.getType());
        Type newValueType = this.valueType.lub(value.getType());
        return new MapWriter(newKeyType, newValueType, newData).done();
    }

    @Override
    public IMap common(IMap other) {
        IMap theOtherMap;
        Iterator<Map.Entry<IValue, IValue>> entryIterator;
        ShareableValuesHashMap commonData = new ShareableValuesHashMap();
        if (other.size() <= this.size()) {
            entryIterator = other.entryIterator();
            theOtherMap = this;
        } else {
            entryIterator = this.entryIterator();
            theOtherMap = other;
        }
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            IValue key = entry.getKey();
            IValue value = entry.getValue();
            if (!value.isEqual(theOtherMap.get(key))) continue;
            commonData.put(key, value);
        }
        Type newKeyType = this.keyType.lub(other.getKeyType());
        Type newValueType = this.valueType.lub(other.getValueType());
        return new MapWriter(newKeyType, newValueType, commonData).done();
    }

    @Override
    public IMap compose(IMap other) {
        ShareableValuesHashMap newData = new ShareableValuesHashMap();
        Map otherMap = (Map)other;
        Iterator<Map.Entry<IValue, IValue>> entryIterator = this.entryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            IValue value = otherMap.get(entry.getValue());
            if (value == null) continue;
            newData.put(entry.getKey(), value);
        }
        return new MapWriter(this.keyType, otherMap.valueType, newData).done();
    }

    @Override
    public IMap join(IMap other) {
        Iterator<Map.Entry<IValue, IValue>> entryIterator;
        ShareableValuesHashMap newData;
        Map otherMap = (Map)other;
        if (otherMap.size() <= this.size()) {
            newData = new ShareableValuesHashMap(this.data);
            entryIterator = otherMap.entryIterator();
        } else {
            newData = new ShareableValuesHashMap(otherMap.data);
            entryIterator = this.entryIterator();
        }
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            newData.put(entry.getKey(), entry.getValue());
        }
        Type newKeyType = this.keyType.lub(otherMap.keyType);
        Type newValueType = this.valueType.lub(otherMap.valueType);
        return new MapWriter(newKeyType, newValueType, newData).done();
    }

    @Override
    public IMap remove(IMap other) {
        ShareableValuesHashMap newData = new ShareableValuesHashMap(this.data);
        Iterator<IValue> keysIterator = other.iterator();
        while (keysIterator.hasNext()) {
            newData.remove(keysIterator.next());
        }
        return new MapWriter(this.keyType, this.valueType, newData).done();
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Map otherMap = (Map)o;
            if (this.mapType != otherMap.mapType) {
                return false;
            }
            return this.data.equals(otherMap.data);
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Map) {
            Map otherMap = (Map)value;
            if (!this.keyType.comparable(otherMap.keyType) || !this.valueType.comparable(otherMap.valueType)) {
                return false;
            }
            return this.data.isEqual(otherMap.data);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Iterator<Map.Entry<IValue, IValue>> mapIterator = this.data.entryIterator();
        if (mapIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = mapIterator.next();
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            while (mapIterator.hasNext()) {
                sb.append(",");
                entry = mapIterator.next();
                sb.append(entry.getKey());
                sb.append(":");
                sb.append(entry.getValue());
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

