/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.shared;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.impl.ICanBecomeABigInteger;
import org.eclipse.imp.pdb.facts.impl.fast.BigIntegerValue;
import org.eclipse.imp.pdb.facts.impl.fast.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.shared.SharedValueFactory;
import org.eclipse.imp.pdb.facts.impl.util.sharing.IShareable;

public class SharedBigIntegerValue
extends BigIntegerValue
implements IShareable {
    public SharedBigIntegerValue(BigInteger bigInteger) {
        super(bigInteger);
    }

    public IReal toReal() {
        return SharedValueFactory.getInstance().real(new BigDecimal(this.value));
    }

    public IInteger add(IInteger other) {
        BigInteger result = this.value.add(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 31) {
            return SharedValueFactory.getInstance().integer(result.intValue());
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger subtract(IInteger other) {
        BigInteger result = this.value.subtract(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 31) {
            return SharedValueFactory.getInstance().integer(result.intValue());
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger multiply(IInteger other) {
        BigInteger result = this.value.multiply(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger divide(IInteger other) {
        BigInteger result = this.value.divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        int length = result.bitLength();
        if (length <= 31) {
            return SharedValueFactory.getInstance().integer(result.intValue());
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger mod(IInteger other) {
        BigInteger result = this.value.mod(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return SharedValueFactory.getInstance().integer(integerResult);
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger remainder(IInteger other) {
        BigInteger result = this.value.remainder(((ICanBecomeABigInteger)((Object)other)).toBigInteger());
        if (other instanceof IntegerValue) {
            int integerResult = result.intValue();
            return SharedValueFactory.getInstance().integer(integerResult);
        }
        return SharedValueFactory.getInstance().integer(result);
    }

    public IInteger negate() {
        return SharedValueFactory.getInstance().integer(this.value.negate());
    }

    public IBool greater(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    public IBool greaterEqual(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    public IBool less(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    public IBool lessEqual(IInteger other) {
        return SharedValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    public boolean equivalent(IShareable shareable) {
        return super.equals(shareable);
    }

    public boolean equals(Object o) {
        return this == o;
    }
}

